open Swig
type c_enum_type = [ 
  `unknown
| `Weekday
| `Month
| `TimeUnit
| `Frequency
| `Month
| `Type
| `Convention
| `Convention
| `Compounding
| `BusinessDayConvention
| `JointCalendarRule
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Market
| `Type
| `Type
| `Type
| `Type
| `Type
| `Rule
| `YieldCurveModel
| `Type
| `Type
| `Side
| `ConversionType
| `Type
| `Type
]
type c_enum_value = [ 
  `Int of int
| `Sunday
| `Monday
| `Tuesday
| `Wednesday
| `Thursday
| `Friday
| `Saturday
| `January
| `February
| `March
| `April
| `May
| `June
| `July
| `August
| `September
| `October
| `November
| `December
| `Days
| `Weeks
| `Months
| `Years
| `NoFrequency
| `Once
| `Annual
| `Semiannual
| `EveryFourthMonth
| `Quarterly
| `Bimonthly
| `Monthly
| `EveryFourthWeek
| `Biweekly
| `Weekly
| `Daily
| `OtherFrequency
| `F
| `G
| `H
| `J
| `K
| `M
| `N
| `Q
| `U
| `V
| `X
| `Z
| `None
| `Spectral
| `USA
| `BondBasis
| `European
| `EurobondBasis
| `Italian
| `ISMA
| `Bond
| `ISDA
| `Historical
| `Actual365
| `AFB
| `Euro
| `Simple
| `Compounded
| `Continuous
| `SimpleThenCompounded
| `Following
| `ModifiedFollowing
| `Preceding
| `ModifiedPreceding
| `Unadjusted
| `JoinHolidays
| `JoinBusinessDays
| `Merval
| `Settlement
| `Exchange
| `TSX
| `PSE
| `FrankfurtStockExchange
| `Xetra
| `Eurex
| `HKEx
| `ICEX
| `NSE
| `BEJ
| `JSX
| `BMV
| `Tadawul
| `SGX
| `BSSE
| `KRX
| `TSEC
| `USE
| `Metals
| `NYSE
| `GovernmentBond
| `NERC
| `Open
| `Close
| `High
| `Low
| `MaxIterations
| `StationaryPoint
| `StationaryFunctionValue
| `StationaryFunctionAccuracy
| `ZeroGradientNorm
| `Unknown
| `Put
| `Call
| `DownIn
| `UpIn
| `DownOut
| `UpOut
| `Arithmetic
| `Geometric
| `Backward
| `Forward
| `Zero
| `ThirdWednesday
| `Twentieth
| `TwentiethIMM
| `OldCDS
| `Standard
| `ExactYield
| `ParallelShifts
| `NonParallelShifts
| `Macaulay
| `Modified
| `Dirty
| `Clean
| `Buyer
| `Seller
| `NoConversion
| `BaseCurrencyConversion
| `AutomatedConversion
| `Direct
| `Derived
| `Physical
| `Cash
]

type c_obj = c_enum_value c_obj_t
let module_name = "QuantLib"

exception BadArgs of string
exception BadMethodName of c_obj * string * string
exception NotObject of c_obj
exception NotEnumType of c_obj
exception LabelNotFromThisEnum of c_obj
exception InvalidDirectorCall of c_obj


  
  let array_to_vector v argcons array = 
    for i = 0 to (Array.length array) - 1 do
	(invoke v) "set" (C_list [ C_int i ; (argcons array.(i)) ])
    done ;
    v
    
  let vector_to_array v argcons array =
    for i = 0; to (get_int ((invoke v) "size" C_void)) - 1 do
	array.(i) <- argcons ((invoke v) "[]" (C_int i))
    done ; 
    v
      

let _ = Callback.register "Weekday_marker" (`Weekday)
external _Sunday : c_obj -> Swig.c_obj = "_wrap_Sunday" 
external _Monday : c_obj -> Swig.c_obj = "_wrap_Monday" 
external _Tuesday : c_obj -> Swig.c_obj = "_wrap_Tuesday" 
external _Wednesday : c_obj -> Swig.c_obj = "_wrap_Wednesday" 
external _Thursday : c_obj -> Swig.c_obj = "_wrap_Thursday" 
external _Friday : c_obj -> Swig.c_obj = "_wrap_Friday" 
external _Saturday : c_obj -> Swig.c_obj = "_wrap_Saturday" 
let _ = Callback.register "Month_marker" (`Month)
external _January : c_obj -> Swig.c_obj = "_wrap_January" 
external _February : c_obj -> Swig.c_obj = "_wrap_February" 
external _March : c_obj -> Swig.c_obj = "_wrap_March" 
external _April : c_obj -> Swig.c_obj = "_wrap_April" 
external _May : c_obj -> Swig.c_obj = "_wrap_May" 
external _June : c_obj -> Swig.c_obj = "_wrap_June" 
external _July : c_obj -> Swig.c_obj = "_wrap_July" 
external _August : c_obj -> Swig.c_obj = "_wrap_August" 
external _September : c_obj -> Swig.c_obj = "_wrap_September" 
external _October : c_obj -> Swig.c_obj = "_wrap_October" 
external _November : c_obj -> Swig.c_obj = "_wrap_November" 
external _December : c_obj -> Swig.c_obj = "_wrap_December" 
let _ = Callback.register "TimeUnit_marker" (`TimeUnit)
external _Days : c_obj -> Swig.c_obj = "_wrap_Days" 
external _Weeks : c_obj -> Swig.c_obj = "_wrap_Weeks" 
external _Months : c_obj -> Swig.c_obj = "_wrap_Months" 
external _Years : c_obj -> Swig.c_obj = "_wrap_Years" 
let _ = Callback.register "Frequency_marker" (`Frequency)
external _NoFrequency : c_obj -> Swig.c_obj = "_wrap_NoFrequency" 
external _Once : c_obj -> Swig.c_obj = "_wrap_Once" 
external _Annual : c_obj -> Swig.c_obj = "_wrap_Annual" 
external _Semiannual : c_obj -> Swig.c_obj = "_wrap_Semiannual" 
external _EveryFourthMonth : c_obj -> Swig.c_obj = "_wrap_EveryFourthMonth" 
external _Quarterly : c_obj -> Swig.c_obj = "_wrap_Quarterly" 
external _Bimonthly : c_obj -> Swig.c_obj = "_wrap_Bimonthly" 
external _Monthly : c_obj -> Swig.c_obj = "_wrap_Monthly" 
external _EveryFourthWeek : c_obj -> Swig.c_obj = "_wrap_EveryFourthWeek" 
external _Biweekly : c_obj -> Swig.c_obj = "_wrap_Biweekly" 
external _Weekly : c_obj -> Swig.c_obj = "_wrap_Weekly" 
external _Daily : c_obj -> Swig.c_obj = "_wrap_Daily" 
external _OtherFrequency : c_obj -> Swig.c_obj = "_wrap_OtherFrequency" 
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_Period__SWIG_0QuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_Period__SWIG_1QuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_Period__SWIG_2QuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period_length_f : c_obj list -> c_obj list = "_wrap_Period_lengthQuantLib" ;;
let _Period_length arg = match _Period_length_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period_units_f : c_obj list -> c_obj list = "_wrap_Period_unitsQuantLib" ;;
let _Period_units arg = match _Period_units_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period_frequency_f : c_obj list -> c_obj list = "_wrap_Period_frequencyQuantLib" ;;
let _Period_frequency arg = match _Period_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Period_f : c_obj list -> c_obj list = "_wrap_new_PeriodQuantLib" ;;
let _new_Period arg = match _new_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period___str___f : c_obj list -> c_obj list = "_wrap_Period___str__QuantLib" ;;
let _Period___str__ arg = match _Period___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Period___repr___f : c_obj list -> c_obj list = "_wrap_Period___repr__QuantLib" ;;
let _Period___repr__ arg = match _Period___repr___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Period_f : c_obj list -> c_obj list = "_wrap_delete_PeriodQuantLib" ;;
let _delete_Period arg = match _delete_Period_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVector__SWIG_0QuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVector__SWIG_1QuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVector__SWIG_2QuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodVector_f : c_obj list -> c_obj list = "_wrap_new_PeriodVectorQuantLib" ;;
let _new_PeriodVector arg = match _new_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_size_f : c_obj list -> c_obj list = "_wrap_PeriodVector_sizeQuantLib" ;;
let _PeriodVector_size arg = match _PeriodVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_empty_f : c_obj list -> c_obj list = "_wrap_PeriodVector_emptyQuantLib" ;;
let _PeriodVector_empty arg = match _PeriodVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_clear_f : c_obj list -> c_obj list = "_wrap_PeriodVector_clearQuantLib" ;;
let _PeriodVector_clear arg = match _PeriodVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_push_back_f : c_obj list -> c_obj list = "_wrap_PeriodVector_push_backQuantLib" ;;
let _PeriodVector_push_back arg = match _PeriodVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_PeriodVector_operator_bB___QuantLib" ;;
let _PeriodVector_operator_xx_xx_lbrace_xx_rbrace arg = match _PeriodVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_PeriodVector_operator_e___QuantLib" ;;
let _PeriodVector_operator_xx_xx_equals arg = match _PeriodVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_set_f : c_obj list -> c_obj list = "_wrap_PeriodVector_setQuantLib" ;;
let _PeriodVector_set arg = match _PeriodVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodVector_to_array_f : c_obj list -> c_obj list = "_wrap_PeriodVector_to_arrayQuantLib" ;;
let _PeriodVector_to_array arg = match _PeriodVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PeriodVector_f : c_obj list -> c_obj list = "_wrap_delete_PeriodVectorQuantLib" ;;
let _delete_PeriodVector arg = match _delete_PeriodVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_Date__SWIG_0QuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_Date__SWIG_1QuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_Date__SWIG_2QuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_weekday_f : c_obj list -> c_obj list = "_wrap_Date_weekdayQuantLib" ;;
let _Date_weekday arg = match _Date_weekday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_dayOfMonth_f : c_obj list -> c_obj list = "_wrap_Date_dayOfMonthQuantLib" ;;
let _Date_dayOfMonth arg = match _Date_dayOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_dayOfYear_f : c_obj list -> c_obj list = "_wrap_Date_dayOfYearQuantLib" ;;
let _Date_dayOfYear arg = match _Date_dayOfYear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_month_f : c_obj list -> c_obj list = "_wrap_Date_monthQuantLib" ;;
let _Date_month arg = match _Date_month_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_year_f : c_obj list -> c_obj list = "_wrap_Date_yearQuantLib" ;;
let _Date_year arg = match _Date_year_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_serialNumber_f : c_obj list -> c_obj list = "_wrap_Date_serialNumberQuantLib" ;;
let _Date_serialNumber arg = match _Date_serialNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_isLeap_f : c_obj list -> c_obj list = "_wrap_Date_isLeapQuantLib" ;;
let _Date_isLeap arg = match _Date_isLeap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_minDate_f : c_obj list -> c_obj list = "_wrap_Date_minDateQuantLib" ;;
let _Date_minDate arg = match _Date_minDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_maxDate_f : c_obj list -> c_obj list = "_wrap_Date_maxDateQuantLib" ;;
let _Date_maxDate arg = match _Date_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_todaysDate_f : c_obj list -> c_obj list = "_wrap_Date_todaysDateQuantLib" ;;
let _Date_todaysDate arg = match _Date_todaysDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_endOfMonth_f : c_obj list -> c_obj list = "_wrap_Date_endOfMonthQuantLib" ;;
let _Date_endOfMonth arg = match _Date_endOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_isEndOfMonth_f : c_obj list -> c_obj list = "_wrap_Date_isEndOfMonthQuantLib" ;;
let _Date_isEndOfMonth arg = match _Date_isEndOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_nextWeekday_f : c_obj list -> c_obj list = "_wrap_Date_nextWeekdayQuantLib" ;;
let _Date_nextWeekday arg = match _Date_nextWeekday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_nthWeekday_f : c_obj list -> c_obj list = "_wrap_Date_nthWeekdayQuantLib" ;;
let _Date_nthWeekday arg = match _Date_nthWeekday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Date_f : c_obj list -> c_obj list = "_wrap_new_DateQuantLib" ;;
let _new_Date arg = match _new_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_weekdayNumber_f : c_obj list -> c_obj list = "_wrap_Date_weekdayNumberQuantLib" ;;
let _Date_weekdayNumber arg = match _Date_weekdayNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date___str___f : c_obj list -> c_obj list = "_wrap_Date___str__QuantLib" ;;
let _Date___str__ arg = match _Date___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date___repr___f : c_obj list -> c_obj list = "_wrap_Date___repr__QuantLib" ;;
let _Date___repr__ arg = match _Date___repr___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Date_ISO_f : c_obj list -> c_obj list = "_wrap_Date_ISOQuantLib" ;;
let _Date_ISO arg = match _Date_ISO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Date_f : c_obj list -> c_obj list = "_wrap_delete_DateQuantLib" ;;
let _delete_Date arg = match _delete_Date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateParser_parse_f : c_obj list -> c_obj list = "_wrap_DateParser_parseQuantLib" ;;
let _DateParser_parse arg = match _DateParser_parse_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateParser_parseISO_f : c_obj list -> c_obj list = "_wrap_DateParser_parseISOQuantLib" ;;
let _DateParser_parseISO arg = match _DateParser_parseISO_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateParser_f : c_obj list -> c_obj list = "_wrap_new_DateParserQuantLib" ;;
let _new_DateParser arg = match _new_DateParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DateParser_f : c_obj list -> c_obj list = "_wrap_delete_DateParserQuantLib" ;;
let _delete_DateParser arg = match _delete_DateParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PeriodParser_parse_f : c_obj list -> c_obj list = "_wrap_PeriodParser_parseQuantLib" ;;
let _PeriodParser_parse arg = match _PeriodParser_parse_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PeriodParser_f : c_obj list -> c_obj list = "_wrap_new_PeriodParserQuantLib" ;;
let _new_PeriodParser arg = match _new_PeriodParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PeriodParser_f : c_obj list -> c_obj list = "_wrap_delete_PeriodParserQuantLib" ;;
let _delete_PeriodParser arg = match _delete_PeriodParser_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVector__SWIG_0QuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVector__SWIG_1QuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVector__SWIG_2QuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DateVector_f : c_obj list -> c_obj list = "_wrap_new_DateVectorQuantLib" ;;
let _new_DateVector arg = match _new_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_size_f : c_obj list -> c_obj list = "_wrap_DateVector_sizeQuantLib" ;;
let _DateVector_size arg = match _DateVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_empty_f : c_obj list -> c_obj list = "_wrap_DateVector_emptyQuantLib" ;;
let _DateVector_empty arg = match _DateVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_clear_f : c_obj list -> c_obj list = "_wrap_DateVector_clearQuantLib" ;;
let _DateVector_clear arg = match _DateVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_push_back_f : c_obj list -> c_obj list = "_wrap_DateVector_push_backQuantLib" ;;
let _DateVector_push_back arg = match _DateVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_DateVector_operator_bB___QuantLib" ;;
let _DateVector_operator_xx_xx_lbrace_xx_rbrace arg = match _DateVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_DateVector_operator_e___QuantLib" ;;
let _DateVector_operator_xx_xx_equals arg = match _DateVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_set_f : c_obj list -> c_obj list = "_wrap_DateVector_setQuantLib" ;;
let _DateVector_set arg = match _DateVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DateVector_to_array_f : c_obj list -> c_obj list = "_wrap_DateVector_to_arrayQuantLib" ;;
let _DateVector_to_array arg = match _DateVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DateVector_f : c_obj list -> c_obj list = "_wrap_delete_DateVectorQuantLib" ;;
let _delete_DateVector arg = match _delete_DateVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "IMM::Month_marker" (`Month)
external _F : c_obj -> Swig.c_obj = "_wrap_F" 
external _G : c_obj -> Swig.c_obj = "_wrap_G" 
external _H : c_obj -> Swig.c_obj = "_wrap_H" 
external _J : c_obj -> Swig.c_obj = "_wrap_J" 
external _K : c_obj -> Swig.c_obj = "_wrap_K" 
external _M : c_obj -> Swig.c_obj = "_wrap_M" 
external _N : c_obj -> Swig.c_obj = "_wrap_N" 
external _Q : c_obj -> Swig.c_obj = "_wrap_Q" 
external _U : c_obj -> Swig.c_obj = "_wrap_U" 
external _V : c_obj -> Swig.c_obj = "_wrap_V" 
external _X : c_obj -> Swig.c_obj = "_wrap_X" 
external _Z : c_obj -> Swig.c_obj = "_wrap_Z" 
external _IMM_isIMMdate_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMdate__SWIG_0QuantLib" ;;
let _IMM_isIMMdate arg = match _IMM_isIMMdate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_isIMMdate_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMdateQuantLib" ;;
let _IMM_isIMMdate arg = match _IMM_isIMMdate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_isIMMcode_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMcode__SWIG_0QuantLib" ;;
let _IMM_isIMMcode arg = match _IMM_isIMMcode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_isIMMcode_f : c_obj list -> c_obj list = "_wrap_IMM_isIMMcodeQuantLib" ;;
let _IMM_isIMMcode arg = match _IMM_isIMMcode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_code_f : c_obj list -> c_obj list = "_wrap_IMM_codeQuantLib" ;;
let _IMM_code arg = match _IMM_code_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_date_f : c_obj list -> c_obj list = "_wrap_IMM_date__SWIG_0QuantLib" ;;
let _IMM_date arg = match _IMM_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_date_f : c_obj list -> c_obj list = "_wrap_IMM_dateQuantLib" ;;
let _IMM_date arg = match _IMM_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_0QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_1QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_2QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_3QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDate__SWIG_4QuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextDate_f : c_obj list -> c_obj list = "_wrap_IMM_nextDateQuantLib" ;;
let _IMM_nextDate arg = match _IMM_nextDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_0QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_1QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_2QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_3QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCode__SWIG_4QuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IMM_nextCode_f : c_obj list -> c_obj list = "_wrap_IMM_nextCodeQuantLib" ;;
let _IMM_nextCode arg = match _IMM_nextCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IMM_f : c_obj list -> c_obj list = "_wrap_new_IMMQuantLib" ;;
let _new_IMM arg = match _new_IMM_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IMM_f : c_obj list -> c_obj list = "_wrap_delete_IMMQuantLib" ;;
let _delete_IMM arg = match _delete_IMM_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVector__SWIG_0QuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVector__SWIG_1QuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVector__SWIG_2QuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntVector_f : c_obj list -> c_obj list = "_wrap_new_IntVectorQuantLib" ;;
let _new_IntVector arg = match _new_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_size_f : c_obj list -> c_obj list = "_wrap_IntVector_sizeQuantLib" ;;
let _IntVector_size arg = match _IntVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_empty_f : c_obj list -> c_obj list = "_wrap_IntVector_emptyQuantLib" ;;
let _IntVector_empty arg = match _IntVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_clear_f : c_obj list -> c_obj list = "_wrap_IntVector_clearQuantLib" ;;
let _IntVector_clear arg = match _IntVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_push_back_f : c_obj list -> c_obj list = "_wrap_IntVector_push_backQuantLib" ;;
let _IntVector_push_back arg = match _IntVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_IntVector_operator_bB___QuantLib" ;;
let _IntVector_operator_xx_xx_lbrace_xx_rbrace arg = match _IntVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_IntVector_operator_e___QuantLib" ;;
let _IntVector_operator_xx_xx_equals arg = match _IntVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_set_f : c_obj list -> c_obj list = "_wrap_IntVector_setQuantLib" ;;
let _IntVector_set arg = match _IntVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntVector_to_array_f : c_obj list -> c_obj list = "_wrap_IntVector_to_arrayQuantLib" ;;
let _IntVector_to_array arg = match _IntVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntVector_f : c_obj list -> c_obj list = "_wrap_delete_IntVectorQuantLib" ;;
let _delete_IntVector arg = match _delete_IntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnsignedIntVector_f : c_obj list -> c_obj list = "_wrap_new_UnsignedIntVector__SWIG_0QuantLib" ;;
let _new_UnsignedIntVector arg = match _new_UnsignedIntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnsignedIntVector_f : c_obj list -> c_obj list = "_wrap_new_UnsignedIntVector__SWIG_1QuantLib" ;;
let _new_UnsignedIntVector arg = match _new_UnsignedIntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnsignedIntVector_f : c_obj list -> c_obj list = "_wrap_new_UnsignedIntVector__SWIG_2QuantLib" ;;
let _new_UnsignedIntVector arg = match _new_UnsignedIntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnsignedIntVector_f : c_obj list -> c_obj list = "_wrap_new_UnsignedIntVectorQuantLib" ;;
let _new_UnsignedIntVector arg = match _new_UnsignedIntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_size_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_sizeQuantLib" ;;
let _UnsignedIntVector_size arg = match _UnsignedIntVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_empty_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_emptyQuantLib" ;;
let _UnsignedIntVector_empty arg = match _UnsignedIntVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_clear_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_clearQuantLib" ;;
let _UnsignedIntVector_clear arg = match _UnsignedIntVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_push_back_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_push_backQuantLib" ;;
let _UnsignedIntVector_push_back arg = match _UnsignedIntVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_operator_bB___QuantLib" ;;
let _UnsignedIntVector_operator_xx_xx_lbrace_xx_rbrace arg = match _UnsignedIntVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_operator_e___QuantLib" ;;
let _UnsignedIntVector_operator_xx_xx_equals arg = match _UnsignedIntVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_set_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_setQuantLib" ;;
let _UnsignedIntVector_set arg = match _UnsignedIntVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UnsignedIntVector_to_array_f : c_obj list -> c_obj list = "_wrap_UnsignedIntVector_to_arrayQuantLib" ;;
let _UnsignedIntVector_to_array arg = match _UnsignedIntVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UnsignedIntVector_f : c_obj list -> c_obj list = "_wrap_delete_UnsignedIntVectorQuantLib" ;;
let _delete_UnsignedIntVector arg = match _delete_UnsignedIntVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVector__SWIG_0QuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVector__SWIG_1QuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVector__SWIG_2QuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DoubleVector_f : c_obj list -> c_obj list = "_wrap_new_DoubleVectorQuantLib" ;;
let _new_DoubleVector arg = match _new_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_size_f : c_obj list -> c_obj list = "_wrap_DoubleVector_sizeQuantLib" ;;
let _DoubleVector_size arg = match _DoubleVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_empty_f : c_obj list -> c_obj list = "_wrap_DoubleVector_emptyQuantLib" ;;
let _DoubleVector_empty arg = match _DoubleVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_clear_f : c_obj list -> c_obj list = "_wrap_DoubleVector_clearQuantLib" ;;
let _DoubleVector_clear arg = match _DoubleVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_push_back_f : c_obj list -> c_obj list = "_wrap_DoubleVector_push_backQuantLib" ;;
let _DoubleVector_push_back arg = match _DoubleVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_DoubleVector_operator_bB___QuantLib" ;;
let _DoubleVector_operator_xx_xx_lbrace_xx_rbrace arg = match _DoubleVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_DoubleVector_operator_e___QuantLib" ;;
let _DoubleVector_operator_xx_xx_equals arg = match _DoubleVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_set_f : c_obj list -> c_obj list = "_wrap_DoubleVector_setQuantLib" ;;
let _DoubleVector_set arg = match _DoubleVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DoubleVector_to_array_f : c_obj list -> c_obj list = "_wrap_DoubleVector_to_arrayQuantLib" ;;
let _DoubleVector_to_array arg = match _DoubleVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DoubleVector_f : c_obj list -> c_obj list = "_wrap_delete_DoubleVectorQuantLib" ;;
let _delete_DoubleVector arg = match _delete_DoubleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVector__SWIG_0QuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVector__SWIG_1QuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVector__SWIG_2QuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StrVector_f : c_obj list -> c_obj list = "_wrap_new_StrVectorQuantLib" ;;
let _new_StrVector arg = match _new_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_size_f : c_obj list -> c_obj list = "_wrap_StrVector_sizeQuantLib" ;;
let _StrVector_size arg = match _StrVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_empty_f : c_obj list -> c_obj list = "_wrap_StrVector_emptyQuantLib" ;;
let _StrVector_empty arg = match _StrVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_clear_f : c_obj list -> c_obj list = "_wrap_StrVector_clearQuantLib" ;;
let _StrVector_clear arg = match _StrVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_push_back_f : c_obj list -> c_obj list = "_wrap_StrVector_push_backQuantLib" ;;
let _StrVector_push_back arg = match _StrVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_StrVector_operator_bB___QuantLib" ;;
let _StrVector_operator_xx_xx_lbrace_xx_rbrace arg = match _StrVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_StrVector_operator_e___QuantLib" ;;
let _StrVector_operator_xx_xx_equals arg = match _StrVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_set_f : c_obj list -> c_obj list = "_wrap_StrVector_setQuantLib" ;;
let _StrVector_set arg = match _StrVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StrVector_to_array_f : c_obj list -> c_obj list = "_wrap_StrVector_to_arrayQuantLib" ;;
let _StrVector_to_array arg = match _StrVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StrVector_f : c_obj list -> c_obj list = "_wrap_delete_StrVectorQuantLib" ;;
let _delete_StrVector arg = match _delete_StrVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoolVector_f : c_obj list -> c_obj list = "_wrap_new_BoolVector__SWIG_0QuantLib" ;;
let _new_BoolVector arg = match _new_BoolVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoolVector_f : c_obj list -> c_obj list = "_wrap_new_BoolVector__SWIG_1QuantLib" ;;
let _new_BoolVector arg = match _new_BoolVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoolVector_f : c_obj list -> c_obj list = "_wrap_new_BoolVector__SWIG_2QuantLib" ;;
let _new_BoolVector arg = match _new_BoolVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoolVector_f : c_obj list -> c_obj list = "_wrap_new_BoolVectorQuantLib" ;;
let _new_BoolVector arg = match _new_BoolVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_size_f : c_obj list -> c_obj list = "_wrap_BoolVector_sizeQuantLib" ;;
let _BoolVector_size arg = match _BoolVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_empty_f : c_obj list -> c_obj list = "_wrap_BoolVector_emptyQuantLib" ;;
let _BoolVector_empty arg = match _BoolVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_clear_f : c_obj list -> c_obj list = "_wrap_BoolVector_clearQuantLib" ;;
let _BoolVector_clear arg = match _BoolVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_push_back_f : c_obj list -> c_obj list = "_wrap_BoolVector_push_backQuantLib" ;;
let _BoolVector_push_back arg = match _BoolVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_BoolVector_operator_bB___QuantLib" ;;
let _BoolVector_operator_xx_xx_lbrace_xx_rbrace arg = match _BoolVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_BoolVector_operator_e___QuantLib" ;;
let _BoolVector_operator_xx_xx_equals arg = match _BoolVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_set_f : c_obj list -> c_obj list = "_wrap_BoolVector_setQuantLib" ;;
let _BoolVector_set arg = match _BoolVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoolVector_to_array_f : c_obj list -> c_obj list = "_wrap_BoolVector_to_arrayQuantLib" ;;
let _BoolVector_to_array arg = match _BoolVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoolVector_f : c_obj list -> c_obj list = "_wrap_delete_BoolVectorQuantLib" ;;
let _delete_BoolVector arg = match _delete_BoolVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodePair_f : c_obj list -> c_obj list = "_wrap_new_NodePair__SWIG_0QuantLib" ;;
let _new_NodePair arg = match _new_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodePair_f : c_obj list -> c_obj list = "_wrap_new_NodePair__SWIG_1QuantLib" ;;
let _new_NodePair arg = match _new_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodePair_f : c_obj list -> c_obj list = "_wrap_new_NodePairQuantLib" ;;
let _new_NodePair arg = match _new_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_first_set_f : c_obj list -> c_obj list = "_wrap_NodePair_first_setQuantLib" ;;
let _NodePair_first_set arg = match _NodePair_first_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_first_get_f : c_obj list -> c_obj list = "_wrap_NodePair_first_getQuantLib" ;;
let _NodePair_first_get arg = match _NodePair_first_get_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_second_set_f : c_obj list -> c_obj list = "_wrap_NodePair_second_setQuantLib" ;;
let _NodePair_second_set arg = match _NodePair_second_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodePair_second_get_f : c_obj list -> c_obj list = "_wrap_NodePair_second_getQuantLib" ;;
let _NodePair_second_get arg = match _NodePair_second_get_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NodePair_f : c_obj list -> c_obj list = "_wrap_delete_NodePairQuantLib" ;;
let _delete_NodePair arg = match _delete_NodePair_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVector__SWIG_0QuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVector__SWIG_1QuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVector__SWIG_2QuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NodeVector_f : c_obj list -> c_obj list = "_wrap_new_NodeVectorQuantLib" ;;
let _new_NodeVector arg = match _new_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_size_f : c_obj list -> c_obj list = "_wrap_NodeVector_sizeQuantLib" ;;
let _NodeVector_size arg = match _NodeVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_empty_f : c_obj list -> c_obj list = "_wrap_NodeVector_emptyQuantLib" ;;
let _NodeVector_empty arg = match _NodeVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_clear_f : c_obj list -> c_obj list = "_wrap_NodeVector_clearQuantLib" ;;
let _NodeVector_clear arg = match _NodeVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_push_back_f : c_obj list -> c_obj list = "_wrap_NodeVector_push_backQuantLib" ;;
let _NodeVector_push_back arg = match _NodeVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_NodeVector_operator_bB___QuantLib" ;;
let _NodeVector_operator_xx_xx_lbrace_xx_rbrace arg = match _NodeVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_NodeVector_operator_e___QuantLib" ;;
let _NodeVector_operator_xx_xx_equals arg = match _NodeVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_set_f : c_obj list -> c_obj list = "_wrap_NodeVector_setQuantLib" ;;
let _NodeVector_set arg = match _NodeVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NodeVector_to_array_f : c_obj list -> c_obj list = "_wrap_NodeVector_to_arrayQuantLib" ;;
let _NodeVector_to_array arg = match _NodeVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NodeVector_f : c_obj list -> c_obj list = "_wrap_delete_NodeVectorQuantLib" ;;
let _delete_NodeVector arg = match _delete_NodeVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise___deref___f : c_obj list -> c_obj list = "_wrap_Exercise___deref__QuantLib" ;;
let _Exercise___deref__ arg = match _Exercise___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_isNull_f : c_obj list -> c_obj list = "_wrap_Exercise_isNullQuantLib" ;;
let _Exercise_isNull arg = match _Exercise_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_American : c_obj -> Swig.c_obj = "_wrap_Exercise_American" 
external _Exercise_Bermudan : c_obj -> Swig.c_obj = "_wrap_Exercise_Bermudan" 
external _Exercise_European : c_obj -> Swig.c_obj = "_wrap_Exercise_European" 
external _Exercise_exerciseType_f : c_obj list -> c_obj list = "_wrap_Exercise_exerciseTypeQuantLib" ;;
let _Exercise_exerciseType arg = match _Exercise_exerciseType_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Exercise_f : c_obj list -> c_obj list = "_wrap_new_ExerciseQuantLib" ;;
let _new_Exercise arg = match _new_Exercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Exercise_f : c_obj list -> c_obj list = "_wrap_delete_ExerciseQuantLib" ;;
let _delete_Exercise arg = match _delete_Exercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_type_f : c_obj list -> c_obj list = "_wrap_Exercise_typeQuantLib" ;;
let _Exercise_type arg = match _Exercise_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Exercise_dates_f : c_obj list -> c_obj list = "_wrap_Exercise_datesQuantLib" ;;
let _Exercise_dates arg = match _Exercise_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuropeanExercise_f : c_obj list -> c_obj list = "_wrap_new_EuropeanExerciseQuantLib" ;;
let _new_EuropeanExercise arg = match _new_EuropeanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuropeanExercise_f : c_obj list -> c_obj list = "_wrap_delete_EuropeanExerciseQuantLib" ;;
let _delete_EuropeanExercise arg = match _delete_EuropeanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AmericanExercise_f : c_obj list -> c_obj list = "_wrap_new_AmericanExercise__SWIG_0QuantLib" ;;
let _new_AmericanExercise arg = match _new_AmericanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AmericanExercise_f : c_obj list -> c_obj list = "_wrap_new_AmericanExerciseQuantLib" ;;
let _new_AmericanExercise arg = match _new_AmericanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AmericanExercise_f : c_obj list -> c_obj list = "_wrap_delete_AmericanExerciseQuantLib" ;;
let _delete_AmericanExercise arg = match _delete_AmericanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BermudanExercise_f : c_obj list -> c_obj list = "_wrap_new_BermudanExercise__SWIG_0QuantLib" ;;
let _new_BermudanExercise arg = match _new_BermudanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BermudanExercise_f : c_obj list -> c_obj list = "_wrap_new_BermudanExerciseQuantLib" ;;
let _new_BermudanExercise arg = match _new_BermudanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BermudanExercise_f : c_obj list -> c_obj list = "_wrap_delete_BermudanExerciseQuantLib" ;;
let _delete_BermudanExercise arg = match _delete_BermudanExercise_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Observable___deref___f : c_obj list -> c_obj list = "_wrap_Observable___deref__QuantLib" ;;
let _Observable___deref__ arg = match _Observable___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Observable_isNull_f : c_obj list -> c_obj list = "_wrap_Observable_isNullQuantLib" ;;
let _Observable_isNull arg = match _Observable_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Observable_f : c_obj list -> c_obj list = "_wrap_new_ObservableQuantLib" ;;
let _new_Observable arg = match _new_Observable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Observable_f : c_obj list -> c_obj list = "_wrap_delete_ObservableQuantLib" ;;
let _delete_Observable arg = match _delete_Observable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_Array__SWIG_0QuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_Array__SWIG_1QuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_Array__SWIG_2QuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Array_f : c_obj list -> c_obj list = "_wrap_new_ArrayQuantLib" ;;
let _new_Array arg = match _new_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Array_size_f : c_obj list -> c_obj list = "_wrap_Array_sizeQuantLib" ;;
let _Array_size arg = match _Array_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Array___str___f : c_obj list -> c_obj list = "_wrap_Array___str__QuantLib" ;;
let _Array___str__ arg = match _Array___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Array_f : c_obj list -> c_obj list = "_wrap_delete_ArrayQuantLib" ;;
let _delete_Array arg = match _delete_Array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LexicographicalView_xSize_f : c_obj list -> c_obj list = "_wrap_LexicographicalView_xSizeQuantLib" ;;
let _LexicographicalView_xSize arg = match _LexicographicalView_xSize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LexicographicalView_ySize_f : c_obj list -> c_obj list = "_wrap_LexicographicalView_ySizeQuantLib" ;;
let _LexicographicalView_ySize arg = match _LexicographicalView_ySize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LexicographicalView_f : c_obj list -> c_obj list = "_wrap_new_LexicographicalViewQuantLib" ;;
let _new_LexicographicalView arg = match _new_LexicographicalView_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LexicographicalView___str___f : c_obj list -> c_obj list = "_wrap_LexicographicalView___str__QuantLib" ;;
let _LexicographicalView___str__ arg = match _LexicographicalView___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LexicographicalView_f : c_obj list -> c_obj list = "_wrap_delete_LexicographicalViewQuantLib" ;;
let _delete_LexicographicalView arg = match _delete_LexicographicalView_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_Matrix__SWIG_0QuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_Matrix__SWIG_1QuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_Matrix__SWIG_2QuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Matrix_f : c_obj list -> c_obj list = "_wrap_new_MatrixQuantLib" ;;
let _new_Matrix arg = match _new_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Matrix_rows_f : c_obj list -> c_obj list = "_wrap_Matrix_rowsQuantLib" ;;
let _Matrix_rows arg = match _Matrix_rows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Matrix_columns_f : c_obj list -> c_obj list = "_wrap_Matrix_columnsQuantLib" ;;
let _Matrix_columns arg = match _Matrix_columns_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Matrix___str___f : c_obj list -> c_obj list = "_wrap_Matrix___str__QuantLib" ;;
let _Matrix___str__ arg = match _Matrix___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Matrix_f : c_obj list -> c_obj list = "_wrap_delete_MatrixQuantLib" ;;
let _delete_Matrix arg = match _delete_Matrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "SalvagingAlgorithm::Type_marker" (`Type)
external _None : c_obj -> Swig.c_obj = "_wrap_None" 
external _Spectral : c_obj -> Swig.c_obj = "_wrap_Spectral" 
external _new_SalvagingAlgorithm_f : c_obj list -> c_obj list = "_wrap_new_SalvagingAlgorithmQuantLib" ;;
let _new_SalvagingAlgorithm arg = match _new_SalvagingAlgorithm_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SalvagingAlgorithm_f : c_obj list -> c_obj list = "_wrap_delete_SalvagingAlgorithmQuantLib" ;;
let _delete_SalvagingAlgorithm arg = match _delete_SalvagingAlgorithm_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _transpose_f : c_obj list -> c_obj list = "_wrap_transposeQuantLib" ;;
let _transpose arg = match _transpose_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _outerProduct_f : c_obj list -> c_obj list = "_wrap_outerProductQuantLib" ;;
let _outerProduct arg = match _outerProduct_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _pseudoSqrt_f : c_obj list -> c_obj list = "_wrap_pseudoSqrtQuantLib" ;;
let _pseudoSqrt arg = match _pseudoSqrt_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SVD_f : c_obj list -> c_obj list = "_wrap_new_SVDQuantLib" ;;
let _new_SVD arg = match _new_SVD_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_U_f : c_obj list -> c_obj list = "_wrap_SVD_UQuantLib" ;;
let _SVD_U arg = match _SVD_U_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_V_f : c_obj list -> c_obj list = "_wrap_SVD_VQuantLib" ;;
let _SVD_V arg = match _SVD_V_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_S_f : c_obj list -> c_obj list = "_wrap_SVD_SQuantLib" ;;
let _SVD_S arg = match _SVD_S_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SVD_singularValues_f : c_obj list -> c_obj list = "_wrap_SVD_singularValuesQuantLib" ;;
let _SVD_singularValues arg = match _SVD_singularValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SVD_f : c_obj list -> c_obj list = "_wrap_delete_SVDQuantLib" ;;
let _delete_SVD arg = match _delete_SVD_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote___deref___f : c_obj list -> c_obj list = "_wrap_Quote___deref__QuantLib" ;;
let _Quote___deref__ arg = match _Quote___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote_isNull_f : c_obj list -> c_obj list = "_wrap_Quote_isNullQuantLib" ;;
let _Quote_isNull arg = match _Quote_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote_asObservable_f : c_obj list -> c_obj list = "_wrap_Quote_asObservableQuantLib" ;;
let _Quote_asObservable arg = match _Quote_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Quote_f : c_obj list -> c_obj list = "_wrap_new_QuoteQuantLib" ;;
let _new_Quote arg = match _new_Quote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Quote_f : c_obj list -> c_obj list = "_wrap_delete_QuoteQuantLib" ;;
let _delete_Quote arg = match _delete_Quote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Quote_value_f : c_obj list -> c_obj list = "_wrap_Quote_valueQuantLib" ;;
let _Quote_value arg = match _Quote_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandle__SWIG_0QuantLib" ;;
let _new_QuoteHandle arg = match _new_QuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleQuantLib" ;;
let _new_QuoteHandle arg = match _new_QuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle___deref___f : c_obj list -> c_obj list = "_wrap_QuoteHandle___deref__QuantLib" ;;
let _QuoteHandle___deref__ arg = match _QuoteHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle_empty_f : c_obj list -> c_obj list = "_wrap_QuoteHandle_emptyQuantLib" ;;
let _QuoteHandle_empty arg = match _QuoteHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_QuoteHandle_asObservableQuantLib" ;;
let _QuoteHandle_asObservable arg = match _QuoteHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteHandle_f : c_obj list -> c_obj list = "_wrap_delete_QuoteHandleQuantLib" ;;
let _delete_QuoteHandle arg = match _delete_QuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandle_value_f : c_obj list -> c_obj list = "_wrap_QuoteHandle_valueQuantLib" ;;
let _QuoteHandle_value arg = match _QuoteHandle_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandle__SWIG_0QuantLib" ;;
let _new_RelinkableQuoteHandle arg = match _new_RelinkableQuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleQuantLib" ;;
let _new_RelinkableQuoteHandle arg = match _new_RelinkableQuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandle_linkToQuantLib" ;;
let _RelinkableQuoteHandle_linkTo arg = match _RelinkableQuoteHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableQuoteHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableQuoteHandleQuantLib" ;;
let _delete_RelinkableQuoteHandle arg = match _delete_RelinkableQuoteHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpleQuote_f : c_obj list -> c_obj list = "_wrap_new_SimpleQuoteQuantLib" ;;
let _new_SimpleQuote arg = match _new_SimpleQuote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SimpleQuote_setValue_f : c_obj list -> c_obj list = "_wrap_SimpleQuote_setValueQuantLib" ;;
let _SimpleQuote_setValue arg = match _SimpleQuote_setValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpleQuote_f : c_obj list -> c_obj list = "_wrap_delete_SimpleQuoteQuantLib" ;;
let _delete_SimpleQuote arg = match _delete_SimpleQuote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVector__SWIG_0QuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVector__SWIG_1QuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVector__SWIG_2QuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVectorQuantLib" ;;
let _new_QuoteVector arg = match _new_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_size_f : c_obj list -> c_obj list = "_wrap_QuoteVector_sizeQuantLib" ;;
let _QuoteVector_size arg = match _QuoteVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_empty_f : c_obj list -> c_obj list = "_wrap_QuoteVector_emptyQuantLib" ;;
let _QuoteVector_empty arg = match _QuoteVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_clear_f : c_obj list -> c_obj list = "_wrap_QuoteVector_clearQuantLib" ;;
let _QuoteVector_clear arg = match _QuoteVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_push_back_f : c_obj list -> c_obj list = "_wrap_QuoteVector_push_backQuantLib" ;;
let _QuoteVector_push_back arg = match _QuoteVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_QuoteVector_operator_bB___QuantLib" ;;
let _QuoteVector_operator_xx_xx_lbrace_xx_rbrace arg = match _QuoteVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_QuoteVector_operator_e___QuantLib" ;;
let _QuoteVector_operator_xx_xx_equals arg = match _QuoteVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_set_f : c_obj list -> c_obj list = "_wrap_QuoteVector_setQuantLib" ;;
let _QuoteVector_set arg = match _QuoteVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVector_to_array_f : c_obj list -> c_obj list = "_wrap_QuoteVector_to_arrayQuantLib" ;;
let _QuoteVector_to_array arg = match _QuoteVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteVector_f : c_obj list -> c_obj list = "_wrap_delete_QuoteVectorQuantLib" ;;
let _delete_QuoteVector arg = match _delete_QuoteVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVectorVector__SWIG_0QuantLib" ;;
let _new_QuoteVectorVector arg = match _new_QuoteVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVectorVector__SWIG_1QuantLib" ;;
let _new_QuoteVectorVector arg = match _new_QuoteVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVectorVector__SWIG_2QuantLib" ;;
let _new_QuoteVectorVector arg = match _new_QuoteVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteVectorVectorQuantLib" ;;
let _new_QuoteVectorVector arg = match _new_QuoteVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_size_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_sizeQuantLib" ;;
let _QuoteVectorVector_size arg = match _QuoteVectorVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_empty_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_emptyQuantLib" ;;
let _QuoteVectorVector_empty arg = match _QuoteVectorVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_clear_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_clearQuantLib" ;;
let _QuoteVectorVector_clear arg = match _QuoteVectorVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_push_back_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_push_backQuantLib" ;;
let _QuoteVectorVector_push_back arg = match _QuoteVectorVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_operator_bB___QuantLib" ;;
let _QuoteVectorVector_operator_xx_xx_lbrace_xx_rbrace arg = match _QuoteVectorVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_operator_e___QuantLib" ;;
let _QuoteVectorVector_operator_xx_xx_equals arg = match _QuoteVectorVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_set_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_setQuantLib" ;;
let _QuoteVectorVector_set arg = match _QuoteVectorVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteVectorVector_to_array_f : c_obj list -> c_obj list = "_wrap_QuoteVectorVector_to_arrayQuantLib" ;;
let _QuoteVectorVector_to_array arg = match _QuoteVectorVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteVectorVector_f : c_obj list -> c_obj list = "_wrap_delete_QuoteVectorVectorQuantLib" ;;
let _delete_QuoteVectorVector arg = match _delete_QuoteVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVector__SWIG_0QuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVector__SWIG_1QuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVector__SWIG_2QuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVectorQuantLib" ;;
let _new_QuoteHandleVector arg = match _new_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_size_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_sizeQuantLib" ;;
let _QuoteHandleVector_size arg = match _QuoteHandleVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_empty_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_emptyQuantLib" ;;
let _QuoteHandleVector_empty arg = match _QuoteHandleVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_clear_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_clearQuantLib" ;;
let _QuoteHandleVector_clear arg = match _QuoteHandleVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_push_back_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_push_backQuantLib" ;;
let _QuoteHandleVector_push_back arg = match _QuoteHandleVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_operator_bB___QuantLib" ;;
let _QuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace arg = match _QuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_operator_e___QuantLib" ;;
let _QuoteHandleVector_operator_xx_xx_equals arg = match _QuoteHandleVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_set_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_setQuantLib" ;;
let _QuoteHandleVector_set arg = match _QuoteHandleVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVector_to_array_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVector_to_arrayQuantLib" ;;
let _QuoteHandleVector_to_array arg = match _QuoteHandleVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_delete_QuoteHandleVectorQuantLib" ;;
let _delete_QuoteHandleVector arg = match _delete_QuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVectorVector__SWIG_0QuantLib" ;;
let _new_QuoteHandleVectorVector arg = match _new_QuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVectorVector__SWIG_1QuantLib" ;;
let _new_QuoteHandleVectorVector arg = match _new_QuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVectorVector__SWIG_2QuantLib" ;;
let _new_QuoteHandleVectorVector arg = match _new_QuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_QuoteHandleVectorVectorQuantLib" ;;
let _new_QuoteHandleVectorVector arg = match _new_QuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_size_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_sizeQuantLib" ;;
let _QuoteHandleVectorVector_size arg = match _QuoteHandleVectorVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_empty_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_emptyQuantLib" ;;
let _QuoteHandleVectorVector_empty arg = match _QuoteHandleVectorVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_clear_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_clearQuantLib" ;;
let _QuoteHandleVectorVector_clear arg = match _QuoteHandleVectorVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_push_back_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_push_backQuantLib" ;;
let _QuoteHandleVectorVector_push_back arg = match _QuoteHandleVectorVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_operator_bB___QuantLib" ;;
let _QuoteHandleVectorVector_operator_xx_xx_lbrace_xx_rbrace arg = match _QuoteHandleVectorVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_operator_e___QuantLib" ;;
let _QuoteHandleVectorVector_operator_xx_xx_equals arg = match _QuoteHandleVectorVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_set_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_setQuantLib" ;;
let _QuoteHandleVectorVector_set arg = match _QuoteHandleVectorVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuoteHandleVectorVector_to_array_f : c_obj list -> c_obj list = "_wrap_QuoteHandleVectorVector_to_arrayQuantLib" ;;
let _QuoteHandleVectorVector_to_array arg = match _QuoteHandleVectorVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_delete_QuoteHandleVectorVectorQuantLib" ;;
let _delete_QuoteHandleVectorVector arg = match _delete_QuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVector__SWIG_0QuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVector__SWIG_1QuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVector__SWIG_2QuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVectorQuantLib" ;;
let _new_RelinkableQuoteHandleVector arg = match _new_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_size_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_sizeQuantLib" ;;
let _RelinkableQuoteHandleVector_size arg = match _RelinkableQuoteHandleVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_empty_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_emptyQuantLib" ;;
let _RelinkableQuoteHandleVector_empty arg = match _RelinkableQuoteHandleVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_clear_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_clearQuantLib" ;;
let _RelinkableQuoteHandleVector_clear arg = match _RelinkableQuoteHandleVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_push_back_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_push_backQuantLib" ;;
let _RelinkableQuoteHandleVector_push_back arg = match _RelinkableQuoteHandleVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_operator_bB___QuantLib" ;;
let _RelinkableQuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace arg = match _RelinkableQuoteHandleVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_operator_e___QuantLib" ;;
let _RelinkableQuoteHandleVector_operator_xx_xx_equals arg = match _RelinkableQuoteHandleVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_set_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_setQuantLib" ;;
let _RelinkableQuoteHandleVector_set arg = match _RelinkableQuoteHandleVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVector_to_array_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVector_to_arrayQuantLib" ;;
let _RelinkableQuoteHandleVector_to_array arg = match _RelinkableQuoteHandleVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableQuoteHandleVector_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableQuoteHandleVectorQuantLib" ;;
let _delete_RelinkableQuoteHandleVector arg = match _delete_RelinkableQuoteHandleVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVectorVector__SWIG_0QuantLib" ;;
let _new_RelinkableQuoteHandleVectorVector arg = match _new_RelinkableQuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVectorVector__SWIG_1QuantLib" ;;
let _new_RelinkableQuoteHandleVectorVector arg = match _new_RelinkableQuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVectorVector__SWIG_2QuantLib" ;;
let _new_RelinkableQuoteHandleVectorVector arg = match _new_RelinkableQuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableQuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_new_RelinkableQuoteHandleVectorVectorQuantLib" ;;
let _new_RelinkableQuoteHandleVectorVector arg = match _new_RelinkableQuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_size_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_sizeQuantLib" ;;
let _RelinkableQuoteHandleVectorVector_size arg = match _RelinkableQuoteHandleVectorVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_empty_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_emptyQuantLib" ;;
let _RelinkableQuoteHandleVectorVector_empty arg = match _RelinkableQuoteHandleVectorVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_clear_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_clearQuantLib" ;;
let _RelinkableQuoteHandleVectorVector_clear arg = match _RelinkableQuoteHandleVectorVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_push_back_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_push_backQuantLib" ;;
let _RelinkableQuoteHandleVectorVector_push_back arg = match _RelinkableQuoteHandleVectorVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_operator_bB___QuantLib" ;;
let _RelinkableQuoteHandleVectorVector_operator_xx_xx_lbrace_xx_rbrace arg = match _RelinkableQuoteHandleVectorVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_operator_e___QuantLib" ;;
let _RelinkableQuoteHandleVectorVector_operator_xx_xx_equals arg = match _RelinkableQuoteHandleVectorVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_set_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_setQuantLib" ;;
let _RelinkableQuoteHandleVectorVector_set arg = match _RelinkableQuoteHandleVectorVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableQuoteHandleVectorVector_to_array_f : c_obj list -> c_obj list = "_wrap_RelinkableQuoteHandleVectorVector_to_arrayQuantLib" ;;
let _RelinkableQuoteHandleVectorVector_to_array arg = match _RelinkableQuoteHandleVectorVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableQuoteHandleVectorVector_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableQuoteHandleVectorVectorQuantLib" ;;
let _delete_RelinkableQuoteHandleVectorVector arg = match _delete_RelinkableQuoteHandleVectorVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _nullInt_f : c_obj list -> c_obj list = "_wrap_nullIntQuantLib" ;;
let _nullInt arg = match _nullInt_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _nullDouble_f : c_obj list -> c_obj list = "_wrap_nullDoubleQuantLib" ;;
let _nullDouble arg = match _nullDouble_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_dayCount_f : c_obj list -> c_obj list = "_wrap_DayCounter_dayCountQuantLib" ;;
let _DayCounter_dayCount arg = match _DayCounter_dayCount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_yearFraction_f : c_obj list -> c_obj list = "_wrap_DayCounter_yearFraction__SWIG_0QuantLib" ;;
let _DayCounter_yearFraction arg = match _DayCounter_yearFraction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_yearFraction_f : c_obj list -> c_obj list = "_wrap_DayCounter_yearFraction__SWIG_1QuantLib" ;;
let _DayCounter_yearFraction arg = match _DayCounter_yearFraction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_yearFraction_f : c_obj list -> c_obj list = "_wrap_DayCounter_yearFractionQuantLib" ;;
let _DayCounter_yearFraction arg = match _DayCounter_yearFraction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter_name_f : c_obj list -> c_obj list = "_wrap_DayCounter_nameQuantLib" ;;
let _DayCounter_name arg = match _DayCounter_name_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DayCounter___str___f : c_obj list -> c_obj list = "_wrap_DayCounter___str__QuantLib" ;;
let _DayCounter___str__ arg = match _DayCounter___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DayCounter_f : c_obj list -> c_obj list = "_wrap_delete_DayCounterQuantLib" ;;
let _delete_DayCounter arg = match _delete_DayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Actual360_f : c_obj list -> c_obj list = "_wrap_new_Actual360QuantLib" ;;
let _new_Actual360 arg = match _new_Actual360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Actual360_f : c_obj list -> c_obj list = "_wrap_delete_Actual360QuantLib" ;;
let _delete_Actual360 arg = match _delete_Actual360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Actual365Fixed_f : c_obj list -> c_obj list = "_wrap_new_Actual365FixedQuantLib" ;;
let _new_Actual365Fixed arg = match _new_Actual365Fixed_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Actual365Fixed_f : c_obj list -> c_obj list = "_wrap_delete_Actual365FixedQuantLib" ;;
let _delete_Actual365Fixed arg = match _delete_Actual365Fixed_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Thirty360::Convention_marker" (`Convention)
external _USA : c_obj -> Swig.c_obj = "_wrap_USA" 
external _BondBasis : c_obj -> Swig.c_obj = "_wrap_BondBasis" 
external _European : c_obj -> Swig.c_obj = "_wrap_European" 
external _EurobondBasis : c_obj -> Swig.c_obj = "_wrap_EurobondBasis" 
external _Italian : c_obj -> Swig.c_obj = "_wrap_Italian" 
external _new_Thirty360_f : c_obj list -> c_obj list = "_wrap_new_Thirty360__SWIG_0QuantLib" ;;
let _new_Thirty360 arg = match _new_Thirty360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Thirty360_f : c_obj list -> c_obj list = "_wrap_new_Thirty360QuantLib" ;;
let _new_Thirty360 arg = match _new_Thirty360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Thirty360_f : c_obj list -> c_obj list = "_wrap_delete_Thirty360QuantLib" ;;
let _delete_Thirty360 arg = match _delete_Thirty360_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::ActualActual::Convention_marker" (`Convention)
external _ISMA : c_obj -> Swig.c_obj = "_wrap_ISMA" 
external _Bond : c_obj -> Swig.c_obj = "_wrap_Bond" 
external _ISDA : c_obj -> Swig.c_obj = "_wrap_ISDA" 
external _Historical : c_obj -> Swig.c_obj = "_wrap_Historical" 
external _Actual365 : c_obj -> Swig.c_obj = "_wrap_Actual365" 
external _AFB : c_obj -> Swig.c_obj = "_wrap_AFB" 
external _Euro : c_obj -> Swig.c_obj = "_wrap_Euro" 
external _new_ActualActual_f : c_obj list -> c_obj list = "_wrap_new_ActualActual__SWIG_0QuantLib" ;;
let _new_ActualActual arg = match _new_ActualActual_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ActualActual_f : c_obj list -> c_obj list = "_wrap_new_ActualActualQuantLib" ;;
let _new_ActualActual arg = match _new_ActualActual_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ActualActual_f : c_obj list -> c_obj list = "_wrap_delete_ActualActualQuantLib" ;;
let _delete_ActualActual arg = match _delete_ActualActual_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OneDayCounter_f : c_obj list -> c_obj list = "_wrap_new_OneDayCounterQuantLib" ;;
let _new_OneDayCounter arg = match _new_OneDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_OneDayCounter_f : c_obj list -> c_obj list = "_wrap_delete_OneDayCounterQuantLib" ;;
let _delete_OneDayCounter arg = match _delete_OneDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpleDayCounter_f : c_obj list -> c_obj list = "_wrap_new_SimpleDayCounterQuantLib" ;;
let _new_SimpleDayCounter arg = match _new_SimpleDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpleDayCounter_f : c_obj list -> c_obj list = "_wrap_delete_SimpleDayCounterQuantLib" ;;
let _delete_SimpleDayCounter arg = match _delete_SimpleDayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Business252_f : c_obj list -> c_obj list = "_wrap_new_Business252QuantLib" ;;
let _new_Business252 arg = match _new_Business252_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Business252_f : c_obj list -> c_obj list = "_wrap_delete_Business252QuantLib" ;;
let _delete_Business252 arg = match _delete_Business252_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Compounding_marker" (`Compounding)
external _Simple : c_obj -> Swig.c_obj = "_wrap_Simple" 
external _Compounded : c_obj -> Swig.c_obj = "_wrap_Compounded" 
external _Continuous : c_obj -> Swig.c_obj = "_wrap_Continuous" 
external _SimpleThenCompounded : c_obj -> Swig.c_obj = "_wrap_SimpleThenCompounded" 
external _new_InterestRate_f : c_obj list -> c_obj list = "_wrap_new_InterestRate__SWIG_0QuantLib" ;;
let _new_InterestRate arg = match _new_InterestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InterestRate_f : c_obj list -> c_obj list = "_wrap_new_InterestRateQuantLib" ;;
let _new_InterestRate arg = match _new_InterestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_rate_f : c_obj list -> c_obj list = "_wrap_InterestRate_rateQuantLib" ;;
let _InterestRate_rate arg = match _InterestRate_rate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_dayCounter_f : c_obj list -> c_obj list = "_wrap_InterestRate_dayCounterQuantLib" ;;
let _InterestRate_dayCounter arg = match _InterestRate_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compounding_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundingQuantLib" ;;
let _InterestRate_compounding arg = match _InterestRate_compounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_frequency_f : c_obj list -> c_obj list = "_wrap_InterestRate_frequencyQuantLib" ;;
let _InterestRate_frequency arg = match _InterestRate_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_discountFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_discountFactor__SWIG_0QuantLib" ;;
let _InterestRate_discountFactor arg = match _InterestRate_discountFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_discountFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_discountFactor__SWIG_1QuantLib" ;;
let _InterestRate_discountFactor arg = match _InterestRate_discountFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_discountFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_discountFactor__SWIG_2QuantLib" ;;
let _InterestRate_discountFactor arg = match _InterestRate_discountFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_discountFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_discountFactorQuantLib" ;;
let _InterestRate_discountFactor arg = match _InterestRate_discountFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compoundFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundFactor__SWIG_0QuantLib" ;;
let _InterestRate_compoundFactor arg = match _InterestRate_compoundFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compoundFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundFactor__SWIG_1QuantLib" ;;
let _InterestRate_compoundFactor arg = match _InterestRate_compoundFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compoundFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundFactor__SWIG_2QuantLib" ;;
let _InterestRate_compoundFactor arg = match _InterestRate_compoundFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_compoundFactor_f : c_obj list -> c_obj list = "_wrap_InterestRate_compoundFactorQuantLib" ;;
let _InterestRate_compoundFactor arg = match _InterestRate_compoundFactor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRate__SWIG_0QuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRate__SWIG_1QuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRate__SWIG_2QuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_impliedRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_impliedRateQuantLib" ;;
let _InterestRate_impliedRate arg = match _InterestRate_impliedRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRate__SWIG_0QuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRate__SWIG_1QuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRate__SWIG_2QuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate_equivalentRate_f : c_obj list -> c_obj list = "_wrap_InterestRate_equivalentRateQuantLib" ;;
let _InterestRate_equivalentRate arg = match _InterestRate_equivalentRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRate___str___f : c_obj list -> c_obj list = "_wrap_InterestRate___str__QuantLib" ;;
let _InterestRate___str__ arg = match _InterestRate___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InterestRate_f : c_obj list -> c_obj list = "_wrap_delete_InterestRateQuantLib" ;;
let _delete_InterestRate arg = match _delete_InterestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "BusinessDayConvention_marker" (`BusinessDayConvention)
external _Following : c_obj -> Swig.c_obj = "_wrap_Following" 
external _ModifiedFollowing : c_obj -> Swig.c_obj = "_wrap_ModifiedFollowing" 
external _Preceding : c_obj -> Swig.c_obj = "_wrap_Preceding" 
external _ModifiedPreceding : c_obj -> Swig.c_obj = "_wrap_ModifiedPreceding" 
external _Unadjusted : c_obj -> Swig.c_obj = "_wrap_Unadjusted" 
let _ = Callback.register "JointCalendarRule_marker" (`JointCalendarRule)
external _JoinHolidays : c_obj -> Swig.c_obj = "_wrap_JoinHolidays" 
external _JoinBusinessDays : c_obj -> Swig.c_obj = "_wrap_JoinBusinessDays" 
external _Calendar_isBusinessDay_f : c_obj list -> c_obj list = "_wrap_Calendar_isBusinessDayQuantLib" ;;
let _Calendar_isBusinessDay arg = match _Calendar_isBusinessDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_isHoliday_f : c_obj list -> c_obj list = "_wrap_Calendar_isHolidayQuantLib" ;;
let _Calendar_isHoliday arg = match _Calendar_isHoliday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_isEndOfMonth_f : c_obj list -> c_obj list = "_wrap_Calendar_isEndOfMonthQuantLib" ;;
let _Calendar_isEndOfMonth arg = match _Calendar_isEndOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_addHoliday_f : c_obj list -> c_obj list = "_wrap_Calendar_addHolidayQuantLib" ;;
let _Calendar_addHoliday arg = match _Calendar_addHoliday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_removeHoliday_f : c_obj list -> c_obj list = "_wrap_Calendar_removeHolidayQuantLib" ;;
let _Calendar_removeHoliday arg = match _Calendar_removeHoliday_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_adjust_f : c_obj list -> c_obj list = "_wrap_Calendar_adjust__SWIG_0QuantLib" ;;
let _Calendar_adjust arg = match _Calendar_adjust_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_adjust_f : c_obj list -> c_obj list = "_wrap_Calendar_adjustQuantLib" ;;
let _Calendar_adjust arg = match _Calendar_adjust_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_0QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_1QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_2QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_3QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advance__SWIG_4QuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_advance_f : c_obj list -> c_obj list = "_wrap_Calendar_advanceQuantLib" ;;
let _Calendar_advance arg = match _Calendar_advance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_businessDaysBetween_f : c_obj list -> c_obj list = "_wrap_Calendar_businessDaysBetween__SWIG_0QuantLib" ;;
let _Calendar_businessDaysBetween arg = match _Calendar_businessDaysBetween_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_businessDaysBetween_f : c_obj list -> c_obj list = "_wrap_Calendar_businessDaysBetween__SWIG_1QuantLib" ;;
let _Calendar_businessDaysBetween arg = match _Calendar_businessDaysBetween_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_businessDaysBetween_f : c_obj list -> c_obj list = "_wrap_Calendar_businessDaysBetweenQuantLib" ;;
let _Calendar_businessDaysBetween arg = match _Calendar_businessDaysBetween_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar_name_f : c_obj list -> c_obj list = "_wrap_Calendar_nameQuantLib" ;;
let _Calendar_name arg = match _Calendar_name_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Calendar___str___f : c_obj list -> c_obj list = "_wrap_Calendar___str__QuantLib" ;;
let _Calendar___str__ arg = match _Calendar___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Calendar_f : c_obj list -> c_obj list = "_wrap_delete_CalendarQuantLib" ;;
let _delete_Calendar arg = match _delete_Calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Argentina::Market_marker" (`Market)
external _Merval : c_obj -> Swig.c_obj = "_wrap_Merval" 
external _new_Argentina_f : c_obj list -> c_obj list = "_wrap_new_Argentina__SWIG_0QuantLib" ;;
let _new_Argentina arg = match _new_Argentina_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Argentina_f : c_obj list -> c_obj list = "_wrap_new_ArgentinaQuantLib" ;;
let _new_Argentina arg = match _new_Argentina_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Argentina_f : c_obj list -> c_obj list = "_wrap_delete_ArgentinaQuantLib" ;;
let _delete_Argentina arg = match _delete_Argentina_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Australia_f : c_obj list -> c_obj list = "_wrap_new_AustraliaQuantLib" ;;
let _new_Australia arg = match _new_Australia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Australia_f : c_obj list -> c_obj list = "_wrap_delete_AustraliaQuantLib" ;;
let _delete_Australia arg = match _delete_Australia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Brazil::Market_marker" (`Market)
external _Settlement : c_obj -> Swig.c_obj = "_wrap_Settlement" 
external _Exchange : c_obj -> Swig.c_obj = "_wrap_Exchange" 
external _new_Brazil_f : c_obj list -> c_obj list = "_wrap_new_Brazil__SWIG_0QuantLib" ;;
let _new_Brazil arg = match _new_Brazil_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Brazil_f : c_obj list -> c_obj list = "_wrap_new_BrazilQuantLib" ;;
let _new_Brazil arg = match _new_Brazil_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Brazil_f : c_obj list -> c_obj list = "_wrap_delete_BrazilQuantLib" ;;
let _delete_Brazil arg = match _delete_Brazil_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Canada::Market_marker" (`Market)
external _TSX : c_obj -> Swig.c_obj = "_wrap_TSX" 
external _new_Canada_f : c_obj list -> c_obj list = "_wrap_new_Canada__SWIG_0QuantLib" ;;
let _new_Canada arg = match _new_Canada_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Canada_f : c_obj list -> c_obj list = "_wrap_new_CanadaQuantLib" ;;
let _new_Canada arg = match _new_Canada_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Canada_f : c_obj list -> c_obj list = "_wrap_delete_CanadaQuantLib" ;;
let _delete_Canada arg = match _delete_Canada_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_China_f : c_obj list -> c_obj list = "_wrap_new_ChinaQuantLib" ;;
let _new_China arg = match _new_China_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_China_f : c_obj list -> c_obj list = "_wrap_delete_ChinaQuantLib" ;;
let _delete_China arg = match _delete_China_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::CzechRepublic::Market_marker" (`Market)
external _PSE : c_obj -> Swig.c_obj = "_wrap_PSE" 
external _new_CzechRepublic_f : c_obj list -> c_obj list = "_wrap_new_CzechRepublic__SWIG_0QuantLib" ;;
let _new_CzechRepublic arg = match _new_CzechRepublic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CzechRepublic_f : c_obj list -> c_obj list = "_wrap_new_CzechRepublicQuantLib" ;;
let _new_CzechRepublic arg = match _new_CzechRepublic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CzechRepublic_f : c_obj list -> c_obj list = "_wrap_delete_CzechRepublicQuantLib" ;;
let _delete_CzechRepublic arg = match _delete_CzechRepublic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Denmark_f : c_obj list -> c_obj list = "_wrap_new_DenmarkQuantLib" ;;
let _new_Denmark arg = match _new_Denmark_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Denmark_f : c_obj list -> c_obj list = "_wrap_delete_DenmarkQuantLib" ;;
let _delete_Denmark arg = match _delete_Denmark_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Finland_f : c_obj list -> c_obj list = "_wrap_new_FinlandQuantLib" ;;
let _new_Finland arg = match _new_Finland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Finland_f : c_obj list -> c_obj list = "_wrap_delete_FinlandQuantLib" ;;
let _delete_Finland arg = match _delete_Finland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Germany::Market_marker" (`Market)
external _FrankfurtStockExchange : c_obj -> Swig.c_obj = "_wrap_FrankfurtStockExchange" 
external _Xetra : c_obj -> Swig.c_obj = "_wrap_Xetra" 
external _Eurex : c_obj -> Swig.c_obj = "_wrap_Eurex" 
external _new_Germany_f : c_obj list -> c_obj list = "_wrap_new_Germany__SWIG_0QuantLib" ;;
let _new_Germany arg = match _new_Germany_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Germany_f : c_obj list -> c_obj list = "_wrap_new_GermanyQuantLib" ;;
let _new_Germany arg = match _new_Germany_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Germany_f : c_obj list -> c_obj list = "_wrap_delete_GermanyQuantLib" ;;
let _delete_Germany arg = match _delete_Germany_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::HongKong::Market_marker" (`Market)
external _HKEx : c_obj -> Swig.c_obj = "_wrap_HKEx" 
external _new_HongKong_f : c_obj list -> c_obj list = "_wrap_new_HongKong__SWIG_0QuantLib" ;;
let _new_HongKong arg = match _new_HongKong_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HongKong_f : c_obj list -> c_obj list = "_wrap_new_HongKongQuantLib" ;;
let _new_HongKong arg = match _new_HongKong_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HongKong_f : c_obj list -> c_obj list = "_wrap_delete_HongKongQuantLib" ;;
let _delete_HongKong arg = match _delete_HongKong_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Hungary_f : c_obj list -> c_obj list = "_wrap_new_HungaryQuantLib" ;;
let _new_Hungary arg = match _new_Hungary_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Hungary_f : c_obj list -> c_obj list = "_wrap_delete_HungaryQuantLib" ;;
let _delete_Hungary arg = match _delete_Hungary_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Iceland::Market_marker" (`Market)
external _ICEX : c_obj -> Swig.c_obj = "_wrap_ICEX" 
external _new_Iceland_f : c_obj list -> c_obj list = "_wrap_new_Iceland__SWIG_0QuantLib" ;;
let _new_Iceland arg = match _new_Iceland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Iceland_f : c_obj list -> c_obj list = "_wrap_new_IcelandQuantLib" ;;
let _new_Iceland arg = match _new_Iceland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Iceland_f : c_obj list -> c_obj list = "_wrap_delete_IcelandQuantLib" ;;
let _delete_Iceland arg = match _delete_Iceland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::India::Market_marker" (`Market)
external _NSE : c_obj -> Swig.c_obj = "_wrap_NSE" 
external _new_India_f : c_obj list -> c_obj list = "_wrap_new_India__SWIG_0QuantLib" ;;
let _new_India arg = match _new_India_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_India_f : c_obj list -> c_obj list = "_wrap_new_IndiaQuantLib" ;;
let _new_India arg = match _new_India_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_India_f : c_obj list -> c_obj list = "_wrap_delete_IndiaQuantLib" ;;
let _delete_India arg = match _delete_India_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Indonesia::Market_marker" (`Market)
external _BEJ : c_obj -> Swig.c_obj = "_wrap_BEJ" 
external _JSX : c_obj -> Swig.c_obj = "_wrap_JSX" 
external _new_Indonesia_f : c_obj list -> c_obj list = "_wrap_new_Indonesia__SWIG_0QuantLib" ;;
let _new_Indonesia arg = match _new_Indonesia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Indonesia_f : c_obj list -> c_obj list = "_wrap_new_IndonesiaQuantLib" ;;
let _new_Indonesia arg = match _new_Indonesia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Indonesia_f : c_obj list -> c_obj list = "_wrap_delete_IndonesiaQuantLib" ;;
let _delete_Indonesia arg = match _delete_Indonesia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Italy::Market_marker" (`Market)
external _new_Italy_f : c_obj list -> c_obj list = "_wrap_new_Italy__SWIG_0QuantLib" ;;
let _new_Italy arg = match _new_Italy_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Italy_f : c_obj list -> c_obj list = "_wrap_new_ItalyQuantLib" ;;
let _new_Italy arg = match _new_Italy_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Italy_f : c_obj list -> c_obj list = "_wrap_delete_ItalyQuantLib" ;;
let _delete_Italy arg = match _delete_Italy_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Japan_f : c_obj list -> c_obj list = "_wrap_new_JapanQuantLib" ;;
let _new_Japan arg = match _new_Japan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Japan_f : c_obj list -> c_obj list = "_wrap_delete_JapanQuantLib" ;;
let _delete_Japan arg = match _delete_Japan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Mexico::Market_marker" (`Market)
external _BMV : c_obj -> Swig.c_obj = "_wrap_BMV" 
external _new_Mexico_f : c_obj list -> c_obj list = "_wrap_new_Mexico__SWIG_0QuantLib" ;;
let _new_Mexico arg = match _new_Mexico_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Mexico_f : c_obj list -> c_obj list = "_wrap_new_MexicoQuantLib" ;;
let _new_Mexico arg = match _new_Mexico_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Mexico_f : c_obj list -> c_obj list = "_wrap_delete_MexicoQuantLib" ;;
let _delete_Mexico arg = match _delete_Mexico_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NewZealand_f : c_obj list -> c_obj list = "_wrap_new_NewZealandQuantLib" ;;
let _new_NewZealand arg = match _new_NewZealand_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NewZealand_f : c_obj list -> c_obj list = "_wrap_delete_NewZealandQuantLib" ;;
let _delete_NewZealand arg = match _delete_NewZealand_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Norway_f : c_obj list -> c_obj list = "_wrap_new_NorwayQuantLib" ;;
let _new_Norway arg = match _new_Norway_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Norway_f : c_obj list -> c_obj list = "_wrap_delete_NorwayQuantLib" ;;
let _delete_Norway arg = match _delete_Norway_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Poland_f : c_obj list -> c_obj list = "_wrap_new_PolandQuantLib" ;;
let _new_Poland arg = match _new_Poland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Poland_f : c_obj list -> c_obj list = "_wrap_delete_PolandQuantLib" ;;
let _delete_Poland arg = match _delete_Poland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Russia_f : c_obj list -> c_obj list = "_wrap_new_RussiaQuantLib" ;;
let _new_Russia arg = match _new_Russia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Russia_f : c_obj list -> c_obj list = "_wrap_delete_RussiaQuantLib" ;;
let _delete_Russia arg = match _delete_Russia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::SaudiArabia::Market_marker" (`Market)
external _Tadawul : c_obj -> Swig.c_obj = "_wrap_Tadawul" 
external _new_SaudiArabia_f : c_obj list -> c_obj list = "_wrap_new_SaudiArabia__SWIG_0QuantLib" ;;
let _new_SaudiArabia arg = match _new_SaudiArabia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SaudiArabia_f : c_obj list -> c_obj list = "_wrap_new_SaudiArabiaQuantLib" ;;
let _new_SaudiArabia arg = match _new_SaudiArabia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SaudiArabia_f : c_obj list -> c_obj list = "_wrap_delete_SaudiArabiaQuantLib" ;;
let _delete_SaudiArabia arg = match _delete_SaudiArabia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Singapore::Market_marker" (`Market)
external _SGX : c_obj -> Swig.c_obj = "_wrap_SGX" 
external _new_Singapore_f : c_obj list -> c_obj list = "_wrap_new_Singapore__SWIG_0QuantLib" ;;
let _new_Singapore arg = match _new_Singapore_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Singapore_f : c_obj list -> c_obj list = "_wrap_new_SingaporeQuantLib" ;;
let _new_Singapore arg = match _new_Singapore_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Singapore_f : c_obj list -> c_obj list = "_wrap_delete_SingaporeQuantLib" ;;
let _delete_Singapore arg = match _delete_Singapore_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Slovakia::Market_marker" (`Market)
external _BSSE : c_obj -> Swig.c_obj = "_wrap_BSSE" 
external _new_Slovakia_f : c_obj list -> c_obj list = "_wrap_new_Slovakia__SWIG_0QuantLib" ;;
let _new_Slovakia arg = match _new_Slovakia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Slovakia_f : c_obj list -> c_obj list = "_wrap_new_SlovakiaQuantLib" ;;
let _new_Slovakia arg = match _new_Slovakia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Slovakia_f : c_obj list -> c_obj list = "_wrap_delete_SlovakiaQuantLib" ;;
let _delete_Slovakia arg = match _delete_Slovakia_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SouthAfrica_f : c_obj list -> c_obj list = "_wrap_new_SouthAfricaQuantLib" ;;
let _new_SouthAfrica arg = match _new_SouthAfrica_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SouthAfrica_f : c_obj list -> c_obj list = "_wrap_delete_SouthAfricaQuantLib" ;;
let _delete_SouthAfrica arg = match _delete_SouthAfrica_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::SouthKorea::Market_marker" (`Market)
external _KRX : c_obj -> Swig.c_obj = "_wrap_KRX" 
external _new_SouthKorea_f : c_obj list -> c_obj list = "_wrap_new_SouthKorea__SWIG_0QuantLib" ;;
let _new_SouthKorea arg = match _new_SouthKorea_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SouthKorea_f : c_obj list -> c_obj list = "_wrap_new_SouthKoreaQuantLib" ;;
let _new_SouthKorea arg = match _new_SouthKorea_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SouthKorea_f : c_obj list -> c_obj list = "_wrap_delete_SouthKoreaQuantLib" ;;
let _delete_SouthKorea arg = match _delete_SouthKorea_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Sweden_f : c_obj list -> c_obj list = "_wrap_new_SwedenQuantLib" ;;
let _new_Sweden arg = match _new_Sweden_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Sweden_f : c_obj list -> c_obj list = "_wrap_delete_SwedenQuantLib" ;;
let _delete_Sweden arg = match _delete_Sweden_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Switzerland_f : c_obj list -> c_obj list = "_wrap_new_SwitzerlandQuantLib" ;;
let _new_Switzerland arg = match _new_Switzerland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Switzerland_f : c_obj list -> c_obj list = "_wrap_delete_SwitzerlandQuantLib" ;;
let _delete_Switzerland arg = match _delete_Switzerland_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Taiwan::Market_marker" (`Market)
external _TSEC : c_obj -> Swig.c_obj = "_wrap_TSEC" 
external _new_Taiwan_f : c_obj list -> c_obj list = "_wrap_new_Taiwan__SWIG_0QuantLib" ;;
let _new_Taiwan arg = match _new_Taiwan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Taiwan_f : c_obj list -> c_obj list = "_wrap_new_TaiwanQuantLib" ;;
let _new_Taiwan arg = match _new_Taiwan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Taiwan_f : c_obj list -> c_obj list = "_wrap_delete_TaiwanQuantLib" ;;
let _delete_Taiwan arg = match _delete_Taiwan_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TARGET_f : c_obj list -> c_obj list = "_wrap_new_TARGETQuantLib" ;;
let _new_TARGET arg = match _new_TARGET_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TARGET_f : c_obj list -> c_obj list = "_wrap_delete_TARGETQuantLib" ;;
let _delete_TARGET arg = match _delete_TARGET_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Turkey_f : c_obj list -> c_obj list = "_wrap_new_TurkeyQuantLib" ;;
let _new_Turkey arg = match _new_Turkey_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Turkey_f : c_obj list -> c_obj list = "_wrap_delete_TurkeyQuantLib" ;;
let _delete_Turkey arg = match _delete_Turkey_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::Ukraine::Market_marker" (`Market)
external _USE : c_obj -> Swig.c_obj = "_wrap_USE" 
external _new_Ukraine_f : c_obj list -> c_obj list = "_wrap_new_Ukraine__SWIG_0QuantLib" ;;
let _new_Ukraine arg = match _new_Ukraine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Ukraine_f : c_obj list -> c_obj list = "_wrap_new_UkraineQuantLib" ;;
let _new_Ukraine arg = match _new_Ukraine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Ukraine_f : c_obj list -> c_obj list = "_wrap_delete_UkraineQuantLib" ;;
let _delete_Ukraine arg = match _delete_Ukraine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::UnitedKingdom::Market_marker" (`Market)
external _Metals : c_obj -> Swig.c_obj = "_wrap_Metals" 
external _new_UnitedKingdom_f : c_obj list -> c_obj list = "_wrap_new_UnitedKingdom__SWIG_0QuantLib" ;;
let _new_UnitedKingdom arg = match _new_UnitedKingdom_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnitedKingdom_f : c_obj list -> c_obj list = "_wrap_new_UnitedKingdomQuantLib" ;;
let _new_UnitedKingdom arg = match _new_UnitedKingdom_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UnitedKingdom_f : c_obj list -> c_obj list = "_wrap_delete_UnitedKingdomQuantLib" ;;
let _delete_UnitedKingdom arg = match _delete_UnitedKingdom_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "QuantLib::UnitedStates::Market_marker" (`Market)
external _NYSE : c_obj -> Swig.c_obj = "_wrap_NYSE" 
external _GovernmentBond : c_obj -> Swig.c_obj = "_wrap_GovernmentBond" 
external _NERC : c_obj -> Swig.c_obj = "_wrap_NERC" 
external _new_UnitedStates_f : c_obj list -> c_obj list = "_wrap_new_UnitedStates__SWIG_0QuantLib" ;;
let _new_UnitedStates arg = match _new_UnitedStates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UnitedStates_f : c_obj list -> c_obj list = "_wrap_new_UnitedStatesQuantLib" ;;
let _new_UnitedStates arg = match _new_UnitedStates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UnitedStates_f : c_obj list -> c_obj list = "_wrap_delete_UnitedStatesQuantLib" ;;
let _delete_UnitedStates arg = match _delete_UnitedStates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NullCalendar_f : c_obj list -> c_obj list = "_wrap_new_NullCalendarQuantLib" ;;
let _new_NullCalendar arg = match _new_NullCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NullCalendar_f : c_obj list -> c_obj list = "_wrap_delete_NullCalendarQuantLib" ;;
let _delete_NullCalendar arg = match _delete_NullCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_WeekendsOnly_f : c_obj list -> c_obj list = "_wrap_new_WeekendsOnlyQuantLib" ;;
let _new_WeekendsOnly arg = match _new_WeekendsOnly_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_WeekendsOnly_f : c_obj list -> c_obj list = "_wrap_delete_WeekendsOnlyQuantLib" ;;
let _delete_WeekendsOnly arg = match _delete_WeekendsOnly_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_0QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_1QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_2QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_3QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendar__SWIG_4QuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JointCalendar_f : c_obj list -> c_obj list = "_wrap_new_JointCalendarQuantLib" ;;
let _new_JointCalendar arg = match _new_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_JointCalendar_f : c_obj list -> c_obj list = "_wrap_delete_JointCalendarQuantLib" ;;
let _delete_JointCalendar arg = match _delete_JointCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BespokeCalendar_f : c_obj list -> c_obj list = "_wrap_new_BespokeCalendarQuantLib" ;;
let _new_BespokeCalendar arg = match _new_BespokeCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BespokeCalendar_addWeekend_f : c_obj list -> c_obj list = "_wrap_BespokeCalendar_addWeekendQuantLib" ;;
let _BespokeCalendar_addWeekend arg = match _BespokeCalendar_addWeekend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BespokeCalendar_f : c_obj list -> c_obj list = "_wrap_delete_BespokeCalendarQuantLib" ;;
let _delete_BespokeCalendar arg = match _delete_BespokeCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Rounding_f : c_obj list -> c_obj list = "_wrap_new_RoundingQuantLib" ;;
let _new_Rounding arg = match _new_Rounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Rounding_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_Rounding_operator_pP___QuantLib" ;;
let _Rounding_operator_xx_xx_lparen_xx_rparen arg = match _Rounding_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Rounding_f : c_obj list -> c_obj list = "_wrap_delete_RoundingQuantLib" ;;
let _delete_Rounding arg = match _delete_Rounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpRounding_f : c_obj list -> c_obj list = "_wrap_new_UpRounding__SWIG_0QuantLib" ;;
let _new_UpRounding arg = match _new_UpRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpRounding_f : c_obj list -> c_obj list = "_wrap_new_UpRoundingQuantLib" ;;
let _new_UpRounding arg = match _new_UpRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UpRounding_f : c_obj list -> c_obj list = "_wrap_delete_UpRoundingQuantLib" ;;
let _delete_UpRounding arg = match _delete_UpRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DownRounding_f : c_obj list -> c_obj list = "_wrap_new_DownRounding__SWIG_0QuantLib" ;;
let _new_DownRounding arg = match _new_DownRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DownRounding_f : c_obj list -> c_obj list = "_wrap_new_DownRoundingQuantLib" ;;
let _new_DownRounding arg = match _new_DownRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DownRounding_f : c_obj list -> c_obj list = "_wrap_delete_DownRoundingQuantLib" ;;
let _delete_DownRounding arg = match _delete_DownRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ClosestRounding_f : c_obj list -> c_obj list = "_wrap_new_ClosestRounding__SWIG_0QuantLib" ;;
let _new_ClosestRounding arg = match _new_ClosestRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ClosestRounding_f : c_obj list -> c_obj list = "_wrap_new_ClosestRoundingQuantLib" ;;
let _new_ClosestRounding arg = match _new_ClosestRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ClosestRounding_f : c_obj list -> c_obj list = "_wrap_delete_ClosestRoundingQuantLib" ;;
let _delete_ClosestRounding arg = match _delete_ClosestRounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CeilingTruncation_f : c_obj list -> c_obj list = "_wrap_new_CeilingTruncation__SWIG_0QuantLib" ;;
let _new_CeilingTruncation arg = match _new_CeilingTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CeilingTruncation_f : c_obj list -> c_obj list = "_wrap_new_CeilingTruncationQuantLib" ;;
let _new_CeilingTruncation arg = match _new_CeilingTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CeilingTruncation_f : c_obj list -> c_obj list = "_wrap_delete_CeilingTruncationQuantLib" ;;
let _delete_CeilingTruncation arg = match _delete_CeilingTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloorTruncation_f : c_obj list -> c_obj list = "_wrap_new_FloorTruncation__SWIG_0QuantLib" ;;
let _new_FloorTruncation arg = match _new_FloorTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloorTruncation_f : c_obj list -> c_obj list = "_wrap_new_FloorTruncationQuantLib" ;;
let _new_FloorTruncation arg = match _new_FloorTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FloorTruncation_f : c_obj list -> c_obj list = "_wrap_delete_FloorTruncationQuantLib" ;;
let _delete_FloorTruncation arg = match _delete_FloorTruncation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_name_f : c_obj list -> c_obj list = "_wrap_Currency_nameQuantLib" ;;
let _Currency_name arg = match _Currency_name_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_code_f : c_obj list -> c_obj list = "_wrap_Currency_codeQuantLib" ;;
let _Currency_code arg = match _Currency_code_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_numericCode_f : c_obj list -> c_obj list = "_wrap_Currency_numericCodeQuantLib" ;;
let _Currency_numericCode arg = match _Currency_numericCode_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_symbol_f : c_obj list -> c_obj list = "_wrap_Currency_symbolQuantLib" ;;
let _Currency_symbol arg = match _Currency_symbol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_fractionSymbol_f : c_obj list -> c_obj list = "_wrap_Currency_fractionSymbolQuantLib" ;;
let _Currency_fractionSymbol arg = match _Currency_fractionSymbol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_fractionsPerUnit_f : c_obj list -> c_obj list = "_wrap_Currency_fractionsPerUnitQuantLib" ;;
let _Currency_fractionsPerUnit arg = match _Currency_fractionsPerUnit_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_rounding_f : c_obj list -> c_obj list = "_wrap_Currency_roundingQuantLib" ;;
let _Currency_rounding arg = match _Currency_rounding_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_format_f : c_obj list -> c_obj list = "_wrap_Currency_formatQuantLib" ;;
let _Currency_format arg = match _Currency_format_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_empty_f : c_obj list -> c_obj list = "_wrap_Currency_emptyQuantLib" ;;
let _Currency_empty arg = match _Currency_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency_triangulationCurrency_f : c_obj list -> c_obj list = "_wrap_Currency_triangulationCurrencyQuantLib" ;;
let _Currency_triangulationCurrency arg = match _Currency_triangulationCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Currency___str___f : c_obj list -> c_obj list = "_wrap_Currency___str__QuantLib" ;;
let _Currency___str__ arg = match _Currency___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Currency_f : c_obj list -> c_obj list = "_wrap_new_CurrencyQuantLib" ;;
let _new_Currency arg = match _new_Currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Currency_f : c_obj list -> c_obj list = "_wrap_delete_CurrencyQuantLib" ;;
let _delete_Currency arg = match _delete_Currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ARSCurrency_f : c_obj list -> c_obj list = "_wrap_new_ARSCurrencyQuantLib" ;;
let _new_ARSCurrency arg = match _new_ARSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ARSCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ARSCurrencyQuantLib" ;;
let _delete_ARSCurrency arg = match _delete_ARSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ATSCurrency_f : c_obj list -> c_obj list = "_wrap_new_ATSCurrencyQuantLib" ;;
let _new_ATSCurrency arg = match _new_ATSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ATSCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ATSCurrencyQuantLib" ;;
let _delete_ATSCurrency arg = match _delete_ATSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AUDCurrency_f : c_obj list -> c_obj list = "_wrap_new_AUDCurrencyQuantLib" ;;
let _new_AUDCurrency arg = match _new_AUDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AUDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_AUDCurrencyQuantLib" ;;
let _delete_AUDCurrency arg = match _delete_AUDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BDTCurrency_f : c_obj list -> c_obj list = "_wrap_new_BDTCurrencyQuantLib" ;;
let _new_BDTCurrency arg = match _new_BDTCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BDTCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BDTCurrencyQuantLib" ;;
let _delete_BDTCurrency arg = match _delete_BDTCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BEFCurrency_f : c_obj list -> c_obj list = "_wrap_new_BEFCurrencyQuantLib" ;;
let _new_BEFCurrency arg = match _new_BEFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BEFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BEFCurrencyQuantLib" ;;
let _delete_BEFCurrency arg = match _delete_BEFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BGLCurrency_f : c_obj list -> c_obj list = "_wrap_new_BGLCurrencyQuantLib" ;;
let _new_BGLCurrency arg = match _new_BGLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BGLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BGLCurrencyQuantLib" ;;
let _delete_BGLCurrency arg = match _delete_BGLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BRLCurrency_f : c_obj list -> c_obj list = "_wrap_new_BRLCurrencyQuantLib" ;;
let _new_BRLCurrency arg = match _new_BRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BRLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BRLCurrencyQuantLib" ;;
let _delete_BRLCurrency arg = match _delete_BRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BYRCurrency_f : c_obj list -> c_obj list = "_wrap_new_BYRCurrencyQuantLib" ;;
let _new_BYRCurrency arg = match _new_BYRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BYRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_BYRCurrencyQuantLib" ;;
let _delete_BYRCurrency arg = match _delete_BYRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CADCurrency_f : c_obj list -> c_obj list = "_wrap_new_CADCurrencyQuantLib" ;;
let _new_CADCurrency arg = match _new_CADCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CADCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CADCurrencyQuantLib" ;;
let _delete_CADCurrency arg = match _delete_CADCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CHFCurrency_f : c_obj list -> c_obj list = "_wrap_new_CHFCurrencyQuantLib" ;;
let _new_CHFCurrency arg = match _new_CHFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CHFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CHFCurrencyQuantLib" ;;
let _delete_CHFCurrency arg = match _delete_CHFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CLPCurrency_f : c_obj list -> c_obj list = "_wrap_new_CLPCurrencyQuantLib" ;;
let _new_CLPCurrency arg = match _new_CLPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CLPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CLPCurrencyQuantLib" ;;
let _delete_CLPCurrency arg = match _delete_CLPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CNYCurrency_f : c_obj list -> c_obj list = "_wrap_new_CNYCurrencyQuantLib" ;;
let _new_CNYCurrency arg = match _new_CNYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CNYCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CNYCurrencyQuantLib" ;;
let _delete_CNYCurrency arg = match _delete_CNYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_COPCurrency_f : c_obj list -> c_obj list = "_wrap_new_COPCurrencyQuantLib" ;;
let _new_COPCurrency arg = match _new_COPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_COPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_COPCurrencyQuantLib" ;;
let _delete_COPCurrency arg = match _delete_COPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CYPCurrency_f : c_obj list -> c_obj list = "_wrap_new_CYPCurrencyQuantLib" ;;
let _new_CYPCurrency arg = match _new_CYPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CYPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CYPCurrencyQuantLib" ;;
let _delete_CYPCurrency arg = match _delete_CYPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CZKCurrency_f : c_obj list -> c_obj list = "_wrap_new_CZKCurrencyQuantLib" ;;
let _new_CZKCurrency arg = match _new_CZKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CZKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_CZKCurrencyQuantLib" ;;
let _delete_CZKCurrency arg = match _delete_CZKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DEMCurrency_f : c_obj list -> c_obj list = "_wrap_new_DEMCurrencyQuantLib" ;;
let _new_DEMCurrency arg = match _new_DEMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DEMCurrency_f : c_obj list -> c_obj list = "_wrap_delete_DEMCurrencyQuantLib" ;;
let _delete_DEMCurrency arg = match _delete_DEMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DKKCurrency_f : c_obj list -> c_obj list = "_wrap_new_DKKCurrencyQuantLib" ;;
let _new_DKKCurrency arg = match _new_DKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DKKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_DKKCurrencyQuantLib" ;;
let _delete_DKKCurrency arg = match _delete_DKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EEKCurrency_f : c_obj list -> c_obj list = "_wrap_new_EEKCurrencyQuantLib" ;;
let _new_EEKCurrency arg = match _new_EEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EEKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_EEKCurrencyQuantLib" ;;
let _delete_EEKCurrency arg = match _delete_EEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ESPCurrency_f : c_obj list -> c_obj list = "_wrap_new_ESPCurrencyQuantLib" ;;
let _new_ESPCurrency arg = match _new_ESPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ESPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ESPCurrencyQuantLib" ;;
let _delete_ESPCurrency arg = match _delete_ESPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURCurrency_f : c_obj list -> c_obj list = "_wrap_new_EURCurrencyQuantLib" ;;
let _new_EURCurrency arg = match _new_EURCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURCurrency_f : c_obj list -> c_obj list = "_wrap_delete_EURCurrencyQuantLib" ;;
let _delete_EURCurrency arg = match _delete_EURCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FIMCurrency_f : c_obj list -> c_obj list = "_wrap_new_FIMCurrencyQuantLib" ;;
let _new_FIMCurrency arg = match _new_FIMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FIMCurrency_f : c_obj list -> c_obj list = "_wrap_delete_FIMCurrencyQuantLib" ;;
let _delete_FIMCurrency arg = match _delete_FIMCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FRFCurrency_f : c_obj list -> c_obj list = "_wrap_new_FRFCurrencyQuantLib" ;;
let _new_FRFCurrency arg = match _new_FRFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FRFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_FRFCurrencyQuantLib" ;;
let _delete_FRFCurrency arg = match _delete_FRFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GBPCurrency_f : c_obj list -> c_obj list = "_wrap_new_GBPCurrencyQuantLib" ;;
let _new_GBPCurrency arg = match _new_GBPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GBPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_GBPCurrencyQuantLib" ;;
let _delete_GBPCurrency arg = match _delete_GBPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GRDCurrency_f : c_obj list -> c_obj list = "_wrap_new_GRDCurrencyQuantLib" ;;
let _new_GRDCurrency arg = match _new_GRDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GRDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_GRDCurrencyQuantLib" ;;
let _delete_GRDCurrency arg = match _delete_GRDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HKDCurrency_f : c_obj list -> c_obj list = "_wrap_new_HKDCurrencyQuantLib" ;;
let _new_HKDCurrency arg = match _new_HKDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HKDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_HKDCurrencyQuantLib" ;;
let _delete_HKDCurrency arg = match _delete_HKDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HUFCurrency_f : c_obj list -> c_obj list = "_wrap_new_HUFCurrencyQuantLib" ;;
let _new_HUFCurrency arg = match _new_HUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HUFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_HUFCurrencyQuantLib" ;;
let _delete_HUFCurrency arg = match _delete_HUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IEPCurrency_f : c_obj list -> c_obj list = "_wrap_new_IEPCurrencyQuantLib" ;;
let _new_IEPCurrency arg = match _new_IEPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IEPCurrency_f : c_obj list -> c_obj list = "_wrap_delete_IEPCurrencyQuantLib" ;;
let _delete_IEPCurrency arg = match _delete_IEPCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ILSCurrency_f : c_obj list -> c_obj list = "_wrap_new_ILSCurrencyQuantLib" ;;
let _new_ILSCurrency arg = match _new_ILSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ILSCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ILSCurrencyQuantLib" ;;
let _delete_ILSCurrency arg = match _delete_ILSCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_INRCurrency_f : c_obj list -> c_obj list = "_wrap_new_INRCurrencyQuantLib" ;;
let _new_INRCurrency arg = match _new_INRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_INRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_INRCurrencyQuantLib" ;;
let _delete_INRCurrency arg = match _delete_INRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IQDCurrency_f : c_obj list -> c_obj list = "_wrap_new_IQDCurrencyQuantLib" ;;
let _new_IQDCurrency arg = match _new_IQDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IQDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_IQDCurrencyQuantLib" ;;
let _delete_IQDCurrency arg = match _delete_IQDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IRRCurrency_f : c_obj list -> c_obj list = "_wrap_new_IRRCurrencyQuantLib" ;;
let _new_IRRCurrency arg = match _new_IRRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IRRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_IRRCurrencyQuantLib" ;;
let _delete_IRRCurrency arg = match _delete_IRRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ISKCurrency_f : c_obj list -> c_obj list = "_wrap_new_ISKCurrencyQuantLib" ;;
let _new_ISKCurrency arg = match _new_ISKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ISKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ISKCurrencyQuantLib" ;;
let _delete_ISKCurrency arg = match _delete_ISKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ITLCurrency_f : c_obj list -> c_obj list = "_wrap_new_ITLCurrencyQuantLib" ;;
let _new_ITLCurrency arg = match _new_ITLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ITLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ITLCurrencyQuantLib" ;;
let _delete_ITLCurrency arg = match _delete_ITLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JPYCurrency_f : c_obj list -> c_obj list = "_wrap_new_JPYCurrencyQuantLib" ;;
let _new_JPYCurrency arg = match _new_JPYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_JPYCurrency_f : c_obj list -> c_obj list = "_wrap_delete_JPYCurrencyQuantLib" ;;
let _delete_JPYCurrency arg = match _delete_JPYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KRWCurrency_f : c_obj list -> c_obj list = "_wrap_new_KRWCurrencyQuantLib" ;;
let _new_KRWCurrency arg = match _new_KRWCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KRWCurrency_f : c_obj list -> c_obj list = "_wrap_delete_KRWCurrencyQuantLib" ;;
let _delete_KRWCurrency arg = match _delete_KRWCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KWDCurrency_f : c_obj list -> c_obj list = "_wrap_new_KWDCurrencyQuantLib" ;;
let _new_KWDCurrency arg = match _new_KWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KWDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_KWDCurrencyQuantLib" ;;
let _delete_KWDCurrency arg = match _delete_KWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LTLCurrency_f : c_obj list -> c_obj list = "_wrap_new_LTLCurrencyQuantLib" ;;
let _new_LTLCurrency arg = match _new_LTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LTLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_LTLCurrencyQuantLib" ;;
let _delete_LTLCurrency arg = match _delete_LTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LUFCurrency_f : c_obj list -> c_obj list = "_wrap_new_LUFCurrencyQuantLib" ;;
let _new_LUFCurrency arg = match _new_LUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LUFCurrency_f : c_obj list -> c_obj list = "_wrap_delete_LUFCurrencyQuantLib" ;;
let _delete_LUFCurrency arg = match _delete_LUFCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LVLCurrency_f : c_obj list -> c_obj list = "_wrap_new_LVLCurrencyQuantLib" ;;
let _new_LVLCurrency arg = match _new_LVLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LVLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_LVLCurrencyQuantLib" ;;
let _delete_LVLCurrency arg = match _delete_LVLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MTLCurrency_f : c_obj list -> c_obj list = "_wrap_new_MTLCurrencyQuantLib" ;;
let _new_MTLCurrency arg = match _new_MTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MTLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_MTLCurrencyQuantLib" ;;
let _delete_MTLCurrency arg = match _delete_MTLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MXNCurrency_f : c_obj list -> c_obj list = "_wrap_new_MXNCurrencyQuantLib" ;;
let _new_MXNCurrency arg = match _new_MXNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MXNCurrency_f : c_obj list -> c_obj list = "_wrap_delete_MXNCurrencyQuantLib" ;;
let _delete_MXNCurrency arg = match _delete_MXNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NLGCurrency_f : c_obj list -> c_obj list = "_wrap_new_NLGCurrencyQuantLib" ;;
let _new_NLGCurrency arg = match _new_NLGCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NLGCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NLGCurrencyQuantLib" ;;
let _delete_NLGCurrency arg = match _delete_NLGCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NOKCurrency_f : c_obj list -> c_obj list = "_wrap_new_NOKCurrencyQuantLib" ;;
let _new_NOKCurrency arg = match _new_NOKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NOKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NOKCurrencyQuantLib" ;;
let _delete_NOKCurrency arg = match _delete_NOKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NPRCurrency_f : c_obj list -> c_obj list = "_wrap_new_NPRCurrencyQuantLib" ;;
let _new_NPRCurrency arg = match _new_NPRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NPRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NPRCurrencyQuantLib" ;;
let _delete_NPRCurrency arg = match _delete_NPRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NZDCurrency_f : c_obj list -> c_obj list = "_wrap_new_NZDCurrencyQuantLib" ;;
let _new_NZDCurrency arg = match _new_NZDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NZDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_NZDCurrencyQuantLib" ;;
let _delete_NZDCurrency arg = match _delete_NZDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PEHCurrency_f : c_obj list -> c_obj list = "_wrap_new_PEHCurrencyQuantLib" ;;
let _new_PEHCurrency arg = match _new_PEHCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PEHCurrency_f : c_obj list -> c_obj list = "_wrap_delete_PEHCurrencyQuantLib" ;;
let _delete_PEHCurrency arg = match _delete_PEHCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PEICurrency_f : c_obj list -> c_obj list = "_wrap_new_PEICurrencyQuantLib" ;;
let _new_PEICurrency arg = match _new_PEICurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PEICurrency_f : c_obj list -> c_obj list = "_wrap_delete_PEICurrencyQuantLib" ;;
let _delete_PEICurrency arg = match _delete_PEICurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PENCurrency_f : c_obj list -> c_obj list = "_wrap_new_PENCurrencyQuantLib" ;;
let _new_PENCurrency arg = match _new_PENCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PENCurrency_f : c_obj list -> c_obj list = "_wrap_delete_PENCurrencyQuantLib" ;;
let _delete_PENCurrency arg = match _delete_PENCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PKRCurrency_f : c_obj list -> c_obj list = "_wrap_new_PKRCurrencyQuantLib" ;;
let _new_PKRCurrency arg = match _new_PKRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PKRCurrency_f : c_obj list -> c_obj list = "_wrap_delete_PKRCurrencyQuantLib" ;;
let _delete_PKRCurrency arg = match _delete_PKRCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PLNCurrency_f : c_obj list -> c_obj list = "_wrap_new_PLNCurrencyQuantLib" ;;
let _new_PLNCurrency arg = match _new_PLNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PLNCurrency_f : c_obj list -> c_obj list = "_wrap_delete_PLNCurrencyQuantLib" ;;
let _delete_PLNCurrency arg = match _delete_PLNCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PTECurrency_f : c_obj list -> c_obj list = "_wrap_new_PTECurrencyQuantLib" ;;
let _new_PTECurrency arg = match _new_PTECurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PTECurrency_f : c_obj list -> c_obj list = "_wrap_delete_PTECurrencyQuantLib" ;;
let _delete_PTECurrency arg = match _delete_PTECurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ROLCurrency_f : c_obj list -> c_obj list = "_wrap_new_ROLCurrencyQuantLib" ;;
let _new_ROLCurrency arg = match _new_ROLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ROLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ROLCurrencyQuantLib" ;;
let _delete_ROLCurrency arg = match _delete_ROLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RONCurrency_f : c_obj list -> c_obj list = "_wrap_new_RONCurrencyQuantLib" ;;
let _new_RONCurrency arg = match _new_RONCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RONCurrency_f : c_obj list -> c_obj list = "_wrap_delete_RONCurrencyQuantLib" ;;
let _delete_RONCurrency arg = match _delete_RONCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SARCurrency_f : c_obj list -> c_obj list = "_wrap_new_SARCurrencyQuantLib" ;;
let _new_SARCurrency arg = match _new_SARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SARCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SARCurrencyQuantLib" ;;
let _delete_SARCurrency arg = match _delete_SARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SEKCurrency_f : c_obj list -> c_obj list = "_wrap_new_SEKCurrencyQuantLib" ;;
let _new_SEKCurrency arg = match _new_SEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SEKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SEKCurrencyQuantLib" ;;
let _delete_SEKCurrency arg = match _delete_SEKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SGDCurrency_f : c_obj list -> c_obj list = "_wrap_new_SGDCurrencyQuantLib" ;;
let _new_SGDCurrency arg = match _new_SGDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SGDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SGDCurrencyQuantLib" ;;
let _delete_SGDCurrency arg = match _delete_SGDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SITCurrency_f : c_obj list -> c_obj list = "_wrap_new_SITCurrencyQuantLib" ;;
let _new_SITCurrency arg = match _new_SITCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SITCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SITCurrencyQuantLib" ;;
let _delete_SITCurrency arg = match _delete_SITCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SKKCurrency_f : c_obj list -> c_obj list = "_wrap_new_SKKCurrencyQuantLib" ;;
let _new_SKKCurrency arg = match _new_SKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SKKCurrency_f : c_obj list -> c_obj list = "_wrap_delete_SKKCurrencyQuantLib" ;;
let _delete_SKKCurrency arg = match _delete_SKKCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_THBCurrency_f : c_obj list -> c_obj list = "_wrap_new_THBCurrencyQuantLib" ;;
let _new_THBCurrency arg = match _new_THBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_THBCurrency_f : c_obj list -> c_obj list = "_wrap_delete_THBCurrencyQuantLib" ;;
let _delete_THBCurrency arg = match _delete_THBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRLCurrency_f : c_obj list -> c_obj list = "_wrap_new_TRLCurrencyQuantLib" ;;
let _new_TRLCurrency arg = match _new_TRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TRLCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TRLCurrencyQuantLib" ;;
let _delete_TRLCurrency arg = match _delete_TRLCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRYCurrency_f : c_obj list -> c_obj list = "_wrap_new_TRYCurrencyQuantLib" ;;
let _new_TRYCurrency arg = match _new_TRYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TRYCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TRYCurrencyQuantLib" ;;
let _delete_TRYCurrency arg = match _delete_TRYCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TTDCurrency_f : c_obj list -> c_obj list = "_wrap_new_TTDCurrencyQuantLib" ;;
let _new_TTDCurrency arg = match _new_TTDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TTDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TTDCurrencyQuantLib" ;;
let _delete_TTDCurrency arg = match _delete_TTDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TWDCurrency_f : c_obj list -> c_obj list = "_wrap_new_TWDCurrencyQuantLib" ;;
let _new_TWDCurrency arg = match _new_TWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TWDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_TWDCurrencyQuantLib" ;;
let _delete_TWDCurrency arg = match _delete_TWDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USDCurrency_f : c_obj list -> c_obj list = "_wrap_new_USDCurrencyQuantLib" ;;
let _new_USDCurrency arg = match _new_USDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_USDCurrency_f : c_obj list -> c_obj list = "_wrap_delete_USDCurrencyQuantLib" ;;
let _delete_USDCurrency arg = match _delete_USDCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_VEBCurrency_f : c_obj list -> c_obj list = "_wrap_new_VEBCurrencyQuantLib" ;;
let _new_VEBCurrency arg = match _new_VEBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VEBCurrency_f : c_obj list -> c_obj list = "_wrap_delete_VEBCurrencyQuantLib" ;;
let _delete_VEBCurrency arg = match _delete_VEBCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZARCurrency_f : c_obj list -> c_obj list = "_wrap_new_ZARCurrencyQuantLib" ;;
let _new_ZARCurrency arg = match _new_ZARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZARCurrency_f : c_obj list -> c_obj list = "_wrap_delete_ZARCurrencyQuantLib" ;;
let _delete_ZARCurrency arg = match _delete_ZARCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LinearInterpolation_f : c_obj list -> c_obj list = "_wrap_new_LinearInterpolationQuantLib" ;;
let _new_LinearInterpolation arg = match _new_LinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LinearInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _LinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LinearInterpolation_operator_pP___QuantLib" ;;
let _LinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LinearInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_LinearInterpolationQuantLib" ;;
let _delete_LinearInterpolation arg = match _delete_LinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LogLinearInterpolation_f : c_obj list -> c_obj list = "_wrap_new_LogLinearInterpolationQuantLib" ;;
let _new_LogLinearInterpolation arg = match _new_LogLinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogLinearInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogLinearInterpolation_operator_pP___QuantLib" ;;
let _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _LogLinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LogLinearInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_LogLinearInterpolationQuantLib" ;;
let _delete_LogLinearInterpolation arg = match _delete_LogLinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BackwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_new_BackwardFlatInterpolationQuantLib" ;;
let _new_BackwardFlatInterpolation arg = match _new_BackwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BackwardFlatInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BackwardFlatInterpolation_operator_pP___QuantLib" ;;
let _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BackwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BackwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_BackwardFlatInterpolationQuantLib" ;;
let _delete_BackwardFlatInterpolation arg = match _delete_BackwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_new_ForwardFlatInterpolationQuantLib" ;;
let _new_ForwardFlatInterpolation arg = match _new_ForwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_ForwardFlatInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_ForwardFlatInterpolation_operator_pP___QuantLib" ;;
let _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _ForwardFlatInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardFlatInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_ForwardFlatInterpolationQuantLib" ;;
let _delete_ForwardFlatInterpolation arg = match _delete_ForwardFlatInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_new_CubicNaturalSplineQuantLib" ;;
let _new_CubicNaturalSpline arg = match _new_CubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_operator_pP_____SWIG_0QuantLib" ;;
let _CubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _CubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_operator_pP___QuantLib" ;;
let _CubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _CubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_derivative__SWIG_0QuantLib" ;;
let _CubicNaturalSpline_derivative arg = match _CubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_derivativeQuantLib" ;;
let _CubicNaturalSpline_derivative arg = match _CubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_secondDerivative__SWIG_0QuantLib" ;;
let _CubicNaturalSpline_secondDerivative arg = match _CubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_secondDerivativeQuantLib" ;;
let _CubicNaturalSpline_secondDerivative arg = match _CubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_primitive__SWIG_0QuantLib" ;;
let _CubicNaturalSpline_primitive arg = match _CubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_CubicNaturalSpline_primitiveQuantLib" ;;
let _CubicNaturalSpline_primitive arg = match _CubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_delete_CubicNaturalSplineQuantLib" ;;
let _delete_CubicNaturalSpline arg = match _delete_CubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LogCubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_new_LogCubicNaturalSplineQuantLib" ;;
let _new_LogCubicNaturalSpline arg = match _new_LogCubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_operator_pP_____SWIG_0QuantLib" ;;
let _LogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _LogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_operator_pP___QuantLib" ;;
let _LogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _LogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_derivative__SWIG_0QuantLib" ;;
let _LogCubicNaturalSpline_derivative arg = match _LogCubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_derivativeQuantLib" ;;
let _LogCubicNaturalSpline_derivative arg = match _LogCubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_secondDerivative__SWIG_0QuantLib" ;;
let _LogCubicNaturalSpline_secondDerivative arg = match _LogCubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_secondDerivativeQuantLib" ;;
let _LogCubicNaturalSpline_secondDerivative arg = match _LogCubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_primitive__SWIG_0QuantLib" ;;
let _LogCubicNaturalSpline_primitive arg = match _LogCubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogCubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_LogCubicNaturalSpline_primitiveQuantLib" ;;
let _LogCubicNaturalSpline_primitive arg = match _LogCubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LogCubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_delete_LogCubicNaturalSplineQuantLib" ;;
let _delete_LogCubicNaturalSpline arg = match _delete_LogCubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MonotonicCubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_new_MonotonicCubicNaturalSplineQuantLib" ;;
let _new_MonotonicCubicNaturalSpline arg = match _new_MonotonicCubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_operator_pP_____SWIG_0QuantLib" ;;
let _MonotonicCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_operator_pP___QuantLib" ;;
let _MonotonicCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_derivative__SWIG_0QuantLib" ;;
let _MonotonicCubicNaturalSpline_derivative arg = match _MonotonicCubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_derivativeQuantLib" ;;
let _MonotonicCubicNaturalSpline_derivative arg = match _MonotonicCubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_secondDerivative__SWIG_0QuantLib" ;;
let _MonotonicCubicNaturalSpline_secondDerivative arg = match _MonotonicCubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_secondDerivativeQuantLib" ;;
let _MonotonicCubicNaturalSpline_secondDerivative arg = match _MonotonicCubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_primitive__SWIG_0QuantLib" ;;
let _MonotonicCubicNaturalSpline_primitive arg = match _MonotonicCubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicCubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicCubicNaturalSpline_primitiveQuantLib" ;;
let _MonotonicCubicNaturalSpline_primitive arg = match _MonotonicCubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MonotonicCubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_delete_MonotonicCubicNaturalSplineQuantLib" ;;
let _delete_MonotonicCubicNaturalSpline arg = match _delete_MonotonicCubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MonotonicLogCubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_new_MonotonicLogCubicNaturalSplineQuantLib" ;;
let _new_MonotonicLogCubicNaturalSpline arg = match _new_MonotonicLogCubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_operator_pP_____SWIG_0QuantLib" ;;
let _MonotonicLogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicLogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_operator_pP___QuantLib" ;;
let _MonotonicLogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicLogCubicNaturalSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_derivative__SWIG_0QuantLib" ;;
let _MonotonicLogCubicNaturalSpline_derivative arg = match _MonotonicLogCubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_derivativeQuantLib" ;;
let _MonotonicLogCubicNaturalSpline_derivative arg = match _MonotonicLogCubicNaturalSpline_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_secondDerivative__SWIG_0QuantLib" ;;
let _MonotonicLogCubicNaturalSpline_secondDerivative arg = match _MonotonicLogCubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_secondDerivativeQuantLib" ;;
let _MonotonicLogCubicNaturalSpline_secondDerivative arg = match _MonotonicLogCubicNaturalSpline_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_primitive__SWIG_0QuantLib" ;;
let _MonotonicLogCubicNaturalSpline_primitive arg = match _MonotonicLogCubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogCubicNaturalSpline_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicLogCubicNaturalSpline_primitiveQuantLib" ;;
let _MonotonicLogCubicNaturalSpline_primitive arg = match _MonotonicLogCubicNaturalSpline_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MonotonicLogCubicNaturalSpline_f : c_obj list -> c_obj list = "_wrap_delete_MonotonicLogCubicNaturalSplineQuantLib" ;;
let _delete_MonotonicLogCubicNaturalSpline arg = match _delete_MonotonicLogCubicNaturalSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KrugerCubic_f : c_obj list -> c_obj list = "_wrap_new_KrugerCubicQuantLib" ;;
let _new_KrugerCubic arg = match _new_KrugerCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_operator_pP_____SWIG_0QuantLib" ;;
let _KrugerCubic_operator_xx_xx_lparen_xx_rparen arg = match _KrugerCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_operator_pP___QuantLib" ;;
let _KrugerCubic_operator_xx_xx_lparen_xx_rparen arg = match _KrugerCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_derivative_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_derivative__SWIG_0QuantLib" ;;
let _KrugerCubic_derivative arg = match _KrugerCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_derivative_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_derivativeQuantLib" ;;
let _KrugerCubic_derivative arg = match _KrugerCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_secondDerivative__SWIG_0QuantLib" ;;
let _KrugerCubic_secondDerivative arg = match _KrugerCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_secondDerivativeQuantLib" ;;
let _KrugerCubic_secondDerivative arg = match _KrugerCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_primitive_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_primitive__SWIG_0QuantLib" ;;
let _KrugerCubic_primitive arg = match _KrugerCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerCubic_primitive_f : c_obj list -> c_obj list = "_wrap_KrugerCubic_primitiveQuantLib" ;;
let _KrugerCubic_primitive arg = match _KrugerCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KrugerCubic_f : c_obj list -> c_obj list = "_wrap_delete_KrugerCubicQuantLib" ;;
let _delete_KrugerCubic arg = match _delete_KrugerCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KrugerLogCubic_f : c_obj list -> c_obj list = "_wrap_new_KrugerLogCubicQuantLib" ;;
let _new_KrugerLogCubic arg = match _new_KrugerLogCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_operator_pP_____SWIG_0QuantLib" ;;
let _KrugerLogCubic_operator_xx_xx_lparen_xx_rparen arg = match _KrugerLogCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_operator_pP___QuantLib" ;;
let _KrugerLogCubic_operator_xx_xx_lparen_xx_rparen arg = match _KrugerLogCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_derivative_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_derivative__SWIG_0QuantLib" ;;
let _KrugerLogCubic_derivative arg = match _KrugerLogCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_derivative_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_derivativeQuantLib" ;;
let _KrugerLogCubic_derivative arg = match _KrugerLogCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_secondDerivative__SWIG_0QuantLib" ;;
let _KrugerLogCubic_secondDerivative arg = match _KrugerLogCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_secondDerivativeQuantLib" ;;
let _KrugerLogCubic_secondDerivative arg = match _KrugerLogCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_primitive_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_primitive__SWIG_0QuantLib" ;;
let _KrugerLogCubic_primitive arg = match _KrugerLogCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KrugerLogCubic_primitive_f : c_obj list -> c_obj list = "_wrap_KrugerLogCubic_primitiveQuantLib" ;;
let _KrugerLogCubic_primitive arg = match _KrugerLogCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KrugerLogCubic_f : c_obj list -> c_obj list = "_wrap_delete_KrugerLogCubicQuantLib" ;;
let _delete_KrugerLogCubic arg = match _delete_KrugerLogCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FritschButlandCubic_f : c_obj list -> c_obj list = "_wrap_new_FritschButlandCubicQuantLib" ;;
let _new_FritschButlandCubic arg = match _new_FritschButlandCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_operator_pP_____SWIG_0QuantLib" ;;
let _FritschButlandCubic_operator_xx_xx_lparen_xx_rparen arg = match _FritschButlandCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_operator_pP___QuantLib" ;;
let _FritschButlandCubic_operator_xx_xx_lparen_xx_rparen arg = match _FritschButlandCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_derivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_derivative__SWIG_0QuantLib" ;;
let _FritschButlandCubic_derivative arg = match _FritschButlandCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_derivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_derivativeQuantLib" ;;
let _FritschButlandCubic_derivative arg = match _FritschButlandCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_secondDerivative__SWIG_0QuantLib" ;;
let _FritschButlandCubic_secondDerivative arg = match _FritschButlandCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_secondDerivativeQuantLib" ;;
let _FritschButlandCubic_secondDerivative arg = match _FritschButlandCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_primitive_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_primitive__SWIG_0QuantLib" ;;
let _FritschButlandCubic_primitive arg = match _FritschButlandCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandCubic_primitive_f : c_obj list -> c_obj list = "_wrap_FritschButlandCubic_primitiveQuantLib" ;;
let _FritschButlandCubic_primitive arg = match _FritschButlandCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FritschButlandCubic_f : c_obj list -> c_obj list = "_wrap_delete_FritschButlandCubicQuantLib" ;;
let _delete_FritschButlandCubic arg = match _delete_FritschButlandCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FritschButlandLogCubic_f : c_obj list -> c_obj list = "_wrap_new_FritschButlandLogCubicQuantLib" ;;
let _new_FritschButlandLogCubic arg = match _new_FritschButlandLogCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_operator_pP_____SWIG_0QuantLib" ;;
let _FritschButlandLogCubic_operator_xx_xx_lparen_xx_rparen arg = match _FritschButlandLogCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_operator_pP___QuantLib" ;;
let _FritschButlandLogCubic_operator_xx_xx_lparen_xx_rparen arg = match _FritschButlandLogCubic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_derivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_derivative__SWIG_0QuantLib" ;;
let _FritschButlandLogCubic_derivative arg = match _FritschButlandLogCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_derivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_derivativeQuantLib" ;;
let _FritschButlandLogCubic_derivative arg = match _FritschButlandLogCubic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_secondDerivative__SWIG_0QuantLib" ;;
let _FritschButlandLogCubic_secondDerivative arg = match _FritschButlandLogCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_secondDerivativeQuantLib" ;;
let _FritschButlandLogCubic_secondDerivative arg = match _FritschButlandLogCubic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_primitive_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_primitive__SWIG_0QuantLib" ;;
let _FritschButlandLogCubic_primitive arg = match _FritschButlandLogCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FritschButlandLogCubic_primitive_f : c_obj list -> c_obj list = "_wrap_FritschButlandLogCubic_primitiveQuantLib" ;;
let _FritschButlandLogCubic_primitive arg = match _FritschButlandLogCubic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FritschButlandLogCubic_f : c_obj list -> c_obj list = "_wrap_delete_FritschButlandLogCubicQuantLib" ;;
let _delete_FritschButlandLogCubic arg = match _delete_FritschButlandLogCubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Parabolic_f : c_obj list -> c_obj list = "_wrap_new_ParabolicQuantLib" ;;
let _new_Parabolic arg = match _new_Parabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_Parabolic_operator_pP_____SWIG_0QuantLib" ;;
let _Parabolic_operator_xx_xx_lparen_xx_rparen arg = match _Parabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_Parabolic_operator_pP___QuantLib" ;;
let _Parabolic_operator_xx_xx_lparen_xx_rparen arg = match _Parabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_derivative_f : c_obj list -> c_obj list = "_wrap_Parabolic_derivative__SWIG_0QuantLib" ;;
let _Parabolic_derivative arg = match _Parabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_derivative_f : c_obj list -> c_obj list = "_wrap_Parabolic_derivativeQuantLib" ;;
let _Parabolic_derivative arg = match _Parabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_Parabolic_secondDerivative__SWIG_0QuantLib" ;;
let _Parabolic_secondDerivative arg = match _Parabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_Parabolic_secondDerivativeQuantLib" ;;
let _Parabolic_secondDerivative arg = match _Parabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_primitive_f : c_obj list -> c_obj list = "_wrap_Parabolic_primitive__SWIG_0QuantLib" ;;
let _Parabolic_primitive arg = match _Parabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Parabolic_primitive_f : c_obj list -> c_obj list = "_wrap_Parabolic_primitiveQuantLib" ;;
let _Parabolic_primitive arg = match _Parabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Parabolic_f : c_obj list -> c_obj list = "_wrap_delete_ParabolicQuantLib" ;;
let _delete_Parabolic arg = match _delete_Parabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LogParabolic_f : c_obj list -> c_obj list = "_wrap_new_LogParabolicQuantLib" ;;
let _new_LogParabolic arg = match _new_LogParabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogParabolic_operator_pP_____SWIG_0QuantLib" ;;
let _LogParabolic_operator_xx_xx_lparen_xx_rparen arg = match _LogParabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_LogParabolic_operator_pP___QuantLib" ;;
let _LogParabolic_operator_xx_xx_lparen_xx_rparen arg = match _LogParabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_derivative_f : c_obj list -> c_obj list = "_wrap_LogParabolic_derivative__SWIG_0QuantLib" ;;
let _LogParabolic_derivative arg = match _LogParabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_derivative_f : c_obj list -> c_obj list = "_wrap_LogParabolic_derivativeQuantLib" ;;
let _LogParabolic_derivative arg = match _LogParabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_LogParabolic_secondDerivative__SWIG_0QuantLib" ;;
let _LogParabolic_secondDerivative arg = match _LogParabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_LogParabolic_secondDerivativeQuantLib" ;;
let _LogParabolic_secondDerivative arg = match _LogParabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_primitive_f : c_obj list -> c_obj list = "_wrap_LogParabolic_primitive__SWIG_0QuantLib" ;;
let _LogParabolic_primitive arg = match _LogParabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LogParabolic_primitive_f : c_obj list -> c_obj list = "_wrap_LogParabolic_primitiveQuantLib" ;;
let _LogParabolic_primitive arg = match _LogParabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LogParabolic_f : c_obj list -> c_obj list = "_wrap_delete_LogParabolicQuantLib" ;;
let _delete_LogParabolic arg = match _delete_LogParabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MonotonicParabolic_f : c_obj list -> c_obj list = "_wrap_new_MonotonicParabolicQuantLib" ;;
let _new_MonotonicParabolic arg = match _new_MonotonicParabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_operator_pP_____SWIG_0QuantLib" ;;
let _MonotonicParabolic_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicParabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_operator_pP___QuantLib" ;;
let _MonotonicParabolic_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicParabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_derivative__SWIG_0QuantLib" ;;
let _MonotonicParabolic_derivative arg = match _MonotonicParabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_derivativeQuantLib" ;;
let _MonotonicParabolic_derivative arg = match _MonotonicParabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_secondDerivative__SWIG_0QuantLib" ;;
let _MonotonicParabolic_secondDerivative arg = match _MonotonicParabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_secondDerivativeQuantLib" ;;
let _MonotonicParabolic_secondDerivative arg = match _MonotonicParabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_primitive__SWIG_0QuantLib" ;;
let _MonotonicParabolic_primitive arg = match _MonotonicParabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicParabolic_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicParabolic_primitiveQuantLib" ;;
let _MonotonicParabolic_primitive arg = match _MonotonicParabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MonotonicParabolic_f : c_obj list -> c_obj list = "_wrap_delete_MonotonicParabolicQuantLib" ;;
let _delete_MonotonicParabolic arg = match _delete_MonotonicParabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MonotonicLogParabolic_f : c_obj list -> c_obj list = "_wrap_new_MonotonicLogParabolicQuantLib" ;;
let _new_MonotonicLogParabolic arg = match _new_MonotonicLogParabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_operator_pP_____SWIG_0QuantLib" ;;
let _MonotonicLogParabolic_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicLogParabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_operator_pP___QuantLib" ;;
let _MonotonicLogParabolic_operator_xx_xx_lparen_xx_rparen arg = match _MonotonicLogParabolic_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_derivative__SWIG_0QuantLib" ;;
let _MonotonicLogParabolic_derivative arg = match _MonotonicLogParabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_derivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_derivativeQuantLib" ;;
let _MonotonicLogParabolic_derivative arg = match _MonotonicLogParabolic_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_secondDerivative__SWIG_0QuantLib" ;;
let _MonotonicLogParabolic_secondDerivative arg = match _MonotonicLogParabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_secondDerivative_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_secondDerivativeQuantLib" ;;
let _MonotonicLogParabolic_secondDerivative arg = match _MonotonicLogParabolic_secondDerivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_primitive__SWIG_0QuantLib" ;;
let _MonotonicLogParabolic_primitive arg = match _MonotonicLogParabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MonotonicLogParabolic_primitive_f : c_obj list -> c_obj list = "_wrap_MonotonicLogParabolic_primitiveQuantLib" ;;
let _MonotonicLogParabolic_primitive arg = match _MonotonicLogParabolic_primitive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MonotonicLogParabolic_f : c_obj list -> c_obj list = "_wrap_delete_MonotonicLogParabolicQuantLib" ;;
let _delete_MonotonicLogParabolic arg = match _delete_MonotonicLogParabolic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BilinearInterpolation_f : c_obj list -> c_obj list = "_wrap_new_BilinearInterpolationQuantLib" ;;
let _new_BilinearInterpolation arg = match _new_BilinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BilinearInterpolation_operator_pP_____SWIG_0QuantLib" ;;
let _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BilinearInterpolation_operator_pP___QuantLib" ;;
let _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen arg = match _BilinearInterpolation_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BilinearInterpolation_f : c_obj list -> c_obj list = "_wrap_delete_BilinearInterpolationQuantLib" ;;
let _delete_BilinearInterpolation arg = match _delete_BilinearInterpolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BicubicSpline_f : c_obj list -> c_obj list = "_wrap_new_BicubicSplineQuantLib" ;;
let _new_BicubicSpline arg = match _new_BicubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BicubicSpline_operator_pP_____SWIG_0QuantLib" ;;
let _BicubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BicubicSpline_operator_pP___QuantLib" ;;
let _BicubicSpline_operator_xx_xx_lparen_xx_rparen arg = match _BicubicSpline_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BicubicSpline_f : c_obj list -> c_obj list = "_wrap_delete_BicubicSplineQuantLib" ;;
let _delete_BicubicSpline arg = match _delete_BicubicSpline_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BackwardFlat_f : c_obj list -> c_obj list = "_wrap_new_BackwardFlatQuantLib" ;;
let _new_BackwardFlat arg = match _new_BackwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BackwardFlat_f : c_obj list -> c_obj list = "_wrap_delete_BackwardFlatQuantLib" ;;
let _delete_BackwardFlat arg = match _delete_BackwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardFlat_f : c_obj list -> c_obj list = "_wrap_new_ForwardFlatQuantLib" ;;
let _new_ForwardFlat arg = match _new_ForwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardFlat_f : c_obj list -> c_obj list = "_wrap_delete_ForwardFlatQuantLib" ;;
let _delete_ForwardFlat arg = match _delete_ForwardFlat_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Linear_f : c_obj list -> c_obj list = "_wrap_new_LinearQuantLib" ;;
let _new_Linear arg = match _new_Linear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Linear_f : c_obj list -> c_obj list = "_wrap_delete_LinearQuantLib" ;;
let _delete_Linear arg = match _delete_Linear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LogLinear_f : c_obj list -> c_obj list = "_wrap_new_LogLinearQuantLib" ;;
let _new_LogLinear arg = match _new_LogLinear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LogLinear_f : c_obj list -> c_obj list = "_wrap_delete_LogLinearQuantLib" ;;
let _delete_LogLinear arg = match _delete_LogLinear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cubic_f : c_obj list -> c_obj list = "_wrap_new_CubicQuantLib" ;;
let _new_Cubic arg = match _new_Cubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Cubic_f : c_obj list -> c_obj list = "_wrap_delete_CubicQuantLib" ;;
let _delete_Cubic arg = match _delete_Cubic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_YieldTermStructure___deref__QuantLib" ;;
let _YieldTermStructure___deref__ arg = match _YieldTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_isNullQuantLib" ;;
let _YieldTermStructure_isNull arg = match _YieldTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_asObservableQuantLib" ;;
let _YieldTermStructure_asObservable arg = match _YieldTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructure_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureQuantLib" ;;
let _new_YieldTermStructure arg = match _new_YieldTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YieldTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_YieldTermStructureQuantLib" ;;
let _delete_YieldTermStructure arg = match _delete_YieldTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_dayCounterQuantLib" ;;
let _YieldTermStructure_dayCounter arg = match _YieldTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_calendarQuantLib" ;;
let _YieldTermStructure_calendar arg = match _YieldTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_referenceDateQuantLib" ;;
let _YieldTermStructure_referenceDate arg = match _YieldTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_maxDateQuantLib" ;;
let _YieldTermStructure_maxDate arg = match _YieldTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_maxTimeQuantLib" ;;
let _YieldTermStructure_maxTime arg = match _YieldTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discount__SWIG_0QuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discount__SWIG_1QuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discount__SWIG_2QuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_discountQuantLib" ;;
let _YieldTermStructure_discount arg = match _YieldTermStructure_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_0QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_1QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_2QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_3QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRate__SWIG_4QuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_zeroRateQuantLib" ;;
let _YieldTermStructure_zeroRate arg = match _YieldTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_0QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_1QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_2QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_3QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRate__SWIG_4QuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_forwardRateQuantLib" ;;
let _YieldTermStructure_forwardRate arg = match _YieldTermStructure_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_enableExtrapolationQuantLib" ;;
let _YieldTermStructure_enableExtrapolation arg = match _YieldTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_disableExtrapolationQuantLib" ;;
let _YieldTermStructure_disableExtrapolation arg = match _YieldTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructure_allowsExtrapolationQuantLib" ;;
let _YieldTermStructure_allowsExtrapolation arg = match _YieldTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureHandle__SWIG_0QuantLib" ;;
let _new_YieldTermStructureHandle arg = match _new_YieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_YieldTermStructureHandleQuantLib" ;;
let _new_YieldTermStructureHandle arg = match _new_YieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle___deref__QuantLib" ;;
let _YieldTermStructureHandle___deref__ arg = match _YieldTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_emptyQuantLib" ;;
let _YieldTermStructureHandle_empty arg = match _YieldTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_asObservableQuantLib" ;;
let _YieldTermStructureHandle_asObservable arg = match _YieldTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_YieldTermStructureHandleQuantLib" ;;
let _delete_YieldTermStructureHandle arg = match _delete_YieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_dayCounterQuantLib" ;;
let _YieldTermStructureHandle_dayCounter arg = match _YieldTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_calendarQuantLib" ;;
let _YieldTermStructureHandle_calendar arg = match _YieldTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_referenceDateQuantLib" ;;
let _YieldTermStructureHandle_referenceDate arg = match _YieldTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_maxDateQuantLib" ;;
let _YieldTermStructureHandle_maxDate arg = match _YieldTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_maxTimeQuantLib" ;;
let _YieldTermStructureHandle_maxTime arg = match _YieldTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discount__SWIG_0QuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discount__SWIG_1QuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discount__SWIG_2QuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_discount_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_discountQuantLib" ;;
let _YieldTermStructureHandle_discount arg = match _YieldTermStructureHandle_discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_0QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_1QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_2QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_3QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRate__SWIG_4QuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_zeroRateQuantLib" ;;
let _YieldTermStructureHandle_zeroRate arg = match _YieldTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_0QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_1QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_2QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_3QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRate__SWIG_4QuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_forwardRate_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_forwardRateQuantLib" ;;
let _YieldTermStructureHandle_forwardRate arg = match _YieldTermStructureHandle_forwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_enableExtrapolationQuantLib" ;;
let _YieldTermStructureHandle_enableExtrapolation arg = match _YieldTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_disableExtrapolationQuantLib" ;;
let _YieldTermStructureHandle_disableExtrapolation arg = match _YieldTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YieldTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_YieldTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _YieldTermStructureHandle_allowsExtrapolation arg = match _YieldTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableYieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableYieldTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableYieldTermStructureHandle arg = match _new_RelinkableYieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableYieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableYieldTermStructureHandleQuantLib" ;;
let _new_RelinkableYieldTermStructureHandle arg = match _new_RelinkableYieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableYieldTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableYieldTermStructureHandle_linkToQuantLib" ;;
let _RelinkableYieldTermStructureHandle_linkTo arg = match _RelinkableYieldTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableYieldTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableYieldTermStructureHandleQuantLib" ;;
let _delete_RelinkableYieldTermStructureHandle arg = match _delete_RelinkableYieldTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ImpliedTermStructure_f : c_obj list -> c_obj list = "_wrap_new_ImpliedTermStructureQuantLib" ;;
let _new_ImpliedTermStructure arg = match _new_ImpliedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ImpliedTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_ImpliedTermStructureQuantLib" ;;
let _delete_ImpliedTermStructure arg = match _delete_ImpliedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_new_ZeroSpreadedTermStructureQuantLib" ;;
let _new_ZeroSpreadedTermStructure arg = match _new_ZeroSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_ZeroSpreadedTermStructureQuantLib" ;;
let _delete_ZeroSpreadedTermStructure arg = match _delete_ZeroSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_new_ForwardSpreadedTermStructureQuantLib" ;;
let _new_ForwardSpreadedTermStructure arg = match _new_ForwardSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardSpreadedTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_ForwardSpreadedTermStructureQuantLib" ;;
let _delete_ForwardSpreadedTermStructure arg = match _delete_ForwardSpreadedTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_0QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_1QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_2QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_3QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_4QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_5QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_6QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_7QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_8QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_9QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForward__SWIG_10QuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatForward_f : c_obj list -> c_obj list = "_wrap_new_FlatForwardQuantLib" ;;
let _new_FlatForward arg = match _new_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FlatForward_f : c_obj list -> c_obj list = "_wrap_delete_FlatForwardQuantLib" ;;
let _delete_FlatForward arg = match _delete_FlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RealTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_RealTimeSeries__SWIG_0QuantLib" ;;
let _new_RealTimeSeries arg = match _new_RealTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RealTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_RealTimeSeriesQuantLib" ;;
let _new_RealTimeSeries arg = match _new_RealTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RealTimeSeries_dates_f : c_obj list -> c_obj list = "_wrap_RealTimeSeries_datesQuantLib" ;;
let _RealTimeSeries_dates arg = match _RealTimeSeries_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RealTimeSeries_values_f : c_obj list -> c_obj list = "_wrap_RealTimeSeries_valuesQuantLib" ;;
let _RealTimeSeries_values arg = match _RealTimeSeries_values_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RealTimeSeries_size_f : c_obj list -> c_obj list = "_wrap_RealTimeSeries_sizeQuantLib" ;;
let _RealTimeSeries_size arg = match _RealTimeSeries_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RealTimeSeries_f : c_obj list -> c_obj list = "_wrap_delete_RealTimeSeriesQuantLib" ;;
let _delete_RealTimeSeries arg = match _delete_RealTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceTimeSeries__SWIG_0QuantLib" ;;
let _new_IntervalPriceTimeSeries arg = match _new_IntervalPriceTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceTimeSeries_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceTimeSeriesQuantLib" ;;
let _new_IntervalPriceTimeSeries arg = match _new_IntervalPriceTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceTimeSeries_dates_f : c_obj list -> c_obj list = "_wrap_IntervalPriceTimeSeries_datesQuantLib" ;;
let _IntervalPriceTimeSeries_dates arg = match _IntervalPriceTimeSeries_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceTimeSeries_values_f : c_obj list -> c_obj list = "_wrap_IntervalPriceTimeSeries_valuesQuantLib" ;;
let _IntervalPriceTimeSeries_values arg = match _IntervalPriceTimeSeries_values_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceTimeSeries_size_f : c_obj list -> c_obj list = "_wrap_IntervalPriceTimeSeries_sizeQuantLib" ;;
let _IntervalPriceTimeSeries_size arg = match _IntervalPriceTimeSeries_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntervalPriceTimeSeries_f : c_obj list -> c_obj list = "_wrap_delete_IntervalPriceTimeSeriesQuantLib" ;;
let _delete_IntervalPriceTimeSeries arg = match _delete_IntervalPriceTimeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVector__SWIG_0QuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVector__SWIG_1QuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVector__SWIG_2QuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceVectorQuantLib" ;;
let _new_IntervalPriceVector arg = match _new_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_size_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_sizeQuantLib" ;;
let _IntervalPriceVector_size arg = match _IntervalPriceVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_empty_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_emptyQuantLib" ;;
let _IntervalPriceVector_empty arg = match _IntervalPriceVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_clear_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_clearQuantLib" ;;
let _IntervalPriceVector_clear arg = match _IntervalPriceVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_push_back_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_push_backQuantLib" ;;
let _IntervalPriceVector_push_back arg = match _IntervalPriceVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_operator_bB___QuantLib" ;;
let _IntervalPriceVector_operator_xx_xx_lbrace_xx_rbrace arg = match _IntervalPriceVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_operator_e___QuantLib" ;;
let _IntervalPriceVector_operator_xx_xx_equals arg = match _IntervalPriceVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_set_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_setQuantLib" ;;
let _IntervalPriceVector_set arg = match _IntervalPriceVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPriceVector_to_array_f : c_obj list -> c_obj list = "_wrap_IntervalPriceVector_to_arrayQuantLib" ;;
let _IntervalPriceVector_to_array arg = match _IntervalPriceVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntervalPriceVector_f : c_obj list -> c_obj list = "_wrap_delete_IntervalPriceVectorQuantLib" ;;
let _delete_IntervalPriceVector arg = match _delete_IntervalPriceVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "IntervalPrice::Type_marker" (`Type)
external _Open : c_obj -> Swig.c_obj = "_wrap_Open" 
external _Close : c_obj -> Swig.c_obj = "_wrap_Close" 
external _High : c_obj -> Swig.c_obj = "_wrap_High" 
external _Low : c_obj -> Swig.c_obj = "_wrap_Low" 
external _new_IntervalPrice_f : c_obj list -> c_obj list = "_wrap_new_IntervalPriceQuantLib" ;;
let _new_IntervalPrice arg = match _new_IntervalPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_setValue_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_setValueQuantLib" ;;
let _IntervalPrice_setValue arg = match _IntervalPrice_setValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_setValues_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_setValuesQuantLib" ;;
let _IntervalPrice_setValues arg = match _IntervalPrice_setValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_value_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_valueQuantLib" ;;
let _IntervalPrice_value arg = match _IntervalPrice_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_open_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_openQuantLib" ;;
let _IntervalPrice_open arg = match _IntervalPrice_open_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_close_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_closeQuantLib" ;;
let _IntervalPrice_close arg = match _IntervalPrice_close_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_high_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_highQuantLib" ;;
let _IntervalPrice_high arg = match _IntervalPrice_high_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_low_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_lowQuantLib" ;;
let _IntervalPrice_low arg = match _IntervalPrice_low_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_makeSeries_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_makeSeriesQuantLib" ;;
let _IntervalPrice_makeSeries arg = match _IntervalPrice_makeSeries_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_extractValues_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_extractValuesQuantLib" ;;
let _IntervalPrice_extractValues arg = match _IntervalPrice_extractValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IntervalPrice_extractComponent_f : c_obj list -> c_obj list = "_wrap_IntervalPrice_extractComponentQuantLib" ;;
let _IntervalPrice_extractComponent arg = match _IntervalPrice_extractComponent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntervalPrice_f : c_obj list -> c_obj list = "_wrap_delete_IntervalPriceQuantLib" ;;
let _delete_IntervalPrice arg = match _delete_IntervalPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_instance_f : c_obj list -> c_obj list = "_wrap_IndexManager_instanceQuantLib" ;;
let _IndexManager_instance arg = match _IndexManager_instance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_setHistory_f : c_obj list -> c_obj list = "_wrap_IndexManager_setHistoryQuantLib" ;;
let _IndexManager_setHistory arg = match _IndexManager_setHistory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_getHistory_f : c_obj list -> c_obj list = "_wrap_IndexManager_getHistoryQuantLib" ;;
let _IndexManager_getHistory arg = match _IndexManager_getHistory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_hasHistory_f : c_obj list -> c_obj list = "_wrap_IndexManager_hasHistoryQuantLib" ;;
let _IndexManager_hasHistory arg = match _IndexManager_hasHistory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_histories_f : c_obj list -> c_obj list = "_wrap_IndexManager_historiesQuantLib" ;;
let _IndexManager_histories arg = match _IndexManager_histories_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_clearHistory_f : c_obj list -> c_obj list = "_wrap_IndexManager_clearHistoryQuantLib" ;;
let _IndexManager_clearHistory arg = match _IndexManager_clearHistory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IndexManager_clearHistories_f : c_obj list -> c_obj list = "_wrap_IndexManager_clearHistoriesQuantLib" ;;
let _IndexManager_clearHistories arg = match _IndexManager_clearHistories_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IndexManager_f : c_obj list -> c_obj list = "_wrap_delete_IndexManagerQuantLib" ;;
let _delete_IndexManager arg = match _delete_IndexManager_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index___deref___f : c_obj list -> c_obj list = "_wrap_Index___deref__QuantLib" ;;
let _Index___deref__ arg = match _Index___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_isNull_f : c_obj list -> c_obj list = "_wrap_Index_isNullQuantLib" ;;
let _Index_isNull arg = match _Index_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_addFixings_f : c_obj list -> c_obj list = "_wrap_Index_addFixingsQuantLib" ;;
let _Index_addFixings arg = match _Index_addFixings_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index___str___f : c_obj list -> c_obj list = "_wrap_Index___str__QuantLib" ;;
let _Index___str__ arg = match _Index___str___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_asObservable_f : c_obj list -> c_obj list = "_wrap_Index_asObservableQuantLib" ;;
let _Index_asObservable arg = match _Index_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Index_f : c_obj list -> c_obj list = "_wrap_new_IndexQuantLib" ;;
let _new_Index arg = match _new_Index_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Index_f : c_obj list -> c_obj list = "_wrap_delete_IndexQuantLib" ;;
let _delete_Index arg = match _delete_Index_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_name_f : c_obj list -> c_obj list = "_wrap_Index_nameQuantLib" ;;
let _Index_name arg = match _Index_name_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_fixingCalendar_f : c_obj list -> c_obj list = "_wrap_Index_fixingCalendarQuantLib" ;;
let _Index_fixingCalendar arg = match _Index_fixingCalendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_isValidFixingDate_f : c_obj list -> c_obj list = "_wrap_Index_isValidFixingDateQuantLib" ;;
let _Index_isValidFixingDate arg = match _Index_isValidFixingDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_fixing_f : c_obj list -> c_obj list = "_wrap_Index_fixing__SWIG_0QuantLib" ;;
let _Index_fixing arg = match _Index_fixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_fixing_f : c_obj list -> c_obj list = "_wrap_Index_fixingQuantLib" ;;
let _Index_fixing arg = match _Index_fixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Index_addFixing_f : c_obj list -> c_obj list = "_wrap_Index_addFixingQuantLib" ;;
let _Index_addFixing arg = match _Index_addFixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_familyName_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_familyNameQuantLib" ;;
let _InterestRateIndex_familyName arg = match _InterestRateIndex_familyName_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_tenor_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_tenorQuantLib" ;;
let _InterestRateIndex_tenor arg = match _InterestRateIndex_tenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_fixingDays_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_fixingDaysQuantLib" ;;
let _InterestRateIndex_fixingDays arg = match _InterestRateIndex_fixingDays_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_fixingDate_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_fixingDateQuantLib" ;;
let _InterestRateIndex_fixingDate arg = match _InterestRateIndex_fixingDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_currency_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_currencyQuantLib" ;;
let _InterestRateIndex_currency arg = match _InterestRateIndex_currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_dayCounter_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_dayCounterQuantLib" ;;
let _InterestRateIndex_dayCounter arg = match _InterestRateIndex_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_maturityDate_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_maturityDateQuantLib" ;;
let _InterestRateIndex_maturityDate arg = match _InterestRateIndex_maturityDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InterestRateIndex_valueDate_f : c_obj list -> c_obj list = "_wrap_InterestRateIndex_valueDateQuantLib" ;;
let _InterestRateIndex_valueDate arg = match _InterestRateIndex_valueDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InterestRateIndex_f : c_obj list -> c_obj list = "_wrap_delete_InterestRateIndexQuantLib" ;;
let _delete_InterestRateIndex arg = match _delete_InterestRateIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborIndex_f : c_obj list -> c_obj list = "_wrap_new_IborIndex__SWIG_0QuantLib" ;;
let _new_IborIndex arg = match _new_IborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborIndex_f : c_obj list -> c_obj list = "_wrap_new_IborIndexQuantLib" ;;
let _new_IborIndex arg = match _new_IborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborIndex_businessDayConvention_f : c_obj list -> c_obj list = "_wrap_IborIndex_businessDayConventionQuantLib" ;;
let _IborIndex_businessDayConvention arg = match _IborIndex_businessDayConvention_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborIndex_endOfMonth_f : c_obj list -> c_obj list = "_wrap_IborIndex_endOfMonthQuantLib" ;;
let _IborIndex_endOfMonth arg = match _IborIndex_endOfMonth_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborIndex_forwardingTermStructure_f : c_obj list -> c_obj list = "_wrap_IborIndex_forwardingTermStructureQuantLib" ;;
let _IborIndex_forwardingTermStructure arg = match _IborIndex_forwardingTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IborIndex_f : c_obj list -> c_obj list = "_wrap_delete_IborIndexQuantLib" ;;
let _delete_IborIndex arg = match _delete_IborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapIndex_f : c_obj list -> c_obj list = "_wrap_new_SwapIndex__SWIG_0QuantLib" ;;
let _new_SwapIndex arg = match _new_SwapIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapIndex_f : c_obj list -> c_obj list = "_wrap_new_SwapIndexQuantLib" ;;
let _new_SwapIndex arg = match _new_SwapIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapIndex_fixedLegTenor_f : c_obj list -> c_obj list = "_wrap_SwapIndex_fixedLegTenorQuantLib" ;;
let _SwapIndex_fixedLegTenor arg = match _SwapIndex_fixedLegTenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapIndex_fixedLegConvention_f : c_obj list -> c_obj list = "_wrap_SwapIndex_fixedLegConventionQuantLib" ;;
let _SwapIndex_fixedLegConvention arg = match _SwapIndex_fixedLegConvention_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapIndex_iborIndex_f : c_obj list -> c_obj list = "_wrap_SwapIndex_iborIndexQuantLib" ;;
let _SwapIndex_iborIndex arg = match _SwapIndex_iborIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapIndex_forwardingTermStructure_f : c_obj list -> c_obj list = "_wrap_SwapIndex_forwardingTermStructureQuantLib" ;;
let _SwapIndex_forwardingTermStructure arg = match _SwapIndex_forwardingTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwapIndex_f : c_obj list -> c_obj list = "_wrap_delete_SwapIndexQuantLib" ;;
let _delete_SwapIndex arg = match _delete_SwapIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AUDLibor_f : c_obj list -> c_obj list = "_wrap_new_AUDLibor__SWIG_0QuantLib" ;;
let _new_AUDLibor arg = match _new_AUDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AUDLibor_f : c_obj list -> c_obj list = "_wrap_new_AUDLiborQuantLib" ;;
let _new_AUDLibor arg = match _new_AUDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AUDLibor_f : c_obj list -> c_obj list = "_wrap_delete_AUDLiborQuantLib" ;;
let _delete_AUDLibor arg = match _delete_AUDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CADLibor_f : c_obj list -> c_obj list = "_wrap_new_CADLibor__SWIG_0QuantLib" ;;
let _new_CADLibor arg = match _new_CADLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CADLibor_f : c_obj list -> c_obj list = "_wrap_new_CADLiborQuantLib" ;;
let _new_CADLibor arg = match _new_CADLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CADLibor_f : c_obj list -> c_obj list = "_wrap_delete_CADLiborQuantLib" ;;
let _delete_CADLibor arg = match _delete_CADLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cdor_f : c_obj list -> c_obj list = "_wrap_new_Cdor__SWIG_0QuantLib" ;;
let _new_Cdor arg = match _new_Cdor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cdor_f : c_obj list -> c_obj list = "_wrap_new_CdorQuantLib" ;;
let _new_Cdor arg = match _new_Cdor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Cdor_f : c_obj list -> c_obj list = "_wrap_delete_CdorQuantLib" ;;
let _delete_Cdor arg = match _delete_Cdor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CHFLibor_f : c_obj list -> c_obj list = "_wrap_new_CHFLibor__SWIG_0QuantLib" ;;
let _new_CHFLibor arg = match _new_CHFLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CHFLibor_f : c_obj list -> c_obj list = "_wrap_new_CHFLiborQuantLib" ;;
let _new_CHFLibor arg = match _new_CHFLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CHFLibor_f : c_obj list -> c_obj list = "_wrap_delete_CHFLiborQuantLib" ;;
let _delete_CHFLibor arg = match _delete_CHFLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DKKLibor_f : c_obj list -> c_obj list = "_wrap_new_DKKLibor__SWIG_0QuantLib" ;;
let _new_DKKLibor arg = match _new_DKKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DKKLibor_f : c_obj list -> c_obj list = "_wrap_new_DKKLiborQuantLib" ;;
let _new_DKKLibor arg = match _new_DKKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DKKLibor_f : c_obj list -> c_obj list = "_wrap_delete_DKKLiborQuantLib" ;;
let _delete_DKKLibor arg = match _delete_DKKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor_f : c_obj list -> c_obj list = "_wrap_new_Euribor__SWIG_0QuantLib" ;;
let _new_Euribor arg = match _new_Euribor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor_f : c_obj list -> c_obj list = "_wrap_new_EuriborQuantLib" ;;
let _new_Euribor arg = match _new_Euribor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor_f : c_obj list -> c_obj list = "_wrap_delete_EuriborQuantLib" ;;
let _delete_Euribor arg = match _delete_Euribor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSW_f : c_obj list -> c_obj list = "_wrap_new_EuriborSW__SWIG_0QuantLib" ;;
let _new_EuriborSW arg = match _new_EuriborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSW_f : c_obj list -> c_obj list = "_wrap_new_EuriborSWQuantLib" ;;
let _new_EuriborSW arg = match _new_EuriborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSW_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSWQuantLib" ;;
let _delete_EuriborSW arg = match _delete_EuriborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor2W__SWIG_0QuantLib" ;;
let _new_Euribor2W arg = match _new_Euribor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor2WQuantLib" ;;
let _new_Euribor2W arg = match _new_Euribor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor2W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor2WQuantLib" ;;
let _delete_Euribor2W arg = match _delete_Euribor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor3W__SWIG_0QuantLib" ;;
let _new_Euribor3W arg = match _new_Euribor3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor3WQuantLib" ;;
let _new_Euribor3W arg = match _new_Euribor3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor3W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor3WQuantLib" ;;
let _delete_Euribor3W arg = match _delete_Euribor3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor1M__SWIG_0QuantLib" ;;
let _new_Euribor1M arg = match _new_Euribor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor1MQuantLib" ;;
let _new_Euribor1M arg = match _new_Euribor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor1M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor1MQuantLib" ;;
let _delete_Euribor1M arg = match _delete_Euribor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor2M__SWIG_0QuantLib" ;;
let _new_Euribor2M arg = match _new_Euribor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor2MQuantLib" ;;
let _new_Euribor2M arg = match _new_Euribor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor2M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor2MQuantLib" ;;
let _delete_Euribor2M arg = match _delete_Euribor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor3M__SWIG_0QuantLib" ;;
let _new_Euribor3M arg = match _new_Euribor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor3MQuantLib" ;;
let _new_Euribor3M arg = match _new_Euribor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor3M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor3MQuantLib" ;;
let _delete_Euribor3M arg = match _delete_Euribor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor4M__SWIG_0QuantLib" ;;
let _new_Euribor4M arg = match _new_Euribor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor4MQuantLib" ;;
let _new_Euribor4M arg = match _new_Euribor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor4M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor4MQuantLib" ;;
let _delete_Euribor4M arg = match _delete_Euribor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor5M__SWIG_0QuantLib" ;;
let _new_Euribor5M arg = match _new_Euribor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor5MQuantLib" ;;
let _new_Euribor5M arg = match _new_Euribor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor5M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor5MQuantLib" ;;
let _delete_Euribor5M arg = match _delete_Euribor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor6M__SWIG_0QuantLib" ;;
let _new_Euribor6M arg = match _new_Euribor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor6MQuantLib" ;;
let _new_Euribor6M arg = match _new_Euribor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor6M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor6MQuantLib" ;;
let _delete_Euribor6M arg = match _delete_Euribor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor7M__SWIG_0QuantLib" ;;
let _new_Euribor7M arg = match _new_Euribor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor7MQuantLib" ;;
let _new_Euribor7M arg = match _new_Euribor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor7M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor7MQuantLib" ;;
let _delete_Euribor7M arg = match _delete_Euribor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor8M__SWIG_0QuantLib" ;;
let _new_Euribor8M arg = match _new_Euribor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor8MQuantLib" ;;
let _new_Euribor8M arg = match _new_Euribor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor8M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor8MQuantLib" ;;
let _delete_Euribor8M arg = match _delete_Euribor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor9M__SWIG_0QuantLib" ;;
let _new_Euribor9M arg = match _new_Euribor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor9MQuantLib" ;;
let _new_Euribor9M arg = match _new_Euribor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor9M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor9MQuantLib" ;;
let _delete_Euribor9M arg = match _delete_Euribor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor10M__SWIG_0QuantLib" ;;
let _new_Euribor10M arg = match _new_Euribor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor10MQuantLib" ;;
let _new_Euribor10M arg = match _new_Euribor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor10M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor10MQuantLib" ;;
let _delete_Euribor10M arg = match _delete_Euribor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor11M__SWIG_0QuantLib" ;;
let _new_Euribor11M arg = match _new_Euribor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor11MQuantLib" ;;
let _new_Euribor11M arg = match _new_Euribor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor11M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor11MQuantLib" ;;
let _delete_Euribor11M arg = match _delete_Euribor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor1Y__SWIG_0QuantLib" ;;
let _new_Euribor1Y arg = match _new_Euribor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor1YQuantLib" ;;
let _new_Euribor1Y arg = match _new_Euribor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor1Y_f : c_obj list -> c_obj list = "_wrap_delete_Euribor1YQuantLib" ;;
let _delete_Euribor1Y arg = match _delete_Euribor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_f : c_obj list -> c_obj list = "_wrap_new_Euribor365__SWIG_0QuantLib" ;;
let _new_Euribor365 arg = match _new_Euribor365_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_f : c_obj list -> c_obj list = "_wrap_new_Euribor365QuantLib" ;;
let _new_Euribor365 arg = match _new_Euribor365_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365QuantLib" ;;
let _delete_Euribor365 arg = match _delete_Euribor365_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_SW_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_SW__SWIG_0QuantLib" ;;
let _new_Euribor365_SW arg = match _new_Euribor365_SW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_SW_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_SWQuantLib" ;;
let _new_Euribor365_SW arg = match _new_Euribor365_SW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_SW_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_SWQuantLib" ;;
let _delete_Euribor365_SW arg = match _delete_Euribor365_SW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2W__SWIG_0QuantLib" ;;
let _new_Euribor365_2W arg = match _new_Euribor365_2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2WQuantLib" ;;
let _new_Euribor365_2W arg = match _new_Euribor365_2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_2W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_2WQuantLib" ;;
let _delete_Euribor365_2W arg = match _delete_Euribor365_2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3W__SWIG_0QuantLib" ;;
let _new_Euribor365_3W arg = match _new_Euribor365_3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3W_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3WQuantLib" ;;
let _new_Euribor365_3W arg = match _new_Euribor365_3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_3W_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_3WQuantLib" ;;
let _delete_Euribor365_3W arg = match _delete_Euribor365_3W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1M__SWIG_0QuantLib" ;;
let _new_Euribor365_1M arg = match _new_Euribor365_1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1MQuantLib" ;;
let _new_Euribor365_1M arg = match _new_Euribor365_1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_1M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_1MQuantLib" ;;
let _delete_Euribor365_1M arg = match _delete_Euribor365_1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2M__SWIG_0QuantLib" ;;
let _new_Euribor365_2M arg = match _new_Euribor365_2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_2M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_2MQuantLib" ;;
let _new_Euribor365_2M arg = match _new_Euribor365_2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_2M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_2MQuantLib" ;;
let _delete_Euribor365_2M arg = match _delete_Euribor365_2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3M__SWIG_0QuantLib" ;;
let _new_Euribor365_3M arg = match _new_Euribor365_3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_3M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_3MQuantLib" ;;
let _new_Euribor365_3M arg = match _new_Euribor365_3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_3M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_3MQuantLib" ;;
let _delete_Euribor365_3M arg = match _delete_Euribor365_3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_4M__SWIG_0QuantLib" ;;
let _new_Euribor365_4M arg = match _new_Euribor365_4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_4M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_4MQuantLib" ;;
let _new_Euribor365_4M arg = match _new_Euribor365_4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_4M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_4MQuantLib" ;;
let _delete_Euribor365_4M arg = match _delete_Euribor365_4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_5M__SWIG_0QuantLib" ;;
let _new_Euribor365_5M arg = match _new_Euribor365_5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_5M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_5MQuantLib" ;;
let _new_Euribor365_5M arg = match _new_Euribor365_5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_5M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_5MQuantLib" ;;
let _delete_Euribor365_5M arg = match _delete_Euribor365_5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_6M__SWIG_0QuantLib" ;;
let _new_Euribor365_6M arg = match _new_Euribor365_6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_6M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_6MQuantLib" ;;
let _new_Euribor365_6M arg = match _new_Euribor365_6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_6M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_6MQuantLib" ;;
let _delete_Euribor365_6M arg = match _delete_Euribor365_6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_7M__SWIG_0QuantLib" ;;
let _new_Euribor365_7M arg = match _new_Euribor365_7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_7M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_7MQuantLib" ;;
let _new_Euribor365_7M arg = match _new_Euribor365_7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_7M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_7MQuantLib" ;;
let _delete_Euribor365_7M arg = match _delete_Euribor365_7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_8M__SWIG_0QuantLib" ;;
let _new_Euribor365_8M arg = match _new_Euribor365_8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_8M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_8MQuantLib" ;;
let _new_Euribor365_8M arg = match _new_Euribor365_8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_8M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_8MQuantLib" ;;
let _delete_Euribor365_8M arg = match _delete_Euribor365_8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_9M__SWIG_0QuantLib" ;;
let _new_Euribor365_9M arg = match _new_Euribor365_9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_9M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_9MQuantLib" ;;
let _new_Euribor365_9M arg = match _new_Euribor365_9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_9M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_9MQuantLib" ;;
let _delete_Euribor365_9M arg = match _delete_Euribor365_9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_10M__SWIG_0QuantLib" ;;
let _new_Euribor365_10M arg = match _new_Euribor365_10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_10M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_10MQuantLib" ;;
let _new_Euribor365_10M arg = match _new_Euribor365_10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_10M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_10MQuantLib" ;;
let _delete_Euribor365_10M arg = match _delete_Euribor365_10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_11M__SWIG_0QuantLib" ;;
let _new_Euribor365_11M arg = match _new_Euribor365_11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_11M_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_11MQuantLib" ;;
let _new_Euribor365_11M arg = match _new_Euribor365_11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_11M_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_11MQuantLib" ;;
let _delete_Euribor365_11M arg = match _delete_Euribor365_11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1Y__SWIG_0QuantLib" ;;
let _new_Euribor365_1Y arg = match _new_Euribor365_1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Euribor365_1Y_f : c_obj list -> c_obj list = "_wrap_new_Euribor365_1YQuantLib" ;;
let _new_Euribor365_1Y arg = match _new_Euribor365_1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Euribor365_1Y_f : c_obj list -> c_obj list = "_wrap_delete_Euribor365_1YQuantLib" ;;
let _delete_Euribor365_1Y arg = match _delete_Euribor365_1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor_f : c_obj list -> c_obj list = "_wrap_new_EURLibor__SWIG_0QuantLib" ;;
let _new_EURLibor arg = match _new_EURLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor_f : c_obj list -> c_obj list = "_wrap_new_EURLiborQuantLib" ;;
let _new_EURLibor arg = match _new_EURLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor_f : c_obj list -> c_obj list = "_wrap_delete_EURLiborQuantLib" ;;
let _delete_EURLibor arg = match _delete_EURLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLiborSW_f : c_obj list -> c_obj list = "_wrap_new_EURLiborSW__SWIG_0QuantLib" ;;
let _new_EURLiborSW arg = match _new_EURLiborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLiborSW_f : c_obj list -> c_obj list = "_wrap_new_EURLiborSWQuantLib" ;;
let _new_EURLiborSW arg = match _new_EURLiborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLiborSW_f : c_obj list -> c_obj list = "_wrap_delete_EURLiborSWQuantLib" ;;
let _delete_EURLiborSW arg = match _delete_EURLiborSW_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2W_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2W__SWIG_0QuantLib" ;;
let _new_EURLibor2W arg = match _new_EURLibor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2W_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2WQuantLib" ;;
let _new_EURLibor2W arg = match _new_EURLibor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor2W_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor2WQuantLib" ;;
let _delete_EURLibor2W arg = match _delete_EURLibor2W_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1M__SWIG_0QuantLib" ;;
let _new_EURLibor1M arg = match _new_EURLibor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1MQuantLib" ;;
let _new_EURLibor1M arg = match _new_EURLibor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor1M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor1MQuantLib" ;;
let _delete_EURLibor1M arg = match _delete_EURLibor1M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2M__SWIG_0QuantLib" ;;
let _new_EURLibor2M arg = match _new_EURLibor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor2M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor2MQuantLib" ;;
let _new_EURLibor2M arg = match _new_EURLibor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor2M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor2MQuantLib" ;;
let _delete_EURLibor2M arg = match _delete_EURLibor2M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor3M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor3M__SWIG_0QuantLib" ;;
let _new_EURLibor3M arg = match _new_EURLibor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor3M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor3MQuantLib" ;;
let _new_EURLibor3M arg = match _new_EURLibor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor3M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor3MQuantLib" ;;
let _delete_EURLibor3M arg = match _delete_EURLibor3M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor4M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor4M__SWIG_0QuantLib" ;;
let _new_EURLibor4M arg = match _new_EURLibor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor4M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor4MQuantLib" ;;
let _new_EURLibor4M arg = match _new_EURLibor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor4M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor4MQuantLib" ;;
let _delete_EURLibor4M arg = match _delete_EURLibor4M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor5M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor5M__SWIG_0QuantLib" ;;
let _new_EURLibor5M arg = match _new_EURLibor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor5M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor5MQuantLib" ;;
let _new_EURLibor5M arg = match _new_EURLibor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor5M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor5MQuantLib" ;;
let _delete_EURLibor5M arg = match _delete_EURLibor5M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor6M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor6M__SWIG_0QuantLib" ;;
let _new_EURLibor6M arg = match _new_EURLibor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor6M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor6MQuantLib" ;;
let _new_EURLibor6M arg = match _new_EURLibor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor6M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor6MQuantLib" ;;
let _delete_EURLibor6M arg = match _delete_EURLibor6M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor7M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor7M__SWIG_0QuantLib" ;;
let _new_EURLibor7M arg = match _new_EURLibor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor7M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor7MQuantLib" ;;
let _new_EURLibor7M arg = match _new_EURLibor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor7M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor7MQuantLib" ;;
let _delete_EURLibor7M arg = match _delete_EURLibor7M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor8M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor8M__SWIG_0QuantLib" ;;
let _new_EURLibor8M arg = match _new_EURLibor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor8M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor8MQuantLib" ;;
let _new_EURLibor8M arg = match _new_EURLibor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor8M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor8MQuantLib" ;;
let _delete_EURLibor8M arg = match _delete_EURLibor8M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor9M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor9M__SWIG_0QuantLib" ;;
let _new_EURLibor9M arg = match _new_EURLibor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor9M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor9MQuantLib" ;;
let _new_EURLibor9M arg = match _new_EURLibor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor9M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor9MQuantLib" ;;
let _delete_EURLibor9M arg = match _delete_EURLibor9M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor10M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor10M__SWIG_0QuantLib" ;;
let _new_EURLibor10M arg = match _new_EURLibor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor10M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor10MQuantLib" ;;
let _new_EURLibor10M arg = match _new_EURLibor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor10M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor10MQuantLib" ;;
let _delete_EURLibor10M arg = match _delete_EURLibor10M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor11M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor11M__SWIG_0QuantLib" ;;
let _new_EURLibor11M arg = match _new_EURLibor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor11M_f : c_obj list -> c_obj list = "_wrap_new_EURLibor11MQuantLib" ;;
let _new_EURLibor11M arg = match _new_EURLibor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor11M_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor11MQuantLib" ;;
let _delete_EURLibor11M arg = match _delete_EURLibor11M_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1Y_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1Y__SWIG_0QuantLib" ;;
let _new_EURLibor1Y arg = match _new_EURLibor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EURLibor1Y_f : c_obj list -> c_obj list = "_wrap_new_EURLibor1YQuantLib" ;;
let _new_EURLibor1Y arg = match _new_EURLibor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EURLibor1Y_f : c_obj list -> c_obj list = "_wrap_delete_EURLibor1YQuantLib" ;;
let _delete_EURLibor1Y arg = match _delete_EURLibor1Y_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GBPLibor_f : c_obj list -> c_obj list = "_wrap_new_GBPLibor__SWIG_0QuantLib" ;;
let _new_GBPLibor arg = match _new_GBPLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GBPLibor_f : c_obj list -> c_obj list = "_wrap_new_GBPLiborQuantLib" ;;
let _new_GBPLibor arg = match _new_GBPLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GBPLibor_f : c_obj list -> c_obj list = "_wrap_delete_GBPLiborQuantLib" ;;
let _delete_GBPLibor arg = match _delete_GBPLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Jibar_f : c_obj list -> c_obj list = "_wrap_new_Jibar__SWIG_0QuantLib" ;;
let _new_Jibar arg = match _new_Jibar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Jibar_f : c_obj list -> c_obj list = "_wrap_new_JibarQuantLib" ;;
let _new_Jibar arg = match _new_Jibar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Jibar_f : c_obj list -> c_obj list = "_wrap_delete_JibarQuantLib" ;;
let _delete_Jibar arg = match _delete_Jibar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JPYLibor_f : c_obj list -> c_obj list = "_wrap_new_JPYLibor__SWIG_0QuantLib" ;;
let _new_JPYLibor arg = match _new_JPYLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_JPYLibor_f : c_obj list -> c_obj list = "_wrap_new_JPYLiborQuantLib" ;;
let _new_JPYLibor arg = match _new_JPYLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_JPYLibor_f : c_obj list -> c_obj list = "_wrap_delete_JPYLiborQuantLib" ;;
let _delete_JPYLibor arg = match _delete_JPYLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NZDLibor_f : c_obj list -> c_obj list = "_wrap_new_NZDLibor__SWIG_0QuantLib" ;;
let _new_NZDLibor arg = match _new_NZDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NZDLibor_f : c_obj list -> c_obj list = "_wrap_new_NZDLiborQuantLib" ;;
let _new_NZDLibor arg = match _new_NZDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NZDLibor_f : c_obj list -> c_obj list = "_wrap_delete_NZDLiborQuantLib" ;;
let _delete_NZDLibor arg = match _delete_NZDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SEKLibor_f : c_obj list -> c_obj list = "_wrap_new_SEKLibor__SWIG_0QuantLib" ;;
let _new_SEKLibor arg = match _new_SEKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SEKLibor_f : c_obj list -> c_obj list = "_wrap_new_SEKLiborQuantLib" ;;
let _new_SEKLibor arg = match _new_SEKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SEKLibor_f : c_obj list -> c_obj list = "_wrap_delete_SEKLiborQuantLib" ;;
let _delete_SEKLibor arg = match _delete_SEKLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Tibor_f : c_obj list -> c_obj list = "_wrap_new_Tibor__SWIG_0QuantLib" ;;
let _new_Tibor arg = match _new_Tibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Tibor_f : c_obj list -> c_obj list = "_wrap_new_TiborQuantLib" ;;
let _new_Tibor arg = match _new_Tibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Tibor_f : c_obj list -> c_obj list = "_wrap_delete_TiborQuantLib" ;;
let _delete_Tibor arg = match _delete_Tibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRLibor_f : c_obj list -> c_obj list = "_wrap_new_TRLibor__SWIG_0QuantLib" ;;
let _new_TRLibor arg = match _new_TRLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TRLibor_f : c_obj list -> c_obj list = "_wrap_new_TRLiborQuantLib" ;;
let _new_TRLibor arg = match _new_TRLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TRLibor_f : c_obj list -> c_obj list = "_wrap_delete_TRLiborQuantLib" ;;
let _delete_TRLibor arg = match _delete_TRLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USDLibor_f : c_obj list -> c_obj list = "_wrap_new_USDLibor__SWIG_0QuantLib" ;;
let _new_USDLibor arg = match _new_USDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USDLibor_f : c_obj list -> c_obj list = "_wrap_new_USDLiborQuantLib" ;;
let _new_USDLibor arg = match _new_USDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_USDLibor_f : c_obj list -> c_obj list = "_wrap_delete_USDLiborQuantLib" ;;
let _delete_USDLibor arg = match _delete_USDLibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Zibor_f : c_obj list -> c_obj list = "_wrap_new_Zibor__SWIG_0QuantLib" ;;
let _new_Zibor arg = match _new_Zibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Zibor_f : c_obj list -> c_obj list = "_wrap_new_ZiborQuantLib" ;;
let _new_Zibor arg = match _new_Zibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Zibor_f : c_obj list -> c_obj list = "_wrap_delete_ZiborQuantLib" ;;
let _delete_Zibor arg = match _delete_Zibor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapIsdaFixA_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapIsdaFixA__SWIG_0QuantLib" ;;
let _new_EuriborSwapIsdaFixA arg = match _new_EuriborSwapIsdaFixA_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapIsdaFixA_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapIsdaFixAQuantLib" ;;
let _new_EuriborSwapIsdaFixA arg = match _new_EuriborSwapIsdaFixA_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapIsdaFixA_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapIsdaFixAQuantLib" ;;
let _delete_EuriborSwapIsdaFixA arg = match _delete_EuriborSwapIsdaFixA_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapIsdaFixB_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapIsdaFixB__SWIG_0QuantLib" ;;
let _new_EuriborSwapIsdaFixB arg = match _new_EuriborSwapIsdaFixB_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapIsdaFixB_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapIsdaFixBQuantLib" ;;
let _new_EuriborSwapIsdaFixB arg = match _new_EuriborSwapIsdaFixB_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapIsdaFixB_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapIsdaFixBQuantLib" ;;
let _delete_EuriborSwapIsdaFixB arg = match _delete_EuriborSwapIsdaFixB_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapIfrFix_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapIfrFix__SWIG_0QuantLib" ;;
let _new_EuriborSwapIfrFix arg = match _new_EuriborSwapIfrFix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuriborSwapIfrFix_f : c_obj list -> c_obj list = "_wrap_new_EuriborSwapIfrFixQuantLib" ;;
let _new_EuriborSwapIfrFix arg = match _new_EuriborSwapIfrFix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuriborSwapIfrFix_f : c_obj list -> c_obj list = "_wrap_delete_EuriborSwapIfrFixQuantLib" ;;
let _delete_EuriborSwapIfrFix arg = match _delete_EuriborSwapIfrFix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurLiborSwapIsdaFixA_f : c_obj list -> c_obj list = "_wrap_new_EurLiborSwapIsdaFixA__SWIG_0QuantLib" ;;
let _new_EurLiborSwapIsdaFixA arg = match _new_EurLiborSwapIsdaFixA_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurLiborSwapIsdaFixA_f : c_obj list -> c_obj list = "_wrap_new_EurLiborSwapIsdaFixAQuantLib" ;;
let _new_EurLiborSwapIsdaFixA arg = match _new_EurLiborSwapIsdaFixA_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurLiborSwapIsdaFixA_f : c_obj list -> c_obj list = "_wrap_delete_EurLiborSwapIsdaFixAQuantLib" ;;
let _delete_EurLiborSwapIsdaFixA arg = match _delete_EurLiborSwapIsdaFixA_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurLiborSwapIsdaFixB_f : c_obj list -> c_obj list = "_wrap_new_EurLiborSwapIsdaFixB__SWIG_0QuantLib" ;;
let _new_EurLiborSwapIsdaFixB arg = match _new_EurLiborSwapIsdaFixB_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurLiborSwapIsdaFixB_f : c_obj list -> c_obj list = "_wrap_new_EurLiborSwapIsdaFixBQuantLib" ;;
let _new_EurLiborSwapIsdaFixB arg = match _new_EurLiborSwapIsdaFixB_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurLiborSwapIsdaFixB_f : c_obj list -> c_obj list = "_wrap_delete_EurLiborSwapIsdaFixBQuantLib" ;;
let _delete_EurLiborSwapIsdaFixB arg = match _delete_EurLiborSwapIsdaFixB_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurLiborSwapIfrFix_f : c_obj list -> c_obj list = "_wrap_new_EurLiborSwapIfrFix__SWIG_0QuantLib" ;;
let _new_EurLiborSwapIfrFix arg = match _new_EurLiborSwapIfrFix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EurLiborSwapIfrFix_f : c_obj list -> c_obj list = "_wrap_new_EurLiborSwapIfrFixQuantLib" ;;
let _new_EurLiborSwapIfrFix arg = match _new_EurLiborSwapIfrFix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EurLiborSwapIfrFix_f : c_obj list -> c_obj list = "_wrap_delete_EurLiborSwapIfrFixQuantLib" ;;
let _delete_EurLiborSwapIfrFix arg = match _delete_EurLiborSwapIfrFix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Brent_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Brent_setMaxEvaluationsQuantLib" ;;
let _Brent_setMaxEvaluations arg = match _Brent_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Brent_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Brent_setLowerBoundQuantLib" ;;
let _Brent_setLowerBound arg = match _Brent_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Brent_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Brent_setUpperBoundQuantLib" ;;
let _Brent_setUpperBound arg = match _Brent_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Brent_f : c_obj list -> c_obj list = "_wrap_new_BrentQuantLib" ;;
let _new_Brent arg = match _new_Brent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Brent_f : c_obj list -> c_obj list = "_wrap_delete_BrentQuantLib" ;;
let _delete_Brent arg = match _delete_Brent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bisection_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Bisection_setMaxEvaluationsQuantLib" ;;
let _Bisection_setMaxEvaluations arg = match _Bisection_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bisection_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Bisection_setLowerBoundQuantLib" ;;
let _Bisection_setLowerBound arg = match _Bisection_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bisection_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Bisection_setUpperBoundQuantLib" ;;
let _Bisection_setUpperBound arg = match _Bisection_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Bisection_f : c_obj list -> c_obj list = "_wrap_new_BisectionQuantLib" ;;
let _new_Bisection arg = match _new_Bisection_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Bisection_f : c_obj list -> c_obj list = "_wrap_delete_BisectionQuantLib" ;;
let _delete_Bisection arg = match _delete_Bisection_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FalsePosition_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_FalsePosition_setMaxEvaluationsQuantLib" ;;
let _FalsePosition_setMaxEvaluations arg = match _FalsePosition_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FalsePosition_setLowerBound_f : c_obj list -> c_obj list = "_wrap_FalsePosition_setLowerBoundQuantLib" ;;
let _FalsePosition_setLowerBound arg = match _FalsePosition_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FalsePosition_setUpperBound_f : c_obj list -> c_obj list = "_wrap_FalsePosition_setUpperBoundQuantLib" ;;
let _FalsePosition_setUpperBound arg = match _FalsePosition_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FalsePosition_f : c_obj list -> c_obj list = "_wrap_new_FalsePositionQuantLib" ;;
let _new_FalsePosition arg = match _new_FalsePosition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FalsePosition_f : c_obj list -> c_obj list = "_wrap_delete_FalsePositionQuantLib" ;;
let _delete_FalsePosition arg = match _delete_FalsePosition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Ridder_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Ridder_setMaxEvaluationsQuantLib" ;;
let _Ridder_setMaxEvaluations arg = match _Ridder_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Ridder_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Ridder_setLowerBoundQuantLib" ;;
let _Ridder_setLowerBound arg = match _Ridder_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Ridder_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Ridder_setUpperBoundQuantLib" ;;
let _Ridder_setUpperBound arg = match _Ridder_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Ridder_f : c_obj list -> c_obj list = "_wrap_new_RidderQuantLib" ;;
let _new_Ridder arg = match _new_Ridder_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Ridder_f : c_obj list -> c_obj list = "_wrap_delete_RidderQuantLib" ;;
let _delete_Ridder arg = match _delete_Ridder_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Secant_setMaxEvaluations_f : c_obj list -> c_obj list = "_wrap_Secant_setMaxEvaluationsQuantLib" ;;
let _Secant_setMaxEvaluations arg = match _Secant_setMaxEvaluations_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Secant_setLowerBound_f : c_obj list -> c_obj list = "_wrap_Secant_setLowerBoundQuantLib" ;;
let _Secant_setLowerBound arg = match _Secant_setLowerBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Secant_setUpperBound_f : c_obj list -> c_obj list = "_wrap_Secant_setUpperBoundQuantLib" ;;
let _Secant_setUpperBound arg = match _Secant_setUpperBound_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Secant_f : c_obj list -> c_obj list = "_wrap_new_SecantQuantLib" ;;
let _new_Secant arg = match _new_Secant_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Secant_f : c_obj list -> c_obj list = "_wrap_delete_SecantQuantLib" ;;
let _delete_Secant arg = match _delete_Secant_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Constraint_f : c_obj list -> c_obj list = "_wrap_delete_ConstraintQuantLib" ;;
let _delete_Constraint arg = match _delete_Constraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoundaryConstraint_f : c_obj list -> c_obj list = "_wrap_new_BoundaryConstraintQuantLib" ;;
let _new_BoundaryConstraint arg = match _new_BoundaryConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoundaryConstraint_f : c_obj list -> c_obj list = "_wrap_delete_BoundaryConstraintQuantLib" ;;
let _delete_BoundaryConstraint arg = match _delete_BoundaryConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NoConstraint_f : c_obj list -> c_obj list = "_wrap_new_NoConstraintQuantLib" ;;
let _new_NoConstraint arg = match _new_NoConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NoConstraint_f : c_obj list -> c_obj list = "_wrap_delete_NoConstraintQuantLib" ;;
let _delete_NoConstraint arg = match _delete_NoConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PositiveConstraint_f : c_obj list -> c_obj list = "_wrap_new_PositiveConstraintQuantLib" ;;
let _new_PositiveConstraint arg = match _new_PositiveConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PositiveConstraint_f : c_obj list -> c_obj list = "_wrap_delete_PositiveConstraintQuantLib" ;;
let _delete_PositiveConstraint arg = match _delete_PositiveConstraint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "EndCriteria::Type_marker" (`Type)
external _MaxIterations : c_obj -> Swig.c_obj = "_wrap_MaxIterations" 
external _StationaryPoint : c_obj -> Swig.c_obj = "_wrap_StationaryPoint" 
external _StationaryFunctionValue : c_obj -> Swig.c_obj = "_wrap_StationaryFunctionValue" 
external _StationaryFunctionAccuracy : c_obj -> Swig.c_obj = "_wrap_StationaryFunctionAccuracy" 
external _ZeroGradientNorm : c_obj -> Swig.c_obj = "_wrap_ZeroGradientNorm" 
external _Unknown : c_obj -> Swig.c_obj = "_wrap_Unknown" 
external _new_EndCriteria_f : c_obj list -> c_obj list = "_wrap_new_EndCriteriaQuantLib" ;;
let _new_EndCriteria arg = match _new_EndCriteria_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _EndCriteria_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_EndCriteria_operator_pP___QuantLib" ;;
let _EndCriteria_operator_xx_xx_lparen_xx_rparen arg = match _EndCriteria_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EndCriteria_f : c_obj list -> c_obj list = "_wrap_delete_EndCriteriaQuantLib" ;;
let _delete_EndCriteria arg = match _delete_EndCriteria_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_OptimizationMethod_f : c_obj list -> c_obj list = "_wrap_delete_OptimizationMethodQuantLib" ;;
let _delete_OptimizationMethod arg = match _delete_OptimizationMethod_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConjugateGradient_f : c_obj list -> c_obj list = "_wrap_new_ConjugateGradientQuantLib" ;;
let _new_ConjugateGradient arg = match _new_ConjugateGradient_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConjugateGradient_f : c_obj list -> c_obj list = "_wrap_delete_ConjugateGradientQuantLib" ;;
let _delete_ConjugateGradient arg = match _delete_ConjugateGradient_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Simplex_f : c_obj list -> c_obj list = "_wrap_new_SimplexQuantLib" ;;
let _new_Simplex arg = match _new_Simplex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Simplex_f : c_obj list -> c_obj list = "_wrap_delete_SimplexQuantLib" ;;
let _delete_Simplex arg = match _delete_Simplex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SteepestDescent_f : c_obj list -> c_obj list = "_wrap_new_SteepestDescentQuantLib" ;;
let _new_SteepestDescent arg = match _new_SteepestDescent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SteepestDescent_f : c_obj list -> c_obj list = "_wrap_delete_SteepestDescentQuantLib" ;;
let _delete_SteepestDescent arg = match _delete_SteepestDescent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BFGS_f : c_obj list -> c_obj list = "_wrap_new_BFGSQuantLib" ;;
let _new_BFGS arg = match _new_BFGS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BFGS_f : c_obj list -> c_obj list = "_wrap_delete_BFGSQuantLib" ;;
let _delete_BFGS arg = match _delete_BFGS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Optimizer_f : c_obj list -> c_obj list = "_wrap_new_OptimizerQuantLib" ;;
let _new_Optimizer arg = match _new_Optimizer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Optimizer_f : c_obj list -> c_obj list = "_wrap_delete_OptimizerQuantLib" ;;
let _delete_Optimizer arg = match _delete_Optimizer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure___deref__QuantLib" ;;
let _BlackVolTermStructure___deref__ arg = match _BlackVolTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_isNullQuantLib" ;;
let _BlackVolTermStructure_isNull arg = match _BlackVolTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_asObservableQuantLib" ;;
let _BlackVolTermStructure_asObservable arg = match _BlackVolTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructure_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureQuantLib" ;;
let _new_BlackVolTermStructure arg = match _new_BlackVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackVolTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_BlackVolTermStructureQuantLib" ;;
let _delete_BlackVolTermStructure arg = match _delete_BlackVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_referenceDateQuantLib" ;;
let _BlackVolTermStructure_referenceDate arg = match _BlackVolTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_dayCounterQuantLib" ;;
let _BlackVolTermStructure_dayCounter arg = match _BlackVolTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_calendarQuantLib" ;;
let _BlackVolTermStructure_calendar arg = match _BlackVolTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_maxDateQuantLib" ;;
let _BlackVolTermStructure_maxDate arg = match _BlackVolTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_maxTimeQuantLib" ;;
let _BlackVolTermStructure_maxTime arg = match _BlackVolTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_minStrikeQuantLib" ;;
let _BlackVolTermStructure_minStrike arg = match _BlackVolTermStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_maxStrikeQuantLib" ;;
let _BlackVolTermStructure_maxStrike arg = match _BlackVolTermStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVolQuantLib" ;;
let _BlackVolTermStructure_blackVol arg = match _BlackVolTermStructure_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackVarianceQuantLib" ;;
let _BlackVolTermStructure_blackVariance arg = match _BlackVolTermStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVolQuantLib" ;;
let _BlackVolTermStructure_blackForwardVol arg = match _BlackVolTermStructure_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_blackForwardVarianceQuantLib" ;;
let _BlackVolTermStructure_blackForwardVariance arg = match _BlackVolTermStructure_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_enableExtrapolationQuantLib" ;;
let _BlackVolTermStructure_enableExtrapolation arg = match _BlackVolTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_disableExtrapolationQuantLib" ;;
let _BlackVolTermStructure_disableExtrapolation arg = match _BlackVolTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructure_allowsExtrapolationQuantLib" ;;
let _BlackVolTermStructure_allowsExtrapolation arg = match _BlackVolTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_BlackVolTermStructureHandle arg = match _new_BlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_BlackVolTermStructureHandleQuantLib" ;;
let _new_BlackVolTermStructureHandle arg = match _new_BlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle___deref__QuantLib" ;;
let _BlackVolTermStructureHandle___deref__ arg = match _BlackVolTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_emptyQuantLib" ;;
let _BlackVolTermStructureHandle_empty arg = match _BlackVolTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_asObservableQuantLib" ;;
let _BlackVolTermStructureHandle_asObservable arg = match _BlackVolTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_BlackVolTermStructureHandleQuantLib" ;;
let _delete_BlackVolTermStructureHandle arg = match _delete_BlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_referenceDateQuantLib" ;;
let _BlackVolTermStructureHandle_referenceDate arg = match _BlackVolTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_dayCounterQuantLib" ;;
let _BlackVolTermStructureHandle_dayCounter arg = match _BlackVolTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_calendarQuantLib" ;;
let _BlackVolTermStructureHandle_calendar arg = match _BlackVolTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_maxDateQuantLib" ;;
let _BlackVolTermStructureHandle_maxDate arg = match _BlackVolTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_maxTimeQuantLib" ;;
let _BlackVolTermStructureHandle_maxTime arg = match _BlackVolTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_minStrikeQuantLib" ;;
let _BlackVolTermStructureHandle_minStrike arg = match _BlackVolTermStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_maxStrikeQuantLib" ;;
let _BlackVolTermStructureHandle_maxStrike arg = match _BlackVolTermStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVolQuantLib" ;;
let _BlackVolTermStructureHandle_blackVol arg = match _BlackVolTermStructureHandle_blackVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackVarianceQuantLib" ;;
let _BlackVolTermStructureHandle_blackVariance arg = match _BlackVolTermStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVol_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVolQuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVol arg = match _BlackVolTermStructureHandle_blackForwardVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_2QuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_blackForwardVariance_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_blackForwardVarianceQuantLib" ;;
let _BlackVolTermStructureHandle_blackForwardVariance arg = match _BlackVolTermStructureHandle_blackForwardVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_enableExtrapolationQuantLib" ;;
let _BlackVolTermStructureHandle_enableExtrapolation arg = match _BlackVolTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_disableExtrapolationQuantLib" ;;
let _BlackVolTermStructureHandle_disableExtrapolation arg = match _BlackVolTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVolTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_BlackVolTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _BlackVolTermStructureHandle_allowsExtrapolation arg = match _BlackVolTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableBlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableBlackVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableBlackVolTermStructureHandle arg = match _new_RelinkableBlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableBlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableBlackVolTermStructureHandleQuantLib" ;;
let _new_RelinkableBlackVolTermStructureHandle arg = match _new_RelinkableBlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableBlackVolTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableBlackVolTermStructureHandle_linkToQuantLib" ;;
let _RelinkableBlackVolTermStructureHandle_linkTo arg = match _RelinkableBlackVolTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableBlackVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableBlackVolTermStructureHandleQuantLib" ;;
let _delete_RelinkableBlackVolTermStructureHandle arg = match _delete_RelinkableBlackVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure___deref__QuantLib" ;;
let _LocalVolTermStructure___deref__ arg = match _LocalVolTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_isNullQuantLib" ;;
let _LocalVolTermStructure_isNull arg = match _LocalVolTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_asObservableQuantLib" ;;
let _LocalVolTermStructure_asObservable arg = match _LocalVolTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalVolTermStructure_f : c_obj list -> c_obj list = "_wrap_new_LocalVolTermStructureQuantLib" ;;
let _new_LocalVolTermStructure arg = match _new_LocalVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LocalVolTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_LocalVolTermStructureQuantLib" ;;
let _delete_LocalVolTermStructure arg = match _delete_LocalVolTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_referenceDateQuantLib" ;;
let _LocalVolTermStructure_referenceDate arg = match _LocalVolTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_dayCounterQuantLib" ;;
let _LocalVolTermStructure_dayCounter arg = match _LocalVolTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_calendarQuantLib" ;;
let _LocalVolTermStructure_calendar arg = match _LocalVolTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_maxDateQuantLib" ;;
let _LocalVolTermStructure_maxDate arg = match _LocalVolTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_maxTimeQuantLib" ;;
let _LocalVolTermStructure_maxTime arg = match _LocalVolTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_minStrikeQuantLib" ;;
let _LocalVolTermStructure_minStrike arg = match _LocalVolTermStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_maxStrikeQuantLib" ;;
let _LocalVolTermStructure_maxStrike arg = match _LocalVolTermStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVol__SWIG_0QuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVol__SWIG_1QuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVol__SWIG_2QuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_localVolQuantLib" ;;
let _LocalVolTermStructure_localVol arg = match _LocalVolTermStructure_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_enableExtrapolationQuantLib" ;;
let _LocalVolTermStructure_enableExtrapolation arg = match _LocalVolTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_disableExtrapolationQuantLib" ;;
let _LocalVolTermStructure_disableExtrapolation arg = match _LocalVolTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructure_allowsExtrapolationQuantLib" ;;
let _LocalVolTermStructure_allowsExtrapolation arg = match _LocalVolTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_LocalVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_LocalVolTermStructureHandle arg = match _new_LocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_LocalVolTermStructureHandleQuantLib" ;;
let _new_LocalVolTermStructureHandle arg = match _new_LocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle___deref__QuantLib" ;;
let _LocalVolTermStructureHandle___deref__ arg = match _LocalVolTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_emptyQuantLib" ;;
let _LocalVolTermStructureHandle_empty arg = match _LocalVolTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_asObservableQuantLib" ;;
let _LocalVolTermStructureHandle_asObservable arg = match _LocalVolTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_LocalVolTermStructureHandleQuantLib" ;;
let _delete_LocalVolTermStructureHandle arg = match _delete_LocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_referenceDateQuantLib" ;;
let _LocalVolTermStructureHandle_referenceDate arg = match _LocalVolTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_dayCounterQuantLib" ;;
let _LocalVolTermStructureHandle_dayCounter arg = match _LocalVolTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_calendarQuantLib" ;;
let _LocalVolTermStructureHandle_calendar arg = match _LocalVolTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_maxDateQuantLib" ;;
let _LocalVolTermStructureHandle_maxDate arg = match _LocalVolTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_maxTimeQuantLib" ;;
let _LocalVolTermStructureHandle_maxTime arg = match _LocalVolTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_minStrikeQuantLib" ;;
let _LocalVolTermStructureHandle_minStrike arg = match _LocalVolTermStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_maxStrikeQuantLib" ;;
let _LocalVolTermStructureHandle_maxStrike arg = match _LocalVolTermStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVol__SWIG_0QuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVol__SWIG_1QuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVol__SWIG_2QuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_localVol_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_localVolQuantLib" ;;
let _LocalVolTermStructureHandle_localVol arg = match _LocalVolTermStructureHandle_localVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_enableExtrapolationQuantLib" ;;
let _LocalVolTermStructureHandle_enableExtrapolation arg = match _LocalVolTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_disableExtrapolationQuantLib" ;;
let _LocalVolTermStructureHandle_disableExtrapolation arg = match _LocalVolTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LocalVolTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_LocalVolTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _LocalVolTermStructureHandle_allowsExtrapolation arg = match _LocalVolTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableLocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableLocalVolTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableLocalVolTermStructureHandle arg = match _new_RelinkableLocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableLocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableLocalVolTermStructureHandleQuantLib" ;;
let _new_RelinkableLocalVolTermStructureHandle arg = match _new_RelinkableLocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableLocalVolTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableLocalVolTermStructureHandle_linkToQuantLib" ;;
let _RelinkableLocalVolTermStructureHandle_linkTo arg = match _RelinkableLocalVolTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableLocalVolTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableLocalVolTermStructureHandleQuantLib" ;;
let _delete_RelinkableLocalVolTermStructureHandle arg = match _delete_RelinkableLocalVolTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure___deref___f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure___deref__QuantLib" ;;
let _OptionletVolatilityStructure___deref__ arg = match _OptionletVolatilityStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_isNull_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_isNullQuantLib" ;;
let _OptionletVolatilityStructure_isNull arg = match _OptionletVolatilityStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_asObservableQuantLib" ;;
let _OptionletVolatilityStructure_asObservable arg = match _OptionletVolatilityStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OptionletVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_new_OptionletVolatilityStructureQuantLib" ;;
let _new_OptionletVolatilityStructure arg = match _new_OptionletVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_OptionletVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_delete_OptionletVolatilityStructureQuantLib" ;;
let _delete_OptionletVolatilityStructure arg = match _delete_OptionletVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_referenceDateQuantLib" ;;
let _OptionletVolatilityStructure_referenceDate arg = match _OptionletVolatilityStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_dayCounterQuantLib" ;;
let _OptionletVolatilityStructure_dayCounter arg = match _OptionletVolatilityStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_calendar_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_calendarQuantLib" ;;
let _OptionletVolatilityStructure_calendar arg = match _OptionletVolatilityStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_maxDateQuantLib" ;;
let _OptionletVolatilityStructure_maxDate arg = match _OptionletVolatilityStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_maxTimeQuantLib" ;;
let _OptionletVolatilityStructure_maxTime arg = match _OptionletVolatilityStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_minStrikeQuantLib" ;;
let _OptionletVolatilityStructure_minStrike arg = match _OptionletVolatilityStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_maxStrikeQuantLib" ;;
let _OptionletVolatilityStructure_maxStrike arg = match _OptionletVolatilityStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_volatility__SWIG_0QuantLib" ;;
let _OptionletVolatilityStructure_volatility arg = match _OptionletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_volatility__SWIG_1QuantLib" ;;
let _OptionletVolatilityStructure_volatility arg = match _OptionletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_volatility__SWIG_2QuantLib" ;;
let _OptionletVolatilityStructure_volatility arg = match _OptionletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_volatilityQuantLib" ;;
let _OptionletVolatilityStructure_volatility arg = match _OptionletVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_blackVariance__SWIG_0QuantLib" ;;
let _OptionletVolatilityStructure_blackVariance arg = match _OptionletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_blackVariance__SWIG_1QuantLib" ;;
let _OptionletVolatilityStructure_blackVariance arg = match _OptionletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_blackVariance__SWIG_2QuantLib" ;;
let _OptionletVolatilityStructure_blackVariance arg = match _OptionletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_blackVarianceQuantLib" ;;
let _OptionletVolatilityStructure_blackVariance arg = match _OptionletVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_enableExtrapolationQuantLib" ;;
let _OptionletVolatilityStructure_enableExtrapolation arg = match _OptionletVolatilityStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_disableExtrapolationQuantLib" ;;
let _OptionletVolatilityStructure_disableExtrapolation arg = match _OptionletVolatilityStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructure_allowsExtrapolationQuantLib" ;;
let _OptionletVolatilityStructure_allowsExtrapolation arg = match _OptionletVolatilityStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OptionletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_OptionletVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_OptionletVolatilityStructureHandle arg = match _new_OptionletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OptionletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_OptionletVolatilityStructureHandleQuantLib" ;;
let _new_OptionletVolatilityStructureHandle arg = match _new_OptionletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle___deref__QuantLib" ;;
let _OptionletVolatilityStructureHandle___deref__ arg = match _OptionletVolatilityStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_emptyQuantLib" ;;
let _OptionletVolatilityStructureHandle_empty arg = match _OptionletVolatilityStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_asObservableQuantLib" ;;
let _OptionletVolatilityStructureHandle_asObservable arg = match _OptionletVolatilityStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_OptionletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_OptionletVolatilityStructureHandleQuantLib" ;;
let _delete_OptionletVolatilityStructureHandle arg = match _delete_OptionletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_referenceDateQuantLib" ;;
let _OptionletVolatilityStructureHandle_referenceDate arg = match _OptionletVolatilityStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_dayCounterQuantLib" ;;
let _OptionletVolatilityStructureHandle_dayCounter arg = match _OptionletVolatilityStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_calendarQuantLib" ;;
let _OptionletVolatilityStructureHandle_calendar arg = match _OptionletVolatilityStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_maxDateQuantLib" ;;
let _OptionletVolatilityStructureHandle_maxDate arg = match _OptionletVolatilityStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_maxTimeQuantLib" ;;
let _OptionletVolatilityStructureHandle_maxTime arg = match _OptionletVolatilityStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_minStrikeQuantLib" ;;
let _OptionletVolatilityStructureHandle_minStrike arg = match _OptionletVolatilityStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_maxStrikeQuantLib" ;;
let _OptionletVolatilityStructureHandle_maxStrike arg = match _OptionletVolatilityStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_volatility__SWIG_0QuantLib" ;;
let _OptionletVolatilityStructureHandle_volatility arg = match _OptionletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_volatility__SWIG_1QuantLib" ;;
let _OptionletVolatilityStructureHandle_volatility arg = match _OptionletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_volatility__SWIG_2QuantLib" ;;
let _OptionletVolatilityStructureHandle_volatility arg = match _OptionletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_volatilityQuantLib" ;;
let _OptionletVolatilityStructureHandle_volatility arg = match _OptionletVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_blackVariance__SWIG_0QuantLib" ;;
let _OptionletVolatilityStructureHandle_blackVariance arg = match _OptionletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_blackVariance__SWIG_1QuantLib" ;;
let _OptionletVolatilityStructureHandle_blackVariance arg = match _OptionletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_blackVariance__SWIG_2QuantLib" ;;
let _OptionletVolatilityStructureHandle_blackVariance arg = match _OptionletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_blackVarianceQuantLib" ;;
let _OptionletVolatilityStructureHandle_blackVariance arg = match _OptionletVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_enableExtrapolationQuantLib" ;;
let _OptionletVolatilityStructureHandle_enableExtrapolation arg = match _OptionletVolatilityStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_disableExtrapolationQuantLib" ;;
let _OptionletVolatilityStructureHandle_disableExtrapolation arg = match _OptionletVolatilityStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionletVolatilityStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_OptionletVolatilityStructureHandle_allowsExtrapolationQuantLib" ;;
let _OptionletVolatilityStructureHandle_allowsExtrapolation arg = match _OptionletVolatilityStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableOptionletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableOptionletVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableOptionletVolatilityStructureHandle arg = match _new_RelinkableOptionletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableOptionletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableOptionletVolatilityStructureHandleQuantLib" ;;
let _new_RelinkableOptionletVolatilityStructureHandle arg = match _new_RelinkableOptionletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableOptionletVolatilityStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableOptionletVolatilityStructureHandle_linkToQuantLib" ;;
let _RelinkableOptionletVolatilityStructureHandle_linkTo arg = match _RelinkableOptionletVolatilityStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableOptionletVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableOptionletVolatilityStructureHandleQuantLib" ;;
let _delete_RelinkableOptionletVolatilityStructureHandle arg = match _delete_RelinkableOptionletVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure___deref___f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure___deref__QuantLib" ;;
let _SwaptionVolatilityStructure___deref__ arg = match _SwaptionVolatilityStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_isNull_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_isNullQuantLib" ;;
let _SwaptionVolatilityStructure_isNull arg = match _SwaptionVolatilityStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_asObservableQuantLib" ;;
let _SwaptionVolatilityStructure_asObservable arg = match _SwaptionVolatilityStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityStructureQuantLib" ;;
let _new_SwaptionVolatilityStructure arg = match _new_SwaptionVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolatilityStructure_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolatilityStructureQuantLib" ;;
let _delete_SwaptionVolatilityStructure arg = match _delete_SwaptionVolatilityStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_referenceDateQuantLib" ;;
let _SwaptionVolatilityStructure_referenceDate arg = match _SwaptionVolatilityStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_dayCounterQuantLib" ;;
let _SwaptionVolatilityStructure_dayCounter arg = match _SwaptionVolatilityStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_calendar_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_calendarQuantLib" ;;
let _SwaptionVolatilityStructure_calendar arg = match _SwaptionVolatilityStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_maxSwapTenor_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_maxSwapTenorQuantLib" ;;
let _SwaptionVolatilityStructure_maxSwapTenor arg = match _SwaptionVolatilityStructure_maxSwapTenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_maxSwapLength_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_maxSwapLengthQuantLib" ;;
let _SwaptionVolatilityStructure_maxSwapLength arg = match _SwaptionVolatilityStructure_maxSwapLength_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_minStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_minStrikeQuantLib" ;;
let _SwaptionVolatilityStructure_minStrike arg = match _SwaptionVolatilityStructure_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_maxStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_maxStrikeQuantLib" ;;
let _SwaptionVolatilityStructure_maxStrike arg = match _SwaptionVolatilityStructure_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatility__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatility__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatility__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_volatilityQuantLib" ;;
let _SwaptionVolatilityStructure_volatility arg = match _SwaptionVolatilityStructure_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVariance__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVariance__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVariance__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_blackVarianceQuantLib" ;;
let _SwaptionVolatilityStructure_blackVariance arg = match _SwaptionVolatilityStructure_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_enableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructure_enableExtrapolation arg = match _SwaptionVolatilityStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_disableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructure_disableExtrapolation arg = match _SwaptionVolatilityStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructure_allowsExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructure_allowsExtrapolation arg = match _SwaptionVolatilityStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_SwaptionVolatilityStructureHandle arg = match _new_SwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityStructureHandleQuantLib" ;;
let _new_SwaptionVolatilityStructureHandle arg = match _new_SwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle___deref__QuantLib" ;;
let _SwaptionVolatilityStructureHandle___deref__ arg = match _SwaptionVolatilityStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_emptyQuantLib" ;;
let _SwaptionVolatilityStructureHandle_empty arg = match _SwaptionVolatilityStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_asObservableQuantLib" ;;
let _SwaptionVolatilityStructureHandle_asObservable arg = match _SwaptionVolatilityStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolatilityStructureHandleQuantLib" ;;
let _delete_SwaptionVolatilityStructureHandle arg = match _delete_SwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_referenceDateQuantLib" ;;
let _SwaptionVolatilityStructureHandle_referenceDate arg = match _SwaptionVolatilityStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_dayCounterQuantLib" ;;
let _SwaptionVolatilityStructureHandle_dayCounter arg = match _SwaptionVolatilityStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_calendarQuantLib" ;;
let _SwaptionVolatilityStructureHandle_calendar arg = match _SwaptionVolatilityStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_maxSwapTenor_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_maxSwapTenorQuantLib" ;;
let _SwaptionVolatilityStructureHandle_maxSwapTenor arg = match _SwaptionVolatilityStructureHandle_maxSwapTenor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_maxSwapLength_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_maxSwapLengthQuantLib" ;;
let _SwaptionVolatilityStructureHandle_maxSwapLength arg = match _SwaptionVolatilityStructureHandle_maxSwapLength_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_minStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_minStrikeQuantLib" ;;
let _SwaptionVolatilityStructureHandle_minStrike arg = match _SwaptionVolatilityStructureHandle_minStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_maxStrike_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_maxStrikeQuantLib" ;;
let _SwaptionVolatilityStructureHandle_maxStrike arg = match _SwaptionVolatilityStructureHandle_maxStrike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatility__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatility__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatility__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_volatility_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_volatilityQuantLib" ;;
let _SwaptionVolatilityStructureHandle_volatility arg = match _SwaptionVolatilityStructureHandle_volatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVariance__SWIG_0QuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVariance__SWIG_1QuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVariance__SWIG_2QuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_blackVariance_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_blackVarianceQuantLib" ;;
let _SwaptionVolatilityStructureHandle_blackVariance arg = match _SwaptionVolatilityStructureHandle_blackVariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_enableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructureHandle_enableExtrapolation arg = match _SwaptionVolatilityStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_disableExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructureHandle_disableExtrapolation arg = match _SwaptionVolatilityStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionVolatilityStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_SwaptionVolatilityStructureHandle_allowsExtrapolationQuantLib" ;;
let _SwaptionVolatilityStructureHandle_allowsExtrapolation arg = match _SwaptionVolatilityStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableSwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableSwaptionVolatilityStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableSwaptionVolatilityStructureHandle arg = match _new_RelinkableSwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableSwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableSwaptionVolatilityStructureHandleQuantLib" ;;
let _new_RelinkableSwaptionVolatilityStructureHandle arg = match _new_RelinkableSwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableSwaptionVolatilityStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableSwaptionVolatilityStructureHandle_linkToQuantLib" ;;
let _RelinkableSwaptionVolatilityStructureHandle_linkTo arg = match _RelinkableSwaptionVolatilityStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableSwaptionVolatilityStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableSwaptionVolatilityStructureHandleQuantLib" ;;
let _delete_RelinkableSwaptionVolatilityStructureHandle arg = match _delete_RelinkableSwaptionVolatilityStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVol__SWIG_0QuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVol__SWIG_1QuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVol__SWIG_2QuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_new_BlackConstantVolQuantLib" ;;
let _new_BlackConstantVol arg = match _new_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackConstantVol_f : c_obj list -> c_obj list = "_wrap_delete_BlackConstantVolQuantLib" ;;
let _delete_BlackConstantVol arg = match _delete_BlackConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceCurve_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceCurve__SWIG_0QuantLib" ;;
let _new_BlackVarianceCurve arg = match _new_BlackVarianceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceCurve_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceCurveQuantLib" ;;
let _new_BlackVarianceCurve arg = match _new_BlackVarianceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackVarianceCurve_f : c_obj list -> c_obj list = "_wrap_delete_BlackVarianceCurveQuantLib" ;;
let _delete_BlackVarianceCurve arg = match _delete_BlackVarianceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceSurface__SWIG_0QuantLib" ;;
let _new_BlackVarianceSurface arg = match _new_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceSurface__SWIG_1QuantLib" ;;
let _new_BlackVarianceSurface arg = match _new_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_new_BlackVarianceSurfaceQuantLib" ;;
let _new_BlackVarianceSurface arg = match _new_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackVarianceSurface_ConstantExtrapolation : c_obj -> Swig.c_obj = "_wrap_BlackVarianceSurface_ConstantExtrapolation" 
external _BlackVarianceSurface_InterpolatorDefaultExtrapolation : c_obj -> Swig.c_obj = "_wrap_BlackVarianceSurface_InterpolatorDefaultExtrapolation" 
external _delete_BlackVarianceSurface_f : c_obj list -> c_obj list = "_wrap_delete_BlackVarianceSurfaceQuantLib" ;;
let _delete_BlackVarianceSurface arg = match _delete_BlackVarianceSurface_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVol__SWIG_0QuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVol__SWIG_1QuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVol__SWIG_2QuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_new_LocalConstantVolQuantLib" ;;
let _new_LocalConstantVol arg = match _new_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LocalConstantVol_f : c_obj list -> c_obj list = "_wrap_delete_LocalConstantVolQuantLib" ;;
let _delete_LocalConstantVol arg = match _delete_LocalConstantVol_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantOptionletVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantOptionletVolatility__SWIG_0QuantLib" ;;
let _new_ConstantOptionletVolatility arg = match _new_ConstantOptionletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantOptionletVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantOptionletVolatility__SWIG_1QuantLib" ;;
let _new_ConstantOptionletVolatility arg = match _new_ConstantOptionletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantOptionletVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantOptionletVolatility__SWIG_2QuantLib" ;;
let _new_ConstantOptionletVolatility arg = match _new_ConstantOptionletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantOptionletVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantOptionletVolatilityQuantLib" ;;
let _new_ConstantOptionletVolatility arg = match _new_ConstantOptionletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConstantOptionletVolatility_f : c_obj list -> c_obj list = "_wrap_delete_ConstantOptionletVolatilityQuantLib" ;;
let _delete_ConstantOptionletVolatility arg = match _delete_ConstantOptionletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantSwaptionVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantSwaptionVolatility__SWIG_0QuantLib" ;;
let _new_ConstantSwaptionVolatility arg = match _new_ConstantSwaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantSwaptionVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantSwaptionVolatility__SWIG_1QuantLib" ;;
let _new_ConstantSwaptionVolatility arg = match _new_ConstantSwaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantSwaptionVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantSwaptionVolatility__SWIG_2QuantLib" ;;
let _new_ConstantSwaptionVolatility arg = match _new_ConstantSwaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConstantSwaptionVolatility_f : c_obj list -> c_obj list = "_wrap_new_ConstantSwaptionVolatilityQuantLib" ;;
let _new_ConstantSwaptionVolatility arg = match _new_ConstantSwaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConstantSwaptionVolatility_f : c_obj list -> c_obj list = "_wrap_delete_ConstantSwaptionVolatilityQuantLib" ;;
let _delete_ConstantSwaptionVolatility arg = match _delete_ConstantSwaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityMatrix_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityMatrix__SWIG_0QuantLib" ;;
let _new_SwaptionVolatilityMatrix arg = match _new_SwaptionVolatilityMatrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityMatrix_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityMatrix__SWIG_1QuantLib" ;;
let _new_SwaptionVolatilityMatrix arg = match _new_SwaptionVolatilityMatrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolatilityMatrix_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolatilityMatrixQuantLib" ;;
let _new_SwaptionVolatilityMatrix arg = match _new_SwaptionVolatilityMatrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolatilityMatrix_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolatilityMatrixQuantLib" ;;
let _delete_SwaptionVolatilityMatrix arg = match _delete_SwaptionVolatilityMatrix_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolCube1_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolCube1__SWIG_0QuantLib" ;;
let _new_SwaptionVolCube1 arg = match _new_SwaptionVolCube1_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolCube1_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolCube1__SWIG_1QuantLib" ;;
let _new_SwaptionVolCube1 arg = match _new_SwaptionVolCube1_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolCube1_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolCube1__SWIG_2QuantLib" ;;
let _new_SwaptionVolCube1 arg = match _new_SwaptionVolCube1_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolCube1_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolCube1QuantLib" ;;
let _new_SwaptionVolCube1 arg = match _new_SwaptionVolCube1_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolCube1_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolCube1QuantLib" ;;
let _delete_SwaptionVolCube1 arg = match _delete_SwaptionVolCube1_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionVolCube2_f : c_obj list -> c_obj list = "_wrap_new_SwaptionVolCube2QuantLib" ;;
let _new_SwaptionVolCube2 arg = match _new_SwaptionVolCube2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionVolCube2_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionVolCube2QuantLib" ;;
let _delete_SwaptionVolCube2 arg = match _delete_SwaptionVolCube2_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcess___deref___f : c_obj list -> c_obj list = "_wrap_StochasticProcess___deref__QuantLib" ;;
let _StochasticProcess___deref__ arg = match _StochasticProcess___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcess_isNull_f : c_obj list -> c_obj list = "_wrap_StochasticProcess_isNullQuantLib" ;;
let _StochasticProcess_isNull arg = match _StochasticProcess_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcess_asObservable_f : c_obj list -> c_obj list = "_wrap_StochasticProcess_asObservableQuantLib" ;;
let _StochasticProcess_asObservable arg = match _StochasticProcess_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcess_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessQuantLib" ;;
let _new_StochasticProcess arg = match _new_StochasticProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcess_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcessQuantLib" ;;
let _delete_StochasticProcess arg = match _delete_StochasticProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcess1D_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcess1DQuantLib" ;;
let _delete_StochasticProcess1D arg = match _delete_StochasticProcess1D_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GeneralizedBlackScholesProcess_f : c_obj list -> c_obj list = "_wrap_new_GeneralizedBlackScholesProcessQuantLib" ;;
let _new_GeneralizedBlackScholesProcess arg = match _new_GeneralizedBlackScholesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GeneralizedBlackScholesProcess_stateVariable_f : c_obj list -> c_obj list = "_wrap_GeneralizedBlackScholesProcess_stateVariableQuantLib" ;;
let _GeneralizedBlackScholesProcess_stateVariable arg = match _GeneralizedBlackScholesProcess_stateVariable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GeneralizedBlackScholesProcess_dividendYield_f : c_obj list -> c_obj list = "_wrap_GeneralizedBlackScholesProcess_dividendYieldQuantLib" ;;
let _GeneralizedBlackScholesProcess_dividendYield arg = match _GeneralizedBlackScholesProcess_dividendYield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GeneralizedBlackScholesProcess_riskFreeRate_f : c_obj list -> c_obj list = "_wrap_GeneralizedBlackScholesProcess_riskFreeRateQuantLib" ;;
let _GeneralizedBlackScholesProcess_riskFreeRate arg = match _GeneralizedBlackScholesProcess_riskFreeRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GeneralizedBlackScholesProcess_blackVolatility_f : c_obj list -> c_obj list = "_wrap_GeneralizedBlackScholesProcess_blackVolatilityQuantLib" ;;
let _GeneralizedBlackScholesProcess_blackVolatility arg = match _GeneralizedBlackScholesProcess_blackVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GeneralizedBlackScholesProcess_f : c_obj list -> c_obj list = "_wrap_delete_GeneralizedBlackScholesProcessQuantLib" ;;
let _delete_GeneralizedBlackScholesProcess arg = match _delete_GeneralizedBlackScholesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackScholesProcess_f : c_obj list -> c_obj list = "_wrap_new_BlackScholesProcessQuantLib" ;;
let _new_BlackScholesProcess arg = match _new_BlackScholesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackScholesProcess_f : c_obj list -> c_obj list = "_wrap_delete_BlackScholesProcessQuantLib" ;;
let _delete_BlackScholesProcess arg = match _delete_BlackScholesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackScholesMertonProcess_f : c_obj list -> c_obj list = "_wrap_new_BlackScholesMertonProcessQuantLib" ;;
let _new_BlackScholesMertonProcess arg = match _new_BlackScholesMertonProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackScholesMertonProcess_f : c_obj list -> c_obj list = "_wrap_delete_BlackScholesMertonProcessQuantLib" ;;
let _delete_BlackScholesMertonProcess arg = match _delete_BlackScholesMertonProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackProcess_f : c_obj list -> c_obj list = "_wrap_new_BlackProcessQuantLib" ;;
let _new_BlackProcess arg = match _new_BlackProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackProcess_f : c_obj list -> c_obj list = "_wrap_delete_BlackProcessQuantLib" ;;
let _delete_BlackProcess arg = match _delete_BlackProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GarmanKohlagenProcess_f : c_obj list -> c_obj list = "_wrap_new_GarmanKohlagenProcessQuantLib" ;;
let _new_GarmanKohlagenProcess arg = match _new_GarmanKohlagenProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GarmanKohlagenProcess_f : c_obj list -> c_obj list = "_wrap_delete_GarmanKohlagenProcessQuantLib" ;;
let _delete_GarmanKohlagenProcess arg = match _delete_GarmanKohlagenProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Merton76Process_f : c_obj list -> c_obj list = "_wrap_new_Merton76ProcessQuantLib" ;;
let _new_Merton76Process arg = match _new_Merton76Process_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Merton76Process_f : c_obj list -> c_obj list = "_wrap_delete_Merton76ProcessQuantLib" ;;
let _delete_Merton76Process arg = match _delete_Merton76Process_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessArray_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessArrayQuantLib" ;;
let _new_StochasticProcessArray arg = match _new_StochasticProcessArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcessArray_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcessArrayQuantLib" ;;
let _delete_StochasticProcessArray arg = match _delete_StochasticProcessArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GeometricBrownianMotionProcess_f : c_obj list -> c_obj list = "_wrap_new_GeometricBrownianMotionProcessQuantLib" ;;
let _new_GeometricBrownianMotionProcess arg = match _new_GeometricBrownianMotionProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GeometricBrownianMotionProcess_f : c_obj list -> c_obj list = "_wrap_delete_GeometricBrownianMotionProcessQuantLib" ;;
let _delete_GeometricBrownianMotionProcess arg = match _delete_GeometricBrownianMotionProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_VarianceGammaProcess_f : c_obj list -> c_obj list = "_wrap_new_VarianceGammaProcessQuantLib" ;;
let _new_VarianceGammaProcess arg = match _new_VarianceGammaProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VarianceGammaProcess_f : c_obj list -> c_obj list = "_wrap_delete_VarianceGammaProcessQuantLib" ;;
let _delete_VarianceGammaProcess arg = match _delete_VarianceGammaProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HestonProcess_f : c_obj list -> c_obj list = "_wrap_new_HestonProcessQuantLib" ;;
let _new_HestonProcess arg = match _new_HestonProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HestonProcess_s0_f : c_obj list -> c_obj list = "_wrap_HestonProcess_s0QuantLib" ;;
let _HestonProcess_s0 arg = match _HestonProcess_s0_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HestonProcess_dividendYield_f : c_obj list -> c_obj list = "_wrap_HestonProcess_dividendYieldQuantLib" ;;
let _HestonProcess_dividendYield arg = match _HestonProcess_dividendYield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HestonProcess_riskFreeRate_f : c_obj list -> c_obj list = "_wrap_HestonProcess_riskFreeRateQuantLib" ;;
let _HestonProcess_riskFreeRate arg = match _HestonProcess_riskFreeRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HestonProcess_f : c_obj list -> c_obj list = "_wrap_delete_HestonProcessQuantLib" ;;
let _delete_HestonProcess arg = match _delete_HestonProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BatesProcess_f : c_obj list -> c_obj list = "_wrap_new_BatesProcessQuantLib" ;;
let _new_BatesProcess arg = match _new_BatesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BatesProcess_f : c_obj list -> c_obj list = "_wrap_delete_BatesProcessQuantLib" ;;
let _delete_BatesProcess arg = match _delete_BatesProcess_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVector__SWIG_0QuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVector__SWIG_1QuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVector__SWIG_2QuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_new_StochasticProcessVectorQuantLib" ;;
let _new_StochasticProcessVector arg = match _new_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_size_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_sizeQuantLib" ;;
let _StochasticProcessVector_size arg = match _StochasticProcessVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_empty_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_emptyQuantLib" ;;
let _StochasticProcessVector_empty arg = match _StochasticProcessVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_clear_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_clearQuantLib" ;;
let _StochasticProcessVector_clear arg = match _StochasticProcessVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_push_back_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_push_backQuantLib" ;;
let _StochasticProcessVector_push_back arg = match _StochasticProcessVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_operator_bB___QuantLib" ;;
let _StochasticProcessVector_operator_xx_xx_lbrace_xx_rbrace arg = match _StochasticProcessVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_operator_e___QuantLib" ;;
let _StochasticProcessVector_operator_xx_xx_equals arg = match _StochasticProcessVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_set_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_setQuantLib" ;;
let _StochasticProcessVector_set arg = match _StochasticProcessVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StochasticProcessVector_to_array_f : c_obj list -> c_obj list = "_wrap_StochasticProcessVector_to_arrayQuantLib" ;;
let _StochasticProcessVector_to_array arg = match _StochasticProcessVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StochasticProcessVector_f : c_obj list -> c_obj list = "_wrap_delete_StochasticProcessVectorQuantLib" ;;
let _delete_StochasticProcessVector arg = match _delete_StochasticProcessVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PricingEngine___deref___f : c_obj list -> c_obj list = "_wrap_PricingEngine___deref__QuantLib" ;;
let _PricingEngine___deref__ arg = match _PricingEngine___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PricingEngine_isNull_f : c_obj list -> c_obj list = "_wrap_PricingEngine_isNullQuantLib" ;;
let _PricingEngine_isNull arg = match _PricingEngine_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PricingEngine_f : c_obj list -> c_obj list = "_wrap_new_PricingEngineQuantLib" ;;
let _new_PricingEngine arg = match _new_PricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PricingEngine_f : c_obj list -> c_obj list = "_wrap_delete_PricingEngineQuantLib" ;;
let _delete_PricingEngine arg = match _delete_PricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument___deref___f : c_obj list -> c_obj list = "_wrap_Instrument___deref__QuantLib" ;;
let _Instrument___deref__ arg = match _Instrument___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_isNull_f : c_obj list -> c_obj list = "_wrap_Instrument_isNullQuantLib" ;;
let _Instrument_isNull arg = match _Instrument_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_asObservable_f : c_obj list -> c_obj list = "_wrap_Instrument_asObservableQuantLib" ;;
let _Instrument_asObservable arg = match _Instrument_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Instrument_f : c_obj list -> c_obj list = "_wrap_new_InstrumentQuantLib" ;;
let _new_Instrument arg = match _new_Instrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Instrument_f : c_obj list -> c_obj list = "_wrap_delete_InstrumentQuantLib" ;;
let _delete_Instrument arg = match _delete_Instrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_NPV_f : c_obj list -> c_obj list = "_wrap_Instrument_NPVQuantLib" ;;
let _Instrument_NPV arg = match _Instrument_NPV_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_errorEstimate_f : c_obj list -> c_obj list = "_wrap_Instrument_errorEstimateQuantLib" ;;
let _Instrument_errorEstimate arg = match _Instrument_errorEstimate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_isExpired_f : c_obj list -> c_obj list = "_wrap_Instrument_isExpiredQuantLib" ;;
let _Instrument_isExpired arg = match _Instrument_isExpired_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_setPricingEngine_f : c_obj list -> c_obj list = "_wrap_Instrument_setPricingEngineQuantLib" ;;
let _Instrument_setPricingEngine arg = match _Instrument_setPricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_recalculate_f : c_obj list -> c_obj list = "_wrap_Instrument_recalculateQuantLib" ;;
let _Instrument_recalculate arg = match _Instrument_recalculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_freeze_f : c_obj list -> c_obj list = "_wrap_Instrument_freezeQuantLib" ;;
let _Instrument_freeze arg = match _Instrument_freeze_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Instrument_unfreeze_f : c_obj list -> c_obj list = "_wrap_Instrument_unfreezeQuantLib" ;;
let _Instrument_unfreeze arg = match _Instrument_unfreeze_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Stock_f : c_obj list -> c_obj list = "_wrap_new_StockQuantLib" ;;
let _new_Stock arg = match _new_Stock_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Stock_f : c_obj list -> c_obj list = "_wrap_delete_StockQuantLib" ;;
let _delete_Stock arg = match _delete_Stock_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CompositeInstrument_f : c_obj list -> c_obj list = "_wrap_new_CompositeInstrumentQuantLib" ;;
let _new_CompositeInstrument arg = match _new_CompositeInstrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_add_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_add__SWIG_0QuantLib" ;;
let _CompositeInstrument_add arg = match _CompositeInstrument_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_add_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_addQuantLib" ;;
let _CompositeInstrument_add arg = match _CompositeInstrument_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_subtract_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_subtract__SWIG_0QuantLib" ;;
let _CompositeInstrument_subtract arg = match _CompositeInstrument_subtract_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CompositeInstrument_subtract_f : c_obj list -> c_obj list = "_wrap_CompositeInstrument_subtractQuantLib" ;;
let _CompositeInstrument_subtract arg = match _CompositeInstrument_subtract_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CompositeInstrument_f : c_obj list -> c_obj list = "_wrap_delete_CompositeInstrumentQuantLib" ;;
let _delete_CompositeInstrument arg = match _delete_CompositeInstrument_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Option::Type_marker" (`Type)
external _Put : c_obj -> Swig.c_obj = "_wrap_Put" 
external _Call : c_obj -> Swig.c_obj = "_wrap_Call" 
external _delete_Option_f : c_obj list -> c_obj list = "_wrap_delete_OptionQuantLib" ;;
let _delete_Option arg = match _delete_Option_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Barrier::Type_marker" (`Type)
external _DownIn : c_obj -> Swig.c_obj = "_wrap_DownIn" 
external _UpIn : c_obj -> Swig.c_obj = "_wrap_UpIn" 
external _DownOut : c_obj -> Swig.c_obj = "_wrap_DownOut" 
external _UpOut : c_obj -> Swig.c_obj = "_wrap_UpOut" 
external _new_Barrier_f : c_obj list -> c_obj list = "_wrap_new_BarrierQuantLib" ;;
let _new_Barrier arg = match _new_Barrier_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Barrier_f : c_obj list -> c_obj list = "_wrap_delete_BarrierQuantLib" ;;
let _delete_Barrier arg = match _delete_Barrier_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Payoff___deref___f : c_obj list -> c_obj list = "_wrap_Payoff___deref__QuantLib" ;;
let _Payoff___deref__ arg = match _Payoff___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Payoff_isNull_f : c_obj list -> c_obj list = "_wrap_Payoff_isNullQuantLib" ;;
let _Payoff_isNull arg = match _Payoff_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Payoff_f : c_obj list -> c_obj list = "_wrap_new_PayoffQuantLib" ;;
let _new_Payoff arg = match _new_Payoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Payoff_f : c_obj list -> c_obj list = "_wrap_delete_PayoffQuantLib" ;;
let _delete_Payoff arg = match _delete_Payoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Payoff_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_Payoff_operator_pP___QuantLib" ;;
let _Payoff_operator_xx_xx_lparen_xx_rparen arg = match _Payoff_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_VanillaOption_f : c_obj list -> c_obj list = "_wrap_new_VanillaOptionQuantLib" ;;
let _new_VanillaOption arg = match _new_VanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_priceCurve_f : c_obj list -> c_obj list = "_wrap_VanillaOption_priceCurveQuantLib" ;;
let _VanillaOption_priceCurve arg = match _VanillaOption_priceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_0QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_1QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_2QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatility__SWIG_3QuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_VanillaOption_impliedVolatilityQuantLib" ;;
let _VanillaOption_impliedVolatility arg = match _VanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_delta_f : c_obj list -> c_obj list = "_wrap_VanillaOption_deltaQuantLib" ;;
let _VanillaOption_delta arg = match _VanillaOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_gamma_f : c_obj list -> c_obj list = "_wrap_VanillaOption_gammaQuantLib" ;;
let _VanillaOption_gamma arg = match _VanillaOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_theta_f : c_obj list -> c_obj list = "_wrap_VanillaOption_thetaQuantLib" ;;
let _VanillaOption_theta arg = match _VanillaOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_thetaPerDay_f : c_obj list -> c_obj list = "_wrap_VanillaOption_thetaPerDayQuantLib" ;;
let _VanillaOption_thetaPerDay arg = match _VanillaOption_thetaPerDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_vega_f : c_obj list -> c_obj list = "_wrap_VanillaOption_vegaQuantLib" ;;
let _VanillaOption_vega arg = match _VanillaOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_rho_f : c_obj list -> c_obj list = "_wrap_VanillaOption_rhoQuantLib" ;;
let _VanillaOption_rho arg = match _VanillaOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_VanillaOption_dividendRhoQuantLib" ;;
let _VanillaOption_dividendRho arg = match _VanillaOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_VanillaOption_strikeSensitivityQuantLib" ;;
let _VanillaOption_strikeSensitivity arg = match _VanillaOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_VanillaOptionQuantLib" ;;
let _delete_VanillaOption arg = match _delete_VanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EuropeanOption_f : c_obj list -> c_obj list = "_wrap_new_EuropeanOptionQuantLib" ;;
let _new_EuropeanOption arg = match _new_EuropeanOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EuropeanOption_f : c_obj list -> c_obj list = "_wrap_delete_EuropeanOptionQuantLib" ;;
let _delete_EuropeanOption arg = match _delete_EuropeanOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_ForwardVanillaOptionQuantLib" ;;
let _new_ForwardVanillaOption arg = match _new_ForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_ForwardVanillaOptionQuantLib" ;;
let _delete_ForwardVanillaOption arg = match _delete_ForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_QuantoVanillaOptionQuantLib" ;;
let _new_QuantoVanillaOption arg = match _new_QuantoVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuantoVanillaOption_qvega_f : c_obj list -> c_obj list = "_wrap_QuantoVanillaOption_qvegaQuantLib" ;;
let _QuantoVanillaOption_qvega arg = match _QuantoVanillaOption_qvega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuantoVanillaOption_qrho_f : c_obj list -> c_obj list = "_wrap_QuantoVanillaOption_qrhoQuantLib" ;;
let _QuantoVanillaOption_qrho arg = match _QuantoVanillaOption_qrho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _QuantoVanillaOption_qlambda_f : c_obj list -> c_obj list = "_wrap_QuantoVanillaOption_qlambdaQuantLib" ;;
let _QuantoVanillaOption_qlambda arg = match _QuantoVanillaOption_qlambda_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_QuantoVanillaOptionQuantLib" ;;
let _delete_QuantoVanillaOption arg = match _delete_QuantoVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_QuantoForwardVanillaOptionQuantLib" ;;
let _new_QuantoForwardVanillaOption arg = match _new_QuantoForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoForwardVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_QuantoForwardVanillaOptionQuantLib" ;;
let _delete_QuantoForwardVanillaOption arg = match _delete_QuantoForwardVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_delta_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_deltaQuantLib" ;;
let _MultiAssetOption_delta arg = match _MultiAssetOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_gamma_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_gammaQuantLib" ;;
let _MultiAssetOption_gamma arg = match _MultiAssetOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_theta_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_thetaQuantLib" ;;
let _MultiAssetOption_theta arg = match _MultiAssetOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_vega_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_vegaQuantLib" ;;
let _MultiAssetOption_vega arg = match _MultiAssetOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_rho_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_rhoQuantLib" ;;
let _MultiAssetOption_rho arg = match _MultiAssetOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiAssetOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_MultiAssetOption_dividendRhoQuantLib" ;;
let _MultiAssetOption_dividendRho arg = match _MultiAssetOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MultiAssetOption_f : c_obj list -> c_obj list = "_wrap_new_MultiAssetOptionQuantLib" ;;
let _new_MultiAssetOption arg = match _new_MultiAssetOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MultiAssetOption_f : c_obj list -> c_obj list = "_wrap_delete_MultiAssetOptionQuantLib" ;;
let _delete_MultiAssetOption arg = match _delete_MultiAssetOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticEuropeanEngineQuantLib" ;;
let _new_AnalyticEuropeanEngine arg = match _new_AnalyticEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticEuropeanEngineQuantLib" ;;
let _delete_AnalyticEuropeanEngine arg = match _delete_AnalyticEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibratedModel___deref___f : c_obj list -> c_obj list = "_wrap_CalibratedModel___deref__QuantLib" ;;
let _CalibratedModel___deref__ arg = match _CalibratedModel___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibratedModel_isNull_f : c_obj list -> c_obj list = "_wrap_CalibratedModel_isNullQuantLib" ;;
let _CalibratedModel_isNull arg = match _CalibratedModel_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibratedModel_f : c_obj list -> c_obj list = "_wrap_new_CalibratedModelQuantLib" ;;
let _new_CalibratedModel arg = match _new_CalibratedModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CalibratedModel_f : c_obj list -> c_obj list = "_wrap_delete_CalibratedModelQuantLib" ;;
let _delete_CalibratedModel arg = match _delete_CalibratedModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HestonModel_f : c_obj list -> c_obj list = "_wrap_new_HestonModelQuantLib" ;;
let _new_HestonModel arg = match _new_HestonModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HestonModel_f : c_obj list -> c_obj list = "_wrap_delete_HestonModelQuantLib" ;;
let _delete_HestonModel arg = match _delete_HestonModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticHestonEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticHestonEngine__SWIG_0QuantLib" ;;
let _new_AnalyticHestonEngine arg = match _new_AnalyticHestonEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticHestonEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticHestonEngine__SWIG_1QuantLib" ;;
let _new_AnalyticHestonEngine arg = match _new_AnalyticHestonEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticHestonEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticHestonEngineQuantLib" ;;
let _new_AnalyticHestonEngine arg = match _new_AnalyticHestonEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticHestonEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticHestonEngineQuantLib" ;;
let _delete_AnalyticHestonEngine arg = match _delete_AnalyticHestonEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BatesModel_f : c_obj list -> c_obj list = "_wrap_new_BatesModelQuantLib" ;;
let _new_BatesModel arg = match _new_BatesModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BatesModel_f : c_obj list -> c_obj list = "_wrap_delete_BatesModelQuantLib" ;;
let _delete_BatesModel arg = match _delete_BatesModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BatesEngine_f : c_obj list -> c_obj list = "_wrap_new_BatesEngine__SWIG_0QuantLib" ;;
let _new_BatesEngine arg = match _new_BatesEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BatesEngine_f : c_obj list -> c_obj list = "_wrap_new_BatesEngine__SWIG_1QuantLib" ;;
let _new_BatesEngine arg = match _new_BatesEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BatesEngine_f : c_obj list -> c_obj list = "_wrap_new_BatesEngineQuantLib" ;;
let _new_BatesEngine arg = match _new_BatesEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BatesEngine_f : c_obj list -> c_obj list = "_wrap_delete_BatesEngineQuantLib" ;;
let _delete_BatesEngine arg = match _delete_BatesEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IntegralEngine_f : c_obj list -> c_obj list = "_wrap_new_IntegralEngineQuantLib" ;;
let _new_IntegralEngine arg = match _new_IntegralEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IntegralEngine_f : c_obj list -> c_obj list = "_wrap_delete_IntegralEngineQuantLib" ;;
let _delete_IntegralEngine arg = match _delete_IntegralEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDBermudanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDBermudanEngine__SWIG_0QuantLib" ;;
let _new_FDBermudanEngine arg = match _new_FDBermudanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDBermudanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDBermudanEngine__SWIG_1QuantLib" ;;
let _new_FDBermudanEngine arg = match _new_FDBermudanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDBermudanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDBermudanEngine__SWIG_2QuantLib" ;;
let _new_FDBermudanEngine arg = match _new_FDBermudanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDBermudanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDBermudanEngineQuantLib" ;;
let _new_FDBermudanEngine arg = match _new_FDBermudanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDBermudanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDBermudanEngineQuantLib" ;;
let _delete_FDBermudanEngine arg = match _delete_FDBermudanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngine__SWIG_0QuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngine__SWIG_1QuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngine__SWIG_2QuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDEuropeanEngineQuantLib" ;;
let _new_FDEuropeanEngine arg = match _new_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDEuropeanEngineQuantLib" ;;
let _delete_FDEuropeanEngine arg = match _delete_FDEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BinomialVanillaEngine_f : c_obj list -> c_obj list = "_wrap_new_BinomialVanillaEngineQuantLib" ;;
let _new_BinomialVanillaEngine arg = match _new_BinomialVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BinomialVanillaEngine_f : c_obj list -> c_obj list = "_wrap_delete_BinomialVanillaEngineQuantLib" ;;
let _delete_BinomialVanillaEngine arg = match _delete_BinomialVanillaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_MCEuropeanEngineQuantLib" ;;
let _new_MCEuropeanEngine arg = match _new_MCEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCEuropeanEngineQuantLib" ;;
let _delete_MCEuropeanEngine arg = match _delete_MCEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngine__SWIG_0QuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngine__SWIG_1QuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngine__SWIG_2QuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDAmericanEngineQuantLib" ;;
let _new_FDAmericanEngine arg = match _new_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDAmericanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDAmericanEngineQuantLib" ;;
let _delete_FDAmericanEngine arg = match _delete_FDAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngine__SWIG_0QuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngine__SWIG_1QuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngine__SWIG_2QuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_new_FDShoutEngineQuantLib" ;;
let _new_FDShoutEngine arg = match _new_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDShoutEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDShoutEngineQuantLib" ;;
let _delete_FDShoutEngine arg = match _delete_FDShoutEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BaroneAdesiWhaleyEngine_f : c_obj list -> c_obj list = "_wrap_new_BaroneAdesiWhaleyEngineQuantLib" ;;
let _new_BaroneAdesiWhaleyEngine arg = match _new_BaroneAdesiWhaleyEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BaroneAdesiWhaleyEngine_f : c_obj list -> c_obj list = "_wrap_delete_BaroneAdesiWhaleyEngineQuantLib" ;;
let _delete_BaroneAdesiWhaleyEngine arg = match _delete_BaroneAdesiWhaleyEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BjerksundStenslandEngine_f : c_obj list -> c_obj list = "_wrap_new_BjerksundStenslandEngineQuantLib" ;;
let _new_BjerksundStenslandEngine arg = match _new_BjerksundStenslandEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BjerksundStenslandEngine_f : c_obj list -> c_obj list = "_wrap_delete_BjerksundStenslandEngineQuantLib" ;;
let _delete_BjerksundStenslandEngine arg = match _delete_BjerksundStenslandEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticDigitalAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticDigitalAmericanEngineQuantLib" ;;
let _new_AnalyticDigitalAmericanEngine arg = match _new_AnalyticDigitalAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticDigitalAmericanEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticDigitalAmericanEngineQuantLib" ;;
let _delete_AnalyticDigitalAmericanEngine arg = match _delete_AnalyticDigitalAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DividendVanillaOption_f : c_obj list -> c_obj list = "_wrap_new_DividendVanillaOptionQuantLib" ;;
let _new_DividendVanillaOption arg = match _new_DividendVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_priceCurve_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_priceCurveQuantLib" ;;
let _DividendVanillaOption_priceCurve arg = match _DividendVanillaOption_priceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_0QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_1QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_2QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatility__SWIG_3QuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_impliedVolatilityQuantLib" ;;
let _DividendVanillaOption_impliedVolatility arg = match _DividendVanillaOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_delta_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_deltaQuantLib" ;;
let _DividendVanillaOption_delta arg = match _DividendVanillaOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_gamma_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_gammaQuantLib" ;;
let _DividendVanillaOption_gamma arg = match _DividendVanillaOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_theta_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_thetaQuantLib" ;;
let _DividendVanillaOption_theta arg = match _DividendVanillaOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_thetaPerDay_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_thetaPerDayQuantLib" ;;
let _DividendVanillaOption_thetaPerDay arg = match _DividendVanillaOption_thetaPerDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_vega_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_vegaQuantLib" ;;
let _DividendVanillaOption_vega arg = match _DividendVanillaOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_rho_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_rhoQuantLib" ;;
let _DividendVanillaOption_rho arg = match _DividendVanillaOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_dividendRhoQuantLib" ;;
let _DividendVanillaOption_dividendRho arg = match _DividendVanillaOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendVanillaOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_DividendVanillaOption_strikeSensitivityQuantLib" ;;
let _DividendVanillaOption_strikeSensitivity arg = match _DividendVanillaOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DividendVanillaOption_f : c_obj list -> c_obj list = "_wrap_delete_DividendVanillaOptionQuantLib" ;;
let _delete_DividendVanillaOption arg = match _delete_DividendVanillaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticDividendEuropeanEngineQuantLib" ;;
let _new_AnalyticDividendEuropeanEngine arg = match _new_AnalyticDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticDividendEuropeanEngineQuantLib" ;;
let _delete_AnalyticDividendEuropeanEngine arg = match _delete_AnalyticDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngine__SWIG_0QuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngine__SWIG_1QuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngine__SWIG_2QuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendEuropeanEngineQuantLib" ;;
let _new_FDDividendEuropeanEngine arg = match _new_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDDividendEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDDividendEuropeanEngineQuantLib" ;;
let _delete_FDDividendEuropeanEngine arg = match _delete_FDDividendEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngine__SWIG_0QuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngine__SWIG_1QuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngine__SWIG_2QuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_new_FDDividendAmericanEngineQuantLib" ;;
let _new_FDDividendAmericanEngine arg = match _new_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FDDividendAmericanEngine_f : c_obj list -> c_obj list = "_wrap_delete_FDDividendAmericanEngineQuantLib" ;;
let _delete_FDDividendAmericanEngine arg = match _delete_FDDividendAmericanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BarrierOption_f : c_obj list -> c_obj list = "_wrap_new_BarrierOptionQuantLib" ;;
let _new_BarrierOption arg = match _new_BarrierOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_priceCurve_f : c_obj list -> c_obj list = "_wrap_BarrierOption_priceCurveQuantLib" ;;
let _BarrierOption_priceCurve arg = match _BarrierOption_priceCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_0QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_1QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_2QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatility__SWIG_3QuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_BarrierOption_impliedVolatilityQuantLib" ;;
let _BarrierOption_impliedVolatility arg = match _BarrierOption_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_delta_f : c_obj list -> c_obj list = "_wrap_BarrierOption_deltaQuantLib" ;;
let _BarrierOption_delta arg = match _BarrierOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_gamma_f : c_obj list -> c_obj list = "_wrap_BarrierOption_gammaQuantLib" ;;
let _BarrierOption_gamma arg = match _BarrierOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_theta_f : c_obj list -> c_obj list = "_wrap_BarrierOption_thetaQuantLib" ;;
let _BarrierOption_theta arg = match _BarrierOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_thetaPerDay_f : c_obj list -> c_obj list = "_wrap_BarrierOption_thetaPerDayQuantLib" ;;
let _BarrierOption_thetaPerDay arg = match _BarrierOption_thetaPerDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_vega_f : c_obj list -> c_obj list = "_wrap_BarrierOption_vegaQuantLib" ;;
let _BarrierOption_vega arg = match _BarrierOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_rho_f : c_obj list -> c_obj list = "_wrap_BarrierOption_rhoQuantLib" ;;
let _BarrierOption_rho arg = match _BarrierOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_BarrierOption_dividendRhoQuantLib" ;;
let _BarrierOption_dividendRho arg = match _BarrierOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BarrierOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_BarrierOption_strikeSensitivityQuantLib" ;;
let _BarrierOption_strikeSensitivity arg = match _BarrierOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BarrierOption_f : c_obj list -> c_obj list = "_wrap_delete_BarrierOptionQuantLib" ;;
let _delete_BarrierOption arg = match _delete_BarrierOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticBarrierEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticBarrierEngineQuantLib" ;;
let _new_AnalyticBarrierEngine arg = match _new_AnalyticBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticBarrierEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticBarrierEngineQuantLib" ;;
let _delete_AnalyticBarrierEngine arg = match _delete_AnalyticBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCBarrierEngine_f : c_obj list -> c_obj list = "_wrap_new_MCBarrierEngineQuantLib" ;;
let _new_MCBarrierEngine arg = match _new_MCBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCBarrierEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCBarrierEngineQuantLib" ;;
let _delete_MCBarrierEngine arg = match _delete_MCBarrierEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_ForwardEuropeanEngineQuantLib" ;;
let _new_ForwardEuropeanEngine arg = match _new_ForwardEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_ForwardEuropeanEngineQuantLib" ;;
let _delete_ForwardEuropeanEngine arg = match _delete_ForwardEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_QuantoEuropeanEngineQuantLib" ;;
let _new_QuantoEuropeanEngine arg = match _new_QuantoEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_QuantoEuropeanEngineQuantLib" ;;
let _delete_QuantoEuropeanEngine arg = match _delete_QuantoEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_QuantoForwardEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_new_QuantoForwardEuropeanEngineQuantLib" ;;
let _new_QuantoForwardEuropeanEngine arg = match _new_QuantoForwardEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_QuantoForwardEuropeanEngine_f : c_obj list -> c_obj list = "_wrap_delete_QuantoForwardEuropeanEngineQuantLib" ;;
let _delete_QuantoForwardEuropeanEngine arg = match _delete_QuantoForwardEuropeanEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackCalculator_f : c_obj list -> c_obj list = "_wrap_new_BlackCalculator__SWIG_0QuantLib" ;;
let _new_BlackCalculator arg = match _new_BlackCalculator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackCalculator_f : c_obj list -> c_obj list = "_wrap_new_BlackCalculatorQuantLib" ;;
let _new_BlackCalculator arg = match _new_BlackCalculator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_value_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_valueQuantLib" ;;
let _BlackCalculator_value arg = match _BlackCalculator_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_deltaForward_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_deltaForwardQuantLib" ;;
let _BlackCalculator_deltaForward arg = match _BlackCalculator_deltaForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_delta_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_deltaQuantLib" ;;
let _BlackCalculator_delta arg = match _BlackCalculator_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_elasticityForward_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_elasticityForwardQuantLib" ;;
let _BlackCalculator_elasticityForward arg = match _BlackCalculator_elasticityForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_elasticity_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_elasticityQuantLib" ;;
let _BlackCalculator_elasticity arg = match _BlackCalculator_elasticity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_gammaForward_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_gammaForwardQuantLib" ;;
let _BlackCalculator_gammaForward arg = match _BlackCalculator_gammaForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_gamma_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_gammaQuantLib" ;;
let _BlackCalculator_gamma arg = match _BlackCalculator_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_theta_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_thetaQuantLib" ;;
let _BlackCalculator_theta arg = match _BlackCalculator_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_thetaPerDay_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_thetaPerDayQuantLib" ;;
let _BlackCalculator_thetaPerDay arg = match _BlackCalculator_thetaPerDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_vega_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_vegaQuantLib" ;;
let _BlackCalculator_vega arg = match _BlackCalculator_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_rho_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_rhoQuantLib" ;;
let _BlackCalculator_rho arg = match _BlackCalculator_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_dividendRho_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_dividendRhoQuantLib" ;;
let _BlackCalculator_dividendRho arg = match _BlackCalculator_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_itmCashProbability_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_itmCashProbabilityQuantLib" ;;
let _BlackCalculator_itmCashProbability arg = match _BlackCalculator_itmCashProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_itmAssetProbability_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_itmAssetProbabilityQuantLib" ;;
let _BlackCalculator_itmAssetProbability arg = match _BlackCalculator_itmAssetProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_strikeSensitivityQuantLib" ;;
let _BlackCalculator_strikeSensitivity arg = match _BlackCalculator_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_alpha_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_alphaQuantLib" ;;
let _BlackCalculator_alpha arg = match _BlackCalculator_alpha_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BlackCalculator_beta_f : c_obj list -> c_obj list = "_wrap_BlackCalculator_betaQuantLib" ;;
let _BlackCalculator_beta arg = match _BlackCalculator_beta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackCalculator_f : c_obj list -> c_obj list = "_wrap_delete_BlackCalculatorQuantLib" ;;
let _delete_BlackCalculator arg = match _delete_BlackCalculator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Average::Type_marker" (`Type)
external _Arithmetic : c_obj -> Swig.c_obj = "_wrap_Arithmetic" 
external _Geometric : c_obj -> Swig.c_obj = "_wrap_Geometric" 
external _new_Average_f : c_obj list -> c_obj list = "_wrap_new_AverageQuantLib" ;;
let _new_Average arg = match _new_Average_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Average_f : c_obj list -> c_obj list = "_wrap_delete_AverageQuantLib" ;;
let _delete_Average arg = match _delete_Average_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ContinuousAveragingAsianOption_f : c_obj list -> c_obj list = "_wrap_new_ContinuousAveragingAsianOptionQuantLib" ;;
let _new_ContinuousAveragingAsianOption arg = match _new_ContinuousAveragingAsianOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_delta_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_deltaQuantLib" ;;
let _ContinuousAveragingAsianOption_delta arg = match _ContinuousAveragingAsianOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_gamma_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_gammaQuantLib" ;;
let _ContinuousAveragingAsianOption_gamma arg = match _ContinuousAveragingAsianOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_theta_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_thetaQuantLib" ;;
let _ContinuousAveragingAsianOption_theta arg = match _ContinuousAveragingAsianOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_thetaPerDay_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_thetaPerDayQuantLib" ;;
let _ContinuousAveragingAsianOption_thetaPerDay arg = match _ContinuousAveragingAsianOption_thetaPerDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_vega_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_vegaQuantLib" ;;
let _ContinuousAveragingAsianOption_vega arg = match _ContinuousAveragingAsianOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_rho_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_rhoQuantLib" ;;
let _ContinuousAveragingAsianOption_rho arg = match _ContinuousAveragingAsianOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_dividendRhoQuantLib" ;;
let _ContinuousAveragingAsianOption_dividendRho arg = match _ContinuousAveragingAsianOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ContinuousAveragingAsianOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_ContinuousAveragingAsianOption_strikeSensitivityQuantLib" ;;
let _ContinuousAveragingAsianOption_strikeSensitivity arg = match _ContinuousAveragingAsianOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ContinuousAveragingAsianOption_f : c_obj list -> c_obj list = "_wrap_delete_ContinuousAveragingAsianOptionQuantLib" ;;
let _delete_ContinuousAveragingAsianOption arg = match _delete_ContinuousAveragingAsianOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscreteAveragingAsianOption_f : c_obj list -> c_obj list = "_wrap_new_DiscreteAveragingAsianOptionQuantLib" ;;
let _new_DiscreteAveragingAsianOption arg = match _new_DiscreteAveragingAsianOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_delta_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_deltaQuantLib" ;;
let _DiscreteAveragingAsianOption_delta arg = match _DiscreteAveragingAsianOption_delta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_gamma_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_gammaQuantLib" ;;
let _DiscreteAveragingAsianOption_gamma arg = match _DiscreteAveragingAsianOption_gamma_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_theta_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_thetaQuantLib" ;;
let _DiscreteAveragingAsianOption_theta arg = match _DiscreteAveragingAsianOption_theta_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_thetaPerDay_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_thetaPerDayQuantLib" ;;
let _DiscreteAveragingAsianOption_thetaPerDay arg = match _DiscreteAveragingAsianOption_thetaPerDay_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_vega_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_vegaQuantLib" ;;
let _DiscreteAveragingAsianOption_vega arg = match _DiscreteAveragingAsianOption_vega_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_rho_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_rhoQuantLib" ;;
let _DiscreteAveragingAsianOption_rho arg = match _DiscreteAveragingAsianOption_rho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_dividendRho_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_dividendRhoQuantLib" ;;
let _DiscreteAveragingAsianOption_dividendRho arg = match _DiscreteAveragingAsianOption_dividendRho_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscreteAveragingAsianOption_strikeSensitivity_f : c_obj list -> c_obj list = "_wrap_DiscreteAveragingAsianOption_strikeSensitivityQuantLib" ;;
let _DiscreteAveragingAsianOption_strikeSensitivity arg = match _DiscreteAveragingAsianOption_strikeSensitivity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DiscreteAveragingAsianOption_f : c_obj list -> c_obj list = "_wrap_delete_DiscreteAveragingAsianOptionQuantLib" ;;
let _delete_DiscreteAveragingAsianOption arg = match _delete_DiscreteAveragingAsianOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticContinuousGeometricAveragePriceAsianEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticContinuousGeometricAveragePriceAsianEngineQuantLib" ;;
let _new_AnalyticContinuousGeometricAveragePriceAsianEngine arg = match _new_AnalyticContinuousGeometricAveragePriceAsianEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticContinuousGeometricAveragePriceAsianEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticContinuousGeometricAveragePriceAsianEngineQuantLib" ;;
let _delete_AnalyticContinuousGeometricAveragePriceAsianEngine arg = match _delete_AnalyticContinuousGeometricAveragePriceAsianEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticDiscreteGeometricAveragePriceAsianEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticDiscreteGeometricAveragePriceAsianEngineQuantLib" ;;
let _new_AnalyticDiscreteGeometricAveragePriceAsianEngine arg = match _new_AnalyticDiscreteGeometricAveragePriceAsianEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticDiscreteGeometricAveragePriceAsianEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticDiscreteGeometricAveragePriceAsianEngineQuantLib" ;;
let _delete_AnalyticDiscreteGeometricAveragePriceAsianEngine arg = match _delete_AnalyticDiscreteGeometricAveragePriceAsianEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticDiscreteGeometricAverageStrikeAsianEngine_f : c_obj list -> c_obj list = "_wrap_new_AnalyticDiscreteGeometricAverageStrikeAsianEngineQuantLib" ;;
let _new_AnalyticDiscreteGeometricAverageStrikeAsianEngine arg = match _new_AnalyticDiscreteGeometricAverageStrikeAsianEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticDiscreteGeometricAverageStrikeAsianEngine_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticDiscreteGeometricAverageStrikeAsianEngineQuantLib" ;;
let _delete_AnalyticDiscreteGeometricAverageStrikeAsianEngine arg = match _delete_AnalyticDiscreteGeometricAverageStrikeAsianEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCDiscreteArithmeticAPEngine_f : c_obj list -> c_obj list = "_wrap_new_MCDiscreteArithmeticAPEngineQuantLib" ;;
let _new_MCDiscreteArithmeticAPEngine arg = match _new_MCDiscreteArithmeticAPEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCDiscreteArithmeticAPEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCDiscreteArithmeticAPEngineQuantLib" ;;
let _delete_MCDiscreteArithmeticAPEngine arg = match _delete_MCDiscreteArithmeticAPEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCDiscreteArithmeticASEngine_f : c_obj list -> c_obj list = "_wrap_new_MCDiscreteArithmeticASEngineQuantLib" ;;
let _new_MCDiscreteArithmeticASEngine arg = match _new_MCDiscreteArithmeticASEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCDiscreteArithmeticASEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCDiscreteArithmeticASEngineQuantLib" ;;
let _delete_MCDiscreteArithmeticASEngine arg = match _delete_MCDiscreteArithmeticASEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCDiscreteGeometricAPEngine_f : c_obj list -> c_obj list = "_wrap_new_MCDiscreteGeometricAPEngineQuantLib" ;;
let _new_MCDiscreteGeometricAPEngine arg = match _new_MCDiscreteGeometricAPEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCDiscreteGeometricAPEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCDiscreteGeometricAPEngineQuantLib" ;;
let _delete_MCDiscreteGeometricAPEngine arg = match _delete_MCDiscreteGeometricAPEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_VarianceGammaEngine_f : c_obj list -> c_obj list = "_wrap_new_VarianceGammaEngineQuantLib" ;;
let _new_VarianceGammaEngine arg = match _new_VarianceGammaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VarianceGammaEngine_f : c_obj list -> c_obj list = "_wrap_delete_VarianceGammaEngineQuantLib" ;;
let _delete_VarianceGammaEngine arg = match _delete_VarianceGammaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OptionList_f : c_obj list -> c_obj list = "_wrap_new_OptionList__SWIG_0QuantLib" ;;
let _new_OptionList arg = match _new_OptionList_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OptionList_f : c_obj list -> c_obj list = "_wrap_new_OptionList__SWIG_1QuantLib" ;;
let _new_OptionList arg = match _new_OptionList_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OptionList_f : c_obj list -> c_obj list = "_wrap_new_OptionList__SWIG_2QuantLib" ;;
let _new_OptionList arg = match _new_OptionList_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_OptionList_f : c_obj list -> c_obj list = "_wrap_new_OptionListQuantLib" ;;
let _new_OptionList arg = match _new_OptionList_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_size_f : c_obj list -> c_obj list = "_wrap_OptionList_sizeQuantLib" ;;
let _OptionList_size arg = match _OptionList_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_empty_f : c_obj list -> c_obj list = "_wrap_OptionList_emptyQuantLib" ;;
let _OptionList_empty arg = match _OptionList_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_clear_f : c_obj list -> c_obj list = "_wrap_OptionList_clearQuantLib" ;;
let _OptionList_clear arg = match _OptionList_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_push_back_f : c_obj list -> c_obj list = "_wrap_OptionList_push_backQuantLib" ;;
let _OptionList_push_back arg = match _OptionList_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_OptionList_operator_bB___QuantLib" ;;
let _OptionList_operator_xx_xx_lbrace_xx_rbrace arg = match _OptionList_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_OptionList_operator_e___QuantLib" ;;
let _OptionList_operator_xx_xx_equals arg = match _OptionList_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_set_f : c_obj list -> c_obj list = "_wrap_OptionList_setQuantLib" ;;
let _OptionList_set arg = match _OptionList_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _OptionList_to_array_f : c_obj list -> c_obj list = "_wrap_OptionList_to_arrayQuantLib" ;;
let _OptionList_to_array arg = match _OptionList_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_OptionList_f : c_obj list -> c_obj list = "_wrap_delete_OptionListQuantLib" ;;
let _delete_OptionList arg = match _delete_OptionList_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FFTVarianceGammaEngine_f : c_obj list -> c_obj list = "_wrap_new_FFTVarianceGammaEngine__SWIG_0QuantLib" ;;
let _new_FFTVarianceGammaEngine arg = match _new_FFTVarianceGammaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FFTVarianceGammaEngine_f : c_obj list -> c_obj list = "_wrap_new_FFTVarianceGammaEngineQuantLib" ;;
let _new_FFTVarianceGammaEngine arg = match _new_FFTVarianceGammaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FFTVarianceGammaEngine_precalculate_f : c_obj list -> c_obj list = "_wrap_FFTVarianceGammaEngine_precalculateQuantLib" ;;
let _FFTVarianceGammaEngine_precalculate arg = match _FFTVarianceGammaEngine_precalculate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FFTVarianceGammaEngine_f : c_obj list -> c_obj list = "_wrap_delete_FFTVarianceGammaEngineQuantLib" ;;
let _delete_FFTVarianceGammaEngine arg = match _delete_FFTVarianceGammaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PlainVanillaPayoff_f : c_obj list -> c_obj list = "_wrap_new_PlainVanillaPayoffQuantLib" ;;
let _new_PlainVanillaPayoff arg = match _new_PlainVanillaPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PlainVanillaPayoff_optionType_f : c_obj list -> c_obj list = "_wrap_PlainVanillaPayoff_optionTypeQuantLib" ;;
let _PlainVanillaPayoff_optionType arg = match _PlainVanillaPayoff_optionType_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PlainVanillaPayoff_strike_f : c_obj list -> c_obj list = "_wrap_PlainVanillaPayoff_strikeQuantLib" ;;
let _PlainVanillaPayoff_strike arg = match _PlainVanillaPayoff_strike_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PlainVanillaPayoff_f : c_obj list -> c_obj list = "_wrap_delete_PlainVanillaPayoffQuantLib" ;;
let _delete_PlainVanillaPayoff arg = match _delete_PlainVanillaPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PercentageStrikePayoff_f : c_obj list -> c_obj list = "_wrap_new_PercentageStrikePayoffQuantLib" ;;
let _new_PercentageStrikePayoff arg = match _new_PercentageStrikePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PercentageStrikePayoff_f : c_obj list -> c_obj list = "_wrap_delete_PercentageStrikePayoffQuantLib" ;;
let _delete_PercentageStrikePayoff arg = match _delete_PercentageStrikePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CashOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_new_CashOrNothingPayoffQuantLib" ;;
let _new_CashOrNothingPayoff arg = match _new_CashOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CashOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_delete_CashOrNothingPayoffQuantLib" ;;
let _delete_CashOrNothingPayoff arg = match _delete_CashOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AssetOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_new_AssetOrNothingPayoffQuantLib" ;;
let _new_AssetOrNothingPayoff arg = match _new_AssetOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AssetOrNothingPayoff_f : c_obj list -> c_obj list = "_wrap_delete_AssetOrNothingPayoffQuantLib" ;;
let _delete_AssetOrNothingPayoff arg = match _delete_AssetOrNothingPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SuperSharePayoff_f : c_obj list -> c_obj list = "_wrap_new_SuperSharePayoffQuantLib" ;;
let _new_SuperSharePayoff arg = match _new_SuperSharePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SuperSharePayoff_f : c_obj list -> c_obj list = "_wrap_delete_SuperSharePayoffQuantLib" ;;
let _delete_SuperSharePayoff arg = match _delete_SuperSharePayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GapPayoff_f : c_obj list -> c_obj list = "_wrap_new_GapPayoffQuantLib" ;;
let _new_GapPayoff arg = match _new_GapPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GapPayoff_f : c_obj list -> c_obj list = "_wrap_delete_GapPayoffQuantLib" ;;
let _delete_GapPayoff arg = match _delete_GapPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_BasketPayoffQuantLib" ;;
let _new_BasketPayoff arg = match _new_BasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_BasketPayoffQuantLib" ;;
let _delete_BasketPayoff arg = match _delete_BasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MinBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_MinBasketPayoffQuantLib" ;;
let _new_MinBasketPayoff arg = match _new_MinBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MinBasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_MinBasketPayoffQuantLib" ;;
let _delete_MinBasketPayoff arg = match _delete_MinBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MaxBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_MaxBasketPayoffQuantLib" ;;
let _new_MaxBasketPayoff arg = match _new_MaxBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MaxBasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_MaxBasketPayoffQuantLib" ;;
let _delete_MaxBasketPayoff arg = match _delete_MaxBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AverageBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_AverageBasketPayoff__SWIG_0QuantLib" ;;
let _new_AverageBasketPayoff arg = match _new_AverageBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AverageBasketPayoff_f : c_obj list -> c_obj list = "_wrap_new_AverageBasketPayoffQuantLib" ;;
let _new_AverageBasketPayoff arg = match _new_AverageBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AverageBasketPayoff_f : c_obj list -> c_obj list = "_wrap_delete_AverageBasketPayoffQuantLib" ;;
let _delete_AverageBasketPayoff arg = match _delete_AverageBasketPayoff_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BasketOption_f : c_obj list -> c_obj list = "_wrap_new_BasketOptionQuantLib" ;;
let _new_BasketOption arg = match _new_BasketOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BasketOption_f : c_obj list -> c_obj list = "_wrap_delete_BasketOptionQuantLib" ;;
let _delete_BasketOption arg = match _delete_BasketOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCEuropeanBasketEngine_f : c_obj list -> c_obj list = "_wrap_new_MCEuropeanBasketEngineQuantLib" ;;
let _new_MCEuropeanBasketEngine arg = match _new_MCEuropeanBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCEuropeanBasketEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCEuropeanBasketEngineQuantLib" ;;
let _delete_MCEuropeanBasketEngine arg = match _delete_MCEuropeanBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCAmericanBasketEngine_f : c_obj list -> c_obj list = "_wrap_new_MCAmericanBasketEngineQuantLib" ;;
let _new_MCAmericanBasketEngine arg = match _new_MCAmericanBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCAmericanBasketEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCAmericanBasketEngineQuantLib" ;;
let _delete_MCAmericanBasketEngine arg = match _delete_MCAmericanBasketEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StulzEngine_f : c_obj list -> c_obj list = "_wrap_new_StulzEngineQuantLib" ;;
let _new_StulzEngine arg = match _new_StulzEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StulzEngine_f : c_obj list -> c_obj list = "_wrap_delete_StulzEngineQuantLib" ;;
let _delete_StulzEngine arg = match _delete_StulzEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EverestOption_f : c_obj list -> c_obj list = "_wrap_new_EverestOptionQuantLib" ;;
let _new_EverestOption arg = match _new_EverestOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EverestOption_f : c_obj list -> c_obj list = "_wrap_delete_EverestOptionQuantLib" ;;
let _delete_EverestOption arg = match _delete_EverestOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCEverestEngine_f : c_obj list -> c_obj list = "_wrap_new_MCEverestEngineQuantLib" ;;
let _new_MCEverestEngine arg = match _new_MCEverestEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCEverestEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCEverestEngineQuantLib" ;;
let _delete_MCEverestEngine arg = match _delete_MCEverestEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HimalayaOption_f : c_obj list -> c_obj list = "_wrap_new_HimalayaOptionQuantLib" ;;
let _new_HimalayaOption arg = match _new_HimalayaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HimalayaOption_f : c_obj list -> c_obj list = "_wrap_delete_HimalayaOptionQuantLib" ;;
let _delete_HimalayaOption arg = match _delete_HimalayaOption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MCHimalayaEngine_f : c_obj list -> c_obj list = "_wrap_new_MCHimalayaEngineQuantLib" ;;
let _new_MCHimalayaEngine arg = match _new_MCHimalayaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MCHimalayaEngine_f : c_obj list -> c_obj list = "_wrap_delete_MCHimalayaEngineQuantLib" ;;
let _delete_MCHimalayaEngine arg = match _delete_MCHimalayaEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "DateGeneration::Rule_marker" (`Rule)
external _Backward : c_obj -> Swig.c_obj = "_wrap_Backward" 
external _Forward : c_obj -> Swig.c_obj = "_wrap_Forward" 
external _Zero : c_obj -> Swig.c_obj = "_wrap_Zero" 
external _ThirdWednesday : c_obj -> Swig.c_obj = "_wrap_ThirdWednesday" 
external _Twentieth : c_obj -> Swig.c_obj = "_wrap_Twentieth" 
external _TwentiethIMM : c_obj -> Swig.c_obj = "_wrap_TwentiethIMM" 
external _OldCDS : c_obj -> Swig.c_obj = "_wrap_OldCDS" 
external _new_DateGeneration_f : c_obj list -> c_obj list = "_wrap_new_DateGenerationQuantLib" ;;
let _new_DateGeneration arg = match _new_DateGeneration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DateGeneration_f : c_obj list -> c_obj list = "_wrap_delete_DateGenerationQuantLib" ;;
let _delete_DateGeneration arg = match _delete_DateGeneration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_Schedule__SWIG_0QuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_Schedule__SWIG_1QuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_Schedule__SWIG_2QuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_Schedule__SWIG_3QuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Schedule_f : c_obj list -> c_obj list = "_wrap_new_ScheduleQuantLib" ;;
let _new_Schedule arg = match _new_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Schedule_size_f : c_obj list -> c_obj list = "_wrap_Schedule_sizeQuantLib" ;;
let _Schedule_size arg = match _Schedule_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Schedule_date_f : c_obj list -> c_obj list = "_wrap_Schedule_dateQuantLib" ;;
let _Schedule_date arg = match _Schedule_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Schedule_isRegular_f : c_obj list -> c_obj list = "_wrap_Schedule_isRegularQuantLib" ;;
let _Schedule_isRegular arg = match _Schedule_isRegular_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Schedule_f : c_obj list -> c_obj list = "_wrap_delete_ScheduleQuantLib" ;;
let _delete_Schedule arg = match _delete_Schedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow___deref___f : c_obj list -> c_obj list = "_wrap_CashFlow___deref__QuantLib" ;;
let _CashFlow___deref__ arg = match _CashFlow___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_isNull_f : c_obj list -> c_obj list = "_wrap_CashFlow_isNullQuantLib" ;;
let _CashFlow_isNull arg = match _CashFlow_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_asObservable_f : c_obj list -> c_obj list = "_wrap_CashFlow_asObservableQuantLib" ;;
let _CashFlow_asObservable arg = match _CashFlow_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CashFlow_f : c_obj list -> c_obj list = "_wrap_new_CashFlowQuantLib" ;;
let _new_CashFlow arg = match _new_CashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CashFlow_f : c_obj list -> c_obj list = "_wrap_delete_CashFlowQuantLib" ;;
let _delete_CashFlow arg = match _delete_CashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_amount_f : c_obj list -> c_obj list = "_wrap_CashFlow_amountQuantLib" ;;
let _CashFlow_amount arg = match _CashFlow_amount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlow_date_f : c_obj list -> c_obj list = "_wrap_CashFlow_dateQuantLib" ;;
let _CashFlow_date arg = match _CashFlow_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_Leg__SWIG_0QuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_Leg__SWIG_1QuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_Leg__SWIG_2QuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Leg_f : c_obj list -> c_obj list = "_wrap_new_LegQuantLib" ;;
let _new_Leg arg = match _new_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_size_f : c_obj list -> c_obj list = "_wrap_Leg_sizeQuantLib" ;;
let _Leg_size arg = match _Leg_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_empty_f : c_obj list -> c_obj list = "_wrap_Leg_emptyQuantLib" ;;
let _Leg_empty arg = match _Leg_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_clear_f : c_obj list -> c_obj list = "_wrap_Leg_clearQuantLib" ;;
let _Leg_clear arg = match _Leg_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_push_back_f : c_obj list -> c_obj list = "_wrap_Leg_push_backQuantLib" ;;
let _Leg_push_back arg = match _Leg_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_Leg_operator_bB___QuantLib" ;;
let _Leg_operator_xx_xx_lbrace_xx_rbrace arg = match _Leg_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_Leg_operator_e___QuantLib" ;;
let _Leg_operator_xx_xx_equals arg = match _Leg_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_set_f : c_obj list -> c_obj list = "_wrap_Leg_setQuantLib" ;;
let _Leg_set arg = match _Leg_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Leg_to_array_f : c_obj list -> c_obj list = "_wrap_Leg_to_arrayQuantLib" ;;
let _Leg_to_array arg = match _Leg_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Leg_f : c_obj list -> c_obj list = "_wrap_delete_LegQuantLib" ;;
let _delete_Leg arg = match _delete_Leg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpleCashFlow_f : c_obj list -> c_obj list = "_wrap_new_SimpleCashFlowQuantLib" ;;
let _new_SimpleCashFlow arg = match _new_SimpleCashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpleCashFlow_f : c_obj list -> c_obj list = "_wrap_delete_SimpleCashFlowQuantLib" ;;
let _delete_SimpleCashFlow arg = match _delete_SimpleCashFlow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_nominal_f : c_obj list -> c_obj list = "_wrap_Coupon_nominalQuantLib" ;;
let _Coupon_nominal arg = match _Coupon_nominal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_accrualStartDate_f : c_obj list -> c_obj list = "_wrap_Coupon_accrualStartDateQuantLib" ;;
let _Coupon_accrualStartDate arg = match _Coupon_accrualStartDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_accrualEndDate_f : c_obj list -> c_obj list = "_wrap_Coupon_accrualEndDateQuantLib" ;;
let _Coupon_accrualEndDate arg = match _Coupon_accrualEndDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_referencePeriodStart_f : c_obj list -> c_obj list = "_wrap_Coupon_referencePeriodStartQuantLib" ;;
let _Coupon_referencePeriodStart arg = match _Coupon_referencePeriodStart_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_referencePeriodEnd_f : c_obj list -> c_obj list = "_wrap_Coupon_referencePeriodEndQuantLib" ;;
let _Coupon_referencePeriodEnd arg = match _Coupon_referencePeriodEnd_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_rate_f : c_obj list -> c_obj list = "_wrap_Coupon_rateQuantLib" ;;
let _Coupon_rate arg = match _Coupon_rate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_accrualPeriod_f : c_obj list -> c_obj list = "_wrap_Coupon_accrualPeriodQuantLib" ;;
let _Coupon_accrualPeriod arg = match _Coupon_accrualPeriod_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_accrualDays_f : c_obj list -> c_obj list = "_wrap_Coupon_accrualDaysQuantLib" ;;
let _Coupon_accrualDays arg = match _Coupon_accrualDays_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_dayCounter_f : c_obj list -> c_obj list = "_wrap_Coupon_dayCounterQuantLib" ;;
let _Coupon_dayCounter arg = match _Coupon_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Coupon_accruedAmount_f : c_obj list -> c_obj list = "_wrap_Coupon_accruedAmountQuantLib" ;;
let _Coupon_accruedAmount arg = match _Coupon_accruedAmount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Coupon_f : c_obj list -> c_obj list = "_wrap_delete_CouponQuantLib" ;;
let _delete_Coupon arg = match _delete_Coupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _as_coupon_f : c_obj list -> c_obj list = "_wrap_as_couponQuantLib" ;;
let _as_coupon arg = match _as_coupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateCoupon_f : c_obj list -> c_obj list = "_wrap_new_FixedRateCouponQuantLib" ;;
let _new_FixedRateCoupon arg = match _new_FixedRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateCoupon_interestRate_f : c_obj list -> c_obj list = "_wrap_FixedRateCoupon_interestRateQuantLib" ;;
let _FixedRateCoupon_interestRate arg = match _FixedRateCoupon_interestRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedRateCoupon_f : c_obj list -> c_obj list = "_wrap_delete_FixedRateCouponQuantLib" ;;
let _delete_FixedRateCoupon arg = match _delete_FixedRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _as_fixed_rate_coupon_f : c_obj list -> c_obj list = "_wrap_as_fixed_rate_couponQuantLib" ;;
let _as_fixed_rate_coupon arg = match _as_fixed_rate_coupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCouponPricer___deref___f : c_obj list -> c_obj list = "_wrap_FloatingRateCouponPricer___deref__QuantLib" ;;
let _FloatingRateCouponPricer___deref__ arg = match _FloatingRateCouponPricer___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCouponPricer_isNull_f : c_obj list -> c_obj list = "_wrap_FloatingRateCouponPricer_isNullQuantLib" ;;
let _FloatingRateCouponPricer_isNull arg = match _FloatingRateCouponPricer_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloatingRateCouponPricer_f : c_obj list -> c_obj list = "_wrap_new_FloatingRateCouponPricerQuantLib" ;;
let _new_FloatingRateCouponPricer arg = match _new_FloatingRateCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FloatingRateCouponPricer_f : c_obj list -> c_obj list = "_wrap_delete_FloatingRateCouponPricerQuantLib" ;;
let _delete_FloatingRateCouponPricer arg = match _delete_FloatingRateCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _setCouponPricer_f : c_obj list -> c_obj list = "_wrap_setCouponPricerQuantLib" ;;
let _setCouponPricer arg = match _setCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_fixingDate_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_fixingDateQuantLib" ;;
let _FloatingRateCoupon_fixingDate arg = match _FloatingRateCoupon_fixingDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_fixingDays_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_fixingDaysQuantLib" ;;
let _FloatingRateCoupon_fixingDays arg = match _FloatingRateCoupon_fixingDays_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_isInArrears_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_isInArrearsQuantLib" ;;
let _FloatingRateCoupon_isInArrears arg = match _FloatingRateCoupon_isInArrears_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_gearing_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_gearingQuantLib" ;;
let _FloatingRateCoupon_gearing arg = match _FloatingRateCoupon_gearing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_spread_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_spreadQuantLib" ;;
let _FloatingRateCoupon_spread arg = match _FloatingRateCoupon_spread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_indexFixing_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_indexFixingQuantLib" ;;
let _FloatingRateCoupon_indexFixing arg = match _FloatingRateCoupon_indexFixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_adjustedFixing_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_adjustedFixingQuantLib" ;;
let _FloatingRateCoupon_adjustedFixing arg = match _FloatingRateCoupon_adjustedFixing_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_convexityAdjustment_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_convexityAdjustmentQuantLib" ;;
let _FloatingRateCoupon_convexityAdjustment arg = match _FloatingRateCoupon_convexityAdjustment_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_price_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_priceQuantLib" ;;
let _FloatingRateCoupon_price arg = match _FloatingRateCoupon_price_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_index_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_indexQuantLib" ;;
let _FloatingRateCoupon_index arg = match _FloatingRateCoupon_index_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FloatingRateCoupon_setPricer_f : c_obj list -> c_obj list = "_wrap_FloatingRateCoupon_setPricerQuantLib" ;;
let _FloatingRateCoupon_setPricer arg = match _FloatingRateCoupon_setPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FloatingRateCoupon_f : c_obj list -> c_obj list = "_wrap_delete_FloatingRateCouponQuantLib" ;;
let _delete_FloatingRateCoupon arg = match _delete_FloatingRateCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _as_floating_rate_coupon_f : c_obj list -> c_obj list = "_wrap_as_floating_rate_couponQuantLib" ;;
let _as_floating_rate_coupon arg = match _as_floating_rate_coupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCouponQuantLib" ;;
let _new_CappedFlooredCoupon arg = match _new_CappedFlooredCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CappedFlooredCoupon_cap_f : c_obj list -> c_obj list = "_wrap_CappedFlooredCoupon_capQuantLib" ;;
let _CappedFlooredCoupon_cap arg = match _CappedFlooredCoupon_cap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CappedFlooredCoupon_floor_f : c_obj list -> c_obj list = "_wrap_CappedFlooredCoupon_floorQuantLib" ;;
let _CappedFlooredCoupon_floor arg = match _CappedFlooredCoupon_floor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CappedFlooredCoupon_effectiveCap_f : c_obj list -> c_obj list = "_wrap_CappedFlooredCoupon_effectiveCapQuantLib" ;;
let _CappedFlooredCoupon_effectiveCap arg = match _CappedFlooredCoupon_effectiveCap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CappedFlooredCoupon_effectiveFloor_f : c_obj list -> c_obj list = "_wrap_CappedFlooredCoupon_effectiveFloorQuantLib" ;;
let _CappedFlooredCoupon_effectiveFloor arg = match _CappedFlooredCoupon_effectiveFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CappedFlooredCoupon_isCapped_f : c_obj list -> c_obj list = "_wrap_CappedFlooredCoupon_isCappedQuantLib" ;;
let _CappedFlooredCoupon_isCapped arg = match _CappedFlooredCoupon_isCapped_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CappedFlooredCoupon_isFloored_f : c_obj list -> c_obj list = "_wrap_CappedFlooredCoupon_isFlooredQuantLib" ;;
let _CappedFlooredCoupon_isFloored arg = match _CappedFlooredCoupon_isFloored_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CappedFlooredCoupon_setPricer_f : c_obj list -> c_obj list = "_wrap_CappedFlooredCoupon_setPricerQuantLib" ;;
let _CappedFlooredCoupon_setPricer arg = match _CappedFlooredCoupon_setPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CappedFlooredCoupon_f : c_obj list -> c_obj list = "_wrap_delete_CappedFlooredCouponQuantLib" ;;
let _delete_CappedFlooredCoupon arg = match _delete_CappedFlooredCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_IborCoupon_f : c_obj list -> c_obj list = "_wrap_new_IborCouponQuantLib" ;;
let _new_IborCoupon arg = match _new_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IborCoupon_f : c_obj list -> c_obj list = "_wrap_delete_IborCouponQuantLib" ;;
let _delete_IborCoupon arg = match _delete_IborCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborCouponPricer_capletVolatility_f : c_obj list -> c_obj list = "_wrap_IborCouponPricer_capletVolatilityQuantLib" ;;
let _IborCouponPricer_capletVolatility arg = match _IborCouponPricer_capletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborCouponPricer_setCapletVolatility_f : c_obj list -> c_obj list = "_wrap_IborCouponPricer_setCapletVolatility__SWIG_0QuantLib" ;;
let _IborCouponPricer_setCapletVolatility arg = match _IborCouponPricer_setCapletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborCouponPricer_setCapletVolatility_f : c_obj list -> c_obj list = "_wrap_IborCouponPricer_setCapletVolatilityQuantLib" ;;
let _IborCouponPricer_setCapletVolatility arg = match _IborCouponPricer_setCapletVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_IborCouponPricer_f : c_obj list -> c_obj list = "_wrap_delete_IborCouponPricerQuantLib" ;;
let _delete_IborCouponPricer arg = match _delete_IborCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackIborCouponPricer_f : c_obj list -> c_obj list = "_wrap_new_BlackIborCouponPricer__SWIG_0QuantLib" ;;
let _new_BlackIborCouponPricer arg = match _new_BlackIborCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackIborCouponPricer_f : c_obj list -> c_obj list = "_wrap_new_BlackIborCouponPricerQuantLib" ;;
let _new_BlackIborCouponPricer arg = match _new_BlackIborCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackIborCouponPricer_f : c_obj list -> c_obj list = "_wrap_delete_BlackIborCouponPricerQuantLib" ;;
let _delete_BlackIborCouponPricer arg = match _delete_BlackIborCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CmsCouponQuantLib" ;;
let _new_CmsCoupon arg = match _new_CmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CmsCoupon_f : c_obj list -> c_obj list = "_wrap_delete_CmsCouponQuantLib" ;;
let _delete_CmsCoupon arg = match _delete_CmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CmsCouponPricer_swaptionVolatility_f : c_obj list -> c_obj list = "_wrap_CmsCouponPricer_swaptionVolatilityQuantLib" ;;
let _CmsCouponPricer_swaptionVolatility arg = match _CmsCouponPricer_swaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CmsCouponPricer_setSwaptionVolatility_f : c_obj list -> c_obj list = "_wrap_CmsCouponPricer_setSwaptionVolatility__SWIG_0QuantLib" ;;
let _CmsCouponPricer_setSwaptionVolatility arg = match _CmsCouponPricer_setSwaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CmsCouponPricer_setSwaptionVolatility_f : c_obj list -> c_obj list = "_wrap_CmsCouponPricer_setSwaptionVolatilityQuantLib" ;;
let _CmsCouponPricer_setSwaptionVolatility arg = match _CmsCouponPricer_setSwaptionVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CmsCouponPricer_f : c_obj list -> c_obj list = "_wrap_delete_CmsCouponPricerQuantLib" ;;
let _delete_CmsCouponPricer arg = match _delete_CmsCouponPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "GFunctionFactory::YieldCurveModel_marker" (`YieldCurveModel)
external _Standard : c_obj -> Swig.c_obj = "_wrap_Standard" 
external _ExactYield : c_obj -> Swig.c_obj = "_wrap_ExactYield" 
external _ParallelShifts : c_obj -> Swig.c_obj = "_wrap_ParallelShifts" 
external _NonParallelShifts : c_obj -> Swig.c_obj = "_wrap_NonParallelShifts" 
external _delete_GFunctionFactory_f : c_obj list -> c_obj list = "_wrap_delete_GFunctionFactoryQuantLib" ;;
let _delete_GFunctionFactory arg = match _delete_GFunctionFactory_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AnalyticHaganPricer_f : c_obj list -> c_obj list = "_wrap_new_AnalyticHaganPricerQuantLib" ;;
let _new_AnalyticHaganPricer arg = match _new_AnalyticHaganPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AnalyticHaganPricer_f : c_obj list -> c_obj list = "_wrap_delete_AnalyticHaganPricerQuantLib" ;;
let _delete_AnalyticHaganPricer arg = match _delete_AnalyticHaganPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NumericHaganPricer_f : c_obj list -> c_obj list = "_wrap_new_NumericHaganPricer__SWIG_0QuantLib" ;;
let _new_NumericHaganPricer arg = match _new_NumericHaganPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NumericHaganPricer_f : c_obj list -> c_obj list = "_wrap_new_NumericHaganPricer__SWIG_1QuantLib" ;;
let _new_NumericHaganPricer arg = match _new_NumericHaganPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NumericHaganPricer_f : c_obj list -> c_obj list = "_wrap_new_NumericHaganPricer__SWIG_2QuantLib" ;;
let _new_NumericHaganPricer arg = match _new_NumericHaganPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NumericHaganPricer_f : c_obj list -> c_obj list = "_wrap_new_NumericHaganPricerQuantLib" ;;
let _new_NumericHaganPricer arg = match _new_NumericHaganPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NumericHaganPricer_f : c_obj list -> c_obj list = "_wrap_delete_NumericHaganPricerQuantLib" ;;
let _delete_NumericHaganPricer arg = match _delete_NumericHaganPricer_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_0QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_1QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_2QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_3QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_4QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_5QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_6QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCoupon__SWIG_7QuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_new_CappedFlooredCmsCouponQuantLib" ;;
let _new_CappedFlooredCmsCoupon arg = match _new_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CappedFlooredCmsCoupon_f : c_obj list -> c_obj list = "_wrap_delete_CappedFlooredCmsCouponQuantLib" ;;
let _delete_CappedFlooredCmsCoupon arg = match _delete_CappedFlooredCmsCoupon_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateLeg_f : c_obj list -> c_obj list = "_wrap_FixedRateLegQuantLib" ;;
let _FixedRateLeg arg = match _FixedRateLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _IborLeg_f : c_obj list -> c_obj list = "_wrap_IborLegQuantLib" ;;
let _IborLeg arg = match _IborLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CmsLeg_f : c_obj list -> c_obj list = "_wrap_CmsLegQuantLib" ;;
let _CmsLeg arg = match _CmsLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CmsZeroLeg_f : c_obj list -> c_obj list = "_wrap_CmsZeroLegQuantLib" ;;
let _CmsZeroLeg arg = match _CmsZeroLeg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Duration::Type_marker" (`Type)
external _Macaulay : c_obj -> Swig.c_obj = "_wrap_Macaulay" 
external _Modified : c_obj -> Swig.c_obj = "_wrap_Modified" 
external _new_Duration_f : c_obj list -> c_obj list = "_wrap_new_DurationQuantLib" ;;
let _new_Duration arg = match _new_Duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Duration_f : c_obj list -> c_obj list = "_wrap_delete_DurationQuantLib" ;;
let _delete_Duration arg = match _delete_Duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_startDate_f : c_obj list -> c_obj list = "_wrap_CashFlows_startDateQuantLib" ;;
let _CashFlows_startDate arg = match _CashFlows_startDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_maturityDate_f : c_obj list -> c_obj list = "_wrap_CashFlows_maturityDateQuantLib" ;;
let _CashFlows_maturityDate arg = match _CashFlows_maturityDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_0QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_1QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_2QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_3QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_4QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_5QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_6QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_7QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_8QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_9QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npv__SWIG_10QuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_npv_f : c_obj list -> c_obj list = "_wrap_CashFlows_npvQuantLib" ;;
let _CashFlows_npv arg = match _CashFlows_npv_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_0QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_1QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_2QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_3QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_4QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_5QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_6QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_7QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_8QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_9QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bps__SWIG_10QuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_bps_f : c_obj list -> c_obj list = "_wrap_CashFlows_bpsQuantLib" ;;
let _CashFlows_bps arg = match _CashFlows_bps_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRate__SWIG_0QuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRate__SWIG_1QuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRate__SWIG_2QuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_atmRate_f : c_obj list -> c_obj list = "_wrap_CashFlows_atmRateQuantLib" ;;
let _CashFlows_atmRate arg = match _CashFlows_atmRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_yield_f : c_obj list -> c_obj list = "_wrap_CashFlows_yield__SWIG_0QuantLib" ;;
let _CashFlows_yield arg = match _CashFlows_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_yield_f : c_obj list -> c_obj list = "_wrap_CashFlows_yield__SWIG_1QuantLib" ;;
let _CashFlows_yield arg = match _CashFlows_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_yield_f : c_obj list -> c_obj list = "_wrap_CashFlows_yield__SWIG_2QuantLib" ;;
let _CashFlows_yield arg = match _CashFlows_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_yield_f : c_obj list -> c_obj list = "_wrap_CashFlows_yield__SWIG_3QuantLib" ;;
let _CashFlows_yield arg = match _CashFlows_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_yield_f : c_obj list -> c_obj list = "_wrap_CashFlows_yield__SWIG_4QuantLib" ;;
let _CashFlows_yield arg = match _CashFlows_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_yield_f : c_obj list -> c_obj list = "_wrap_CashFlows_yieldQuantLib" ;;
let _CashFlows_yield arg = match _CashFlows_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_duration__SWIG_0QuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_duration__SWIG_1QuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_duration__SWIG_2QuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_duration__SWIG_3QuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_duration_f : c_obj list -> c_obj list = "_wrap_CashFlows_durationQuantLib" ;;
let _CashFlows_duration arg = match _CashFlows_duration_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexity__SWIG_0QuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexity__SWIG_1QuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexity__SWIG_2QuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexity__SWIG_3QuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexity__SWIG_4QuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CashFlows_convexity_f : c_obj list -> c_obj list = "_wrap_CashFlows_convexityQuantLib" ;;
let _CashFlows_convexity arg = match _CashFlows_convexity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CashFlows_f : c_obj list -> c_obj list = "_wrap_delete_CashFlowsQuantLib" ;;
let _delete_CashFlows arg = match _delete_CashFlows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Bond_f : c_obj list -> c_obj list = "_wrap_new_Bond__SWIG_0QuantLib" ;;
let _new_Bond arg = match _new_Bond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Bond_f : c_obj list -> c_obj list = "_wrap_new_Bond__SWIG_1QuantLib" ;;
let _new_Bond arg = match _new_Bond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Bond_f : c_obj list -> c_obj list = "_wrap_new_BondQuantLib" ;;
let _new_Bond arg = match _new_Bond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_nextCouponRate_f : c_obj list -> c_obj list = "_wrap_Bond_nextCouponRate__SWIG_0QuantLib" ;;
let _Bond_nextCouponRate arg = match _Bond_nextCouponRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_nextCouponRate_f : c_obj list -> c_obj list = "_wrap_Bond_nextCouponRateQuantLib" ;;
let _Bond_nextCouponRate arg = match _Bond_nextCouponRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_previousCouponRate_f : c_obj list -> c_obj list = "_wrap_Bond_previousCouponRate__SWIG_0QuantLib" ;;
let _Bond_previousCouponRate arg = match _Bond_previousCouponRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_previousCouponRate_f : c_obj list -> c_obj list = "_wrap_Bond_previousCouponRateQuantLib" ;;
let _Bond_previousCouponRate arg = match _Bond_previousCouponRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_settlementDays_f : c_obj list -> c_obj list = "_wrap_Bond_settlementDaysQuantLib" ;;
let _Bond_settlementDays arg = match _Bond_settlementDays_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_settlementDate_f : c_obj list -> c_obj list = "_wrap_Bond_settlementDateQuantLib" ;;
let _Bond_settlementDate arg = match _Bond_settlementDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_startDate_f : c_obj list -> c_obj list = "_wrap_Bond_startDateQuantLib" ;;
let _Bond_startDate arg = match _Bond_startDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_maturityDate_f : c_obj list -> c_obj list = "_wrap_Bond_maturityDateQuantLib" ;;
let _Bond_maturityDate arg = match _Bond_maturityDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_issueDate_f : c_obj list -> c_obj list = "_wrap_Bond_issueDateQuantLib" ;;
let _Bond_issueDate arg = match _Bond_issueDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cashflows_f : c_obj list -> c_obj list = "_wrap_Bond_cashflowsQuantLib" ;;
let _Bond_cashflows arg = match _Bond_cashflows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_redemptions_f : c_obj list -> c_obj list = "_wrap_Bond_redemptionsQuantLib" ;;
let _Bond_redemptions arg = match _Bond_redemptions_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_redemption_f : c_obj list -> c_obj list = "_wrap_Bond_redemptionQuantLib" ;;
let _Bond_redemption arg = match _Bond_redemption_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_calendar_f : c_obj list -> c_obj list = "_wrap_Bond_calendarQuantLib" ;;
let _Bond_calendar arg = match _Bond_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_notionals_f : c_obj list -> c_obj list = "_wrap_Bond_notionalsQuantLib" ;;
let _Bond_notionals arg = match _Bond_notionals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_notional_f : c_obj list -> c_obj list = "_wrap_Bond_notional__SWIG_0QuantLib" ;;
let _Bond_notional arg = match _Bond_notional_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_notional_f : c_obj list -> c_obj list = "_wrap_Bond_notionalQuantLib" ;;
let _Bond_notional arg = match _Bond_notional_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cleanPrice_f : c_obj list -> c_obj list = "_wrap_Bond_cleanPrice__SWIG_0QuantLib" ;;
let _Bond_cleanPrice arg = match _Bond_cleanPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cleanPrice_f : c_obj list -> c_obj list = "_wrap_Bond_cleanPrice__SWIG_1QuantLib" ;;
let _Bond_cleanPrice arg = match _Bond_cleanPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_cleanPrice_f : c_obj list -> c_obj list = "_wrap_Bond_cleanPriceQuantLib" ;;
let _Bond_cleanPrice arg = match _Bond_cleanPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_dirtyPrice_f : c_obj list -> c_obj list = "_wrap_Bond_dirtyPrice__SWIG_0QuantLib" ;;
let _Bond_dirtyPrice arg = match _Bond_dirtyPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_dirtyPrice_f : c_obj list -> c_obj list = "_wrap_Bond_dirtyPrice__SWIG_1QuantLib" ;;
let _Bond_dirtyPrice arg = match _Bond_dirtyPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_dirtyPrice_f : c_obj list -> c_obj list = "_wrap_Bond_dirtyPriceQuantLib" ;;
let _Bond_dirtyPrice arg = match _Bond_dirtyPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_0QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_1QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_2QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_3QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_4QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yield__SWIG_5QuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_yield_f : c_obj list -> c_obj list = "_wrap_Bond_yieldQuantLib" ;;
let _Bond_yield arg = match _Bond_yield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_accruedAmount_f : c_obj list -> c_obj list = "_wrap_Bond_accruedAmount__SWIG_0QuantLib" ;;
let _Bond_accruedAmount arg = match _Bond_accruedAmount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_accruedAmount_f : c_obj list -> c_obj list = "_wrap_Bond_accruedAmountQuantLib" ;;
let _Bond_accruedAmount arg = match _Bond_accruedAmount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_settlementValue_f : c_obj list -> c_obj list = "_wrap_Bond_settlementValue__SWIG_0QuantLib" ;;
let _Bond_settlementValue arg = match _Bond_settlementValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Bond_settlementValue_f : c_obj list -> c_obj list = "_wrap_Bond_settlementValueQuantLib" ;;
let _Bond_settlementValue arg = match _Bond_settlementValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Bond_f : c_obj list -> c_obj list = "_wrap_delete_BondQuantLib" ;;
let _delete_Bond arg = match _delete_Bond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _cleanPriceFromZSpread_f : c_obj list -> c_obj list = "_wrap_cleanPriceFromZSpread__SWIG_0QuantLib" ;;
let _cleanPriceFromZSpread arg = match _cleanPriceFromZSpread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _cleanPriceFromZSpread_f : c_obj list -> c_obj list = "_wrap_cleanPriceFromZSpreadQuantLib" ;;
let _cleanPriceFromZSpread arg = match _cleanPriceFromZSpread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ZeroCouponBondQuantLib" ;;
let _new_ZeroCouponBond arg = match _new_ZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_delete_ZeroCouponBondQuantLib" ;;
let _delete_ZeroCouponBond arg = match _delete_ZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateBond_f : c_obj list -> c_obj list = "_wrap_new_FixedRateBondQuantLib" ;;
let _new_FixedRateBond arg = match _new_FixedRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateBond_frequency_f : c_obj list -> c_obj list = "_wrap_FixedRateBond_frequencyQuantLib" ;;
let _FixedRateBond_frequency arg = match _FixedRateBond_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateBond_dayCounter_f : c_obj list -> c_obj list = "_wrap_FixedRateBond_dayCounterQuantLib" ;;
let _FixedRateBond_dayCounter arg = match _FixedRateBond_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedRateBond_f : c_obj list -> c_obj list = "_wrap_delete_FixedRateBondQuantLib" ;;
let _delete_FixedRateBond arg = match _delete_FixedRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FloatingRateBond_f : c_obj list -> c_obj list = "_wrap_new_FloatingRateBondQuantLib" ;;
let _new_FloatingRateBond arg = match _new_FloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FloatingRateBond_f : c_obj list -> c_obj list = "_wrap_delete_FloatingRateBondQuantLib" ;;
let _delete_FloatingRateBond arg = match _delete_FloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CmsRateBond_f : c_obj list -> c_obj list = "_wrap_new_CmsRateBondQuantLib" ;;
let _new_CmsRateBond arg = match _new_CmsRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CmsRateBond_f : c_obj list -> c_obj list = "_wrap_delete_CmsRateBondQuantLib" ;;
let _delete_CmsRateBond arg = match _delete_CmsRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountingBondEngine_f : c_obj list -> c_obj list = "_wrap_new_DiscountingBondEngineQuantLib" ;;
let _new_DiscountingBondEngine arg = match _new_DiscountingBondEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DiscountingBondEngine_f : c_obj list -> c_obj list = "_wrap_delete_DiscountingBondEngineQuantLib" ;;
let _delete_DiscountingBondEngine arg = match _delete_DiscountingBondEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "CallabilityPrice::Type_marker" (`Type)
external _Dirty : c_obj -> Swig.c_obj = "_wrap_Dirty" 
external _Clean : c_obj -> Swig.c_obj = "_wrap_Clean" 
external _new_CallabilityPrice_f : c_obj list -> c_obj list = "_wrap_new_CallabilityPriceQuantLib" ;;
let _new_CallabilityPrice arg = match _new_CallabilityPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityPrice_amount_f : c_obj list -> c_obj list = "_wrap_CallabilityPrice_amountQuantLib" ;;
let _CallabilityPrice_amount arg = match _CallabilityPrice_amount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilityPrice_type_f : c_obj list -> c_obj list = "_wrap_CallabilityPrice_typeQuantLib" ;;
let _CallabilityPrice_type arg = match _CallabilityPrice_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CallabilityPrice_f : c_obj list -> c_obj list = "_wrap_delete_CallabilityPriceQuantLib" ;;
let _delete_CallabilityPrice arg = match _delete_CallabilityPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability___deref___f : c_obj list -> c_obj list = "_wrap_Callability___deref__QuantLib" ;;
let _Callability___deref__ arg = match _Callability___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_isNull_f : c_obj list -> c_obj list = "_wrap_Callability_isNullQuantLib" ;;
let _Callability_isNull arg = match _Callability_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Callability_f : c_obj list -> c_obj list = "_wrap_new_CallabilityQuantLib" ;;
let _new_Callability arg = match _new_Callability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_Call : c_obj -> Swig.c_obj = "_wrap_Callability_Call" 
external _Callability_Put : c_obj -> Swig.c_obj = "_wrap_Callability_Put" 
external _delete_Callability_f : c_obj list -> c_obj list = "_wrap_delete_CallabilityQuantLib" ;;
let _delete_Callability arg = match _delete_Callability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_price_f : c_obj list -> c_obj list = "_wrap_Callability_priceQuantLib" ;;
let _Callability_price arg = match _Callability_price_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_type_f : c_obj list -> c_obj list = "_wrap_Callability_typeQuantLib" ;;
let _Callability_type arg = match _Callability_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Callability_date_f : c_obj list -> c_obj list = "_wrap_Callability_dateQuantLib" ;;
let _Callability_date arg = match _Callability_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SoftCallability_f : c_obj list -> c_obj list = "_wrap_new_SoftCallabilityQuantLib" ;;
let _new_SoftCallability arg = match _new_SoftCallability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SoftCallability_f : c_obj list -> c_obj list = "_wrap_delete_SoftCallabilityQuantLib" ;;
let _delete_SoftCallability arg = match _delete_SoftCallability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilitySchedule_f : c_obj list -> c_obj list = "_wrap_new_CallabilitySchedule__SWIG_0QuantLib" ;;
let _new_CallabilitySchedule arg = match _new_CallabilitySchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilitySchedule_f : c_obj list -> c_obj list = "_wrap_new_CallabilitySchedule__SWIG_1QuantLib" ;;
let _new_CallabilitySchedule arg = match _new_CallabilitySchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilitySchedule_f : c_obj list -> c_obj list = "_wrap_new_CallabilitySchedule__SWIG_2QuantLib" ;;
let _new_CallabilitySchedule arg = match _new_CallabilitySchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CallabilitySchedule_f : c_obj list -> c_obj list = "_wrap_new_CallabilityScheduleQuantLib" ;;
let _new_CallabilitySchedule arg = match _new_CallabilitySchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_size_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_sizeQuantLib" ;;
let _CallabilitySchedule_size arg = match _CallabilitySchedule_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_empty_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_emptyQuantLib" ;;
let _CallabilitySchedule_empty arg = match _CallabilitySchedule_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_clear_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_clearQuantLib" ;;
let _CallabilitySchedule_clear arg = match _CallabilitySchedule_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_push_back_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_push_backQuantLib" ;;
let _CallabilitySchedule_push_back arg = match _CallabilitySchedule_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_operator_bB___QuantLib" ;;
let _CallabilitySchedule_operator_xx_xx_lbrace_xx_rbrace arg = match _CallabilitySchedule_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_operator_e___QuantLib" ;;
let _CallabilitySchedule_operator_xx_xx_equals arg = match _CallabilitySchedule_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_set_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_setQuantLib" ;;
let _CallabilitySchedule_set arg = match _CallabilitySchedule_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CallabilitySchedule_to_array_f : c_obj list -> c_obj list = "_wrap_CallabilitySchedule_to_arrayQuantLib" ;;
let _CallabilitySchedule_to_array arg = match _CallabilitySchedule_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CallabilitySchedule_f : c_obj list -> c_obj list = "_wrap_delete_CallabilityScheduleQuantLib" ;;
let _delete_CallabilitySchedule arg = match _delete_CallabilitySchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_0QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_1QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_2QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatility__SWIG_3QuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CapFloor_impliedVolatilityQuantLib" ;;
let _CapFloor_impliedVolatility arg = match _CapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapFloor_f : c_obj list -> c_obj list = "_wrap_new_CapFloorQuantLib" ;;
let _new_CapFloor arg = match _new_CapFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapFloor_f : c_obj list -> c_obj list = "_wrap_delete_CapFloorQuantLib" ;;
let _delete_CapFloor arg = match _delete_CapFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Cap_f : c_obj list -> c_obj list = "_wrap_new_CapQuantLib" ;;
let _new_Cap arg = match _new_Cap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Cap_f : c_obj list -> c_obj list = "_wrap_delete_CapQuantLib" ;;
let _delete_Cap arg = match _delete_Cap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Floor_f : c_obj list -> c_obj list = "_wrap_new_FloorQuantLib" ;;
let _new_Floor arg = match _new_Floor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Floor_f : c_obj list -> c_obj list = "_wrap_delete_FloorQuantLib" ;;
let _delete_Floor arg = match _delete_Floor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Collar_f : c_obj list -> c_obj list = "_wrap_new_CollarQuantLib" ;;
let _new_Collar arg = match _new_Collar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Collar_f : c_obj list -> c_obj list = "_wrap_delete_CollarQuantLib" ;;
let _delete_Collar arg = match _delete_Collar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_new_BlackCapFloorEngine__SWIG_0QuantLib" ;;
let _new_BlackCapFloorEngine arg = match _new_BlackCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BlackCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_new_BlackCapFloorEngineQuantLib" ;;
let _new_BlackCapFloorEngine arg = match _new_BlackCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BlackCapFloorEngine_f : c_obj list -> c_obj list = "_wrap_delete_BlackCapFloorEngineQuantLib" ;;
let _delete_BlackCapFloorEngine arg = match _delete_BlackCapFloorEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend___deref___f : c_obj list -> c_obj list = "_wrap_Dividend___deref__QuantLib" ;;
let _Dividend___deref__ arg = match _Dividend___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend_isNull_f : c_obj list -> c_obj list = "_wrap_Dividend_isNullQuantLib" ;;
let _Dividend_isNull arg = match _Dividend_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Dividend_f : c_obj list -> c_obj list = "_wrap_new_DividendQuantLib" ;;
let _new_Dividend arg = match _new_Dividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Dividend_f : c_obj list -> c_obj list = "_wrap_delete_DividendQuantLib" ;;
let _delete_Dividend arg = match _delete_Dividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend_amount_f : c_obj list -> c_obj list = "_wrap_Dividend_amountQuantLib" ;;
let _Dividend_amount arg = match _Dividend_amount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Dividend_date_f : c_obj list -> c_obj list = "_wrap_Dividend_dateQuantLib" ;;
let _Dividend_date arg = match _Dividend_date_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedDividend_f : c_obj list -> c_obj list = "_wrap_new_FixedDividendQuantLib" ;;
let _new_FixedDividend arg = match _new_FixedDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedDividend_f : c_obj list -> c_obj list = "_wrap_delete_FixedDividendQuantLib" ;;
let _delete_FixedDividend arg = match _delete_FixedDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FractionalDividend_f : c_obj list -> c_obj list = "_wrap_new_FractionalDividendQuantLib" ;;
let _new_FractionalDividend arg = match _new_FractionalDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FractionalDividend_f : c_obj list -> c_obj list = "_wrap_delete_FractionalDividendQuantLib" ;;
let _delete_FractionalDividend arg = match _delete_FractionalDividend_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DividendSchedule_f : c_obj list -> c_obj list = "_wrap_new_DividendSchedule__SWIG_0QuantLib" ;;
let _new_DividendSchedule arg = match _new_DividendSchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DividendSchedule_f : c_obj list -> c_obj list = "_wrap_new_DividendSchedule__SWIG_1QuantLib" ;;
let _new_DividendSchedule arg = match _new_DividendSchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DividendSchedule_f : c_obj list -> c_obj list = "_wrap_new_DividendSchedule__SWIG_2QuantLib" ;;
let _new_DividendSchedule arg = match _new_DividendSchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DividendSchedule_f : c_obj list -> c_obj list = "_wrap_new_DividendScheduleQuantLib" ;;
let _new_DividendSchedule arg = match _new_DividendSchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_size_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_sizeQuantLib" ;;
let _DividendSchedule_size arg = match _DividendSchedule_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_empty_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_emptyQuantLib" ;;
let _DividendSchedule_empty arg = match _DividendSchedule_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_clear_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_clearQuantLib" ;;
let _DividendSchedule_clear arg = match _DividendSchedule_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_push_back_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_push_backQuantLib" ;;
let _DividendSchedule_push_back arg = match _DividendSchedule_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_operator_bB___QuantLib" ;;
let _DividendSchedule_operator_xx_xx_lbrace_xx_rbrace arg = match _DividendSchedule_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_operator_e___QuantLib" ;;
let _DividendSchedule_operator_xx_xx_equals arg = match _DividendSchedule_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_set_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_setQuantLib" ;;
let _DividendSchedule_set arg = match _DividendSchedule_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DividendSchedule_to_array_f : c_obj list -> c_obj list = "_wrap_DividendSchedule_to_arrayQuantLib" ;;
let _DividendSchedule_to_array arg = match _DividendSchedule_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DividendSchedule_f : c_obj list -> c_obj list = "_wrap_delete_DividendScheduleQuantLib" ;;
let _delete_DividendSchedule arg = match _delete_DividendSchedule_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleZeroCouponBond__SWIG_0QuantLib" ;;
let _new_ConvertibleZeroCouponBond arg = match _new_ConvertibleZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleZeroCouponBondQuantLib" ;;
let _new_ConvertibleZeroCouponBond arg = match _new_ConvertibleZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConvertibleZeroCouponBond_f : c_obj list -> c_obj list = "_wrap_delete_ConvertibleZeroCouponBondQuantLib" ;;
let _delete_ConvertibleZeroCouponBond arg = match _delete_ConvertibleZeroCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFixedCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFixedCouponBond__SWIG_0QuantLib" ;;
let _new_ConvertibleFixedCouponBond arg = match _new_ConvertibleFixedCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFixedCouponBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFixedCouponBondQuantLib" ;;
let _new_ConvertibleFixedCouponBond arg = match _new_ConvertibleFixedCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConvertibleFixedCouponBond_f : c_obj list -> c_obj list = "_wrap_delete_ConvertibleFixedCouponBondQuantLib" ;;
let _delete_ConvertibleFixedCouponBond arg = match _delete_ConvertibleFixedCouponBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFloatingRateBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFloatingRateBond__SWIG_0QuantLib" ;;
let _new_ConvertibleFloatingRateBond arg = match _new_ConvertibleFloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ConvertibleFloatingRateBond_f : c_obj list -> c_obj list = "_wrap_new_ConvertibleFloatingRateBondQuantLib" ;;
let _new_ConvertibleFloatingRateBond arg = match _new_ConvertibleFloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ConvertibleFloatingRateBond_f : c_obj list -> c_obj list = "_wrap_delete_ConvertibleFloatingRateBondQuantLib" ;;
let _delete_ConvertibleFloatingRateBond arg = match _delete_ConvertibleFloatingRateBond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BinomialConvertibleEngine_f : c_obj list -> c_obj list = "_wrap_new_BinomialConvertibleEngineQuantLib" ;;
let _new_BinomialConvertibleEngine arg = match _new_BinomialConvertibleEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BinomialConvertibleEngine_f : c_obj list -> c_obj list = "_wrap_delete_BinomialConvertibleEngineQuantLib" ;;
let _delete_BinomialConvertibleEngine arg = match _delete_BinomialConvertibleEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure___deref__QuantLib" ;;
let _DefaultProbabilityTermStructure___deref__ arg = match _DefaultProbabilityTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_isNullQuantLib" ;;
let _DefaultProbabilityTermStructure_isNull arg = match _DefaultProbabilityTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_asObservableQuantLib" ;;
let _DefaultProbabilityTermStructure_asObservable arg = match _DefaultProbabilityTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityTermStructure_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityTermStructureQuantLib" ;;
let _new_DefaultProbabilityTermStructure arg = match _new_DefaultProbabilityTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DefaultProbabilityTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_DefaultProbabilityTermStructureQuantLib" ;;
let _delete_DefaultProbabilityTermStructure arg = match _delete_DefaultProbabilityTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_dayCounterQuantLib" ;;
let _DefaultProbabilityTermStructure_dayCounter arg = match _DefaultProbabilityTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_calendarQuantLib" ;;
let _DefaultProbabilityTermStructure_calendar arg = match _DefaultProbabilityTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_referenceDateQuantLib" ;;
let _DefaultProbabilityTermStructure_referenceDate arg = match _DefaultProbabilityTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_maxDateQuantLib" ;;
let _DefaultProbabilityTermStructure_maxDate arg = match _DefaultProbabilityTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_maxTimeQuantLib" ;;
let _DefaultProbabilityTermStructure_maxTime arg = match _DefaultProbabilityTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbability__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbability__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbability__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbability__SWIG_3QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbability__SWIG_4QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbability__SWIG_5QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbability__SWIG_6QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultProbabilityQuantLib" ;;
let _DefaultProbabilityTermStructure_defaultProbability arg = match _DefaultProbabilityTermStructure_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_survivalProbability__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructure_survivalProbability arg = match _DefaultProbabilityTermStructure_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_survivalProbability__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructure_survivalProbability arg = match _DefaultProbabilityTermStructure_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_survivalProbability__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructure_survivalProbability arg = match _DefaultProbabilityTermStructure_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_survivalProbabilityQuantLib" ;;
let _DefaultProbabilityTermStructure_survivalProbability arg = match _DefaultProbabilityTermStructure_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultDensity__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultDensity arg = match _DefaultProbabilityTermStructure_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultDensity__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultDensity arg = match _DefaultProbabilityTermStructure_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultDensity__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructure_defaultDensity arg = match _DefaultProbabilityTermStructure_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_defaultDensityQuantLib" ;;
let _DefaultProbabilityTermStructure_defaultDensity arg = match _DefaultProbabilityTermStructure_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_hazardRate__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructure_hazardRate arg = match _DefaultProbabilityTermStructure_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_hazardRate__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructure_hazardRate arg = match _DefaultProbabilityTermStructure_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_hazardRate__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructure_hazardRate arg = match _DefaultProbabilityTermStructure_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_hazardRateQuantLib" ;;
let _DefaultProbabilityTermStructure_hazardRate arg = match _DefaultProbabilityTermStructure_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_enableExtrapolationQuantLib" ;;
let _DefaultProbabilityTermStructure_enableExtrapolation arg = match _DefaultProbabilityTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_disableExtrapolationQuantLib" ;;
let _DefaultProbabilityTermStructure_disableExtrapolation arg = match _DefaultProbabilityTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructure_allowsExtrapolationQuantLib" ;;
let _DefaultProbabilityTermStructure_allowsExtrapolation arg = match _DefaultProbabilityTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityTermStructureHandle__SWIG_0QuantLib" ;;
let _new_DefaultProbabilityTermStructureHandle arg = match _new_DefaultProbabilityTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityTermStructureHandleQuantLib" ;;
let _new_DefaultProbabilityTermStructureHandle arg = match _new_DefaultProbabilityTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle___deref__QuantLib" ;;
let _DefaultProbabilityTermStructureHandle___deref__ arg = match _DefaultProbabilityTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_emptyQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_empty arg = match _DefaultProbabilityTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_asObservableQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_asObservable arg = match _DefaultProbabilityTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DefaultProbabilityTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_DefaultProbabilityTermStructureHandleQuantLib" ;;
let _delete_DefaultProbabilityTermStructureHandle arg = match _delete_DefaultProbabilityTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_dayCounterQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_dayCounter arg = match _DefaultProbabilityTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_calendarQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_calendar arg = match _DefaultProbabilityTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_referenceDateQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_referenceDate arg = match _DefaultProbabilityTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_maxDateQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_maxDate arg = match _DefaultProbabilityTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_maxTimeQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_maxTime arg = match _DefaultProbabilityTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbability__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbability__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbability__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbability__SWIG_3QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbability__SWIG_4QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbability__SWIG_5QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbability__SWIG_6QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultProbabilityQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultProbability arg = match _DefaultProbabilityTermStructureHandle_defaultProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_survivalProbability__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_survivalProbability arg = match _DefaultProbabilityTermStructureHandle_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_survivalProbability__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_survivalProbability arg = match _DefaultProbabilityTermStructureHandle_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_survivalProbability__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_survivalProbability arg = match _DefaultProbabilityTermStructureHandle_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_survivalProbability_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_survivalProbabilityQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_survivalProbability arg = match _DefaultProbabilityTermStructureHandle_survivalProbability_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultDensity__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultDensity arg = match _DefaultProbabilityTermStructureHandle_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultDensity__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultDensity arg = match _DefaultProbabilityTermStructureHandle_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultDensity__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultDensity arg = match _DefaultProbabilityTermStructureHandle_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_defaultDensity_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_defaultDensityQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_defaultDensity arg = match _DefaultProbabilityTermStructureHandle_defaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_hazardRate__SWIG_0QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_hazardRate arg = match _DefaultProbabilityTermStructureHandle_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_hazardRate__SWIG_1QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_hazardRate arg = match _DefaultProbabilityTermStructureHandle_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_hazardRate__SWIG_2QuantLib" ;;
let _DefaultProbabilityTermStructureHandle_hazardRate arg = match _DefaultProbabilityTermStructureHandle_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_hazardRate_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_hazardRateQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_hazardRate arg = match _DefaultProbabilityTermStructureHandle_hazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_enableExtrapolationQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_enableExtrapolation arg = match _DefaultProbabilityTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_disableExtrapolationQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_disableExtrapolation arg = match _DefaultProbabilityTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _DefaultProbabilityTermStructureHandle_allowsExtrapolation arg = match _DefaultProbabilityTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableDefaultProbabilityTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableDefaultProbabilityTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableDefaultProbabilityTermStructureHandle arg = match _new_RelinkableDefaultProbabilityTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableDefaultProbabilityTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableDefaultProbabilityTermStructureHandleQuantLib" ;;
let _new_RelinkableDefaultProbabilityTermStructureHandle arg = match _new_RelinkableDefaultProbabilityTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableDefaultProbabilityTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableDefaultProbabilityTermStructureHandle_linkToQuantLib" ;;
let _RelinkableDefaultProbabilityTermStructureHandle_linkTo arg = match _RelinkableDefaultProbabilityTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableDefaultProbabilityTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableDefaultProbabilityTermStructureHandleQuantLib" ;;
let _delete_RelinkableDefaultProbabilityTermStructureHandle arg = match _delete_RelinkableDefaultProbabilityTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_FlatHazardRate__SWIG_0QuantLib" ;;
let _new_FlatHazardRate arg = match _new_FlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_FlatHazardRateQuantLib" ;;
let _new_FlatHazardRate arg = match _new_FlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FlatHazardRate_f : c_obj list -> c_obj list = "_wrap_delete_FlatHazardRateQuantLib" ;;
let _delete_FlatHazardRate arg = match _delete_FlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HazardRateCurve_f : c_obj list -> c_obj list = "_wrap_new_HazardRateCurve__SWIG_0QuantLib" ;;
let _new_HazardRateCurve arg = match _new_HazardRateCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HazardRateCurve_f : c_obj list -> c_obj list = "_wrap_new_HazardRateCurve__SWIG_1QuantLib" ;;
let _new_HazardRateCurve arg = match _new_HazardRateCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HazardRateCurve_f : c_obj list -> c_obj list = "_wrap_new_HazardRateCurveQuantLib" ;;
let _new_HazardRateCurve arg = match _new_HazardRateCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HazardRateCurve_dates_f : c_obj list -> c_obj list = "_wrap_HazardRateCurve_datesQuantLib" ;;
let _HazardRateCurve_dates arg = match _HazardRateCurve_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HazardRateCurve_hazardRates_f : c_obj list -> c_obj list = "_wrap_HazardRateCurve_hazardRatesQuantLib" ;;
let _HazardRateCurve_hazardRates arg = match _HazardRateCurve_hazardRates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HazardRateCurve_nodes_f : c_obj list -> c_obj list = "_wrap_HazardRateCurve_nodesQuantLib" ;;
let _HazardRateCurve_nodes arg = match _HazardRateCurve_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HazardRateCurve_f : c_obj list -> c_obj list = "_wrap_delete_HazardRateCurveQuantLib" ;;
let _delete_HazardRateCurve arg = match _delete_HazardRateCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultDensityCurve_f : c_obj list -> c_obj list = "_wrap_new_DefaultDensityCurve__SWIG_0QuantLib" ;;
let _new_DefaultDensityCurve arg = match _new_DefaultDensityCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultDensityCurve_f : c_obj list -> c_obj list = "_wrap_new_DefaultDensityCurve__SWIG_1QuantLib" ;;
let _new_DefaultDensityCurve arg = match _new_DefaultDensityCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultDensityCurve_f : c_obj list -> c_obj list = "_wrap_new_DefaultDensityCurveQuantLib" ;;
let _new_DefaultDensityCurve arg = match _new_DefaultDensityCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultDensityCurve_dates_f : c_obj list -> c_obj list = "_wrap_DefaultDensityCurve_datesQuantLib" ;;
let _DefaultDensityCurve_dates arg = match _DefaultDensityCurve_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultDensityCurve_defaultDensities_f : c_obj list -> c_obj list = "_wrap_DefaultDensityCurve_defaultDensitiesQuantLib" ;;
let _DefaultDensityCurve_defaultDensities arg = match _DefaultDensityCurve_defaultDensities_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultDensityCurve_nodes_f : c_obj list -> c_obj list = "_wrap_DefaultDensityCurve_nodesQuantLib" ;;
let _DefaultDensityCurve_nodes arg = match _DefaultDensityCurve_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DefaultDensityCurve_f : c_obj list -> c_obj list = "_wrap_delete_DefaultDensityCurveQuantLib" ;;
let _delete_DefaultDensityCurve arg = match _delete_DefaultDensityCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelper___deref___f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelper___deref__QuantLib" ;;
let _DefaultProbabilityHelper___deref__ arg = match _DefaultProbabilityHelper___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelper_isNull_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelper_isNullQuantLib" ;;
let _DefaultProbabilityHelper_isNull arg = match _DefaultProbabilityHelper_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityHelper_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityHelperQuantLib" ;;
let _new_DefaultProbabilityHelper arg = match _new_DefaultProbabilityHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DefaultProbabilityHelper_f : c_obj list -> c_obj list = "_wrap_delete_DefaultProbabilityHelperQuantLib" ;;
let _delete_DefaultProbabilityHelper arg = match _delete_DefaultProbabilityHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityHelperVector_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityHelperVector__SWIG_0QuantLib" ;;
let _new_DefaultProbabilityHelperVector arg = match _new_DefaultProbabilityHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityHelperVector_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityHelperVector__SWIG_1QuantLib" ;;
let _new_DefaultProbabilityHelperVector arg = match _new_DefaultProbabilityHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityHelperVector_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityHelperVector__SWIG_2QuantLib" ;;
let _new_DefaultProbabilityHelperVector arg = match _new_DefaultProbabilityHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultProbabilityHelperVector_f : c_obj list -> c_obj list = "_wrap_new_DefaultProbabilityHelperVectorQuantLib" ;;
let _new_DefaultProbabilityHelperVector arg = match _new_DefaultProbabilityHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_size_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_sizeQuantLib" ;;
let _DefaultProbabilityHelperVector_size arg = match _DefaultProbabilityHelperVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_empty_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_emptyQuantLib" ;;
let _DefaultProbabilityHelperVector_empty arg = match _DefaultProbabilityHelperVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_clear_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_clearQuantLib" ;;
let _DefaultProbabilityHelperVector_clear arg = match _DefaultProbabilityHelperVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_push_back_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_push_backQuantLib" ;;
let _DefaultProbabilityHelperVector_push_back arg = match _DefaultProbabilityHelperVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_operator_bB___QuantLib" ;;
let _DefaultProbabilityHelperVector_operator_xx_xx_lbrace_xx_rbrace arg = match _DefaultProbabilityHelperVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_operator_e___QuantLib" ;;
let _DefaultProbabilityHelperVector_operator_xx_xx_equals arg = match _DefaultProbabilityHelperVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_set_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_setQuantLib" ;;
let _DefaultProbabilityHelperVector_set arg = match _DefaultProbabilityHelperVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DefaultProbabilityHelperVector_to_array_f : c_obj list -> c_obj list = "_wrap_DefaultProbabilityHelperVector_to_arrayQuantLib" ;;
let _DefaultProbabilityHelperVector_to_array arg = match _DefaultProbabilityHelperVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DefaultProbabilityHelperVector_f : c_obj list -> c_obj list = "_wrap_delete_DefaultProbabilityHelperVectorQuantLib" ;;
let _delete_DefaultProbabilityHelperVector arg = match _delete_DefaultProbabilityHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SpreadCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_SpreadCdsHelper__SWIG_0QuantLib" ;;
let _new_SpreadCdsHelper arg = match _new_SpreadCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SpreadCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_SpreadCdsHelper__SWIG_1QuantLib" ;;
let _new_SpreadCdsHelper arg = match _new_SpreadCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SpreadCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_SpreadCdsHelper__SWIG_2QuantLib" ;;
let _new_SpreadCdsHelper arg = match _new_SpreadCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SpreadCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_SpreadCdsHelper__SWIG_3QuantLib" ;;
let _new_SpreadCdsHelper arg = match _new_SpreadCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SpreadCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_SpreadCdsHelper__SWIG_4QuantLib" ;;
let _new_SpreadCdsHelper arg = match _new_SpreadCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SpreadCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_SpreadCdsHelperQuantLib" ;;
let _new_SpreadCdsHelper arg = match _new_SpreadCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SpreadCdsHelper_f : c_obj list -> c_obj list = "_wrap_delete_SpreadCdsHelperQuantLib" ;;
let _delete_SpreadCdsHelper arg = match _delete_SpreadCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpfrontCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_UpfrontCdsHelper__SWIG_0QuantLib" ;;
let _new_UpfrontCdsHelper arg = match _new_UpfrontCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpfrontCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_UpfrontCdsHelper__SWIG_1QuantLib" ;;
let _new_UpfrontCdsHelper arg = match _new_UpfrontCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpfrontCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_UpfrontCdsHelper__SWIG_2QuantLib" ;;
let _new_UpfrontCdsHelper arg = match _new_UpfrontCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpfrontCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_UpfrontCdsHelper__SWIG_3QuantLib" ;;
let _new_UpfrontCdsHelper arg = match _new_UpfrontCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpfrontCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_UpfrontCdsHelper__SWIG_4QuantLib" ;;
let _new_UpfrontCdsHelper arg = match _new_UpfrontCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UpfrontCdsHelper_f : c_obj list -> c_obj list = "_wrap_new_UpfrontCdsHelperQuantLib" ;;
let _new_UpfrontCdsHelper arg = match _new_UpfrontCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UpfrontCdsHelper_f : c_obj list -> c_obj list = "_wrap_delete_UpfrontCdsHelperQuantLib" ;;
let _delete_UpfrontCdsHelper arg = match _delete_UpfrontCdsHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HazardRate_f : c_obj list -> c_obj list = "_wrap_new_HazardRateQuantLib" ;;
let _new_HazardRate arg = match _new_HazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HazardRate_f : c_obj list -> c_obj list = "_wrap_delete_HazardRateQuantLib" ;;
let _delete_HazardRate arg = match _delete_HazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DefaultDensity_f : c_obj list -> c_obj list = "_wrap_new_DefaultDensityQuantLib" ;;
let _new_DefaultDensity arg = match _new_DefaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DefaultDensity_f : c_obj list -> c_obj list = "_wrap_delete_DefaultDensityQuantLib" ;;
let _delete_DefaultDensity arg = match _delete_DefaultDensity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatHazardRate__SWIG_0QuantLib" ;;
let _new_PiecewiseFlatHazardRate arg = match _new_PiecewiseFlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatHazardRate__SWIG_1QuantLib" ;;
let _new_PiecewiseFlatHazardRate arg = match _new_PiecewiseFlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatHazardRate__SWIG_2QuantLib" ;;
let _new_PiecewiseFlatHazardRate arg = match _new_PiecewiseFlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatHazardRate__SWIG_3QuantLib" ;;
let _new_PiecewiseFlatHazardRate arg = match _new_PiecewiseFlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatHazardRate__SWIG_4QuantLib" ;;
let _new_PiecewiseFlatHazardRate arg = match _new_PiecewiseFlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatHazardRate_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatHazardRateQuantLib" ;;
let _new_PiecewiseFlatHazardRate arg = match _new_PiecewiseFlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatHazardRate_dates_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatHazardRate_datesQuantLib" ;;
let _PiecewiseFlatHazardRate_dates arg = match _PiecewiseFlatHazardRate_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatHazardRate_times_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatHazardRate_timesQuantLib" ;;
let _PiecewiseFlatHazardRate_times arg = match _PiecewiseFlatHazardRate_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatHazardRate_nodes_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatHazardRate_nodesQuantLib" ;;
let _PiecewiseFlatHazardRate_nodes arg = match _PiecewiseFlatHazardRate_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PiecewiseFlatHazardRate_f : c_obj list -> c_obj list = "_wrap_delete_PiecewiseFlatHazardRateQuantLib" ;;
let _delete_PiecewiseFlatHazardRate arg = match _delete_PiecewiseFlatHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Protection::Side_marker" (`Side)
external _Buyer : c_obj -> Swig.c_obj = "_wrap_Buyer" 
external _Seller : c_obj -> Swig.c_obj = "_wrap_Seller" 
external _new_Protection_f : c_obj list -> c_obj list = "_wrap_new_ProtectionQuantLib" ;;
let _new_Protection arg = match _new_Protection_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Protection_f : c_obj list -> c_obj list = "_wrap_delete_ProtectionQuantLib" ;;
let _delete_Protection arg = match _delete_Protection_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CreditDefaultSwap_f : c_obj list -> c_obj list = "_wrap_new_CreditDefaultSwap__SWIG_0QuantLib" ;;
let _new_CreditDefaultSwap arg = match _new_CreditDefaultSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CreditDefaultSwap_f : c_obj list -> c_obj list = "_wrap_new_CreditDefaultSwap__SWIG_1QuantLib" ;;
let _new_CreditDefaultSwap arg = match _new_CreditDefaultSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CreditDefaultSwap_f : c_obj list -> c_obj list = "_wrap_new_CreditDefaultSwap__SWIG_2QuantLib" ;;
let _new_CreditDefaultSwap arg = match _new_CreditDefaultSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CreditDefaultSwap_f : c_obj list -> c_obj list = "_wrap_new_CreditDefaultSwap__SWIG_3QuantLib" ;;
let _new_CreditDefaultSwap arg = match _new_CreditDefaultSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CreditDefaultSwap_f : c_obj list -> c_obj list = "_wrap_new_CreditDefaultSwap__SWIG_4QuantLib" ;;
let _new_CreditDefaultSwap arg = match _new_CreditDefaultSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CreditDefaultSwap_f : c_obj list -> c_obj list = "_wrap_new_CreditDefaultSwapQuantLib" ;;
let _new_CreditDefaultSwap arg = match _new_CreditDefaultSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_side_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_sideQuantLib" ;;
let _CreditDefaultSwap_side arg = match _CreditDefaultSwap_side_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_notional_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_notionalQuantLib" ;;
let _CreditDefaultSwap_notional arg = match _CreditDefaultSwap_notional_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_runningSpread_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_runningSpreadQuantLib" ;;
let _CreditDefaultSwap_runningSpread arg = match _CreditDefaultSwap_runningSpread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_upfront_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_upfrontQuantLib" ;;
let _CreditDefaultSwap_upfront arg = match _CreditDefaultSwap_upfront_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_settlesAccrual_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_settlesAccrualQuantLib" ;;
let _CreditDefaultSwap_settlesAccrual arg = match _CreditDefaultSwap_settlesAccrual_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_paysAtDefaultTime_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_paysAtDefaultTimeQuantLib" ;;
let _CreditDefaultSwap_paysAtDefaultTime arg = match _CreditDefaultSwap_paysAtDefaultTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_fairSpread_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_fairSpreadQuantLib" ;;
let _CreditDefaultSwap_fairSpread arg = match _CreditDefaultSwap_fairSpread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_fairUpfront_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_fairUpfrontQuantLib" ;;
let _CreditDefaultSwap_fairUpfront arg = match _CreditDefaultSwap_fairUpfront_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_couponLegBPS_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_couponLegBPSQuantLib" ;;
let _CreditDefaultSwap_couponLegBPS arg = match _CreditDefaultSwap_couponLegBPS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_couponLegNPV_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_couponLegNPVQuantLib" ;;
let _CreditDefaultSwap_couponLegNPV arg = match _CreditDefaultSwap_couponLegNPV_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_defaultLegNPV_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_defaultLegNPVQuantLib" ;;
let _CreditDefaultSwap_defaultLegNPV arg = match _CreditDefaultSwap_defaultLegNPV_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_upfrontBPS_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_upfrontBPSQuantLib" ;;
let _CreditDefaultSwap_upfrontBPS arg = match _CreditDefaultSwap_upfrontBPS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_upfrontNPV_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_upfrontNPVQuantLib" ;;
let _CreditDefaultSwap_upfrontNPV arg = match _CreditDefaultSwap_upfrontNPV_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_impliedHazardRate_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_impliedHazardRate__SWIG_0QuantLib" ;;
let _CreditDefaultSwap_impliedHazardRate arg = match _CreditDefaultSwap_impliedHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_impliedHazardRate_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_impliedHazardRate__SWIG_1QuantLib" ;;
let _CreditDefaultSwap_impliedHazardRate arg = match _CreditDefaultSwap_impliedHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_impliedHazardRate_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_impliedHazardRateQuantLib" ;;
let _CreditDefaultSwap_impliedHazardRate arg = match _CreditDefaultSwap_impliedHazardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CreditDefaultSwap_coupons_f : c_obj list -> c_obj list = "_wrap_CreditDefaultSwap_couponsQuantLib" ;;
let _CreditDefaultSwap_coupons arg = match _CreditDefaultSwap_coupons_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CreditDefaultSwap_f : c_obj list -> c_obj list = "_wrap_delete_CreditDefaultSwapQuantLib" ;;
let _delete_CreditDefaultSwap arg = match _delete_CreditDefaultSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MidPointCdsEngine_f : c_obj list -> c_obj list = "_wrap_new_MidPointCdsEngineQuantLib" ;;
let _new_MidPointCdsEngine arg = match _new_MidPointCdsEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MidPointCdsEngine_f : c_obj list -> c_obj list = "_wrap_delete_MidPointCdsEngineQuantLib" ;;
let _delete_MidPointCdsEngine arg = match _delete_MidPointCdsEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_new_DiscountCurve__SWIG_0QuantLib" ;;
let _new_DiscountCurve arg = match _new_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_new_DiscountCurve__SWIG_1QuantLib" ;;
let _new_DiscountCurve arg = match _new_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_new_DiscountCurveQuantLib" ;;
let _new_DiscountCurve arg = match _new_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscountCurve_dates_f : c_obj list -> c_obj list = "_wrap_DiscountCurve_datesQuantLib" ;;
let _DiscountCurve_dates arg = match _DiscountCurve_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscountCurve_discounts_f : c_obj list -> c_obj list = "_wrap_DiscountCurve_discountsQuantLib" ;;
let _DiscountCurve_discounts arg = match _DiscountCurve_discounts_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _DiscountCurve_nodes_f : c_obj list -> c_obj list = "_wrap_DiscountCurve_nodesQuantLib" ;;
let _DiscountCurve_nodes arg = match _DiscountCurve_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DiscountCurve_f : c_obj list -> c_obj list = "_wrap_delete_DiscountCurveQuantLib" ;;
let _delete_DiscountCurve arg = match _delete_DiscountCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_NormalDistribution__SWIG_0QuantLib" ;;
let _new_NormalDistribution arg = match _new_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_NormalDistribution__SWIG_1QuantLib" ;;
let _new_NormalDistribution arg = match _new_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_NormalDistributionQuantLib" ;;
let _new_NormalDistribution arg = match _new_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NormalDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_NormalDistribution_operator_pP___QuantLib" ;;
let _NormalDistribution_operator_xx_xx_lparen_xx_rparen arg = match _NormalDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NormalDistribution_derivative_f : c_obj list -> c_obj list = "_wrap_NormalDistribution_derivativeQuantLib" ;;
let _NormalDistribution_derivative arg = match _NormalDistribution_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NormalDistribution_f : c_obj list -> c_obj list = "_wrap_delete_NormalDistributionQuantLib" ;;
let _delete_NormalDistribution arg = match _delete_NormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeNormalDistribution__SWIG_0QuantLib" ;;
let _new_CumulativeNormalDistribution arg = match _new_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeNormalDistribution__SWIG_1QuantLib" ;;
let _new_CumulativeNormalDistribution arg = match _new_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeNormalDistributionQuantLib" ;;
let _new_CumulativeNormalDistribution arg = match _new_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CumulativeNormalDistribution_operator_pP___QuantLib" ;;
let _CumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen arg = match _CumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CumulativeNormalDistribution_derivative_f : c_obj list -> c_obj list = "_wrap_CumulativeNormalDistribution_derivativeQuantLib" ;;
let _CumulativeNormalDistribution_derivative arg = match _CumulativeNormalDistribution_derivative_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_delete_CumulativeNormalDistributionQuantLib" ;;
let _delete_CumulativeNormalDistribution arg = match _delete_CumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeNormal__SWIG_0QuantLib" ;;
let _new_InverseCumulativeNormal arg = match _new_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeNormal__SWIG_1QuantLib" ;;
let _new_InverseCumulativeNormal arg = match _new_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeNormalQuantLib" ;;
let _new_InverseCumulativeNormal arg = match _new_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_InverseCumulativeNormal_operator_pP___QuantLib" ;;
let _InverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen arg = match _InverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_delete_InverseCumulativeNormalQuantLib" ;;
let _delete_InverseCumulativeNormal arg = match _delete_InverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_MoroInverseCumulativeNormal__SWIG_0QuantLib" ;;
let _new_MoroInverseCumulativeNormal arg = match _new_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_MoroInverseCumulativeNormal__SWIG_1QuantLib" ;;
let _new_MoroInverseCumulativeNormal arg = match _new_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_new_MoroInverseCumulativeNormalQuantLib" ;;
let _new_MoroInverseCumulativeNormal arg = match _new_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_MoroInverseCumulativeNormal_operator_pP___QuantLib" ;;
let _MoroInverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen arg = match _MoroInverseCumulativeNormal_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInverseCumulativeNormal_f : c_obj list -> c_obj list = "_wrap_delete_MoroInverseCumulativeNormalQuantLib" ;;
let _delete_MoroInverseCumulativeNormal arg = match _delete_MoroInverseCumulativeNormal_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BivariateCumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_new_BivariateCumulativeNormalDistributionQuantLib" ;;
let _new_BivariateCumulativeNormalDistribution arg = match _new_BivariateCumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BivariateCumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BivariateCumulativeNormalDistribution_operator_pP___QuantLib" ;;
let _BivariateCumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen arg = match _BivariateCumulativeNormalDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BivariateCumulativeNormalDistribution_f : c_obj list -> c_obj list = "_wrap_delete_BivariateCumulativeNormalDistributionQuantLib" ;;
let _delete_BivariateCumulativeNormalDistribution arg = match _delete_BivariateCumulativeNormalDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BinomialDistribution_f : c_obj list -> c_obj list = "_wrap_new_BinomialDistributionQuantLib" ;;
let _new_BinomialDistribution arg = match _new_BinomialDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BinomialDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BinomialDistribution_operator_pP___QuantLib" ;;
let _BinomialDistribution_operator_xx_xx_lparen_xx_rparen arg = match _BinomialDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BinomialDistribution_f : c_obj list -> c_obj list = "_wrap_delete_BinomialDistributionQuantLib" ;;
let _delete_BinomialDistribution arg = match _delete_BinomialDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeBinomialDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeBinomialDistributionQuantLib" ;;
let _new_CumulativeBinomialDistribution arg = match _new_CumulativeBinomialDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CumulativeBinomialDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CumulativeBinomialDistribution_operator_pP___QuantLib" ;;
let _CumulativeBinomialDistribution_operator_xx_xx_lparen_xx_rparen arg = match _CumulativeBinomialDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CumulativeBinomialDistribution_f : c_obj list -> c_obj list = "_wrap_delete_CumulativeBinomialDistributionQuantLib" ;;
let _delete_CumulativeBinomialDistribution arg = match _delete_CumulativeBinomialDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BivariateCumulativeNormalDistributionDr78_f : c_obj list -> c_obj list = "_wrap_new_BivariateCumulativeNormalDistributionDr78QuantLib" ;;
let _new_BivariateCumulativeNormalDistributionDr78 arg = match _new_BivariateCumulativeNormalDistributionDr78_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BivariateCumulativeNormalDistributionDr78_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BivariateCumulativeNormalDistributionDr78_operator_pP___QuantLib" ;;
let _BivariateCumulativeNormalDistributionDr78_operator_xx_xx_lparen_xx_rparen arg = match _BivariateCumulativeNormalDistributionDr78_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BivariateCumulativeNormalDistributionDr78_f : c_obj list -> c_obj list = "_wrap_delete_BivariateCumulativeNormalDistributionDr78QuantLib" ;;
let _delete_BivariateCumulativeNormalDistributionDr78 arg = match _delete_BivariateCumulativeNormalDistributionDr78_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BivariateCumulativeNormalDistributionWe04DP_f : c_obj list -> c_obj list = "_wrap_new_BivariateCumulativeNormalDistributionWe04DPQuantLib" ;;
let _new_BivariateCumulativeNormalDistributionWe04DP arg = match _new_BivariateCumulativeNormalDistributionWe04DP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BivariateCumulativeNormalDistributionWe04DP_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_BivariateCumulativeNormalDistributionWe04DP_operator_pP___QuantLib" ;;
let _BivariateCumulativeNormalDistributionWe04DP_operator_xx_xx_lparen_xx_rparen arg = match _BivariateCumulativeNormalDistributionWe04DP_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BivariateCumulativeNormalDistributionWe04DP_f : c_obj list -> c_obj list = "_wrap_delete_BivariateCumulativeNormalDistributionWe04DPQuantLib" ;;
let _delete_BivariateCumulativeNormalDistributionWe04DP arg = match _delete_BivariateCumulativeNormalDistributionWe04DP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_new_ChiSquareDistributionQuantLib" ;;
let _new_ChiSquareDistribution arg = match _new_ChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ChiSquareDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_ChiSquareDistribution_operator_pP___QuantLib" ;;
let _ChiSquareDistribution_operator_xx_xx_lparen_xx_rparen arg = match _ChiSquareDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_delete_ChiSquareDistributionQuantLib" ;;
let _delete_ChiSquareDistribution arg = match _delete_ChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NonCentralChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_new_NonCentralChiSquareDistributionQuantLib" ;;
let _new_NonCentralChiSquareDistribution arg = match _new_NonCentralChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _NonCentralChiSquareDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_NonCentralChiSquareDistribution_operator_pP___QuantLib" ;;
let _NonCentralChiSquareDistribution_operator_xx_xx_lparen_xx_rparen arg = match _NonCentralChiSquareDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NonCentralChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_delete_NonCentralChiSquareDistributionQuantLib" ;;
let _delete_NonCentralChiSquareDistribution arg = match _delete_NonCentralChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseNonCentralChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_new_InverseNonCentralChiSquareDistribution__SWIG_0QuantLib" ;;
let _new_InverseNonCentralChiSquareDistribution arg = match _new_InverseNonCentralChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseNonCentralChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_new_InverseNonCentralChiSquareDistribution__SWIG_1QuantLib" ;;
let _new_InverseNonCentralChiSquareDistribution arg = match _new_InverseNonCentralChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseNonCentralChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_new_InverseNonCentralChiSquareDistributionQuantLib" ;;
let _new_InverseNonCentralChiSquareDistribution arg = match _new_InverseNonCentralChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InverseNonCentralChiSquareDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_InverseNonCentralChiSquareDistribution_operator_pP___QuantLib" ;;
let _InverseNonCentralChiSquareDistribution_operator_xx_xx_lparen_xx_rparen arg = match _InverseNonCentralChiSquareDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InverseNonCentralChiSquareDistribution_f : c_obj list -> c_obj list = "_wrap_delete_InverseNonCentralChiSquareDistributionQuantLib" ;;
let _delete_InverseNonCentralChiSquareDistribution arg = match _delete_InverseNonCentralChiSquareDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GammaDistribution_f : c_obj list -> c_obj list = "_wrap_new_GammaDistributionQuantLib" ;;
let _new_GammaDistribution arg = match _new_GammaDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GammaDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_GammaDistribution_operator_pP___QuantLib" ;;
let _GammaDistribution_operator_xx_xx_lparen_xx_rparen arg = match _GammaDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GammaDistribution_f : c_obj list -> c_obj list = "_wrap_delete_GammaDistributionQuantLib" ;;
let _delete_GammaDistribution arg = match _delete_GammaDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GammaFunction_logValue_f : c_obj list -> c_obj list = "_wrap_GammaFunction_logValueQuantLib" ;;
let _GammaFunction_logValue arg = match _GammaFunction_logValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GammaFunction_f : c_obj list -> c_obj list = "_wrap_new_GammaFunctionQuantLib" ;;
let _new_GammaFunction arg = match _new_GammaFunction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GammaFunction_f : c_obj list -> c_obj list = "_wrap_delete_GammaFunctionQuantLib" ;;
let _delete_GammaFunction arg = match _delete_GammaFunction_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PoissonDistribution_f : c_obj list -> c_obj list = "_wrap_new_PoissonDistributionQuantLib" ;;
let _new_PoissonDistribution arg = match _new_PoissonDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PoissonDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_PoissonDistribution_operator_pP___QuantLib" ;;
let _PoissonDistribution_operator_xx_xx_lparen_xx_rparen arg = match _PoissonDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PoissonDistribution_f : c_obj list -> c_obj list = "_wrap_delete_PoissonDistributionQuantLib" ;;
let _delete_PoissonDistribution arg = match _delete_PoissonDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativePoissonDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativePoissonDistributionQuantLib" ;;
let _new_CumulativePoissonDistribution arg = match _new_CumulativePoissonDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CumulativePoissonDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CumulativePoissonDistribution_operator_pP___QuantLib" ;;
let _CumulativePoissonDistribution_operator_xx_xx_lparen_xx_rparen arg = match _CumulativePoissonDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CumulativePoissonDistribution_f : c_obj list -> c_obj list = "_wrap_delete_CumulativePoissonDistributionQuantLib" ;;
let _delete_CumulativePoissonDistribution arg = match _delete_CumulativePoissonDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativePoisson_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativePoissonQuantLib" ;;
let _new_InverseCumulativePoisson arg = match _new_InverseCumulativePoisson_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InverseCumulativePoisson_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_InverseCumulativePoisson_operator_pP___QuantLib" ;;
let _InverseCumulativePoisson_operator_xx_xx_lparen_xx_rparen arg = match _InverseCumulativePoisson_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InverseCumulativePoisson_f : c_obj list -> c_obj list = "_wrap_delete_InverseCumulativePoissonQuantLib" ;;
let _delete_InverseCumulativePoisson arg = match _delete_InverseCumulativePoisson_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_StudentDistribution_f : c_obj list -> c_obj list = "_wrap_new_StudentDistributionQuantLib" ;;
let _new_StudentDistribution arg = match _new_StudentDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _StudentDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_StudentDistribution_operator_pP___QuantLib" ;;
let _StudentDistribution_operator_xx_xx_lparen_xx_rparen arg = match _StudentDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_StudentDistribution_f : c_obj list -> c_obj list = "_wrap_delete_StudentDistributionQuantLib" ;;
let _delete_StudentDistribution arg = match _delete_StudentDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CumulativeStudentDistribution_f : c_obj list -> c_obj list = "_wrap_new_CumulativeStudentDistributionQuantLib" ;;
let _new_CumulativeStudentDistribution arg = match _new_CumulativeStudentDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CumulativeStudentDistribution_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_CumulativeStudentDistribution_operator_pP___QuantLib" ;;
let _CumulativeStudentDistribution_operator_xx_xx_lparen_xx_rparen arg = match _CumulativeStudentDistribution_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CumulativeStudentDistribution_f : c_obj list -> c_obj list = "_wrap_delete_CumulativeStudentDistributionQuantLib" ;;
let _delete_CumulativeStudentDistribution arg = match _delete_CumulativeStudentDistribution_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeStudent_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeStudent__SWIG_0QuantLib" ;;
let _new_InverseCumulativeStudent arg = match _new_InverseCumulativeStudent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeStudent_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeStudent__SWIG_1QuantLib" ;;
let _new_InverseCumulativeStudent arg = match _new_InverseCumulativeStudent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InverseCumulativeStudent_f : c_obj list -> c_obj list = "_wrap_new_InverseCumulativeStudentQuantLib" ;;
let _new_InverseCumulativeStudent arg = match _new_InverseCumulativeStudent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InverseCumulativeStudent_operator_xx_xx_lparen_xx_rparen_f : c_obj list -> c_obj list = "_wrap_InverseCumulativeStudent_operator_pP___QuantLib" ;;
let _InverseCumulativeStudent_operator_xx_xx_lparen_xx_rparen arg = match _InverseCumulativeStudent_operator_xx_xx_lparen_xx_rparen_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InverseCumulativeStudent_f : c_obj list -> c_obj list = "_wrap_delete_InverseCumulativeStudentQuantLib" ;;
let _delete_InverseCumulativeStudent arg = match _delete_InverseCumulativeStudent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Money_f : c_obj list -> c_obj list = "_wrap_new_Money__SWIG_0QuantLib" ;;
let _new_Money arg = match _new_Money_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Money_f : c_obj list -> c_obj list = "_wrap_new_MoneyQuantLib" ;;
let _new_Money arg = match _new_Money_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_currency_f : c_obj list -> c_obj list = "_wrap_Money_currencyQuantLib" ;;
let _Money_currency arg = match _Money_currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_value_f : c_obj list -> c_obj list = "_wrap_Money_valueQuantLib" ;;
let _Money_value arg = match _Money_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_rounded_f : c_obj list -> c_obj list = "_wrap_Money_roundedQuantLib" ;;
let _Money_rounded arg = match _Money_rounded_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "Money::ConversionType_marker" (`ConversionType)
external _NoConversion : c_obj -> Swig.c_obj = "_wrap_NoConversion" 
external _BaseCurrencyConversion : c_obj -> Swig.c_obj = "_wrap_BaseCurrencyConversion" 
external _AutomatedConversion : c_obj -> Swig.c_obj = "_wrap_AutomatedConversion" 
external _Money_setConversionType_f : c_obj list -> c_obj list = "_wrap_Money_setConversionTypeQuantLib" ;;
let _Money_setConversionType arg = match _Money_setConversionType_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Money_setBaseCurrency_f : c_obj list -> c_obj list = "_wrap_Money_setBaseCurrencyQuantLib" ;;
let _Money_setBaseCurrency arg = match _Money_setBaseCurrency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Money_f : c_obj list -> c_obj list = "_wrap_delete_MoneyQuantLib" ;;
let _delete_Money arg = match _delete_Money_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
let _ = Callback.register "ExchangeRate::Type_marker" (`Type)
external _Direct : c_obj -> Swig.c_obj = "_wrap_Direct" 
external _Derived : c_obj -> Swig.c_obj = "_wrap_Derived" 
external _new_ExchangeRate_f : c_obj list -> c_obj list = "_wrap_new_ExchangeRateQuantLib" ;;
let _new_ExchangeRate arg = match _new_ExchangeRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_source_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_sourceQuantLib" ;;
let _ExchangeRate_source arg = match _ExchangeRate_source_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_target_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_targetQuantLib" ;;
let _ExchangeRate_target arg = match _ExchangeRate_target_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_type_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_typeQuantLib" ;;
let _ExchangeRate_type arg = match _ExchangeRate_type_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_rate_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_rateQuantLib" ;;
let _ExchangeRate_rate arg = match _ExchangeRate_rate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_exchange_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_exchangeQuantLib" ;;
let _ExchangeRate_exchange arg = match _ExchangeRate_exchange_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRate_chain_f : c_obj list -> c_obj list = "_wrap_ExchangeRate_chainQuantLib" ;;
let _ExchangeRate_chain arg = match _ExchangeRate_chain_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ExchangeRate_f : c_obj list -> c_obj list = "_wrap_delete_ExchangeRateQuantLib" ;;
let _delete_ExchangeRate arg = match _delete_ExchangeRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_instance_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_instanceQuantLib" ;;
let _ExchangeRateManager_instance arg = match _ExchangeRateManager_instance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_add_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_add__SWIG_0QuantLib" ;;
let _ExchangeRateManager_add arg = match _ExchangeRateManager_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_add_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_add__SWIG_1QuantLib" ;;
let _ExchangeRateManager_add arg = match _ExchangeRateManager_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_add_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_addQuantLib" ;;
let _ExchangeRateManager_add arg = match _ExchangeRateManager_add_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_lookup_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_lookup__SWIG_0QuantLib" ;;
let _ExchangeRateManager_lookup arg = match _ExchangeRateManager_lookup_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_lookup_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_lookupQuantLib" ;;
let _ExchangeRateManager_lookup arg = match _ExchangeRateManager_lookup_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ExchangeRateManager_clear_f : c_obj list -> c_obj list = "_wrap_ExchangeRateManager_clearQuantLib" ;;
let _ExchangeRateManager_clear arg = match _ExchangeRateManager_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ExchangeRateManager_f : c_obj list -> c_obj list = "_wrap_delete_ExchangeRateManagerQuantLib" ;;
let _delete_ExchangeRateManager arg = match _delete_ExchangeRateManager_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardCurve_f : c_obj list -> c_obj list = "_wrap_new_ForwardCurve__SWIG_0QuantLib" ;;
let _new_ForwardCurve arg = match _new_ForwardCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardCurve_f : c_obj list -> c_obj list = "_wrap_new_ForwardCurve__SWIG_1QuantLib" ;;
let _new_ForwardCurve arg = match _new_ForwardCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardCurve_f : c_obj list -> c_obj list = "_wrap_new_ForwardCurveQuantLib" ;;
let _new_ForwardCurve arg = match _new_ForwardCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardCurve_dates_f : c_obj list -> c_obj list = "_wrap_ForwardCurve_datesQuantLib" ;;
let _ForwardCurve_dates arg = match _ForwardCurve_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardCurve_forwards_f : c_obj list -> c_obj list = "_wrap_ForwardCurve_forwardsQuantLib" ;;
let _ForwardCurve_forwards arg = match _ForwardCurve_forwards_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ForwardCurve_nodes_f : c_obj list -> c_obj list = "_wrap_ForwardCurve_nodesQuantLib" ;;
let _ForwardCurve_nodes arg = match _ForwardCurve_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardCurve_f : c_obj list -> c_obj list = "_wrap_delete_ForwardCurveQuantLib" ;;
let _delete_ForwardCurve arg = match _delete_ForwardCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGrid__SWIG_0QuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGrid__SWIG_1QuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGrid__SWIG_2QuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeGrid_f : c_obj list -> c_obj list = "_wrap_new_TimeGridQuantLib" ;;
let _new_TimeGrid arg = match _new_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TimeGrid_size_f : c_obj list -> c_obj list = "_wrap_TimeGrid_sizeQuantLib" ;;
let _TimeGrid_size arg = match _TimeGrid_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TimeGrid_f : c_obj list -> c_obj list = "_wrap_delete_TimeGridQuantLib" ;;
let _delete_TimeGrid arg = match _delete_TimeGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Seasonality___deref___f : c_obj list -> c_obj list = "_wrap_Seasonality___deref__QuantLib" ;;
let _Seasonality___deref__ arg = match _Seasonality___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Seasonality_isNull_f : c_obj list -> c_obj list = "_wrap_Seasonality_isNullQuantLib" ;;
let _Seasonality_isNull arg = match _Seasonality_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Seasonality_f : c_obj list -> c_obj list = "_wrap_new_SeasonalityQuantLib" ;;
let _new_Seasonality arg = match _new_Seasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Seasonality_f : c_obj list -> c_obj list = "_wrap_delete_SeasonalityQuantLib" ;;
let _delete_Seasonality arg = match _delete_Seasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Seasonality_correctZeroRate_f : c_obj list -> c_obj list = "_wrap_Seasonality_correctZeroRateQuantLib" ;;
let _Seasonality_correctZeroRate arg = match _Seasonality_correctZeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Seasonality_correctYoYRate_f : c_obj list -> c_obj list = "_wrap_Seasonality_correctYoYRateQuantLib" ;;
let _Seasonality_correctYoYRate arg = match _Seasonality_correctYoYRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Seasonality_isConsistent_f : c_obj list -> c_obj list = "_wrap_Seasonality_isConsistentQuantLib" ;;
let _Seasonality_isConsistent arg = match _Seasonality_isConsistent_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MultiplicativePriceSeasonalityPtr_f : c_obj list -> c_obj list = "_wrap_new_MultiplicativePriceSeasonalityPtrQuantLib" ;;
let _new_MultiplicativePriceSeasonalityPtr arg = match _new_MultiplicativePriceSeasonalityPtr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MultiplicativePriceSeasonalityPtr_f : c_obj list -> c_obj list = "_wrap_delete_MultiplicativePriceSeasonalityPtrQuantLib" ;;
let _delete_MultiplicativePriceSeasonalityPtr arg = match _delete_MultiplicativePriceSeasonalityPtr_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure___deref__QuantLib" ;;
let _YoYInflationTermStructure___deref__ arg = match _YoYInflationTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_isNullQuantLib" ;;
let _YoYInflationTermStructure_isNull arg = match _YoYInflationTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_asObservableQuantLib" ;;
let _YoYInflationTermStructure_asObservable arg = match _YoYInflationTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYInflationTermStructure_f : c_obj list -> c_obj list = "_wrap_new_YoYInflationTermStructureQuantLib" ;;
let _new_YoYInflationTermStructure arg = match _new_YoYInflationTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYInflationTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_YoYInflationTermStructureQuantLib" ;;
let _delete_YoYInflationTermStructure arg = match _delete_YoYInflationTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_yoyRate__SWIG_0QuantLib" ;;
let _YoYInflationTermStructure_yoyRate arg = match _YoYInflationTermStructure_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_yoyRate__SWIG_1QuantLib" ;;
let _YoYInflationTermStructure_yoyRate arg = match _YoYInflationTermStructure_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_yoyRate__SWIG_2QuantLib" ;;
let _YoYInflationTermStructure_yoyRate arg = match _YoYInflationTermStructure_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_yoyRateQuantLib" ;;
let _YoYInflationTermStructure_yoyRate arg = match _YoYInflationTermStructure_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_dayCounterQuantLib" ;;
let _YoYInflationTermStructure_dayCounter arg = match _YoYInflationTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_calendarQuantLib" ;;
let _YoYInflationTermStructure_calendar arg = match _YoYInflationTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_referenceDateQuantLib" ;;
let _YoYInflationTermStructure_referenceDate arg = match _YoYInflationTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_maxDateQuantLib" ;;
let _YoYInflationTermStructure_maxDate arg = match _YoYInflationTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_maxTimeQuantLib" ;;
let _YoYInflationTermStructure_maxTime arg = match _YoYInflationTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_observationLag_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_observationLagQuantLib" ;;
let _YoYInflationTermStructure_observationLag arg = match _YoYInflationTermStructure_observationLag_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_frequency_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_frequencyQuantLib" ;;
let _YoYInflationTermStructure_frequency arg = match _YoYInflationTermStructure_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_indexIsInterpolated_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_indexIsInterpolatedQuantLib" ;;
let _YoYInflationTermStructure_indexIsInterpolated arg = match _YoYInflationTermStructure_indexIsInterpolated_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_baseRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_baseRateQuantLib" ;;
let _YoYInflationTermStructure_baseRate arg = match _YoYInflationTermStructure_baseRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_nominalTermStructure_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_nominalTermStructureQuantLib" ;;
let _YoYInflationTermStructure_nominalTermStructure arg = match _YoYInflationTermStructure_nominalTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_baseDate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_baseDateQuantLib" ;;
let _YoYInflationTermStructure_baseDate arg = match _YoYInflationTermStructure_baseDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_setSeasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_setSeasonality__SWIG_0QuantLib" ;;
let _YoYInflationTermStructure_setSeasonality arg = match _YoYInflationTermStructure_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_setSeasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_setSeasonalityQuantLib" ;;
let _YoYInflationTermStructure_setSeasonality arg = match _YoYInflationTermStructure_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_seasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_seasonalityQuantLib" ;;
let _YoYInflationTermStructure_seasonality arg = match _YoYInflationTermStructure_seasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_hasSeasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_hasSeasonalityQuantLib" ;;
let _YoYInflationTermStructure_hasSeasonality arg = match _YoYInflationTermStructure_hasSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_enableExtrapolationQuantLib" ;;
let _YoYInflationTermStructure_enableExtrapolation arg = match _YoYInflationTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_disableExtrapolationQuantLib" ;;
let _YoYInflationTermStructure_disableExtrapolation arg = match _YoYInflationTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructure_allowsExtrapolationQuantLib" ;;
let _YoYInflationTermStructure_allowsExtrapolation arg = match _YoYInflationTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_YoYInflationTermStructureHandle__SWIG_0QuantLib" ;;
let _new_YoYInflationTermStructureHandle arg = match _new_YoYInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_YoYInflationTermStructureHandleQuantLib" ;;
let _new_YoYInflationTermStructureHandle arg = match _new_YoYInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle___deref__QuantLib" ;;
let _YoYInflationTermStructureHandle___deref__ arg = match _YoYInflationTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_emptyQuantLib" ;;
let _YoYInflationTermStructureHandle_empty arg = match _YoYInflationTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_asObservableQuantLib" ;;
let _YoYInflationTermStructureHandle_asObservable arg = match _YoYInflationTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_YoYInflationTermStructureHandleQuantLib" ;;
let _delete_YoYInflationTermStructureHandle arg = match _delete_YoYInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_yoyRate__SWIG_0QuantLib" ;;
let _YoYInflationTermStructureHandle_yoyRate arg = match _YoYInflationTermStructureHandle_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_yoyRate__SWIG_1QuantLib" ;;
let _YoYInflationTermStructureHandle_yoyRate arg = match _YoYInflationTermStructureHandle_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_yoyRate__SWIG_2QuantLib" ;;
let _YoYInflationTermStructureHandle_yoyRate arg = match _YoYInflationTermStructureHandle_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_yoyRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_yoyRateQuantLib" ;;
let _YoYInflationTermStructureHandle_yoyRate arg = match _YoYInflationTermStructureHandle_yoyRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_dayCounterQuantLib" ;;
let _YoYInflationTermStructureHandle_dayCounter arg = match _YoYInflationTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_calendarQuantLib" ;;
let _YoYInflationTermStructureHandle_calendar arg = match _YoYInflationTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_referenceDateQuantLib" ;;
let _YoYInflationTermStructureHandle_referenceDate arg = match _YoYInflationTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_maxDateQuantLib" ;;
let _YoYInflationTermStructureHandle_maxDate arg = match _YoYInflationTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_maxTimeQuantLib" ;;
let _YoYInflationTermStructureHandle_maxTime arg = match _YoYInflationTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_observationLag_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_observationLagQuantLib" ;;
let _YoYInflationTermStructureHandle_observationLag arg = match _YoYInflationTermStructureHandle_observationLag_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_frequency_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_frequencyQuantLib" ;;
let _YoYInflationTermStructureHandle_frequency arg = match _YoYInflationTermStructureHandle_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_indexIsInterpolated_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_indexIsInterpolatedQuantLib" ;;
let _YoYInflationTermStructureHandle_indexIsInterpolated arg = match _YoYInflationTermStructureHandle_indexIsInterpolated_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_baseRate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_baseRateQuantLib" ;;
let _YoYInflationTermStructureHandle_baseRate arg = match _YoYInflationTermStructureHandle_baseRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_nominalTermStructure_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_nominalTermStructureQuantLib" ;;
let _YoYInflationTermStructureHandle_nominalTermStructure arg = match _YoYInflationTermStructureHandle_nominalTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_baseDate_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_baseDateQuantLib" ;;
let _YoYInflationTermStructureHandle_baseDate arg = match _YoYInflationTermStructureHandle_baseDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_setSeasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_setSeasonality__SWIG_0QuantLib" ;;
let _YoYInflationTermStructureHandle_setSeasonality arg = match _YoYInflationTermStructureHandle_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_setSeasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_setSeasonalityQuantLib" ;;
let _YoYInflationTermStructureHandle_setSeasonality arg = match _YoYInflationTermStructureHandle_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_seasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_seasonalityQuantLib" ;;
let _YoYInflationTermStructureHandle_seasonality arg = match _YoYInflationTermStructureHandle_seasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_hasSeasonality_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_hasSeasonalityQuantLib" ;;
let _YoYInflationTermStructureHandle_hasSeasonality arg = match _YoYInflationTermStructureHandle_hasSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_enableExtrapolationQuantLib" ;;
let _YoYInflationTermStructureHandle_enableExtrapolation arg = match _YoYInflationTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_disableExtrapolationQuantLib" ;;
let _YoYInflationTermStructureHandle_disableExtrapolation arg = match _YoYInflationTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_YoYInflationTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _YoYInflationTermStructureHandle_allowsExtrapolation arg = match _YoYInflationTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableYoYInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableYoYInflationTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableYoYInflationTermStructureHandle arg = match _new_RelinkableYoYInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableYoYInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableYoYInflationTermStructureHandleQuantLib" ;;
let _new_RelinkableYoYInflationTermStructureHandle arg = match _new_RelinkableYoYInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableYoYInflationTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableYoYInflationTermStructureHandle_linkToQuantLib" ;;
let _RelinkableYoYInflationTermStructureHandle_linkTo arg = match _RelinkableYoYInflationTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableYoYInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableYoYInflationTermStructureHandleQuantLib" ;;
let _delete_RelinkableYoYInflationTermStructureHandle arg = match _delete_RelinkableYoYInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure___deref___f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure___deref__QuantLib" ;;
let _ZeroInflationTermStructure___deref__ arg = match _ZeroInflationTermStructure___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_isNull_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_isNullQuantLib" ;;
let _ZeroInflationTermStructure_isNull arg = match _ZeroInflationTermStructure_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_asObservable_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_asObservableQuantLib" ;;
let _ZeroInflationTermStructure_asObservable arg = match _ZeroInflationTermStructure_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroInflationTermStructure_f : c_obj list -> c_obj list = "_wrap_new_ZeroInflationTermStructureQuantLib" ;;
let _new_ZeroInflationTermStructure arg = match _new_ZeroInflationTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroInflationTermStructure_f : c_obj list -> c_obj list = "_wrap_delete_ZeroInflationTermStructureQuantLib" ;;
let _delete_ZeroInflationTermStructure arg = match _delete_ZeroInflationTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_zeroRate__SWIG_0QuantLib" ;;
let _ZeroInflationTermStructure_zeroRate arg = match _ZeroInflationTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_zeroRate__SWIG_1QuantLib" ;;
let _ZeroInflationTermStructure_zeroRate arg = match _ZeroInflationTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_zeroRate__SWIG_2QuantLib" ;;
let _ZeroInflationTermStructure_zeroRate arg = match _ZeroInflationTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_zeroRateQuantLib" ;;
let _ZeroInflationTermStructure_zeroRate arg = match _ZeroInflationTermStructure_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_dayCounter_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_dayCounterQuantLib" ;;
let _ZeroInflationTermStructure_dayCounter arg = match _ZeroInflationTermStructure_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_calendar_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_calendarQuantLib" ;;
let _ZeroInflationTermStructure_calendar arg = match _ZeroInflationTermStructure_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_referenceDate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_referenceDateQuantLib" ;;
let _ZeroInflationTermStructure_referenceDate arg = match _ZeroInflationTermStructure_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_maxDate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_maxDateQuantLib" ;;
let _ZeroInflationTermStructure_maxDate arg = match _ZeroInflationTermStructure_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_maxTime_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_maxTimeQuantLib" ;;
let _ZeroInflationTermStructure_maxTime arg = match _ZeroInflationTermStructure_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_observationLag_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_observationLagQuantLib" ;;
let _ZeroInflationTermStructure_observationLag arg = match _ZeroInflationTermStructure_observationLag_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_frequency_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_frequencyQuantLib" ;;
let _ZeroInflationTermStructure_frequency arg = match _ZeroInflationTermStructure_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_indexIsInterpolated_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_indexIsInterpolatedQuantLib" ;;
let _ZeroInflationTermStructure_indexIsInterpolated arg = match _ZeroInflationTermStructure_indexIsInterpolated_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_baseRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_baseRateQuantLib" ;;
let _ZeroInflationTermStructure_baseRate arg = match _ZeroInflationTermStructure_baseRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_nominalTermStructure_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_nominalTermStructureQuantLib" ;;
let _ZeroInflationTermStructure_nominalTermStructure arg = match _ZeroInflationTermStructure_nominalTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_baseDate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_baseDateQuantLib" ;;
let _ZeroInflationTermStructure_baseDate arg = match _ZeroInflationTermStructure_baseDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_setSeasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_setSeasonality__SWIG_0QuantLib" ;;
let _ZeroInflationTermStructure_setSeasonality arg = match _ZeroInflationTermStructure_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_setSeasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_setSeasonalityQuantLib" ;;
let _ZeroInflationTermStructure_setSeasonality arg = match _ZeroInflationTermStructure_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_seasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_seasonalityQuantLib" ;;
let _ZeroInflationTermStructure_seasonality arg = match _ZeroInflationTermStructure_seasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_hasSeasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_hasSeasonalityQuantLib" ;;
let _ZeroInflationTermStructure_hasSeasonality arg = match _ZeroInflationTermStructure_hasSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_enableExtrapolationQuantLib" ;;
let _ZeroInflationTermStructure_enableExtrapolation arg = match _ZeroInflationTermStructure_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_disableExtrapolationQuantLib" ;;
let _ZeroInflationTermStructure_disableExtrapolation arg = match _ZeroInflationTermStructure_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructure_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructure_allowsExtrapolationQuantLib" ;;
let _ZeroInflationTermStructure_allowsExtrapolation arg = match _ZeroInflationTermStructure_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_ZeroInflationTermStructureHandle__SWIG_0QuantLib" ;;
let _new_ZeroInflationTermStructureHandle arg = match _new_ZeroInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_ZeroInflationTermStructureHandleQuantLib" ;;
let _new_ZeroInflationTermStructureHandle arg = match _new_ZeroInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle___deref___f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle___deref__QuantLib" ;;
let _ZeroInflationTermStructureHandle___deref__ arg = match _ZeroInflationTermStructureHandle___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_empty_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_emptyQuantLib" ;;
let _ZeroInflationTermStructureHandle_empty arg = match _ZeroInflationTermStructureHandle_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_asObservable_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_asObservableQuantLib" ;;
let _ZeroInflationTermStructureHandle_asObservable arg = match _ZeroInflationTermStructureHandle_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_ZeroInflationTermStructureHandleQuantLib" ;;
let _delete_ZeroInflationTermStructureHandle arg = match _delete_ZeroInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_zeroRate__SWIG_0QuantLib" ;;
let _ZeroInflationTermStructureHandle_zeroRate arg = match _ZeroInflationTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_zeroRate__SWIG_1QuantLib" ;;
let _ZeroInflationTermStructureHandle_zeroRate arg = match _ZeroInflationTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_zeroRate__SWIG_2QuantLib" ;;
let _ZeroInflationTermStructureHandle_zeroRate arg = match _ZeroInflationTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_zeroRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_zeroRateQuantLib" ;;
let _ZeroInflationTermStructureHandle_zeroRate arg = match _ZeroInflationTermStructureHandle_zeroRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_dayCounter_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_dayCounterQuantLib" ;;
let _ZeroInflationTermStructureHandle_dayCounter arg = match _ZeroInflationTermStructureHandle_dayCounter_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_calendar_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_calendarQuantLib" ;;
let _ZeroInflationTermStructureHandle_calendar arg = match _ZeroInflationTermStructureHandle_calendar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_referenceDate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_referenceDateQuantLib" ;;
let _ZeroInflationTermStructureHandle_referenceDate arg = match _ZeroInflationTermStructureHandle_referenceDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_maxDate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_maxDateQuantLib" ;;
let _ZeroInflationTermStructureHandle_maxDate arg = match _ZeroInflationTermStructureHandle_maxDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_maxTime_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_maxTimeQuantLib" ;;
let _ZeroInflationTermStructureHandle_maxTime arg = match _ZeroInflationTermStructureHandle_maxTime_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_observationLag_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_observationLagQuantLib" ;;
let _ZeroInflationTermStructureHandle_observationLag arg = match _ZeroInflationTermStructureHandle_observationLag_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_frequency_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_frequencyQuantLib" ;;
let _ZeroInflationTermStructureHandle_frequency arg = match _ZeroInflationTermStructureHandle_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_indexIsInterpolated_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_indexIsInterpolatedQuantLib" ;;
let _ZeroInflationTermStructureHandle_indexIsInterpolated arg = match _ZeroInflationTermStructureHandle_indexIsInterpolated_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_baseRate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_baseRateQuantLib" ;;
let _ZeroInflationTermStructureHandle_baseRate arg = match _ZeroInflationTermStructureHandle_baseRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_nominalTermStructure_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_nominalTermStructureQuantLib" ;;
let _ZeroInflationTermStructureHandle_nominalTermStructure arg = match _ZeroInflationTermStructureHandle_nominalTermStructure_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_baseDate_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_baseDateQuantLib" ;;
let _ZeroInflationTermStructureHandle_baseDate arg = match _ZeroInflationTermStructureHandle_baseDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_setSeasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_setSeasonality__SWIG_0QuantLib" ;;
let _ZeroInflationTermStructureHandle_setSeasonality arg = match _ZeroInflationTermStructureHandle_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_setSeasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_setSeasonalityQuantLib" ;;
let _ZeroInflationTermStructureHandle_setSeasonality arg = match _ZeroInflationTermStructureHandle_setSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_seasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_seasonalityQuantLib" ;;
let _ZeroInflationTermStructureHandle_seasonality arg = match _ZeroInflationTermStructureHandle_seasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_hasSeasonality_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_hasSeasonalityQuantLib" ;;
let _ZeroInflationTermStructureHandle_hasSeasonality arg = match _ZeroInflationTermStructureHandle_hasSeasonality_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_enableExtrapolation_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_enableExtrapolationQuantLib" ;;
let _ZeroInflationTermStructureHandle_enableExtrapolation arg = match _ZeroInflationTermStructureHandle_enableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_disableExtrapolation_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_disableExtrapolationQuantLib" ;;
let _ZeroInflationTermStructureHandle_disableExtrapolation arg = match _ZeroInflationTermStructureHandle_disableExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroInflationTermStructureHandle_allowsExtrapolation_f : c_obj list -> c_obj list = "_wrap_ZeroInflationTermStructureHandle_allowsExtrapolationQuantLib" ;;
let _ZeroInflationTermStructureHandle_allowsExtrapolation arg = match _ZeroInflationTermStructureHandle_allowsExtrapolation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableZeroInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableZeroInflationTermStructureHandle__SWIG_0QuantLib" ;;
let _new_RelinkableZeroInflationTermStructureHandle arg = match _new_RelinkableZeroInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RelinkableZeroInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_new_RelinkableZeroInflationTermStructureHandleQuantLib" ;;
let _new_RelinkableZeroInflationTermStructureHandle arg = match _new_RelinkableZeroInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RelinkableZeroInflationTermStructureHandle_linkTo_f : c_obj list -> c_obj list = "_wrap_RelinkableZeroInflationTermStructureHandle_linkToQuantLib" ;;
let _RelinkableZeroInflationTermStructureHandle_linkTo arg = match _RelinkableZeroInflationTermStructureHandle_linkTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RelinkableZeroInflationTermStructureHandle_f : c_obj list -> c_obj list = "_wrap_delete_RelinkableZeroInflationTermStructureHandleQuantLib" ;;
let _delete_RelinkableZeroInflationTermStructureHandle arg = match _delete_RelinkableZeroInflationTermStructureHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InflationIndex_interpolated_f : c_obj list -> c_obj list = "_wrap_InflationIndex_interpolatedQuantLib" ;;
let _InflationIndex_interpolated arg = match _InflationIndex_interpolated_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InflationIndex_frequency_f : c_obj list -> c_obj list = "_wrap_InflationIndex_frequencyQuantLib" ;;
let _InflationIndex_frequency arg = match _InflationIndex_frequency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InflationIndex_availabilityLag_f : c_obj list -> c_obj list = "_wrap_InflationIndex_availabilityLagQuantLib" ;;
let _InflationIndex_availabilityLag arg = match _InflationIndex_availabilityLag_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InflationIndex_currency_f : c_obj list -> c_obj list = "_wrap_InflationIndex_currencyQuantLib" ;;
let _InflationIndex_currency arg = match _InflationIndex_currency_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InflationIndex_f : c_obj list -> c_obj list = "_wrap_delete_InflationIndexQuantLib" ;;
let _delete_InflationIndex arg = match _delete_InflationIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroInflationIndex_f : c_obj list -> c_obj list = "_wrap_delete_ZeroInflationIndexQuantLib" ;;
let _delete_ZeroInflationIndex arg = match _delete_ZeroInflationIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYInflationIndex_f : c_obj list -> c_obj list = "_wrap_delete_YoYInflationIndexQuantLib" ;;
let _delete_YoYInflationIndex arg = match _delete_YoYInflationIndex_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EUHICP_f : c_obj list -> c_obj list = "_wrap_new_EUHICP__SWIG_0QuantLib" ;;
let _new_EUHICP arg = match _new_EUHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EUHICP_f : c_obj list -> c_obj list = "_wrap_new_EUHICPQuantLib" ;;
let _new_EUHICP arg = match _new_EUHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EUHICP_f : c_obj list -> c_obj list = "_wrap_delete_EUHICPQuantLib" ;;
let _delete_EUHICP arg = match _delete_EUHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EUHICPXT_f : c_obj list -> c_obj list = "_wrap_new_EUHICPXT__SWIG_0QuantLib" ;;
let _new_EUHICPXT arg = match _new_EUHICPXT_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_EUHICPXT_f : c_obj list -> c_obj list = "_wrap_new_EUHICPXTQuantLib" ;;
let _new_EUHICPXT arg = match _new_EUHICPXT_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_EUHICPXT_f : c_obj list -> c_obj list = "_wrap_delete_EUHICPXTQuantLib" ;;
let _delete_EUHICPXT arg = match _delete_EUHICPXT_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FRHICP_f : c_obj list -> c_obj list = "_wrap_new_FRHICP__SWIG_0QuantLib" ;;
let _new_FRHICP arg = match _new_FRHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FRHICP_f : c_obj list -> c_obj list = "_wrap_new_FRHICPQuantLib" ;;
let _new_FRHICP arg = match _new_FRHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FRHICP_f : c_obj list -> c_obj list = "_wrap_delete_FRHICPQuantLib" ;;
let _delete_FRHICP arg = match _delete_FRHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UKRPI_f : c_obj list -> c_obj list = "_wrap_new_UKRPI__SWIG_0QuantLib" ;;
let _new_UKRPI arg = match _new_UKRPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UKRPI_f : c_obj list -> c_obj list = "_wrap_new_UKRPIQuantLib" ;;
let _new_UKRPI arg = match _new_UKRPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UKRPI_f : c_obj list -> c_obj list = "_wrap_delete_UKRPIQuantLib" ;;
let _delete_UKRPI arg = match _delete_UKRPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USCPI_f : c_obj list -> c_obj list = "_wrap_new_USCPI__SWIG_0QuantLib" ;;
let _new_USCPI arg = match _new_USCPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_USCPI_f : c_obj list -> c_obj list = "_wrap_new_USCPIQuantLib" ;;
let _new_USCPI arg = match _new_USCPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_USCPI_f : c_obj list -> c_obj list = "_wrap_delete_USCPIQuantLib" ;;
let _delete_USCPI arg = match _delete_USCPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYEUHICP_f : c_obj list -> c_obj list = "_wrap_new_YYEUHICP__SWIG_0QuantLib" ;;
let _new_YYEUHICP arg = match _new_YYEUHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYEUHICP_f : c_obj list -> c_obj list = "_wrap_new_YYEUHICPQuantLib" ;;
let _new_YYEUHICP arg = match _new_YYEUHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YYEUHICP_f : c_obj list -> c_obj list = "_wrap_delete_YYEUHICPQuantLib" ;;
let _delete_YYEUHICP arg = match _delete_YYEUHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYEUHICPXT_f : c_obj list -> c_obj list = "_wrap_new_YYEUHICPXT__SWIG_0QuantLib" ;;
let _new_YYEUHICPXT arg = match _new_YYEUHICPXT_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYEUHICPXT_f : c_obj list -> c_obj list = "_wrap_new_YYEUHICPXTQuantLib" ;;
let _new_YYEUHICPXT arg = match _new_YYEUHICPXT_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YYEUHICPXT_f : c_obj list -> c_obj list = "_wrap_delete_YYEUHICPXTQuantLib" ;;
let _delete_YYEUHICPXT arg = match _delete_YYEUHICPXT_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYFRHICP_f : c_obj list -> c_obj list = "_wrap_new_YYFRHICP__SWIG_0QuantLib" ;;
let _new_YYFRHICP arg = match _new_YYFRHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYFRHICP_f : c_obj list -> c_obj list = "_wrap_new_YYFRHICPQuantLib" ;;
let _new_YYFRHICP arg = match _new_YYFRHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YYFRHICP_f : c_obj list -> c_obj list = "_wrap_delete_YYFRHICPQuantLib" ;;
let _delete_YYFRHICP arg = match _delete_YYFRHICP_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYUKRPI_f : c_obj list -> c_obj list = "_wrap_new_YYUKRPI__SWIG_0QuantLib" ;;
let _new_YYUKRPI arg = match _new_YYUKRPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYUKRPI_f : c_obj list -> c_obj list = "_wrap_new_YYUKRPIQuantLib" ;;
let _new_YYUKRPI arg = match _new_YYUKRPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YYUKRPI_f : c_obj list -> c_obj list = "_wrap_delete_YYUKRPIQuantLib" ;;
let _delete_YYUKRPI arg = match _delete_YYUKRPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYUSCPI_f : c_obj list -> c_obj list = "_wrap_new_YYUSCPI__SWIG_0QuantLib" ;;
let _new_YYUSCPI arg = match _new_YYUSCPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YYUSCPI_f : c_obj list -> c_obj list = "_wrap_new_YYUSCPIQuantLib" ;;
let _new_YYUSCPI arg = match _new_YYUSCPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YYUSCPI_f : c_obj list -> c_obj list = "_wrap_delete_YYUSCPIQuantLib" ;;
let _delete_YYUSCPI arg = match _delete_YYUSCPI_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelper___deref___f : c_obj list -> c_obj list = "_wrap_ZeroHelper___deref__QuantLib" ;;
let _ZeroHelper___deref__ arg = match _ZeroHelper___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelper_isNull_f : c_obj list -> c_obj list = "_wrap_ZeroHelper_isNullQuantLib" ;;
let _ZeroHelper_isNull arg = match _ZeroHelper_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroHelper_f : c_obj list -> c_obj list = "_wrap_new_ZeroHelperQuantLib" ;;
let _new_ZeroHelper arg = match _new_ZeroHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroHelper_f : c_obj list -> c_obj list = "_wrap_delete_ZeroHelperQuantLib" ;;
let _delete_ZeroHelper arg = match _delete_ZeroHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelper___deref___f : c_obj list -> c_obj list = "_wrap_YoYHelper___deref__QuantLib" ;;
let _YoYHelper___deref__ arg = match _YoYHelper___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelper_isNull_f : c_obj list -> c_obj list = "_wrap_YoYHelper_isNullQuantLib" ;;
let _YoYHelper_isNull arg = match _YoYHelper_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYHelper_f : c_obj list -> c_obj list = "_wrap_new_YoYHelperQuantLib" ;;
let _new_YoYHelper arg = match _new_YoYHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYHelper_f : c_obj list -> c_obj list = "_wrap_delete_YoYHelperQuantLib" ;;
let _delete_YoYHelper arg = match _delete_YoYHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroHelperVector_f : c_obj list -> c_obj list = "_wrap_new_ZeroHelperVector__SWIG_0QuantLib" ;;
let _new_ZeroHelperVector arg = match _new_ZeroHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroHelperVector_f : c_obj list -> c_obj list = "_wrap_new_ZeroHelperVector__SWIG_1QuantLib" ;;
let _new_ZeroHelperVector arg = match _new_ZeroHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroHelperVector_f : c_obj list -> c_obj list = "_wrap_new_ZeroHelperVector__SWIG_2QuantLib" ;;
let _new_ZeroHelperVector arg = match _new_ZeroHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroHelperVector_f : c_obj list -> c_obj list = "_wrap_new_ZeroHelperVectorQuantLib" ;;
let _new_ZeroHelperVector arg = match _new_ZeroHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_size_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_sizeQuantLib" ;;
let _ZeroHelperVector_size arg = match _ZeroHelperVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_empty_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_emptyQuantLib" ;;
let _ZeroHelperVector_empty arg = match _ZeroHelperVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_clear_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_clearQuantLib" ;;
let _ZeroHelperVector_clear arg = match _ZeroHelperVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_push_back_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_push_backQuantLib" ;;
let _ZeroHelperVector_push_back arg = match _ZeroHelperVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_operator_bB___QuantLib" ;;
let _ZeroHelperVector_operator_xx_xx_lbrace_xx_rbrace arg = match _ZeroHelperVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_operator_e___QuantLib" ;;
let _ZeroHelperVector_operator_xx_xx_equals arg = match _ZeroHelperVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_set_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_setQuantLib" ;;
let _ZeroHelperVector_set arg = match _ZeroHelperVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroHelperVector_to_array_f : c_obj list -> c_obj list = "_wrap_ZeroHelperVector_to_arrayQuantLib" ;;
let _ZeroHelperVector_to_array arg = match _ZeroHelperVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroHelperVector_f : c_obj list -> c_obj list = "_wrap_delete_ZeroHelperVectorQuantLib" ;;
let _delete_ZeroHelperVector arg = match _delete_ZeroHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYHelperVector_f : c_obj list -> c_obj list = "_wrap_new_YoYHelperVector__SWIG_0QuantLib" ;;
let _new_YoYHelperVector arg = match _new_YoYHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYHelperVector_f : c_obj list -> c_obj list = "_wrap_new_YoYHelperVector__SWIG_1QuantLib" ;;
let _new_YoYHelperVector arg = match _new_YoYHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYHelperVector_f : c_obj list -> c_obj list = "_wrap_new_YoYHelperVector__SWIG_2QuantLib" ;;
let _new_YoYHelperVector arg = match _new_YoYHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYHelperVector_f : c_obj list -> c_obj list = "_wrap_new_YoYHelperVectorQuantLib" ;;
let _new_YoYHelperVector arg = match _new_YoYHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_size_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_sizeQuantLib" ;;
let _YoYHelperVector_size arg = match _YoYHelperVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_empty_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_emptyQuantLib" ;;
let _YoYHelperVector_empty arg = match _YoYHelperVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_clear_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_clearQuantLib" ;;
let _YoYHelperVector_clear arg = match _YoYHelperVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_push_back_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_push_backQuantLib" ;;
let _YoYHelperVector_push_back arg = match _YoYHelperVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_operator_bB___QuantLib" ;;
let _YoYHelperVector_operator_xx_xx_lbrace_xx_rbrace arg = match _YoYHelperVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_operator_e___QuantLib" ;;
let _YoYHelperVector_operator_xx_xx_equals arg = match _YoYHelperVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_set_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_setQuantLib" ;;
let _YoYHelperVector_set arg = match _YoYHelperVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYHelperVector_to_array_f : c_obj list -> c_obj list = "_wrap_YoYHelperVector_to_arrayQuantLib" ;;
let _YoYHelperVector_to_array arg = match _YoYHelperVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYHelperVector_f : c_obj list -> c_obj list = "_wrap_delete_YoYHelperVectorQuantLib" ;;
let _delete_YoYHelperVector arg = match _delete_YoYHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCouponInflationSwapHelper_f : c_obj list -> c_obj list = "_wrap_new_ZeroCouponInflationSwapHelperQuantLib" ;;
let _new_ZeroCouponInflationSwapHelper arg = match _new_ZeroCouponInflationSwapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroCouponInflationSwapHelper_f : c_obj list -> c_obj list = "_wrap_delete_ZeroCouponInflationSwapHelperQuantLib" ;;
let _delete_ZeroCouponInflationSwapHelper arg = match _delete_ZeroCouponInflationSwapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YearOnYearInflationSwapHelper_f : c_obj list -> c_obj list = "_wrap_new_YearOnYearInflationSwapHelperQuantLib" ;;
let _new_YearOnYearInflationSwapHelper arg = match _new_YearOnYearInflationSwapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YearOnYearInflationSwapHelper_f : c_obj list -> c_obj list = "_wrap_delete_YearOnYearInflationSwapHelperQuantLib" ;;
let _delete_YearOnYearInflationSwapHelper arg = match _delete_YearOnYearInflationSwapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseZeroInflation_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseZeroInflationQuantLib" ;;
let _new_PiecewiseZeroInflation arg = match _new_PiecewiseZeroInflation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseZeroInflation_dates_f : c_obj list -> c_obj list = "_wrap_PiecewiseZeroInflation_datesQuantLib" ;;
let _PiecewiseZeroInflation_dates arg = match _PiecewiseZeroInflation_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseZeroInflation_times_f : c_obj list -> c_obj list = "_wrap_PiecewiseZeroInflation_timesQuantLib" ;;
let _PiecewiseZeroInflation_times arg = match _PiecewiseZeroInflation_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseZeroInflation_nodes_f : c_obj list -> c_obj list = "_wrap_PiecewiseZeroInflation_nodesQuantLib" ;;
let _PiecewiseZeroInflation_nodes arg = match _PiecewiseZeroInflation_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PiecewiseZeroInflation_f : c_obj list -> c_obj list = "_wrap_delete_PiecewiseZeroInflationQuantLib" ;;
let _delete_PiecewiseZeroInflation arg = match _delete_PiecewiseZeroInflation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseYoYInflation_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseYoYInflationQuantLib" ;;
let _new_PiecewiseYoYInflation arg = match _new_PiecewiseYoYInflation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseYoYInflation_dates_f : c_obj list -> c_obj list = "_wrap_PiecewiseYoYInflation_datesQuantLib" ;;
let _PiecewiseYoYInflation_dates arg = match _PiecewiseYoYInflation_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseYoYInflation_times_f : c_obj list -> c_obj list = "_wrap_PiecewiseYoYInflation_timesQuantLib" ;;
let _PiecewiseYoYInflation_times arg = match _PiecewiseYoYInflation_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseYoYInflation_nodes_f : c_obj list -> c_obj list = "_wrap_PiecewiseYoYInflation_nodesQuantLib" ;;
let _PiecewiseYoYInflation_nodes arg = match _PiecewiseYoYInflation_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PiecewiseYoYInflation_f : c_obj list -> c_obj list = "_wrap_delete_PiecewiseYoYInflationQuantLib" ;;
let _delete_PiecewiseYoYInflation arg = match _delete_PiecewiseYoYInflation_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroCouponInflationSwap_Receiver : c_obj -> Swig.c_obj = "_wrap_ZeroCouponInflationSwap_Receiver" 
external _ZeroCouponInflationSwap_Payer : c_obj -> Swig.c_obj = "_wrap_ZeroCouponInflationSwap_Payer" 
external _new_ZeroCouponInflationSwap_f : c_obj list -> c_obj list = "_wrap_new_ZeroCouponInflationSwap__SWIG_0QuantLib" ;;
let _new_ZeroCouponInflationSwap arg = match _new_ZeroCouponInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCouponInflationSwap_f : c_obj list -> c_obj list = "_wrap_new_ZeroCouponInflationSwap__SWIG_1QuantLib" ;;
let _new_ZeroCouponInflationSwap arg = match _new_ZeroCouponInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCouponInflationSwap_f : c_obj list -> c_obj list = "_wrap_new_ZeroCouponInflationSwap__SWIG_2QuantLib" ;;
let _new_ZeroCouponInflationSwap arg = match _new_ZeroCouponInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroCouponInflationSwap_f : c_obj list -> c_obj list = "_wrap_new_ZeroCouponInflationSwapQuantLib" ;;
let _new_ZeroCouponInflationSwap arg = match _new_ZeroCouponInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ZeroCouponInflationSwap_fairRate_f : c_obj list -> c_obj list = "_wrap_ZeroCouponInflationSwap_fairRateQuantLib" ;;
let _ZeroCouponInflationSwap_fairRate arg = match _ZeroCouponInflationSwap_fairRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroCouponInflationSwap_f : c_obj list -> c_obj list = "_wrap_delete_ZeroCouponInflationSwapQuantLib" ;;
let _delete_ZeroCouponInflationSwap arg = match _delete_ZeroCouponInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YearOnYearInflationSwap_Receiver : c_obj -> Swig.c_obj = "_wrap_YearOnYearInflationSwap_Receiver" 
external _YearOnYearInflationSwap_Payer : c_obj -> Swig.c_obj = "_wrap_YearOnYearInflationSwap_Payer" 
external _new_YearOnYearInflationSwap_f : c_obj list -> c_obj list = "_wrap_new_YearOnYearInflationSwap__SWIG_0QuantLib" ;;
let _new_YearOnYearInflationSwap arg = match _new_YearOnYearInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YearOnYearInflationSwap_f : c_obj list -> c_obj list = "_wrap_new_YearOnYearInflationSwapQuantLib" ;;
let _new_YearOnYearInflationSwap arg = match _new_YearOnYearInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YearOnYearInflationSwap_fairRate_f : c_obj list -> c_obj list = "_wrap_YearOnYearInflationSwap_fairRateQuantLib" ;;
let _YearOnYearInflationSwap_fairRate arg = match _YearOnYearInflationSwap_fairRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YearOnYearInflationSwap_f : c_obj list -> c_obj list = "_wrap_delete_YearOnYearInflationSwapQuantLib" ;;
let _delete_YearOnYearInflationSwap arg = match _delete_YearOnYearInflationSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationCapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_YoYInflationCapFloor_impliedVolatility__SWIG_0QuantLib" ;;
let _YoYInflationCapFloor_impliedVolatility arg = match _YoYInflationCapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationCapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_YoYInflationCapFloor_impliedVolatility__SWIG_1QuantLib" ;;
let _YoYInflationCapFloor_impliedVolatility arg = match _YoYInflationCapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationCapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_YoYInflationCapFloor_impliedVolatility__SWIG_2QuantLib" ;;
let _YoYInflationCapFloor_impliedVolatility arg = match _YoYInflationCapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationCapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_YoYInflationCapFloor_impliedVolatility__SWIG_3QuantLib" ;;
let _YoYInflationCapFloor_impliedVolatility arg = match _YoYInflationCapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _YoYInflationCapFloor_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_YoYInflationCapFloor_impliedVolatilityQuantLib" ;;
let _YoYInflationCapFloor_impliedVolatility arg = match _YoYInflationCapFloor_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYInflationCapFloor_f : c_obj list -> c_obj list = "_wrap_new_YoYInflationCapFloorQuantLib" ;;
let _new_YoYInflationCapFloor arg = match _new_YoYInflationCapFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYInflationCapFloor_f : c_obj list -> c_obj list = "_wrap_delete_YoYInflationCapFloorQuantLib" ;;
let _delete_YoYInflationCapFloor arg = match _delete_YoYInflationCapFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYInflationCap_f : c_obj list -> c_obj list = "_wrap_new_YoYInflationCapQuantLib" ;;
let _new_YoYInflationCap arg = match _new_YoYInflationCap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYInflationCap_f : c_obj list -> c_obj list = "_wrap_delete_YoYInflationCapQuantLib" ;;
let _delete_YoYInflationCap arg = match _delete_YoYInflationCap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYInflationFloor_f : c_obj list -> c_obj list = "_wrap_new_YoYInflationFloorQuantLib" ;;
let _new_YoYInflationFloor arg = match _new_YoYInflationFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYInflationFloor_f : c_obj list -> c_obj list = "_wrap_delete_YoYInflationFloorQuantLib" ;;
let _delete_YoYInflationFloor arg = match _delete_YoYInflationFloor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_YoYInflationCollar_f : c_obj list -> c_obj list = "_wrap_new_YoYInflationCollarQuantLib" ;;
let _new_YoYInflationCollar arg = match _new_YoYInflationCollar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_YoYInflationCollar_f : c_obj list -> c_obj list = "_wrap_delete_YoYInflationCollarQuantLib" ;;
let _delete_YoYInflationCollar arg = match _delete_YoYInflationCollar_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SegmentIntegral_f : c_obj list -> c_obj list = "_wrap_new_SegmentIntegralQuantLib" ;;
let _new_SegmentIntegral arg = match _new_SegmentIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SegmentIntegral_f : c_obj list -> c_obj list = "_wrap_delete_SegmentIntegralQuantLib" ;;
let _delete_SegmentIntegral arg = match _delete_SegmentIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TrapezoidIntegralDefault_f : c_obj list -> c_obj list = "_wrap_new_TrapezoidIntegralDefaultQuantLib" ;;
let _new_TrapezoidIntegralDefault arg = match _new_TrapezoidIntegralDefault_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TrapezoidIntegralDefault_f : c_obj list -> c_obj list = "_wrap_delete_TrapezoidIntegralDefaultQuantLib" ;;
let _delete_TrapezoidIntegralDefault arg = match _delete_TrapezoidIntegralDefault_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TrapezoidIntegralMidPoint_f : c_obj list -> c_obj list = "_wrap_new_TrapezoidIntegralMidPointQuantLib" ;;
let _new_TrapezoidIntegralMidPoint arg = match _new_TrapezoidIntegralMidPoint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TrapezoidIntegralMidPoint_f : c_obj list -> c_obj list = "_wrap_delete_TrapezoidIntegralMidPointQuantLib" ;;
let _delete_TrapezoidIntegralMidPoint arg = match _delete_TrapezoidIntegralMidPoint_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SimpsonIntegral_f : c_obj list -> c_obj list = "_wrap_new_SimpsonIntegralQuantLib" ;;
let _new_SimpsonIntegral arg = match _new_SimpsonIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SimpsonIntegral_f : c_obj list -> c_obj list = "_wrap_delete_SimpsonIntegralQuantLib" ;;
let _delete_SimpsonIntegral arg = match _delete_SimpsonIntegral_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussKronrodAdaptive_f : c_obj list -> c_obj list = "_wrap_new_GaussKronrodAdaptive__SWIG_0QuantLib" ;;
let _new_GaussKronrodAdaptive arg = match _new_GaussKronrodAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussKronrodAdaptive_f : c_obj list -> c_obj list = "_wrap_new_GaussKronrodAdaptiveQuantLib" ;;
let _new_GaussKronrodAdaptive arg = match _new_GaussKronrodAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussKronrodAdaptive_f : c_obj list -> c_obj list = "_wrap_delete_GaussKronrodAdaptiveQuantLib" ;;
let _delete_GaussKronrodAdaptive arg = match _delete_GaussKronrodAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussKronrodNonAdaptive_f : c_obj list -> c_obj list = "_wrap_new_GaussKronrodNonAdaptiveQuantLib" ;;
let _new_GaussKronrodNonAdaptive arg = match _new_GaussKronrodNonAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussKronrodNonAdaptive_f : c_obj list -> c_obj list = "_wrap_delete_GaussKronrodNonAdaptiveQuantLib" ;;
let _delete_GaussKronrodNonAdaptive arg = match _delete_GaussKronrodNonAdaptive_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleNumber_value_f : c_obj list -> c_obj list = "_wrap_SampleNumber_valueQuantLib" ;;
let _SampleNumber_value arg = match _SampleNumber_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleNumber_weight_f : c_obj list -> c_obj list = "_wrap_SampleNumber_weightQuantLib" ;;
let _SampleNumber_weight arg = match _SampleNumber_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleNumber_f : c_obj list -> c_obj list = "_wrap_delete_SampleNumberQuantLib" ;;
let _delete_SampleNumber arg = match _delete_SampleNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleArray_value_f : c_obj list -> c_obj list = "_wrap_SampleArray_valueQuantLib" ;;
let _SampleArray_value arg = match _SampleArray_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleArray_weight_f : c_obj list -> c_obj list = "_wrap_SampleArray_weightQuantLib" ;;
let _SampleArray_weight arg = match _SampleArray_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleArray_f : c_obj list -> c_obj list = "_wrap_delete_SampleArrayQuantLib" ;;
let _delete_SampleArray arg = match _delete_SampleArray_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleRealVector_value_f : c_obj list -> c_obj list = "_wrap_SampleRealVector_valueQuantLib" ;;
let _SampleRealVector_value arg = match _SampleRealVector_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleRealVector_weight_f : c_obj list -> c_obj list = "_wrap_SampleRealVector_weightQuantLib" ;;
let _SampleRealVector_weight arg = match _SampleRealVector_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleRealVector_f : c_obj list -> c_obj list = "_wrap_delete_SampleRealVectorQuantLib" ;;
let _delete_SampleRealVector arg = match _delete_SampleRealVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LecuyerUniformRng_f : c_obj list -> c_obj list = "_wrap_new_LecuyerUniformRng__SWIG_0QuantLib" ;;
let _new_LecuyerUniformRng arg = match _new_LecuyerUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LecuyerUniformRng_f : c_obj list -> c_obj list = "_wrap_new_LecuyerUniformRngQuantLib" ;;
let _new_LecuyerUniformRng arg = match _new_LecuyerUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LecuyerUniformRng_next_f : c_obj list -> c_obj list = "_wrap_LecuyerUniformRng_nextQuantLib" ;;
let _LecuyerUniformRng_next arg = match _LecuyerUniformRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LecuyerUniformRng_f : c_obj list -> c_obj list = "_wrap_delete_LecuyerUniformRngQuantLib" ;;
let _delete_LecuyerUniformRng arg = match _delete_LecuyerUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KnuthUniformRng_f : c_obj list -> c_obj list = "_wrap_new_KnuthUniformRng__SWIG_0QuantLib" ;;
let _new_KnuthUniformRng arg = match _new_KnuthUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KnuthUniformRng_f : c_obj list -> c_obj list = "_wrap_new_KnuthUniformRngQuantLib" ;;
let _new_KnuthUniformRng arg = match _new_KnuthUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KnuthUniformRng_next_f : c_obj list -> c_obj list = "_wrap_KnuthUniformRng_nextQuantLib" ;;
let _KnuthUniformRng_next arg = match _KnuthUniformRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KnuthUniformRng_f : c_obj list -> c_obj list = "_wrap_delete_KnuthUniformRngQuantLib" ;;
let _delete_KnuthUniformRng arg = match _delete_KnuthUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MersenneTwisterUniformRng_f : c_obj list -> c_obj list = "_wrap_new_MersenneTwisterUniformRng__SWIG_0QuantLib" ;;
let _new_MersenneTwisterUniformRng arg = match _new_MersenneTwisterUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MersenneTwisterUniformRng_f : c_obj list -> c_obj list = "_wrap_new_MersenneTwisterUniformRngQuantLib" ;;
let _new_MersenneTwisterUniformRng arg = match _new_MersenneTwisterUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MersenneTwisterUniformRng_next_f : c_obj list -> c_obj list = "_wrap_MersenneTwisterUniformRng_nextQuantLib" ;;
let _MersenneTwisterUniformRng_next arg = match _MersenneTwisterUniformRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MersenneTwisterUniformRng_f : c_obj list -> c_obj list = "_wrap_delete_MersenneTwisterUniformRngQuantLib" ;;
let _delete_MersenneTwisterUniformRng arg = match _delete_MersenneTwisterUniformRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformRandomGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformRandomGenerator__SWIG_0QuantLib" ;;
let _new_UniformRandomGenerator arg = match _new_UniformRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformRandomGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformRandomGeneratorQuantLib" ;;
let _new_UniformRandomGenerator arg = match _new_UniformRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformRandomGenerator_next_f : c_obj list -> c_obj list = "_wrap_UniformRandomGenerator_nextQuantLib" ;;
let _UniformRandomGenerator_next arg = match _UniformRandomGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformRandomGenerator_nextValue_f : c_obj list -> c_obj list = "_wrap_UniformRandomGenerator_nextValueQuantLib" ;;
let _UniformRandomGenerator_nextValue arg = match _UniformRandomGenerator_nextValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UniformRandomGenerator_f : c_obj list -> c_obj list = "_wrap_delete_UniformRandomGeneratorQuantLib" ;;
let _delete_UniformRandomGenerator arg = match _delete_UniformRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CentralLimitLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_CentralLimitLecuyerGaussianRngQuantLib" ;;
let _new_CentralLimitLecuyerGaussianRng arg = match _new_CentralLimitLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CentralLimitLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_CentralLimitLecuyerGaussianRng_nextQuantLib" ;;
let _CentralLimitLecuyerGaussianRng_next arg = match _CentralLimitLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CentralLimitLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_CentralLimitLecuyerGaussianRngQuantLib" ;;
let _delete_CentralLimitLecuyerGaussianRng arg = match _delete_CentralLimitLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CentralLimitKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_CentralLimitKnuthGaussianRngQuantLib" ;;
let _new_CentralLimitKnuthGaussianRng arg = match _new_CentralLimitKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CentralLimitKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_CentralLimitKnuthGaussianRng_nextQuantLib" ;;
let _CentralLimitKnuthGaussianRng_next arg = match _CentralLimitKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CentralLimitKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_CentralLimitKnuthGaussianRngQuantLib" ;;
let _delete_CentralLimitKnuthGaussianRng arg = match _delete_CentralLimitKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CentralLimitMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_CentralLimitMersenneTwisterGaussianRngQuantLib" ;;
let _new_CentralLimitMersenneTwisterGaussianRng arg = match _new_CentralLimitMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CentralLimitMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_CentralLimitMersenneTwisterGaussianRng_nextQuantLib" ;;
let _CentralLimitMersenneTwisterGaussianRng_next arg = match _CentralLimitMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CentralLimitMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_CentralLimitMersenneTwisterGaussianRngQuantLib" ;;
let _delete_CentralLimitMersenneTwisterGaussianRng arg = match _delete_CentralLimitMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoxMullerLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_BoxMullerLecuyerGaussianRngQuantLib" ;;
let _new_BoxMullerLecuyerGaussianRng arg = match _new_BoxMullerLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoxMullerLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_BoxMullerLecuyerGaussianRng_nextQuantLib" ;;
let _BoxMullerLecuyerGaussianRng_next arg = match _BoxMullerLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoxMullerLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_BoxMullerLecuyerGaussianRngQuantLib" ;;
let _delete_BoxMullerLecuyerGaussianRng arg = match _delete_BoxMullerLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoxMullerKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_BoxMullerKnuthGaussianRngQuantLib" ;;
let _new_BoxMullerKnuthGaussianRng arg = match _new_BoxMullerKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoxMullerKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_BoxMullerKnuthGaussianRng_nextQuantLib" ;;
let _BoxMullerKnuthGaussianRng_next arg = match _BoxMullerKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoxMullerKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_BoxMullerKnuthGaussianRngQuantLib" ;;
let _delete_BoxMullerKnuthGaussianRng arg = match _delete_BoxMullerKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_BoxMullerMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_BoxMullerMersenneTwisterGaussianRngQuantLib" ;;
let _new_BoxMullerMersenneTwisterGaussianRng arg = match _new_BoxMullerMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoxMullerMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_BoxMullerMersenneTwisterGaussianRng_nextQuantLib" ;;
let _BoxMullerMersenneTwisterGaussianRng_next arg = match _BoxMullerMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoxMullerMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_BoxMullerMersenneTwisterGaussianRngQuantLib" ;;
let _delete_BoxMullerMersenneTwisterGaussianRng arg = match _delete_BoxMullerMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeLecuyerGaussianRngQuantLib" ;;
let _new_MoroInvCumulativeLecuyerGaussianRng arg = match _new_MoroInvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeLecuyerGaussianRng_nextQuantLib" ;;
let _MoroInvCumulativeLecuyerGaussianRng_next arg = match _MoroInvCumulativeLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeLecuyerGaussianRngQuantLib" ;;
let _delete_MoroInvCumulativeLecuyerGaussianRng arg = match _delete_MoroInvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeKnuthGaussianRngQuantLib" ;;
let _new_MoroInvCumulativeKnuthGaussianRng arg = match _new_MoroInvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeKnuthGaussianRng_nextQuantLib" ;;
let _MoroInvCumulativeKnuthGaussianRng_next arg = match _MoroInvCumulativeKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeKnuthGaussianRngQuantLib" ;;
let _delete_MoroInvCumulativeKnuthGaussianRng arg = match _delete_MoroInvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _new_MoroInvCumulativeMersenneTwisterGaussianRng arg = match _new_MoroInvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeMersenneTwisterGaussianRng_nextQuantLib" ;;
let _MoroInvCumulativeMersenneTwisterGaussianRng_next arg = match _MoroInvCumulativeMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _delete_MoroInvCumulativeMersenneTwisterGaussianRng arg = match _delete_MoroInvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeLecuyerGaussianRngQuantLib" ;;
let _new_InvCumulativeLecuyerGaussianRng arg = match _new_InvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeLecuyerGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_InvCumulativeLecuyerGaussianRng_nextQuantLib" ;;
let _InvCumulativeLecuyerGaussianRng_next arg = match _InvCumulativeLecuyerGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeLecuyerGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeLecuyerGaussianRngQuantLib" ;;
let _delete_InvCumulativeLecuyerGaussianRng arg = match _delete_InvCumulativeLecuyerGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeKnuthGaussianRngQuantLib" ;;
let _new_InvCumulativeKnuthGaussianRng arg = match _new_InvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeKnuthGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_InvCumulativeKnuthGaussianRng_nextQuantLib" ;;
let _InvCumulativeKnuthGaussianRng_next arg = match _InvCumulativeKnuthGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeKnuthGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeKnuthGaussianRngQuantLib" ;;
let _delete_InvCumulativeKnuthGaussianRng arg = match _delete_InvCumulativeKnuthGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _new_InvCumulativeMersenneTwisterGaussianRng arg = match _new_InvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeMersenneTwisterGaussianRng_next_f : c_obj list -> c_obj list = "_wrap_InvCumulativeMersenneTwisterGaussianRng_nextQuantLib" ;;
let _InvCumulativeMersenneTwisterGaussianRng_next arg = match _InvCumulativeMersenneTwisterGaussianRng_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeMersenneTwisterGaussianRng_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeMersenneTwisterGaussianRngQuantLib" ;;
let _delete_InvCumulativeMersenneTwisterGaussianRng arg = match _delete_InvCumulativeMersenneTwisterGaussianRng_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianRandomGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianRandomGeneratorQuantLib" ;;
let _new_GaussianRandomGenerator arg = match _new_GaussianRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianRandomGenerator_next_f : c_obj list -> c_obj list = "_wrap_GaussianRandomGenerator_nextQuantLib" ;;
let _GaussianRandomGenerator_next arg = match _GaussianRandomGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianRandomGenerator_nextValue_f : c_obj list -> c_obj list = "_wrap_GaussianRandomGenerator_nextValueQuantLib" ;;
let _GaussianRandomGenerator_nextValue arg = match _GaussianRandomGenerator_nextValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianRandomGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianRandomGeneratorQuantLib" ;;
let _delete_GaussianRandomGenerator arg = match _delete_GaussianRandomGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_HaltonRsg_f : c_obj list -> c_obj list = "_wrap_new_HaltonRsgQuantLib" ;;
let _new_HaltonRsg arg = match _new_HaltonRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HaltonRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_HaltonRsg_nextSequenceQuantLib" ;;
let _HaltonRsg_nextSequence arg = match _HaltonRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _HaltonRsg_dimension_f : c_obj list -> c_obj list = "_wrap_HaltonRsg_dimensionQuantLib" ;;
let _HaltonRsg_dimension arg = match _HaltonRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_HaltonRsg_f : c_obj list -> c_obj list = "_wrap_delete_HaltonRsgQuantLib" ;;
let _delete_HaltonRsg arg = match _delete_HaltonRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SobolRsg_f : c_obj list -> c_obj list = "_wrap_new_SobolRsg__SWIG_0QuantLib" ;;
let _new_SobolRsg arg = match _new_SobolRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SobolRsg_f : c_obj list -> c_obj list = "_wrap_new_SobolRsgQuantLib" ;;
let _new_SobolRsg arg = match _new_SobolRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SobolRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_SobolRsg_nextSequenceQuantLib" ;;
let _SobolRsg_nextSequence arg = match _SobolRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SobolRsg_dimension_f : c_obj list -> c_obj list = "_wrap_SobolRsg_dimensionQuantLib" ;;
let _SobolRsg_dimension arg = match _SobolRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SobolRsg_f : c_obj list -> c_obj list = "_wrap_delete_SobolRsgQuantLib" ;;
let _delete_SobolRsg arg = match _delete_SobolRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_LecuyerUniformRsg_f : c_obj list -> c_obj list = "_wrap_new_LecuyerUniformRsgQuantLib" ;;
let _new_LecuyerUniformRsg arg = match _new_LecuyerUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LecuyerUniformRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_LecuyerUniformRsg_nextSequenceQuantLib" ;;
let _LecuyerUniformRsg_nextSequence arg = match _LecuyerUniformRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _LecuyerUniformRsg_dimension_f : c_obj list -> c_obj list = "_wrap_LecuyerUniformRsg_dimensionQuantLib" ;;
let _LecuyerUniformRsg_dimension arg = match _LecuyerUniformRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_LecuyerUniformRsg_f : c_obj list -> c_obj list = "_wrap_delete_LecuyerUniformRsgQuantLib" ;;
let _delete_LecuyerUniformRsg arg = match _delete_LecuyerUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_KnuthUniformRsg_f : c_obj list -> c_obj list = "_wrap_new_KnuthUniformRsgQuantLib" ;;
let _new_KnuthUniformRsg arg = match _new_KnuthUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KnuthUniformRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_KnuthUniformRsg_nextSequenceQuantLib" ;;
let _KnuthUniformRsg_nextSequence arg = match _KnuthUniformRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _KnuthUniformRsg_dimension_f : c_obj list -> c_obj list = "_wrap_KnuthUniformRsg_dimensionQuantLib" ;;
let _KnuthUniformRsg_dimension arg = match _KnuthUniformRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_KnuthUniformRsg_f : c_obj list -> c_obj list = "_wrap_delete_KnuthUniformRsgQuantLib" ;;
let _delete_KnuthUniformRsg arg = match _delete_KnuthUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MersenneTwisterUniformRsg_f : c_obj list -> c_obj list = "_wrap_new_MersenneTwisterUniformRsgQuantLib" ;;
let _new_MersenneTwisterUniformRsg arg = match _new_MersenneTwisterUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MersenneTwisterUniformRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MersenneTwisterUniformRsg_nextSequenceQuantLib" ;;
let _MersenneTwisterUniformRsg_nextSequence arg = match _MersenneTwisterUniformRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MersenneTwisterUniformRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MersenneTwisterUniformRsg_dimensionQuantLib" ;;
let _MersenneTwisterUniformRsg_dimension arg = match _MersenneTwisterUniformRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MersenneTwisterUniformRsg_f : c_obj list -> c_obj list = "_wrap_delete_MersenneTwisterUniformRsgQuantLib" ;;
let _delete_MersenneTwisterUniformRsg arg = match _delete_MersenneTwisterUniformRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformRandomSequenceGeneratorQuantLib" ;;
let _new_UniformRandomSequenceGenerator arg = match _new_UniformRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformRandomSequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_UniformRandomSequenceGenerator_nextSequenceQuantLib" ;;
let _UniformRandomSequenceGenerator_nextSequence arg = match _UniformRandomSequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformRandomSequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_UniformRandomSequenceGenerator_dimensionQuantLib" ;;
let _UniformRandomSequenceGenerator_dimension arg = match _UniformRandomSequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UniformRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_UniformRandomSequenceGeneratorQuantLib" ;;
let _delete_UniformRandomSequenceGenerator arg = match _delete_UniformRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_UniformLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_UniformLowDiscrepancySequenceGeneratorQuantLib" ;;
let _new_UniformLowDiscrepancySequenceGenerator arg = match _new_UniformLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformLowDiscrepancySequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_UniformLowDiscrepancySequenceGenerator_nextSequenceQuantLib" ;;
let _UniformLowDiscrepancySequenceGenerator_nextSequence arg = match _UniformLowDiscrepancySequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _UniformLowDiscrepancySequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_UniformLowDiscrepancySequenceGenerator_dimensionQuantLib" ;;
let _UniformLowDiscrepancySequenceGenerator_dimension arg = match _UniformLowDiscrepancySequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_UniformLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_UniformLowDiscrepancySequenceGeneratorQuantLib" ;;
let _delete_UniformLowDiscrepancySequenceGenerator arg = match _delete_UniformLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeLecuyerGaussianRsg arg = match _new_MoroInvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeLecuyerGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeLecuyerGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeLecuyerGaussianRsg_nextSequence arg = match _MoroInvCumulativeLecuyerGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeLecuyerGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeLecuyerGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeLecuyerGaussianRsg_dimension arg = match _MoroInvCumulativeLecuyerGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeLecuyerGaussianRsg arg = match _delete_MoroInvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeKnuthGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeKnuthGaussianRsg arg = match _new_MoroInvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeKnuthGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeKnuthGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeKnuthGaussianRsg_nextSequence arg = match _MoroInvCumulativeKnuthGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeKnuthGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeKnuthGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeKnuthGaussianRsg_dimension arg = match _MoroInvCumulativeKnuthGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeKnuthGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeKnuthGaussianRsg arg = match _delete_MoroInvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeMersenneTwisterGaussianRsg arg = match _new_MoroInvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence arg = match _MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeMersenneTwisterGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeMersenneTwisterGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeMersenneTwisterGaussianRsg_dimension arg = match _MoroInvCumulativeMersenneTwisterGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeMersenneTwisterGaussianRsg arg = match _delete_MoroInvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_MoroInvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_MoroInvCumulativeHaltonGaussianRsgQuantLib" ;;
let _new_MoroInvCumulativeHaltonGaussianRsg arg = match _new_MoroInvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeHaltonGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeHaltonGaussianRsg_nextSequenceQuantLib" ;;
let _MoroInvCumulativeHaltonGaussianRsg_nextSequence arg = match _MoroInvCumulativeHaltonGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MoroInvCumulativeHaltonGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_MoroInvCumulativeHaltonGaussianRsg_dimensionQuantLib" ;;
let _MoroInvCumulativeHaltonGaussianRsg_dimension arg = match _MoroInvCumulativeHaltonGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MoroInvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_MoroInvCumulativeHaltonGaussianRsgQuantLib" ;;
let _delete_MoroInvCumulativeHaltonGaussianRsg arg = match _delete_MoroInvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _new_InvCumulativeLecuyerGaussianRsg arg = match _new_InvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeLecuyerGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeLecuyerGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeLecuyerGaussianRsg_nextSequence arg = match _InvCumulativeLecuyerGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeLecuyerGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeLecuyerGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeLecuyerGaussianRsg_dimension arg = match _InvCumulativeLecuyerGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeLecuyerGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeLecuyerGaussianRsgQuantLib" ;;
let _delete_InvCumulativeLecuyerGaussianRsg arg = match _delete_InvCumulativeLecuyerGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeKnuthGaussianRsgQuantLib" ;;
let _new_InvCumulativeKnuthGaussianRsg arg = match _new_InvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeKnuthGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeKnuthGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeKnuthGaussianRsg_nextSequence arg = match _InvCumulativeKnuthGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeKnuthGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeKnuthGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeKnuthGaussianRsg_dimension arg = match _InvCumulativeKnuthGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeKnuthGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeKnuthGaussianRsgQuantLib" ;;
let _delete_InvCumulativeKnuthGaussianRsg arg = match _delete_InvCumulativeKnuthGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _new_InvCumulativeMersenneTwisterGaussianRsg arg = match _new_InvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeMersenneTwisterGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeMersenneTwisterGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeMersenneTwisterGaussianRsg_nextSequence arg = match _InvCumulativeMersenneTwisterGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeMersenneTwisterGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeMersenneTwisterGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeMersenneTwisterGaussianRsg_dimension arg = match _InvCumulativeMersenneTwisterGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeMersenneTwisterGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeMersenneTwisterGaussianRsgQuantLib" ;;
let _delete_InvCumulativeMersenneTwisterGaussianRsg arg = match _delete_InvCumulativeMersenneTwisterGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_InvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_new_InvCumulativeHaltonGaussianRsgQuantLib" ;;
let _new_InvCumulativeHaltonGaussianRsg arg = match _new_InvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeHaltonGaussianRsg_nextSequence_f : c_obj list -> c_obj list = "_wrap_InvCumulativeHaltonGaussianRsg_nextSequenceQuantLib" ;;
let _InvCumulativeHaltonGaussianRsg_nextSequence arg = match _InvCumulativeHaltonGaussianRsg_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _InvCumulativeHaltonGaussianRsg_dimension_f : c_obj list -> c_obj list = "_wrap_InvCumulativeHaltonGaussianRsg_dimensionQuantLib" ;;
let _InvCumulativeHaltonGaussianRsg_dimension arg = match _InvCumulativeHaltonGaussianRsg_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_InvCumulativeHaltonGaussianRsg_f : c_obj list -> c_obj list = "_wrap_delete_InvCumulativeHaltonGaussianRsgQuantLib" ;;
let _delete_InvCumulativeHaltonGaussianRsg arg = match _delete_InvCumulativeHaltonGaussianRsg_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianRandomSequenceGeneratorQuantLib" ;;
let _new_GaussianRandomSequenceGenerator arg = match _new_GaussianRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianRandomSequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_GaussianRandomSequenceGenerator_nextSequenceQuantLib" ;;
let _GaussianRandomSequenceGenerator_nextSequence arg = match _GaussianRandomSequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianRandomSequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_GaussianRandomSequenceGenerator_dimensionQuantLib" ;;
let _GaussianRandomSequenceGenerator_dimension arg = match _GaussianRandomSequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianRandomSequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianRandomSequenceGeneratorQuantLib" ;;
let _delete_GaussianRandomSequenceGenerator arg = match _delete_GaussianRandomSequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianLowDiscrepancySequenceGeneratorQuantLib" ;;
let _new_GaussianLowDiscrepancySequenceGenerator arg = match _new_GaussianLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianLowDiscrepancySequenceGenerator_nextSequence_f : c_obj list -> c_obj list = "_wrap_GaussianLowDiscrepancySequenceGenerator_nextSequenceQuantLib" ;;
let _GaussianLowDiscrepancySequenceGenerator_nextSequence arg = match _GaussianLowDiscrepancySequenceGenerator_nextSequence_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianLowDiscrepancySequenceGenerator_dimension_f : c_obj list -> c_obj list = "_wrap_GaussianLowDiscrepancySequenceGenerator_dimensionQuantLib" ;;
let _GaussianLowDiscrepancySequenceGenerator_dimension arg = match _GaussianLowDiscrepancySequenceGenerator_dimension_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianLowDiscrepancySequenceGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianLowDiscrepancySequenceGeneratorQuantLib" ;;
let _delete_GaussianLowDiscrepancySequenceGenerator arg = match _delete_GaussianLowDiscrepancySequenceGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _getCovariance_f : c_obj list -> c_obj list = "_wrap_getCovarianceQuantLib" ;;
let _getCovariance arg = match _getCovariance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_length_f : c_obj list -> c_obj list = "_wrap_Path_lengthQuantLib" ;;
let _Path_length arg = match _Path_length_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_value_f : c_obj list -> c_obj list = "_wrap_Path_valueQuantLib" ;;
let _Path_value arg = match _Path_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_front_f : c_obj list -> c_obj list = "_wrap_Path_frontQuantLib" ;;
let _Path_front arg = match _Path_front_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_back_f : c_obj list -> c_obj list = "_wrap_Path_backQuantLib" ;;
let _Path_back arg = match _Path_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Path_time_f : c_obj list -> c_obj list = "_wrap_Path_timeQuantLib" ;;
let _Path_time arg = match _Path_time_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Path_f : c_obj list -> c_obj list = "_wrap_delete_PathQuantLib" ;;
let _delete_Path arg = match _delete_Path_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SamplePath_value_f : c_obj list -> c_obj list = "_wrap_SamplePath_valueQuantLib" ;;
let _SamplePath_value arg = match _SamplePath_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SamplePath_weight_f : c_obj list -> c_obj list = "_wrap_SamplePath_weightQuantLib" ;;
let _SamplePath_weight arg = match _SamplePath_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SamplePath_f : c_obj list -> c_obj list = "_wrap_delete_SamplePathQuantLib" ;;
let _delete_SamplePath arg = match _delete_SamplePath_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianPathGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianPathGeneratorQuantLib" ;;
let _new_GaussianPathGenerator arg = match _new_GaussianPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianPathGenerator_next_f : c_obj list -> c_obj list = "_wrap_GaussianPathGenerator_nextQuantLib" ;;
let _GaussianPathGenerator_next arg = match _GaussianPathGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianPathGenerator_antithetic_f : c_obj list -> c_obj list = "_wrap_GaussianPathGenerator_antitheticQuantLib" ;;
let _GaussianPathGenerator_antithetic arg = match _GaussianPathGenerator_antithetic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianPathGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianPathGeneratorQuantLib" ;;
let _delete_GaussianPathGenerator arg = match _delete_GaussianPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianSobolPathGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianSobolPathGeneratorQuantLib" ;;
let _new_GaussianSobolPathGenerator arg = match _new_GaussianSobolPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianSobolPathGenerator_next_f : c_obj list -> c_obj list = "_wrap_GaussianSobolPathGenerator_nextQuantLib" ;;
let _GaussianSobolPathGenerator_next arg = match _GaussianSobolPathGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianSobolPathGenerator_antithetic_f : c_obj list -> c_obj list = "_wrap_GaussianSobolPathGenerator_antitheticQuantLib" ;;
let _GaussianSobolPathGenerator_antithetic arg = match _GaussianSobolPathGenerator_antithetic_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianSobolPathGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianSobolPathGeneratorQuantLib" ;;
let _delete_GaussianSobolPathGenerator arg = match _delete_GaussianSobolPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiPath_pathSize_f : c_obj list -> c_obj list = "_wrap_MultiPath_pathSizeQuantLib" ;;
let _MultiPath_pathSize arg = match _MultiPath_pathSize_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _MultiPath_assetNumber_f : c_obj list -> c_obj list = "_wrap_MultiPath_assetNumberQuantLib" ;;
let _MultiPath_assetNumber arg = match _MultiPath_assetNumber_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_MultiPath_f : c_obj list -> c_obj list = "_wrap_delete_MultiPathQuantLib" ;;
let _delete_MultiPath arg = match _delete_MultiPath_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleMultiPath_value_f : c_obj list -> c_obj list = "_wrap_SampleMultiPath_valueQuantLib" ;;
let _SampleMultiPath_value arg = match _SampleMultiPath_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampleMultiPath_weight_f : c_obj list -> c_obj list = "_wrap_SampleMultiPath_weightQuantLib" ;;
let _SampleMultiPath_weight arg = match _SampleMultiPath_weight_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampleMultiPath_f : c_obj list -> c_obj list = "_wrap_delete_SampleMultiPathQuantLib" ;;
let _delete_SampleMultiPath arg = match _delete_SampleMultiPath_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianMultiPathGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianMultiPathGenerator__SWIG_0QuantLib" ;;
let _new_GaussianMultiPathGenerator arg = match _new_GaussianMultiPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_GaussianMultiPathGenerator_f : c_obj list -> c_obj list = "_wrap_new_GaussianMultiPathGeneratorQuantLib" ;;
let _new_GaussianMultiPathGenerator arg = match _new_GaussianMultiPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _GaussianMultiPathGenerator_next_f : c_obj list -> c_obj list = "_wrap_GaussianMultiPathGenerator_nextQuantLib" ;;
let _GaussianMultiPathGenerator_next arg = match _GaussianMultiPathGenerator_next_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_GaussianMultiPathGenerator_f : c_obj list -> c_obj list = "_wrap_delete_GaussianMultiPathGeneratorQuantLib" ;;
let _delete_GaussianMultiPathGenerator arg = match _delete_GaussianMultiPathGenerator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoundaryCondition___deref___f : c_obj list -> c_obj list = "_wrap_BoundaryCondition___deref__QuantLib" ;;
let _BoundaryCondition___deref__ arg = match _BoundaryCondition___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoundaryCondition_isNull_f : c_obj list -> c_obj list = "_wrap_BoundaryCondition_isNullQuantLib" ;;
let _BoundaryCondition_isNull arg = match _BoundaryCondition_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _BoundaryCondition_NoSide : c_obj -> Swig.c_obj = "_wrap_BoundaryCondition_NoSide" 
external _BoundaryCondition_Upper : c_obj -> Swig.c_obj = "_wrap_BoundaryCondition_Upper" 
external _BoundaryCondition_Lower : c_obj -> Swig.c_obj = "_wrap_BoundaryCondition_Lower" 
external _new_BoundaryCondition_f : c_obj list -> c_obj list = "_wrap_new_BoundaryConditionQuantLib" ;;
let _new_BoundaryCondition arg = match _new_BoundaryCondition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_BoundaryCondition_f : c_obj list -> c_obj list = "_wrap_delete_BoundaryConditionQuantLib" ;;
let _delete_BoundaryCondition arg = match _delete_BoundaryCondition_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_NeumannBC_f : c_obj list -> c_obj list = "_wrap_new_NeumannBCQuantLib" ;;
let _new_NeumannBC arg = match _new_NeumannBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_NeumannBC_f : c_obj list -> c_obj list = "_wrap_delete_NeumannBCQuantLib" ;;
let _delete_NeumannBC arg = match _delete_NeumannBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DirichletBC_f : c_obj list -> c_obj list = "_wrap_new_DirichletBCQuantLib" ;;
let _new_DirichletBC arg = match _new_DirichletBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DirichletBC_f : c_obj list -> c_obj list = "_wrap_delete_DirichletBCQuantLib" ;;
let _delete_DirichletBC arg = match _delete_DirichletBC_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TridiagonalOperator_f : c_obj list -> c_obj list = "_wrap_new_TridiagonalOperatorQuantLib" ;;
let _new_TridiagonalOperator arg = match _new_TridiagonalOperator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_solveFor_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_solveForQuantLib" ;;
let _TridiagonalOperator_solveFor arg = match _TridiagonalOperator_solveFor_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_applyTo_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_applyToQuantLib" ;;
let _TridiagonalOperator_applyTo arg = match _TridiagonalOperator_applyTo_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_size_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_sizeQuantLib" ;;
let _TridiagonalOperator_size arg = match _TridiagonalOperator_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setFirstRow_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setFirstRowQuantLib" ;;
let _TridiagonalOperator_setFirstRow arg = match _TridiagonalOperator_setFirstRow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setMidRow_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setMidRowQuantLib" ;;
let _TridiagonalOperator_setMidRow arg = match _TridiagonalOperator_setMidRow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setMidRows_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setMidRowsQuantLib" ;;
let _TridiagonalOperator_setMidRows arg = match _TridiagonalOperator_setMidRows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_setLastRow_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_setLastRowQuantLib" ;;
let _TridiagonalOperator_setLastRow arg = match _TridiagonalOperator_setLastRow_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TridiagonalOperator_identity_f : c_obj list -> c_obj list = "_wrap_TridiagonalOperator_identityQuantLib" ;;
let _TridiagonalOperator_identity arg = match _TridiagonalOperator_identity_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TridiagonalOperator_f : c_obj list -> c_obj list = "_wrap_delete_TridiagonalOperatorQuantLib" ;;
let _delete_TridiagonalOperator arg = match _delete_TridiagonalOperator_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DPlus_f : c_obj list -> c_obj list = "_wrap_new_DPlusQuantLib" ;;
let _new_DPlus arg = match _new_DPlus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DPlus_f : c_obj list -> c_obj list = "_wrap_delete_DPlusQuantLib" ;;
let _delete_DPlus arg = match _delete_DPlus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DMinus_f : c_obj list -> c_obj list = "_wrap_new_DMinusQuantLib" ;;
let _new_DMinus arg = match _new_DMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DMinus_f : c_obj list -> c_obj list = "_wrap_delete_DMinusQuantLib" ;;
let _delete_DMinus arg = match _delete_DMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DZero_f : c_obj list -> c_obj list = "_wrap_new_DZeroQuantLib" ;;
let _new_DZero arg = match _new_DZero_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DZero_f : c_obj list -> c_obj list = "_wrap_delete_DZeroQuantLib" ;;
let _delete_DZero arg = match _delete_DZero_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DPlusDMinus_f : c_obj list -> c_obj list = "_wrap_new_DPlusDMinusQuantLib" ;;
let _new_DPlusDMinus arg = match _new_DPlusDMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DPlusDMinus_f : c_obj list -> c_obj list = "_wrap_delete_DPlusDMinusQuantLib" ;;
let _delete_DPlusDMinus arg = match _delete_DPlusDMinus_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeBasket_f : c_obj list -> c_obj list = "_wrap_new_TimeBasket__SWIG_0QuantLib" ;;
let _new_TimeBasket arg = match _new_TimeBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_TimeBasket_f : c_obj list -> c_obj list = "_wrap_new_TimeBasketQuantLib" ;;
let _new_TimeBasket arg = match _new_TimeBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TimeBasket_size_f : c_obj list -> c_obj list = "_wrap_TimeBasket_sizeQuantLib" ;;
let _TimeBasket_size arg = match _TimeBasket_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _TimeBasket_rebin_f : c_obj list -> c_obj list = "_wrap_TimeBasket_rebinQuantLib" ;;
let _TimeBasket_rebin arg = match _TimeBasket_rebin_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_TimeBasket_f : c_obj list -> c_obj list = "_wrap_delete_TimeBasketQuantLib" ;;
let _delete_TimeBasket arg = match _delete_TimeBasket_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Swap_f : c_obj list -> c_obj list = "_wrap_new_SwapQuantLib" ;;
let _new_Swap arg = match _new_Swap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Swap_startDate_f : c_obj list -> c_obj list = "_wrap_Swap_startDateQuantLib" ;;
let _Swap_startDate arg = match _Swap_startDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Swap_maturityDate_f : c_obj list -> c_obj list = "_wrap_Swap_maturityDateQuantLib" ;;
let _Swap_maturityDate arg = match _Swap_maturityDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Swap_f : c_obj list -> c_obj list = "_wrap_delete_SwapQuantLib" ;;
let _delete_Swap arg = match _delete_Swap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_Receiver : c_obj -> Swig.c_obj = "_wrap_VanillaSwap_Receiver" 
external _VanillaSwap_Payer : c_obj -> Swig.c_obj = "_wrap_VanillaSwap_Payer" 
external _new_VanillaSwap_f : c_obj list -> c_obj list = "_wrap_new_VanillaSwapQuantLib" ;;
let _new_VanillaSwap arg = match _new_VanillaSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_fairRate_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_fairRateQuantLib" ;;
let _VanillaSwap_fairRate arg = match _VanillaSwap_fairRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_fairSpread_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_fairSpreadQuantLib" ;;
let _VanillaSwap_fairSpread arg = match _VanillaSwap_fairSpread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_fixedLegBPS_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_fixedLegBPSQuantLib" ;;
let _VanillaSwap_fixedLegBPS arg = match _VanillaSwap_fixedLegBPS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _VanillaSwap_floatingLegBPS_f : c_obj list -> c_obj list = "_wrap_VanillaSwap_floatingLegBPSQuantLib" ;;
let _VanillaSwap_floatingLegBPS arg = match _VanillaSwap_floatingLegBPS_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_VanillaSwap_f : c_obj list -> c_obj list = "_wrap_delete_VanillaSwapQuantLib" ;;
let _delete_VanillaSwap arg = match _delete_VanillaSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountingSwapEngine_f : c_obj list -> c_obj list = "_wrap_new_DiscountingSwapEngine__SWIG_0QuantLib" ;;
let _new_DiscountingSwapEngine arg = match _new_DiscountingSwapEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountingSwapEngine_f : c_obj list -> c_obj list = "_wrap_new_DiscountingSwapEngine__SWIG_1QuantLib" ;;
let _new_DiscountingSwapEngine arg = match _new_DiscountingSwapEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountingSwapEngine_f : c_obj list -> c_obj list = "_wrap_new_DiscountingSwapEngine__SWIG_2QuantLib" ;;
let _new_DiscountingSwapEngine arg = match _new_DiscountingSwapEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountingSwapEngine_f : c_obj list -> c_obj list = "_wrap_new_DiscountingSwapEngine__SWIG_3QuantLib" ;;
let _new_DiscountingSwapEngine arg = match _new_DiscountingSwapEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountingSwapEngine_f : c_obj list -> c_obj list = "_wrap_new_DiscountingSwapEngine__SWIG_4QuantLib" ;;
let _new_DiscountingSwapEngine arg = match _new_DiscountingSwapEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DiscountingSwapEngine_f : c_obj list -> c_obj list = "_wrap_new_DiscountingSwapEngineQuantLib" ;;
let _new_DiscountingSwapEngine arg = match _new_DiscountingSwapEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DiscountingSwapEngine_f : c_obj list -> c_obj list = "_wrap_delete_DiscountingSwapEngineQuantLib" ;;
let _delete_DiscountingSwapEngine arg = match _delete_DiscountingSwapEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_AssetSwap_f : c_obj list -> c_obj list = "_wrap_new_AssetSwapQuantLib" ;;
let _new_AssetSwap arg = match _new_AssetSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _AssetSwap_fairCleanPrice_f : c_obj list -> c_obj list = "_wrap_AssetSwap_fairCleanPriceQuantLib" ;;
let _AssetSwap_fairCleanPrice arg = match _AssetSwap_fairCleanPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _AssetSwap_fairSpread_f : c_obj list -> c_obj list = "_wrap_AssetSwap_fairSpreadQuantLib" ;;
let _AssetSwap_fairSpread arg = match _AssetSwap_fairSpread_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_AssetSwap_f : c_obj list -> c_obj list = "_wrap_delete_AssetSwapQuantLib" ;;
let _delete_AssetSwap arg = match _delete_AssetSwap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelper___deref___f : c_obj list -> c_obj list = "_wrap_RateHelper___deref__QuantLib" ;;
let _RateHelper___deref__ arg = match _RateHelper___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelper_isNull_f : c_obj list -> c_obj list = "_wrap_RateHelper_isNullQuantLib" ;;
let _RateHelper_isNull arg = match _RateHelper_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelper_f : c_obj list -> c_obj list = "_wrap_new_RateHelperQuantLib" ;;
let _new_RateHelper arg = match _new_RateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RateHelper_f : c_obj list -> c_obj list = "_wrap_delete_RateHelperQuantLib" ;;
let _delete_RateHelper arg = match _delete_RateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelper_quote_f : c_obj list -> c_obj list = "_wrap_RateHelper_quoteQuantLib" ;;
let _RateHelper_quote arg = match _RateHelper_quote_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelper_latestDate_f : c_obj list -> c_obj list = "_wrap_RateHelper_latestDateQuantLib" ;;
let _RateHelper_latestDate arg = match _RateHelper_latestDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DepositRateHelper_f : c_obj list -> c_obj list = "_wrap_new_DepositRateHelper__SWIG_0QuantLib" ;;
let _new_DepositRateHelper arg = match _new_DepositRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_DepositRateHelper_f : c_obj list -> c_obj list = "_wrap_new_DepositRateHelperQuantLib" ;;
let _new_DepositRateHelper arg = match _new_DepositRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_DepositRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_DepositRateHelperQuantLib" ;;
let _delete_DepositRateHelper arg = match _delete_DepositRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FraRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FraRateHelper__SWIG_0QuantLib" ;;
let _new_FraRateHelper arg = match _new_FraRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FraRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FraRateHelperQuantLib" ;;
let _new_FraRateHelper arg = match _new_FraRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FraRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_FraRateHelperQuantLib" ;;
let _delete_FraRateHelper arg = match _delete_FraRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelper__SWIG_0QuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelper__SWIG_1QuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_new_FuturesRateHelperQuantLib" ;;
let _new_FuturesRateHelper arg = match _new_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FuturesRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_FuturesRateHelperQuantLib" ;;
let _delete_FuturesRateHelper arg = match _delete_FuturesRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelper__SWIG_0QuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelper__SWIG_1QuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelper__SWIG_2QuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelper__SWIG_3QuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelper__SWIG_4QuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_new_SwapRateHelperQuantLib" ;;
let _new_SwapRateHelper arg = match _new_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwapRateHelper_swap_f : c_obj list -> c_obj list = "_wrap_SwapRateHelper_swapQuantLib" ;;
let _SwapRateHelper_swap arg = match _SwapRateHelper_swap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwapRateHelper_f : c_obj list -> c_obj list = "_wrap_delete_SwapRateHelperQuantLib" ;;
let _delete_SwapRateHelper arg = match _delete_SwapRateHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedRateBondHelper__SWIG_0QuantLib" ;;
let _new_FixedRateBondHelper arg = match _new_FixedRateBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedRateBondHelper__SWIG_1QuantLib" ;;
let _new_FixedRateBondHelper arg = match _new_FixedRateBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedRateBondHelper__SWIG_2QuantLib" ;;
let _new_FixedRateBondHelper arg = match _new_FixedRateBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_FixedRateBondHelper_f : c_obj list -> c_obj list = "_wrap_new_FixedRateBondHelperQuantLib" ;;
let _new_FixedRateBondHelper arg = match _new_FixedRateBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _FixedRateBondHelper_bond_f : c_obj list -> c_obj list = "_wrap_FixedRateBondHelper_bondQuantLib" ;;
let _FixedRateBondHelper_bond arg = match _FixedRateBondHelper_bond_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_FixedRateBondHelper_f : c_obj list -> c_obj list = "_wrap_delete_FixedRateBondHelperQuantLib" ;;
let _delete_FixedRateBondHelper arg = match _delete_FixedRateBondHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVector__SWIG_0QuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVector__SWIG_1QuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVector__SWIG_2QuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_new_RateHelperVectorQuantLib" ;;
let _new_RateHelperVector arg = match _new_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_size_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_sizeQuantLib" ;;
let _RateHelperVector_size arg = match _RateHelperVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_empty_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_emptyQuantLib" ;;
let _RateHelperVector_empty arg = match _RateHelperVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_clear_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_clearQuantLib" ;;
let _RateHelperVector_clear arg = match _RateHelperVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_push_back_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_push_backQuantLib" ;;
let _RateHelperVector_push_back arg = match _RateHelperVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_operator_bB___QuantLib" ;;
let _RateHelperVector_operator_xx_xx_lbrace_xx_rbrace arg = match _RateHelperVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_operator_e___QuantLib" ;;
let _RateHelperVector_operator_xx_xx_equals arg = match _RateHelperVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_set_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_setQuantLib" ;;
let _RateHelperVector_set arg = match _RateHelperVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _RateHelperVector_to_array_f : c_obj list -> c_obj list = "_wrap_RateHelperVector_to_arrayQuantLib" ;;
let _RateHelperVector_to_array arg = match _RateHelperVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_RateHelperVector_f : c_obj list -> c_obj list = "_wrap_delete_RateHelperVectorQuantLib" ;;
let _delete_RateHelperVector arg = match _delete_RateHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_Discount_f : c_obj list -> c_obj list = "_wrap_new_DiscountQuantLib" ;;
let _new_Discount arg = match _new_Discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Discount_f : c_obj list -> c_obj list = "_wrap_delete_DiscountQuantLib" ;;
let _delete_Discount arg = match _delete_Discount_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ZeroYield_f : c_obj list -> c_obj list = "_wrap_new_ZeroYieldQuantLib" ;;
let _new_ZeroYield arg = match _new_ZeroYield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ZeroYield_f : c_obj list -> c_obj list = "_wrap_delete_ZeroYieldQuantLib" ;;
let _delete_ZeroYield arg = match _delete_ZeroYield_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ForwardRate_f : c_obj list -> c_obj list = "_wrap_new_ForwardRateQuantLib" ;;
let _new_ForwardRate arg = match _new_ForwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ForwardRate_f : c_obj list -> c_obj list = "_wrap_delete_ForwardRateQuantLib" ;;
let _delete_ForwardRate arg = match _delete_ForwardRate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_0QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_1QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_2QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_3QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_4QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_5QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_6QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_7QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForward__SWIG_8QuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_new_PiecewiseFlatForwardQuantLib" ;;
let _new_PiecewiseFlatForward arg = match _new_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatForward_dates_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatForward_datesQuantLib" ;;
let _PiecewiseFlatForward_dates arg = match _PiecewiseFlatForward_dates_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatForward_times_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatForward_timesQuantLib" ;;
let _PiecewiseFlatForward_times arg = match _PiecewiseFlatForward_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _PiecewiseFlatForward_nodes_f : c_obj list -> c_obj list = "_wrap_PiecewiseFlatForward_nodesQuantLib" ;;
let _PiecewiseFlatForward_nodes arg = match _PiecewiseFlatForward_nodes_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_PiecewiseFlatForward_f : c_obj list -> c_obj list = "_wrap_delete_PiecewiseFlatForwardQuantLib" ;;
let _delete_PiecewiseFlatForward arg = match _delete_PiecewiseFlatForward_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SampledCurve_f : c_obj list -> c_obj list = "_wrap_new_SampledCurve__SWIG_0QuantLib" ;;
let _new_SampledCurve arg = match _new_SampledCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SampledCurve_f : c_obj list -> c_obj list = "_wrap_new_SampledCurveQuantLib" ;;
let _new_SampledCurve arg = match _new_SampledCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_grid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_gridQuantLib" ;;
let _SampledCurve_grid arg = match _SampledCurve_grid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_values_f : c_obj list -> c_obj list = "_wrap_SampledCurve_valuesQuantLib" ;;
let _SampledCurve_values arg = match _SampledCurve_values_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_gridValue_f : c_obj list -> c_obj list = "_wrap_SampledCurve_gridValueQuantLib" ;;
let _SampledCurve_gridValue arg = match _SampledCurve_gridValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_value_f : c_obj list -> c_obj list = "_wrap_SampledCurve_valueQuantLib" ;;
let _SampledCurve_value arg = match _SampledCurve_value_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_size_f : c_obj list -> c_obj list = "_wrap_SampledCurve_sizeQuantLib" ;;
let _SampledCurve_size arg = match _SampledCurve_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_empty_f : c_obj list -> c_obj list = "_wrap_SampledCurve_emptyQuantLib" ;;
let _SampledCurve_empty arg = match _SampledCurve_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_setGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_setGridQuantLib" ;;
let _SampledCurve_setGrid arg = match _SampledCurve_setGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_setValues_f : c_obj list -> c_obj list = "_wrap_SampledCurve_setValuesQuantLib" ;;
let _SampledCurve_setValues arg = match _SampledCurve_setValues_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_swap_f : c_obj list -> c_obj list = "_wrap_SampledCurve_swapQuantLib" ;;
let _SampledCurve_swap arg = match _SampledCurve_swap_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_setLogGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_setLogGridQuantLib" ;;
let _SampledCurve_setLogGrid arg = match _SampledCurve_setLogGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_regridLogGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_regridLogGridQuantLib" ;;
let _SampledCurve_regridLogGrid arg = match _SampledCurve_regridLogGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_shiftGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_shiftGridQuantLib" ;;
let _SampledCurve_shiftGrid arg = match _SampledCurve_shiftGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_scaleGrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_scaleGridQuantLib" ;;
let _SampledCurve_scaleGrid arg = match _SampledCurve_scaleGrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SampledCurve_regrid_f : c_obj list -> c_obj list = "_wrap_SampledCurve_regridQuantLib" ;;
let _SampledCurve_regrid arg = match _SampledCurve_regrid_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SampledCurve_f : c_obj list -> c_obj list = "_wrap_delete_SampledCurveQuantLib" ;;
let _delete_SampledCurve arg = match _delete_SampledCurve_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_instance_f : c_obj list -> c_obj list = "_wrap_Settings_instanceQuantLib" ;;
let _Settings_instance arg = match _Settings_instance_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_getEvaluationDate_f : c_obj list -> c_obj list = "_wrap_Settings_getEvaluationDateQuantLib" ;;
let _Settings_getEvaluationDate arg = match _Settings_getEvaluationDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_setEvaluationDate_f : c_obj list -> c_obj list = "_wrap_Settings_setEvaluationDateQuantLib" ;;
let _Settings_setEvaluationDate arg = match _Settings_setEvaluationDate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_includeReferenceDateCashFlows_f : c_obj list -> c_obj list = "_wrap_Settings_includeReferenceDateCashFlowsQuantLib" ;;
let _Settings_includeReferenceDateCashFlows arg = match _Settings_includeReferenceDateCashFlows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _Settings_includeTodaysCashFlows_f : c_obj list -> c_obj list = "_wrap_Settings_includeTodaysCashFlowsQuantLib" ;;
let _Settings_includeTodaysCashFlows arg = match _Settings_includeTodaysCashFlows_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_Settings_f : c_obj list -> c_obj list = "_wrap_delete_SettingsQuantLib" ;;
let _delete_Settings arg = match _delete_Settings_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper___deref___f : c_obj list -> c_obj list = "_wrap_CalibrationHelper___deref__QuantLib" ;;
let _CalibrationHelper___deref__ arg = match _CalibrationHelper___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_isNull_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_isNullQuantLib" ;;
let _CalibrationHelper_isNull arg = match _CalibrationHelper_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_RelativePriceError : c_obj -> Swig.c_obj = "_wrap_CalibrationHelper_RelativePriceError" 
external _CalibrationHelper_PriceError : c_obj -> Swig.c_obj = "_wrap_CalibrationHelper_PriceError" 
external _CalibrationHelper_ImpliedVolError : c_obj -> Swig.c_obj = "_wrap_CalibrationHelper_ImpliedVolError" 
external _new_CalibrationHelper_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperQuantLib" ;;
let _new_CalibrationHelper arg = match _new_CalibrationHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CalibrationHelper_f : c_obj list -> c_obj list = "_wrap_delete_CalibrationHelperQuantLib" ;;
let _delete_CalibrationHelper arg = match _delete_CalibrationHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_setPricingEngine_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_setPricingEngineQuantLib" ;;
let _CalibrationHelper_setPricingEngine arg = match _CalibrationHelper_setPricingEngine_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_marketValue_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_marketValueQuantLib" ;;
let _CalibrationHelper_marketValue arg = match _CalibrationHelper_marketValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_modelValue_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_modelValueQuantLib" ;;
let _CalibrationHelper_modelValue arg = match _CalibrationHelper_modelValue_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_impliedVolatility_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_impliedVolatilityQuantLib" ;;
let _CalibrationHelper_impliedVolatility arg = match _CalibrationHelper_impliedVolatility_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelper_blackPrice_f : c_obj list -> c_obj list = "_wrap_CalibrationHelper_blackPriceQuantLib" ;;
let _CalibrationHelper_blackPrice arg = match _CalibrationHelper_blackPrice_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionHelper_f : c_obj list -> c_obj list = "_wrap_new_SwaptionHelper__SWIG_0QuantLib" ;;
let _new_SwaptionHelper arg = match _new_SwaptionHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_SwaptionHelper_f : c_obj list -> c_obj list = "_wrap_new_SwaptionHelperQuantLib" ;;
let _new_SwaptionHelper arg = match _new_SwaptionHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _SwaptionHelper_times_f : c_obj list -> c_obj list = "_wrap_SwaptionHelper_timesQuantLib" ;;
let _SwaptionHelper_times arg = match _SwaptionHelper_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_SwaptionHelper_f : c_obj list -> c_obj list = "_wrap_delete_SwaptionHelperQuantLib" ;;
let _delete_SwaptionHelper arg = match _delete_SwaptionHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapHelper_f : c_obj list -> c_obj list = "_wrap_new_CapHelper__SWIG_0QuantLib" ;;
let _new_CapHelper arg = match _new_CapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CapHelper_f : c_obj list -> c_obj list = "_wrap_new_CapHelperQuantLib" ;;
let _new_CapHelper arg = match _new_CapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CapHelper_times_f : c_obj list -> c_obj list = "_wrap_CapHelper_timesQuantLib" ;;
let _CapHelper_times arg = match _CapHelper_times_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CapHelper_f : c_obj list -> c_obj list = "_wrap_delete_CapHelperQuantLib" ;;
let _delete_CapHelper arg = match _delete_CapHelper_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVector__SWIG_0QuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVector__SWIG_1QuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVector__SWIG_2QuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_new_CalibrationHelperVectorQuantLib" ;;
let _new_CalibrationHelperVector arg = match _new_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_size_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_sizeQuantLib" ;;
let _CalibrationHelperVector_size arg = match _CalibrationHelperVector_size_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_empty_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_emptyQuantLib" ;;
let _CalibrationHelperVector_empty arg = match _CalibrationHelperVector_empty_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_clear_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_clearQuantLib" ;;
let _CalibrationHelperVector_clear arg = match _CalibrationHelperVector_clear_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_push_back_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_push_backQuantLib" ;;
let _CalibrationHelperVector_push_back arg = match _CalibrationHelperVector_push_back_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_operator_xx_xx_lbrace_xx_rbrace_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_operator_bB___QuantLib" ;;
let _CalibrationHelperVector_operator_xx_xx_lbrace_xx_rbrace arg = match _CalibrationHelperVector_operator_xx_xx_lbrace_xx_rbrace_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_operator_xx_xx_equals_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_operator_e___QuantLib" ;;
let _CalibrationHelperVector_operator_xx_xx_equals arg = match _CalibrationHelperVector_operator_xx_xx_equals_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_set_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_setQuantLib" ;;
let _CalibrationHelperVector_set arg = match _CalibrationHelperVector_set_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _CalibrationHelperVector_to_array_f : c_obj list -> c_obj list = "_wrap_CalibrationHelperVector_to_arrayQuantLib" ;;
let _CalibrationHelperVector_to_array arg = match _CalibrationHelperVector_to_array_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_CalibrationHelperVector_f : c_obj list -> c_obj list = "_wrap_delete_CalibrationHelperVectorQuantLib" ;;
let _delete_CalibrationHelperVector arg = match _delete_CalibrationHelperVector_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel___deref___f : c_obj list -> c_obj list = "_wrap_ShortRateModel___deref__QuantLib" ;;
let _ShortRateModel___deref__ arg = match _ShortRateModel___deref___f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_isNull_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_isNullQuantLib" ;;
let _ShortRateModel_isNull arg = match _ShortRateModel_isNull_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_asObservable_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_asObservableQuantLib" ;;
let _ShortRateModel_asObservable arg = match _ShortRateModel_asObservable_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ShortRateModel_f : c_obj list -> c_obj list = "_wrap_new_ShortRateModelQuantLib" ;;
let _new_ShortRateModel arg = match _new_ShortRateModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _delete_ShortRateModel_f : c_obj list -> c_obj list = "_wrap_delete_ShortRateModelQuantLib" ;;
let _delete_ShortRateModel arg = match _delete_ShortRateModel_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_params_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_paramsQuantLib" ;;
let _ShortRateModel_params arg = match _ShortRateModel_params_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_calibrate_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_calibrate__SWIG_0QuantLib" ;;
let _ShortRateModel_calibrate arg = match _ShortRateModel_calibrate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_calibrate_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_calibrate__SWIG_1QuantLib" ;;
let _ShortRateModel_calibrate arg = match _ShortRateModel_calibrate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModel_calibrate_f : c_obj list -> c_obj list = "_wrap_ShortRateModel_calibrateQuantLib" ;;
let _ShortRateModel_calibrate arg = match _ShortRateModel_calibrate_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if false then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ShortRateModelHandle_f : c_obj list -> c_obj list = "_wrap_new_ShortRateModelHandle__SWIG_0QuantLib" ;;
let _new_ShortRateModelHandle arg = match _new_ShortRateModelHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _new_ShortRateModelHandle_f : c_obj list -> c_obj list = "_wrap_new_ShortRateModelHandleQuantLib" ;;
let _new_ShortRateModelHandle arg = match _new_ShortRateModelHandle_f (fnhelper arg) with
  [] -> C_void
| [x] -> (if true then Gc.finalise 
  (fun x -> ignore ((invoke x) "~" C_void)) x) ; x
| lst -> C_list lst ;;
external _ShortRateModelHandle___deref___f : c_obj list -> 