

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: MontecarloPricers.i,v 1.6 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_Montecarlo_Pricers_i
#define quantlib_Montecarlo_Pricers_i

%include QLArray.i
%include Vectors.i
%include Matrix.i
%include Options.i
%include Types.i

%{
// single asset
using QuantLib::Pricers::McDiscreteArithmeticAPO;
using QuantLib::Pricers::McDiscreteArithmeticASO;
using QuantLib::Pricers::McEuropean;

// multi asset
using QuantLib::Pricers::McBasket;
using QuantLib::Pricers::McMaxBasket;
using QuantLib::Pricers::McEverest;
using QuantLib::Pricers::McHimalaya;
using QuantLib::Pricers::McPagoda;
%}

class McEuropean {
  public:
    McEuropean(OptionType type,
               double underlying,
               double strike,
               Spread dividendYield,
               Rate riskFreeRate,
               double residualTime,
               double volatility,
               bool antitheticVariance,
              long seed);
    ~McEuropean();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};

class McDiscreteArithmeticAPO {
  public:
	McDiscreteArithmeticAPO(OptionType type,
                            double underlying,
                            double strike,
                            Spread dividendYield,
                            Rate riskFreeRate,
                            const DoubleVector& timeDelays,
                            double volatility,
                            bool antitheticVariance,
                            bool controlVariate,
                            long seed);
    ~McDiscreteArithmeticAPO();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};

class McDiscreteArithmeticASO {
  public:
	McDiscreteArithmeticASO(OptionType type,
                            double underlying,
                            Spread dividendYield,
                            Rate riskFreeRate,
                            const DoubleVector& timeDelays,
                            double volatility,
                            bool antitheticVariance,
                            bool controlVariate,
                            long seed);
    ~McDiscreteArithmeticASO();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};



//
// Multi asset options
//

class McBasket {
  public:
    McBasket(OptionType type,
             const Array& underlying,
             double strike,
             const Array& dividendYield,
             const Matrix& covariance,
             Rate riskFreeRate,
             double residualTime,
             bool antitheticVariance,
             long seed = 0);
    ~McBasket();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};

class McMaxBasket {
  public:
    McMaxBasket(const Array& underlying,
                const Array& dividendYield,
                const Matrix& covariance,
                Rate riskFreeRate,
                double residualTime,
                bool antitheticVariance,
                long seed = 0);
    ~McMaxBasket();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};

class McHimalaya {
  public:
    McHimalaya(const Array& underlying,
		       const Array& dividendYield,
               const Matrix& covariance,
			   Rate riskFreeRate,
			   double strike,
               const DoubleVector& timeDelays,
		       bool antitheticVariance,
			   long seed=0);
    ~McHimalaya();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};

class McEverest {
  public:
    McEverest(const Array& dividendYield,
	          const Matrix& covariance,
              Rate riskFreeRate,
			  Time residualTime,
			  bool antitheticVariance,
			  long seed=0);
    ~McEverest();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};

class McPagoda {
  public:
    McPagoda(const Array& portfolio,
		     double fraction,
             double roof,
		     const Array& dividendYield,
		     const Matrix& covariance,
		     Rate riskFreeRate,
             const DoubleVector& timeDelays,
		     bool antithetic,
		     long seed = 0);
    ~McPagoda();
    double value(double tolerance,
                 size_t maxSample = QL_MAX_INT) const;
	double valueWithSamples(size_t samples) const;
    double errorEstimate() const;
};


#endif
