#!/usr/bin/python

"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.11 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/random_generators.py,v $

import QuantLib
import unittest

class RNGTest(unittest.TestCase):
    def runTest(self):
        "Testing random number generators"
        seed = 576919
        samples = 1000000
        for RNG in [QuantLib.UniformRandomGenerator,
                    QuantLib.GaussianRandomGenerator]:
            rn = RNG(seed=seed)
            s = QuantLib.Statistics()
            while s.samples() < samples:
                s.add(rn.next().value)
            # we'll have to write some meaningful test here


if __name__ == '__main__':
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(RNGTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')


