
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Path.i,v 1.12 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_path_i
#define quantlib_path_i

%include QLArray.i

%{
using QuantLib::MonteCarlo::Path;
using QuantLib::MonteCarlo::GaussianPathGenerator;
typedef QuantLib::MonteCarlo::Sample<QuantLib::MonteCarlo::Path> SamplePath;
%}

class Path {
  private:
    // access control - no constructor exported
    Path();
  public:
    ~Path();
    Array drift() const;
    Array diffusion() const;
};

%addmethods Path {
    int __len__() {
        return int(self->size());
    }
    double __getitem__(int i) {
        int size_ = int(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        } else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        } else {
            throw IndexError("Path index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
}


class SamplePath {
  public:
    ~SamplePath();
    Path value;
    double weight;
  private:
    SamplePath();
};

class GaussianPathGenerator {
  public:
    GaussianPathGenerator(double drift, double variance,
        Time length, /* Size */ int steps, long seed = 0);
	~GaussianPathGenerator();
	SamplePath next() const;
};


#endif
