
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Indexes.i,v 1.24 2002/02/19 10:35:43 lballabio Exp $

#ifndef quantlib_indexes_i
#define quantlib_indexes_i

%include Date.i
%include Calendars.i
%include DayCounters.i
%include Types.i
%include TermStructures.i
%include Null.i
%include History.i
%include String.i

%{
    typedef QuantLib::Indexes::XiborManager XiborManagerClass;
%}

class XiborManagerClass {
  public:
    XiborManagerClass();
    ~XiborManagerClass();
    void setHistory(String name, History termStructure);
    History getHistory(String name);
    bool hasHistory(String name);
    StringVector histories();
};

%inline %{
    XiborManagerClass XiborManager;
%}


// base index class

%{
using QuantLib::Handle;
using QuantLib::Index;
typedef Handle<Index> IndexHandle;
%}

// export Handle<Index>
%name(Index) class IndexHandle {
  private:
    // abstract class - no constructor exported
    IndexHandle();
  public:
    ~IndexHandle();
};

// replicate the Index interface
%addmethods IndexHandle {
    Rate fixing(Date fixingDate) {
        return (*self)->fixing(fixingDate);
    }
    String name() {
        return (*self)->name();
    }
    String __str__() {
        if (!self->isNull())
            return (*self)->name()+" index";
        else
            return "Null index";
    }
}

// typemap None to null index handle

AllowNoneAsInput(IndexHandle,Index);


// Xibor indexes
%{
using QuantLib::Indexes::Xibor;
using QuantLib::Indexes::Euribor;
using QuantLib::Indexes::AUDLibor;
using QuantLib::Indexes::GBPLibor;
using QuantLib::Indexes::USDLibor;
using QuantLib::Indexes::JPYLibor;
using QuantLib::Indexes::CADLibor;
using QuantLib::Indexes::CHFLibor;
using QuantLib::Indexes::ZARLibor;
typedef Handle<Xibor> XiborHandle;
%}

// fake inheritance between handles
%name(Xibor) class XiborHandle : public IndexHandle {
  public:
    // constructor defined below as string-based factory
    ~XiborHandle();
};

// replicate the Xibor interface
%addmethods XiborHandle {
    XiborHandle(String name, int n, TimeUnit units,
                TermStructureRelinkableHandle h) {
        String s = StringFormatter::toLowercase(name);
        if (s == "euribor")
            return new XiborHandle(new Euribor(n,units,h));
        else if (s == "audlibor")
            return new XiborHandle(new AUDLibor(n,units,h));
        else if (s == "gbplibor")
            return new XiborHandle(new GBPLibor(n,units,h));
        else if (s == "usdlibor")
            return new XiborHandle(new USDLibor(n,units,h));
        else if (s == "jpylibor")
            return new XiborHandle(new JPYLibor(n,units,h));
        else if (s == "cadlibor")
            return new XiborHandle(new CADLibor(n,units,h));
        else if (s == "chflibor")
            return new XiborHandle(new CHFLibor(n,units,h));
        else if (s == "zarlibor")
            return new XiborHandle(new ZARLibor(n,units,h));
        else
            throw Error("unknown index: " + name);
        QL_DUMMY_RETURN(new XiborHandle);
    }
    Period tenor() {
        return (*self)->tenor();
    }
    Currency currency() {
        return (*self)->currency();
    }
    Calendar calendar() {
        return (*self)->calendar();
    }
    bool isAdjusted() {
        return (*self)->isAdjusted();
    }
    RollingConvention rollingConvention() {
        return (*self)->rollingConvention();
    }
    DayCounter dayCounter() {
        return (*self)->dayCounter();
    }
}



%{
XiborHandle NewEuribor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new Euribor(n,units,h)); }
XiborHandle NewAUDLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new AUDLibor(n,units,h)); }
XiborHandle NewGBPLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new GBPLibor(n,units,h)); }
XiborHandle NewUSDLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new USDLibor(n,units,h)); }
XiborHandle NewJPYLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new JPYLibor(n,units,h)); }
XiborHandle NewCADLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new CADLibor(n,units,h)); }
XiborHandle NewCHFLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new CHFLibor(n,units,h)); }
XiborHandle NewZARLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new ZARLibor(n,units,h)); }
%}

%name(Euribor)  XiborHandle NewEuribor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);
%name(AUDLibor) XiborHandle NewAUDLibor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);
%name(GBPLibor) XiborHandle NewGBPLibor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);
%name(USDLibor) XiborHandle NewUSDLibor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);
%name(JPYLibor) XiborHandle NewJPYLibor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);
%name(CADLibor) XiborHandle NewCADLibor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);
%name(CHFLibor) XiborHandle NewCHFLibor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);
%name(ZARLibor) XiborHandle NewZARLibor(int n, TimeUnit units,
                    TermStructureRelinkableHandle h);


#endif
