/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMWindow.h"

#include <wtf/GetPtr.h>

#include "BarInfo.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSRuleList.h"
#include "CSSStyleDeclaration.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "Document.h"
#include "Element.h"
#include "History.h"
#include "JSAttr.h"
#include "JSBarInfo.h"
#include "JSCDATASection.h"
#include "JSCSSCharsetRule.h"
#include "JSCSSFontFaceRule.h"
#include "JSCSSImportRule.h"
#include "JSCSSMediaRule.h"
#include "JSCSSPageRule.h"
#include "JSCSSPrimitiveValue.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSStyleRule.h"
#include "JSCSSStyleSheet.h"
#include "JSCSSValue.h"
#include "JSCSSValueList.h"
#include "JSCharacterData.h"
#include "JSComment.h"
#include "JSCounter.h"
#include "JSDOMImplementation.h"
#include "JSDOMParser.h"
#include "JSDOMSelection.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntity.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSHTMLAnchorElement.h"
#include "JSHTMLAppletElement.h"
#include "JSHTMLAreaElement.h"
#include "JSHTMLBRElement.h"
#include "JSHTMLBaseElement.h"
#include "JSHTMLBaseFontElement.h"
#include "JSHTMLBlockquoteElement.h"
#include "JSHTMLBodyElement.h"
#include "JSHTMLButtonElement.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLDListElement.h"
#include "JSHTMLDirectoryElement.h"
#include "JSHTMLDivElement.h"
#include "JSHTMLDocument.h"
#include "JSHTMLElement.h"
#include "JSHTMLEmbedElement.h"
#include "JSHTMLFieldSetElement.h"
#include "JSHTMLFontElement.h"
#include "JSHTMLFormElement.h"
#include "JSHTMLFrameElement.h"
#include "JSHTMLFrameSetElement.h"
#include "JSHTMLHRElement.h"
#include "JSHTMLHeadElement.h"
#include "JSHTMLHeadingElement.h"
#include "JSHTMLHtmlElement.h"
#include "JSHTMLIFrameElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLInputElement.h"
#include "JSHTMLIsIndexElement.h"
#include "JSHTMLLIElement.h"
#include "JSHTMLLabelElement.h"
#include "JSHTMLLegendElement.h"
#include "JSHTMLLinkElement.h"
#include "JSHTMLMapElement.h"
#include "JSHTMLMarqueeElement.h"
#include "JSHTMLMenuElement.h"
#include "JSHTMLMetaElement.h"
#include "JSHTMLModElement.h"
#include "JSHTMLOListElement.h"
#include "JSHTMLObjectElement.h"
#include "JSHTMLOptGroupElement.h"
#include "JSHTMLOptionElement.h"
#include "JSHTMLParagraphElement.h"
#include "JSHTMLParamElement.h"
#include "JSHTMLPreElement.h"
#include "JSHTMLQuoteElement.h"
#include "JSHTMLScriptElement.h"
#include "JSHTMLSelectElement.h"
#include "JSHTMLStyleElement.h"
#include "JSHTMLTableCaptionElement.h"
#include "JSHTMLTableCellElement.h"
#include "JSHTMLTableColElement.h"
#include "JSHTMLTableElement.h"
#include "JSHTMLTableRowElement.h"
#include "JSHTMLTableSectionElement.h"
#include "JSHTMLTextAreaElement.h"
#include "JSHTMLTitleElement.h"
#include "JSHTMLUListElement.h"
#include "JSHistory.h"
#include "JSMediaList.h"
#include "JSMutationEvent.h"
#include "JSNamedNodeMap.h"
#include "JSNavigator.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeList.h"
#include "JSNotation.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSRangeException.h"
#include "JSRect.h"
#include "JSScreen.h"
#include "JSStyleSheet.h"
#include "JSText.h"
#include "JSXMLSerializer.h"
#include "JSXPathEvaluator.h"
#include "JSXPathResult.h"
#include "Navigator.h"
#include "PlatformString.h"
#include "Screen.h"
#include "kjs_dom.h"
#include "kjs_window.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDOMWindowTableEntries[] =
{
    { "navigator", JSDOMWindow::NavigatorAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "screenX", JSDOMWindow::ScreenXAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[177] },
    { "Document", JSDOMWindow::DocumentConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[173] },
    { 0, 0, 0, 0, 0 },
    { "HTMLTableRowElement", JSDOMWindow::HTMLTableRowElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "CSSPrimitiveValue", JSDOMWindow::CSSPrimitiveValueConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[187] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "statusbar", JSDOMWindow::StatusbarAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[158] },
    { "outerWidth", JSDOMWindow::OuterWidthAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[142] },
    { "defaultstatus", JSDOMWindow::DefaultstatusAttrNum, DontDelete, 0, 0 },
    { "frameElement", JSDOMWindow::FrameElementAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[179] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLModElement", JSDOMWindow::HTMLModElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLDocument", JSDOMWindow::HTMLDocumentConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[174] },
    { 0, 0, 0, 0, 0 },
    { "HTMLOptionElement", JSDOMWindow::HTMLOptionElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "CSSStyleDeclaration", JSDOMWindow::CSSStyleDeclarationConstructorAttrNum, DontDelete, 0, 0 },
    { "StyleSheet", JSDOMWindow::StyleSheetConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[150] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLBaseFontElement", JSDOMWindow::HTMLBaseFontElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[188] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "clientInformation", JSDOMWindow::ClientInformationAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLOptGroupElement", JSDOMWindow::HTMLOptGroupElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "screenLeft", JSDOMWindow::ScreenLeftAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "MediaList", JSDOMWindow::MediaListConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[155] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "pageYOffset", JSDOMWindow::PageYOffsetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "HTMLBodyElement", JSDOMWindow::HTMLBodyElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[191] },
    { "HTMLDListElement", JSDOMWindow::HTMLDListElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[185] },
    { "NamedNodeMap", JSDOMWindow::NamedNodeMapConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLBlockquoteElement", JSDOMWindow::HTMLBlockquoteElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLLegendElement", JSDOMWindow::HTMLLegendElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLFormElement", JSDOMWindow::HTMLFormElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLMarqueeElement", JSDOMWindow::HTMLMarqueeElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "NodeFilter", JSDOMWindow::NodeFilterConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLAreaElement", JSDOMWindow::HTMLAreaElementConstructorAttrNum, DontDelete, 0, 0 },
    { "screenTop", JSDOMWindow::ScreenTopAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[164] },
    { 0, 0, 0, 0, 0 },
    { "window", JSDOMWindow::WindowAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[147] },
    { "HTMLHtmlElement", JSDOMWindow::HTMLHtmlElementConstructorAttrNum, DontDelete, 0, 0 },
    { "locationbar", JSDOMWindow::LocationbarAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "personalbar", JSDOMWindow::PersonalbarAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[148] },
    { "name", JSDOMWindow::NameAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[152] },
    { "HTMLFontElement", JSDOMWindow::HTMLFontElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLFieldSetElement", JSDOMWindow::HTMLFieldSetElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[165] },
    { "screen", JSDOMWindow::ScreenAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "Notation", JSDOMWindow::NotationConstructorAttrNum, DontDelete, 0, 0 },
    { "history", JSDOMWindow::HistoryAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "status", JSDOMWindow::StatusAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "CSSCharsetRule", JSDOMWindow::CSSCharsetRuleConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[190] },
    { "HTMLMetaElement", JSDOMWindow::HTMLMetaElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "closed", JSDOMWindow::ClosedAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[159] },
    { "HTMLDivElement", JSDOMWindow::HTMLDivElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "DOMParser", JSDOMWindow::DOMParserConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "CSSValue", JSDOMWindow::CSSValueConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[161] },
    { "scrollY", JSDOMWindow::ScrollYAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[143] },
    { "self", JSDOMWindow::SelfAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[170] },
    { "parent", JSDOMWindow::ParentAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[144] },
    { "opener", JSDOMWindow::OpenerAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[146] },
    { "outerHeight", JSDOMWindow::OuterHeightAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[141] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLElement", JSDOMWindow::HTMLElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "Rect", JSDOMWindow::RectConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[163] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLTableElement", JSDOMWindow::HTMLTableElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[192] },
    { 0, 0, 0, 0, 0 },
    { "Text", JSDOMWindow::TextConstructorAttrNum, DontDelete, 0, 0 },
    { "menubar", JSDOMWindow::MenubarAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[140] },
    { 0, 0, 0, 0, 0 },
    { "DocumentFragment", JSDOMWindow::DocumentFragmentConstructorAttrNum, DontDelete, 0, 0 },
    { "document", JSDOMWindow::DocumentAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[145] },
    { "frames", JSDOMWindow::FramesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLQuoteElement", JSDOMWindow::HTMLQuoteElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[195] },
    { "HTMLButtonElement", JSDOMWindow::HTMLButtonElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[167] },
    { "devicePixelRatio", JSDOMWindow::DevicePixelRatioAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLOListElement", JSDOMWindow::HTMLOListElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLMenuElement", JSDOMWindow::HTMLMenuElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[186] },
    { "CDATASection", JSDOMWindow::CDATASectionConstructorAttrNum, DontDelete, 0, 0 },
    { "CSSRuleList", JSDOMWindow::CSSRuleListConstructorAttrNum, DontDelete, 0, 0 },
    { "screenY", JSDOMWindow::ScreenYAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "HTMLImageElement", JSDOMWindow::HTMLImageElementConstructorAttrNum, DontDelete, 0, 0 },
    { "DOMImplementation", JSDOMWindow::DOMImplementationConstructorAttrNum, DontDelete, 0, 0 },
    { "Event", JSDOMWindow::EventConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "toolbar", JSDOMWindow::ToolbarAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[162] },
    { 0, 0, 0, 0, 0 },
    { "EntityReference", JSDOMWindow::EntityReferenceConstructorAttrNum, DontDelete, 0, 0 },
    { "innerHeight", JSDOMWindow::InnerHeightAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[153] },
    { "top", JSDOMWindow::TopAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[176] },
    { "HTMLDirectoryElement", JSDOMWindow::HTMLDirectoryElementConstructorAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "offscreenBuffering", JSDOMWindow::OffscreenBufferingAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[175] },
    { 0, 0, 0, 0, 0 },
    { "HTMLStyleElement", JSDOMWindow::HTMLStyleElementConstructorAttrNum, DontDelete, 0, 0 },
    { "defaultStatus", JSDOMWindow::DefaultStatusAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[149] },
    { "scrollbars", JSDOMWindow::ScrollbarsAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[166] },
    { 0, 0, 0, 0, 0 },
    { "CharacterData", JSDOMWindow::CharacterDataConstructorAttrNum, DontDelete, 0, 0 },
    { "CSSStyleSheet", JSDOMWindow::CSSStyleSheetConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[151] },
    { "DocumentType", JSDOMWindow::DocumentTypeConstructorAttrNum, DontDelete, 0, 0 },
    { "innerWidth", JSDOMWindow::InnerWidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "scrollX", JSDOMWindow::ScrollXAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "pageXOffset", JSDOMWindow::PageXOffsetAttrNum, DontDelete|ReadOnly, 0, &JSDOMWindowTableEntries[172] },
    { "length", JSDOMWindow::LengthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "CSSValueList", JSDOMWindow::CSSValueListConstructorAttrNum, DontDelete, 0, 0 },
    { "CSSRule", JSDOMWindow::CSSRuleConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[168] },
    { "CSSFontFaceRule", JSDOMWindow::CSSFontFaceRuleConstructorAttrNum, DontDelete, 0, 0 },
    { "CSSImportRule", JSDOMWindow::CSSImportRuleConstructorAttrNum, DontDelete, 0, 0 },
    { "CSSMediaRule", JSDOMWindow::CSSMediaRuleConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[154] },
    { "CSSPageRule", JSDOMWindow::CSSPageRuleConstructorAttrNum, DontDelete, 0, 0 },
    { "CSSStyleRule", JSDOMWindow::CSSStyleRuleConstructorAttrNum, DontDelete, 0, 0 },
    { "Counter", JSDOMWindow::CounterConstructorAttrNum, DontDelete, 0, 0 },
    { "Node", JSDOMWindow::NodeConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[178] },
    { "NodeList", JSDOMWindow::NodeListConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[156] },
    { "Attr", JSDOMWindow::AttrConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[157] },
    { "Element", JSDOMWindow::ElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[160] },
    { "Comment", JSDOMWindow::CommentConstructorAttrNum, DontDelete, 0, 0 },
    { "Entity", JSDOMWindow::EntityConstructorAttrNum, DontDelete, 0, 0 },
    { "ProcessingInstruction", JSDOMWindow::ProcessingInstructionConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[194] },
    { "HTMLAnchorElement", JSDOMWindow::HTMLAnchorElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLAppletElement", JSDOMWindow::HTMLAppletElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLBRElement", JSDOMWindow::HTMLBRElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[169] },
    { "HTMLBaseElement", JSDOMWindow::HTMLBaseElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLCanvasElement", JSDOMWindow::HTMLCanvasElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLEmbedElement", JSDOMWindow::HTMLEmbedElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[171] },
    { "HTMLFrameElement", JSDOMWindow::HTMLFrameElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLFrameSetElement", JSDOMWindow::HTMLFrameSetElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[196] },
    { "HTMLHRElement", JSDOMWindow::HTMLHRElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLHeadElement", JSDOMWindow::HTMLHeadElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLHeadingElement", JSDOMWindow::HTMLHeadingElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLIFrameElement", JSDOMWindow::HTMLIFrameElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLInputElement", JSDOMWindow::HTMLInputElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[182] },
    { "HTMLIsIndexElement", JSDOMWindow::HTMLIsIndexElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLLIElement", JSDOMWindow::HTMLLIElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLLabelElement", JSDOMWindow::HTMLLabelElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[181] },
    { "HTMLLinkElement", JSDOMWindow::HTMLLinkElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLMapElement", JSDOMWindow::HTMLMapElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLObjectElement", JSDOMWindow::HTMLObjectElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[189] },
    { "HTMLParagraphElement", JSDOMWindow::HTMLParagraphElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[180] },
    { "HTMLParamElement", JSDOMWindow::HTMLParamElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLPreElement", JSDOMWindow::HTMLPreElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLScriptElement", JSDOMWindow::HTMLScriptElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLSelectElement", JSDOMWindow::HTMLSelectElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[183] },
    { "HTMLTableCaptionElement", JSDOMWindow::HTMLTableCaptionElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[184] },
    { "HTMLTableCellElement", JSDOMWindow::HTMLTableCellElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLTableColElement", JSDOMWindow::HTMLTableColElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLTableSectionElement", JSDOMWindow::HTMLTableSectionElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLTextAreaElement", JSDOMWindow::HTMLTextAreaElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLTitleElement", JSDOMWindow::HTMLTitleElementConstructorAttrNum, DontDelete, 0, 0 },
    { "HTMLUListElement", JSDOMWindow::HTMLUListElementConstructorAttrNum, DontDelete, 0, &JSDOMWindowTableEntries[193] },
    { "MutationEvent", JSDOMWindow::MutationEventConstructorAttrNum, DontDelete, 0, 0 },
    { "Range", JSDOMWindow::RangeConstructorAttrNum, DontDelete, 0, 0 },
    { "RangeException", JSDOMWindow::RangeExceptionConstructorAttrNum, DontDelete, 0, 0 },
    { "XMLDocument", JSDOMWindow::XMLDocumentConstructorAttrNum, DontDelete, 0, 0 },
    { "XMLSerializer", JSDOMWindow::XMLSerializerConstructorAttrNum, DontDelete, 0, 0 },
    { "XPathEvaluator", JSDOMWindow::XPathEvaluatorConstructorAttrNum, DontDelete, 0, 0 },
    { "XPathResult", JSDOMWindow::XPathResultConstructorAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSDOMWindowTable = 
{
    2, 197, JSDOMWindowTableEntries, 140
};

/* Hash table for prototype */

static const HashEntry JSDOMWindowPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "alert", JSDOMWindow::AlertFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "blur", JSDOMWindow::BlurFuncNum, DontDelete|Function, 0, 0 },
    { "getSelection", JSDOMWindow::GetSelectionFuncNum, DontDelete|Function, 0, &JSDOMWindowPrototypeTableEntries[14] },
    { "find", JSDOMWindow::FindFuncNum, DontDelete|Function, 7, 0 },
    { "close", JSDOMWindow::CloseFuncNum, DontDelete|Function, 0, &JSDOMWindowPrototypeTableEntries[12] },
    { "getComputedStyle", JSDOMWindow::GetComputedStyleFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "focus", JSDOMWindow::FocusFuncNum, DontDelete|Function, 0, &JSDOMWindowPrototypeTableEntries[13] },
    { "prompt", JSDOMWindow::PromptFuncNum, DontDelete|Function, 2, 0 },
    { "print", JSDOMWindow::PrintFuncNum, DontDelete|Function, 0, 0 },
    { "stop", JSDOMWindow::StopFuncNum, DontDelete|Function, 0, 0 },
    { "confirm", JSDOMWindow::ConfirmFuncNum, DontDelete|Function, 1, &JSDOMWindowPrototypeTableEntries[15] },
    { "getMatchedCSSRules", JSDOMWindow::GetMatchedCSSRulesFuncNum, DontDelete|Function, 3, 0 }
};

static const HashTable JSDOMWindowPrototypeTable = 
{
    2, 16, JSDOMWindowPrototypeTableEntries, 12
};

const ClassInfo JSDOMWindowPrototype::info = { "DOMWindowPrototype", 0, &JSDOMWindowPrototypeTable, 0 };

JSObject* JSDOMWindowPrototype::self()
{
    return new JSDOMWindowPrototype();
}

bool JSDOMWindowPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSDOMWindowPrototypeFunction, JSObject>(exec, &JSDOMWindowPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMWindow::info = { "DOMWindow", &KJS::Window::info, &JSDOMWindowTable, 0 };

JSDOMWindow::JSDOMWindow(DOMWindow* impl)
    : KJS::Window(impl)
{
    setPrototype(JSDOMWindowPrototype::self());
}

bool JSDOMWindow::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSDOMWindow, KJS::Window>(exec, &JSDOMWindowTable, this, propertyName, slot);
}

JSValue* JSDOMWindow::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ScreenAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->screen()));
    }
    case HistoryAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->history()));
    }
    case LocationbarAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->locationbar()));
    }
    case MenubarAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->menubar()));
    }
    case PersonalbarAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->personalbar()));
    }
    case ScrollbarsAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->scrollbars()));
    }
    case StatusbarAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->statusbar()));
    }
    case ToolbarAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->toolbar()));
    }
    case NavigatorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->navigator()));
    }
    case ClientInformationAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->clientInformation()));
    }
    case FrameElementAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return checkNodeSecurity(exec, imp->frameElement()) ? toJS(exec, WTF::getPtr(imp->frameElement())) : jsUndefined();
    }
    case OffscreenBufferingAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsBoolean(imp->offscreenBuffering());
    }
    case OuterHeightAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->outerHeight());
    }
    case OuterWidthAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->outerWidth());
    }
    case InnerHeightAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->innerHeight());
    }
    case InnerWidthAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->innerWidth());
    }
    case ScreenXAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->screenX());
    }
    case ScreenYAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->screenY());
    }
    case ScreenLeftAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->screenLeft());
    }
    case ScreenTopAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->screenTop());
    }
    case ScrollXAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->scrollX());
    }
    case ScrollYAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->scrollY());
    }
    case PageXOffsetAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->pageXOffset());
    }
    case PageYOffsetAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->pageYOffset());
    }
    case ClosedAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsBoolean(imp->closed());
    }
    case LengthAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->length());
    }
    case NameAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsString(imp->name());
    }
    case StatusAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsString(imp->status());
    }
    case DefaultStatusAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsString(imp->defaultStatus());
    }
    case DefaultstatusAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsString(imp->defaultstatus());
    }
    case SelfAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->self()));
    }
    case WindowAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->window()));
    }
    case FramesAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->frames()));
    }
    case OpenerAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->opener()));
    }
    case ParentAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->parent()));
    }
    case TopAttrNum: {
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->top()));
    }
    case DocumentAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return toJS(exec, WTF::getPtr(imp->document()));
    }
    case DevicePixelRatioAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        return jsNumber(imp->devicePixelRatio());
    }
    case StyleSheetConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSStyleSheet::getConstructor(exec);
    }
    case CSSStyleSheetConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSStyleSheet::getConstructor(exec);
    }
    case CSSValueConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSValue::getConstructor(exec);
    }
    case CSSPrimitiveValueConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSPrimitiveValue::getConstructor(exec);
    }
    case CSSValueListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSValueList::getConstructor(exec);
    }
    case CSSRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSRule::getConstructor(exec);
    }
    case CSSCharsetRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSCharsetRule::getConstructor(exec);
    }
    case CSSFontFaceRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSFontFaceRule::getConstructor(exec);
    }
    case CSSImportRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSImportRule::getConstructor(exec);
    }
    case CSSMediaRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSMediaRule::getConstructor(exec);
    }
    case CSSPageRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSPageRule::getConstructor(exec);
    }
    case CSSStyleRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSStyleRule::getConstructor(exec);
    }
    case CSSStyleDeclarationConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSStyleDeclaration::getConstructor(exec);
    }
    case MediaListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSMediaList::getConstructor(exec);
    }
    case CounterConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCounter::getConstructor(exec);
    }
    case CSSRuleListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCSSRuleList::getConstructor(exec);
    }
    case RectConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSRect::getConstructor(exec);
    }
    case DOMImplementationConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSDOMImplementation::getConstructor(exec);
    }
    case DocumentFragmentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSDocumentFragment::getConstructor(exec);
    }
    case DocumentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSDocument::getConstructor(exec);
    }
    case NodeConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSNode::getConstructor(exec);
    }
    case NodeListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSNodeList::getConstructor(exec);
    }
    case NamedNodeMapConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSNamedNodeMap::getConstructor(exec);
    }
    case CharacterDataConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCharacterData::getConstructor(exec);
    }
    case AttrConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSAttr::getConstructor(exec);
    }
    case ElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSElement::getConstructor(exec);
    }
    case TextConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSText::getConstructor(exec);
    }
    case CommentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSComment::getConstructor(exec);
    }
    case CDATASectionConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSCDATASection::getConstructor(exec);
    }
    case DocumentTypeConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSDocumentType::getConstructor(exec);
    }
    case NotationConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSNotation::getConstructor(exec);
    }
    case EntityConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSEntity::getConstructor(exec);
    }
    case EntityReferenceConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSEntityReference::getConstructor(exec);
    }
    case ProcessingInstructionConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSProcessingInstruction::getConstructor(exec);
    }
    case HTMLDocumentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLDocument::getConstructor(exec);
    }
    case HTMLElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLElement::getConstructor(exec);
    }
    case HTMLAnchorElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLAnchorElement::getConstructor(exec);
    }
    case HTMLAppletElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLAppletElement::getConstructor(exec);
    }
    case HTMLAreaElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLAreaElement::getConstructor(exec);
    }
    case HTMLBRElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLBRElement::getConstructor(exec);
    }
    case HTMLBaseElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLBaseElement::getConstructor(exec);
    }
    case HTMLBaseFontElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLBaseFontElement::getConstructor(exec);
    }
    case HTMLBlockquoteElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLBlockquoteElement::getConstructor(exec);
    }
    case HTMLBodyElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLBodyElement::getConstructor(exec);
    }
    case HTMLButtonElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLButtonElement::getConstructor(exec);
    }
    case HTMLCanvasElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLCanvasElement::getConstructor(exec);
    }
    case HTMLDListElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLDListElement::getConstructor(exec);
    }
    case HTMLDirectoryElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLDirectoryElement::getConstructor(exec);
    }
    case HTMLDivElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLDivElement::getConstructor(exec);
    }
    case HTMLEmbedElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLEmbedElement::getConstructor(exec);
    }
    case HTMLFieldSetElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLFieldSetElement::getConstructor(exec);
    }
    case HTMLFontElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLFontElement::getConstructor(exec);
    }
    case HTMLFormElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLFormElement::getConstructor(exec);
    }
    case HTMLFrameElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLFrameElement::getConstructor(exec);
    }
    case HTMLFrameSetElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLFrameSetElement::getConstructor(exec);
    }
    case HTMLHRElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLHRElement::getConstructor(exec);
    }
    case HTMLHeadElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLHeadElement::getConstructor(exec);
    }
    case HTMLHeadingElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLHeadingElement::getConstructor(exec);
    }
    case HTMLHtmlElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLHtmlElement::getConstructor(exec);
    }
    case HTMLIFrameElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLIFrameElement::getConstructor(exec);
    }
    case HTMLImageElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLImageElement::getConstructor(exec);
    }
    case HTMLInputElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLInputElement::getConstructor(exec);
    }
    case HTMLIsIndexElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLIsIndexElement::getConstructor(exec);
    }
    case HTMLLIElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLLIElement::getConstructor(exec);
    }
    case HTMLLabelElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLLabelElement::getConstructor(exec);
    }
    case HTMLLegendElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLLegendElement::getConstructor(exec);
    }
    case HTMLLinkElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLLinkElement::getConstructor(exec);
    }
    case HTMLMapElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLMapElement::getConstructor(exec);
    }
    case HTMLMarqueeElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLMarqueeElement::getConstructor(exec);
    }
    case HTMLMenuElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLMenuElement::getConstructor(exec);
    }
    case HTMLMetaElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLMetaElement::getConstructor(exec);
    }
    case HTMLModElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLModElement::getConstructor(exec);
    }
    case HTMLOListElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLOListElement::getConstructor(exec);
    }
    case HTMLObjectElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLObjectElement::getConstructor(exec);
    }
    case HTMLOptGroupElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLOptGroupElement::getConstructor(exec);
    }
    case HTMLOptionElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLOptionElement::getConstructor(exec);
    }
    case HTMLParagraphElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLParagraphElement::getConstructor(exec);
    }
    case HTMLParamElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLParamElement::getConstructor(exec);
    }
    case HTMLPreElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLPreElement::getConstructor(exec);
    }
    case HTMLQuoteElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLQuoteElement::getConstructor(exec);
    }
    case HTMLScriptElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLScriptElement::getConstructor(exec);
    }
    case HTMLSelectElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLSelectElement::getConstructor(exec);
    }
    case HTMLStyleElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLStyleElement::getConstructor(exec);
    }
    case HTMLTableCaptionElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTableCaptionElement::getConstructor(exec);
    }
    case HTMLTableCellElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTableCellElement::getConstructor(exec);
    }
    case HTMLTableColElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTableColElement::getConstructor(exec);
    }
    case HTMLTableElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTableElement::getConstructor(exec);
    }
    case HTMLTableRowElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTableRowElement::getConstructor(exec);
    }
    case HTMLTableSectionElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTableSectionElement::getConstructor(exec);
    }
    case HTMLTextAreaElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTextAreaElement::getConstructor(exec);
    }
    case HTMLTitleElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLTitleElement::getConstructor(exec);
    }
    case HTMLUListElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSHTMLUListElement::getConstructor(exec);
    }
    case EventConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSEvent::getConstructor(exec);
    }
    case MutationEventConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSMutationEvent::getConstructor(exec);
    }
    case NodeFilterConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSNodeFilter::getConstructor(exec);
    }
    case RangeConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSRange::getConstructor(exec);
    }
    case RangeExceptionConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSRangeException::getConstructor(exec);
    }
    case XMLDocumentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSDocument::getConstructor(exec);
    }
    case DOMParserConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSDOMParser::getConstructor(exec);
    }
    case XMLSerializerConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSXMLSerializer::getConstructor(exec);
    }
    case XPathEvaluatorConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSXPathEvaluator::getConstructor(exec);
    }
    case XPathResultConstructorAttrNum: {
        if (!isSafeScript(exec))
            return jsUndefined();
        return JSXPathResult::getConstructor(exec);
    }
    }
    return 0;
}

void JSDOMWindow::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    if (customPut(exec, propertyName, value, attr))
        return;
    lookupPut<JSDOMWindow, KJS::Window>(exec, propertyName, value, attr, &JSDOMWindowTable, this);
}

void JSDOMWindow::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case NameAttrNum: {
        if (!isSafeScript(exec))
            return;
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        imp->setName(value->toString(exec));
        break;
    }
    case StatusAttrNum: {
        if (!isSafeScript(exec))
            return;
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        imp->setStatus(value->toString(exec));
        break;
    }
    case DefaultStatusAttrNum: {
        if (!isSafeScript(exec))
            return;
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        imp->setDefaultStatus(value->toString(exec));
        break;
    }
    case DefaultstatusAttrNum: {
        if (!isSafeScript(exec))
            return;
        DOMWindow* imp = static_cast<DOMWindow*>(impl());

        imp->setDefaultstatus(value->toString(exec));
        break;
    }
    case StyleSheetConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "StyleSheet", value);
        break;
    }
    case CSSStyleSheetConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSStyleSheet", value);
        break;
    }
    case CSSValueConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSValue", value);
        break;
    }
    case CSSPrimitiveValueConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSPrimitiveValue", value);
        break;
    }
    case CSSValueListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSValueList", value);
        break;
    }
    case CSSRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSRule", value);
        break;
    }
    case CSSCharsetRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSCharsetRule", value);
        break;
    }
    case CSSFontFaceRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSFontFaceRule", value);
        break;
    }
    case CSSImportRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSImportRule", value);
        break;
    }
    case CSSMediaRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSMediaRule", value);
        break;
    }
    case CSSPageRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSPageRule", value);
        break;
    }
    case CSSStyleRuleConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSStyleRule", value);
        break;
    }
    case CSSStyleDeclarationConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSStyleDeclaration", value);
        break;
    }
    case MediaListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "MediaList", value);
        break;
    }
    case CounterConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Counter", value);
        break;
    }
    case CSSRuleListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CSSRuleList", value);
        break;
    }
    case RectConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Rect", value);
        break;
    }
    case DOMImplementationConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "DOMImplementation", value);
        break;
    }
    case DocumentFragmentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "DocumentFragment", value);
        break;
    }
    case DocumentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Document", value);
        break;
    }
    case NodeConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Node", value);
        break;
    }
    case NodeListConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "NodeList", value);
        break;
    }
    case NamedNodeMapConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "NamedNodeMap", value);
        break;
    }
    case CharacterDataConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CharacterData", value);
        break;
    }
    case AttrConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Attr", value);
        break;
    }
    case ElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Element", value);
        break;
    }
    case TextConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Text", value);
        break;
    }
    case CommentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Comment", value);
        break;
    }
    case CDATASectionConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "CDATASection", value);
        break;
    }
    case DocumentTypeConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "DocumentType", value);
        break;
    }
    case NotationConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Notation", value);
        break;
    }
    case EntityConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Entity", value);
        break;
    }
    case EntityReferenceConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "EntityReference", value);
        break;
    }
    case ProcessingInstructionConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "ProcessingInstruction", value);
        break;
    }
    case HTMLDocumentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLDocument", value);
        break;
    }
    case HTMLElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLElement", value);
        break;
    }
    case HTMLAnchorElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLAnchorElement", value);
        break;
    }
    case HTMLAppletElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLAppletElement", value);
        break;
    }
    case HTMLAreaElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLAreaElement", value);
        break;
    }
    case HTMLBRElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLBRElement", value);
        break;
    }
    case HTMLBaseElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLBaseElement", value);
        break;
    }
    case HTMLBaseFontElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLBaseFontElement", value);
        break;
    }
    case HTMLBlockquoteElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLBlockquoteElement", value);
        break;
    }
    case HTMLBodyElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLBodyElement", value);
        break;
    }
    case HTMLButtonElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLButtonElement", value);
        break;
    }
    case HTMLCanvasElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLCanvasElement", value);
        break;
    }
    case HTMLDListElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLDListElement", value);
        break;
    }
    case HTMLDirectoryElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLDirectoryElement", value);
        break;
    }
    case HTMLDivElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLDivElement", value);
        break;
    }
    case HTMLEmbedElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLEmbedElement", value);
        break;
    }
    case HTMLFieldSetElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLFieldSetElement", value);
        break;
    }
    case HTMLFontElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLFontElement", value);
        break;
    }
    case HTMLFormElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLFormElement", value);
        break;
    }
    case HTMLFrameElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLFrameElement", value);
        break;
    }
    case HTMLFrameSetElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLFrameSetElement", value);
        break;
    }
    case HTMLHRElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLHRElement", value);
        break;
    }
    case HTMLHeadElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLHeadElement", value);
        break;
    }
    case HTMLHeadingElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLHeadingElement", value);
        break;
    }
    case HTMLHtmlElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLHtmlElement", value);
        break;
    }
    case HTMLIFrameElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLIFrameElement", value);
        break;
    }
    case HTMLImageElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLImageElement", value);
        break;
    }
    case HTMLInputElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLInputElement", value);
        break;
    }
    case HTMLIsIndexElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLIsIndexElement", value);
        break;
    }
    case HTMLLIElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLLIElement", value);
        break;
    }
    case HTMLLabelElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLLabelElement", value);
        break;
    }
    case HTMLLegendElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLLegendElement", value);
        break;
    }
    case HTMLLinkElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLLinkElement", value);
        break;
    }
    case HTMLMapElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLMapElement", value);
        break;
    }
    case HTMLMarqueeElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLMarqueeElement", value);
        break;
    }
    case HTMLMenuElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLMenuElement", value);
        break;
    }
    case HTMLMetaElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLMetaElement", value);
        break;
    }
    case HTMLModElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLModElement", value);
        break;
    }
    case HTMLOListElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLOListElement", value);
        break;
    }
    case HTMLObjectElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLObjectElement", value);
        break;
    }
    case HTMLOptGroupElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLOptGroupElement", value);
        break;
    }
    case HTMLOptionElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLOptionElement", value);
        break;
    }
    case HTMLParagraphElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLParagraphElement", value);
        break;
    }
    case HTMLParamElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLParamElement", value);
        break;
    }
    case HTMLPreElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLPreElement", value);
        break;
    }
    case HTMLQuoteElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLQuoteElement", value);
        break;
    }
    case HTMLScriptElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLScriptElement", value);
        break;
    }
    case HTMLSelectElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLSelectElement", value);
        break;
    }
    case HTMLStyleElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLStyleElement", value);
        break;
    }
    case HTMLTableCaptionElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTableCaptionElement", value);
        break;
    }
    case HTMLTableCellElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTableCellElement", value);
        break;
    }
    case HTMLTableColElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTableColElement", value);
        break;
    }
    case HTMLTableElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTableElement", value);
        break;
    }
    case HTMLTableRowElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTableRowElement", value);
        break;
    }
    case HTMLTableSectionElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTableSectionElement", value);
        break;
    }
    case HTMLTextAreaElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTextAreaElement", value);
        break;
    }
    case HTMLTitleElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLTitleElement", value);
        break;
    }
    case HTMLUListElementConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "HTMLUListElement", value);
        break;
    }
    case EventConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Event", value);
        break;
    }
    case MutationEventConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "MutationEvent", value);
        break;
    }
    case NodeFilterConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "NodeFilter", value);
        break;
    }
    case RangeConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "Range", value);
        break;
    }
    case RangeExceptionConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "RangeException", value);
        break;
    }
    case XMLDocumentConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "XMLDocument", value);
        break;
    }
    case DOMParserConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "DOMParser", value);
        break;
    }
    case XMLSerializerConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "XMLSerializer", value);
        break;
    }
    case XPathEvaluatorConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "XPathEvaluator", value);
        break;
    }
    case XPathResultConstructorAttrNum: {
        if (!isSafeScript(exec))
            return;
        // Shadowing a built-in constructor
        JSObject::put(exec, "XPathResult", value);
        break;
    }
    }
}

JSValue* JSDOMWindowPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMWindow::info))
      return throwError(exec, TypeError);

    DOMWindow* imp = static_cast<DOMWindow*>(static_cast<JSDOMWindow*>(thisObj)->impl());

    switch (id) {
    case JSDOMWindow::GetSelectionFuncNum: {


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getSelection()));
        return result;
    }
    case JSDOMWindow::FocusFuncNum: {

        imp->focus();
        return jsUndefined();
    }
    case JSDOMWindow::BlurFuncNum: {

        imp->blur();
        return jsUndefined();
    }
    case JSDOMWindow::CloseFuncNum: {

        imp->close();
        return jsUndefined();
    }
    case JSDOMWindow::PrintFuncNum: {

        imp->print();
        return jsUndefined();
    }
    case JSDOMWindow::StopFuncNum: {

        imp->stop();
        return jsUndefined();
    }
    case JSDOMWindow::AlertFuncNum: {
        String message = valueToStringWithUndefinedOrNullCheck(exec, args[0]);

        imp->alert(message);
        return jsUndefined();
    }
    case JSDOMWindow::ConfirmFuncNum: {
        String message = valueToStringWithUndefinedOrNullCheck(exec, args[0]);


        KJS::JSValue* result = jsBoolean(imp->confirm(message));
        return result;
    }
    case JSDOMWindow::PromptFuncNum: {
        String message = valueToStringWithUndefinedOrNullCheck(exec, args[0]);
        String defaultValue = valueToStringWithUndefinedOrNullCheck(exec, args[1]);


        KJS::JSValue* result = jsStringOrNull(imp->prompt(message, defaultValue));
        return result;
    }
    case JSDOMWindow::FindFuncNum: {
        String string = args[0]->toString(exec);
        bool caseSensitive = args[1]->toBoolean(exec);
        bool backwards = args[2]->toBoolean(exec);
        bool wrap = args[3]->toBoolean(exec);
        bool wholeWord = args[4]->toBoolean(exec);
        bool searchInFrames = args[5]->toBoolean(exec);
        bool showDialog = args[6]->toBoolean(exec);


        KJS::JSValue* result = jsBoolean(imp->find(string, caseSensitive, backwards, wrap, wholeWord, searchInFrames, showDialog));
        return result;
    }
    case JSDOMWindow::GetComputedStyleFuncNum: {
        Element* element = toElement(args[0]);
        String pseudoElement = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getComputedStyle(element, pseudoElement)));
        return result;
    }
    case JSDOMWindow::GetMatchedCSSRulesFuncNum: {
        Element* element = toElement(args[0]);
        String pseudoElement = args[1]->toString(exec);

        int argsCount = args.size();
        if (argsCount < 3) {

            KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getMatchedCSSRules(element, pseudoElement)));
            return result;
        }

        bool authorOnly = args[2]->toBoolean(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getMatchedCSSRules(element, pseudoElement, authorOnly)));
        return result;
    }
    }
    return 0;
}
DOMWindow* toDOMWindow(KJS::JSValue* val)
{
    return val->isObject(&JSDOMWindow::info) ? static_cast<JSDOMWindow*>(val)->impl() : 0;
}

DOMWindow* JSDOMWindow::impl() const
{
    return static_cast<DOMWindow*>(KJS::Window::impl());
}

}
