/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef __SYNTP_H
#define __SYNTP_H

#include <qobject.h>

#include <iostream>
#include <map>


class SynTouchPad : public QObject
{
    Q_OBJECT
    
public:

//
// that type exchanges data between GUI and touch pad
//
typedef std::map<std::string, float> SynParam;



SynTouchPad();
~SynTouchPad();

//
// checks on synaptics driver installation
// NB: checks on synclient, since /var/log/* isn't 
//     readable on every system and we need that tool anyways!
//     ...would be better to check on the module as well..
//
bool hasSynaptics();

//
// checks on syndaemon
//
bool hasSynDaemon();


//
// detects XFree86 version
//
char *detectXFree86Version();

//
// detect Synaptics Driver version
//
char *detectSynapticsVersion();

//
// checks on SHM configuration ability
//
bool hasSHMConfigurability();

//
// disables touch pad immediately
//
bool disableTP();

//
// enable touch pad immediately
//
bool enableTP();


//
// restores some stored system settings to HW
//
bool restoreConfig();

//
// checks whether the given parameter is a custom parameter or not
// NB: custom parameters are those that aren't used by the synclient directly
//
bool isCustomParameter(std::string paramName);


signals:

//
// is emitted, when there's changed data the user may commit
//
void settingsChanged();


public slots:

//
// apply all temporary changes
//
bool applyConfig();

//
// apply and store all changes
//
bool applyAndStoreConfig();

//
// reject all temporary changes
//
bool cancelConfig();


//
// gets a certain touch pad parameter setting
//
float getParameter(std::string paramName);

//
// sets a certain touch pad parameter
// 
bool setParameter(std::string paramName, float param);


private:

//
// gets actual syndaemon timing 
// in seconds
//
float getSynDaemonTiming();

//
// applies the changed timing settings stored in delay
//
bool applySynDaemonTiming(float delay);


//
// applies a bunch of parameters directly to the touch pad
//
bool apply(SynParam param);


//
// stores the actual system settings
//
void storeConfig(SynParam &param);

//
// returns whether the given parameter maps are different or identical
//
bool isEqual(SynParam &a, SynParam &b);

//
// returns whether a is a subset of b
//
bool isSubset(SynParam &a, SynParam &b);

//
// important variables
//

SynParam myDefaultConfig;
SynParam myPrevConfig;
SynParam myConfig;

std::string cfgFN;
};

#endif
