/**************************************************************************
*   Copyright (C) 2000-2012 by Johan Maes                                 *
*   on4qz@telenet.be                                                      *
*   http://users.telenet.be/on4qz                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include "qsstvglobal.h"


#include <QString>
#include <QPixmap>




const QString MAJORVERSION  = "8.2";
const QString CONFIGVERSION = "8.1";
const QString MINORVERSION  = ".7";
const QString LOGVERSION = ("qsstv."+MAJORVERSION+MINORVERSION+".log");
const QString ORGANIZATION = "ON4QZ";
const QString APPLICATION  = ("qsstv" +CONFIGVERSION);
const QString qsstvVersion=QString("QSSTV " + MAJORVERSION+MINORVERSION);


QByteArray *debugPtr;
QStatusBar *statusBarPtr;
configDialog *confDiag;
#ifndef QT_NO_DEBUG
scopeView *scopeViewerData;
scopeView *scopeViewerSync;
#endif

mainWindow *mainWindowPtr;
dispatcher *dispatcherPtr;
waterfallText *waterfallPtr;
QSplashScreen *splashPtr;
QString splashStr;



QCursor *cpCursor;
logFile *logfile;


// for DRM
emscStatus msc_valid;
int bodyTotalSegments;
int rxSegments;
int currentSegmentNumber;
unsigned int rxTransportID;
//unsigned int bitsPerSecond;
QList<short unsigned int> drmBlockList;
sourceDecoder srcDecoder;
uint txTransportID;
QList<short unsigned int> fixBlockList;
bool stopDRM;
float avgSNR;
float lastAvgSNR;
QPixmap *greenPXM;
QPixmap *redPXM;

logBook *logBookPtr;
xmlInterface *xmlIntfPtr;


void globalInit(void)
{
  logfile=new logFile;
  logfile->open(LOGVERSION);
  QPixmap pm(":/icons/colorpicker.png");
  cpCursor=new QCursor(pm,0,pm.height()-1);

}

void globalEnd(void)
{
  logfile->close();
}

