
#ifndef Imageframe_included
#define Imageframe_included
#include <qframe.h>
#include <qimage.h>
#include <qfont.h>
#include <qfileinfo.h>
#include <qradiobutton.h>
#include <qdialog.h>
#include "pixmapview.h"
#include "posform.h"

enum eimageAlignH {LEFT,RIGHT,CENTER};
enum eimageAlignV {TOP,BOTTOM,MIDDLE};

class imagePosition : public posForm
{
    Q_OBJECT

public:
    imagePosition(QWidget *parent, const char *name);
    virtual ~imagePosition();
    eimageAlignH getHorizontalPosition();
    eimageAlignV getVerticalPosition();
    bool keepAspectRatio();
    bool scaled();
public slots:
	void slotSelectColor();
	void slotAccept();

};



class imageFrame : public pixmapView
{
    Q_OBJECT

public:

    imageFrame(QWidget* parent = NULL,const char* name = NULL);
    virtual ~imageFrame();
    void createImage(int width,int height,int NumberOfColorBits,int viewX,int viewY);
    void backup();
    void restore();
    void deleteBackup();
    void showLine(int width,int line);
    void showLine(int width,int line,int nbrlines);
    void rotate(uint len,uint nbrlines);
    void scale( int width, int height,eimageAlignH alignH,eimageAlignV alignV,int x,int y);
    bool addImage(int x,int y, QString s,int w=-1,int h=-1);
    void addString(int x,int y, QString s,const QColor &icolor=black, const QFont &ifont=QFont("Helvetica"));
    uint *getLineAddress(int line);
    void imageFill(QColor pixel)
      {
				clearToBottom(0,pixel);
      }
    void save(QFileInfo fn);
    bool load(QFileInfo fn,bool showError=TRUE);
    bool load(const char * s,bool showError=TRUE);
    bool load(QFileInfo fn,eimageAlignH alignH,eimageAlignV alignV,bool showError=TRUE,int x=0,int y=0);
    bool load(const char * s,eimageAlignH alignH,eimageAlignV alignV,bool showError=TRUE,int x=0,int y=0);

    //    void editImage();
    void zoom();
    QImage *getImagePtr()
      {
	return(image);
      }
    QPixmap *getPixmapPtr()
      {
				return(&pixmap);
      }
    void imageToPixmap()
      {
				pixmap=*image;
      }
    void pixmapToImage()
      {
				*image=pixmap;
      }

    bool editorOpen;
    void setupPosition();
    void copyPixmap(QPixmap &ipm)
      {
      	pixmap=ipm;
      }
    bool reload();


public slots:
/*    void paintEvent( QPaintEvent *e ); */
    void resizeEvent(QResizeEvent *);
 		virtual void contentsMousePressEvent( QMouseEvent *e );

signals:
		void mouseLeftButtonPressed(QMouseEvent *e);
		void mouseRightButtonPressed(QMouseEvent *e);

protected:

   QImage  *image;
   QPixmap *buPixmap;
   QPixmap pmLoad;
   bool scaled;
   bool keepAspectRatio;
   eimageAlignH alignH;
   eimageAlignV alignV;
   char fnsave[255];
};

#endif // Imageframe_included













