/***************************************************************************
                          cw.cpp  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "cw.h"
#include <ctype.h>

#include "qsstvglobal.h"

static struct {
	char key;
	const char	*cw;
} charTable[] = 
{
  {'A',	".-"	}, {'B',"-..."  },{'C',	"-.-." },
  {'D',	"-.."	}, {'E',"."	},{'F',"..-."  },
  {'G',	"--."	}, {'H',"...."	},{'I',".."    },
  {'J',	".---"	}, {'K',"-.-"	},{'L',".-.."  },
  {'M',	"--"	}, {'N',"-."	},{'O',"---"   },
  {'P',	".--."	}, {'Q',"--.-"	},{'R',".-."   },
  {'S',	"..."	}, {'T',"-"	},{'U',"..-"   },
  {'V',	"...-"	}, {'W',".--"	},{'X',"-..-"  },
  {'Y',	"-.--"	}, {'Z',"--.."	},
  {'0',	"-----"	}, {'1',".----"	},{'2',	"..---"},
  {'3',	"...--"	}, {'4',"....-"	},{'5',"....." },
  {'6',	"-...."	}, {'7',"--..."	},{'8',"---.." },
  {'9',	"----."	},
  {'"',	".-..-."}, {'\'', ".----." },{'$',"...-..-"},
  {'(',	"-.--." }, { ')', "-.--.-" },{'+',".-.-."},
  {',',	"--..--"}, {'-',  "-....-" },{'.',".-.-.-"},
  {'/',	"-..-." }, { ':', "---..." },{';',"-.-.-."},
  {'=',	"-...-" }, { '?', "..--.." },{'_',"..--.-"},
  {0,	""	}
};



morse::morse()
{
 initCW();

}

void morse::initCW(const char *st)
{ 
  if (st==0)
    {
      s=configFile.readOption("CWText");
    }
  else
    {
      s=st;
    }
  cwState=CWNEW;
  dotSpacing=1.2/(float)iCWWPM;
  cwState=CWNEW;
}

morse::~morse()
{
}

const char *morse::charLookup(char a)
{
  char b;
  int i=0;;
  b=toupper(a);
  while (charTable[i].key!=0)
    {
      if(charTable[i].key==b)
	{
	  return (charTable[i].cw);
	}
      i++;
    }
  return NULL;
}

bool morse::sendChar(float &duration)
{
  if (dotPtr[dotIndex]==0)
    {
      return FALSE;
    }
  else if(dotPtr[dotIndex]=='.')
    {
      duration=dotSpacing;
    }
  else
    {
      duration=3*dotSpacing;
    }
  dotIndex++;
  return TRUE;
}

bool morse::sendText(int &tone,float &duration)
{
  result=CWIDLE;
  do
    {
      switch (cwState)
	{
	case CWNEW:
	  {
	    charIndex=0;
	    if (s[0]==0)
	      {
		result=CWFALSE;
	      }
	    cwState=CWNEXTCHAR;
	  }
	  break;
	case CWNEXTCHAR:
	  {
	    if(s[charIndex]==' ')
	      {
		charIndex++;
		cwState=CWWORDSPACING;
	      }
	    else
	      {
		dotPtr=charLookup(s[charIndex++]);
		if (dotPtr==NULL)
		  {
		  cwState=CWEND;
		  }
		else
		  {
		    dotIndex=0;
		    cwState=CWNEXTDOT;
		  }
	      }
	  }
	  break;

	case CWNEXTDOT:
	  {
	    if(sendChar(duration))
	      {
		tone=iCWHz;
		cwState=CWDOTSPACING;
		result=CWTRUE;
	      }
	    else
	      {
		cwState=CWCHARSPACING;
	      }
	  }
	  break;
	case CWDOTSPACING:
	  {
	    tone=0;
	    duration=dotSpacing;
	    cwState=CWNEXTDOT;
	    result=CWTRUE;
	  }
	  break;
	case CWCHARSPACING:
	  {
	    tone=0;
	    duration=2*dotSpacing;  // we already had a dotspace
	    cwState=CWNEXTCHAR;
	    result=CWTRUE;
	  }
	  break;
	case CWWORDSPACING:
	  {
	    tone=0;
	    duration=4*dotSpacing; // we already had a charspace
	    cwState=CWNEXTCHAR;
	    result=CWTRUE;
	  }
	  break;
	
	case CWEND:
	  {
	    tone=0;
	    duration=7*dotSpacing;
	    cwState=CWFINISHED;
	    result=CWTRUE;
	  }
	  break;
	case CWFINISHED:
	  {
	    result=CWFALSE;
	  }
	  break;
	  
	}
    }
  while(result==CWIDLE);
  return (result==CWTRUE);
}












