
#include "misc.h"
#include "global.h"

#include "./icon/x1.xpm" 
#include "./icon/x2.xpm" 
#include "./icon/letters.xpm" 

#include <qbrush.h>
#include <qdrawutil.h>
#include <qfontmetrics.h>
#include <qwindowsstyle.h>
#include <qbutton.h>
#include <qpainter.h>
#include <qlayout.h>
#include <time.h>
#include <errno.h>


//ok 
#include <sys/utsname.h>    // uname 
int get_kernel_version()
{
	int version = 0;
	char *p;
	struct utsname uname_info;
	if(uname (&uname_info)==0)		
	{
	    //printf("sysname =%s \n",uname_info.sysname);
	    if(strcasecmp(uname_info.sysname,"linux")==0)
	    {
			uname_info.release[0];
	    }
		p=uname_info.release;
		char str[32];
	    int major, minor, patch;
	    int result;

        result = sscanf(p, "%d.%d.%d", &major, &minor, &patch);
        if(result < 3) {
			fprintf(stderr, "Qps: can't determine version, read %s \n",	p);
			fprintf(stderr, "please report this bug.\n");
			exit(1);
        }
        version = major * 10000 + minor * 100  + patch;
		//ex) 2.6.17 == 20617 , 2.4.8  == 20408
        //printf("DEBUG: version = %d\n", version);
    } else {
		fprintf(stderr, "Qps: uname failed. (%d) \n",version);
		fprintf(stderr, "please report this bug.\n");
		exit(1);
    }
	return version;
}

// 300% faster than glibc (by fasthyun@magicn.com) 
inline int x_atoi(const char *str_)
{
	register const char *str=str_;
	register int val=0;
	while(*str)
	{
		val*=10;
		val+=*str-48;
		str++;
	}
	return val;
}

#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

// return file size 
int fsize(char *fname)
{
	int size=0;
	if(0)
	{
		// !!! important !! not works with "proc" , always zero
		int fd = open(fname, O_RDONLY);
		if(fd < 0) return -1;
		size=lseek(fd,0, SEEK_END);
		printf("size=%d\n",size);
		close(fd);
		return size;
	}
	int buf[1024];
	int r;
	int fd = open(fname, O_RDONLY);
	if(fd < 0) return -1;
	do{
		r = read(fd, buf, 1024);
		size+=r;
	//	printf("r_size=%d\n",size);
	} while(r);
	// printf("size=%d\n",size);
	return size;
}

// sleep for msec
void msleep(long msec)
{
#ifdef LINUX
	timespec req,remain;
	timeval tv;
	req.tv_sec=0;
	req.tv_nsec=msec*1000000;
	//int  	nanosleep(const struct timespec *req, struct timespec *remain)
	/*while (nanosleep(&req, &req))
	{
		if (errno != EINTR)
			break;
	} */

	tv.tv_sec=0;
	tv.tv_usec=msec*1000;                
	select(0,NULL,NULL,NULL,&tv);
	return;
#endif

}

void mem_string(int kbytes, char *buf)
{
	if(kbytes >= 1024) {
		int meg = kbytes >> 10;
		if(meg >= 1024)
			sprintf(buf, "%uGb", meg >> 10);
		else
			sprintf(buf, "%uMb", meg);
	} else
		sprintf(buf, "%uKb", kbytes);
}

#include <grp.h>
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

// return username from /etc/passwd
char *userName(int uid,int euid)
{
	char buff[128];
	struct passwd *pw = getpwuid(uid);
	if(!pw) {
		// dont have name !
		sprintf(buff, "%d", uid);
	} else
		strcpy(buff,pw->pw_name);

	if(uid!=euid)
		strcat(buff, euid == 0 ? "*" : "+");
	
	return strdup(buff);
}

// return group name (possibly numeric)
char *groupName(int gid,int egid)
{
    char *p;
	struct group *gr = getgrgid(gid);
	if(!gr) {
	    p = (char *)malloc(11);
	    sprintf(p, "%d", gid);
	} else
	    p = strdup(gr->gr_name);
	//	s.append("*");
    return p;
}




CheckMenu::CheckMenu(QWidget *parent)
          : QPopupMenu(parent)
{}


CrossBox::CrossBox(const char *text, QWidget *parent)
         : QCheckBox(text, parent)
{}

void CrossBox::drawButton(QPainter *p)
{ 
	{
		QCheckBox::drawButton(p);
	}
}

TFrame::TFrame(QWidget *parent):QFrame(parent)
{
//	setFixedSize(80,20);
//	setMinimumWidth (100);
    	setBackgroundMode(Qt::NoBackground); //flicker free
}

void TFrame::setText( char *str) 
{
	text=str;
	update();
}
void TFrame::drawContents( QPainter *p ) 
{
	int h=fontMetrics ().height() + 2;
	int w=fontMetrics ().width(text) + 6;
	setFixedSize(w,h);
	QRect cr = contentsRect();
	p->fillRect ( cr,QColor(0,0,0)  );
	p->setPen(QColor(0,255,140)); // less visually obtrusive than black
	p->drawRect(cr);
	p->drawText(0, 0,w, h, AlignVCenter | Qt::AlignHCenter,text);
}


/*
//void SearchBox::event_cursor_moved(QMouseEvent *e)
{
	move(e->x(),e->y());
	//printf("xxxxxxxxxxxxxk\n");
}

*/

QPixmap *letters;
int pf_height=9;
int pf_width=6;

void init_xpm()
{
	letters=new QPixmap( (const char**)letters_xpm);
	pf_height=9;
	pf_width=6;
}

int  pf_str_width(char *str)
{
	int len;
	len=strlen(str)*pf_width;
	return len;
}
int  pf_char_height()
{
	return pf_height;
}

int pf_write(QPainter *p,int x,int y,const char *str)
{
	int i,len,n;
	int ch;
	int sx,sy;
	int x0=x;
	len=strlen(str);
	for(i=0;i<len;i++)
	{
		ch=str[i];
		
		if(ch=='\n')
		{
			//y+=pf_height;
			continue;
		}
		//if(ch>96) ch-=(97-65);
		n=ch-32;		
		p->drawPixmap ( x ,  y, *letters, n*pf_width , 0 , pf_width+1, pf_height);
		x+=pf_width;
	}
	return x-x0;
}


QPixmap *x1,*x2;
XButton::XButton(QWidget *parent):QButton(parent)
{
	x1=new QPixmap( (const char**)x1_xpm);
	x2=new QPixmap( (const char**)x2_xpm);
	int w=x1->width();
	setGeometry(0,0,w,w);
}


void XButton::resizeEvent(QResizeEvent *p)
{
	int i,h;
	i=height()%2;

	if(i!=0)
		h=height()+1;
	else h=height();	
	setFixedSize(h,h);
}

void XButton::drawButton(QPainter *p)
{ 
	int w,h,m;

	if(isDown())
		p->drawPixmap(0,0,*x2);	
	else	p->drawPixmap(0,0,*x1);

	return;
}


SearchBox::SearchBox(QWidget *parent):QLineEdit(parent)
{
	QToolTip::add( this, "Search PID,COMMAND,COMMAND_LINE,USER , Esc: Reset" );
	left_time=0;
	setMaximumWidth (300) ;
	setMinimumWidth (250) ;
	setFrameShadow(QFrame::Plain);
	setFrameShape (QFrame::Box ) ;
	setLineWidth( 1 );
//	setMargin(1);
	xb=new XButton(this);
	connect(xb, SIGNAL(clicked()), SLOT(event_xbutton_clicked()));
}

void SearchBox::event_xbutton_clicked()
{
	clear();
	qps->forced_update();///	emit update();
}

void SearchBox::event_cursor_moved(QMouseEvent *e)
{
	move(e->x(),e->y());
}

void SearchBox::resizeEvent(QResizeEvent *p)
{
	int w,h,margin;
	//setMinimumHeight(height()-4);
	//setMaximumHeight(p->size().height()-1);
	//setFixedHeight(p->size().height()-5);
	//setMaximumHeight(height()-2);
	w=width();
	h=height();
	margin=(h - xb->width())/2;
	xb->move(w-h+margin-1,margin);
	return;	
}

void SearchBox::keyPressEvent ( QKeyEvent * e )
{
	
	if(e->key()==Qt::Key_Escape )
	{
		xb->setDown(true);
		event_xbutton_clicked();		
		xb->setDown(false);
		return;

	}

	if(e->key()==Qt::Key_Delete)
	{
		qps->sig_term();
		QLineEdit::keyPressEvent ( e );
		return;
	}
	
	QLineEdit::keyPressEvent ( e );
	qps->forced_update(); // better ? //emit update();
	
}

void SearchBox::timerEvent( QTimerEvent *e )
{
 //       qDebug( "timer event, id %d", e->timerId() );
}
    
// Location: bottom
StatusBar::StatusBar(QWidget *parent)  : QStatusBar(parent)
{
	button = new QLabel(this);//QButton *button = new QButton(this);
	button->setText ("") ;
	setSizeGripEnabled (true);
//	button2 = new QToolButton(this);//QButton *button = new QButton(this);
//	button2->setTextLabel ("") ;
//	button2->setUsesTextLabel ( true );
//	button2->setAutoRaise(true); 
//	button3 = new QLabel(this);//QButton *button = new QButton(this);
//	button3->setText ("") ;
	addWidget(button);
//	addWidget(button3);
}

void StatusBar::refresh()
{

}

extern	int num_opened_files;
void StatusBar::update(int total_n)
{
	QString str;
	int 	x=0;
	button->setText("Total Process : " + str.setNum(total_n) ) ;
//	button2->setTextLabel ("Network Process(testing): "+ str.setNum(Procinfo::num_network_process));
//	button3->setText ("Opened files : "+ str.setNum(num_opened_files));
}

#include <qlayout.h>

// Location : 
ControlBar::ControlBar(QWidget *parent)  : QFrame(parent)
{
	int h;
	layout = new QHBoxLayout( this);
	layout->insertSpacing (0, 10) ;
	layout->setSpacing(7);
	layout->setMargin(1);

//	setFrameStyle(Panel | Raised);
	setFrameStyle(Panel ); // better ? 

	b_linear = new QRadioButton("Linear", this);
	b_linear->setFocusPolicy(QWidget::NoFocus);
	connect(b_linear, SIGNAL(clicked()), SLOT(linear_clicked()));

	b_tree = new QRadioButton("Tree", this);
	b_tree->setFocusPolicy(QWidget::NoFocus);
	connect(b_tree, SIGNAL(clicked()), SLOT(tree_clicked()));

	layout->addWidget( b_linear);
	layout->addWidget( b_tree);
	
	if(flag_thread_ok){
		check_thread=new QCheckBox ("Thread",this);
		check_thread->setFocusPolicy(QWidget::NoFocus);
		connect(check_thread, SIGNAL(clicked()), SLOT(show_thread_clicked()));
		check_thread->setChecked (flag_show_thread) ;
		layout->addWidget(check_thread);
	}


	search_box=new SearchBox(this);
	layout->addWidget( search_box);
	connect(search_box, SIGNAL(textChanged ( const QString & ) ), SLOT(event_search_box_changed()));
	
	view=new QComboBox(this);
	view->insertItem("All Processes", Procview::ALL);
	view->insertItem("Your Processes", Procview::OWNED);
	view->insertItem("Non-Root Processes", Procview::NROOT );
	view->insertItem("Running Processes", Procview::RUNNING);
	//PAUSED view->insertItem("Hidden Processes", Procview::HIDDEN);

	layout->addWidget(view);
	layout->addStretch();
}


void ControlBar::setMode(bool treemode) // just.. interface function
{
	b_linear->setChecked(!treemode);
	b_tree->setChecked(treemode);
}

void ControlBar::linear_clicked()
{
	setMode(FALSE); 
	emit modeChange(FALSE);
}

void ControlBar::tree_clicked()
{
	setMode(TRUE);
	emit modeChange(TRUE);
}

void ControlBar::show_thread_clicked()
{
	flag_show_thread=check_thread->isChecked ();
	emit update();
}

void ControlBar::event_search_box_changed()
{
	//printf("search_box changed!\n");
}

void ControlBar::event_command_pressed()
{
	//printf("command!\n");
}

void ControlBar::update_bar() // trick for Command 
{
	resize(width()-1,height());
	resize(width()+1,height());
}

// called after resize()
// simplified by fasthyun@magicn.com
void ControlBar::resizeEvent(QResizeEvent *r)
{
	int i,w,h;
	int x;
	
	setMaximumHeight (b_tree->sizeHint().height()+2);
	search_box->setMaximumHeight(height()-4);
	//search_box->setMinimumHeight(height()-5);
	
	for(i=0;i< commands.size();i++)
	{
		QToolButton *b;
		b=commands[i]->toolbutton;
		if(commands[i]->toolbar==true)
		{
			if (layout->findWidget(b)<0)
				layout->addWidget(b);
			b->show();
		}
		else 
			if(b!=NULL)
				b->hide();
	}

}

QPalette  GlobalPallete()
{
  	QColorGroup active;
	//void QPalette::setActive ( const QColorGroup & g ); 
	//const QColorGroup & QPalette::active () cons;
	if(1)
	{
		//active=qps->palette().active();
		//active.setColor (QColorGroup::Button,
		//	active.color (QColorGroup::Background));
		//active=colorGroup();
		//qps->palette().setActive(active);
		//active=colorGroup();
		//QPalette p=QPalette( active,  disabled,active );
		//return p; 
	}
	
	int base_red=204,
	    base_green=212,
	    base_blue=203;
	
	base_red=0xee,
	base_green=0xee,
	base_blue=0xe0;


	
	active.setColor (QColorGroup::Foreground, QColor(0,0,0 ));  // text
	active.setColor (QColorGroup::Button, QColor(base_red,base_green,base_blue )); // background 
	active.setColor (QColorGroup::Light, QColor(255,255,255 )); 
	active.setColor (QColorGroup::Midlight, QColor(base_red*6/7,base_green*6/7,base_blue*6/7 )); 
	//active.setColor (QColorGroup::Mid, QColor(base_red*4/5,base_green*4/5,base_blue*4/5 ));  //???
	active.setColor (QColorGroup::Mid, QColor(base_red*4/5,0,0 ));  //???
	active.setColor (QColorGroup::Dark, QColor(90,90,80 )); 
	//active.setColor (QColorGroup::Dark, QColor(10,10,10 )); 
	active.setColor (QColorGroup::Shadow, QColor(70,70,80 ));  
//	active.setColor (QColorGroup::Text, QColor(0,0,0 )); 
	active.setColor (QColorGroup::BrightText, QColor(255,0,0 )); //??? 
	active.setColor (QColorGroup::ButtonText, QColor(0,0,0 ));  //text
	active.setColor (QColorGroup::Text, QColor(0,0,0));  //text
	active.setColor (QColorGroup::Base, QColor(255,255,255)); 
	active.setColor (QColorGroup::Background, QColor(base_red,base_green,base_blue )); 
//	active.setColor (QColorGroup::Shadow, QColor(100,0,0 )); 
	active.setColor (QColorGroup::Highlight, QColor(250,250,0 )); // Yellow : Selected Color
	active.setColor (QColorGroup::HighlightedText, QColor(100,0,0 )); 
	active.setColor (QColorGroup::Link, QColor(0,0,130 ));  //blue
//	active.setColor (QColorGroup::LinkVisited, QColor(100,0,0 )); 

  	QColorGroup disabled(active);
	disabled.setColor (QColorGroup::Foreground, QColor(200,200,200 ));  // text
	disabled.setColor (QColorGroup::BrightText, QColor(200,200,200 )); 
	disabled.setColor (QColorGroup::ButtonText, QColor(200,200,200 ));  //text
	disabled.setColor (QColorGroup::Dark, QColor(200,200,200 ));  
	disabled.setColor (QColorGroup::Shadow, QColor(150,150,150 ));  
	disabled.setColor (QColorGroup::Text, QColor(255,255,255));  //text
	disabled.setColor (QColorGroup::Text, QColor(170,170,170));  //text

#ifdef SOLARIS

#endif
	QPalette p=QPalette( active,  disabled,active );
	return p; 

}

QPalette  platinumPallete()
{
  	QColorGroup active;
	
	int base_red=204,
	    base_green=212,
	    base_blue=203;
	
	base_red=0xee,
	base_green=0xee,
	base_blue=0xe0;

	active.setColor (QColorGroup::Foreground, QColor(0,0,0 ));  // text
	active.setColor (QColorGroup::Button, QColor(base_red,base_green,base_blue ));// button background 
	//active.setColor (QColorGroup::Mid, QColor(base_red*4/5,base_green*4/5,base_blue*4/5 ));  //???
	//active.setColor (QColorGroup::Dark, QColor(10,10,10 )); 
	active.setColor (QColorGroup::Shadow, QColor(70,70,80 ));  
	active.setColor (QColorGroup::Text, QColor(0,0,0 )); 
	active.setColor (QColorGroup::BrightText, QColor(0,0,0 )); //text edit background
	active.setColor (QColorGroup::ButtonText, QColor(0,0,0 ));  //text
	active.setColor (QColorGroup::Text, QColor(0,0,0));  //text
	active.setColor (QColorGroup::Base, QColor(255,255,255)); 
	active.setColor (QColorGroup::Background, QColor(base_red,base_green,base_blue )); 
	
	active.setColor (QColorGroup::Light, QColor(255,255,255 )); 
//	active.setColor (QColorGroup::Midlight, QColor(base_red*6/7,base_green*6/7,base_blue*6/7 ));  // not used
	active.setColor (QColorGroup::Mid, QColor(base_red-20,base_green-20,base_blue-20));  //Scroll background
	active.setColor (QColorGroup::Dark, QColor(base_red,base_green,base_blue )); 
	active.setColor (QColorGroup::Shadow, QColor(0x00,0x00,0x00 )); 
	
	active.setColor (QColorGroup::Highlight, QColor(160,0x00,37 )); // Red wine : Selected Color
	active.setColor (QColorGroup::HighlightedText, QColor(0xff,0xff,0xff )); 
	active.setColor (QColorGroup::Link, QColor(0,0,130 ));  //blue
//	active.setColor (QColorGroup::LinkVisited, QColor(100,0,0 )); 

  	QColorGroup disabled(active);
	disabled.setColor (QColorGroup::Foreground, QColor(200,200,200 ));  // text
	disabled.setColor (QColorGroup::BrightText, QColor(200,200,200 )); 
	disabled.setColor (QColorGroup::ButtonText, QColor(200,200,200 ));  //text
	disabled.setColor (QColorGroup::Dark, QColor(200,200,200 ));  
	disabled.setColor (QColorGroup::Shadow, QColor(150,150,150 ));  
	disabled.setColor (QColorGroup::Text, QColor(255,255,255));  //text
	disabled.setColor (QColorGroup::Text, QColor(170,170,170));  //text

#ifdef SOLARIS

#endif
	QPalette p=QPalette( active,  disabled,active );
	return p; 

}

QPalette  windowsPallete()
{
  	QColorGroup active;
	int base_red,  base_green,  base_blue;
	
	base_red=0xee,
	base_green=0xee,
	base_blue=0xe0;

	active.setColor (QColorGroup::Foreground, QColor(0,0,0 ));  // text
	active.setColor (QColorGroup::Button, QColor(base_red,base_green,base_blue ));// button background 
	//active.setColor (QColorGroup::Mid, QColor(base_red*4/5,base_green*4/5,base_blue*4/5 ));  //???
	//active.setColor (QColorGroup::Dark, QColor(10,10,10 )); 
	active.setColor (QColorGroup::Shadow, QColor(70,70,80 ));  
	active.setColor (QColorGroup::Text, QColor(0,0,0 )); 
	active.setColor (QColorGroup::BrightText, QColor(0,0,0 )); //text edit background
	active.setColor (QColorGroup::ButtonText, QColor(0,0,0 ));  //text
	active.setColor (QColorGroup::Text, QColor(0,0,0));  //text
	active.setColor (QColorGroup::Base, QColor(255,255,255)); 
	active.setColor (QColorGroup::Background, QColor(base_red,base_green,base_blue )); 
	
	active.setColor (QColorGroup::Light, QColor(255,255,255 )); 
	active.setColor (QColorGroup::Midlight, QColor(base_red-10,base_green-10,base_blue-10 ));  
	active.setColor (QColorGroup::Mid, QColor(base_red-20,base_green-20,base_blue-20));  //Scroll background
	active.setColor (QColorGroup::Dark, QColor(base_red-60,base_green-60,base_blue-60)); 
	active.setColor (QColorGroup::Shadow, QColor(0x05,0x05,0x05 )); 
	
	active.setColor (QColorGroup::Highlight, QColor(170,0x02,52 )); // Red wine : Selected Color
	active.setColor (QColorGroup::HighlightedText, QColor(0xff,0xff,0xff )); 
	active.setColor (QColorGroup::Link, QColor(0,0,130 ));  //blue
//	active.setColor (QColorGroup::LinkVisited, QColor(100,0,0 )); 

  	QColorGroup disabled(active);
	disabled.setColor (QColorGroup::Foreground, QColor(200,200,200 ));  // text
	disabled.setColor (QColorGroup::BrightText, QColor(200,200,200 )); 
	disabled.setColor (QColorGroup::ButtonText, QColor(200,200,200 ));  //text
	disabled.setColor (QColorGroup::Dark, QColor(200,200,200 ));  
	disabled.setColor (QColorGroup::Shadow, QColor(150,150,150 ));  
	disabled.setColor (QColorGroup::Text, QColor(255,255,255));  //text
	disabled.setColor (QColorGroup::Text, QColor(170,170,170));  //text

#ifdef SOLARIS

#endif
	QPalette p=QPalette( active,  disabled,active );
	return p; 

}


#include <qstylefactory.h>
#include <qapplication.h>
#include <qstyle.h>

// if theme is Qt's default, then use qps theme.
void setQpsTheme()
{
	QString currentstyle;
	currentstyle = QApplication::style().name();
	//printf("%s\n",(const char *)currentstyle);
	if(currentstyle!="Motif")
		return;

	QColor c=QApplication::palette().active().background();
	//printf("r=%d,g=%d,b=%d\n",c.red(),c.green(),c.blue());
	if(c.red()==192 and c.green()==192 and c.blue()==192)
		;
	else
		return;

	QStringList styles = QStyleFactory::keys();

	QStringList list=styles.grep("platinum",false);
	if(list.size()>0) 
	{
	//	QApplication::setStyle(QStyleFactory::create("platinum"));
	//	QApplication::setPalette( platinumPallete(), TRUE );
	//	return;
	}

	list=styles.grep("windows",false);
	if(list.size()>0) 
	{
		QApplication::setStyle(QStyleFactory::create("windows"));
		QApplication::setPalette( windowsPallete(), TRUE );
	}
}



#include <qdialog.h>
#include <qtextbrowser.h> 

void Qps::license() // -> help()
{
		
	QDialog *diag=new QDialog(this); 
	diag->setCaption("Quick Help" );
	//diag->setSizeGripEnabled(true) ;
	QHBoxLayout *lay=new QHBoxLayout(diag);
	QTextBrowser *browser = new QTextBrowser( diag );
	browser->setMinimumSize( 400,200 );
	lay->addWidget(browser);
	browser->setText(
			"<H1>QPS Help</H1>"
			"Updated: May 24 2005<BR>"
			"<A HREF=\"http://qps.kldp.net\">http://qps.kldp.net</A><HR>"
			//			"temporary<BR>"
			
			"<table style=\"text-align: center; width: 100%;\" border=\"1\""
			" cellpadding=\"1\" cellspacing=\"0\">"
			"  <tbody>"
			"    <tr>"
			"      <td"
			" style=\"vertical-align: top; background-color: rgb(204, 204, 204);\">Quit"
			"      </td>"
			"      <td >&nbsp; CTRL + q , CTRL + x"
			"      </td>"
			"    </tr>"
			"    <tr>"
			"      <td"
			" style=\"vertical-align: top; background-color: rgb(204, 204, 204);\">Update"
			"      </td>"
			"      <td>&nbsp;Space , Enter "
			"      </td>"
			"    </tr>"
			"    <tr><td> process Terminate </td>  <td> ALT + T , DELETE </td> </tr>"
			"    <tr><td> process Kill </td>  <td> ALT + K  </td> </tr>"
			"  </tbody>"
			"</table>"
			);
	diag->exec();
}

