/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#ifndef CVIEWTRACKINFO_H
#define CVIEWTRACKINFO_H
#include <QWidget>
#include <QPointer>
#include "ui_IToolViewTrackInfo.h"

class CGarminDBTrack;
class CGarminTrack;

class MyQTreeWidgetItem : public QTreeWidgetItem
{

    public:
        MyQTreeWidgetItem(QTreeWidget *tree) : QTreeWidgetItem(tree) {
        }

        MyQTreeWidgetItem ( QTreeWidget * parent, const QStringList & strings) : QTreeWidgetItem (parent,strings) {
        }

        bool operator< ( const QTreeWidgetItem & other ) const;
};

class CToolViewTrackInfo : public QWidget, private Ui::IToolViewTrackInfo
{
    Q_OBJECT
        public:
        CToolViewTrackInfo(QWidget * parent, CGarminDBTrack* db);
        virtual ~CToolViewTrackInfo();

    public slots:
        void slotTrackSelectionChanged();

        void slotPointSelectionChanged();

        void slotPointSelection(MyQTreeWidgetItem * item);

    protected slots:
        void slotApply();
        void slotCheckReset(bool checked);
        void slotCheckRemove(bool checked);
        void slotContextMenu(const QPoint& pos);
        void slotPurge();

    protected:
        /// test for del key
        void keyPressEvent(QKeyEvent * e);

    private:
        bool originator;

        enum columns_e
        {
            eNum       = 0
            ,eTime      = 1
            ,eAltitude  = 2
            ,eDelta     = 3
            ,eAzimuth   = 4
            ,eDistance  = 5
            ,eSpeed     = 6
            ,eAscend    = 7
            ,eDescend   = 8
            ,ePosition  = 9
            ,eMaxColumn = 10
        };

        QPointer<CGarminTrack> track;

        QMenu * contextMenu;

};
#endif                           //CVIEWTRACKINFO_H
