/***************************************************************************
                          configfile.h  -   QGrid
                             -------------------
    begin                : Fri Jan 12 13:46:56 CET 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CONFIGFILE_H
#define CONFIGFILE_H
#include <qlist.h>
#include <qstring.h>
#include <qdir.h>
#include <qfileinfo.h>

/*
Modules to support config files
Features:
Users can edit and comment the config files.
This functions will leave the comment strings intact and
only update the values.
The configfile will first be search in the HOME directory, then in the local directory
Text after '#' is seen as comment
layout: Optionname = Optionvalue [# comment]
Maximum length (including comment): 255 characters

 
Use:
1) Register the Options to be used  
 RegisterOption(const char *OptionName,const char *OptionValue);
2) Read the configfile
 ReadFile(const char *name, const char *path="");
 only Option that are registered will be used and updated
3) SaveFile
 Will save the Options in the same file that was indicated in the ReadFile.
 Options that are registered but that are not in the configfile, are added.
 Options in the configfile that are not registered are flagged as invalid (commented out).
*/

#define OPTIONNAMELEN 15
#define OPTIONVALLEN  50


class configOption
{
public:
  configOption (const char *name, const char *defaultvalue="")
	{
	n=name;
	s=defaultvalue;
	Stored=FALSE;
	}
  const char *name() const
	{
	return n;
	}
   const char *getvalstr()
	{
	return s;
	}
   int getvali(bool * ok=NULL)
     {
       return( s.toInt(ok));  // if ok!=NULL then ok =TRUE if no errors 
     }
   float getvalf(bool * ok=NULL)
     {
       return( s.toFloat(ok));  // if ok!=NULL then ok =TRUE if no errors 
     }

   void setvalstr(const char *str)
	{
	s=str;
	}
   void setval(int i)
     {
       s.setNum(i);
     }
   void setstored(bool st)
     {
       Stored=st;
     }
   bool IsStored()
     {
       return Stored;
     }
private:
	QString n;
	QString s;
	bool Stored;
};


class configurationFile
{
public:
  QList<configOption> optionList;  
  configurationFile();
  void registerOption(const char *OptionName,const char *OptionValue);
  bool readFile(const char *name, const char *path=NULL);
  bool saveFile ();
  bool readOption(const char * s,int &i);
  bool readOption(const char * s,float &i);
  bool readOption(const char * s,bool &b);
  bool hasChanged()
    {
      return changed;
    }
  const char *readOption(const char *);
  //  void setOption(const char *s);
  void setOption(const char *s,const char *t);
  void setOption(const char *s,int t);
  void setOption(const char *s,float t);
protected:
  int processLine( QString &s, QString &OptN, QString &OptV);
  configOption *optionCheck(QString OptN, QString OptV, bool Update); 
  QFileInfo configFileName;
  QDir configDir;
  bool changed;
};



#endif









