/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef REVSVIEW_H
#define REVSVIEW_H

#include <qguardedptr.h>
#include "revbase.h" // needed by moc_* file to understand tab() function
#include "exceptionmanager.h"
#include "common.h"
#include "domain.h"

class Git;
class QListBoxItem;
class QPopupMenu;
class QTextEdit;
class QTextBrowser;
class QListBox;
class QListViewItem;
class ListView;
class ListViewItem;
class RevDesc;
class ListBoxFiles;
class PatchView;
class TreeView;
class MainImpl;
class FileHistory;

class RevsView : public Domain {
Q_OBJECT
public:
	RevsView(MainImpl* parent, Git* git);
	~RevsView();
	void clear(bool keepState);
	void viewPatch(bool newTab);
	void setEnabled(bool b);
	virtual TabRev* tab() { return revTab; }

private slots:
	void on_loadCompleted(const FileHistory*, const QString& stats);
	void on_lanesContextMenuRequested(const QStringList&, const QStringList&);
	void on_droppedRevisions(const QString&, const QStringList&, const QString&);

protected:
	virtual bool doUpdate();

private:
	friend class MainImpl;

	bool listBoxFiles_mouseMoveEvent();
	bool listBoxFiles_mouseReleaseEvent();
	void updateLineEditSHA(bool clear = false);

	TabRev* revTab;
	QGuardedPtr<PatchView> linkedPatchView;
	TreeView* treeView;
	ListView* listViewLog;
	ListBoxFiles* listBoxFiles;
};

#endif
