# -*- coding: utf-8 -*-

"""
***************************************************************************
    acceptable_missing_doc.py
    ---------------------
    Date                 : March 2016
    Copyright            : (C) 2016 by Stéphane Brunner
    Email                : stephane dot brunner at camptocamp dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Stéphane Brunner'
__date__ = 'March 2016'
__copyright__ = '(C) 2016, Stéphane Brunner'
# This will get replaced with a git SHA1 when you do a git archive
__revision__ = '$Format:%H$'

# -*- coding: utf-8 -*-
"""
The list of acceptable documentation missing
"""
__author__ = 'Stéphane Brunner'
__date__ = '18/03/2016'
__copyright__ = 'Copyright 2016, The QGIS Project'
# This will get replaced with a git SHA1 when you do a git archive
__revision__ = '$Format:%H$'

ACCEPTABLE_MISSING_DOCS = {
    "QgsNineCellFilter": ["zFactor() const ", "setZFactor(double factor)", "setCellSizeX(double size)", "setInputNodataValue(double value)", "cellSizeX() const ", "cellSizeY() const ", "inputNodataValue() const ", "outputNodataValue() const ", "setCellSizeY(double size)", "setOutputNodataValue(double value)"],
    "QgsVectorRandomColorRampV2": ["setValMin(int val)", "setCount(int val)", "hueMin() const ", "valMax() const ", "setSatMin(int val)", "setValMax(int val)", "valMin() const ", "hueMax() const ", "QgsVectorRandomColorRampV2(int count=DEFAULT_RANDOM_COUNT, int hueMin=DEFAULT_RANDOM_HUE_MIN, int hueMax=DEFAULT_RANDOM_HUE_MAX, int satMin=DEFAULT_RANDOM_SAT_MIN, int satMax=DEFAULT_RANDOM_SAT_MAX, int valMin=DEFAULT_RANDOM_VAL_MIN, int valMax=DEFAULT_RANDOM_VAL_MAX)", "satMax() const ", "satMin() const ", "updateColors()", "setHueMax(int val)", "create(const QgsStringMap &properties=QgsStringMap())", "setSatMax(int val)", "setHueMin(int val)"],
    "QgsGPSConnectionRegistry": ["instance()", "connectionList() const "],
    "QgsOSMDownload": ["setServiceUrl(const QString &serviceUrl)", "serviceUrl() const ", "setOutputFileName(const QString &outputFileName)", "outputFileName() const ", "errorString() const ", "setQuery(const QString &query)", "query() const ", "hasError() const "],
    "QgsExpression::WhenThen": ["WhenThen(Node *whenExp, Node *thenExp)"],
    "QgsValueRelationSearchWidgetWrapper": ["valueChanged()", "None", "QgsValueRelationSearchWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)", "value() const "],
    "QgsMapLayerRenderer": ["QgsMapLayerRenderer(const QString &layerID)"],
    "QgsSvgSelectorDialog": ["QgsSvgSelectorDialog(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags, const QDialogButtonBox::StandardButtons &buttons=QDialogButtonBox::Close|QDialogButtonBox::Ok, Qt::Orientation orientation=Qt::Horizontal)"],
    "QgsRasterBlock": ["typeSize(int dataType)", "dataTypeSize() const ", "applyNoDataValues(const QgsRasterRangeList &rangeList)", "toString() const "],
    "QgsVectorRandomColorRampV2Dialog": ["setSat1(int val)", "QgsVectorRandomColorRampV2Dialog(QgsVectorRandomColorRampV2 *ramp, QWidget *parent=nullptr)", "setVal1(int val)", "setCount(int val)", "setSat2(int val)", "setVal2(int val)", "setHue2(int val)", "setHue1(int val)", "updatePreview()"],
    "QgsAbstractFeatureSource": ["iteratorOpened(QgsAbstractFeatureIterator *it)", "iteratorClosed(QgsAbstractFeatureIterator *it)"],
    "QgsRuleBasedRendererV2Model": ["removeRule(const QModelIndex &index)", "ruleForIndex(const QModelIndex &index) const ", "updateRule(const QModelIndex &parent, int row)", "finishedAddingRules()", "insertRule(const QModelIndex &parent, int before, QgsRuleBasedRendererV2::Rule *newrule)", "QgsRuleBasedRendererV2Model(QgsRuleBasedRendererV2 *r)", "updateRule(const QModelIndex &index)", "willAddRules(const QModelIndex &parent, int count)", "clearFeatureCounts()"],
    "QgsPointSample": ["QgsPointSample(QgsVectorLayer *inputLayer, const QString &outputLayer, const QString &nPointsAttribute, const QString &minDistAttribute=QString())"],
    "pal::LabelPosition": ["getNextPart() const ", "getQuadrant() const ", "polygonObstacleCallback(pal::FeaturePart *obstacle, void *ctx)", "countOverlapCallback(LabelPosition *lp, void *ctx)", "countFullOverlapCallback(LabelPosition *lp, void *ctx)", "getProblemFeatureId() const ", "isInConflictMultiPart(LabelPosition *lp)", "getPartId() const ", "isInConflictSinglePart(LabelPosition *lp)", "insertIntoIndex(RTree< LabelPosition *, double, 2, double > *index)", "getWidth() const ", "getNumOverlaps() const ", "setPartId(int id)", "getReversed() const ", "resetNumOverlaps()", "removeFromIndex(RTree< LabelPosition *, double, 2, double > *index)", "getUpsideDown() const ", "getHeight() const ", "removeOverlapCallback(LabelPosition *lp, void *ctx)", "setNextPart(LabelPosition *next)"],
    "QgsShapeburstFillSymbolLayerV2Widget": ["applyColorRamp()", "create(const QgsVectorLayer *vl)", "offsetChanged()", "setColor(const QColor &color)", "setColor2(const QColor &color)", "QgsShapeburstFillSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "colorModeChanged()"],
    "QgsSymbolLayerV2AbstractMetadata": ["QgsSymbolLayerV2AbstractMetadata(const QString &name, const QString &visibleName, QgsSymbolV2::SymbolType type)", "type() const ", "name() const ", "visibleName() const "],
    "QgsGroupBoxCollapseButton": ["QgsGroupBoxCollapseButton(QWidget *parent=nullptr)", "shiftDown() const ", "setAltDown(bool updown)", "setShiftDown(bool shiftdown)", "altDown() const "],
    "QgsGeometryGeneratorSymbolLayerV2": ["create(const QgsStringMap &properties)"],
    "QgsVectorLayerEditUtils": ["cache()", "QgsVectorLayerEditUtils(QgsVectorLayer *layer)", "addPart(QgsCurveV2 *ring, QgsFeatureId featureId)"],
    "QgsMapLayerComboBox": ["indexChanged(int i)", "rowsChanged()"],
    "QgsHiddenWidgetWrapper": ["QgsHiddenWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsDxfExport": ["QgsDxfExport(const QgsDxfExport &dxfExport)", "SymbologyExport", "mapUnitScaleFactor(double scaleDenominator, QgsSymbolV2::OutputUnit symbolUnits, QGis::UnitType mapUnits)"],
    "QgsCheckBoxConfigDlg": ["QgsCheckBoxConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsMessageLog": ["MessageLevel", "instance()", "messageReceived(bool received)", "messageReceived(const QString &message, const QString &tag, QgsMessageLog::MessageLevel level)"],
    "QgsFontMarkerSymbolLayerV2Widget": ["setAngle(double angle)", "create(const QgsVectorLayer *vl)", "setFontFamily(const QFont &font)", "QgsFontMarkerSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "setColor(const QColor &color)", "setOffset()", "setCharacter(QChar chr)", "setSize(double size)"],
    "QgsStyleV2ManagerDialog": ["removeItem()", "importItems()", "removeSymbol()", "addColorRamp(QAction *action)", "exportItemsSVG()", "editItem()", "exportSelectedItemsImages(const QString &dir, const QString &format, QSize size)", "editSymbol()", "editColorRamp()", "currentItemType()", "addGroup()", "groupSelectedSymbols()", "groupChanged(const QModelIndex &)", "addItem()", "itemChanged(QStandardItem *item)", "removeGroup()", "QgsStyleV2ManagerDialog(QgsStyleV2 *style, QWidget *parent=nullptr)", "groupRenamed(QStandardItem *)", "removeColorRamp()", "exportItemsPNG()", "exportItems()", "currentItemName()"],
    "QgsVectorColorBrewerColorRampV2Dialog": ["setSchemeName()", "populateVariants()", "QgsVectorColorBrewerColorRampV2Dialog(QgsVectorColorBrewerColorRampV2 *ramp, QWidget *parent=nullptr)", "setColors()", "updatePreview()"],
    "QgsFeatureListModel": ["fidToIndexList(QgsFeatureId fid)", "onBeginInsertRows(const QModelIndex &parent, int first, int last)", "onBeginRemoveRows(const QModelIndex &parent, int first, int last)", "featureByIndex(const QModelIndex &index, QgsFeature &feat)", "mapToMaster(const QModelIndex &proxyIndex) const ", "onEndRemoveRows(const QModelIndex &parent, int first, int last)", "setSourceModel(QgsAttributeTableFilterModel *sourceModel)", "onEndInsertRows(const QModelIndex &parent, int first, int last)", "fidToIdx(const QgsFeatureId fid) const ", "idxToFid(const QModelIndex &index) const ", "layerCache()", "mapSelectionFromMaster(const QItemSelection &selection) const ", "Role", "masterModel()", "displayExpression() const ", "mapFromMaster(const QModelIndex &sourceIndex) const ", "QgsFeatureListModel(QgsAttributeTableFilterModel *sourceModel, QObject *parent=nullptr)", "mapSelectionToMaster(const QItemSelection &selection) const "],
    "QgsCptCityArchive": ["copyingInfo(const QString &fileName)", "QgsCptCityArchive(const QString &archiveName=DEFAULT_CPTCITY_ARCHIVE, const QString &baseDir=QString())", "baseDir(QString archiveName)", "defaultBaseDir()", "initArchive(const QString &archiveName, const QString &archiveBaseDir)", "archiveRegistry()", "descFileName(const QString &dirName) const ", "initArchives(bool loadAll=false)", "findFileName(const QString &target, const QString &startDir, const QString &baseDir)", "rootItems() const ", "copyingFileName(const QString &dirName) const ", "clearArchives()", "setBaseDir(const QString &dirName)", "isEmpty()", "baseDir() const ", "selectionItems() const ", "defaultArchive()", "initDefaultArchive()", "archiveName() const ", "description(const QString &fileName)"],
    "QgsLinearMinMaxEnhancement": ["QgsLinearMinMaxEnhancement(QGis::DataType, double, double)"],
    "QgsFieldValidator": ["QgsFieldValidator(QObject *parent, const QgsField &field, const QString &defaultValue, const QString &dateFormat=\"yyyy-MM-dd\")", "dateFormat() const "],
    "QgsProviderCountCalcEvent": ["QgsProviderCountCalcEvent(long featuresCounted)", "featuresCounted() const "],
    "QgsFeatureListViewDelegate": ["editButtonClicked(QModelIndex &index)", "positionToElement(QPoint pos)", "QgsFeatureListViewDelegate(QgsFeatureListModel *listModel, QObject *parent=nullptr)", "setCurrentFeatureEdited(bool state)", "setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)", "Element", "setEditSelectionModel(QItemSelectionModel *editSelectionModel)"],
    "QgsImageLegendNode": ["QgsImageLegendNode(QgsLayerTreeLayer *nodeLayer, const QImage &img, QObject *parent=nullptr)"],
    "QgsVectorLayerRenderer": ["QgsVectorLayerRenderer(QgsVectorLayer *layer, QgsRenderContext &context)"],
    "QgsQueryBuilder": ["sql()", "clear()", "setSql(const QString &sqlStatement)", "setDatasourceDescription(const QString &uri)"],
    "QgsPalLabeling": ["dataDefinedTextStyle(QgsPalLayerSettings &tmpLyr, const QMap< QgsPalLayerSettings::DataDefinedProperties, QVariant > &ddValues)", "setShowingPartialsLabels(bool showing)", "setDrawingOutlineLabels(bool outline)", "setNumCandidatePositions(int candPoint, int candLine, int candPolygon)", "isShowingAllLabels() const ", "isShowingShadowRectangles() const ", "numCandidatePositions(int &candPoint, int &candLine, int &candPolygon)", "drawLabelShadow(QgsRenderContext &context, const QgsLabelComponent &component, const QgsPalLayerSettings &tmpLyr)", "setShowingCandidates(bool showing)", "drawLabelBuffer(QgsRenderContext &context, const QgsLabelComponent &component, const QgsPalLayerSettings &tmpLyr)", "isShowingCandidates() const ", "dataDefinedTextBuffer(QgsPalLayerSettings &tmpLyr, const QMap< QgsPalLayerSettings::DataDefinedProperties, QVariant > &ddValues)", "setShowingShadowRectangles(bool showing)", "Search", "dataDefinedTextFormatting(QgsPalLayerSettings &tmpLyr, const QMap< QgsPalLayerSettings::DataDefinedProperties, QVariant > &ddValues)", "setSearchMethod(Search s)", "DrawLabelType", "isShowingPartialsLabels() const ", "drawLabelBackground(QgsRenderContext &context, QgsLabelComponent component, const QgsPalLayerSettings &tmpLyr)", "dataDefinedDropShadow(QgsPalLayerSettings &tmpLyr, const QMap< QgsPalLayerSettings::DataDefinedProperties, QVariant > &ddValues)", "dataDefinedShapeBackground(QgsPalLayerSettings &tmpLyr, const QMap< QgsPalLayerSettings::DataDefinedProperties, QVariant > &ddValues)", "clearEngineSettings()", "searchMethod() const ", "deleteTemporaryData()", "setShowingAllLabels(bool showing)", "staticWillUseLayer(const QString &layerID)", "saveEngineSettings()"],
    "QgsTransformWidget": ["QgsTransformWidget(QWidget *parent=nullptr)", "create()"],
    "pal::LabelInfo": ["LabelInfo(int num, double height, double maxinangle=20.0, double maxoutangle=-20.0)"],
    "QgsVectorLayerUndoCommandDeleteFeature": ["QgsVectorLayerUndoCommandDeleteFeature(QgsVectorLayerEditBuffer *buffer, QgsFeatureId fid)"],
    "QgsUniqueValueWidgetFactory": ["QgsUniqueValueWidgetFactory(const QString &name)"],
    "QgsSvgSelectorListModel": ["QgsSvgSelectorListModel(QObject *parent)", "QgsSvgSelectorListModel(QObject *parent, const QString &path)"],
    "QgsPythonRunner": ["evalCommand(QString command, QString &result)=0", "runCommand(QString command, QString messageOnError=QString())=0"],
    "QgsRasterTransparency": ["readXML(const QDomElement &elem)", "writeXML(QDomDocument &doc, QDomElement &parentElem) const "],
    "QgsFeatureIterator": ["rewind()", "close()", "nextFeature(QgsFeature &f)"],
    "QgsPenCapStyleComboBox": ["QgsPenCapStyleComboBox(QWidget *parent=nullptr)", "penCapStyle() const ", "setPenCapStyle(Qt::PenCapStyle style)"],
    "QgsAddRemoveMultiFrameCommand": ["State", "QgsAddRemoveMultiFrameCommand(State s, QgsComposerMultiFrame *multiFrame, QgsComposition *c, const QString &text, QUndoCommand *parent=nullptr)"],
    "QgsRelationReferenceFactory": ["QgsRelationReferenceFactory(const QString &name, QgsMapCanvas *canvas, QgsMessageBar *messageBar)"],
    "QgsDxfPaintDevice": ["setDrawingSize(QSizeF size)", "setLayer(const QString &layer)", "setOutputSize(const QRectF &r)", "QgsDxfPaintDevice(QgsDxfExport *dxf)", "setShift(QPointF shift)"],
    "QgsPoint": ["operator-(const QgsPoint &p) const ", "operator-(QgsVector v) const ", "operator+=(QgsVector v)", "operator-=(QgsVector v)", "operator+(QgsVector v) const "],
    "QgsVectorGradientColorRampV2Dialog": ["setItemStopColor(const QColor &newColor)", "setColor1(const QColor &color)", "stopDoubleClicked(QTreeWidgetItem *item, int column)", "setStopColor(QTreeWidgetItem *item, const QColor &color)", "QgsVectorGradientColorRampV2Dialog(QgsVectorGradientColorRampV2 *ramp, QWidget *parent=nullptr)", "setColor2(const QColor &color)", "addStop()", "toggledStops(bool on)", "removeStop()", "updateStops()", "updatePreview()"],
    "QgsCptCityColorRampV2Dialog": ["clearCopyingInfo()", "showAll()", "saveAsGradientRamp() const ", "updatePreview(bool clear=false)", "setTreeModel(QgsCptCityBrowserModel *model)", "updateCopyingInfo(const QMap< QString, QString > &copyingMap)", "QgsCptCityColorRampV2Dialog(QgsCptCityColorRampV2 *ramp, QWidget *parent=nullptr)", "updateTreeView(QgsCptCityDataItem *item, bool resetRamp=true)", "onFinished()", "updateRamp()", "populateVariants()", "updateListWidget(QgsCptCityDataItem *item)", "selectedName() const "],
    "QgsComposerMouseHandles": ["SnapGuideMode", "composition()", "QgsComposerMouseHandles(QgsComposition *composition)", "setComposition(QgsComposition *c)", "ItemPositionMode"],
    "QgsExpressionBuilderDialog": ["QgsExpressionBuilderDialog(QgsVectorLayer *layer, const QString &startText=QString(), QWidget *parent=nullptr, const QString &key=\"generic\", const QgsExpressionContext &context=QgsExpressionContext())", "expressionText()", "setExpressionText(const QString &text)"],
    "QgsProviderMetadata": ["QgsProviderMetadata(const QString &_key, const QString &_description, const QString &_library)"],
    "QgsAbstractFeatureIteratorFromSource": ["QgsAbstractFeatureIteratorFromSource(T *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsSnapper": ["SnappingMode", "QgsSnapper(const QgsMapSettings &mapSettings)", "setSnapLayers(const QList< QgsSnapper::SnapLayer > &snapLayers)", "setSnapMode(QgsSnapper::SnappingMode snapMode)"],
    "pal::PolygonCostCalculator": ["PolygonCostCalculator(LabelPosition *lp)", "update(pal::PointSet *pset)", "getCost()", "getLabel()"],
    "QgsSimpleLegendNode": ["QgsSimpleLegendNode(QgsLayerTreeLayer *nodeLayer, const QString &label, const QIcon &icon=QIcon(), QObject *parent=nullptr, const QString &key=QString())"],
    "QgsDataSourceURI": ["SSLmode"],
    "HalfEdge": ["HalfEdge(int dual, int next, int point, bool mbreak, bool forced)"],
    "QgsTransactionGroup": ["QgsTransactionGroup(QObject *parent=0)"],
    "QgsCptCityDataItem": ["icon()", "setIcon(const QIcon &icon)", "emitEndRemoveItems()", "deleteChildItem(QgsCptCityDataItem *child)", "shortInfo() const ", "createChildren()", "refresh()", "Type", "addChildItem(QgsCptCityDataItem *child, bool refresh=false)", "equal(const QgsCptCityDataItem *other)", "toolTip() const ", "hasChildren()", "isPopulated()", "leafCount() const ", "setParent(QgsCptCityDataItem *parent)", "acceptDrop()", "name() const ", "actions()", "icon(QSize size)", "endRemoveItems()", "endInsertItems()", "paramWidget()", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "setToolTip(const QString &msg)", "parent() const ", "children() const ", "emitBeginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "emitEndInsertItems()", "findItem(QVector< QgsCptCityDataItem * > items, QgsCptCityDataItem *item)", "rowCount()", "handleDrop(const QMimeData *, Qt::DropAction)", "QgsCptCityDataItem(QgsCptCityDataItem::Type type, QgsCptCityDataItem *parent, const QString &name, const QString &path)", "emitBeginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "info() const ", "populate()", "isValid()", "type() const ", "removeChildItem(QgsCptCityDataItem *child)", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "path() const "],
    "QgsVectorLayerEditBuffer": ["committedAttributeValuesChanges(const QString &layerId, const QgsChangedAttributesMap &changedAttributesValues)", "committedGeometriesChanges(const QString &layerId, const QgsGeometryMap &changedGeometries)", "featureDeleted(QgsFeatureId fid)", "committedFeaturesRemoved(const QString &layerId, const QgsFeatureIds &deletedFeatureIds)", "committedAttributesAdded(const QString &layerId, const QList< QgsField > &addedAttributes)", "committedFeaturesAdded(const QString &layerId, const QgsFeatureList &addedFeatures)", "attributeValueChanged(QgsFeatureId fid, int idx, const QVariant &)", "updateFields(QgsFields &fields)", "QgsVectorLayerEditBuffer(QgsVectorLayer *layer)", "geometryChanged(QgsFeatureId fid, QgsGeometry &geom)", "updateLayerFields()", "deletedFeatureIds()", "featureAdded(QgsFeatureId fid)", "undoIndexChanged(int index)", "attributeAdded(int idx)", "attributeDeleted(int idx)"],
    "QgsRasterLayerSaveAsDialog": ["buildPyramidsFlag() const ", "outputRectangle() const ", "ResolutionState", "outputCrs()", "hideOutput()", "hideFormat()", "tileMode() const ", "nRows() const ", "yResolution() const ", "CrsState", "noData() const ", "createOptions() const ", "nColumns() const ", "addToCanvas() const ", "pyramidsList() const ", "Mode", "pyramidsConfigOptions() const ", "pyramidsFormat() const ", "mode() const ", "outputFormat() const ", "maximumTileSizeY() const ", "outputFileName() const ", "maximumTileSizeX() const ", "pyramidsResamplingMethod() const ", "xResolution() const ", "QgsRasterLayerSaveAsDialog(QgsRasterLayer *rasterLayer, QgsRasterDataProvider *sourceProvider, const QgsRectangle &currentExtent, const QgsCoordinateReferenceSystem &layerCrs, const QgsCoordinateReferenceSystem &currentCrs, QWidget *parent=nullptr, const Qt::WindowFlags &f=nullptr)"],
    "QgsOSMNode": ["point() const ", "QgsOSMNode(QgsOSMId id, const QgsPoint &point)"],
    "QgsPointLocator_VisitorEdgesInRect": ["QgsPointLocator_VisitorEdgesInRect(QgsPointLocator *pl, QgsPointLocator::MatchList &lst, const QgsRectangle &srcRect, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsMapLayerLegendUtils": ["hasLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "hasLegendNodeOrder(QgsLayerTreeLayer *nodeLayer)", "setLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex, const QString &newLabel)", "legendNodeOrder(QgsLayerTreeLayer *nodeLayer)", "legendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "setLegendNodeOrder(QgsLayerTreeLayer *nodeLayer, const QList< int > &order)"],
    "QgsMultiRenderChecker": ["setControlPathPrefix(const QString &prefix)"],
    "QgsLabelAttributes": ["setAngle(double angle)", "setBufferStyle(Qt::BrushStyle style)", "colorIsSet() const ", "setBorderColor(const QColor &color)", "italicIsSet() const ", "multilineEnabled() const ", "italic() const ", "setStrikeOut(bool enable)", "boldIsSet() const ", "angleIsAuto() const ", "bufferEnabled() const ", "setBorderStyle(Qt::PenStyle style)", "setBufferSize(double size, int type)", "familyIsSet() const ", "setMultilineEnabled(bool useMultiline)", "bold() const ", "bufferSize() const ", "offsetIsSet() const ", "bufferStyle() const ", "selectedOnly() const ", "sizeIsSet() const ", "sizeType() const ", "setOffset(double x, double y, int type)", "textIsSet() const ", "setFamily(const QString &family)", "underline() const ", "unitsName(int units)", "offsetType() const ", "setBold(bool enable)", "borderStyleIsSet() const ", "family() const ", "Units", "setBufferColor(const QColor &color)", "strikeOut() const ", "borderWidthIsSet() const ", "bufferStyleIsSet() const ", "size() const ", "color() const ", "text() const ", "alignmentIsSet() const ", "setSize(double size, int type)", "setItalic(bool enable)", "setSelectedOnly(bool selectedonly)", "unitsCode(const QString &name)", "setAlignment(int alignment)", "bufferSizeIsSet() const ", "bufferColorIsSet() const ", "setColor(const QColor &color)", "borderColorIsSet() const ", "setBorderWidth(int width)", "yOffset() const ", "setUnderline(bool enable)", "alignmentName(int alignment)", "setText(const QString &text)", "underlineIsSet() const ", "borderColor() const ", "angleIsSet() const ", "xOffset() const ", "alignmentCode(const QString &name)", "bufferSizeType() const ", "angle() const ", "borderWidth() const ", "alignment() const ", "bufferColor() const ", "setBufferEnabled(bool useBufferFlag)", "strikeOutIsSet() const ", "setAutoAngle(bool state)", "borderStyle() const "],
    "QgsLineSymbolV2": ["setWidth(double width)", "QgsLineSymbolV2(const QgsSymbolLayerV2List &layers=QgsSymbolLayerV2List())", "width() const ", "renderPolyline(const QPolygonF &points, const QgsFeature *f, QgsRenderContext &context, int layer=-1, bool selected=false)"],
    "QgsTextEditWidgetFactory": ["QgsTextEditWidgetFactory(const QString &name)"],
    "QgsRendererRangeV2": ["label() const ", "QgsRendererRangeV2(const QgsRendererRangeV2 &range)", "QgsRendererRangeV2(double lowerValue, double upperValue, QgsSymbolV2 *symbol, const QString &label, bool render=true)", "upperValue() const ", "lowerValue() const ", "symbol() const ", "setUpperValue(double upperValue)", "operator<(const QgsRendererRangeV2 &other) const ", "swap(QgsRendererRangeV2 &other)", "renderState() const ", "toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const ", "setRenderState(bool render)", "setLowerValue(double lowerValue)", "setSymbol(QgsSymbolV2 *s)", "dump() const ", "setLabel(const QString &label)"],
    "QgsTextAnnotationItem": ["QgsTextAnnotationItem(QgsMapCanvas *canvas)"],
    "QgsStyleV2": ["symbolSaved(const QString &name, QgsSymbolV2 *symbol)"],
    "QgsMarkerLineSymbolLayerV2": ["markerAngle(const QPolygonF &points, bool isRing, int vertex)", "renderPolylineInterval(const QPolygonF &points, QgsSymbolV2RenderContext &context)", "setIntervalMapUnitScale(const QgsMapUnitScale &scale)", "renderPolylineVertex(const QPolygonF &points, QgsSymbolV2RenderContext &context, Placement placement=Vertex)", "QgsMarkerLineSymbolLayerV2(bool rotateMarker=DEFAULT_MARKERLINE_ROTATE, double interval=DEFAULT_MARKERLINE_INTERVAL)", "intervalUnit() const ", "setIntervalUnit(QgsSymbolV2::OutputUnit unit)", "intervalMapUnitScale() const ", "renderPolylineCentral(const QPolygonF &points, QgsSymbolV2RenderContext &context)"],
    "QgsEffectDrawModeComboBox": ["QgsEffectDrawModeComboBox(QWidget *parent=nullptr)"],
    "CharacterWidget": ["updateFontMerging(bool enable)", "characterSelected(QChar character)", "updateColumns(int cols)", "setCharacter(QChar character)", "getColumns() const ", "getSquareSize() const "],
    "QgsVector": ["rotateBy(double rot) const ", "perpVector() const ", "x() const ", "operator*(QgsVector v) const ", "angle(QgsVector v) const ", "operator*(double scalar) const ", "length() const ", "normal() const ", "operator/(double scalar) const ", "y() const ", "QgsVector(double x, double y)"],
    "QgsSymbolLayerV2": ["setOutputUnit(QgsSymbolV2::OutputUnit unit)", "QgsSymbolLayerV2(QgsSymbolV2::SymbolType type, bool locked=false)", "dxfOffset(const QgsDxfExport &e, QgsSymbolV2RenderContext &context) const ", "writeDxf(QgsDxfExport &e, double mmMapUnitScaleFactor, const QString &layerName, QgsSymbolV2RenderContext *context, const QgsFeature *f, QPointF shift=QPointF(0.0, 0.0)) const ", "stopRender(QgsSymbolV2RenderContext &context)=0", "dxfBrushColor(QgsSymbolV2RenderContext &context) const ", "renderingPass() const ", "setLocked(bool locked)", "setRenderingPass(int renderingPass)", "ogrFeatureStyle(double mmScaleFactor, double mapUnitScaleFactor) const ", "outputUnit() const ", "toSld(QDomDocument &doc, QDomElement &element, const QgsStringMap &props) const ", "startRender(QgsSymbolV2RenderContext &context)=0", "dxfWidth(const QgsDxfExport &e, QgsSymbolV2RenderContext &context) const ", "subSymbol()", "dxfBrushStyle() const ", "dxfCustomDashPattern(QgsSymbolV2::OutputUnit &unit) const ", "mapUnitScale() const ", "dxfColor(QgsSymbolV2RenderContext &context) const ", "dxfPenStyle() const ", "setMapUnitScale(const QgsMapUnitScale &scale)", "type() const ", "isLocked() const ", "drawPreviewIcon(QgsSymbolV2RenderContext &context, QSize size)=0"],
    "QgsLegendSettings": ["boxSpace() const ", "mapScale() const ", "setBoxSpace(double s)", "setSymbolSize(QSizeF s)", "splitLayer() const ", "setLineSpacing(double s)", "dpi() const ", "setColumnCount(int c)", "setMmPerMapUnit(double mmPerMapUnit)", "setMapScale(double scale)", "setUseAdvancedEffects(bool use)", "setTitle(const QString &t)", "setColumnSpace(double s)", "columnCount() const ", "setStyle(QgsComposerLegendStyle::Style s, const QgsComposerLegendStyle &style)", "wmsLegendSize() const ", "setSplitLayer(bool s)", "lineSpacing() const ", "mmPerMapUnit() const ", "title() const ", "setFontColor(const QColor &c)", "setDpi(int dpi)", "symbolSize() const ", "fontColor() const ", "columnSpace() const ", "setWmsLegendSize(QSizeF s)", "useAdvancedEffects() const ", "equalColumnWidth() const ", "wrapChar() const ", "setEqualColumnWidth(bool s)", "setWrapChar(const QString &t)"],
    "QgsRasterResampleFilter": ["setMaxOversampling(double os)", "QgsRasterResampleFilter(QgsRasterInterface *input=nullptr)", "zoomedInResampler() const ", "zoomedOutResampler() const ", "maxOversampling() const "],
    "QgsVectorLayerUndoCommandChangeGeometry": ["QgsVectorLayerUndoCommandChangeGeometry(QgsVectorLayerEditBuffer *buffer, QgsFeatureId fid, QgsGeometry *newGeom)"],
    "QgsMapToPixelSimplifier": ["QgsMapToPixelSimplifier(int simplifyFlags, double tolerance)", "simplifyFlags() const ", "setSimplifyFlags(int simplifyFlags)"],
    "QgsHtmlAnnotationItem": ["QgsHtmlAnnotationItem(QgsMapCanvas *canvas, QgsVectorLayer *vlayer=nullptr, bool hasFeature=false, int feature=0)", "htmlPage() const ", "vectorLayer() const ", "setHTMLPage(const QString &htmlFile)"],
    "QgsWkbException": ["QgsWkbException(QString const &what)"],
    "QgsSmartGroupEditorDialog": ["QgsSmartGroupEditorDialog(QgsStyleV2 *style, QWidget *parent=nullptr)"],
    "QgsRendererV2AbstractMetadata": ["icon() const ", "createRendererFromSld(QDomElement &elem, QGis::GeometryType geomType)", "setIcon(const QIcon &icon)", "QgsRendererV2AbstractMetadata(const QString &name, const QString &visibleName, const QIcon &icon=QIcon())", "visibleName() const ", "name() const "],
    "QgsBrushStyleComboBox": ["setBrushStyle(Qt::BrushStyle style)", "QgsBrushStyleComboBox(QWidget *parent=nullptr)", "iconForBrush(Qt::BrushStyle style)", "brushStyle() const "],
    "QgsAttributeTableAction": ["featureForm()", "execute()", "QgsAttributeTableAction(const QString &name, QgsDualView *dualView, int action, const QModelIndex &fieldIdx)"],
    "QgsColorSwatchDelegate": ["QgsColorSwatchDelegate(QWidget *parent=nullptr)"],
    "QgsRasterRenderer": ["opacity() const ", "MinMaxOrigin", "QgsRasterRenderer(QgsRasterInterface *input=nullptr, const QString &type=\"\")", "rasterTransparency() const ", "type() const ", "minMaxOriginLabel(int theOrigin)", "setAlphaBand(int band)", "minMaxOriginFromName(const QString &theName)", "setOpacity(double opacity)", "usesTransparency() const ", "alphaBand() const ", "setRasterTransparency(QgsRasterTransparency *t)", "minMaxOriginName(int theOrigin)"],
    "QgsTicksScaleBarStyle": ["TickPosition", "setTickPosition(TickPosition p)", "QgsTicksScaleBarStyle(const QgsComposerScaleBar *bar)"],
    "QgsComposerItemGroup": ["items()", "itemDestroyed()", "QgsComposerItemGroup(QgsComposition *c)", "childItemDeleted(QgsComposerItem *item)"],
    "QgsRangeWidgetFactory": ["QgsRangeWidgetFactory(const QString &name)"],
    "QgsVectorLayer": ["saveLayerToProject()", "diagramRenderer() const ", "invalidateSymbolCountedFlag()", "committedAttributeValuesChanges(const QString &layerId, const QgsChangedAttributesMap &changedAttributesValues)", "committedFeaturesRemoved(const QString &layerId, const QgsFeatureIds &deletedFeatureIds)", "None", "committedFeaturesAdded(const QString &layerId, const QgsFeatureList &addedFeatures)", "excludeAttributesWFS() const ", "setExcludeAttributesWMS(const QSet< QString > &att)", "writeSld(QDomNode &node, QDomDocument &doc, QString &errorMessage) const ", "actions()", "geometryChanged(QgsFeatureId fid, QgsGeometry &geom)", "committedGeometriesChanges(const QString &layerId, const QgsGeometryMap &changedGeometries)", "commitErrors()", "attributeAliases() const ", "vectorJoins() const ", "diagramLayerSettings() const ", "committedAttributesAdded(const QString &layerId, const QList< QgsField > &addedAttributes)", "attributeValueChanged(QgsFeatureId fid, int idx, const QVariant &)", "EditorLayout", "setDiagramLayerSettings(const QgsDiagramLayerSettings &s)", "setExcludeAttributesWFS(const QSet< QString > &att)", "excludeAttributesWMS() const "],
    "QgsSymbolLayerV2Utils": [
        "encodeSldBrushStyle(Qt::BrushStyle style)", "colorRampPreviewIcon(QgsVectorColorRampV2 *ramp, QSize size)", "decodeSldFontWeight(const QString &str)", "decodePenJoinStyle(const QString &str)", "wellKnownMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &name, const QColor &color, const QColor &borderColor, Qt::PenStyle borderStyle, double borderWidth=-1, double size=-1)", "createRotationElement(QDomDocument &doc, QDomElement &element, const QString &rotationFunc)", "clearSymbolMap(QgsSymbolV2Map &symbols)", "labelTextToSld(QDomDocument &doc, QDomElement &element, const QString &label, const QFont &font, const QColor &color=QColor(), double size=-1)", "saveSymbol(const QString &symbolName, QgsSymbolV2 *symbol, QDomDocument &doc)", "encodePenCapStyle(Qt::PenCapStyle style)", "drawStippledBackground(QPainter *painter, QRect rect)", "needSvgFill(QDomElement &element)", "decodePoint(const QString &str)", "decodeSldLineJoinStyle(const QString &str)", "encodeSldFontWeight(int weight)", "decodeSldFontStyle(const QString &str)", "decodeSldRealVector(const QString &s)", "encodeRealVector(const QVector< qreal > &v)", "encodeSldFontStyle(QFont::Style style)", "decodeScaleMethod(const QString &str)", "externalGraphicFromSld(QDomElement &element, QString &path, QString &mime, QColor &color, double &size)", "needFontMarker(QDomElement &element)", "decodeSldAlpha(const QString &str)", "saveColorRamp(const QString &name, QgsVectorColorRampV2 *ramp, QDomDocument &doc)", "createVendorOptionElement(QDomDocument &doc, const QString &name, const QString &value)", "createLineLayerFromSld(QDomElement &element)", "createMarkerLayerFromSld(QDomElement &element)", "loadSymbols(QDomElement &element)", "encodeColor(const QColor &color)", "saveSymbols(QgsSymbolV2Map &symbols, const QString &tagName, QDomDocument &doc)", "createDisplacementElement(QDomDocument &doc, QDomElement &element, QPointF offset)", "createFillLayerFromSld(QDomElement &element)", "decodeBrushStyle(const QString &str)", "encodeBrushStyle(Qt::BrushStyle style)", "createSvgParameterElement(QDomDocument &doc, const QString &name, const QString &value)", "loadSymbolLayer(QDomElement &element)", "decodeOutputUnit(const QString &str)", "encodeSldLineJoinStyle(Qt::PenJoinStyle style)", "encodePenStyle(Qt::PenStyle style)", "decodeSldBrushStyle(const QString &str)", "createOnlineResourceElement(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format)", "encodePoint(QPointF point)", "needMarkerLine(QDomElement &element)", "onlineResourceFromSldElement(QDomElement &element, QString &path, QString &format)", "decodePenCapStyle(const QString &str)", "displacementFromSldElement(QDomElement &element, QPointF &offset)", "createGeometryElement(QDomDocument &doc, QDomElement &element, const QString &geomFunc)", "hasExternalGraphic(QDomElement &element)",
        "externalGraphicToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &mime, const QColor &color, double size=-1)", "opacityFromSldElement(QDomElement &element, QString &alphaFunc)", "getVendorOptionList(QDomElement &element)", "decodeRealVector(const QString &s)", "convertPolygonSymbolizerToPointMarker(QDomElement &element, QgsSymbolLayerV2List &layerList)", "decodeBlendMode(const QString &s)", "fillFromSld(QDomElement &element, Qt::BrushStyle &brushStyle, QColor &color)", "decodeSldLineCapStyle(const QString &str)", "externalMarkerFromSld(QDomElement &element, QString &path, QString &format, int &markIndex, QColor &color, double &size)", "decodeMapUnitScale(const QString &str)", "externalMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format, int *markIndex=nullptr, const QColor &color=QColor(), double size=-1)", "encodeScaleMethod(QgsSymbolV2::ScaleMethod scaleMethod)", "encodeMapUnitScale(const QgsMapUnitScale &mapUnitScale)", "hasWellKnownMark(QDomElement &element)", "rotationFromSldElement(QDomElement &element, QString &rotationFunc)", "decodeColor(const QString &str)", "needLinePatternFill(QDomElement &element)", "decodePenStyle(const QString &str)", "encodeSldUom(QgsSymbolV2::OutputUnit unit, double *scaleFactor)", "saveProperties(QgsStringMap props, QDomDocument &doc, QDomElement &element)", "createFunctionElement(QDomDocument &doc, QDomElement &element, const QString &function)", "createOpacityElement(QDomDocument &doc, QDomElement &element, const QString &alphaFunc)", "createSymbolLayerV2ListFromSld(QDomElement &element, QGis::GeometryType geomType, QgsSymbolLayerV2List &layers)", "functionFromSldElement(QDomElement &element, QString &function)", "symbolLayerPreviewIcon(QgsSymbolLayerV2 *layer, QgsSymbolV2::OutputUnit u, QSize size, const QgsMapUnitScale &scale=QgsMapUnitScale())", "geometryFromSldElement(QDomElement &element, QString &geomFunc)", "needEllipseMarker(QDomElement &element)", "loadColorRamp(QDomElement &element)", "parseProperties(QDomElement &element)", "colorRampPreviewPixmap(QgsVectorColorRampV2 *ramp, QSize size)", "needPointPatternFill(QDomElement &element)", "encodeSldRealVector(const QVector< qreal > &v)", "encodeSldLineCapStyle(Qt::PenCapStyle style)", "symbolPreviewIcon(QgsSymbolV2 *symbol, QSize size)", "getSvgParameterList(QDomElement &element)", "encodeSldAlpha(int alpha)", "needSvgMarker(QDomElement &element)", "fillToSld(QDomDocument &doc, QDomElement &element, Qt::BrushStyle brushStyle, const QColor &color=QColor())", "lineFromSld(QDomElement &element, Qt::PenStyle &penStyle, QColor &color, double &width, Qt::PenJoinStyle *penJoinStyle=nullptr, Qt::PenCapStyle *penCapStyle=nullptr, QVector< qreal > *customDashPattern=nullptr, double *dashOffset=nullptr)", "encodeOutputUnit(QgsSymbolV2::OutputUnit unit)", "decodeSldUom(const QString &str, double *scaleFactor)", "encodePenJoinStyle(Qt::PenJoinStyle style)"],
    "QgsVectorFileWriter::SetOption": ["SetOption(const QString &docString, const QStringList &values, const QString &defaultValue, bool allowNone=false)"],
    "QgsDataItem": ["populate(const QVector< QgsDataItem * > &children)", "icon()", "emitDataChanged(QgsDataItem *item)", "setIcon(const QIcon &icon)", "emitEndRemoveItems()", "emitBeginRemoveItems(QgsDataItem *parent, int first, int last)", "State", "beginInsertItems(QgsDataItem *parent, int first, int last)", "refresh()", "Type", "setCapabilities(const Capabilities &capabilities)", "toolTip() const ", "hasChildren()", "dataChanged(QgsDataItem *item)", "refresh(QVector< QgsDataItem * > children)", "setCrs(QgsCoordinateReferenceSystem crs)", "deleteLater(QVector< QgsDataItem * > &items)", "name() const ", "emitDataChanged()", "setToolTip(const QString &msg)", "setName(const QString &name)", "endRemoveItems()", "endInsertItems()", "paramWidget()", "setPath(const QString &path)", "children() const ", "populate(bool foreground=false)", "Capability", "rowCount()", "stateChanged(QgsDataItem *item, QgsDataItem::State oldState)", "childrenCreated()", "emitStateChanged(QgsDataItem *item, QgsDataItem::State oldState)", "emitEndInsertItems()", "findItem(QVector< QgsDataItem * > items, QgsDataItem *item)", "capabilities2() const ", "type() const ", "emitBeginInsertItems(QgsDataItem *parent, int first, int last)", "path() const ", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "setIconName(const QString &iconName)"],
    "QgsBrightnessContrastFilter": ["contrast() const ", "setContrast(int contrast)", "brightness() const ", "setBrightness(int brightness)", "QgsBrightnessContrastFilter(QgsRasterInterface *input=nullptr)"],
    "QgsRelationReferenceConfigDlg": ["QgsRelationReferenceConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsTextDiagram": ["Shape", "Orientation"],
    "QgsClipToMinMaxEnhancement": ["QgsClipToMinMaxEnhancement(QGis::DataType, double, double)"],
    "QgsPaperItem": ["QgsPaperItem(QgsComposition *c)", "QgsPaperItem(qreal x, qreal y, qreal width, qreal height, QgsComposition *composition)"],
    "QgsRendererRulePropsDialog": ["QgsRendererRulePropsDialog(QgsRuleBasedRendererV2::Rule *rule, QgsVectorLayer *layer, QgsStyleV2 *style, QWidget *parent=nullptr, QgsMapCanvas *mapCanvas=nullptr)", "rule()", "buildExpression()", "testFilter()"],
    "QgsLayerTreeNode": ["QgsLayerTreeNode(const QgsLayerTreeNode &other)", "readCommonXML(QDomElement &element)", "writeCommonXML(QDomElement &element)", "QgsLayerTreeNode(NodeType t)"],
    "QgsVectorFileWriter::HiddenOption": ["HiddenOption(const QString &value)"],
    "QgsCptCitySelectionItem": ["selectionsList() const ", "QgsCptCitySelectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "parseXML()"],
    "QgsOSMWay": ["QgsOSMWay(QgsOSMId id, const QList< QgsOSMId > &nodes)", "nodes() const "],
    "QgsErrorItem": ["QgsErrorItem(QgsDataItem *parent, const QString &error, const QString &path)"],
    "QgsAtlasComposition": ["setFeatureFilter(const QString &expression)", "QgsAtlasComposition(QgsComposition *composition)", "None", "lastFeature()", "setSortKeyAttributeName(const QString &fieldName)", "sortKeyAttributeName() const ", "featureFilter() const ", "filterFeatures() const ", "setSortFeatures(bool doSort)", "setSortAscending(bool ascending)", "sortFeatures() const ", "nextFeature()", "sortAscending() const ", "setFilterFeatures(bool doFilter)", "composition()", "writeXML(QDomElement &elem, QDomDocument &doc) const ", "prevFeature()", "firstFeature()"],
    "QgsClipper": ["trimPolygon(QPolygonF &pts, const QgsRectangle &clipRect)"],
    "QgsMultiBandColorRenderer": ["greenContrastEnhancement() const ", "blueBand() const ", "setGreenBand(int band)", "setRedBand(int band)", "QgsMultiBandColorRenderer(QgsRasterInterface *input, int redBand, int greenBand, int blueBand, QgsContrastEnhancement *redEnhancement=nullptr, QgsContrastEnhancement *greenEnhancement=nullptr, QgsContrastEnhancement *blueEnhancement=nullptr)", "redBand() const ", "create(const QDomElement &elem, QgsRasterInterface *input)", "greenBand() const ", "setBlueBand(int band)", "redContrastEnhancement() const ", "blueContrastEnhancement() const "],
    "QgsComposerItemCommand": ["previousState() const ", "QgsComposerItemCommand(QgsComposerItem *item, const QString &text, QUndoCommand *parent=nullptr)", "restoreState(QDomDocument &stateDoc) const ", "afterState() const ", "saveState(QDomDocument &stateDoc) const "],
    "QgsComposerShape": ["Shape", "setShapeType(QgsComposerShape::Shape s)", "shapeType() const ", "QgsComposerShape(qreal x, qreal y, qreal width, qreal height, QgsComposition *composition)", "QgsComposerShape(QgsComposition *composition)"],
    "QgsWMSLegendNode": ["QgsWMSLegendNode(QgsLayerTreeLayer *nodeLayer, QObject *parent=nullptr)"],
    "QgsRelationReferenceWidgetWrapper": ["QgsRelationReferenceWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor, QgsMapCanvas *canvas, QgsMessageBar *messageBar, QWidget *parent=nullptr)"],
    "QgsColorRampShader": ["QgsColorRampShader(double theMinimumValue=0.0, double theMaximumValue=255.0)", "clip() const ", "ColorRamp_TYPE", "setClip(bool clip)"],
    "QgsSingleSymbolRendererV2Widget": ["changeSingleSymbol()", "scaleMethodChanged(QgsSymbolV2::ScaleMethod scaleMethod)", "QgsSingleSymbolRendererV2Widget(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "create(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "sizeScaleFieldChanged(const QString &fldName)", "showSymbolLevels()"],
    "QgsRequestHandler": ["setDefaultHeaders()"],
    "QgsEditorWidgetRegistry": ["createSearchWidget(const QString &widgetId, QgsVectorLayer *vl, int fieldIdx, const QgsEditorWidgetConfig &config, QWidget *parent, const QgsAttributeEditorContext &context=QgsAttributeEditorContext())"],
    "QgsPropertyKey": ["QgsPropertyKey(const QString &name=\"\")", "name()", "find(QString &propertyName)"],
    "QgsFontMarkerSymbolLayerV2": ["character() const ", "setCharacter(QChar ch)", "QgsFontMarkerSymbolLayerV2(const QString &fontFamily=DEFAULT_FONTMARKER_FONT, QChar chr=DEFAULT_FONTMARKER_CHR, double pointSize=DEFAULT_FONTMARKER_SIZE, const QColor &color=DEFAULT_FONTMARKER_COLOR, double angle=DEFAULT_FONTMARKER_ANGLE)", "setFontFamily(const QString &family)", "fontFamily() const ", "create(const QgsStringMap &properties=QgsStringMap())", "createFromSld(QDomElement &element)"],
    "QgsScaleRangeWidget": ["setScaleRange(double min, double max)", "setMinimumScale(double scale)", "QgsScaleRangeWidget(QWidget *parent=nullptr)", "setMaximumScale(double scale)"],
    "QgsFeatureRendererV2": ["usingSymbolLevels() const ", "_getLineString(QPolygonF &pts, QgsRenderContext &context, QgsConstWkbPtr wkb, bool clipToExtent=true)", "renderFeatureWithSymbol(QgsFeature &feature, QgsSymbolV2 *symbol, QgsRenderContext &context, int layer, bool selected, bool drawVertexMarker)", "type() const ", "clone() const =0", "setScaleMethodToSymbol(QgsSymbolV2 *symbol, int scaleMethod)", "Capabilities", "setUsingSymbolLevels(bool usingSymbolLevels)", "QgsFeatureRendererV2(const QString &type)", "_getPoint(QPointF &pt, QgsRenderContext &context, QgsConstWkbPtr wkb)", "_getPolygon(QPolygonF &pts, QList< QPolygonF > &holes, QgsRenderContext &context, QgsConstWkbPtr wkb, bool clipToExtent=true)"],
    "QgsRendererV2Registry": ["instance()"],
    "QgsClassificationWidgetWrapper": ["QgsClassificationWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsCsException": ["QgsCsException(QString const &what)"],
    "QgsDiagramRendererV2": ["rendererName() const =0", "setDiagram(QgsDiagram *d)", "writeXML(QDomElement &layerElem, QDomDocument &doc, const QgsVectorLayer *layer) const =0", "readXML(const QDomElement &elem, const QgsVectorLayer *layer)=0", "_readXML(const QDomElement &elem, const QgsVectorLayer *layer)", "diagram() const ", "renderDiagram(const QgsFeature &feature, QgsRenderContext &c, QPointF pos) const ", "QgsDiagramRendererV2(const QgsDiagramRendererV2 &other)", "_writeXML(QDomElement &rendererElem, QDomDocument &doc, const QgsVectorLayer *layer) const "],
    "QgsMapCanvas": ["WheelAction", "setLayerSet(QList< QgsMapCanvasLayer > &layers)", "clearExtentHistory()", "setCurrentLayer(QgsMapLayer *layer)", "updateOverview()", "enableOverviewMode(QgsMapOverviewCanvas *overview)"],
    "QgsMapToolEdit": ["QgsMapToolEdit(QgsMapCanvas *canvas)", "createGeometryRubberBand(QGis::GeometryType geometryType=QGis::Line, bool alternativeBand=false) const "],
    "QgsLayerTreeViewDefaultActions": ["actionShowFeatureCount(QObject *parent=nullptr)", "actionShowInOverview(QObject *parent=nullptr)", "showFeatureCount()", "uniqueGroupName(QgsLayerTreeGroup *parentGroup)", "actionZoomToLayer(QgsMapCanvas *canvas, QObject *parent=nullptr)", "zoomToGroup()", "zoomToLayers(QgsMapCanvas *canvas, const QList< QgsMapLayer * > &layers)", "zoomToLayer(QgsMapCanvas *canvas)", "zoomToLayer()", "makeTopLevel()", "renameGroupOrLayer()", "actionAddGroup(QObject *parent=nullptr)", "addGroup()", "actionGroupSelected(QObject *parent=nullptr)", "groupSelected()", "actionRemoveGroupOrLayer(QObject *parent=nullptr)", "zoomToGroup(QgsMapCanvas *canvas)", "actionZoomToGroup(QgsMapCanvas *canvas, QObject *parent=nullptr)", "QgsLayerTreeViewDefaultActions(QgsLayerTreeView *view)", "removeGroupOrLayer()", "actionRenameGroupOrLayer(QObject *parent=nullptr)", "actionMakeTopLevel(QObject *parent=nullptr)", "showInOverview()"],
    "QgsDataDefinedValueDialog": ["symbolDataDefined() const ", "dataDefinedChanged()", "init(const QString &description)", "setDataDefined(QgsSymbolV2 *symbol, const QgsDataDefined &dd)=0", "value(const QgsSymbolV2 *) const =0", "symbolDataDefined(const QgsSymbolV2 *) const =0"],
    "QgsLayerItem": ["iconLine()", "iconTable()", "iconPoint()", "iconRaster()", "QgsLayerItem(QgsDataItem *parent, const QString &name, const QString &path, const QString &uri, LayerType layerType, const QString &providerKey)", "iconPolygon()", "LayerType", "iconDefault()"],
    "pal::CostCalculator": ["setPolygonCandidatesCost(int nblp, QList< LabelPosition * > &lPos, RTree< pal::FeaturePart *, double, 2, double > *obstacles, double bbx[4], double bby[4])"],
    "pal::Util": ["unmulti(const GEOSGeometry *the_geom)"],
    "QgsDataCollectionItem": ["iconDir()", "iconDataCollection()", "QgsDataCollectionItem(QgsDataItem *parent, const QString &name, const QString &path=QString::null)", "addChild(QgsDataItem *item)"],
    "QgsMapOverviewCanvas": ["destinationSrsChanged()", "QgsMapOverviewCanvas(QWidget *parent=nullptr, QgsMapCanvas *mapCanvas=nullptr)", "layerRepaintRequested()", "hasCrsTransformEnabled(bool flag)", "enableAntiAliasing(bool flag)", "layerSet() const ", "updateFullExtent()", "mapRenderingFinished()"],
    "QgsMapCanvasSnappingUtils": ["QgsMapCanvasSnappingUtils(QgsMapCanvas *canvas, QObject *parent=nullptr)"],
    "QgsVectorLayerEditPassthrough": ["QgsVectorLayerEditPassthrough(QgsVectorLayer *layer)"],
    "QgsLineSymbolLayerV2": ["offset() const ", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "renderPolygonOutline(const QPolygonF &points, QList< QPolygonF > *rings, QgsSymbolV2RenderContext &context)", "setWidthUnit(QgsSymbolV2::OutputUnit unit)", "renderPolyline(const QPolygonF &points, QgsSymbolV2RenderContext &context)=0", "setWidthMapUnitScale(const QgsMapUnitScale &scale)", "width() const ", "widthMapUnitScale() const ", "offsetMapUnitScale() const ", "widthUnit() const ", "setWidth(double width)", "offsetUnit() const ", "QgsLineSymbolLayerV2(bool locked=false)", "setOffset(double offset)", "setOffsetUnit(QgsSymbolV2::OutputUnit unit)"],
    "QgsStyleV2GroupSelectionDialog": ["QgsStyleV2GroupSelectionDialog(QgsStyleV2 *style, QWidget *parent=nullptr)"],
    "QgsCheckboxWidgetWrapper": ["QgsCheckboxWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsShapeburstFillSymbolLayerV2": ["setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "ShapeburstColorType", "distanceMapUnitScale() const ", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "QgsShapeburstFillSymbolLayerV2(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, ShapeburstColorType colorType=SimpleTwoColor, int blurRadius=0, bool useWholeShape=true, double maxDistance=5)", "offsetMapUnitScale() const ", "create(const QgsStringMap &properties=QgsStringMap())"],
    "QgsRangeConfigDlg": ["QgsRangeConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)", "rangeWidgetChanged(int index)"],
    "QgsMapMouseEvent": ["SnappingMode"],
    "QgsDataDefined": ["insertExpressionParam(const QString &key, const QVariant &param)", "expression()", "isActive() const ", "setActive(bool active)"],
    "QgsScaleExpression": ["Type", "operator bool() const "],
    "QgsSvgMarkerSymbolLayerV2": ["outlineWidthMapUnitScale() const ", "path() const ", "setOutlineWidthMapUnitScale(const QgsMapUnitScale &scale)", "setOutlineWidth(double w)", "outlineWidthUnit() const ", "QgsSvgMarkerSymbolLayerV2(const QString &name=DEFAULT_SVGMARKER_NAME, double size=DEFAULT_SVGMARKER_SIZE, double angle=DEFAULT_SVGMARKER_ANGLE, QgsSymbolV2::ScaleMethod scaleMethod=DEFAULT_SCALE_METHOD)", "create(const QgsStringMap &properties=QgsStringMap())", "setOutlineWidthUnit(QgsSymbolV2::OutputUnit unit)", "setPath(const QString &path)", "createFromSld(QDomElement &element)", "outlineWidth() const "],
    "QgsDateTimeEditWrapper": ["QgsDateTimeEditWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor, QWidget *parent=nullptr)"],
    "QgsMultiBandColorRendererWidget": ["QgsMultiBandColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "create(QgsRasterLayer *layer, const QgsRectangle &theExtent)", "setFromRenderer(const QgsRasterRenderer *r)", "loadMinMax(int theBandNo, double theMin, double theMax, int theOrigin)"],
    "QgsAnimatedIcon": ["setIconPath(const QString &iconPath)", "iconPath() const ", "icon() const ", "onFrameChanged()"],
    "pal::Layer": ["LabelMode", "displayAll() const ", "UpsideDownLabels"],
    "QgsComposerGroupItem": ["QgsComposerGroupItem(const QString &text)"],
    "QgsGraphDirector": ["buildProgress(int, int) const ", "buildMessage(const QString &) const ", "addProperter(QgsArcProperter *prop)"],
    "QgsScaleComboBox": ["QgsScaleComboBox(QWidget *parent=nullptr)", "updateScales(const QStringList &scales=QStringList())"],
    "QgsLabelingEngineV2": ["processProvider(QgsAbstractLabelProvider *provider, QgsRenderContext &context, pal::Pal &p)", "Flag"],
    "QgsSymbolV2SelectorDialog": ["moveLayerByOffset(int offset)", "QgsSymbolV2SelectorDialog(QgsSymbolV2 *symbol, QgsStyleV2 *style, const QgsVectorLayer *vl, QWidget *parent=nullptr, bool embedded=false)", "lockLayer()", "moveLayerUp()", "updateUi()", "addLayer()", "moveLayerDown()", "layerChanged()", "loadSymbol()", "setWidget(QWidget *widget)", "updateLayerPreview()", "symbolModified()", "updateLockButton()", "removeLayer()", "currentLayer()", "updatePreview()"],
    "QgsCacheIndexFeatureId": ["QgsCacheIndexFeatureId(QgsVectorLayerCache *)"],
    "QgsSymbolLayerV2Widget": ["registerDataDefinedButton(QgsDataDefinedButton *button, const QString &propertyName, QgsDataDefinedButton::DataType type, const QString &description)", "setSymbolLayer(QgsSymbolLayerV2 *layer)=0", "updateDataDefinedProperty()", "QgsSymbolLayerV2Widget(QWidget *parent, const QgsVectorLayer *vl=nullptr)", "symbolLayer()=0"],
    "QgsRendererV2PropertiesDialog": ["apply()", "onOK()", "QgsRendererV2PropertiesDialog(QgsVectorLayer *layer, QgsStyleV2 *style, bool embedded=false)"],
    "QgsAttributeTableFilterModel": ["fidToIndexList(QgsFeatureId fid)", "FilterMode", "mapFromMaster(const QModelIndex &sourceIndex) const ", "mapToMaster(const QModelIndex &proxyIndex) const "],
    "QgsRasterRendererWidget": ["min(int index=0)", "rasterLayer() const ", "selectedBand(int index=0)", "stdDev()", "setMax(const QString &value, int index=0)", "LoadMinMaxAlgo", "setMin(const QString &value, int index=0)", "setRasterLayer(QgsRasterLayer *layer)", "max(int index=0)", "QgsRasterRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent)", "setStdDev(const QString &value)", "renderer()=0"],
    "QgsLabelCandidate": ["QgsLabelCandidate(const QRectF &r, double c)"],
    "QgsLayerTreeLayer": ["readXML(QDomElement &element)", "QgsLayerTreeLayer(const QString &layerId, const QString &name=QString())", "QgsLayerTreeLayer(const QgsLayerTreeLayer &other)", "setVisible(Qt::CheckState visible)", "QgsLayerTreeLayer(QgsMapLayer *layer)", "attachToLayer()", "isVisible() const ", "setLayerName(const QString &n)", "layerName() const ", "layerId() const ", "layer() const ", "registryLayersAdded(const QList< QgsMapLayer * > &layers)", "registryLayersWillBeRemoved(const QStringList &layerIds)"],
    "QgsLayerTreeModel": ["nodeAddedChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "legendParent(QgsLayerTreeModelLegendNode *legendNode) const ", "disconnectFromRootNode()", "invalidateLegendMapBasedData()", "layerNeedsUpdate()", "legendNodeRowCount(QgsLayerTreeModelLegendNode *node) const ", "layerLegendChanged()", "connectToRootNode()", "legendIconEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const ", "addLegendToLayer(QgsLayerTreeLayer *nodeL)", "legendRootRowCount(QgsLayerTreeLayer *nL) const ", "nodeVisibilityChanged(QgsLayerTreeNode *node)", "legendRootIndex(int row, int column, QgsLayerTreeLayer *nL) const ", "Flag", "disconnectFromLayer(QgsLayerTreeLayer *nodeLayer)", "legendNodeFlags(QgsLayerTreeModelLegendNode *node) const ", "nodeRemovedChildren()", "nodeWillAddChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "nodeLayerWillBeUnloaded()", "legendNodeIndex(int row, int column, QgsLayerTreeModelLegendNode *node) const ", "removeLegendFromLayer(QgsLayerTreeLayer *nodeLayer)", "nodeLayerLoaded()", "nodeCustomPropertyChanged(QgsLayerTreeNode *node, const QString &key)", "nodeWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "legendNodeDataChanged()", "legendNodeData(QgsLayerTreeModelLegendNode *node, int role) const ", "connectToLayer(QgsLayerTreeLayer *nodeLayer)", "legendCleanup()", "legendInvalidateMapBasedData()", "iconGroup()", "legendFilterByScale() const ", "indexOfParentLayerTreeNode(QgsLayerTreeNode *parentNode) const ", "disconnectFromLayers(QgsLayerTreeGroup *parentGroup)", "connectToLayers(QgsLayerTreeGroup *parentGroup)", "legendEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const "],
    "QgsConditionalLayerStyles": ["rowStyles()"],
    "QgsUuidWidgetFactory": ["QgsUuidWidgetFactory(const QString &name)"],
    "QgsNetworkAccessManager": ["QgsNetworkAccessManager(QObject *parent=nullptr)", "requestCreated(QNetworkReply *)", "requestTimedOut(QNetworkReply *)", "requestAboutToBeCreated(QNetworkAccessManager::Operation, const QNetworkRequest &, QIODevice *)"],
    "QgsRunProcess": ["dialogGone()", "processError(QProcess::ProcessError)", "create(const QString &action, bool capture)", "stdoutAvailable()", "processExit(int, QProcess::ExitStatus)", "stderrAvailable()"],
    "QgsFieldModel": ["isField(const QString &expression)", "FieldRoles", "updateModel()", "allowExpression()"],
    "QgsPaintEffect": ["QgsPaintEffect(const QgsPaintEffect &other)"],
    "QgsGeos": ["asGeos(const QgsAbstractGeometryV2 *geom, double precision=0)", "getGEOSHandler()", "coordSeqPoint(const GEOSCoordSequence *cs, int i, bool hasZ, bool hasM)", "reshapeGeometry(const QgsLineStringV2 &reshapeWithLine, int *errorCode, QString *errorMsg=nullptr) const ", "fromGeosPolygon(const GEOSGeometry *geos)"],
    "QgsColorBrewerPalette": ["listSchemes()", "listSchemeVariants(const QString &schemeName)", "listSchemeColors(const QString &schemeName, int colors)"],
    "QgsGraduatedSymbolRendererV2Widget": ["updateGraduatedSymbolIcon()", "classifyGraduated()", "selectedRanges()", "sizeScaleFieldChanged(const QString &fldName)", "rowsMoved()", "rangesClicked(const QModelIndex &idx)", "labelFormatChanged()", "disconnectUpdateHandlers()", "refreshRanges(bool reset=false)", "create(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "reapplyColorRamp()", "scaleMethodChanged(QgsSymbolV2::ScaleMethod scaleMethod)", "changeRange(int rangeIdx)", "findSymbolForRange(double lowerBound, double upperBound, const QgsRangeList &ranges) const ", "changeCurrentValue(QStandardItem *item)", "changeRangeSymbol(int rangeIdx)", "connectUpdateHandlers()", "modelDataChanged()", "changeSelectedSymbols()", "showSymbolLevels()", "rowsOrdered()", "graduatedColumnChanged(const QString &field)", "reapplySizes()", "QgsGraduatedSymbolRendererV2Widget(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "changeGraduatedSymbol()", "rangesDoubleClicked(const QModelIndex &idx)", "updateUiFromRenderer(bool updateCount=true)"],
    "QgsGpsdConnection": ["QgsGpsdConnection(const QString &host, qint16 port, const QString &device)"],
    "Point3D": ["Point3D(const Point3D &p)"],
    "QgsVectorLayerUndoCommand": ["cache()", "QgsVectorLayerUndoCommand(QgsVectorLayerEditBuffer *buffer)", "layer()"],
    "QgsDataDefinedRotationDialog": ["QgsDataDefinedRotationDialog(const QList< QgsSymbolV2 * > &symbolList, QgsVectorLayer *layer)"],
    "QgsException": ["QgsException(QString const &what)"],
    "QgsEllipseSymbolLayerV2Widget": ["QgsEllipseSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "create(const QgsVectorLayer *vl)"],
    "QgsSingleBandPseudoColorRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &theExtent)", "setFromRenderer(const QgsRasterRenderer *r)", "QgsSingleBandPseudoColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "Mode", "loadMinMax(int theBandNo, double theMin, double theMax, int theOrigin)"],
    "QgsSvgCache": ["instance()", "replaceParamsAndCacheSvg(QgsSvgCacheEntry *entry)", "cachePicture(QgsSvgCacheEntry *entry, bool forceVectorOutput=false)", "cacheImage(QgsSvgCacheEntry *entry)", "takeEntryFromList(QgsSvgCacheEntry *entry)"],
    "QgsMessageViewer": ["setCheckBoxText(const QString &text)", "setMessageAsPlainText(const QString &msg)", "checkBoxState()", "setCheckBoxState(Qt::CheckState state)", "setCheckBoxVisible(bool visible)", "setCheckBoxQSettingsLabel(const QString &label)", "setMessageAsHtml(const QString &msg)", "QgsMessageViewer(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags, bool deleteOnClose=true)"],
    "QgsLabelSorter": ["QgsLabelSorter(const QgsMapSettings &mapSettings)", "operator()(pal::LabelPosition *lp1, pal::LabelPosition *lp2) const "],
    "QgsVectorFieldSymbolLayer": ["AngleUnits", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "setScale(double s)", "distanceMapUnitScale() const ", "yAttribute() const ", "setXAttribute(const QString &attribute)", "VectorFieldType", "setDistanceUnit(QgsSymbolV2::OutputUnit unit)", "setAngleOrientation(AngleOrientation orientation)", "xAttribute() const ", "scale() const ", "angleOrientation() const ", "setAngleUnits(AngleUnits units)", "AngleOrientation", "vectorFieldType() const ", "create(const QgsStringMap &properties=QgsStringMap())", "setYAttribute(const QString &attribute)", "distanceUnit() const ", "angleUnits() const ", "createFromSld(QDomElement &element)", "setVectorFieldType(VectorFieldType type)"],
    "QgsLinearlyInterpolatedDiagramRenderer": ["setLowerValue(double val)", "setClassificationAttribute(int index)", "classificationAttributeIsExpression() const ", "classificationAttributeExpression() const ", "setUpperSize(QSizeF s)", "setLowerSize(QSizeF s)", "classificationAttribute() const ", "lowerValue() const ", "upperSize() const ", "setClassificationAttributeIsExpression(bool isExpression)", "upperValue() const ", "setDiagramSettings(const QgsDiagramSettings &s)", "setClassificationAttributeExpression(const QString &expression)", "lowerSize() const ", "setUpperValue(double val)"],
    "QgsNMEAConnection": ["processGSVSentence(const char *data, int len)", "processVTGSentence(const char *data, int len)", "processGGASentence(const char *data, int len)", "QgsNMEAConnection(QIODevice *dev)", "processGSASentence(const char *data, int len)", "processRMCSentence(const char *data, int len)"],
    "QgsPhotoConfigDlg": ["QgsPhotoConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsPreviewEffect": ["QgsPreviewEffect(QObject *parent)", "PreviewMode"],
    "QgsGeometryGeneratorSymbolLayerWidget": ["QgsGeometryGeneratorSymbolLayerWidget(const QgsVectorLayer *vl, QWidget *parent=nullptr)"],
    "QgsProjectFileTransform": ["updateRevision(const QgsProjectVersion &version)", "convertRasterProperties(QDomDocument &doc, QDomNode &parentNode, QDomElement &rasterPropertiesElem, QgsRasterLayer *rlayer)"],
    "QgsCentroidFillSymbolLayerV2": ["create(const QgsStringMap &properties=QgsStringMap())", "pointOnSurface() const ", "createFromSld(QDomElement &element)", "setPointOnSurface(bool pointOnSurface)"],
    "QgsAdvancedDigitizingCanvasItem": ["QgsAdvancedDigitizingCanvasItem(QgsMapCanvas *canvas, QgsAdvancedDigitizingDockWidget *cadDockWidget)"],
    "QgsCategorizedSymbolRendererV2Widget": ["applyColorRamp()", "categoryColumnChanged(const QString &field)", "addCategories()", "sizeScaleFieldChanged(const QString &fldName)", "deleteCategories()", "QgsCategorizedSymbolRendererV2Widget(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "updateCategorizedSymbolIcon()", "scaleMethodChanged(QgsSymbolV2::ScaleMethod scaleMethod)", "getColorRamp()", "changeCategorizedSymbol()", "create(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "populateCategories()", "selectedCategoryList()", "addCategory()", "rowsMoved()", "changeCategorySymbol()", "categoriesDoubleClicked(const QModelIndex &idx)", "updateUiFromRenderer()", "deleteAllCategories()", "showSymbolLevels()"],
    "QgsAttributeTypeLoadDialog": ["QgsAttributeTypeLoadDialog(QgsVectorLayer *vl)"],
    "QgsRangeWidgetWrapper": ["QgsRangeWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor, QWidget *parent=nullptr)", "valueChanged(const QVariant &)"],
    "QgsNetworkReplyParser": ["None"],
    "QgsSingleBoxScaleBarStyle": ["QgsSingleBoxScaleBarStyle(const QgsComposerScaleBar *bar)"],
    "QgsMapLayerAction": ["Target"],
    "QgsSingleSymbolRendererV2": ["createFromSld(QDomElement &element, QGis::GeometryType geomType)", "scaleMethod() const ", "setSizeScaleField(const QString &fieldOrExpression)", "QgsSingleSymbolRendererV2(QgsSymbolV2 *symbol)", "symbol() const ", "sizeScaleField() const ", "setSymbol(QgsSymbolV2 *s)", "setScaleMethod(QgsSymbolV2::ScaleMethod scaleMethod)"],
    "QgsDetailedItemData": ["category() const ", "icon() const ", "setTitle(const QString &theTitle)", "setChecked(const bool theFlag)", "detail() const ", "setCategory(const QString &theCategory)", "setCheckable(const bool theFlag)", "isEnabled() const ", "isCheckable() const ", "setIcon(const QPixmap &theIcon)", "title() const ", "isRenderedAsWidget() const ", "isChecked() const ", "setDetail(const QString &theDetail)", "setEnabled(bool theFlag)"],
    "QgsPluginLayerType": ["QgsPluginLayerType(const QString &name)", "name()"],
    "QgsRenderContext": ["coordinateTransform() const ", "drawEditingInformation() const ", "QgsRenderContext(const QgsRenderContext &rh)", "setPainter(QPainter *p)", "setUseRenderingOptimization(bool enabled)", "setMapToPixel(const QgsMapToPixel &mtp)", "selectionColor() const ", "setVectorSimplifyMethod(const QgsVectorSimplifyMethod &simplifyMethod)", "extent() const ", "setDrawEditingInformation(bool b)", "constPainter() const ", "scaleFactor() const ", "labelingEngine() const ", "renderingStopped() const ", "mapToPixel() const ", "rendererScale() const ", "painter()", "setScaleFactor(double factor)", "setExtent(const QgsRectangle &extent)", "forceVectorOutput() const ", "setForceVectorOutput(bool force)", "setRasterScaleFactor(double factor)", "setLabelingEngine(QgsLabelingEngineInterface *iface)", "setRendererScale(double scale)", "rasterScaleFactor() const ", "setRenderingStopped(bool stopped)", "setSelectionColor(const QColor &color)"],
    "QgsMessageBar": ["MessageLevel", "currentItem()", "QgsMessageBar(QWidget *parent=nullptr)"],
    "QgsNewMemoryLayerDialog": ["QgsNewMemoryLayerDialog(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags)"],
    "QgsBrowserModel": ["dataItem(const QModelIndex &idx) const ", "endRemoveItems()", "connectItem(QgsDataItem *item)", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "itemStateChanged(QgsDataItem *item, QgsDataItem::State oldState)", "ItemDataRole", "findItem(QgsDataItem *item, QgsDataItem *parent=nullptr) const ", "removeFavourite(const QModelIndex &index)", "addFavouriteDirectory(const QString &favDir)", "beginInsertItems(QgsDataItem *parent, int first, int last)", "QgsBrowserModel(QObject *parent=nullptr)", "itemDataChanged(QgsDataItem *item)", "removeRootItems()", "updateProjectHome()", "endInsertItems()"],
    "QgsExpression::NodeCondition": ["NodeCondition(const WhenThenList &conditions, Node *elseExp=nullptr)", "NodeCondition(WhenThenList *conditions, Node *elseExp=nullptr)"],
    "QgsComposerEffect": ["setCompositionMode(QPainter::CompositionMode compositionMode)"],
    "QgsHighlight": ["QgsHighlight(QgsMapCanvas *mapCanvas, const QgsGeometry *geom, QgsMapLayer *layer)", "layer() const ", "QgsHighlight(QgsMapCanvas *mapCanvas, const QgsGeometry *geom, QgsVectorLayer *layer)"],
    "QgsRasterSymbolLegendNode": ["QgsRasterSymbolLegendNode(QgsLayerTreeLayer *nodeLayer, const QColor &color, const QString &label, QObject *parent=nullptr)"],
    "QgsExternalResourceWidgetFactory": ["QgsExternalResourceWidgetFactory(const QString &name)"],
    "QgsComposerTableV2": ["QgsComposerTableV2(QgsComposition *composition, bool createUndoCommands)"],
    "QgsVectorDataProvider": ["convertValue(QVariant::Type type, const QString &value)", "clearMinMaxCache()", "pushError(const QString &msg)", "fillMinMaxCache()"],
    "pal::PriorityQueue": ["sort()", "getSizeByPos()", "getBest()", "getSize()", "setPriority(int key, double new_p)", "getId(int key)", "insert(int key, double p)", "upheap(int key)", "decreaseKey(int key)", "print()", "downheap(int id)", "remove(int key)", "isIn(int key)"],
    "QgsVectorFileWriter::StringOption": ["StringOption(const QString &docString, const QString &defaultValue=QString())"],
    "QgsLabelPosition": ["QgsLabelPosition(int id, double r, const QVector< QgsPoint > &corners, const QgsRectangle &rect, double w, double h, const QString &layer, const QString &labeltext, const QFont &labelfont, bool upside_down, bool diagram=false, bool pinned=false, const QString &providerId=QString())"],
    "QgsColorRampComboBox": ["QgsColorRampComboBox(QWidget *parent=nullptr)", "colorRampChanged(int index)"],
    "QgsSvgSelectorWidget": ["imagesListView()", "svgSelected(const QString &path)", "filePathLineEdit()", "selectorLayout()", "QgsSvgSelectorWidget(QWidget *parent=nullptr)", "relativePathCheckbox()", "currentSvgPathToName() const ", "currentSvgPath() const ", "groupsTreeView()", "filePathButton()", "create(QWidget *parent=nullptr)", "populateList()"],
    "QgsEnumerationWidgetWrapper": ["QgsEnumerationWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsComposerMap": ["GridAnnotationFormat", "previewMode() const ", "GridFrameStyle", "extent() const ", "setPreviewMode(PreviewMode m)", "drawCanvasItems() const ", "setCacheUpdated(bool u=false)", "setDrawCanvasItems(bool b)", "extentChanged()", "GridAnnotationPosition", "GridAnnotationDirection", "GridStyle"],
    "QgsDerivativeFilter": ["QgsDerivativeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsNumericScaleBarStyle": ["QgsNumericScaleBarStyle(QgsComposerScaleBar *bar)"],
    "QgsSymbolV2RenderContext": ["renderContext() const ", "setMapUnitScale(const QgsMapUnitScale &scale)", "renderContext()", "outputUnit() const ", "outputLineWidth(double width) const ", "outputPixelSize(double size) const ", "selected() const ", "setRenderHints(int hints)", "QgsSymbolV2RenderContext(QgsRenderContext &c, QgsSymbolV2::OutputUnit u, qreal alpha=1.0, bool selected=false, int renderHints=0, const QgsFeature *f=nullptr, const QgsFields *fields=nullptr, const QgsMapUnitScale &mapUnitScale=QgsMapUnitScale())", "setSelected(bool selected)", "setOutputUnit(QgsSymbolV2::OutputUnit u)", "setFeature(const QgsFeature *f)", "renderHints() const ", "mapUnitScale() const "],
    "QgsIdentifyMenu": ["MenuLevel", "execWithSingleResult()", "allowMultipleReturn()", "resultsIfExternalAction()", "showFeatureActions()", "maxFeatureDisplay()", "maxLayerDisplay()"],
    "QgsPointLocator_VisitorNearestEdge": ["QgsPointLocator_VisitorNearestEdge(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPoint &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "ParametricLine": ["getControlPoint(int number) const =0", "getDegree() const =0", "calcPoint(float t, Point3D *)=0", "calcFirstDer(float t, Vector3D *v)=0", "remove(int i)=0", "setParent(ParametricLine *paral)=0", "calcSecDer(float t, Vector3D *v)=0", "getParent() const =0", "changeDirection()=0", "add(ParametricLine *pl)=0", "getControlPoly() const =0", "setControlPoly(QVector< Point3D * > *cp)=0"],
    "QgsComposerAttributeTable": ["QgsComposerAttributeTable(QgsComposition *composition)"],
    "QgisInterface": ["helpToolBar()=0", "actionToggleFullScreen()=0", "newLayerMenu()=0", "actionNodeTool()=0", "actionCopyFeatures()=0", "actionNewProject()=0", "actionNewVectorLayer()=0", "actionCancelEdits()=0", "actionSplitParts()=0", "actionShowComposerManager()=0", "actionHelpContents()=0", "actionOpenFieldCalculator()=0", "actionSaveProjectAs()=0", "actionLayerProperties()=0", "helpMenu()=0", "actionSimplifyFeature()=0", "actionAddAllToOverview()=0", "databaseMenu()=0", "actionCheckQgisVersion()=0", "actionSaveProject()=0", "actionCancelAllEdits()=0", "layerTreeView()=0", "advancedDigitizeToolBar()=0", "actionAbout()=0", "webMenu()=0", "actionDuplicateLayer()=0", "actionShowPythonDialog()=0", "vectorToolBar()=0", "actionPasteFeatures()=0", "actionPrintComposer()=0", "actionSplitFeatures()=0", "actionPluginListSeparator()=0", "pluginManagerInterface()=0", "actionRemoveAllFromOverview()=0", "digitizeToolBar()=0", "actionSaveActiveLayerEdits()=0", "firstRightStandardMenu()=0", "projectMenu()=0", "actionProjectProperties()=0", "actionCopyLayerStyle()=0", "actionAllEdits()=0", "actionAddOgrLayer()=0", "actionDeleteRing()=0", "actionAddWmsLayer()=0", "settingsMenu()=0", "actionAddRing()=0", "fileToolBar()=0", "editMenu()=0", "pluginMenu()=0", "mapNavToolToolBar()=0", "vectorMenu()=0", "actionCutFeatures()=0", "actionSaveMapAsImage()=0", "actionMoveFeature()=0", "windowMenu()=0", "actionShowSelectedLayers()=0", "actionDeleteSelected()=0", "actionOptions()=0", "layerToolBar()=0", "actionDeletePart()=0", "actionAddPgLayer()=0", "databaseToolBar()=0", "actionRollbackAllEdits()=0", "actionShowAllLayers()=0", "viewMenu()=0", "actionRollbackEdits()=0", "actionSaveAllEdits()=0", "actionPasteLayerStyle()=0", "actionQgisHomePage()=0", "attributesToolBar()=0", "actionExit()=0", "rasterToolBar()=0", "actionHideAllLayers()=0", "actionAddToOverview()=0", "layerMenu()=0", "actionToggleEditing()=0", "actionLayerSaveAs()=0", "actionManagePlugins()=0", "actionCustomProjection()=0", "rasterMenu()=0", "actionAddPart()=0", "pluginToolBar()=0", "actionRemoveLayer()=0", "actionOpenTable()=0", "actionSaveEdits()=0", "actionOpenProject()=0", "webToolBar()=0", "actionAddFeature()=0", "actionHideSelectedLayers()=0", "actionAddRasterLayer()=0"],
    "QgsCollapsibleGroupBoxBasic": ["QgsCollapsibleGroupBoxBasic(const QString &title, QWidget *parent=nullptr)", "checkToggled(bool ckd)", "QgsCollapsibleGroupBoxBasic(QWidget *parent=nullptr)", "init()", "clearModifiers()", "titleRect() const ", "checkClicked(bool ckd)", "updateStyle()", "toggleCollapsed()"],
    "QgsOptionsDialogBase": ["setSettings(QSettings *settings)", "updateOptionsListVerticalTabs()", "optionsStackedWidget_CurrentChanged(int indx)", "warnAboutMissingObjects()", "optionsStackedWidget_WidgetRemoved(int indx)", "updateWindowTitle()"],
    "QgsAttributeEditor": ["QgsAttributeEditor(QObject *parent, QgsVectorLayer *vl=nullptr, int idx=-1)", "setValue(QWidget *widget, QgsVectorLayer *vl, int idx, const QVariant &value)", "retrieveValue(QWidget *widget, QgsVectorLayer *vl, int idx, QVariant &value)"],
    "QgsPluginLayerRenderer": ["QgsPluginLayerRenderer(QgsPluginLayer *layer, QgsRenderContext &rendererContext)"],
    "QgsAbstractLabelProvider": ["Flag"],
    "DualEdgeTriangulation": ["DualEdgeTriangulation(int nop, Triangulation *decorator)", "setDecorator(Triangulation *d)"],
    "QgsProjectionSelector": ["setSelectedAuthId(const QString &authId)", "setSelectedCrsId(long theCRSID)", "QgsProjectionSelector(QWidget *parent, const char *name=\"\", const Qt::WindowFlags &fl=nullptr)", "selectedProj4String()", "setSelectedCrsName(const QString &theCRSName)", "selectedName()", "sridSelected(const QString &theSRID)"],
    "QgsImageFillSymbolLayer": ["setOutlineWidthMapUnitScale(const QgsMapUnitScale &scale)", "outlineWidthMapUnitScale() const ", "setOutlineWidthUnit(QgsSymbolV2::OutputUnit unit)", "outlineWidthUnit() const ", "applyDataDefinedSettings(QgsSymbolV2RenderContext &context)"],
    "QgsSymbologyV2Conversion": ["brushStyle2QString(Qt::BrushStyle brushstyle)", "qString2PenStyle(const QString &string)", "penStyle2QString(Qt::PenStyle penstyle)", "qString2BrushStyle(const QString &string)"],
    "QgsRelationEditorWidget": ["setEditorContext(const QgsAttributeEditorContext &context)", "setRelationFeature(const QgsRelation &relation, const QgsFeature &feature)", "setFeature(const QgsFeature &feature)"],
    "QgsDashSpaceDialog": ["QgsDashSpaceDialog(const QVector< qreal > &v, QWidget *parent=nullptr, const Qt::WindowFlags &f=nullptr)", "dashDotVector() const "],
    "QgsAuthMethodConfig": ["setMethod(const QString &method)", "setUri(const QString &uri)"],
    "QgsXmlUtils": ["readRectangle(const QDomElement &element)", "readMapUnits(const QDomElement &element)", "writeMapUnits(QGis::UnitType units, QDomDocument &doc)", "writeRectangle(const QgsRectangle &rect, QDomDocument &doc)"],
    "QgsSurfaceV2": ["surfaceToPolygon() const =0"],
    "QgsDrawSourceWidget": ["create()", "QgsDrawSourceWidget(QWidget *parent=nullptr)"],
    "QgsRelationWidgetWrapper": ["QgsRelationWidgetWrapper(QgsVectorLayer *vl, const QgsRelation &relation, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsLayerTreeGroup": ["QgsLayerTreeGroup(const QString &name=QString(), Qt::CheckState checked=Qt::Checked)", "nodeVisibilityChanged(QgsLayerTreeNode *node)", "QgsLayerTreeGroup(const QgsLayerTreeGroup &other)", "layerDestroyed()"],
    "QgsSLConnect": ["sqlite3_close_v2(sqlite3 *)", "sqlite3_close(sqlite3 *)", "sqlite3_open(const char *filename, sqlite3 **ppDb)", "sqlite3_open_v2(const char *filename, sqlite3 **ppDb, int flags, const char *zVfs)"],
    "QgsVectorColorBrewerColorRampV2": ["listSchemeNames()", "QgsVectorColorBrewerColorRampV2(const QString &schemeName=DEFAULT_COLORBREWER_SCHEMENAME, int colors=DEFAULT_COLORBREWER_COLORS)", "setColors(int colors)", "loadPalette()", "colors() const ", "schemeName() const ", "create(const QgsStringMap &properties=QgsStringMap())", "setSchemeName(const QString &schemeName)", "listSchemeVariants(const QString &schemeName)"],
    "QgsPointCompare": ["operator()(const QgsPoint &p1, const QgsPoint &p2) const ", "QgsPointCompare(double tolerance)"],
    "QgsRasterShaderFunction": ["minimumValue() const ", "QgsRasterShaderFunction(double theMinimumValue=0.0, double theMaximumValue=255.0)", "maximumValue() const ", "minimumMaximumRange() const ", "legendSymbologyItems(QList< QPair< QString, QColor > > &symbolItems) const "],
    "QgsRasterPyramidsOptionsWidget": ["pyramidsFormat() const ", "overviewList() const ", "overviewListChanged()", "QgsRasterPyramidsOptionsWidget(QWidget *parent=nullptr, const QString &provider=\"gdal\")", "setRasterLayer(QgsRasterLayer *rasterLayer)", "checkAllLevels(bool checked)", "setRasterFileName(const QString &file)", "resamplingMethod() const ", "configOptions() const ", "someValueChanged()", "apply()", "createOptionsWidget()"],
    "QgsRasterFillSymbolLayerWidget": ["QgsRasterFillSymbolLayerWidget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "create(const QgsVectorLayer *vl)"],
    "QgsErrorMessage": ["function() const ", "line() const ", "file() const ", "tag() const ", "message() const "],
    "QgsComposerLabel": ["QgsComposerLabel(QgsComposition *composition)", "text()", "setHtmlState(int state)", "refreshExpressionContext()", "setText(const QString &text)", "font() const ", "htmlState()", "setFont(const QFont &f)"],
    "QgsDefaultPluginLayerLegend": ["QgsDefaultPluginLayerLegend(QgsPluginLayer *pl)"],
    "QgsLayerTreeRegistryBridge": ["groupWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "QgsLayerTreeRegistryBridge(QgsLayerTreeGroup *root, QObject *parent=nullptr)", "removeLayersFromRegistry(const QStringList &layerIds)", "isEnabled() const ", "layersAdded(const QList< QgsMapLayer * > &layers)", "newLayersVisible() const ", "setEnabled(bool enabled)", "layersWillBeRemoved(const QStringList &layerIds)", "setNewLayersVisible(bool enabled)", "groupRemovedChildren()"],
    "QgsLabelComponent": ["setUseCenter(const bool use)", "setPictureBuffer(const double buffer)", "offset() const ", "dpiRatio() const ", "setSize(const QgsPoint &point)", "setRotation(const double rotation)", "picture() const ", "rotationOffset() const ", "setRotationOffset(const double rotation)", "setCenter(const QgsPoint &point)", "pictureBuffer() const ", "setDpiRatio(const double ratio)", "size() const ", "setUseRotation(const bool use)", "setPicture(QPicture *picture)", "text() const ", "center() const ", "setOrigin(const QgsPoint &point)", "setUseOrigin(const bool use)", "setText(const QString &text)", "useOrigin() const ", "useCenter() const ", "origin() const ", "setOffset(const QgsPoint &point)", "rotation() const ", "useRotation() const "],
    "QgsMarkerSymbolLayerV2": ["setAngle(double angle)", "sizeMapUnitScale() const ", "scaleMethod() const ", "VerticalAnchorPoint", "offsetMapUnitScale() const ", "renderPoint(QPointF point, QgsSymbolV2RenderContext &context)=0", "setOffsetUnit(QgsSymbolV2::OutputUnit unit)", "setSizeUnit(QgsSymbolV2::OutputUnit unit)", "setVerticalAnchorPoint(VerticalAnchorPoint v)", "setHorizontalAnchorPoint(HorizontalAnchorPoint h)", "_rotatedOffset(QPointF offset, double angle)", "writeSldMarker(QDomDocument &doc, QDomElement &element, const QgsStringMap &props) const ", "offsetUnit() const ", "offset() const ", "sizeUnit() const ", "QgsMarkerSymbolLayerV2(bool locked=false)", "setSize(double size)", "setSizeMapUnitScale(const QgsMapUnitScale &scale)", "size() const ", "horizontalAnchorPoint() const ", "setScaleMethod(QgsSymbolV2::ScaleMethod scaleMethod)", "setOffset(QPointF offset)", "markerOffset(QgsSymbolV2RenderContext &context, double &offsetX, double &offsetY) const ", "verticalAnchorPoint() const ", "HorizontalAnchorPoint", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "angle() const "],
    "QgsApplication": ["QgsApplication(int &argc, char **argv, bool GUIenabled, const QString &customConfigPath=QString(), const QString &platformName=\"desktop\")"],
    "QgsExpression::Visitor": ["visit(const NodeLiteral &n)=0", "visit(const NodeFunction &n)=0", "visit(const NodeCondition &n)=0", "visit(const NodeUnaryOperator &n)=0", "visit(const NodeInOperator &n)=0", "visit(const NodeBinaryOperator &n)=0", "visit(const NodeColumnRef &n)=0"],
    "QgsComposerTable": ["QgsComposerTable(QgsComposition *composition)"],
    "QgsFillSymbolV2": ["setAngle(double angle)", "QgsFillSymbolV2(const QgsSymbolLayerV2List &layers=QgsSymbolLayerV2List())", "renderPolygon(const QPolygonF &points, QList< QPolygonF > *rings, const QgsFeature *f, QgsRenderContext &context, int layer=-1, bool selected=false)"],
    "QgsCentroidFillSymbolLayerV2Widget": ["create(const QgsVectorLayer *vl)", "QgsCentroidFillSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)"],
    "QgsLinePatternFillSymbolLayerWidget": ["create(const QgsVectorLayer *vl)", "QgsLinePatternFillSymbolLayerWidget(const QgsVectorLayer *vl, QWidget *parent=nullptr)"],
    "QgsAttributeTableMapLayerAction": ["QgsAttributeTableMapLayerAction(const QString &name, QgsDualView *dualView, QgsMapLayerAction *action, const QModelIndex &fieldIdx)", "execute()"],
    "QgsScaleBarStyle": ["drawLabels(QPainter *p) const ", "QgsScaleBarStyle(const QgsComposerScaleBar *bar)", "name() const =0", "calculateBoxSize() const "],
    "QgsScaleVisibilityDialog": ["QgsScaleVisibilityDialog(QWidget *parent=nullptr, const QString &title=QString(), QgsMapCanvas *mapCanvas=nullptr)"],
    "QgsGraduatedSymbolRendererV2": ["scaleMethod() const ", "QgsGraduatedSymbolRendererV2(const QString &attrName=QString(), const QgsRangeList &ranges=QgsRangeList())", "updateRangeUpperValue(int rangeIndex, double value)", "sortByValue(Qt::SortOrder order=Qt::AscendingOrder)", "createRenderer(QgsVectorLayer *vlayer, const QString &attrName, int classes, Mode mode, QgsSymbolV2 *symbol, QgsVectorColorRampV2 *ramp, bool inverted=false, const QgsRendererRangeV2LabelFormat &legendFormat=QgsRendererRangeV2LabelFormat())", "addClass(QgsSymbolV2 *symbol)", "setInvertedColorRamp(bool inverted)", "setMode(Mode mode)", "updateRangeSymbol(int rangeIndex, QgsSymbolV2 *symbol)", "setSizeScaleField(const QString &fieldOrExpression)", "updateRangeLowerValue(int rangeIndex, double value)", "GraduatedMethod", "deleteClass(int idx)", "deleteAllClasses()", "Mode", "setClassAttribute(const QString &attr)", "sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)", "symbolForValue(double value)", "setScaleMethod(QgsSymbolV2::ScaleMethod scaleMethod)", "updateRangeLabel(int rangeIndex, const QString &label)", "ranges() const ", "mode() const ", "sizeScaleField() const ", "classAttribute() const "],
    "QgsPaintEffectWidget": ["QgsPaintEffectWidget(QWidget *parent=nullptr)"],
    "QgsPseudoColorShader": ["QgsPseudoColorShader(double theMinimumValue=0.0, double theMaximumValue=255.0)", "classBreakMax2() const ", "classBreakMin2() const ", "classBreakMin3() const ", "classBreakMax1() const ", "classBreakMin1() const "],
    "QgsDetailedItemDelegate": ["QgsDetailedItemDelegate(QObject *parent=nullptr)", "horizontalSpacing() const ", "setHorizontalSpacing(int theValue)", "setVerticalSpacing(int theValue)", "verticalSpacing() const "],
    "FieldSorter": ["FieldSorter(QgsAtlasComposition::SorterKeys &keys, bool ascending=true)", "operator()(const QPair< QgsFeatureId, QString > &id1, const QPair< QgsFeatureId, QString > &id2)"],
    "QgsMessageLogConsole": ["logMessage(const QString &message, const QString &tag, QgsMessageLog::MessageLevel level)"],
    "QgsEncodingFileDialog": ["saveUsedEncoding()", "QgsEncodingFileDialog(QWidget *parent=nullptr, const QString &caption=QString(), const QString &directory=QString(), const QString &filter=QString(), const QString &encoding=QString())", "pbnCancelAll_clicked()"],
    "QgsConnectionPoolGroup": ["onConnectionExpired()", "acquire()", "invalidateConnections()", "release(T conn)", "initTimer(QObject *parent)", "QgsConnectionPoolGroup(const QString &ci)"],
    "QgsValueMapWidgetWrapper": ["QgsValueMapWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsRuleBasedRendererV2::Rule": ["label() const ", "createFromSld(QDomElement &element, QGis::GeometryType geomType)", "scaleMaxDenom() const ", "scaleMinDenom() const ", "initFilter()", "dependsOnScale() const ", "toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const ", "save(QDomDocument &doc, QgsSymbolV2Map &symbolMap) const ", "setLabel(const QString &label)", "symbol()"],
    "QgsExpression::NodeUnaryOperator": ["op() const ", "NodeUnaryOperator(UnaryOperator op, Node *operand)", "operand() const "],
    "QgsLegendModelV2": ["QgsLegendModelV2(QgsLayerTreeGroup *rootNode, QObject *parent=nullptr)"],
    "QgsAction": ["QgsAction(ActionType type, const QString &name, const QString &action, const QString &icon, bool capture)", "ActionType", "QgsAction(ActionType type, const QString &name, const QString &action, bool capture)"],
    "QgsSimpleFillSymbolLayerV2Widget": ["setBrushStyle()", "create(const QgsVectorLayer *vl)", "offsetChanged()", "QgsSimpleFillSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "borderWidthChanged()", "setBorderColor(const QColor &color)", "setColor(const QColor &color)", "borderStyleChanged()"],
    "QgsValueRelationWidgetWrapper": ["orderByKeyLessThan(const QgsValueRelationWidgetWrapper::ValueRelationItem &p1, const QgsValueRelationWidgetWrapper::ValueRelationItem &p2)", "orderByValueLessThan(const QgsValueRelationWidgetWrapper::ValueRelationItem &p1, const QgsValueRelationWidgetWrapper::ValueRelationItem &p2)", "QgsValueRelationWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)", "createCache(const QgsEditorWidgetConfig &config)", "None"],
    "QgsCptCityColorRampItem": ["init()", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QStringList &variantList, bool initialize=false)", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QString &variantName=QString(), bool initialize=false)", "ramp() const "],
    "QgsMasterPasswordResetDialog": ["QgsMasterPasswordResetDialog(QWidget *parent=nullptr)", "requestMasterPasswordReset(QString *newpass, QString *oldpass, bool *keepbackup)"],
    "QgsRasterRange": ["min() const ", "max() const ", "setMax(double theMax)", "setMin(double theMin)"],
    "QgsSymbolV2": ["mapUnitScale() const ", "layer() const ", "None", "QgsSymbolV2(SymbolType type, const QgsSymbolLayerV2List &layers)", "RenderHint", "renderHints() const ", "outputUnit() const ", "type() const ", "clone() const =0", "startRender(QgsRenderContext &context, const QgsFields *fields=nullptr)", "toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const ", "setColor(const QColor &color)", "setRenderHints(int hints)", "color() const ", "dump() const ", "setMapUnitScale(const QgsMapUnitScale &scale)", "setOutputUnit(QgsSymbolV2::OutputUnit u)", "stopRender(QgsRenderContext &context)"],
    "QgsComposition": ["setSnapGridOffsetX(const double offset)", "moveSelectedItemsToTop()", "setGridStyle(const GridStyle s)", "worldFileMap() const ", "setSnapToGridEnabled(const bool b)", "atlasComposition()", "setSnapGridOffsetY(const double offset)", "setSmartGuidesEnabled(const bool b)", "endMultiFrameCommand()", "alignSelectedItemsLeft()", "setPrintAsRaster(const bool enabled)", "snapGridResolution() const ", "setGenerateWorldFile(const bool enabled)", "alignmentSnap() const ", "setSnapGridResolution(const double r)", "alignSelectedItemsBottom()", "moveSelectedItemsToBottom()", "init()", "moveItemToBottom(QgsComposerItem *item)", "selectNextByZOrder(const ZValueDirection direction)", "gridStyle() const ", "setPrintResolution(const int dpi)", "lowerSelectedItems()", "raiseSelectedItems()", "alignSelectedItemsRight()", "snapGridOffsetY() const ", "getComposerItemBelow(QgsComposerItem *item) const ", "setWorldFileMap(QgsComposerMap *map)", "nPagesChanged()", "getComposerItemAbove(QgsComposerItem *item) const ", "setGridPen(const QPen &p)", "printResolution() const ", "smartGuidesEnabled() const ", "snapGridOffsetX() const ", "printAsRaster() const ", "gridVisible() const ", "moveItemToTop(QgsComposerItem *item)", "plotStyle() const ", "raiseItem(QgsComposerItem *item)", "setGridVisible(const bool b)", "snapToGridEnabled() const ", "setPlotStyle(const QgsComposition::PlotStyle style)", "lowerItem(QgsComposerItem *item)", "alignSelectedItemsTop()", "generateWorldFile() const ", "gridPen() const ", "alignSelectedItemsVCenter()", "paperSizeChanged()", "snapLinesVisible() const ", "ZValueDirection", "setAlignmentSnap(const bool s)", "alignSelectedItemsHCenter()", "QgsComposition(const QgsMapSettings &mapSettings)", "PaperOrientation", "beginMultiFrameCommand(QgsComposerMultiFrame *multiFrame, const QString &text, const QgsComposerMultiFrameMergeCommand::Context c=QgsComposerMultiFrameMergeCommand::Unknown)", "preventCursorChange() const "],
    "QgsGml": ["dataProgressAndSteps(int progress, int totalSteps)", "dataReadProgress(int progress)", "QgsGml(const QString &typeName, const QString &geometryAttribute, const QgsFields &fields)", "totalStepsUpdate(int totalSteps)"],
    "QgsGenericFeatureSelectionManager": ["QgsGenericFeatureSelectionManager(QObject *parent=nullptr)", "QgsGenericFeatureSelectionManager(const QgsFeatureIds &initialSelection, QObject *parent=nullptr)"],
    "QgsExpressionFieldBuffer": ["None", "expressions() const "],
    "QgsGPSConnection": ["Status", "nmeaSentenceReceived(const QString &substring)", "stateChanged(const QgsGPSInformation &info)"],
    "QgsMapServiceException": ["code() const ", "QgsMapServiceException(const QString &code, const QString &message)", "message() const "],
    "QgsMapToPixel": ["toMapPoint(double x, double y) const ", "transform(QgsPoint *p) const ", "transformInPlace(float &x, float &y) const ", "toMapCoordinates(int x, int y) const ", "transform() const "],
    "QgsPenJoinStyleComboBox": ["penJoinStyle() const ", "setPenJoinStyle(Qt::PenJoinStyle style)", "QgsPenJoinStyleComboBox(QWidget *parent=nullptr)"],
    "QgsPaintEngineHack": ["fixEngineFlags(QPaintEngine *engine)", "fixFlags()"],
    "QgsRasterDataProvider": ["colorName(int colorInterpretation) const ", "progressUpdate(int theProgress)", "identifyFormatToCapability(QgsRaster::IdentifyFormat format)", "makeTableCell(const QString &value)", "identifyFormatName(QgsRaster::IdentifyFormat format)", "setUserNoDataValue(int bandNo, const QgsRasterRangeList &noData)", "colorTable(int bandNo) const ", "identifyFormatLabel(QgsRaster::IdentifyFormat format)", "makeTableCells(const QStringList &values)", "identifyFormatFromName(const QString &formatName)", "QgsRasterDataProvider(const QString &uri)", "colorInterpretationName(int theBandNo) const "],
    "QgsAdvancedDigitizingDockWidget::CadConstraint": ["CadConstraint(QLineEdit *lineEdit, QToolButton *lockerButton, QToolButton *relativeButton=nullptr)"],
    "QgsProject": ["readBoolEntry(const QString &scope, const QString &key, bool def=false, bool *ok=nullptr) const ", "readEntry(const QString &scope, const QString &key, const QString &def=QString::null, bool *ok=nullptr) const ", "dirty(bool b)", "write()", "loadingLayer(const QString &)", "writeEntry(const QString &scope, const QString &key, const QString &value)", "snapSettingsChanged()", "readNumEntry(const QString &scope, const QString &key, int def=0, bool *ok=nullptr) const ", "writeEntry(const QString &scope, const QString &key, int value)", "relationManager() const ", "writeEntry(const QString &scope, const QString &key, const QStringList &value)", "readDoubleEntry(const QString &scope, const QString &key, double def=0, bool *ok=nullptr) const "],
    "QgsMapLayerModel": ["removeLayers(const QStringList &layerIds)", "addLayers(const QList< QgsMapLayer * > &layers)"],
    "QgsValueRelationConfigDlg": ["editExpression()", "QgsValueRelationConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsFieldComboBox": ["indexChanged(int i)"],
    "pal::FeaturePart": ["getLabelDistance() const ", "FeaturePart(const FeaturePart &other)", "addSizePenalty(int nbp, QList< LabelPosition * > &lPos, double bbx[4], double bby[4])", "getLabelAngle()", "getLabelHeight() const ", "obstacleFactor()", "getLabelWidth() const ", "curvedPlacementAtOffset(PointSet *path_positions, double *path_distances, int orientation, int index, double distance)", "getFixedRotation()", "isObstacle()", "repeatDistance()", "getFixedPosition()", "getAlwaysShow()"],
    "QgsProviderExtentCalcEvent": ["QgsProviderExtentCalcEvent(QgsRectangle *layerExtent)", "layerExtent() const "],
    "QgsGmlFeatureClass": ["fields()", "QgsGmlFeatureClass(const QString &name, const QString &path)", "path() const ", "geometryAttributes()", "fieldIndex(const QString &name)"],
    "QgsOWSConnection": ["connectionList(const QString &theService)", "uri()", "selectedConnection(const QString &theService)", "setSelectedConnection(const QString &theService, const QString &name)", "deleteConnection(const QString &theService, const QString &name)"],
    "QgsDatumTransformStore": ["clear()", "QgsDatumTransformStore(const QgsCoordinateReferenceSystem &destCrs)", "addEntry(const QString &layerId, const QString &srcAuthId, const QString &destAuthId, int srcDatumTransform, int destDatumTransform)", "setDestinationCrs(const QgsCoordinateReferenceSystem &destCrs)", "hasEntryForLayer(QgsMapLayer *layer) const ", "writeXML(QDomNode &parentNode, QDomDocument &theDoc) const ", "readXML(const QDomNode &parentNode)"],
    "QgsVectorFieldSymbolLayerWidget": ["create(const QgsVectorLayer *vl)", "QgsVectorFieldSymbolLayerWidget(const QgsVectorLayer *vl, QWidget *parent=nullptr)"],
    "QgsFieldProxyModel": ["Filter", "filters() const "],
    "QgsNumericSortTreeWidgetItem": ["QgsNumericSortTreeWidgetItem(QTreeWidgetItem *parent)"],
    "QgsBrowserWatcher": ["item() const ", "QgsBrowserWatcher(QgsDataItem *item)", "finished(QgsDataItem *item, const QVector< QgsDataItem * > &items)"],
    "QgsVectorLayerUndoCommandChangeAttribute": ["QgsVectorLayerUndoCommandChangeAttribute(QgsVectorLayerEditBuffer *buffer, QgsFeatureId fid, int fieldIndex, const QVariant &newValue, const QVariant &oldValue)"],
    "QgsDiagramLayerSettings": ["readXML(const QDomElement &elem, const QgsVectorLayer *layer)", "Placement", "writeXML(QDomElement &layerElem, QDomDocument &doc, const QgsVectorLayer *layer) const "],
    "QgsDataDefinedButton": ["lineStyleDesc()", "customDashDesc()", "intDesc()", "colorAlphaDesc()", "capStyleDesc()", "doublePosDesc()", "gradientSpreadDesc()", "unitsMmMuPercentDesc()", "intPosOneDesc()", "doubleDesc()", "svgPathDesc()", "double180RotDesc()", "unitsMmMuDesc()", "boolDesc()", "gradientCoordModeDesc()", "charDesc()", "filePathDesc()", "gradientTypeDesc()", "penJoinStyleDesc()", "intPosDesc()", "paperOrientationDesc()", "fillStyleDesc()", "textHorzAlignDesc()", "markerStyleDesc()", "definedProperty() const ", "colorNoAlphaDesc()", "blendModesDesc()", "DataType", "verticalAnchorDesc()", "paperSizeDesc()", "double0to1Desc()", "intTranspDesc()", "horizontalAnchorDesc()", "anyStringDesc()", "doubleXYDesc()", "textVertAlignDesc()"],
    "QgsValueMapWidgetFactory": ["QgsValueMapWidgetFactory(const QString &name)"],
    "QgsComposerLayerItem": ["showFeatureCount() const ", "setDefaultStyle(double scaleDenominator=-1, const QString &rule=\"\")", "QgsComposerLayerItem(const QString &text)", "setLayerID(const QString &id)", "layerID() const ", "setShowFeatureCount(bool show)"],
    "QgsSingleBandPseudoColorRenderer": ["classificationMax() const ", "setClassificationMax(double max)", "create(const QDomElement &elem, QgsRasterInterface *input)", "setClassificationMin(double min)", "classificationMinMaxOrigin() const ", "setClassificationMinMaxOrigin(int origin)", "shader()", "classificationMin() const "],
    "QgsFeatureSelectionDlg": ["QgsFeatureSelectionDlg(QgsVectorLayer *vl, QgsAttributeEditorContext &context, QWidget *parent=nullptr)"],
    "QgsSingleBandColorDataRenderer": ["QgsSingleBandColorDataRenderer(QgsRasterInterface *input, int band)", "create(const QDomElement &elem, QgsRasterInterface *input)"],
    "QgsRasterRendererRegistry": ["rendererData(const QString &rendererName, QgsRasterRendererRegistryEntry &data) const ", "instance()", "insert(const QgsRasterRendererRegistryEntry &entry)", "renderersList() const ", "insertWidgetFunction(const QString &rendererName, QgsRasterRendererWidgetCreateFunc func)", "entries() const "],
    "QgsDummyConfigDlg": ["QgsDummyConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent, const QString &description)"],
    "QgsZonalStatistics": ["QgsZonalStatistics(QgsVectorLayer *polygonLayer, const QString &rasterFile, const QString &attributePrefix=\"\", int rasterBand=1, const Statistics &stats=Statistics(Count|Sum|Mean))"],
    "QgsRuleBasedRendererV2": ["createFromSld(QDomElement &element, QGis::GeometryType geomType)", "FeatureFlags", "None", "create(QDomElement &element)", "rootRule()"],
    "QgsRasterDrawer": ["draw(QPainter *p, QgsRasterViewPort *viewPort, const QgsMapToPixel *theQgsMapToPixel)", "QgsRasterDrawer(QgsRasterIterator *iterator)"],
    "QgsOfflineEditing": ["ProgressMode"],
    "QgsRendererRangeV2LabelFormat": ["saveToDomElement(QDomElement &element)", "setPrecision(int precision)", "setFromDomElement(QDomElement &element)", "setFormat(const QString &format)", "QgsRendererRangeV2LabelFormat(const QString &format, int precision=4, bool trimTrailingZeroes=false)", "formatNumber(double value) const ", "format() const ", "setTrimTrailingZeroes(bool trimTrailingZeroes)", "labelForRange(const QgsRendererRangeV2 &range) const ", "trimTrailingZeroes() const ", "precision() const "],
    "QgsCharacterSelectorDialog": ["QgsCharacterSelectorDialog(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags)", "selectCharacter(bool *gotChar, const QFont &font, const QString &style)"],
    "QgsComposerLegend": ["boxSpace() const ", "symbolHeight() const ", "setBoxSpace(double s)", "setSymbolWidth(double w)", "splitLayer() const ", "setWmsLegendHeight(double h)", "setFontColor(const QColor &c)", "composerMap() const ", "setColumnCount(int c)", "setComposerMap(const QgsComposerMap *map)", "setTitle(const QString &t)", "QgsComposerLegend(QgsComposition *composition)", "setSymbolHeight(double h)", "setColumnSpace(double s)", "columnCount() const ", "setStyle(QgsComposerLegendStyle::Style s, const QgsComposerLegendStyle &style)", "setWrapChar(const QString &t)", "setSplitLayer(bool s)", "title() const ", "styleFont(QgsComposerLegendStyle::Style s) const ", "wmsLegendWidth() const ", "columnSpace() const ", "equalColumnWidth() const ", "wrapChar() const ", "setStyleMargin(QgsComposerLegendStyle::Style s, QgsComposerLegendStyle::Side side, double margin)", "setWmsLegendWidth(double w)", "setEqualColumnWidth(bool s)", "fontColor() const ", "wmsLegendHeight() const ", "symbolWidth() const "],
    "QgsGeometryRubberBand": ["QgsGeometryRubberBand(QgsMapCanvas *mapCanvas, QGis::GeometryType geomType=QGis::Line)", "IconType"],
    "QgsCredentialDialog": ["QgsCredentialDialog(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags)"],
    "QgsRuleBasedLabeling": ["rootRule()", "None", "rootRule() const "],
    "QgsLUDialog": ["QgsLUDialog(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags)", "lowerValue() const ", "setLowerValue(const QString &val)", "upperValue() const ", "setUpperValue(const QString &val)"],
    "QgsRasterHistogramWidget": ["QgsRasterHistogramWidget(QgsRasterLayer *lyr, QWidget *parent=nullptr)"],
    "QgsUnitSelectionWidget": ["QgsUnitSelectionWidget(QWidget *parent=nullptr)", "changed()"],
    "QgsAttributeTableModel": ["finished()", "idToIndexList(QgsFeatureId id) const ", "Role", "idToIndex(QgsFeatureId id) const "],
    "QgsPointLocator_Stream": ["QgsPointLocator_Stream(const QLinkedList< RTree::Data * > &dataList)"],
    "QgsProviderRegistry": ["registerGuis(QWidget *widget)", "selectWidget(const QString &providerKey, QWidget *parent=nullptr, const Qt::WindowFlags &fl=nullptr)", "providerLibrary(const QString &providerKey) const "],
    "QgsCoordinateTransform": ["destinationDatumTransform() const ", "clone() const ", "setSourceDatumTransform(int dt)", "transformInPlace(double &x, double &y, double &z, TransformDirection direction=ForwardTransform) const ", "transformInPlace(QVector< float > &x, QVector< float > &y, QVector< float > &z, TransformDirection direction=ForwardTransform) const ", "sourceDatumTransform() const ", "setDestinationDatumTransform(int dt)", "transformPolygon(QPolygonF &poly, TransformDirection direction=ForwardTransform) const ", "transformInPlace(float &x, float &y, float &z, TransformDirection direction=ForwardTransform) const ", "transformInPlace(float &x, float &y, double &z, TransformDirection direction=ForwardTransform) const ", "datumTransformString(int datumTransform)"],
    "QgsHeatmapRenderer": ["convertFromRenderer(const QgsFeatureRendererV2 *renderer)", "create(QDomElement &element)"],
    "QgsConnectionPool": ["None"],
    "QgsVectorLayerFeatureSource": ["QgsVectorLayerFeatureSource(QgsVectorLayer *layer)"],
    "QgsLabel": ["QgsLabel(const QgsFields &fields)", "LabelField", "maxScale() const ", "scaleBasedVisibility() const ", "minScale() const "],
    "QgsRasterFileWriter": ["buildPyramidsFlag() const ", "maxTileHeight() const ", "setBuildPyramidsFlag(QgsRaster::RasterBuildPyramids f)", "outputProviderKey() const ", "setPyramidsFormat(QgsRaster::RasterPyramidsFormat f)", "setCreateOptions(const QStringList &list)", "setPyramidsResampling(const QString &str)", "setPyramidsConfigOptions(const QStringList &list)", "tiledMode() const ", "setMaxTileHeight(int h)", "WriterError", "setOutputProviderKey(const QString &key)", "createOptions() const ", "setTiledMode(bool t)", "setOutputFormat(const QString &format)", "pyramidsList() const ", "Mode", "pyramidsResampling() const ", "pyramidsConfigOptions() const ", "pyramidsFormat() const ", "outputFormat() const ", "QgsRasterFileWriter(const QString &outputUrl)", "maxTileWidth() const ", "setMaxTileWidth(int w)", "setPyramidsList(const QList< int > &list)"],
    "QgsProjectBadLayerHandler": ["handleBadLayers(const QList< QDomNode > &layers, const QDomDocument &projectDom)=0"],
    "QgsVectorLayerCache": ["QgsVectorLayerCache(QgsVectorLayer *layer, int cacheSize, QObject *parent=nullptr)"],
    "QgsRasterPipe": ["QgsRasterPipe(const QgsRasterPipe &thePipe)", "size() const ", "renderer() const ", "at(int idx) const ", "resampleFilter() const ", "provider() const ", "brightnessFilter() const ", "nuller() const ", "hueSaturationFilter() const ", "last() const ", "projector() const ", "Role"],
    "QgsDbFilterProxyModel": ["QgsDbFilterProxyModel(QObject *parent=nullptr)"],
    "QgsMarkerLineSymbolLayerV2Widget": ["create(const QgsVectorLayer *vl)", "setOffsetAlongLine(double val)", "setPlacement()", "setInterval(double val)", "setOffset()", "setRotate()", "QgsMarkerLineSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)"],
    "QgsDataDefinedAssistant": ["dataDefined() const =0"],
    "QgsTransaction": ["QgsTransaction(const QString &connString)"],
    "QgsBrowserTreeView": ["hasExpandedDescendant(const QModelIndex &index) const ", "setSettingsSection(const QString &section)", "QgsBrowserTreeView(QWidget *parent=nullptr)"],
    "QgsDistanceArea": ["computePolygonFlatArea(const QList< QgsPoint > &points) const "],
    "QgsContrastEnhancement": ["writeXML(QDomDocument &doc, QDomElement &parentElem) const ", "QgsContrastEnhancement(const QgsContrastEnhancement &ce)", "QgsContrastEnhancement(QGis::DataType theDatatype=QGis::Byte)", "contrastEnhancementAlgorithm() const ", "readXML(const QDomElement &elem)", "contrastEnhancementAlgorithmFromString(const QString &contrastEnhancementString)", "contrastEnhancementAlgorithmString(ContrastEnhancementAlgorithm algorithm)"],
    "QgsExpression::Interval": ["Interval(double seconds=0)"],
    "QgsManageConnectionsDialog": ["doExportImport()", "selectionChanged()", "Mode", "clearSelection()", "QgsManageConnectionsDialog(QWidget *parent=nullptr, Mode mode=Export, Type type=WMS, const QString &fileName=\"\")", "selectAll()", "Type"],
    "QgsAttributeTableView": ["repaintRequested()", "_q_selectRow(int row)", "setModel(QgsAttributeTableFilterModel *filterModel)", "finished()", "selectRow(int row)", "repaintRequested(const QModelIndexList &indexes)", "QgsAttributeTableView(QWidget *parent=nullptr)"],
    "QgsSimpleMarkerSymbolLayerV2": ["outlineWidthMapUnitScale() const ", "setName(const QString &name)", "setBorderColor(const QColor &color)", "outlineStyle() const ", "setOutlineWidthUnit(QgsSymbolV2::OutputUnit u)", "setOutlineWidthMapUnitScale(const QgsMapUnitScale &scale)", "setOutlineWidth(double w)", "borderColor() const ", "preparePath(QString name=QString())", "prepareShape(const QString &name=QString())", "name() const ", "prepareShape(const QString &name, QPolygonF &polygon) const ", "QgsSimpleMarkerSymbolLayerV2(const QString &name=DEFAULT_SIMPLEMARKER_NAME, const QColor &color=DEFAULT_SIMPLEMARKER_COLOR, const QColor &borderColor=DEFAULT_SIMPLEMARKER_BORDERCOLOR, double size=DEFAULT_SIMPLEMARKER_SIZE, double angle=DEFAULT_SIMPLEMARKER_ANGLE, QgsSymbolV2::ScaleMethod scaleMethod=DEFAULT_SCALE_METHOD)", "drawMarker(QPainter *p, QgsSymbolV2RenderContext &context)", "create(const QgsStringMap &properties=QgsStringMap())", "setOutlineStyle(Qt::PenStyle outlineStyle)", "outlineWidthUnit() const ", "createFromSld(QDomElement &element)", "outlineWidth() const "],
    "QgsStyleV2ExportImportDialog": ["QgsStyleV2ExportImportDialog(QgsStyleV2 *style, QWidget *parent=nullptr, Mode mode=Export)", "Mode", "doExportImport()", "importTypeChanged(int)", "browse()"],
    "QgsMapSettings": ["readXML(QDomNode &theNode)", "updateDerived()", "mapToPixel() const ", "writeXML(QDomNode &theNode, QDomDocument &theDoc)", "datumTransformStore()"],
    "QgsAttributeForm": ["QgsAttributeForm(QgsVectorLayer *vl, const QgsFeature &feature=QgsFeature(), const QgsAttributeEditorContext &context=QgsAttributeEditorContext(), QWidget *parent=nullptr)", "feature()"],
    "QgsWkbPtr": ["operator unsigned char *() const ", "operator+=(int n)", "size() const ", "QgsWkbPtr(unsigned char *p, int size)", "operator>>(QgsWKBTypes::Type &v) const ", "operator<<(const double &v)", "operator<<(const char &v)", "operator>>(int &v) const ", "operator>>(char &v) const ", "operator>>(double &v) const ", "writtenSize() const ", "operator<<(const float &r)", "remaining() const ", "operator<<(const QgsWKBTypes::Type &v)", "operator<<(const int &v)", "operator>>(QGis::WkbType &v) const ", "operator>>(unsigned int &v) const ", "operator<<(const unsigned int &v)", "operator<<(const QGis::WkbType &v)", "operator>>(float &r) const "],
    "QgsVisibilityPresetCollection": ["None"],
    "QgsDirectoryItem": ["Column", "dirPath() const ", "directoryChanged()", "QgsDirectoryItem(QgsDataItem *parent, const QString &name, const QString &path)", "init()"],
    "QgsExpression::NodeLiteral": ["NodeLiteral(const QVariant &value)"],
    "QgsEllipseSymbolLayerV2": ["symbolHeight() const ", "setOutlineWidthMapUnitScale(const QgsMapUnitScale &scale)", "setSymbolWidth(double w)", "setOutlineWidth(double w)", "symbolHeightUnit() const ", "outlineWidthUnit() const ", "setSymbolWidthUnit(QgsSymbolV2::OutputUnit unit)", "setSymbolHeightUnit(QgsSymbolV2::OutputUnit unit)", "symbolHeightMapUnitScale() const ", "symbolWidthMapUnitScale() const ", "setOutlineStyle(Qt::PenStyle outlineStyle)", "outlineStyle() const ", "setSymbolHeight(double h)", "setSymbolName(const QString &name)", "createFromSld(QDomElement &element)", "outlineWidthMapUnitScale() const ", "setOutlineWidthUnit(QgsSymbolV2::OutputUnit unit)", "symbolName() const ", "setSymbolWidthMapUnitScale(const QgsMapUnitScale &scale)", "setSymbolHeightMapUnitScale(const QgsMapUnitScale &scale)", "symbolWidthUnit() const ", "create(const QgsStringMap &properties=QgsStringMap())", "symbolWidth() const ", "outlineWidth() const "],
    "QgsComposerHtml": ["QgsComposerHtml(QgsComposition *c, bool createUndoCommands)", "refreshExpressionContext()"],
    "QgsRasterMatrix": ["setNodataValue(double d)", "greaterThan(const QgsRasterMatrix &other)", "changeSign()", "nodataValue() const ", "cosinus()", "lesserEqual(const QgsRasterMatrix &other)", "logicalAnd(const QgsRasterMatrix &other)", "TwoArgOperator", "log()", "divide(const QgsRasterMatrix &other)", "log10()", "QgsRasterMatrix(const QgsRasterMatrix &m)", "setData(int cols, int rows, double *data, double nodataValue)", "greaterEqual(const QgsRasterMatrix &other)", "equal(const QgsRasterMatrix &other)", "sinus()", "asinus()", "logicalOr(const QgsRasterMatrix &other)", "squareRoot()", "nColumns() const ", "OneArgOperator", "atangens()", "number() const ", "lesserThan(const QgsRasterMatrix &other)", "tangens()", "acosinus()", "power(const QgsRasterMatrix &other)", "multiply(const QgsRasterMatrix &other)", "nRows() const ", "notEqual(const QgsRasterMatrix &other)"],
    "QgsLayerTreeView": ["layerForIndex(const QModelIndex &index) const ", "updateExpandedStateToNode(const QModelIndex &index)", "QgsLayerTreeView(QWidget *parent=nullptr)", "modelRowsRemoved()", "onExpandedChanged(QgsLayerTreeNode *node, bool expanded)", "updateExpandedStateFromNode(QgsLayerTreeNode *node)", "modelRowsInserted(const QModelIndex &index, int start, int end)", "onModelReset()", "onCurrentChanged()"],
    "QgsCredentials": ["put(const QString &realm, const QString &username, const QString &password)", "getMasterPassword(QString &password, bool stored=false)", "get(const QString &realm, QString &username, QString &password, const QString &message=QString::null)"],
    "QgsSnappingUtils": ["QgsSnappingUtils(QObject *parent=nullptr)", "IndexingStrategy", "snapToMap(const QgsPoint &pointMap, QgsPointLocator::MatchFilter *filter=nullptr)", "currentLayer() const ", "mapSettings() const "],
    "QgsComposerRuler": ["Direction", "QgsComposerRuler(QgsComposerRuler::Direction d)", "updateMarker(QPointF pos)", "setComposition(QgsComposition *c)", "setSceneTransform(const QTransform &transform)", "composition()", "rulerSize()"],
    "QgsSimplifyMethod": ["MethodType"],
    "QgsComposerTextTable": ["QgsComposerTextTable(QgsComposition *c)"],
    "QgsDataItemProviderFromPlugin": ["QgsDataItemProviderFromPlugin(const QString &name, dataCapabilities_t *capabilitiesFunc, dataItem_t *dataItemFunc)"],
    "QgsMessageLogViewer": ["QgsMessageLogViewer(QStatusBar *statusBar=nullptr, QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags)", "logMessage(QString message, QString tag, QgsMessageLog::MessageLevel level)"],
    "QgsAnnotationItem": ["drawSelectionBoxes(QPainter *p)", "mapPositionFixed() const ", "frameBackgroundColor() const ", "MouseMoveAction", "markerSymbol() const ", "offsetFromReferencePoint() const ", "frameColor() const ", "setFrameSize(QSizeF size)", "minimumFrameSize() const ", "setFrameBorderWidth(double w)", "setFrameColor(const QColor &c)", "writeXML(QDomDocument &doc) const =0", "setOffsetFromReferencePoint(QPointF offset)", "frameBorderWidth() const ", "_readXML(const QDomDocument &doc, const QDomElement &annotationElem)", "setMapPosition(const QgsPoint &pos)", "drawFrame(QPainter *p)", "readXML(const QDomDocument &doc, const QDomElement &itemElem)=0", "QgsAnnotationItem(QgsMapCanvas *mapCanvas)", "updateBoundingRect()", "_writeXML(QDomDocument &doc, QDomElement &itemElem) const ", "setMapPositionFixed(bool fixed)", "mapPosition() const ", "frameSize() const ", "setFrameBackgroundColor(const QColor &c)", "drawMarkerSymbol(QPainter *p)"],
    "QgsVertexMarker": ["QgsVertexMarker(QgsMapCanvas *mapCanvas)", "setColor(const QColor &color)", "setIconSize(int iconSize)", "setCenter(const QgsPoint &point)", "setPenWidth(int width)", "setIconType(int iconType)"],
    "QgsAttributeFormLegacyInterface": ["QgsAttributeFormLegacyInterface(const QString &function, const QString &pyFormName, QgsAttributeForm *form)"],
    "QgsLongLongValidator": ["QgsLongLongValidator(qint64 bottom, qint64 top, QObject *parent)", "setTop(qint64 top)", "setRange(qint64 bottom, qint64 top)", "bottom() const ", "setBottom(qint64 bottom)", "QgsLongLongValidator(QObject *parent)", "top() const "],
    "QgsPalLayerSettings": ["DataDefinedProperties", "ShapeType", "DirectionSymbols", "UpsideDownLabels", "QuadrantPosition", "MultiLineAlign", "writeToLayer(QgsVectorLayer *layer)", "RotationType", "ShadowType", "calculateLabelSize(const QFontMetricsF *fm, QString text, double &labelX, double &labelY, QgsFeature *f=nullptr, QgsRenderContext *context=nullptr)", "QgsPalLayerSettings(const QgsPalLayerSettings &s)", "SizeType", "readFromLayer(QgsVectorLayer *layer)"],
    "QgsRasterLayerRenderer": ["QgsRasterLayerRenderer(QgsRasterLayer *layer, QgsRenderContext &rendererContext)"],
    "QgsCptCityColorRampV2": ["descFileName() const ", "copyingInfo() const ", "fileName() const ", "copyingFileName() const ", "setVariantName(const QString &variantName)", "schemeName() const ", "variantList() const ", "setSchemeName(const QString &schemeName)", "loadPalette()", "QgsCptCityColorRampV2(const QString &schemeName=DEFAULT_CPTCITY_SCHEMENAME, const QString &variantName=DEFAULT_CPTCITY_VARIANTNAME, bool doLoadFile=true)", "copy(const QgsCptCityColorRampV2 *other)", "setName(const QString &schemeName, const QString &variantName=\"\", const QStringList &variantList=QStringList())", "cloneGradientRamp() const ", "setVariantList(const QStringList &variantList)", "loadFile()", "variantName() const ", "fileLoaded() const ", "hasMultiStops() const ", "create(const QgsStringMap &properties=QgsStringMap())", "QgsCptCityColorRampV2(const QString &schemeName, const QStringList &variantList, const QString &variantName=QString(), bool doLoadFile=true)"],
    "QgsRenderChecker": ["matchTarget()", "setRenderedImage(const QString &theImageFileName)", "matchPercent()", "setElapsedTimeTarget(int theTarget)", "mismatchCount()", "elapsedTime()", "report()", "controlImagePath() const ", "setControlPathSuffix(const QString &theName)"],
    "QgsPaperGrid": ["QgsPaperGrid(double x, double y, double width, double height, QgsComposition *composition)"],
    "QgsExternalResourceWidget": ["DocumentViewerContent", "setDocumentPath(const QVariant &documentPath)"],
    "QgsCoordinateTransformCache": ["instance()"],
    "QgsCptCityDirectoryItem": ["QgsCptCityDirectoryItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "rampsMap()", "dataItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "dirEntries() const "],
    "QgsGeometry::Error": ["Error(const QString &m, const QgsPoint &p)", "Error(const QString &m)", "hasWhere()", "what()", "where()"],
    "QgsConstWkbPtr": ["operator+=(int n)", "operator>>(double &v) const ", "operator>>(int &v) const ", "QgsConstWkbPtr(const unsigned char *p, int size)", "operator>>(char &v) const ", "operator const unsigned char *() const ", "remaining() const ", "operator-=(int n)", "readHeader() const ", "operator>>(unsigned int &v) const ", "operator>>(float &r) const "],
    "QgsExternalResourceConfigDlg": ["QgsExternalResourceConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=0)"],
    "QgsPointLocator_VisitorNearestVertex": ["QgsPointLocator_VisitorNearestVertex(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPoint &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsConditionalStyle": ["QgsConditionalStyle(const QgsConditionalStyle &other)", "QgsConditionalStyle(const QString &rule)"],
    "QgsColorEffectWidget": ["QgsColorEffectWidget(QWidget *parent=nullptr)", "create()"],
    "QgsRaster": ["RasterProgressType", "RasterPyramidsFormat", "IdentifyFormat", "contrastEnhancementLimitsAsString(QgsRaster::ContrastEnhancementLimits theLimits)", "contrastEnhancementLimitsFromString(const QString &theLimits)", "RasterBuildPyramids", "ColorInterpretation"],
    "QgsMapCanvasLayer": ["QgsMapCanvasLayer(QgsMapLayer *layer, bool visible=true, bool isInOverview=false)", "setVisible(bool visible)", "isVisible() const ", "setInOverview(bool isInOverview)", "layer()", "layer() const ", "isInOverview() const "],
    "QgsMapRenderer": ["setOutputSize(QSizeF size, double dpi)", "destinationSrsChanged()", "mapUnitsChanged()", "clearLayerCoordinateTransforms()", "outputSizeF()", "height() const ", "transformation(const QgsMapLayer *layer) const ", "setOutputUnits(OutputUnits u)", "setMapUnits(QGis::UnitType u)", "coordinateTransform()", "outputUnits() const ", "mapUnitsPerPixel() const ", "width() const ", "addLayerCoordinateTransform(const QString &layerId, const QString &srcAuthId, const QString &destAuthId, int srcDatumTransform=-1, int destDatumTransform=-1)", "setOutputSize(QSize size, int dpi)", "mapUnits() const "],
    "QgsAttributeDialog": ["feature()", "attributeForm()"],
    "QgsRelief": ["zFactor() const ", "setReliefColors(const QList< ReliefColor > &c)", "addReliefColorClass(const ReliefColor &color)", "clearReliefColors()", "setZFactor(double factor)", "QgsRelief(const QString &inputFile, const QString &outputFile, const QString &outputFormat)", "reliefColors() const "],
    "QgsPhotoWidgetFactory": ["QgsPhotoWidgetFactory(const QString &name)"],
    "QgsAlignRaster": ["gridOffset() const ", "None", "setGridOffset(QPointF offset)"],
    "pal::GeomFunction": ["cross_product(double x1, double y1, double x2, double y2, double x3, double y3)", "dist_euc2d(double x1, double y1, double x2, double y2)", "findLineCircleIntersection(double cx, double cy, double radius, double x1, double y1, double x2, double y2, double &xRes, double &yRes)", "dist_euc2d_sq(double x1, double y1, double x2, double y2)"],
    "QgsSizeScaleWidget": ["QgsSizeScaleWidget(const QgsVectorLayer *layer, const QgsSymbolV2 *symbol)"],
    "QgsSVGFillSymbolLayer": ["svgOutlineWidth() const ", "QgsSVGFillSymbolLayer(const QString &svgFilePath=\"\", double width=20, double rotation=0.0)", "svgFilePath() const ", "patternWidthMapUnitScale() const ", "setPatternWidthUnit(QgsSymbolV2::OutputUnit unit)", "setSvgOutlineWidthUnit(QgsSymbolV2::OutputUnit unit)", "setSvgFilePath(const QString &svgPath)", "setSvgOutlineWidthMapUnitScale(const QgsMapUnitScale &scale)", "setPatternWidthMapUnitScale(const QgsMapUnitScale &scale)", "patternWidthUnit() const ", "setSvgOutlineWidth(double w)", "svgOutlineColor() const ", "setSvgOutlineColor(const QColor &c)", "patternWidth() const ", "createFromSld(QDomElement &element)", "svgFillColor() const ", "svgOutlineWidthMapUnitScale() const ", "setPatternWidth(double width)", "svgOutlineWidthUnit() const ", "setSvgFillColor(const QColor &c)", "create(const QgsStringMap &properties=QgsStringMap())", "QgsSVGFillSymbolLayer(const QByteArray &svgData, double width=20, double rotation=0.0)"],
    "QgsCRSCache": ["updateCRSCache(const QString &authid)", "instance()", "crsByEpsgId(long epsg)"],
    "QgsMapToolIdentify": ["formatChanged(QgsRasterLayer *layer)", "changedRasterResults(QList< IdentifyResult > &)", "identifyProgress(int, int)", "Type", "identifyVectorLayer(QList< IdentifyResult > *results, QgsVectorLayer *layer, const QgsPoint &point)", "IdentifyMode", "identifyRasterLayer(QList< IdentifyResult > *results, QgsRasterLayer *layer, QgsPoint point, const QgsRectangle &viewExtent, double mapUnitsPerPixel)", "identifyMessage(const QString &)"],
    "QgsLayerPropertiesWidget": ["updateSymbolLayerWidget(QgsSymbolLayerV2 *layer)", "changed()", "populateLayerTypes()", "emitSignalChanged()", "QgsLayerPropertiesWidget(QgsSymbolLayerV2 *layer, const QgsSymbolV2 *symbol, const QgsVectorLayer *vl, QWidget *parent=nullptr)", "changeLayer(QgsSymbolLayerV2 *)", "layerTypeChanged()"],
    "pal::PointSet": ["getBoundingBox(double min[2], double max[2]) const ", "compute_chull_bbox()", "getGeosType() const ", "invalidateGeos()", "extractShape(int nbPtSh, int imin, int imax, int fps, int fpe, double fptx, double fpty)", "PointSet(double x, double y)", "getNumPoints() const ", "createGeosGeom() const ", "preparedGeom() const ", "deleteCoords()", "getCentroid(double &px, double &py, bool forceInside=false) const ", "PointSet(int nbPoints, double *x, double *y)", "PointSet(const PointSet &ps)"],
    "QgsComposerScaleBar": ["unitLabeling() const ", "numSegmentsLeft() const ", "setNumSegments(int nSegments)", "labelBarSpace() const ", "numSegments() const ", "updateSegmentSize()", "QgsComposerScaleBar(QgsComposition *composition)", "composerMap() const ", "setComposerMap(const QgsComposerMap *map)", "setNumSegmentsLeft(int nSegmentsLeft)", "setFont(const QFont &font)", "setBoxContentSpace(double space)", "numUnitsPerSegment() const ", "setHeight(double h)", "setUnits(ScaleBarUnits u)", "setNumMapUnitsPerScaleBarUnit(double d)", "units() const ", "setAlignment(Alignment a)", "ScaleBarUnits", "boxContentSpace() const ", "setUnitLabeling(const QString &label)", "setLabelBarSpace(double space)", "font() const ", "setNumUnitsPerSegment(double units)", "numMapUnitsPerScaleBarUnit() const ", "segmentMillimeters() const ", "height() const ", "Alignment"],
    "QgsExpression::NodeList": ["dump() const ", "count()", "list()"],
    "QgsComposerAttributeTableV2": ["QgsComposerAttributeTableV2(QgsComposition *composition, bool createUndoCommands)"],
    "QgsMapLayerLegend": ["QgsMapLayerLegend(QObject *parent=nullptr)"],
    "QgsGeometryEngine": ["buffer(double distance, int segments, QString *errorMsg=nullptr) const =0", "contains(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "prepareGeometry()=0", "length(QString *errorMsg=nullptr) const =0", "splitGeometry(const QgsLineStringV2 &splitLine, QList< QgsAbstractGeometryV2 * > &newGeometries, bool topological, QgsPointSequenceV2 &topologyTestPoints, QString *errorMsg=nullptr) const ", "within(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "geometryChanged()=0", "overlaps(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "interpolate(double distance, QString *errorMsg=nullptr) const =0", "intersection(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "centroid(QgsPointV2 &pt, QString *errorMsg=nullptr) const =0", "simplify(double tolerance, QString *errorMsg=nullptr) const =0", "QgsGeometryEngine(const QgsAbstractGeometryV2 *geometry)", "isValid(QString *errorMsg=nullptr) const =0", "area(QString *errorMsg=nullptr) const =0", "combine(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "combine(const QList< QgsAbstractGeometryV2 * > &, QString *errorMsg=nullptr) const =0", "isEmpty(QString *errorMsg) const =0", "envelope(QString *errorMsg=nullptr) const =0", "touches(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "distance(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "disjoint(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "convexHull(QString *errorMsg=nullptr) const =0", "offsetCurve(double distance, int segments, int joinStyle, double mitreLimit, QString *errorMsg=nullptr) const =0", "buffer(double distance, int segments, int endCapStyle, int joinStyle, double mitreLimit, QString *errorMsg=nullptr) const =0", "pointOnSurface(QgsPointV2 &pt, QString *errorMsg=nullptr) const =0", "intersects(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "difference(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "symDifference(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "isEqual(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0", "crosses(const QgsAbstractGeometryV2 &geom, QString *errorMsg=nullptr) const =0"],
    "QgsMapToolAdvancedDigitizing": ["cadDockWidget() const "],
    "QgsCptCityBrowserModel": ["findItem(QgsCptCityDataItem *item, QgsCptCityDataItem *parent=nullptr) const ", "QgsCptCityBrowserModel(QObject *parent=nullptr, QgsCptCityArchive *archive=QgsCptCityArchive::defaultArchive(), ViewType Type=Authors)", "endInsertItems()", "reload()", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "addRootItems()", "connectItem(QgsCptCityDataItem *item)", "refresh(const QString &path)", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "endRemoveItems()", "refresh(const QModelIndex &index=QModelIndex())", "ViewType", "removeRootItems()"],
    "QgsComposerPicture": ["QgsComposerPicture(QgsComposition *composition)"],
    "QgsSingleCategoryDiagramRenderer": ["setDiagramSettings(const QgsDiagramSettings &s)"],
    "QgsFilterLineEdit": ["nullValue() const ", "QgsFilterLineEdit(QWidget *parent=nullptr, const QString &nullValue=QString::null)", "cleared()", "setNullValue(const QString &nullValue)"],
    "QgsFillSymbolLayerV2": ["setAngle(double angle)", "renderPolygon(const QPolygonF &points, QList< QPolygonF > *rings, QgsSymbolV2RenderContext &context)=0", "QgsFillSymbolLayerV2(bool locked=false)", "angle() const "],
    "QgsClassificationWidgetWrapperFactory": ["QgsClassificationWidgetWrapperFactory(const QString &name)"],
    "QgsLegendInterface": ["itemAdded(const QModelIndex &index)", "groupRelationsChanged()", "itemRemoved()"],
    "QgsGlowWidget": ["QgsGlowWidget(QWidget *parent=nullptr)", "create()"],
    "QgsCollapsibleGroupBox": ["setSettings(QSettings *settings)", "QgsCollapsibleGroupBox(QWidget *parent=nullptr, QSettings *settings=nullptr)", "QgsCollapsibleGroupBox(const QString &title, QWidget *parent=nullptr, QSettings *settings=nullptr)", "init()", "saveCollapsedState()", "saveKey() const ", "saveCheckedState()"],
    "QgsSVGFillSymbolLayerWidget": ["create(const QgsVectorLayer *vl)", "QgsSVGFillSymbolLayerWidget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "insertIcons()"],
    "pal::Problem": ["getNumFeatures()", "reduce()", "subPart(int r, int featseed, int *isIn)", "getSolution(bool returnInactive)", "getFeatureCandidateCount(int i)", "compute_feature_cost(SubPart *part, int feat_id, int label_id, int *nbOverlap)", "compareLabelArea(pal::LabelPosition *l1, pal::LabelPosition *l2)", "initialization()", "compute_subsolution_cost(SubPart *part, int *s, int *nbOverlap)", "init_sol_falp()", "getFeatureCandidate(int fi, int ci)", "popmusic_tabu(SubPart *part)", "getStats()"],
    "QgsPenStyleComboBox": ["setPenStyle(Qt::PenStyle style)", "iconForPen(Qt::PenStyle style)", "QgsPenStyleComboBox(QWidget *parent=nullptr)", "penStyle() const "],
    "QgsDxfPaintEngine": ["setLayer(const QString &layer)", "QgsDxfPaintEngine(const QgsDxfPaintDevice *dxfDevice, QgsDxfExport *dxf)", "layer() const ", "setShift(QPointF shift)"],
    "QgsRasterProjector": ["precisionLabel(Precision precision)", "QgsRasterProjector(const QgsCoordinateReferenceSystem &theSrcCRS, const QgsCoordinateReferenceSystem &theDestCRS, double theMaxSrcXRes, double theMaxSrcYRes, const QgsRectangle &theExtent)", "QgsRasterProjector(const QgsCoordinateReferenceSystem &theSrcCRS, const QgsCoordinateReferenceSystem &theDestCRS, const QgsRectangle &theDestExtent, int theDestRows, int theDestCols, double theMaxSrcXRes, double theMaxSrcYRes, const QgsRectangle &theExtent)", "setPrecision(Precision precision)", "precision() const "],
    "QgsCodeEditorHTML": ["QgsCodeEditorHTML(QWidget *parent=nullptr)"],
    "QgsGenericProjectionSelector": ["setSelectedCrsName(const QString &theName)", "setSelectedCrsId(long theID)", "selectedAuthId()", "selectedCrsId()", "setSelectedAuthId(const QString &authId)"],
    "QgsSpatialIndexData": ["QgsSpatialIndexData(const QgsFeatureIterator &fi)", "QgsSpatialIndexData(const QgsSpatialIndexData &other)", "initTree(IDataStream *inputStream=nullptr)"],
    "QgsSlider": ["setSingleStep(const QVariant &step)", "variantValue() const ", "valueChanged(int)", "setMinimum(const QVariant &min)", "valueChanged(const QVariant &)", "setValue(const QVariant &value)", "QgsSlider(QWidget *parent=nullptr)", "setMaximum(const QVariant &max)", "QgsSlider(Qt::Orientation orientation, QWidget *parent=nullptr)"],
    "QgsBusyIndicatorDialog": ["setMessage(const QString &message)", "message() const "],
    "QgsTextEditConfigDlg": ["QgsTextEditConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsRectangle": ["scale(double scaleFactor, double centerX, double centerY)"],
    "QgsFileDropEdit": ["isDirOnly() const ", "isFileOnly() const ", "QgsFileDropEdit(QWidget *parent=nullptr)", "suffixFilter() const "],
    "QgsFormAnnotationItem": ["QgsFormAnnotationItem(QgsMapCanvas *canvas, QgsVectorLayer *vlayer=nullptr, bool hasFeature=false, int feature=0)", "vectorLayer() const ", "designerForm() const ", "setDesignerForm(const QString &uiFile)"],
    "QgsMapLayer": ["legendUrlFormat() const ", "saveSldStyle(const QString &theURI, bool &theResultFlag)", "setLegendUrl(const QString &legendUrl)", "readSld(const QDomNode &node, QString &errorMessage)", "legendUrl() const ", "setLegendUrlFormat(const QString &legendUrlFormat)", "fromLayerDefinitionFile(const QString &qlrfile)", "loadNamedStyleFromDb(const QString &db, const QString &theURI, QString &qml)", "loadSldStyle(const QString &theURI, bool &theResultFlag)"],
    "QgsSlopeFilter": ["QgsSlopeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsDatumTransformDialog": ["QgsDatumTransformDialog(const QString &layerName, const QList< QList< int > > &dt, QWidget *parent=nullptr, const Qt::WindowFlags &f=nullptr)"],
    "QgsMapRendererSequentialJob": ["QgsMapRendererSequentialJob(const QgsMapSettings &settings)", "internalFinished()"],
    "QgsPointDisplacementRendererWidget": ["create(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "QgsPointDisplacementRendererWidget(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)"],
    "QgsPointLocator": ["Type", "destroyIndex()", "None", "rebuildIndex(int maxFeaturesToIndex=-1)"],
    "QgsUserInputDockWidget": ["QgsUserInputDockWidget(QWidget *parent=nullptr)"],
    "QgsLayerTreeModelLegendNode": ["setUserLabel(const QString &userLabel)", "isScaleOK(double scale) const ", "userLabel() const ", "setEmbeddedInParent(bool embedded)", "LegendNodeRoles", "isEmbeddedInParent() const "],
    "QgsSingleBandGrayRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &theExtent)", "QgsSingleBandGrayRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "setFromRenderer(const QgsRasterRenderer *r)", "loadMinMax(int theBandNo, double theMin, double theMax, int theOrigin)"],
    "QgsValueRelationWidgetFactory": ["QgsValueRelationWidgetFactory(const QString &name)"],
    "QgsCoordinateReferenceSystem": ["createFromId(const long theId, CrsType theType=PostgisCrsId)", "CrsType"],
    "QgsVectorLayerUndoCommandAddAttribute": ["QgsVectorLayerUndoCommandAddAttribute(QgsVectorLayerEditBuffer *buffer, const QgsField &field)"],
    "GEOSGeomScopedPtr": ["GEOSGeomScopedPtr(GEOSGeometry *geom=nullptr)", "get() const ", "operator bool() const ", "reset(GEOSGeometry *geom)"],
    "QgsDoubleSpinBox": ["QgsDoubleSpinBox(QWidget *parent=nullptr)", "ClearValueMode", "showClearButton() const "],
    "QgsComposerAttributeTableCompareV2": ["operator()(const QgsComposerTableRow &m1, const QgsComposerTableRow &m2)"],
    "QgsEnumerationWidgetFactory": ["QgsEnumerationWidgetFactory(const QString &name)"],
    "QgsOSMWayIterator": ["close()", "next()"],
    "QgsComposerLegendItem": ["itemType() const =0", "ItemType", "QgsComposerLegendItem(const QString &text, QgsComposerLegendStyle::Style s=QgsComposerLegendStyle::Undefined)", "QgsComposerLegendItem(const QIcon &icon, const QString &text, QgsComposerLegendStyle::Style s=QgsComposerLegendStyle::Undefined)", "writeXML(QDomElement &elem, QDomDocument &doc) const =0", "userText() const ", "setStyle(QgsComposerLegendStyle::Style style)", "style() const ", "writeXMLChildren(QDomElement &elem, QDomDocument &doc) const ", "setUserText(const QString &text)", "QgsComposerLegendItem(QgsComposerLegendStyle::Style s=QgsComposerLegendStyle::Undefined)"],
    "QgsVectorFileWriter::BoolOption": ["BoolOption(const QString &docString, bool defaultValue)"],
    "QgsVectorLayerUndoCommandDeleteAttribute": ["QgsVectorLayerUndoCommandDeleteAttribute(QgsVectorLayerEditBuffer *buffer, int fieldIndex)"],
    "QgsIFeatureSelectionManager": ["QgsIFeatureSelectionManager(QObject *parent)"],
    "QgsOSMXmlImport": ["readTag(bool way, QgsOSMId id, QXmlStreamReader &xml)", "createIndexes()", "progress(int percent)", "closeDatabase()", "setInputXmlFileName(const QString &xmlFileName)", "readNode(QXmlStreamReader &xml)", "createDatabase()", "readRoot(QXmlStreamReader &xml)", "setOutputDbFileName(const QString &dbFileName)", "errorString() const ", "readWay(QXmlStreamReader &xml)", "inputXmlFileName() const ", "outputDbFileName() const ", "QgsOSMXmlImport(const QString &xmlFileName=QString(), const QString &dbFileName=QString())", "hasError() const "],
    "QgsComposerMergeCommand": ["QgsComposerMergeCommand(Context c, QgsComposerItem *item, const QString &text)", "Context"],
    "QgsVectorFileWriter": ["OptionType", "SymbologyExport", "driverMetadata(const QString &driverName, MetaData &driverMetadata)", "setSymbologyExport(SymbologyExport symExport)", "symbologyScaleDenominator() const ", "setSymbologyScaleDenominator(double d)", "WriterError", "symbologyExport() const "],
    "QgsVectorLayerSelectionManager": ["QgsVectorLayerSelectionManager(QgsVectorLayer *layer, QObject *parent=nullptr)"],
    "QgsVertexId": ["VertexType", "ringEqual(QgsVertexId o) const ", "partEqual(QgsVertexId o) const ", "QgsVertexId(int _part=-1, int _ring=-1, int _vertex=-1, VertexType _type=SegmentVertex)", "isValid(const QgsAbstractGeometryV2 *geom) const ", "vertexEqual(QgsVertexId o) const "],
    "CloughTocherInterpolator": ["setTriangulation(NormVecDecorator *tin)"],
    "QgsExpressionHighlighter": ["addFields(const QStringList &fieldList)", "QgsExpressionHighlighter(QTextDocument *parent=nullptr)"],
    "QgsWebViewWidgetFactory": ["QgsWebViewWidgetFactory(const QString &name)"],
    "QgsNewVectorLayerDialog": ["QgsNewVectorLayerDialog(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags)", "nameChanged(const QString &)", "selectionChanged()", "runAndCreateLayer(QWidget *parent=nullptr, QString *enc=nullptr)"],
    "QgsMapRendererCustomPainterJob": ["doRender()", "futureFinished()", "staticRender(QgsMapRendererCustomPainterJob *self)", "QgsMapRendererCustomPainterJob(const QgsMapSettings &settings, QPainter *painter)"],
    "QgsAttributeFormInterface": ["acceptChanges(const QgsFeature &feature)", "feature()", "form()", "featureChanged()", "QgsAttributeFormInterface(QgsAttributeForm *form)", "initForm()"],
    "QgsContrastEnhancementFunction": ["QgsContrastEnhancementFunction(QGis::DataType, double, double)", "QgsContrastEnhancementFunction(const QgsContrastEnhancementFunction &f)"],
    "QgsCodeEditor": ["getMonospaceFont()", "isFixedPitch(const QFont &font)", "foldingVisible()", "marginVisible()"],
    "QgsRasterResampler": ["type() const =0", "resample(const QImage &srcImage, QImage &dstImage)=0", "clone() const =0"],
    "QgsWebViewWidgetConfigDlg": ["QgsWebViewWidgetConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsFileNameWidgetFactory": ["QgsFileNameWidgetFactory(const QString &name)"],
    "QgsSvgAnnotationItem": ["QgsSvgAnnotationItem(QgsMapCanvas *canvas)", "filePath() const ", "setFilePath(const QString &file)"],
    "QgsSymbolsListWidget": ["updateDataDefinedMarkerAngle()", "updateDataDefinedMarkerSize()", "changed()", "setSymbolColor(const QColor &color)", "setLineWidth(double width)", "setSymbolFromStyle(const QModelIndex &index)", "updateSymbolColor()", "updateSymbolInfo()", "setMarkerAngle(double angle)", "openStyleManager()", "QgsSymbolsListWidget(QgsSymbolV2 *symbol, QgsStyleV2 *style, QMenu *menu, QWidget *parent, const QgsVectorLayer *layer=nullptr)", "symbolAddedToStyle(const QString &name, QgsSymbolV2 *symbol)", "saveSymbol()", "clipFeaturesToggled(bool checked)", "populateSymbols(const QStringList &symbols)", "populateSymbolView()", "addSymbolToStyle()", "setMarkerSize(double size)", "updateDataDefinedLineWidth()"],
    "QgsGradientFillSymbolLayerV2": ["referencePoint2() const ", "GradientSpread", "GradientColorType", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "QgsGradientFillSymbolLayerV2(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, GradientColorType gradientColorType=SimpleTwoColor, GradientType gradientType=Linear, GradientCoordinateMode coordinateMode=Feature, GradientSpread gradientSpread=Pad)", "GradientCoordinateMode", "setCoordinateMode(GradientCoordinateMode coordinateMode)", "setColor2(const QColor &color2)", "setGradientColorType(GradientColorType gradientColorType)", "referencePoint1() const ", "offsetUnit() const ", "referencePoint2IsCentroid() const ", "GradientType", "referencePoint1IsCentroid() const ", "offset() const ", "setGradientType(GradientType gradientType)", "setColorRamp(QgsVectorColorRampV2 *ramp)", "setGradientSpread(GradientSpread gradientSpread)", "create(const QgsStringMap &properties=QgsStringMap())", "offsetMapUnitScale() const "],
    "QgsOSMNodeIterator": ["close()", "next()"],
    "QgsPalettedRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &theExtent)", "QgsPalettedRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "setFromRenderer(const QgsRasterRenderer *r)"],
    "QgsDataProvider": ["QgsDataProvider(QString const &uri=\"\")", "DataCapability"],
    "QgsScaleWidget": ["showCurrentScaleButton()", "QgsScaleWidget(QWidget *parent=nullptr)", "updateScales(const QStringList &scales=QStringList())"],
    "QgsMapToolIdentifyFeature": ["featureIdentified(const QgsFeature &)", "featureIdentified(QgsFeatureId)"],
    "QgsGeometryValidator": ["errorFound(const QgsGeometry::Error &)", "addError(const QgsGeometry::Error &)", "stop()"],
    "QgsErrorDialog": ["QgsErrorDialog(const QgsError &theError, const QString &theTitle, QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags)"],
    "QgsExpression::NodeColumnRef": ["NodeColumnRef(const QString &name)"],
    "QgsRasterCalcNode": ["setRight(QgsRasterCalcNode *right)", "setLeft(QgsRasterCalcNode *left)", "type() const ", "QgsRasterCalcNode(const QString &rasterName)", "QgsRasterCalcNode(double number)", "parseRasterCalcString(const QString &str, QString &parserErrorMsg)", "QgsRasterCalcNode(QgsRasterMatrix *matrix)", "QgsRasterCalcNode(Operator op, QgsRasterCalcNode *left, QgsRasterCalcNode *right)"],
    "QgsComposerMultiFrameMergeCommand": ["QgsComposerMultiFrameMergeCommand(Context c, QgsComposerMultiFrame *multiFrame, const QString &text)", "Context"],
    "QgsColorWidgetWrapper": ["QgsColorWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsDialog": ["QgsDialog(QWidget *parent=nullptr, const Qt::WindowFlags &fl=QgisGui::ModalDialogFlags, const QDialogButtonBox::StandardButtons &buttons=QDialogButtonBox::Close, Qt::Orientation orientation=Qt::Horizontal)"],
    "QgsDartMeasurement": ["typeToString(Type type)", "send() const ", "Type", "QgsDartMeasurement(const QString &name, Type type, const QString &value)", "toString() const "],
    "QgsDirectoryParamWidget": ["showHideColumn()", "QgsDirectoryParamWidget(const QString &path, QWidget *parent=nullptr)"],
    "QgsGeometryUtils": ["componentType", "closestSegmentFromComponents(T &container, componentType ctype, const QgsPointV2 &pt, QgsPointV2 &segmentPt, QgsVertexId &vertexAfter, bool *leftOf, double epsilon)"],
    "QgsProjectionSelectionWidget": ["QgsProjectionSelectionWidget(QWidget *parent=nullptr)"],
    "QgsLinePatternFillSymbolLayer": ["setOffsetUnit(QgsSymbolV2::OutputUnit unit)", "distance() const ", "lineWidthUnit() const ", "lineWidth() const ", "offsetMapUnitScale() const ", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "offsetUnit() const ", "lineAngle() const ", "createFromSld(QDomElement &element)", "ogrFeatureStyleWidth(double widthScaleFactor) const ", "distanceUnit() const ", "setLineAngle(double a)", "lineWidthMapUnitScale() const ", "offset() const ", "distanceMapUnitScale() const ", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "setDistance(double d)", "setOffset(double offset)", "setLineWidthMapUnitScale(const QgsMapUnitScale &scale)", "setLineWidth(double w)", "create(const QgsStringMap &properties=QgsStringMap())", "setDistanceUnit(QgsSymbolV2::OutputUnit unit)", "setLineWidthUnit(QgsSymbolV2::OutputUnit unit)"],
    "QgsWebViewWidgetWrapper": ["QgsWebViewWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsColorButton": ["transpBkgrd()"],
    "QgsExpression::Function": ["referencedColumns() const ", "Function(const QString &fnname, int params, const QString &group, const QString &helpText=QString(), bool usesGeometry=false, const QStringList &referencedColumns=QStringList(), bool lazyEval=false, bool handlesNull=false, bool isContextual=false)", "handlesNull() const "],
    "QgsDefaultSearchWidgetWrapper": ["QgsDefaultSearchWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsGPSDetector": ["detected(const QgsGPSInformation &)", "connDestroyed(QObject *)", "detectionFailed()", "availablePorts()", "advance()", "QgsGPSDetector(const QString &portName)", "detected(QgsGPSConnection *)"],
    "QgsAttributeEditorElement": ["AttributeEditorType"],
    "QgsLegendRenderer": ["setNodeLegendStyle(QgsLayerTreeNode *node, QgsComposerLegendStyle::Style style)", "nodeLegendStyle(QgsLayerTreeNode *node, QgsLayerTreeModel *model)"],
    "QgsOSMDatabase": ["filename() const ", "QgsOSMDatabase(const QString &dbFileName=QString())", "countWays() const ", "open()", "prepareStatements()", "errorString() const ", "createSpatialTable(const QString &tableName, const QString &geometryType, const QStringList &tagKeys)", "exportSpatiaLiteWays(bool closed, const QString &tableName, const QStringList &tagKeys, const QStringList &notNullTagKeys=QStringList())", "wayPoints(QgsOSMId id) const ", "quotedValue(QString value)", "quotedIdentifier(QString id)", "node(QgsOSMId id) const ", "exportSpatiaLiteNodes(const QString &tableName, const QStringList &tagKeys, const QStringList &notNullTagKeys=QStringList())", "exportSpatiaLite(ExportType type, const QString &tableName, const QStringList &tagKeys=QStringList(), const QStringList &noNullTagKeys=QStringList())", "way(QgsOSMId id) const ", "setFileName(const QString &dbFileName)", "ExportType", "runCountStatement(const char *sql) const ", "close()", "createSpatialIndex(const QString &tableName)", "countNodes() const ", "tags(bool way, QgsOSMId id) const ", "isOpen() const "],
    "QgsTotalCurvatureFilter": ["QgsTotalCurvatureFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsMapCanvasSnapper": ["snapToBackgroundLayers(const QgsPoint &point, QList< QgsSnappingResult > &results, const QList< QgsPoint > &excludePoints=QList< QgsPoint >())", "setMapCanvas(QgsMapCanvas *canvas)"],
    "QgsRasterInterface": ["QgsRasterInterface(QgsRasterInterface *input=nullptr)", "dataTypeSize(int bandNo)", "ySize() const ", "srcInput()", "yBlockSize() const "],
    "QgsVectorFileWriter::Option": ["Option(const QString &docString, OptionType type)"],
    "QgsValueMapConfigDlg": ["updateMap(const QMap< QString, QVariant > &map, bool insertNull)", "QgsValueMapConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsActionMenu": ["ActionType", "reinit()"],
    "QgsLegendModel": ["ItemType", "addLayer(QgsMapLayer *theMapLayer, double scaleDenominator=-1, const QString &rule=\"\", QStandardItem *parentItem=nullptr)", "setLayerSet(const QStringList &layerIds, double scaleDenominator=-1, const QString &rule=\"\")", "updateRasterClassificationItem(QStandardItem *classificationItem)", "readXML(const QDomElement &legendModelElem, const QDomDocument &doc)", "removeLayer(const QString &layerId)", "writeXML(QDomElement &composerLegendElem, QDomDocument &doc) const ", "setAutoUpdate(bool autoUpdate)", "layersChanged()", "autoUpdate()"],
    "QgsRasterFormatSaveOptionsWidget": ["validateOptions(bool gui=true, bool reportOk=true)", "setFormat(const QString &format)", "setRasterLayer(QgsRasterLayer *rasterLayer)", "setPyramidsFormat(QgsRaster::RasterPyramidsFormat format)", "QgsRasterFormatSaveOptionsWidget(QWidget *parent=nullptr, const QString &format=\"GTiff\", QgsRasterFormatSaveOptionsWidget::Type type=Default, const QString &provider=\"gdal\")", "options() const ", "setProvider(const QString &provider)", "setRasterFileName(const QString &file)", "updateProfiles()", "helpOptions()", "apply()", "Type", "setType(QgsRasterFormatSaveOptionsWidget::Type type=Default)", "optionsChanged()"],
    "QgsSpatialIndexCopyVisitor": ["QgsSpatialIndexCopyVisitor(SpatialIndex::ISpatialIndex *newIndex)"],
    "QgsCurvePolygonV2": ["numInteriorRings() const ", "QgsCurvePolygonV2(const QgsCurvePolygonV2 &p)", "exteriorRing() const ", "interiorRing(int i) const ", "toPolygon() const "],
    "QgsPointPatternFillSymbolLayerWidget": ["QgsPointPatternFillSymbolLayerWidget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "create(const QgsVectorLayer *vl)"],
    "QgsLayerTreeMapCanvasBridge": ["nodeAddedChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "clear()", "defaultLayerOrder() const ", "customLayerOrder() const ", "nodeRemovedChildren()", "hasCustomLayerOrder() const ", "setCanvasLayers(QgsLayerTreeNode *node, QList< QgsMapCanvasLayer > &layers)", "nodeVisibilityChanged()", "setCustomLayerOrder(const QStringList &order)", "writeProject(QDomDocument &doc)", "mapCanvas() const ", "rootGroup() const ", "setHasCustomLayerOrder(bool state)", "readProject(const QDomDocument &doc)", "autoEnableCrsTransform() const ", "autoSetupOnFirstLayer() const ", "defaultLayerOrder(QgsLayerTreeNode *node, QStringList &order) const ", "hasCustomLayerOrderChanged(bool)", "customLayerOrderChanged(const QStringList &order)", "nodeCustomPropertyChanged(QgsLayerTreeNode *node, const QString &key)", "deferredSetCanvasLayers()"],
    "QgsCptCityAllRampsItem": ["QgsCptCityAllRampsItem(QgsCptCityDataItem *parent, const QString &name, const QVector< QgsCptCityDataItem * > &items)"],
    "QgsSearchQueryBuilder": ["loadQuery()", "saveQuery()"],
    "QgsMapRendererParallelJob": ["renderLayerStatic(LayerRenderJob &job)", "QgsMapRendererParallelJob(const QgsMapSettings &settings)", "renderLabelsStatic(QgsMapRendererParallelJob *self)"],
    "QgsSingleBandGrayRenderer": ["Gradient", "gradient() const ", "setGrayBand(int band)", "create(const QDomElement &elem, QgsRasterInterface *input)", "setGradient(Gradient theGradient)", "grayBand() const ", "contrastEnhancement() const ", "QgsSingleBandGrayRenderer(QgsRasterInterface *input, int grayBand)"],
    "QgsExpression": ["scale()", "NodeType", "None", "FcnEval)(const QVariantList &values, const QgsFeature *f, QgsExpression *parent)", "SpatialOperator", "setScale(double scale)", "initGeomCalculator()", "Functions()", "BuiltinFunctions()"],
    "QgsOWSSourceSelect": ["addWMSListRow(const QDomElement &item, int row)", "connectionsChanged()", "addRasterLayer(const QString &rasterLayerPath, const QString &baseName, const QString &providerKey)", "searchFinished()", "enableLayersForCrs(QTreeWidgetItem *item)", "addWMSListItem(const QDomElement &el, int row, int column)"],
    "QgsSmartGroupCondition": ["removed(int)", "QgsSmartGroupCondition(int id, QWidget *parent=nullptr)", "destruct()"],
    "QgsDataDefinedSizeDialog": ["QgsDataDefinedSizeDialog(const QList< QgsSymbolV2 * > &symbolList, QgsVectorLayer *layer)"],
    "QgsIDWInterpolator": ["QgsIDWInterpolator(const QList< LayerData > &layerData)", "setDistanceCoefficient(double p)"],
    "QgsRasterHistogram": ["None"],
    "QgsDial": ["setSingleStep(const QVariant &step)", "variantValue() const ", "valueChanged(int)", "setMinimum(const QVariant &min)", "valueChanged(const QVariant &)", "setValue(const QVariant &value)", "setMaximum(const QVariant &max)", "QgsDial(QWidget *parent=nullptr)"],
    "QgsExpressionItem": ["QgsExpressionItem(const QString &label, const QString &expressionText, const QString &helpText, QgsExpressionItem::ItemType itemType=ExpressionNode)", "QgsExpressionItem(const QString &label, const QString &expressionText, QgsExpressionItem::ItemType itemType=ExpressionNode)", "ItemType", "getExpressionText() const "],
    "QgsRasterChecker": ["report()"],
    "QgsPluginLayer": ["QgsPluginLayer(const QString &layerType, const QString &layerName=QString())"],
    "QgsSimpleMarkerSymbolLayerV2Widget": ["setName()", "setAngle()", "create(const QgsVectorLayer *vl)", "setColorBorder(const QColor &color)", "setColorFill(const QColor &color)", "QgsSimpleMarkerSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "setSize()", "setOffset()"],
    "QgsProjectVersion": ["text()", "QgsProjectVersion(int major, int minor, int sub, const QString &name=\"\")", "majorVersion()", "subVersion()", "QgsProjectVersion(const QString &string)", "minorVersion()"],
    "QgsMessageBarItem": ["setLevel(QgsMessageBar::MessageLevel level)", "setIcon(const QIcon &icon)", "setText(const QString &text)", "setDuration(int duration)", "setTitle(const QString &title)", "setWidget(QWidget *widget)"],
    "QgsDataItemProviderRegistry": ["instance()"],
    "QgsFeatureRequest": ["Flag", "flags() const "],
    "QgsNewNameDialog": ["matching(const QStringList &newNames, const QStringList &existingNames, Qt::CaseSensitivity cs=Qt::CaseSensitive)", "highlightText(const QString &text)", "fullNames(const QString &name, const QStringList &extensions)", "nameChanged()"],
    "QgsMapRendererJob": ["None", "drawNewLabeling(const QgsMapSettings &settings, QgsRenderContext &renderContext, QgsPalLabeling *labelingEngine)", "composeImage(const QgsMapSettings &settings, const LayerRenderJobs &jobs)", "drawOldLabeling(const QgsMapSettings &settings, QgsRenderContext &renderContext)", "QgsMapRendererJob(const QgsMapSettings &settings)", "needTemporaryImage(QgsMapLayer *ml)"],
    "QgsMapRendererQImageJob": ["QgsMapRendererQImageJob(const QgsMapSettings &settings)"],
    "QgsRendererV2DataDefinedMenus": ["sizeScaleFieldSelected(QAction *a)", "scaleMethodChanged(QgsSymbolV2::ScaleMethod scaleMethod)", "rotationFieldChanged(const QString &fldName)", "scaleMethodSelected(QAction *a)", "rotationFieldSelected(QAction *a)", "sizeScaleFieldChanged(const QString &fldName)", "populateMenu(QMenu *menu, const QString &fieldName, QActionGroup *actionGroup)"],
    "QgsHttpTransaction": ["transactionFinished(bool error)", "dataProgress(int done, int total)", "networkTimedOut()", "getAsynchronously()", "responseContentType()", "dataReceived(const QHttpResponseHeader &resp)", "dataStateChanged(int state)", "dataFinished(int id, bool error)", "dataHeaderReceived(const QHttpResponseHeader &resp)", "dataStarted(int id)"],
    "QgsColorWidgetFactory": ["QgsColorWidgetFactory(const QString &name)"],
    "QgsDateTimeEditConfig": ["QgsDateTimeEditConfig(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsFileNameWidgetWrapper": ["QgsFileNameWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsApplyDialog": ["apply() const =0"],
    "QgsImageFetcher": ["finish(const QImage &legend)", "progress(qint64 received, qint64 total)", "error(const QString &msg)", "start()=0"],
    "QgsFeatureListView": ["repaintRequested()", "repaintRequested(const QModelIndexList &indexes)"],
    "QgsScopeLogger": ["QgsScopeLogger(const char *file, const char *func, int line)"],
    "QgsDiagram": ["clearCache()", "diagramName() const =0", "QgsDiagram(const QgsDiagram &other)"],
    "QgsPixmapLabel": ["QgsPixmapLabel(QWidget *parent=nullptr)", "setPixmap(const QPixmap &)"],
    "QgsTransectSample": ["createSample(QProgressDialog *pd)", "DistanceUnits", "QgsTransectSample(QgsVectorLayer *strataLayer, const QString &strataIdAttribute, const QString &minDistanceAttribute, const QString &nPointsAttribute, DistanceUnits minDistUnits, QgsVectorLayer *baselineLayer, bool shareBaseline, const QString &baselineStrataId, const QString &outputPointLayer, const QString &outputLineLayer, const QString &usedBaselineLayer, double minTransectLength=0.0, double baselineBufferDistance=-1.0, double baselineSimplificationTolerance=-1.0)"],
    "QgsRendererCategoryV2": ["label() const ", "swap(QgsRendererCategoryV2 &other)", "symbol() const ", "setValue(const QVariant &value)", "renderState() const ", "toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const ", "setRenderState(bool render)", "value() const ", "setSymbol(QgsSymbolV2 *s)", "dump() const ", "setLabel(const QString &label)"],
    "QgsOSMTags": ["count() const ", "insert(const QString &k, const QString &v)", "value(const QString &k) const ", "contains(const QString &k) const ", "keys() const "],
    "QgsCodeEditorCSS": ["QgsCodeEditorCSS(QWidget *parent=nullptr)"],
    "QgsRasterMinMaxWidget": ["QgsRasterMinMaxWidget(QgsRasterLayer *theLayer, QWidget *parent=nullptr)", "load()", "setExtent(const QgsRectangle &theExtent)", "setBands(const QList< int > &theBands)", "load(int theBandNo, double theMin, double theMax, int origin)"],
    "QgsUniqueValuesConfigDlg": ["QgsUniqueValuesConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsEffectStack": ["QgsEffectStack(const QgsEffectStack &other)"],
    "QgsMapCanvasRendererSync": ["onDestCrsR2C()", "onLayersC2R()", "onCrsTransformR2C()", "onExtentR2C()", "QgsMapCanvasRendererSync(QgsMapCanvas *canvas, QgsMapRenderer *renderer)", "onExtentC2R()", "onMapUnitsC2R()", "onMapUnitsR2C()", "onCrsTransformC2R()", "onDestCrsC2R()"],
    "QgsMapUnitScaleDialog": ["QgsMapUnitScaleDialog(QWidget *parent=nullptr)"],
    "QgsFieldExpressionWidget": ["currentFieldChanged()", "setLeftHandButtonStyle(bool isLeft)", "isExpressionValid(const QString &expressionStr)"],
    "QgsRuleBasedRendererV2Widget": ["editRule(const QModelIndex &index)", "editRule()", "refineRuleScalesGui(const QModelIndexList &index)", "restoreSectionWidths()", "QgsRuleBasedRendererV2Widget(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "currentRuleChanged(const QModelIndex &current=QModelIndex(), const QModelIndex &previous=QModelIndex())", "clearFeatureCounts()", "refineRuleRanges()", "setRenderingOrder()", "addRule()", "create(QgsVectorLayer *layer, QgsStyleV2 *style, QgsFeatureRendererV2 *renderer)", "refineRuleCategories()", "refineRuleRangesGui(const QModelIndexList &index)", "currentRule()", "selectedRulesChanged()", "refineRuleCategoriesGui(const QModelIndexList &index)", "saveSectionWidth(int section, int oldSize, int newSize)", "refineRule(int type)", "removeRule()", "selectedRules()", "countFeatures()", "refineRuleScales()"],
    "QgsSymbolLevelsV2Dialog": ["renderingPassChanged(int row, int column)", "setForceOrderingEnabled(bool enabled)", "updateUi()", "usingLevels() const "],
    "QgsAbstractGeometryV2": ["QgsAbstractGeometryV2(const QgsAbstractGeometryV2 &geom)", "ringCount(int part=0) const =0", "vertexCount(int part=0, int ring=0) const =0"],
    "QgsUuidWidgetWrapper": ["QgsUuidWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsSimpleLineSymbolLayerV2Widget": ["penStyleChanged()", "penWidthChanged()", "create(const QgsVectorLayer *vl)", "offsetChanged()", "updatePatternIcon()", "colorChanged(const QColor &color)", "QgsSimpleLineSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)"],
    "QgsRasterNuller": ["noData(int bandNo) const ", "setNoData(int bandNo, const QgsRasterRangeList &noData)", "QgsRasterNuller(QgsRasterInterface *input=nullptr)"],
    "QgsRasterLayer": ["renderer() const ", "showStatusMessage(const QString &theMessage)", "rasterUnitsPerPixelY()", "brightnessFilter() const ", "hueSaturationFilter() const ", "isValidRasterFileName(const QString &theFileNameQString)"],
    "QgsMimeDataUtils": ["isUriList(const QMimeData *data)", "encodeUriList(const UriList &layers)", "None", "decodeUriList(const QMimeData *data)"],
    "QGis": ["wkbDimensions(WkbType type)", "GeometryType"],
    "QgsDetailedItemWidget": ["setData(const QgsDetailedItemData &theData)", "QgsDetailedItemWidget(QWidget *parent=nullptr)", "setChecked(bool theFlag)"],
    "QgsComposerStyleItem": ["QgsComposerStyleItem(QgsComposerLegendItem *item)"],
    "QgsPointPatternFillSymbolLayer": ["setDisplacementX(double d)", "displacementYUnit() const ", "distanceXUnit() const ", "setDistanceYUnit(QgsSymbolV2::OutputUnit unit)", "distanceX() const ", "setDistanceX(double d)", "displacementYMapUnitScale() const ", "setDisplacementY(double d)", "setDistanceYMapUnitScale(const QgsMapUnitScale &scale)", "displacementXMapUnitScale() const ", "distanceYMapUnitScale() const ", "displacementXUnit() const ", "setDistanceY(double d)", "distanceYUnit() const ", "distanceY() const ", "displacementY() const ", "createFromSld(QDomElement &element)", "displacementX() const ", "setDisplacementYMapUnitScale(const QgsMapUnitScale &scale)", "setDistanceXUnit(QgsSymbolV2::OutputUnit unit)", "setDisplacementXMapUnitScale(const QgsMapUnitScale &scale)", "distanceXMapUnitScale() const ", "create(const QgsStringMap &properties=QgsStringMap())", "setDisplacementYUnit(QgsSymbolV2::OutputUnit unit)", "setDistanceXMapUnitScale(const QgsMapUnitScale &scale)", "setDisplacementXUnit(QgsSymbolV2::OutputUnit unit)"],
    "QgsDiagramSettings": ["LabelPlacementMethod", "readXML(const QDomElement &elem, const QgsVectorLayer *layer)", "writeXML(QDomElement &rendererElem, QDomDocument &doc, const QgsVectorLayer *layer) const ", "SizeType"],
    "QgsScopedExpressionFunction": ["QgsScopedExpressionFunction(const QString &fnname, int params, const QString &group, const QString &helpText=QString(), bool usesGeometry=false, const QStringList &referencedColumns=QStringList(), bool lazyEval=false, bool handlesNull=false, bool isContextual=true)"],
    "QgsSublayersDialog": ["selectionIndexes()", "ProviderType", "exec()", "QgsSublayersDialog(ProviderType providerType, const QString &name, QWidget *parent=nullptr, const Qt::WindowFlags &fl=nullptr)", "populateLayerTable(const QStringList &theList, const QString &delim=\":\")", "selectionNames()"],
    "QgsCustomLayerOrderWidget": ["bridgeHasCustomLayerOrderChanged(bool state)", "QgsCustomLayerOrderWidget(QgsLayerTreeMapCanvasBridge *bridge, QWidget *parent=nullptr)", "nodeVisibilityChanged(QgsLayerTreeNode *node, Qt::CheckState state)", "bridgeCustomLayerOrderChanged(const QStringList &order)", "modelUpdated()"],
    "QgsRasterShader": ["readXML(const QDomElement &elem)", "rasterShaderFunction()", "writeXML(QDomDocument &doc, QDomElement &parent) const ", "rasterShaderFunction() const ", "QgsRasterShader(double theMinimumValue=0.0, double theMaximumValue=255.0)"],
    "QgsHiddenWidgetFactory": ["QgsHiddenWidgetFactory(const QString &name)"],
    "QgisVisitor": ["QgisVisitor(QList< QgsFeatureId > &list)"],
    "QgsShadowEffectWidget": ["create()", "QgsShadowEffectWidget(QWidget *parent=nullptr)"],
    "QgsFavouritesItem": ["QgsFavouritesItem(QgsDataItem *parent, const QString &name, const QString &path=QString())", "iconFavourites()", "addDirectory(const QString &favIcon)", "removeDirectory(QgsDirectoryItem *item)"],
    "QgsRendererV2Widget": ["refreshSymbolView()", "QgsRendererV2Widget(QgsVectorLayer *layer, QgsStyleV2 *style)", "copy()", "contextMenuViewCategories(QPoint p)", "paste()"],
    "QgsComposerSymbolV2Item": ["QgsComposerSymbolV2Item(const QIcon &icon, const QString &text)", "QgsComposerSymbolV2Item(const QString &text)", "symbolV2()"],
    "QgsAspectFilter": ["QgsAspectFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsDefaultVectorLayerLegend": ["QgsDefaultVectorLayerLegend(QgsVectorLayer *vl)"],
    "QgsDateTimeEdit": ["QgsDateTimeEdit(QWidget *parent=nullptr)", "allowNull() const "],
    "QgsCheckboxWidgetFactory": ["QgsCheckboxWidgetFactory(const QString &name)"],
    "QgsVectorLayerImport": ["ImportError", "errorCount() const "],
    "QgsRelationManager": ["QgsRelationManager(QgsProject *project)"],
    "QgsValueMapSearchWidgetWrapper": ["QgsValueMapSearchWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsComposerTextTableV2": ["QgsComposerTextTableV2(QgsComposition *c, bool createUndoCommands)"],
    "QgsRasterIterator": ["QgsRasterIterator(QgsRasterInterface *input)", "setMaximumTileHeight(int h)", "stopRasterRead(int bandNumber)", "maximumTileHeight() const ", "setMaximumTileWidth(int w)", "input() const ", "maximumTileWidth() const "],
    "QgsRasterBandStats": ["Stats"],
    "QgsFeatureSelectionModel": ["setFeatureSelectionManager(QgsIFeatureSelectionManager *featureSelectionManager)", "QgsFeatureSelectionModel(QAbstractItemModel *model, QgsFeatureModel *featureModel, QgsIFeatureSelectionManager *featureSelectionHandler, QObject *parent)"],
    "QgsComposerMultiFrameCommand": ["multiFrame() const ", "saveAfterState()", "previousState() const ", "checkFirstRun()", "QgsComposerMultiFrameCommand(QgsComposerMultiFrame *multiFrame, const QString &text, QUndoCommand *parent=nullptr)", "restoreState(QDomDocument &stateDoc)", "afterState() const ", "savePreviousState()", "saveState(QDomDocument &stateDoc)"],
    "QgsExtentGroupBox": ["extentState() const ", "currentCrs() const ", "setOutputExtentFromLineEdit()", "setOutputExtent(const QgsRectangle &r, const QgsCoordinateReferenceSystem &srcCrs, ExtentState state)", "updateTitle()", "ExtentState", "originalCrs() const ", "QgsExtentGroupBox(QWidget *parent=nullptr)", "groupBoxClicked()", "originalExtent() const ", "currentExtent() const "],
    "QgsComposerAttributeTableCompare": ["operator()(const QgsAttributeMap &m1, const QgsAttributeMap &m2)"],
    "QgsSpinBox": ["ClearValueMode", "showClearButton() const ", "QgsSpinBox(QWidget *parent=nullptr)"],
    "QgsComposerItem": ["beginItemCommand(const QString &text)", "endItemCommand()", "ItemType", "removeItems()", "deleteHAlignSnapItem()", "deleteVAlignSnapItem()", "ItemPositionMode", "cancelCommand()", "deleteAlignItems()"],
    "QgsBlurWidget": ["create()", "QgsBlurWidget(QWidget *parent=nullptr)"],
    "QgsZipItem": ["QgsZipItem(QgsDataItem *parent, const QString &name, const QString &filePath, const QString &path)", "itemFromPath(QgsDataItem *parent, QString path, QString name)", "getZipFileList()", "QgsZipItem(QgsDataItem *parent, const QString &name, const QString &path)", "iconZip()", "vsiPrefix(const QString &uri)"],
    "NormVecDecorator": ["NormVecDecorator(Triangulation *tin)"],
    "QgsVectorLayerJoinBuffer": ["vectorJoins() const ", "QgsVectorLayerJoinBuffer(QgsVectorLayer *layer=nullptr)"],
    "pal::Pal": ["solveProblem(Problem *prob, bool displayAll)", "extractProblem(double bbox[4])", "FnIsCancelled)(void *ctx)"],
    "QgsSearchWidgetWrapper": ["setExpression(QString value)=0"],
    "QgsRasterFillSymbolLayer": ["create(const QgsStringMap &properties=QgsStringMap())", "QgsRasterFillSymbolLayer(const QString &imageFilePath=QString())", "FillCoordinateMode"],
    "QgsExpression::NodeInOperator": ["NodeInOperator(Node *node, NodeList *list, bool notin=false)", "node() const ", "isNotIn() const ", "list() const "],
    "QgsComposerView": ["setVerticalRuler(QgsComposerRuler *r)", "currentTool() const ", "ToolStatus", "PasteMode", "ClipboardMode", "QgsComposerView(QWidget *parent=nullptr, const char *name=nullptr, const Qt::WindowFlags &f=nullptr)", "setPaintingEnabled(bool enabled)", "setCurrentTool(QgsComposerView::Tool t)", "setHorizontalRuler(QgsComposerRuler *r)", "paintingEnabled() const "],
    "QgsOSMElement": ["QgsOSMElement(QgsOSMElementID::Type t, QgsOSMId id)", "isValid() const ", "id() const ", "elemID() const "],
    "QgsHueSaturationFilter": ["saturation() const ", "colorizeColor() const ", "colorizeStrength() const ", "setColorizeColor(const QColor &colorizeColor)", "setColorizeOn(bool colorizeOn)", "colorizeOn() const ", "setSaturation(int saturation)", "GrayscaleMode", "grayscaleMode() const ", "QgsHueSaturationFilter(QgsRasterInterface *input=nullptr)", "setGrayscaleMode(QgsHueSaturationFilter::GrayscaleMode grayscaleMode)", "setColorizeStrength(int colorizeStrength)"],
    "QgsAttributeTableDelegate": ["setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)"],
    "QgsRuggednessFilter": ["QgsRuggednessFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsDefaultRasterLayerLegend": ["QgsDefaultRasterLayerLegend(QgsRasterLayer *rl)"],
    "QgsGridFileWriter": ["QgsGridFileWriter(QgsInterpolator *i, const QString &outputPath, const QgsRectangle &extent, int nCols, int nRows, double cellSizeX, double cellSizeY)"],
    "QgsVectorLayerUndoCommandAddFeature": ["QgsVectorLayerUndoCommandAddFeature(QgsVectorLayerEditBuffer *buffer, QgsFeature &f)"],
    "QgsCategorizedSymbolRendererV2": ["symbolForValue(const QVariant &value)", "addCategory(const QgsRendererCategoryV2 &category)", "setSizeScaleField(const QString &fieldOrExpression)", "setInvertedColorRamp(bool inverted)", "rebuildHash()", "scaleMethod() const ", "QgsCategorizedSymbolRendererV2(const QString &attrName=QString(), const QgsCategoryList &categories=QgsCategoryList())", "updateCategoryValue(int catIndex, const QVariant &value)", "categories() const ", "sizeScaleField() const ", "sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)", "setClassAttribute(const QString &attr)", "classAttribute() const ", "sortByValue(Qt::SortOrder order=Qt::AscendingOrder)", "updateCategorySymbol(int catIndex, QgsSymbolV2 *symbol)", "setScaleMethod(QgsSymbolV2::ScaleMethod scaleMethod)", "skipRender()", "deleteCategory(int catIndex)", "deleteAllCategories()", "updateCategoryLabel(int catIndex, const QString &label)"],
    "QgsExpression::NodeFunction": ["args() const ", "fnIndex() const ", "NodeFunction(int fnIndex, NodeList *args)"],
    "QgsDualView": ["setFeatureSelectionManager(QgsIFeatureSelectionManager *featureSelectionManager)", "openConditionalStyles()", "setRequest(const QgsFeatureRequest &request)", "filterMode()", "filteredFeatures()"],
    "QgsContextHelp": ["run(const QString &context)"],
    "QgsCodeEditorSQL": ["QgsCodeEditorSQL(QWidget *parent=nullptr)"],
    "QgsVectorFileWriter::IntOption": ["IntOption(const QString &docString, int defaultValue)"],
    "QgsExternalResourceWidgetWrapper": ["QgsExternalResourceWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsMarkerSymbolV2": ["setAngle(double angle)", "scaleMethod()", "size() const ", "angle() const ", "setSize(double size)", "renderPoint(QPointF point, const QgsFeature *f, QgsRenderContext &context, int layer=-1, bool selected=false)", "setScaleMethod(QgsSymbolV2::ScaleMethod scaleMethod)", "QgsMarkerSymbolV2(const QgsSymbolLayerV2List &layers=QgsSymbolLayerV2List())"],
    "QgsTextEditWrapper": ["QgsTextEditWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsHillshadeFilter": ["lightAzimuth() const ", "setLightAngle(float angle)", "lightAngle() const ", "setLightAzimuth(float azimuth)", "QgsHillshadeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat, double lightAzimuth=300, double lightAngle=40)"],
    "TriDecorator": ["TriDecorator(Triangulation *t)"],
    "QgsUniqueValuesWidgetWrapper": ["QgsUniqueValuesWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsComposerLegendStyle": ["margin(Side side)", "writeXML(const QString &name, QDomElement &elem, QDomDocument &doc) const ", "Style", "rfont()", "setMargin(Side side, double margin)", "font() const ", "setMargin(double margin)", "readXML(const QDomElement &elem, const QDomDocument &doc)", "setFont(const QFont &font)", "Side"],
    "QgsPropertyValue": ["count() const ", "QgsPropertyValue(const QVariant &value)"],
    "QgsCptCityCollectionItem": ["setPopulated()", "childrenRamps(bool recursive)", "QgsCptCityCollectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "addChild(QgsCptCityDataItem *item)"],
    "QgsRuleBasedLabelProvider": ["QgsRuleBasedLabelProvider(const QgsRuleBasedLabeling &rules, QgsVectorLayer *layer, bool withFeatureLoop=true)"],
    "QgsBlendModeComboBox": ["updateModes()", "QgsBlendModeComboBox(QWidget *parent=nullptr)"],
    "QgsComposerRasterSymbolItem": ["setColor(const QColor &c)", "color() const ", "QgsComposerRasterSymbolItem(const QString &text)", "setLayerID(const QString &id)", "layerID() const ", "QgsComposerRasterSymbolItem(const QIcon &icon, const QString &text)"],
    "QgsSimpleFillSymbolLayerV2": ["setOffsetUnit(QgsSymbolV2::OutputUnit unit)", "setBorderWidthUnit(QgsSymbolV2::OutputUnit unit)", "offsetMapUnitScale() const ", "setBrushStyle(Qt::BrushStyle style)", "penJoinStyle() const ", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "QgsSimpleFillSymbolLayerV2(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, Qt::BrushStyle style=DEFAULT_SIMPLEFILL_STYLE, const QColor &borderColor=DEFAULT_SIMPLEFILL_BORDERCOLOR, Qt::PenStyle borderStyle=DEFAULT_SIMPLEFILL_BORDERSTYLE, double borderWidth=DEFAULT_SIMPLEFILL_BORDERWIDTH, Qt::PenJoinStyle penJoinStyle=DEFAULT_SIMPLEFILL_JOINSTYLE)", "offset()", "setBorderWidthMapUnitScale(const QgsMapUnitScale &scale)", "offsetUnit() const ", "setPenJoinStyle(Qt::PenJoinStyle style)", "borderWidthUnit() const ", "borderWidth() const ", "setBorderWidth(double borderWidth)", "borderWidthMapUnitScale() const ", "createFromSld(QDomElement &element)", "setOffset(QPointF offset)", "borderColor() const ", "brushStyle() const ", "create(const QgsStringMap &properties=QgsStringMap())", "setBorderColor(const QColor &borderColor)", "setBorderStyle(Qt::PenStyle borderStyle)", "borderStyle() const "],
    "QgsLegendSymbolItemV2": ["QgsLegendSymbolItemV2(const QgsLegendSymbolItemV2 &other)"],
    "QgsGeometryCollectionV2": ["QgsGeometryCollectionV2(const QgsGeometryCollectionV2 &c)"],
    "QgsDateTimeEditFactory": ["QgsDateTimeEditFactory(const QString &name)"],
    "QgsSvgSelectorGroupsModel": ["QgsSvgSelectorGroupsModel(QObject *parent)"],
    "QgsDataDefinedWidthDialog": ["QgsDataDefinedWidthDialog(const QList< QgsSymbolV2 * > &symbolList, QgsVectorLayer *layer)"],
    "QgsDoubleBoxScaleBarStyle": ["QgsDoubleBoxScaleBarStyle(const QgsComposerScaleBar *bar)"],
    "QgsAddRemoveItemCommand": ["QgsAddRemoveItemCommand(State s, QgsComposerItem *item, QgsComposition *c, const QString &text, QUndoCommand *parent=nullptr)", "State", "itemRemoved(QgsComposerItem *item)", "itemAdded(QgsComposerItem *item)"],
    "QgsSymbolV2LegendNode": ["QgsSymbolV2LegendNode(QgsLayerTreeLayer *nodeLayer, const QgsLegendSymbolItemV2 &item, QObject *parent=nullptr)"],
    "QgsFeatureIteratorDataStream": ["readNextEntry()"],
    "QgsWKBTypes": ["GeometryType", "Type"],
    "QgsExpression::NodeBinaryOperator": ["computeDouble(double x, double y)", "computeInt(int x, int y)", "op() const ", "opLeft() const ", "compare(double diff)", "NodeBinaryOperator(BinaryOperator op, Node *opLeft, Node *opRight)", "opRight() const ", "precedence() const ", "computeDateTimeFromInterval(const QDateTime &d, QgsExpression::Interval *i)", "leftAssociative() const "],
    "QgsPointDisplacementRenderer": ["QgsPointDisplacementRenderer(const QString &labelAttributeName=\"\")", "setMaxLabelScaleDenominator(double d)", "circleRadiusAddition() const ", "embeddedRenderer() const ", "setCircleColor(const QColor &c)", "circleWidth() const ", "labelAttributeName() const ", "setLabelFont(const QFont &f)", "circleColor() const ", "setLabelColor(const QColor &c)", "setCircleWidth(double w)", "labelColor() const ", "maxLabelScaleDenominator() const ", "labelFont() const ", "setLabelAttributeName(const QString &name)", "setCircleRadiusAddition(double d)"],
    "QgsSimpleLineSymbolLayerV2": ["penJoinStyle() const ", "setPenJoinStyle(Qt::PenJoinStyle style)", "setCustomDashVector(const QVector< qreal > &vector)", "penCapStyle() const ", "drawInsidePolygon() const ", "customDashPatternUnit() const ", "customDashVector() const ", "setUseCustomDashPattern(bool b)", "setDrawInsidePolygon(bool drawInsidePolygon)", "useCustomDashPattern() const ", "setCustomDashPatternMapUnitScale(const QgsMapUnitScale &scale)", "setPenCapStyle(Qt::PenCapStyle style)", "QgsSimpleLineSymbolLayerV2(const QColor &color=DEFAULT_SIMPLELINE_COLOR, double width=DEFAULT_SIMPLELINE_WIDTH, Qt::PenStyle penStyle=DEFAULT_SIMPLELINE_PENSTYLE)", "setCustomDashPatternUnit(QgsSymbolV2::OutputUnit unit)", "create(const QgsStringMap &properties=QgsStringMap())", "customDashPatternMapUnitScale() const ", "setPenStyle(Qt::PenStyle style)", "createFromSld(QDomElement &element)", "penStyle() const "],
    "QgsVectorLayerFeatureIterator": ["QgsVectorLayerFeatureIterator(QgsVectorLayerFeatureSource *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsGradientFillSymbolLayerV2Widget": ["applyColorRamp()", "create(const QgsVectorLayer *vl)", "offsetChanged()", "QgsGradientFillSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "setCoordinateMode(int index)", "setGradientType(int index)", "setGradientSpread(int index)", "setColor(const QColor &color)", "referencePointChanged()", "setColor2(const QColor &color)", "colorModeChanged()"],
    "QgsSvgMarkerSymbolLayerV2Widget": ["setAngle()", "create(const QgsVectorLayer *vl)", "setGuiForSvg(const QgsSvgMarkerSymbolLayerV2 *layer)", "setSize()", "populateIcons(const QModelIndex &idx)", "setOffset()", "QgsSvgMarkerSymbolLayerV2Widget(const QgsVectorLayer *vl, QWidget *parent=nullptr)", "populateList()", "setName(const QModelIndex &idx)"],
    "QgsPhotoWidgetWrapper": ["QgsPhotoWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)"],
    "QgsFeatureModel": ["fidToIndex(QgsFeatureId fid)=0"],
    "QgsLinearMinMaxEnhancementWithClip": ["QgsLinearMinMaxEnhancementWithClip(QGis::DataType, double, double)"],
    "QgsGeometryCache": ["cachedGeometries()", "cachedGeometriesRect()", "setCachedGeometriesRect(const QgsRectangle &extent)"],
    "QgsAuthCertInfo": ["QgsAuthCertInfo(const QSslCertificate &cert, bool manageCertTrust=false, QWidget *parent=nullptr, const QList< QSslCertificate > &connectionCAs=QList< QSslCertificate >())", "trustCacheRebuilt()"],
    "QgsExpressionBuilderWidget": ["loadRecent(const QString &key)", "QgsExpressionBuilderWidget(QWidget *parent)", "isExpressionValid()", "saveToRecent(const QString &key)", "loadFieldNames(const QgsFields &fields)", "showEvent(QShowEvent *e)"],
    "QgsTINInterpolator": ["setExportTriangulationToFile(bool e)", "TIN_INTERPOLATION", "setTriangulationFilePath(const QString &filepath)", "QgsTINInterpolator(const QList< LayerData > &inputData, TIN_INTERPOLATION interpolation=Linear, bool showProgressDialog=false)"],
    "QgsMapLayerProxyModel": ["Filter", "exceptedLayerList()", "filters() const "],
    "QgsCompoundCurveV2": ["QgsCompoundCurveV2(const QgsCompoundCurveV2 &curve)"],
    "QgisPlugin": ["QgisPlugin(QString const &name=\"\", QString const &description=\"\", QString const &category=\"\", QString const &version=\"\", PLUGINTYPE const &type=MAPLAYER)", "name()"],
    "QgsFields": ["FieldOrigin", "None"],
    "QgsGlowEffect": ["QgsGlowEffect(const QgsGlowEffect &other)"],
    "Node": ["Node(const Node &n)"],
    "QgsSymbolV2LevelItem": ["layer()", "QgsSymbolV2LevelItem(QgsSymbolV2 *symbol, int layer)", "symbol()"],
    "QgsInterpolator": ["QgsInterpolator(const QList< LayerData > &layerData)"],
    "QgsComposerFrame": ["QgsComposerFrame(QgsComposition *c, QgsComposerMultiFrame *mf, qreal x, qreal y, qreal width, qreal height)"],
    "QgsComposerArrow": ["MarkerMode"],
    "QgsAttributeAction": ["operator[](int idx)", "setDefaultAction(int actionNumber)", "size() const ", "at(int idx)"],
    "QgsRelationReferenceWidget": ["setEditorContext(const QgsAttributeEditorContext &context, QgsMapCanvas *canvas, QgsMessageBar *messageBar)", "foreignKeyChanged(const QVariant &)", "None", "setAllowMapIdentification(bool allowMapIdentification)", "setEmbedForm(bool display)", "CanvasExtent", "init()", "setRelation(const QgsRelation &relation, bool allowNullValue)", "setOpenFormButtonVisible(bool openFormButtonVisible)", "setRelationEditable(bool editable)", "setReadOnlySelector(bool readOnly)", "QgsRelationReferenceWidget(QWidget *parent)"],
    "QgsAttributeEditorContext": ["relationMode() const ", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, const QgsRelation &relation, RelationMode relationMode, FormMode widgetMode)", "FormMode", "formMode() const ", "vectorLayerTools() const ", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, FormMode formMode)", "setDistanceArea(const QgsDistanceArea &distanceArea)", "distanceArea() const ", "setVectorLayerTools(QgsVectorLayerTools *vlTools)", "setRelation(const QgsRelation &relation, RelationMode mode)", "parentContext() const ", "relation() const "],
    "QgsPalettedRasterRenderer": ["QgsPalettedRasterRenderer(QgsRasterInterface *input, int bandNumber, QRgb *colorArray, int nColors, const QVector< QString > &labels=QVector< QString >())", "create(const QDomElement &elem, QgsRasterInterface *input)"],
}

ACCEPTABLE_MISSING_ADDED_NOTE = [
    "QgsDerivativeFilter",
    "QgsLayerTreeEmbeddedConfigWidget",
    "QgsCptCityDirectoryItem",
    "QgsDataDefinedRotationDialog",
    "QgsAttributeTypeLoadDialog",
    "QgsProject",
    "QgsDirectoryParamWidget",
    "QgsLegendModelV2",
    "QgsLayerTreeNode",
    "QgsSlopeFilter",
    "QgsPointLocator_VisitorArea",
    "pal::InternalException::Full",
    "QgsPluginLayer",
    "QgsGeometryValidator",
    "QgsLineSymbolV2",
    "QgsFeatureListViewDelegate",
    "QgsHighlight",
    "pal::Sol",
    "QgsServer",
    "QgsOSMXmlImport",
    "QgsDiagramLabelFeature",
    "QgsPanelWidgetStack",
    "QgsMapUnitScaleDialog",
    "QgsDoubleSpinBox",
    "QgsSingleBandPseudoColorRenderer",
    "QgsRasterLayerSaveAsDialog",
    "QgsSvgSelectorDialog",
    "QgsRendererRulePropsWidget",
    "QgsErrorItem",
    "QgsCheckboxWidgetFactory",
    "QgsComposerLayerItem",
    "QgsDataDefined",
    "Triangulation",
    "QgsGlowWidget",
    "QgsVectorFileWriter::Option",
    "QgsColorSwatchDelegate",
    "QgsTextEditWrapper",
    "QgsCaseInsensitiveLexerSQL",
    "QgsServerInterface",
    "QgsAuthMethodPlugins",
    "QgsMapSettings",
    "QgsLayerDefinition",
    "pal::InternalException::WrongGeometry",
    "QgsRasterDrawer",
    "QgsOgcUtils",
    "QgsMapLayerStyleManagerWidget",
    "QgsCoordinateTransformCache",
    "QgsRangeWidgetWrapper",
    "QgsFeatureIteratorDataStream",
    "QgsSimpleLineSymbolLayerV2Widget",
    "QgsContrastEnhancement",
    "QgsHillshadeFilter",
    "QgsCachedFeatureIterator",
    "QgsAuthCrypto",
    "QgsAuthSslErrorsDialog",
    "QgsRendererV2Registry",
    "QgsExpression",
    "Node",
    "QgsFeatureListModel",
    "QgsAuthMethodMetadata",
    "QgsComposerScaleBar",
    "QgsExpression::Function",
    "QgsMultiBandColorRendererWidget",
    "QgsFeatureRequest::OrderByClause",
    "QgsColorWidgetAction",
    "Bezier3D",
    "QgsSQLStatement::NodeJoin",
    "Point3D",
    "QgsSLConnect",
    "QgsConditionalStyle",
    "QgsExpression::NodeList",
    "QgsSingleSymbolRendererV2Widget",
    "QgsDbFilterProxyModel",
    "QgsRasterShaderFunction",
    "QgsContextHelp",
    "QgsBrushStyleComboBox",
    "QgsSVGFillSymbolLayer",
    "QgsPluginLayerRegistry",
    "pal::PalException::UnknownFeature",
    "QgsMapLayerActionRegistry",
    "QgsMapToolIdentify",
    "QgsTableWidgetItem",
    "QgsFontMarkerSymbolLayerV2Widget",
    "QgsLabel",
    "QgsColorSwatchGridAction",
    "QgsRelation",
    "QgsVectorGradientColorRampV2Dialog",
    "QgsSQLStatement::NodeBetweenOperator",
    "QgsScaleBarStyle",
    "QgsMapToolIdentifyFeature",
    "QgsMultiBandColorRenderer",
    "QgsGraphBuilderInterface",
    "QgsComposerHtml",
    "QgsRasterPyramidsOptionsWidget",
    "QgsColorRampShader",
    "QgsMapUnitScale",
    "pal::Util",
    "QgsDataDefinedSymbolDialog",
    "QgsGpsdConnection",
    "pal::PointSet",
    "QgsDateTimeEditWrapper",
    "NormVecDecorator",
    "QGis",
    "QgsDetailedItemWidget",
    "QgsDataDefinedSizeDialog",
    "QgsDxfExport",
    "QgsIdentifyMenu",
    "QgsRendererRangeV2",
    "QgsDiagramSettings",
    "QgsDataItemProviderRegistry",
    "QgsSymbolV2SelectorDialog",
    "QgsComposerFrame",
    "QgsFontMarkerSymbolLayerV2",
    "QgsSpinBox",
    "QgsAction",
    "QgsSQLComposerDialog::SQLValidatorCallback",
    "QgsGPSDetector",
    "QgsExpressionHighlighter",
    "QgsMapToPixelSimplifier",
    "QgsVectorColorBrewerColorRampV2Dialog",
    "QgsCptCityAllRampsItem",
    "QgsOSMWay",
    "QgsLabelingEngineInterface",
    "QgsEditorConfigWidget",
    "QgsDataProvider",
    "QgsLayerTreeView",
    "QgsActionManager",
    "QgsSQLStatement::NodeColumnRef",
    "QgsRendererV2DataDefinedMenus",
    "QgsLocaleNumC",
    "QgsRasterChecker",
    "QgsNumericScaleBarStyle",
    "QgsVectorLayerUndoCommandDeleteFeature",
    "QgsTextEditConfigDlg",
    "QgsOgcUtilsExprToFilter",
    "QgsOSMNode",
    "QgsAuthSslConfigWidget",
    "QgsPixmapLabel",
    "QgsAuthConfigIdEdit",
    "QgsVectorLayerTools",
    "QgsBlendModeComboBox",
    "QgsConstWkbSimplifierPtr",
    "QgsRelief",
    "QgsFeature",
    "QgsProjectBadLayerHandler",
    "QgsCptCityCollectionItem",
    "QgsGridFileWriter",
    "QgsVectorLayerUndoCommandDeleteAttribute",
    "QgsWebView",
    "QgsAbstractCacheIndex",
    "QgsIFeatureSelectionManager",
    "QgsInvertedPolygonRenderer",
    "QgsSQLComposerDialog",
    "QgsNetworkAccessManager",
    "QgsLayerPropertiesWidget",
    "QgsRasterRendererRegistry",
    "QgsRasterRendererWidget",
    "pal::PalException::FeatureExists",
    "QgsAttributeTableFilterModel",
    "QgsPhotoWidgetFactory",
    "QgsComposerView",
    "QgsVectorFileWriter::SetOption",
    "QgsLinearMinMaxEnhancementWithClip",
    "QgsMapCanvas::CanvasProperties",
    "QgsLabelFeature",
    "QgsWebViewWidgetConfigDlg",
    "QgsSymbolLayerV2",
    "QgsMapRendererJob",
    "QgsQueryBuilder",
    "QgsSQLStatement::Visitor",
    "QgsCentroidFillSymbolLayerV2",
    "QgsTreeWidgetItem",
    "QgsSvgMarkerSymbolLayerV2Widget",
    "QgsSingleCategoryDiagramRenderer",
    "QgsSurfaceV2",
    "QgsOgcUtilsSQLStatementToFilter",
    "QgsPalettedRendererWidget",
    "QgsLabelSearchTree",
    "QgsSQLStatement::NodeTableDef",
    "QgsComposerUtils",
    "QgsRasterCalcNode",
    "QgsTextEditWidgetFactory",
    "QgsUniqueValueWidgetFactory",
    "QgsMapLayerAction",
    "QgsNumericSortTreeWidgetItem",
    "QgsPkiBundle",
    "QgsVectorLayerLabelProvider",
    "QgsTextAnnotationItem",
    "QgsPluginManagerInterface",
    "QgsFeatureListView",
    "QgsOSMDownload",
    "QgsAdvancedDigitizingDockWidget::CadConstraint",
    "QgsSimpleMarkerSymbolLayerV2Widget",
    "QgsTolerance",
    "QgsRasterLayer",
    "QgsComposerObject",
    "QgsMapHitTest",
    "QgsLegendRenderer",
    "QgsColorWidgetFactory",
    "QgsWidgetWrapper",
    "QgsRangeWidgetFactory",
    "QgsPointCompare",
    "QgsComposerAttributeTableCompareV2",
    "QgsCRSCache",
    "QgsCptCityColorRampV2",
    "QgsAttributeEditorContext",
    "QgsSymbologyV2Conversion",
    "QgsAttributeEditorRelation",
    "QgsPointDisplacementRendererWidget",
    "QgsOSMDatabase",
    "QgsAbstractGeometrySimplifier",
    "QgsComposerMapItem",
    "QgsProviderExtentCalcEvent",
    "pal::PolygonCostCalculator",
    "pal::Pal",
    "QgsMapRendererCustomPainterJob",
    "QgsExternalResourceWidget",
    "QgsRasterShader",
    "QgsOverlayAnalyzer",
    "QgsComposerLegend",
    "QgsCachedFeatureWriterIterator",
    "QgsFileNameWidgetWrapper",
    "QgsComposerTextTable",
    "QgsNineCellFilter",
    "QgsSymbolLayerV2AbstractMetadata",
    "QgsPointLocator",
    "QgsAuthCertInfo",
    "QgsAttributeTableMapLayerAction",
    "QgsFeatureSelectionDlg",
    "QgsAuthConfigEdit",
    "QgsAuthMethodConfig",
    "QgsVectorLayerUndoCommandAddFeature",
    "QgsAuthConfigEditor",
    "QgsCharacterSelectorDialog",
    "QgsPseudoColorShader",
    "QgsSpatialIndex",
    "QgsAbstractFeatureIterator",
    "QgsMapCanvasMap",
    "QgsShapeburstFillSymbolLayerV2",
    "QgsVectorLayerJoinBuffer",
    "QgsTextLabelFeature",
    "QgsPkiConfigBundle",
    "QgsCredentialsNone",
    "QgsPenCapStyleComboBox",
    "QgsAuthConfigSelect",
    "QgsFeatureRequest",
    "QgsExpression::NodeInOperator",
    "QgsTotalCurvatureFilter",
    "QgsGeometry",
    "QgsDummyConfigDlg",
    "QgsBrowserModel",
    "QgsRenderContext",
    "QgsSingleBandGrayRendererWidget",
    "QgsAttributeEditorElement",
    "QgsAbstractLabelProvider",
    "QgsSQLStatement::NodeInOperator",
    "QgsComposerGroupItem",
    "QgsLineSymbolLayerV2",
    "QgsSublayersDialog",
    "QgsMapOverviewCanvas",
    "QgsRasterRenderer",
    "QgsRelationReferenceFactory",
    "QgsContrastEnhancementFunction",
    "QgsMarkerSymbolLayerV2",
    "QgsGroupWMSDataDialog",
    "QgsVectorLayerInterruptionCheckerDuringCountSymbolFeatures",
    "QgsSymbolV2RenderContext",
    "QgsValueRelationSearchWidgetWrapper",
    "DualEdgeTriangulation",
    "QgsRasterFileWriter",
    "QgsGraphDirector",
    "QgsTransectSample",
    "QgsFeatureRendererV2",
    "QgsExpressionBuilderDialog",
    "QgsMapLayer",
    "QgsOptionsDialogBase",
    "QgsGraphArc",
    "QgsMapCanvasLayer",
    "QgsErrorMessage",
    "QgsAuthImportIdentityDialog",
    "QgsExpressionItem",
    "pal::LabelInfo",
    "QgsStatisticalSummary",
    "pal::PalException::ValueNotInRange",
    "QgsRendererV2AbstractMetadata",
    "QgsLegendModel",
    "QgsSQLStatement::NodeLiteral",
    "QgsEnumerationWidgetWrapper",
    "pal::PalStat",
    "QgsRuleBasedRendererV2Widget",
    "QgsOfflineEditing",
    "QgsSnapper",
    "GEOSGeomScopedPtr",
    "QgsIDWInterpolator",
    "QgsPointLocator_VisitorEdgesInRect",
    "QgsEffectStack",
    "QgsRasterTransparencyWidget",
    "QgsRasterPipe",
    "QgsSvgSelectorWidget",
    "QgsEditorWidgetFactory",
    "QgsExpressionContextScope",
    "QgsVectorLayerSimpleLabeling",
    "QgsLayerTreeEmbeddedWidgetRegistry",
    "QgsOSMTags",
    "QgsScaleUtils",
    "QgsDataCollectionItem",
    "QgsFeatureSelectionModel",
    "QgsSimpleMarkerSymbolLayerV2",
    "QgsRasterProjector",
    "QgsGradientFillSymbolLayerV2",
    "QgsAuthSslConfigDialog",
    "QgsEditorWidgetWrapper",
    "QgsDrawSourceWidget",
    "QgsOWSSourceSelect",
    "QgsException",
    "QgsAttributeTableDelegate",
    "QgsVectorLayerDiagramProvider",
    "QgsVectorLayerUndoCommandAddAttribute",
    "QgsDialog",
    "QgsAuthSslImportDialog",
    "QgsVectorColorRampV2",
    "QgsCustomLayerOrderWidget",
    "QgsStyleV2GroupSelectionDialog",
    "QgsAdvancedDigitizingCanvasItem",
    "QgsComposerItemGroup",
    "pal::CostCalculator",
    "QgsAuthCertTrustPolicyComboBox",
    "QgsExtentGroupBox",
    "QgsValueRelationConfigDlg",
    "QgsVectorLayerImport",
    "QgsPenJoinStyleComboBox",
    "pal::InternalException::NoLabelPosition",
    "QgsDateTimeStatisticalSummary",
    "QgsNewVectorLayerDialog",
    "QgsLinearMinMaxEnhancement",
    "QgsComposerModel",
    "QgsSymbolLayerV2Utils",
    "QgsConstWkbPtr",
    "QgsLongLongValidator",
    "QgsSimpleFillSymbolLayerV2Widget",
    "QgsCptCityArchive",
    "QgsComposerArrow",
    "QgsAttributeFormLegacyInterface",
    "QgsProjectItem",
    "QgsMapToolEmitPoint",
    "QgsClassificationWidgetWrapperFactory",
    "QgsCollapsibleGroupBox",
    "Qgs25DRendererWidget",
    "QgsExpression::NodeColumnRef",
    "QgsComposition",
    "QgsMapCanvas",
    "QgsLayerTreeEmbeddedWidgetProvider",
    "QgsPaintEffect",
    "QgsHiddenWidgetFactory",
    "QgsLinePatternFillSymbolLayerWidget",
    "QgsComposerLegendItem",
    "QgsQtLocationConnection",
    "QgsUnitSelectionWidget",
    "QgsMapTip",
    "QgsGraphBuilder",
    "QgsMarkerSymbolV2",
    "QgsDiagramRendererV2",
    "QgsExpression::NodeLiteral",
    "QgsNewGeoPackageLayerDialog",
    "pal::InternalException::UnknownGeometry",
    "QgsVectorColorBrewerColorRampV2",
    "QgsProperty",
    "QgsDoubleBoxScaleBarStyle",
    "QgsPanelWidgetWrapper",
    "QgsBusyIndicatorDialog",
    "QgsSymbolV2SelectorWidget",
    "QgsPieDiagram",
    "QgsInternalGeometryEngine",
    "QgsMasterPasswordResetDialog",
    "QgsVectorFileWriter::StringOption",
    "QgsComposerItem",
    "QgsSvgAnnotationItem",
    "QgsOSMElement",
    "QgsSvgCacheEntry",
    "QgsCptCityBrowserModel",
    "QgsPointLocator_VisitorNearestVertex",
    "QgsCheckboxWidgetWrapper",
    "QgsAuthServersEditor",
    "QgsGradientFillSymbolLayerV2Widget",
    "QgsNetworkDiskCache",
    "QgsFillSymbolLayerV2",
    "QgsRendererRulePropsDialog",
    "QgsSymbolLevelsV2Dialog",
    "QWebPage",
    "QgsPointLocator_VisitorNearestEdge",
    "QgsStringStatisticalSummary",
    "QgsLabelComponent",
    "QgsDateTimeEditFactory",
    "CharacterWidget",
    "QgsAdvancedDigitizingDockWidget",
    "QgsColorEffectWidget",
    "QgsCsException",
    "QgsMapLayerStyleManager",
    "QgsZipItem",
    "QgsComposerMultiFrameCommand",
    "QgsAttributeEditorField",
    "QgsMessageOutput",
    "QgsSQLStatement::NodeCast",
    "QgsCoordinateReferenceSystem",
    "QgsLayerTreeModelLegendNode",
    "QgsScaleVisibilityDialog",
    "QgsTransactionGroup",
    "QgsDistanceArea",
    "QgsLayerTreeGroup",
    "QgsMapToolPan",
    "QgsVectorLayerFeatureIterator",
    "QgsDxfPaintEngine",
    "QgsSvgMarkerSymbolLayerV2",
    "QgsCategorizedSymbolRendererV2Widget",
    "QgsAuthConfigSslServer",
    "QgsBrightnessContrastFilter",
    "QgsMultiRenderChecker",
    "QgsLabelSorter",
    "QgsComposerShape",
    "QgsLayerItem",
    "QgsAuthCertEditors",
    "QgsMapRendererParallelJob",
    "QgsRasterCalculator",
    "QgsStyleV2",
    "QgsLegacyHelpers",
    "QgsRuleBasedRendererV2",
    "QgsDrawSourceEffect",
    "QgsLayerTreeLayer",
    "pal::PalException::NotImplemented",
    "QgsDxfLabelProvider",
    "QgsCptCitySelectionItem",
    "QgsRendererCategoryV2",
    "QgsDataItem",
    "QgsComposerAttributeTableColumnModelV2",
    "QgsSQLStatement::NodeSelect",
    "QgsSymbolsListWidget",
    "QgsGraduatedSymbolRendererV2",
    "QgsRasterPyramid",
    "QgsAnimatedIcon",
    "QgsDataItemProvider",
    "QgsWebViewWidgetWrapper",
    "QgsScaleRangeWidget",
    "QgsWebViewWidgetFactory",
    "QgsEncodingFileDialog",
    "QgsProviderCountCalcEvent",
    "QgsDxfPaintDevice",
    "QgsRasterInterface",
    "QgsExternalResourceWidgetFactory",
    "QgsAuthIdentitiesEditor",
    "QgsValueMapConfigDlg",
    "QgsAbstractFeatureIteratorFromSource",
    "QgsDirectoryItem",
    "QgsRelationEditorWidget",
    "QgsColorBrewerPalette",
    "QgsTextDiagram",
    "QgsRuleBasedRendererV2Model",
    "QgsExpression::NodeFunction",
    "QgsAuthCertInfoDialog",
    "QgsColorWidgetWrapper",
    "QgsPenStyleComboBox",
    "QgsNewHttpConnection",
    "QgsExpression::NodeCondition",
    "QgsValueMapWidgetWrapper",
    "QgsZonalStatistics",
    "QgsRasterRange",
    "QgsSymbolV2",
    "QgsLegendInterface",
    "QgsTopologyPreservingSimplifier",
    "QgsInterpolator",
    "QgsVirtualLayerDefinition::SourceLayer",
    "QgsScaleComboBox",
    "QgsPhotoConfigDlg",
    "QgsMessageLogConsole",
    "QgsMessageOutputConsole",
    "QgsImageOperation",
    "QgsRasterIdentifyResult",
    "QgsVisibilityPresetCollection::PresetRecord",
    "QgsRunProcess",
    "QgsRasterIterator",
    "QgsExpression::StaticFunction",
    "QgsProjectionSelector",
    "QgsProjectVersion",
    "QgsFieldValidator",
    "QgsRasterFillSymbolLayerWidget",
    "QgsUserInputDockWidget",
    "QgsLabelAttributes",
    "QgsAuthCertUtils",
    "QgsSymbolLayerV2Registry",
    "QgsSlider",
    "QgsColorSchemeList",
    "QgsLayerTreeModel",
    "QgsCategorizedSymbolRendererV2",
    "QgsLinearlyInterpolatedDiagramRenderer",
    "QgsOWSConnection",
    "QgsGenericProjectionSelector",
    "QgsDataDefinedButton",
    "QgsColorSchemeModel",
    "QgsBlurWidget",
    "QgsSQLStatement::NodeColumnSorted",
    "QgsNewMemoryLayerDialog",
    "QgsFileDropEdit",
    "QgsRelationReferenceConfigDlg",
    "QgsComposerMergeCommand",
    "QgsApplication",
    "QgsDateTimeEdit",
    "QgsDxfRuleBasedLabelProvider",
    "Line3D",
    "QgsAuthGuiUtils",
    "QgsVectorLayerRendererInterruptionChecker",
    "pal::Problem",
    "QgsComposerStyleItem",
    "QgsValueMapSearchWidgetWrapper",
    "QgsPalettedRasterRenderer",
    "QgsArcProperter",
    "QgsWkbException",
    "QgsRuntimeProfiler",
    "QgsSvgSelectorGroupsModel",
    "QgsSingleBandGrayRenderer",
    "QgsCubicRasterResampler",
    "QgsEllipseSymbolLayerV2Widget",
    "QgsField",
    "QgsCheckBoxConfigDlg",
    "ParametricLine",
    "QgsDiagram",
    "QgsCredentialsConsole",
    "QgsLogger",
    "QgsEllipseSymbolLayerV2",
    "QgsMapServiceException",
    "pal::Feats",
    "QgsArrowSymbolLayerWidget",
    "QgsVectorLayerEditBuffer",
    "QgsEditFormConfig",
    "QgsEnumerationWidgetFactory",
    "QgsGraphVertex",
    "QgsVector",
    "QgsComposerTable",
    "QgsDataDefinedWidthDialog",
    "QgsRectangle",
    "QgsSQLStatement::Node",
    "QgsTransaction",
    "QgsPhotoWidgetWrapper",
    "QgsComposerTableColumn",
    "QgsMarkerLineSymbolLayerV2Widget",
    "QgsHttpTransaction",
    "QgsImageFillSymbolLayer",
    "QgsBilinearRasterResampler",
    "QgsNetworkReplyParser",
    "QgsRenderChecker",
    "QgsFeatureIterator",
    "pal::LabelPosition",
    "QgsExpressionSelectionDialog",
    "QgsAuthImportCertDialog",
    "QgsSymbolLayerV2Widget",
    "QgsColorDialog",
    "QgsLabelPosition",
    "QgsDiagramLayerSettings",
    "QgsAnnotationItem",
    "QgsStyleV2ExportImportDialog",
    "QgsHeatmapRendererWidget",
    "QgsLabelCandidate",
    "QgsLegendSettings",
    "QgsColorRampComboBox",
    "QgisPlugin",
    "QgsRasterResampleFilter",
    "QgsMapLayerStyle",
    "QgsCoordinateTransform",
    "QgsSizeScaleWidget",
    "QgsPluginLayerType",
    "QgsClipper",
    "pal::GeomFunction",
    "QgsMapToolZoom",
    "QgsLUDialog",
    "QgsScopeLogger",
    "QgsMapMouseEvent",
    "QgsMapToolEdit",
    "QgsTicksScaleBarStyle",
    "QgsFavouritesItem",
    "QgsMapRendererQImageJob",
    "QgsGraphAnalyzer",
    "QgsMessageLog",
    "QgsExpressionContext",
    "QgsSingleSymbolRendererV2",
    "QgsMapRenderer",
    "QgsPointLocator_Stream",
    "QgsGroupBoxCollapseButton",
    "QgsCredentials",
    "QgsSnappingUtils",
    "QgsDistanceArcProperter",
    "QgsVectorLayerEditUtils",
    "QgsHistogramDiagram",
    "QgsVectorFileWriter",
    "QgsDateTimeEditConfig",
    "QgsUuidWidgetFactory",
    "QgsMapRendererSequentialJob",
    "QgsLinePatternFillSymbolLayer",
    "QgsPointSample",
    "QgsObjectCustomProperties",
    "QgsRelationReferenceWidgetWrapper",
    "QgsMapToolAdvancedDigitizing",
    "QgsValueRelationWidgetFactory",
    "QgsGraduatedSymbolRendererV2Widget",
    "QgsComposerItemCommand",
    "QgsBrowserWatcher",
    "pal::PalException",
    "QgsIndexedFeature",
    "QgsPropertyKey",
    "QgsMessageViewer",
    "QgsShadowEffectWidget",
    "QgsEditorWidgetRegistry",
    "QgsColorSwatchGrid",
    "QgsDataDefinedValueDialog",
    "QgsGmlStreamingParser::LayerProperties",
    "QgsSmartGroupCondition",
    "QgsAuthEditorWidgets",
    "QgsFileWidget",
    "QgsFeatureModel",
    "QgsExpressionItemSearchProxy",
    "QgsRuleBasedLabeling",
    "QgsRendererV2Metadata",
    "QgsExpressionBuilderWidget",
    "pal::Layer",
    "QgsSingleBandColorDataRenderer",
    "QgsMapCanvasItem",
    "QgsGmlFeatureClass",
    "QgsVectorFieldSymbolLayer",
    "HalfEdge",
    "QgsAuthMethodRegistry",
    "QgsGraph",
    "QgsSingleBoxScaleBarStyle",
    "pal::InternalException",
    "QgsPalLayerSettings",
    "TriangleInterpolator",
    "QgsCptCityColorRampItem",
    "QgsPaintEngineHack",
    "QgsLineVectorLayerDirector",
    "QgsSVGFillSymbolLayerWidget",
    "QgsGradientStop",
    "QgsDualView",
    "QgsSpatialIndexCopyVisitor",
    "QgsVectorGradientColorRampV2",
    "QgsNMEAConnection",
    "QgsAttributeDialog",
    "QgsProjectBadLayerGuiHandler",
    "QgsComposerMouseHandles",
    "QgsAuthCertManager",
    "QgsGeometryCache",
    "QgsAccessControlFilter",
    "QgsVectorDataProvider",
    "QgsSQLStatement::RecursiveVisitor",
    "QgsAuthTrustedCAsDialog",
    "pal::FeaturePart",
    "QgsError",
    "QgsComposerTableSortColumnsProxyModel",
    "QgsRasterHistogramWidget",
    "QgsOSMNodeIterator",
    "pal::PalException::LayerExists",
    "QgsMessageBar",
    "QgsUuidWidgetWrapper",
    "QgsExpression::Node",
    "QgsUniqueValuesWidgetWrapper",
    "pal::InternalException::Empty",
    "QgisVisitor",
    "QgsVectorLayerUndoCommandChangeAttribute",
    "QgsFormAnnotationItem",
    "QgsConnectionPool",
    "QgsGPSConnectionRegistry",
    "QgsExpression::NodeBinaryOperator",
    "QgsAttributeEditor",
    "QgsSingleBandPseudoColorRendererWidget",
    "QgsVectorLayerUndoCommandChangeGeometry",
    "QgsGenericFeatureSelectionManager",
    "QgsExternalResourceConfigDlg",
    "QgsWkbPtr",
    "QgsSymbolLayerV2Metadata",
    "QgsDiagramInterpolationSettings",
    "QgsRasterBandStats",
    "QgsSQLStatement::NodeBinaryOperator",
    "QgsPanelWidget",
    "QgsRasterResampler",
    "QgsRelationManager",
    "QgsGeometry::Error",
    "QgsMessageLogViewer",
    "QgsVectorLayer",
    "QgsSpatialIndexData",
    "QgsComposerRuler",
    "QgsPointPatternFillSymbolLayerWidget",
    "QgsCptCityDataItem",
    "QgsRandomColorsV2",
    "QgsGeometryAnalyzer",
    "QgsVectorRandomColorRampV2",
    "QgsComposerMultiFrame",
    "QgsValueMapWidgetFactory",
    "QgsXmlUtils",
    "QgsAlignRaster",
    "QgsVectorFileWriter::BoolOption",
    "QgsPalLabeling",
    "QgsRendererV2PropertiesDialog",
    "QgsMessageBarItem",
    "QgsRasterMinMaxWidget",
    "QgsServerFilter",
    "QgsVectorRandomColorRampV2Dialog",
    "QgsAttributeTableAction",
    "QgsMarkerLineSymbolLayerV2",
    "QgsHtmlAnnotationItem",
    "QgsVectorLayerFeatureSource",
    "QgsAtlasComposition",
    "QgsSQLComposerDialog::TableSelectedCallback",
    "QgsConnectionPoolGroup",
    "QgisInterface",
    "QgsFillSymbolV2",
    "QgsPointPatternFillSymbolLayer",
    "QgsComposerMap",
    "QgsSourceSelectItemDelegate",
    "LinTriangleInterpolator",
    "QgsDefaultSearchWidgetWrapper",
    "QgsAttributes",
    "QgsSQLStatementCollectTableNames",
    "QgsComposerSymbolV2Item",
    "QgsLayerDefinition::DependencySorter",
    "QWebFrame",
    "QgsRaster",
    "QgsDial",
    "QgsRubberBand",
    "QgsConditionalLayerStyles",
    "QgsCacheIndexFeatureId",
    "QgsCptCityColorRampV2Dialog",
    "QgsFilterLineEdit",
    "QgsNetworkContentFetcher",
    "QgsComposerPicture",
    "QgsExpression::WhenThen",
    "QgsSimpleLineSymbolLayerV2",
    "QgsClipToMinMaxEnhancement",
    "QgsAddRemoveMultiFrameCommand",
    "QgsFields",
    "QgsGeometryGeneratorSymbolLayerWidget",
    "QgsMapCanvasSnapper",
    "pal::PalException::UnknownLayer",
    "QgsAttributeTableModel",
    "QgsMapLayerRenderer",
    "QgsDetailedItemData",
    "QgsMapTool",
    "QgsVectorLayerUndoCommand",
    "QgsComposerMultiFrameMergeCommand",
    "QgsRequestHandler",
    "QgsAddRemoveItemCommand",
    "QgsAuthManager",
    "QgsGroupUngroupItemsCommand",
    "QgsFileNameWidgetFactory",
    "QgsPaperItem",
    "QgsSQLStatement::NodeList",
    "QgsSvgCache",
    "QgsDatumTransformDialog",
    "QgsFieldExpressionWidget",
    "QgsCollapsibleGroupBoxBasic",
    "QgsHiddenWidgetWrapper",
    "QgsCredentialDialog",
    "QgsScaleCalculator",
    "QgsVectorFileWriter::HiddenOption",
    "QgsVectorLayerEditPassthrough",
    "QgsSymbolV2LevelItem",
    "QgsVertexMarker",
    "QgsRasterFormatSaveOptionsWidget",
    "QgsValueRelationWidgetWrapper",
    "QgsComposerAttributeTableCompare",
    "QgsRuggednessFilter",
    "QgsTrackedVectorLayerTools",
    "QgsLayerTreeMapCanvasBridge",
    "QgsMapToolCapture",
    "QgsSearchWidgetWrapper",
    "QgsDetailedItemDelegate",
    "QgsRasterMatrix",
    "QgsGPSConnection",
    "QgsMapCanvasTracer",
    "QgsComposerAttributeTable",
    "QgsSQLStatement::NodeSelectedColumn",
    "QgsGeos",
    "QgsRelationWidgetWrapper",
    "QgsColorButton",
    "QgsSvgSelectorListModel",
    "QgsGmlSchema",
    "QgsErrorDialog",
    "QgsComposerTableSortColumnsProxyModelV2",
    "QgsSourceSelectDialog",
    "QgsMapToPixel",
    "Vector3D",
    "QgsGeometryGeneratorSymbolLayerV2",
    "QgsAttributeEditorContainer",
    "pal::PriorityQueue",
    "QgsComposerLegendStyle",
    "QgsRasterDataProvider",
    "QgsProjectBadLayerDefaultHandler",
    "QgsPropertyValue",
    "QgsVectorFileWriter::IntOption",
    "QgsRasterBlock",
    "QgsRasterNuller",
    "QgsPythonRunner",
    "QgsSQLStatement::NodeFunction",
    "QgsSQLStatement::NodeUnaryOperator",
    "QgsSearchQueryBuilder",
    "QgsOSMWayIterator",
    "QgsVirtualLayerDefinitionUtils",
    "QgsAttributeForm",
    "QgsVirtualLayerDefinition",
    "QgsAspectFilter",
    "QgsManageConnectionsDialog",
    "QgsRasterTransparency",
    "QgsCapabilitiesCache",
    "Qgs25DRenderer",
    "QgsMapCanvasRendererSync",
    "QgsRendererRasterPropertiesWidget",
    "QgsVectorLayerCache",
    "QgsAuthConfigUriEdit",
    "QgsProjectFileTransform",
    "QgsFontUtils",
    "QgsLayerTreeRegistryBridge",
    "QgsPreviewEffect",
    "QgsRasterHistogram",
    "QgsComposerEffect",
    "QgsRuleBasedLabelProvider",
    "QgsPoint",
    "QgsRangeConfigDlg",
    "QgsShapeburstFillSymbolLayerV2Widget",
    "QgsSimpleFillSymbolLayerV2",
    "QgsVectorFieldSymbolLayerWidget",
    "QgsClassificationWidgetWrapper",
    "CloughTocherInterpolator",
    "QgsUniqueValuesConfigDlg",
    "QgsLabelingEngineV2",
    "QgsMimeDataUtils",
    "QgsTransformWidget",
    "QgsExpression::NodeUnaryOperator",
    "QgsStyleV2ManagerDialog",
    "QgsAttributeTableView",
    "QgsAttributeFormInterface",
    "QgsFeatureStore",
    "QgsExternalResourceWidgetWrapper",
    "TriDecorator",
    "QgsAuthMethodEdit",
    "QgsRelation::FieldPair",
    "QgsTINInterpolator",
    "QgsScaleWidget",
    "QgsDataItemProviderFromPlugin",
    "QgsExpression::Visitor",
    "QgsGeometryRubberBand",
    "QgsComposerAttributeTableV2",
    "QgsCentroidFillSymbolLayerV2Widget",
    "QgsRendererV2Widget",
    "QgsComposerLabel",
    "QgsRuleBasedRendererV2::Rule",
    "QgsMapLayerRegistry",
    "QgsMapRendererCache",
    "QgsDataSourceURI",
    "QgsVectorLayerSelectionManager",
    "QgsPaperGrid",
    "QgsDashSpaceDialog",
    "QgsPointDisplacementRenderer",
    "QgsSmartGroupEditorDialog",
    "QgsMapToolTouch",
    "QgsComposerRasterSymbolItem",
    "QgsComposerAttributeTableColumnModel",
    "QgsGml",
    "QgsAuthAuthoritiesEditor",
    "QgsHueSaturationFilter",
    "QgsRelationReferenceWidget",
    "QWebSettings",
    "QgsPointLocator_DumpTree",
    "QgsProviderRegistry",
    "QgsProviderMetadata",
    "QgsApplyDialog",
    "QgsRuleBasedLabeling::Rule",
    "QgsActionMenu",
    "QgsAuthMethod",
    "QgsDartMeasurement"]
