/***************************************************************************
                          shader.h  -  description
                             -------------------
    begin                : Don Apr 27 2006
    copyright            : (C) 2006 by Krippel Harald
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SHADER_H
#define SHADER_H

/**
	@author Harald Krippel <harald@the-develop.net>
*/

  
class shader {
public: 
   shader();

   void initShaders(const char * strVertex,const char * strFragment);
   void compile();
   // This releases our memory for our shader
    ~shader();

   // This returns an ID for a variable in our shader
   GLint GetVariable(char * strVariable);

   // Below are functions to set an integer or a set of floats
   void SetInt(GLint variable, int newValue);
   void SetFloat(GLint variable, float newValue);
   void SetFloat2(GLint variable, float v0, float v1);
   void SetFloat3(GLint variable, float v0, float v1, float v2);
   void SetFloat4(GLint variable, float v0, float v1, float v2, float v3);

   // Error handling glslang
   char * GetInfoLog(GLuint cc);

   // These 2 functions turn on and off our shader
   void TurnOn();
   void TurnOff();
   void Release(void);
   char * FileRead(const char *fn);

protected:

GLuint v,f,p;
int glslok;
char VerFileName[256];
char FraFileName[256];

};

#endif
