/***************************************************************************
                          barrier.cpp  -  description
                             -------------------
    begin                : Mit Sep 25 13:11:41 CEST 2002
    copyright            : (C) 2002 by Harald Krippel
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <barrier.hpp>

Barrier::Barrier(void)
{
  objtrans=NULL;
  boxobjtrans = NULL;
}

void Barrier::createOdeBody(dSpaceID odspace)
{
   odbox = dCreateBox (odspace,1,1,1);
   dGeomSetPosition(odbox,0,0,0);
}

void Barrier::update()
{
  dVector3 dxyz; 
  // positon Barrier from ode
  if(objtrans != NULL){
      dGeomBoxGetLengths (odbox, dxyz);
      setTransform(objtrans,dGeomGetPosition(odbox),dGeomGetRotation(odbox),dxyz);
  }
}

void Barrier::setTransform (ssgTransform *objtrans, const dReal barpos[3], const dReal R[12],dVector3 dxyz)
{
  sgMat4 m;
  
  m[0][0] = R[0] ;
  m[0][1] = R[4] ;
  m[0][2] = R[8] ;
  m[0][3] = SG_ZERO ; //x

  m[1][0] = R[1] ;
  m[1][1] = R[5] ;
  m[1][2] = R[9] ;
  m[1][3] = SG_ZERO ;  // y

  m[2][0] = R[2] ;
  m[2][1] = R[6] ;
  m[2][2] = R[10] ;
  m[2][3] = SG_ZERO ;  // z

  m[3][0] =  barpos [0] ;
  m[3][1] =  barpos [1] ;
  m[3][2] =  barpos [2] ;
  m[3][3] =  SG_ONE ;

  sgScaleVec3(m[0], dxyz[0]);
  sgScaleVec3(m[1], dxyz[1]);
  sgScaleVec3(m[2], dxyz[2]);
                  
  objtrans->setTransform(m);
  sgSetCoord  ( &pos, m ) ;
}

void Barrier::getPosition ( sgCoord  *bodypos )
{
   sgCopyCoord ( bodypos, &pos ) ;
}

void Barrier::setPosition ()
{
  dMatrix3 odR;

  dGeomSetPosition (odbox,pos.xyz[0],pos.xyz[1],pos.xyz[2]);
  dRFromEulerAngles(odR,-pos.hpr[1] * SG_DEGREES_TO_RADIANS
                      ,-pos.hpr[2] * SG_DEGREES_TO_RADIANS
                      ,-pos.hpr[0] * SG_DEGREES_TO_RADIANS);
  dGeomSetRotation (odbox,odR);
}

void Barrier::setObjtrans (ssgTransform *trans)
{
  objtrans = trans;
}

void Barrier::setRotation (float h, float p, float r)
{

  dMatrix3 odR;
  sgMat4 oglM;
  const dReal *odeM;
  sgMat4 mh ;

  sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
  odeM = dGeomGetRotation(odbox);

oglM[0][0]  = odeM[0];
oglM[0][1]  = odeM[4];
oglM[0][2]  = odeM[8];
oglM[0][3]  = 0;
oglM[1][0]  = odeM[1];
oglM[1][1]  = odeM[5];
oglM[1][2]  = odeM[9];
oglM[1][3]  = 0;
oglM[2][0]  = odeM[2];
oglM[2][1]  = odeM[6];
oglM[2][2] = odeM[10];
oglM[2][3] = 0;
oglM[3][0] = 0;
oglM[3][1] = 0;
oglM[3][2] = 0;
oglM[3][3] = 1;

  sgPreMultMat4  ( oglM, mh ) ;

  odR[0]=oglM[0][0];
  odR[4]=oglM[0][1];
  odR[8]=oglM[0][2];

  odR[1]=oglM[1][0];
  odR[5]=oglM[1][1];
  odR[9]=oglM[1][2];

  odR[2]=oglM[2][0];
  odR[6]=oglM[2][1];
  odR[10]=oglM[2][2];

  dGeomSetRotation (odbox,odR);
}

Barrier::~Barrier()
{

}
