/***************************************************************************
                          rlibraryitem.h  -  description
                             -------------------
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Andrew Mustun
    email                : andrew@qcad.org
 ***************************************************************************/


#ifndef RLIBRARYITEM_H
#define RLIBRARYITEM_H

#include "rwidget.h"

class RGraphic;
class QLabel;
class QFileInfo;

/**A single Item in the library browser - graphic and label.
  *@author Andrew Mustun
  */

class RLibraryItem : public RWidget  {
  Q_OBJECT
public: 
	RLibraryItem(QWidget *_parent=0, const char *_name=0);
	~RLibraryItem();
	
	void resizeChildren();
	
	void setFile( QFileInfo _file );
	void setActive( bool _on );
	bool isActive();
	
	RGraphic* getGraphic() { return graphic; }
	
	QString getReferenceValue( QChar _code );
	
protected:
  virtual void resizeEvent(QResizeEvent* _ev);	

signals:
  void activated(RLibraryItem*);

private slots:
  void slotActivated() { emit activated(this); }
	
private:
  RGraphic* graphic;
  QLabel* label;
};

#endif








