/***************************************************************************
                          rinitialdialog.cpp  -  description
                             -------------------
    begin                : Tue Nov 23 1999
    copyright            : (C) 1999 by Andrew Mustun
    email                : andrew@qcad.org
 ***************************************************************************/

#include "rinitialdialog.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qwidget.h>

#include "rappwin.h"
#include "rcombobox.h"
#include "rconfig.h"
#include "rprgdef.h"
#include "rstring.h"

#include "xpm/init.xpm"


/*! \class RInitialDialog
    \author Andrew Mustun
    \brief Provides the initial dialog called at the very first startup.
*/


/** Constructor
    Same parameters as QDialog
*/
RInitialDialog::RInitialDialog(QWidget * _parent, const char* _name, bool _modal, WFlags _f)
 : QDialog( _parent, _name, _modal, _f )
{
  setFixedSize(350, 250);

  setCaption( QString(DEF_APPNAME) + " - " + "Initial Setup Dialog" );

  QGridLayout *gl;
  QLabel *lab;
  RComboBox *cb;

  // Layout:
  gl = new QGridLayout( this, 4, 3, 12 );
  gl->setRowStretch( 0, 8 );
  gl->setRowStretch( 1, 3 );
  gl->setRowStretch( 2, 3 );
  gl->setRowStretch( 3, 3 );


  lab = new QLabel( this );
  lab->setPixmap( QPixmap( init_xpm ) );
  gl->addMultiCellWidget( lab, 0,3, 0,0 );

  // Label:
  lab = new QLabel( QString("Welcome to ") + DEF_APPNAME + "!\n"
                    "Please choose your language "
                    "and the unit you wish to use "
                    "for new drawings. You can "
                    "change these settings in the "
                    "options dialog of " + DEF_APPNAME +
                    " at any time later.",
                    this );
  lab->setAlignment( AlignLeft|WordBreak );
  gl->addMultiCellWidget( lab, 0,0, 1,2 );


  // Language:
  lab = new QLabel( "Language", this );
  gl->addWidget( lab, 1,1, AlignRight|AlignVCenter );
  cb = new RComboBox( false, this );
  for(int i=0; i<RCONFIG->getLanguageNum(); ++i) {
    cb->insertItem( RCONFIG->getLanguage(i) );
  }
  cb->setEditText( RCONFIG->getLanguageName( RCONFIG->getSetting("Language:Language") ) );
  gl->addWidget( cb, 1,2, AlignLeft|AlignVCenter );
  cbLanguage = cb;


  // Unit:
  lab = new QLabel( "Unit", this );
  gl->addWidget( lab, 2,1, AlignRight|AlignVCenter );
  cb = new RComboBox( false, this );
  cb->fillInUnits();
  cb->setEditText( RCONFIG->getSetting("CAD:Unit") );
  gl->addWidget( cb, 2,2, AlignLeft|AlignVCenter );
  cbUnit = cb;

  // Buttons:
  QPushButton *ok;

  ok = new QPushButton( "Ok", this );
  ok->setGeometry( width()-80,height()-34, 70,26 );
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );
}


/*! Destructor
*/
RInitialDialog::~RInitialDialog()
{
}



/*! Slot accept.
*/
void
RInitialDialog::accept()
{
  Unit unit = mtStringToUnit( cbUnit->currentText() );
  bool lMetric = mtIsUnitMetric( unit );

  // Language:
  //
  RCONFIG->addSetting( "Language:Language",
                       RCONFIG->getLanguageSign(cbLanguage->currentText()) );

  RCONFIG->addSetting( "Application:Charset",
                       mtCharsetToString( RCONFIG->getLanguageCharset( cbLanguage->currentText() ) ) );

  // CAD:
  //
  RCONFIG->addSetting( "CAD:Unit",
                       cbUnit->currentText() );
  RCONFIG->addSetting( "CAD:DimensionUnit",
                       cbUnit->currentText() );
  RCONFIG->addSetting( "CAD:DimensionFormat",
                       (lMetric ? "Decimal" : "Fractional") );
  RCONFIG->addSetting( "CAD:DimensionExactness",
                       (lMetric ? "0.01" : "1/128") );
  RCONFIG->addSetting( "CAD:DimensionShowUnits",
                       (lMetric ? "0" : "1") );
  RCONFIG->addSetting( "CAD:DimensionTextHeight",
                       ((unit==Inch) ? "1/5" : "5" ) );
  RCONFIG->addSetting( "CAD:DimensionArrowLength",
                       ((unit==Inch) ? "1/8" : "3" ) );
  RCONFIG->addSetting( "CAD:DimensionOverLength",
                       ((unit==Inch) ? "1/12" : "2" ) );
  RCONFIG->addSetting( "CAD:DimensionUnderLength",
                       ((unit==Inch) ? "1/12" : "2" ) );

  RCONFIG->addSetting( "CAD:GridFormat",
                       (lMetric ? "Decimal" : "Fractional") );
  RCONFIG->addSetting( "CAD:MinGridX",
                       (lMetric ? "0.001" : "1/1024") );
  RCONFIG->addSetting( "CAD:MinGridY",
                       (lMetric ? "0.001" : "1/1024") );

  RCONFIG->addSetting( "CAD:PageFormat",
                       (lMetric ? "A4" : "Letter") );
  RCONFIG->addSetting( "CAD:PageSizeX",
                       (lMetric ? mtGetPageWidthMM(A4) / mtGetMM( 1.0, unit ) : mtGetPageWidthMM(Letter) / mtGetMM( 1.0, unit )) );
  RCONFIG->addSetting( "CAD:PageSizeY",
                       (lMetric ? mtGetPageHeightMM(A4) / mtGetMM( 1.0, unit ) : mtGetPageHeightMM(Letter) / mtGetMM( 1.0, unit )) );

  QDialog::accept();
}


// EOF






