/***************************************************************************
                          rcombobox.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rcombobox.cpp 1998/09/19 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rcombobox.h"

#include "qdir.h"
#include "qpixmap.h"

#include "rfile.h"
#include "rfonts.h"
#include "rgraphic.h"
#include "rlayer.h"
#include "rlog.h"
#include "rstring.h"

#include "xpm/color00.xpm"
#include "xpm/color01.xpm"
#include "xpm/color02.xpm"
#include "xpm/color03.xpm"
#include "xpm/color04.xpm"
#include "xpm/color05.xpm"
#include "xpm/color06.xpm"
#include "xpm/color07.xpm"
#include "xpm/color08.xpm"
#include "xpm/color09.xpm"
#include "xpm/color10.xpm"
#include "xpm/color11.xpm"
#include "xpm/color12.xpm"
#include "xpm/color13.xpm"
#include "xpm/color14.xpm"
#include "xpm/color15.xpm"

#include "xpm/width00.xpm"
#include "xpm/width01.xpm"
#include "xpm/width02.xpm"
#include "xpm/width03.xpm"
#include "xpm/width04.xpm"
#include "xpm/width05.xpm"
#include "xpm/width06.xpm"
#include "xpm/width07.xpm"
#include "xpm/width08.xpm"

#include "xpm/style00.xpm"
#include "xpm/style01.xpm"
#include "xpm/style02.xpm"
#include "xpm/style03.xpm"
#include "xpm/style04.xpm"


// Constructor:
//
RComboBox::RComboBox(QWidget* _parent, const char* _name)
:QComboBox(_parent, _name)
{
  readWrite=true;
}


// Constructor (read/write?)
//
RComboBox::RComboBox(bool _rw, QWidget* _parent, const char* _name)
:QComboBox(_rw, _parent, _name)
{
  readWrite=_rw;
}



// Destructor:
//
RComboBox::~RComboBox()
{
}



// Set the edit text 
//   (works even for non-editable comboboxes)
//
void 
RComboBox::setEditText(const QString& _txt)
{
  QComboBox::setEditText(_txt);

  // Combo box isn't editable / 
  //   set the item from list if available:
  //
  if( currentText() != _txt ) {
    int i;
    for(i=0; i<count(); ++i) {
      if( text(i) == _txt ) {
        setCurrentItem(i);
      }
    }
  }
}


// Set a double value as text
//
void
RComboBox::setValue( double _val )
{
  QString str;
  str.setNum( _val, 'g', 6 );
  setEditText( str );
}



// Set an int value as text
//
void
RComboBox::setValue( int _val )
{
  QString str;
  str.setNum( _val );
  setEditText( str );
}


// Set the edit text from parameter ($e can be $e (Extension))
//   (works even for non-editable comboboxes)
//
void 
RComboBox::setParameter(const char* _txt)
{
  if(_txt) {
    QComboBox::setEditText(QString(_txt));

    // Combo box isn't editable / 
    //   set the item from list if available:
    //
    if(strncmp(currentText().latin1(), _txt, strlen(_txt))) {
      int i;
      for(i=0; i<count(); ++i) {
        if(!strncmp(text(i).latin1(), _txt, strlen(_txt))) {
          setCurrentItem(i);
        }
        else {
          RLOG("\n");
          RLOG(text(i).latin1());
          RLOG("  is not  ");
          RLOG(_txt);
        }
      }
    }
  }
}



// Insert item only if it's not already 
//   available in the list:
//
void 
RComboBox::insertItem(const QString& _t, int _index)
{
  if(findItem(_t)==-1) {
    QString curText=currentText();
    QComboBox::insertItem(_t, _index);
    setEditText( curText );
  }
}


// Find item _t in the list:
//
//   return: index of item or -1:
//
int  
RComboBox::findItem(const QString& _t)
{
  int ret=-1;
  int i;
  
  for(i=0; i<count(); ++i) {
    if( text(i) == _t ) {
      ret=i;
      break;
    }
  }

  return ret;
}



// Remove item by its name
//
void 
RComboBox::removeItem(const QString& _t)
{
  if(_t) {
    int i;
  
    for(i=0; i<count(); ++i) {
      if( text(i) == _t ) {
        removeItem(i);
      }
    }
  }
}



// Fill in the machine generators found 
//   in directory /machine
//
bool 
RComboBox::fillInMachineGenerators(bool _clear)
{
  bool ret=false;
  RLOG("\nFill In Machine Generators");

  QString machPath;     // Path of machine gen. files
  QString machFilter;   // Filter for searching mach. gen. 
                        //   files (C:\\...*.cxm)
  // Reset:
  //
  if(_clear) clear();

  for( int p=1; p<=3; ++p ) {
    machPath = fileSearchSubdir("machines", p);

    if( QFileInfo(machPath).exists() ) {
      machFilter = "*.cxm";

      // Read *.cxm files from machines diretory
      //   fill the machines in the combo box:
      //
      QDir dir(machPath, machFilter);
      dir.setFilter(QDir::Files);
      dir.setSorting(QDir::Name);

      QStringList machList = dir.entryList();
      QStringList::ConstIterator machIterator;
      QFileInfo machFileInfo;

      if( machList.count()>0 ) {
        for( machIterator=machList.begin(); machIterator!=machList.end(); ++machIterator ) {
          machFileInfo.setFile( machPath+"/"+(*machIterator) );
          insertItem( machFileInfo.baseName() );
        }
        ret=true;
      }
    }
  }

  return ret;
}



// Fill layers from graphics layer list into combobox:
//
// _graphic: Graphic
// _all :    Include item "[All Layers]"?
//
bool 
RComboBox::fillInLayers(RGraphic* _graphic, bool _all, bool _clear)
{
  RLayer* lay;
  
  if(_graphic) {

    // Reset:
    //
    if(_clear) clear();
  
    // Fill in the layers in the combo box:
    //
    for(lay=_graphic->layerFirst(); lay!=0; lay=_graphic->layerNext()) {
      if(lay->getName()) {
        insertItem(lay->getName());
      }
    }

    // [All Layers]:
    //
    if(_all) insertItem(tr("[All Layers]"), 0);
    setCurrentItem(0);
    
    return true;
  }
  else {
    return false;
  }
}



// Fill colors into combobox:
//
bool
RComboBox::fillInColors(bool _clear)
{
  // Reset:
  //
  if(_clear) clear();

  QComboBox::insertItem(QPixmap(color00_xpm));
  QComboBox::insertItem(QPixmap(color01_xpm));
  QComboBox::insertItem(QPixmap(color02_xpm));
  QComboBox::insertItem(QPixmap(color03_xpm));
  QComboBox::insertItem(QPixmap(color04_xpm));
  QComboBox::insertItem(QPixmap(color05_xpm));
  QComboBox::insertItem(QPixmap(color06_xpm));
  QComboBox::insertItem(QPixmap(color07_xpm));
  QComboBox::insertItem(QPixmap(color08_xpm));
  QComboBox::insertItem(QPixmap(color09_xpm));
  QComboBox::insertItem(QPixmap(color10_xpm));
  QComboBox::insertItem(QPixmap(color11_xpm));
  QComboBox::insertItem(QPixmap(color12_xpm));
  QComboBox::insertItem(QPixmap(color13_xpm));
  QComboBox::insertItem(QPixmap(color14_xpm));
  QComboBox::insertItem(QPixmap(color15_xpm));

  return true;
}



// Fill line widths into combobox:
//
bool
RComboBox::fillInWidths(bool _clear)
{
  // Reset:
  //
  if(_clear) clear();

  QComboBox::insertItem(QPixmap(width00_xpm));
  QComboBox::insertItem(QPixmap(width01_xpm));
  QComboBox::insertItem(QPixmap(width02_xpm));
  QComboBox::insertItem(QPixmap(width03_xpm));
  QComboBox::insertItem(QPixmap(width04_xpm));
  QComboBox::insertItem(QPixmap(width05_xpm));
  QComboBox::insertItem(QPixmap(width06_xpm));
  QComboBox::insertItem(QPixmap(width07_xpm));
  QComboBox::insertItem(QPixmap(width08_xpm));

  return true;
}


// Fill line styles into combobox:
//
bool
RComboBox::fillInStyles(bool _clear)
{
  // Reset:
  //
  if(_clear) clear();

  QComboBox::insertItem(QPixmap(style00_xpm));
  QComboBox::insertItem(QPixmap(style01_xpm));
  QComboBox::insertItem(QPixmap(style02_xpm));
  QComboBox::insertItem(QPixmap(style03_xpm));
  QComboBox::insertItem(QPixmap(style04_xpm));

  return true;
}



// Fill in list of parameters from Machine-Generator _mach:
//
bool 
RComboBox::fillInParameters(const char* _mach, bool _layerParameters, bool _clear)
{
  //QString machineGeneratorPath = RIni::getRIni()->getMachineGeneratorPath(_mach);
  QString machineGeneratorPath = fileSearchFile( "machines", QString(_mach)+".cxm" );
  QFile maFile(machineGeneratorPath);

  // Read entries from mach-File:
  //
  if(maFile.open(IO_ReadOnly)) {

    QString curText=currentText();

    // Reset:
    //
    if(_clear) clear();
  
    QTextStream maStream(&maFile);
    QString maLine;        // a line
    QString maSection;     // a section (e.g.: "[Standards]")

    while(!maStream.atEnd()) {
      maLine=maStream.readLine();
      maLine=maLine.stripWhiteSpace();

      // New section:
      //
      if(maLine.at(0)=='[') {
        maSection=maLine;
      }
      else {
        if(maSection=="[Parameter]" ||
           (_layerParameters && maSection=="[LayerParameter]")) {
          if(maLine.contains("Parameter")) {
            char  scode;            // Code for parameter
            char  slabel[128];      // Label for parameter
            char  newEntry[256];    // New entry in ComboBox list

            slabel[0]='\0';

            strGetValuesFromParameterLine(maLine.latin1(),
                                          0,
                                          0,
                                          &scode,
                                          slabel,
                                          0,
                                          0);
            
            RLOG("\nComboBox: Add Parameter: ");
            RLOG(slabel);
            RLOG(" ");
            RLOG(scode);
            
            strReplaceChar(slabel, '_', ' ');
            sprintf(newEntry, "$%c (%s)", scode, slabel);

            insertItem(newEntry);
          }
        }
      }
    }
    
    maFile.close();

    setEditText( curText );
    return true;
  }
  else {
    return false;
  }
}



// Fill in list of orders from Machine-Generator _mach:
//
bool 
RComboBox::fillInOrders(const char* _mach, bool _clear)
{
  QString machineGeneratorPath = fileSearchFile( "machines", QString(_mach)+".cxm" );
  QFile maFile(machineGeneratorPath);

  // Read entries from mach-File:
  //
  if(maFile.open(IO_ReadOnly)) {

    QString curText=currentText();

    // Reset:
    //
    if(_clear) clear();
  
    QTextStream maStream(&maFile);
    QString maLine;        // a line
    QString maSection;     // a section (e.g.: "[Standards]")
    char    tmpBuf[256];   // Temp buffer for order names

    while(!maStream.atEnd()) {
      maLine=maStream.readLine();
      maLine=maLine.stripWhiteSpace();

      // New section:
      //
      if(maLine.at(0)=='[') {
        maSection=maLine;
      }
      else {
        if(maSection=="[Code]") {
          // User Defined Codes:
          //
          // Exclude comments and empty lines:
          //
          if(!maLine.isEmpty() &&
             maLine.left(2) != "//" ) {
               
            while(!maLine.contains('}') &&
                  !maStream.atEnd()) {
              maLine+=maStream.readLine();
            }
                  
            // Order Name:
            //
            tmpBuf[0]='\0';
            sscanf(maLine.latin1(), 
                   "%255s",
                   tmpBuf);
  
            RLOG("\nComboBox: Add Order: ");
            RLOG(tmpBuf);
            
            insertItem(tmpBuf);
          }
        }
      }
    }
    
    maFile.close();

    setEditText( curText );
    return true;
  }
  else {
    return false;
  }
}



// Fill in all order items found in list of orders:
//
bool 
RComboBox::fillInOrderItems(QList<QString> &_order, const char* _exception, bool _clear)
{
  QString* sord;         // pointer which walks through orders
  QString ord;           // Copy of ord but in old QCString style (??)
  const char* itemPtr;   // Walk through order
  char  item[32700];     // Contents of a single item

  if(_clear) clear();
  
  if(!_order.isEmpty()) {
    for(sord=_order.first(); sord!=0; sord=_order.next()) {
    
      ord = *sord;

      // Walk through Items (<...>) and fill ComboBox-List:
      //
      itemPtr = ord.latin1();

      // Step forward to '{':
      //
      while(itemPtr[0]!='{' && itemPtr[0]!='\0') ++itemPtr;
      if(itemPtr[0]=='{') ++itemPtr;

      do {
        
        // Special Item (<...>):
        //
        if(itemPtr[0]=='<') {
          sscanf(itemPtr, "%32698[^>}]", item);
          strcat(item, ">");
          while(itemPtr[0]!='>' && itemPtr[0]!='\0') ++itemPtr;
          if(itemPtr[0]=='>') ++itemPtr;
        }

        // Text-Item:
        //
        else {
          //sscanf(itemPtr, "%32698[^<}]", item);
          while(itemPtr[0]!='<' && itemPtr[0]!='\0') ++itemPtr;
        }

        if(item[0]!='}' &&
           strncmp(item, "<if:", 4) &&
           strncmp(item, "</if>", 5) &&
           strncmp(item, "<mod:", 5) &&
           strncmp(item, "</mod:", 6) &&
           strncmp(item, "<delmod:", 8)  ) {
          if(!_exception || strcmp(_exception, item)) {
            insertItem(item);
          }
        }
      
      }while(itemPtr[0]!='\0' && itemPtr[0]!='}');

      insertItem("<if:>");
      insertItem("<mod:>");
      insertItem("<delmod:1>");
      insertItem("<NewLine>");
      insertItem("<Number>");
      insertItem("<OrderRapidMove>");
      insertItem("<OrderPoint>");
      insertItem("<OrderLine>");
      insertItem("<OrderLineOffsetLeft>");
      insertItem("<OrderLineOffsetRight>");
      insertItem("<OrderLineOffsetOff>");
      insertItem("<OrderArcCW>");
      insertItem("<OrderArcCCW>");
      insertItem("<OrderContourStart>");
      insertItem("<OrderContourEnd>");
      insertItem("<OrderLayerStart>");
      insertItem("<OrderLayerEnd>");
      insertItem("<X1Abs>");
      insertItem("<Y1Abs>");
      insertItem("<X2Abs>");
      insertItem("<Y2Abs>");
      insertItem("<X1Rel>");
      insertItem("<Y1Rel>");
      insertItem("<X2Rel>");
      insertItem("<Y2Rel>");
      insertItem("<IAbs>");
      insertItem("<JAbs>");
      insertItem("<IRel>");
      insertItem("<JRel>");
      insertItem("<A1>");
      insertItem("<A2>");
      insertItem("<A>");
      insertItem("<Radius>");
      insertItem("<Diameter>");

      if(_exception) removeItem(_exception);
    }
    return true;
  }
  else {
    return false;
  }
}



// Fill in the items from another combobox:
//
bool 
RComboBox::fillInItemsFrom(RComboBox* _source, bool _clear)
{
  int i;
  QString curText=currentText();

  if(_source) {
    if(_clear) clear();
    for(i=0; i<_source->count(); ++i) {
      insertItem(_source->text(i));
    }
  }
  
  setEditText( curText );
  
  return true;
}



// Fill in items from a string
//
//   the items must be separated by spaces
//
bool 
RComboBox::fillInItemsFromString(const char* _str, bool _clear)
{
  if(_str) {
    const char* ptr;      // Pointer (walks through _str)
    char item[128]; 

    ptr=_str;

    if(_clear) clear();

    do {
      sscanf(ptr, "%127s", item);

      insertItem(item);

      // Overread item:
      //
      while(ptr[0]!='\0' && ptr[0]!=' ' && ptr[0]!='\n') ++ptr;

      // Overread White-spaces:
      //
      while(ptr[0]!='\0' && (ptr[0]==' ' || ptr[0]=='\n')) ++ptr;

    }while(ptr && ptr[0]!='\0');

    return true;
  }
  else {
    return false;
  }
}



// Fill in possible IF-Items (poschanged, ...):
//
bool 
RComboBox::fillInIfItems(bool _clear)
{
  if(_clear) clear();

  insertItem("poschanged1");
  insertItem("poschanged2");
  insertItem("contourbegin");
  insertItem("contourmiddle");
  insertItem("contourend");

  return true;
}



// Fill in fonts:
//
bool
RComboBox::fillInFonts(bool _clear)
{
  RFonts* fonts = RFonts::getRFonts();

  if(_clear) clear();

  if(fonts->getNumFonts()>0) {
    for(int f=0; f<fonts->getNumFonts(); ++f) {
      insertItem(fonts->getFontName(f));
    }
    return true;
  }
  return false;
}


// Fill in patterns:
//
bool
RComboBox::fillInPatterns(bool _clear)
{
  bool ret=false;
  if(_clear) clear();

  //QString hatchPath = RIni::getRIni()->getProgramPath();
  //hatchPath+="/hatches";

  for( int p=1; p<=3; ++p ) {
    QString hatchPath = fileSearchSubdir( "hatches", p );

    QDir hatchDir(hatchPath, "*.dxf");
    QStringList hatchList = hatchDir.entryList();
    QStringList::ConstIterator hatchIterator;
    QFileInfo hatchFileInfo;

    if( hatchList.count()>0 ) {
      for( hatchIterator=hatchList.begin(); hatchIterator!=hatchList.end(); ++hatchIterator ) {
        hatchFileInfo.setFile( hatchPath+"/"+(*hatchIterator) );
        insertItem( hatchFileInfo.baseName() );
      }
      ret=true;
    }
  }

  return ret;
}



// Fill in units:
//
bool
RComboBox::fillInUnits(bool _clear)
{
  if(_clear) clear();

  insertItem( "None" );
  insertItem( "Inch" );
  insertItem( "Foot" );
  insertItem( "Mile" );
  insertItem( "Millimeter" );
  insertItem( "Centimeter" );
  insertItem( "Meter" );
  insertItem( "Kilometer" );
  insertItem( "Microinch" );
  insertItem( "Mil" );
  insertItem( "Yard" );
  insertItem( "Angstrom" );
  insertItem( "Nanometer" );
  insertItem( "Micron" );
  insertItem( "Decimeter" );
  insertItem( "Decameter" );
  insertItem( "Hectometer" );
  insertItem( "Gigameter" );
  insertItem( "Astro" );
  insertItem( "Lightyear" );
  insertItem( "Parsec" );

  return true;
}


// Fill in metric/english exactness
bool
RComboBox::fillInExactness(bool _metric, bool _clear)
{
  if(_clear) clear();

  if(_metric) {
    insertItem( "1" );
    insertItem( "0.1" );
    insertItem( "0.01" );
    insertItem( "0.001" );
    insertItem( "0.0001" );
    insertItem( "0.00001" );
    insertItem( "0.000001" );
  }
  else {
    insertItem( "1/2" );
    insertItem( "1/4" );
    insertItem( "1/8" );
    insertItem( "1/16" );
    insertItem( "1/32" );
    insertItem( "1/64" );
    insertItem( "1/128" );
    insertItem( "1/256" );
    insertItem( "1/512" );
    insertItem( "1/1024" );
  }

  return true;
}


// Fill in metric/english scales
bool
RComboBox::fillInScale(bool _metric, ScaleType _type, bool _clear )
{
  if(_clear) clear();

  if( _metric || _type==Absolute ) {
    insertItem( "100000:1" );
    insertItem( "75000:1" );
    insertItem( "50000:1" );
    insertItem( "25000:1" );
    insertItem( "10000:1" );
    insertItem( "7500:1" );
    insertItem( "5000:1" );
    insertItem( "2500:1" );
    insertItem( "2000:1" );
    insertItem( "1000:1" );
    insertItem( "500:1" );
    insertItem( "200:1" );
    insertItem( "100:1" );
    insertItem( "75:1" );
    insertItem( "50:1" );
    insertItem( "20:1" );
    insertItem( "10:1" );
    insertItem( "5:1" );
    insertItem( "2:1" );
    insertItem( "1:1" );
    insertItem( "1:2" );
    insertItem( "1:5" );
    insertItem( "1:10" );
    insertItem( "1:20" );
    insertItem( "1:25" );
    insertItem( "1:50" );
    insertItem( "1:75" );
    insertItem( "1:100" );
    insertItem( "1:200" );
    insertItem( "1:500" );
    insertItem( "1:1000" );
    insertItem( "1:2000" );
    insertItem( "1:2500" );
    insertItem( "1:5000" );
    insertItem( "1:7500" );
    insertItem( "1:10000" );
    insertItem( "1:25000" );
    insertItem( "1:50000" );
    insertItem( "1:75000" );
    insertItem( "1:100000" );
  }
  else {
    if( _type==Engineering ) {
      insertItem( "1\" = 1\"" );
      insertItem( "1\" = 2\"" );
      insertItem( "1\" = 4\"" );
      insertItem( "1\" = 1'" );
      insertItem( "1\" = 5'" );
      insertItem( "1\" = 10'" );
      insertItem( "1\" = 20'" );
      insertItem( "1\" = 30'" );
      insertItem( "1\" = 40'" );
      insertItem( "1\" = 50'" );
      insertItem( "1\" = 60'" );
      insertItem( "1\" = 80'" );
      insertItem( "1\" = 100'" );
      insertItem( "1\" = 200'" );
      insertItem( "1\" = 300'" );
      insertItem( "1\" = 400'" );
      insertItem( "1\" = 500'" );
      insertItem( "1\" = 1000'" );
      insertItem( "1\" = 2000'" );
    }
    else if( _type==Architectural ) {
      insertItem( "1\" = 1\"" );
      insertItem( "6\" = 1'-0\"" );
      insertItem( "3\" = 1'-0\"" );
      insertItem( "3/2\" = 1'-0\"" );
      insertItem( "1\" = 1'-0\"" );
      insertItem( "3/4\" = 1'-0\"" );
      insertItem( "1/2\" = 1'-0\"" );
      insertItem( "3/6\" = 1'-0\"" );
      insertItem( "1/4\" = 1'-0\"" );
      insertItem( "3/16\" = 1'-0\"" );
      insertItem( "1/8\" = 1'-0\"" );
      insertItem( "3/32\" = 1'-0\"" );
      insertItem( "1/16\" = 1'-0\"" );
      insertItem( "1/32\" = 1'-0\"" );
    }
  }

  return true;
}


/** Fill in Scale types
*/
bool
RComboBox::fillInScaleTypes(bool _metric, bool _clear)
{
  if(_clear) clear();

  if(_metric) {
    insertItem( "Absolute" );
  }
  else {
    insertItem( "Absolute" );
    insertItem( "Engineering" );
    insertItem( "Architectural" );
  }

  return true;
}


/** Fill in Paper sizes
*/
bool
RComboBox::fillInPageFormats(bool _clear)
{
  if(_clear) clear();

  insertItem( "User" );
  insertItem( "Letter" );
  insertItem( "Legal" );
  insertItem( "Executive" );
  insertItem( "A0" );
  insertItem( "A1" );
  insertItem( "A2" );
  insertItem( "A3" );
  insertItem( "A4" );
  insertItem( "A5" );
  insertItem( "A6" );
  insertItem( "A7" );
  insertItem( "A8" );
  insertItem( "A9" );
  insertItem( "A10" );
  insertItem( "B0" );
  insertItem( "B1" );
  insertItem( "B2" );
  insertItem( "B3" );
  insertItem( "B4" );
  insertItem( "B5" );
  insertItem( "B6" );
  insertItem( "B7" );
  insertItem( "B8" );
  insertItem( "B9" );
  insertItem( "B10" );
  insertItem( "C0" );
  insertItem( "C1" );
  insertItem( "C2" );
  insertItem( "C3" );
  insertItem( "C4" );
  insertItem( "C6" );
  insertItem( "C7" );
  insertItem( "C8" );
  insertItem( "C9" );
  insertItem( "C10" );
  insertItem( "C5E" );
  insertItem( "Comm10E" );
  insertItem( "DLE" );
  insertItem( "Folio" );
  insertItem( "Ledger" );
  insertItem( "Tabloid" );
  insertItem( "NPageSize" );

  return true;
}


/** Fill in Page orientations
*/
bool
RComboBox::fillInPageOrientations(bool _clear)
{
  if(_clear) clear();

  insertItem( "Portrait" );
  insertItem( "Landscape" );

  return true;
}


/** Fill in Charsets
*/
bool
RComboBox::fillInCharsets(bool _clear)
{
  if(_clear) clear();

  insertItem( "AnyCharSet" );
  insertItem( "Latin1" );
  insertItem( "Latin2" );
  insertItem( "Latin3" );
  insertItem( "Latin4" );
  insertItem( "Latin5" );
  insertItem( "Latin6" );
  insertItem( "Latin7" );
  insertItem( "Latin8" );
  insertItem( "Latin9" );
  insertItem( "ISO-8859-1" );
  insertItem( "ISO-8859-2" );
  insertItem( "ISO-8859-3" );
  insertItem( "ISO-8859-4" );
  insertItem( "ISO-8859-5" );
  insertItem( "ISO-8859-6" );
  insertItem( "ISO-8859-7" );
  insertItem( "ISO-8859-8" );
  insertItem( "ISO-8859-9" );
  insertItem( "ISO-8859-10" );
  insertItem( "ISO-8859-11" );
  insertItem( "ISO-8859-12" );
  insertItem( "ISO-8859-13" );
  insertItem( "ISO-8859-14" );
  insertItem( "ISO-8859-15" );
  insertItem( "KOI8-R" );
  insertItem( "Set-Ja" );
  insertItem( "Set-1" );
  insertItem( "Set-Ko" );
  insertItem( "Set-Th-TH" );
  insertItem( "Set-Zh" );
  insertItem( "Set-Zh-TW" );
  insertItem( "Set-N" );
  insertItem( "Unicode" );

  return true;
}




// EOF
