/***************************************************************************
                          rchoosemach.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rchoosemach.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qfile.h>
#include <qfileinfo.h>
#include <qkeycode.h>
#include <qlabel.h>
#include <qtextstream.h>
#include <qtooltip.h>
#include <qpushbutton.h>

#include "rchoosemach.h"
#include "rcombobox.h"
#include "rfile.h"
#include "rconfig.h"
#include "rinputdialog.h"
#include "rlog.h"
#include "rprgdef.h"
#include "ryesnodialog.h"

// Constructor:
//
RChooseMach::RChooseMach(QWidget* _parent, 
                         const char* _name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  setCaption(DEF_APPNAME);

  setFixedSize(DEF_CHOOSEMACH_WIDTH, DEF_CHOOSEMACH_HEIGHT);
  
  // Label: "Machinegen.:"
  //
  lText = new QLabel(tr("Machine-Generator:"), this, "ltext");
  lText->setAlignment(AlignRight|AlignVCenter);
  lText->setGeometry(10, 20, DEF_CHOOSEMACH_WIDTH/2-15, 20);

  mbMachine = new RComboBox(false, this, "cbmachine");
  mbMachine->setGeometry(DEF_CHOOSEMACH_WIDTH/2+5, 20, 100, 20);
  QToolTip::add(mbMachine, tr("Choose a Machine-Generator"));
  mbMachine->fillInMachineGenerators();
  mbMachine->setEditText(RCONFIG->getSetting("CAM:MachineGenerator"));
  mbMachine->setFocus();

  bNew = new QPushButton(tr("New (empty)"), this);
  bNew->setGeometry(10, 60, (width()-20)/3, 20);
  QToolTip::add(bNew, tr("Create empty new Machine-Generator"));
  connect(bNew, SIGNAL(clicked()), SLOT(addNew()));

  bNewDerivation = new QPushButton(tr("New (derivation)"), this);
  bNewDerivation->setGeometry(10+(width()-20)/3, 60, (width()-20)/3, 20);
  QToolTip::add(bNewDerivation, tr("Create new Machine-Generator based\non the currently selected one"));
  connect(bNewDerivation, SIGNAL(clicked()), SLOT(addNewDerivation()));

  bDel = new QPushButton(tr("Delete selected"), this);
  bDel->setGeometry(10+(width()-20)/3*2, 60, (width()-20)/3, 20);
  QToolTip::add(bDel, tr("Delete the selected Machine-Generator"));
  connect(bDel, SIGNAL(clicked()), SLOT(deleteMach()));

  bOk = new QPushButton(tr("Configure"), this);
  bOk->setGeometry(10+(width()-20)/3, 90, (width()-20)/3, 20);
  bOk->setAccel(Key_Return);
  QToolTip::add(bOk, tr("Configure the selected\nMachine-Generator"));
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));

  bCancel = new QPushButton(tr("Cancel"), this);
  bCancel->setGeometry(10+(width()-20)/3*2, 90, (width()-20)/3, 20);
  bCancel->setAccel(Key_Escape);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));

  //bHelp = new QPushButton(tr("Help"), this);
  //bHelp->setGeometry(10+(width()-20)/3*2, 90, (width()-20)/3, 20);
  //bHelp->setAccel(Key_F1);

}



// Destructor:
//
RChooseMach::~RChooseMach()
{

}



// Get the user input:
//
const char*
RChooseMach::getMachine()
{
  if(mbMachine) {
    return mbMachine->currentText();
  }
  else {
    return 0;
  }
}



// Add new machine generator:
//
void
RChooseMach::addNew()
{
  bool repeat;
  do {
    repeat=false;
    RInputDialog inpDlg(tr("Type a name for the new\nMachine-Generator file:"),
                        250, 0, this);
  
    if(inpDlg.exec()) {

      QString machGenPath;
      //machGenPath = fileSearchFile("machines",
      //                             QString(inpDlg.getInput()) + ".cxm");
      QDir dir;
      dir.mkdir( RCONFIG->getConfigDir().absPath() + "/machines", true );
      machGenPath = RCONFIG->getConfigDir().absPath() + "/machines/" + QString(inpDlg.getInput()) + ".cxm";
      QFile machGen(machGenPath);

      // Test if Machine-Generator already exists:
      //   Overwrite-Warning
      //
      if(machGen.exists()) {
        if(!fileOverwriteWarning(inpDlg.getInput(), 
                                 tr("Machine-Generator"),
                                 this)) {
          repeat=true;
        }
      }
      
      // Add an empty Machine-Generator:
      //
      if(!repeat) {

        if(machGen.open(IO_WriteOnly)) {
          QTextStream stream(&machGen);

          stream << "[Description]\n"
                 << "{" << inpDlg.getInput() << "}\n"
                 << "\n";
                 
          stream << "[Standards]\n"
                 << "Extension            = NC\n"
                 << "ContourStartInHeader =  0\n"
                 << "LayerStartInHeader   =  0\n"
                 << "Optimization         =  1\n"
                 << "ContourCenter        =  0\n"
                 << "Sorting              =  n\n"
                 << "Direction            =  n\n"
                 << "StartNumber          = 10\n"
                 << "NumberStep           = 10\n"
                 << "MaxArcAngle          = 0.0\n"
                 << "MaxArcLength         = 0.0\n"
                 << "Tolerance            = 0.001\n"
                 << "Factor               =  1\n"
                 << "\n";

          stream << "[Pointing]\n"
                 << "Pointing             =   0\n"
                 << "PointingAngle        =  60.0\n"
                 << "PointingDepth        =   2.2\n"
                 << "PointingLimit        =   5.0\n"
                 << "PointingMaxLength    = 100.0\n"
                 << "\n";

          stream << "[Parameter]\n"
                 << "\n";

          stream << "[LayerParameter]\n"
                 << "\n";

          stream << "[Code]\n"
                 << "OrderRapidMove\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderPoint\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderLine\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderLineOffsetLeft\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderLineOffsetRight\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderLineOffsetOff\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderArcCW\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderArcCCW\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderToolUp\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderToolDown\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderContourStart\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderContourEnd\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderLayerStart\n"
                 << "  {}\n"
                 << "\n"
                 << "OrderLayerEnd\n"
                 << "  {}\n"
                 << "\n"
                 << "ProgramStart\n"
                 << "  {}\n"
                 << "\n"
                 << "ProgramEnd\n"
                 << "  {}\n"
                 << "\n";

          stream << "//EOF\n";

          machGen.close();

          mbMachine->fillInMachineGenerators();
          mbMachine->setEditText(inpDlg.getInput());
        }
      }
    }
  }while(repeat);
}



// Add new machine generator as derivation from
//   the selected one:
//
void
RChooseMach::addNewDerivation()
{
  bool repeat;
  QString mes;
  
  do {
    repeat=false;

    // Type a name for the new Machine-Generator\nfile derived from 'file.cxm':
    //
    mes = QString("%1 '%2':")
                 .arg(tr("Type a name for the new Machine-Generator\nfile derived from"))
                 .arg(mbMachine->currentText());
    RInputDialog inpDlg(mes, 
                        255, 0, this);
  
    if(inpDlg.exec()) {
      QDir dir;
      QString machGenPathNew;
      dir.mkdir( RCONFIG->getConfigDir().absPath() + "/machines", true );
      machGenPathNew = RCONFIG->getConfigDir().absPath() + "/machines/" + QString(inpDlg.getInput()) + ".cxm";

      //machGenPathNew=
      //  fileSearchFile("machines", QString(inpDlg.getInput()) + ".cxm");
        //RIni::getRIni()->getMachineGeneratorPath(inpDlg.getInput());
      
      QFile machGenNew(machGenPathNew);
      
      // Add a derived Machine-Generator:
      //
      if(!repeat) {
        QString machGenPathOri;

        machGenPathOri=
          //RIni::getRIni()->getMachineGeneratorPath(mbMachine->currentText());
          fileSearchFile("machines", QString(mbMachine->currentText()) + ".cxm");

        // Copy file:
        //
        repeat = !fileCopy(machGenPathOri, 
                           machGenPathNew, 
                           tr("Machine-Generator"),
                           this);
        
        mbMachine->fillInMachineGenerators();
        mbMachine->setEditText(inpDlg.getInput());
      }
    }
  }while(repeat);
  
}



// Delete selected Machine-Generator:
//
void
RChooseMach::deleteMach()
{
  if(mbMachine) {
    QString machGenPathOri;
    QString machGenPathBak;

    machGenPathOri=
      //RIni::getRIni()->getMachineGeneratorPath(mbMachine->currentText());
      fileSearchFile("machines", QString(mbMachine->currentText()) + ".cxm");

    machGenPathBak=machGenPathOri;
    machGenPathBak.at(machGenPathBak.length()-1)='_';
    
    // Copy "cxm"-file to "cx_":
    // 
    if(fileCopy(machGenPathOri,
                machGenPathBak,
                tr("Machine-Generator"),
                this)) {

      // Delete "cxm"-file:
      //
      if(fileDelete(machGenPathOri,
                    tr("Machine-Generator"),
                    this)) {
        mbMachine->fillInMachineGenerators();
      }
    }
  }
}


// EOF


