/***************************************************************************
                          measureearea.cpp  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Guenter Szolderits
    email                : g.szolderits@gmx.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "measurearea.h"
#include "rmath.h"
#include <stdio.h>

MeasureArea::MeasureArea()
{
	thePoints.setAutoDelete(true);
}

MeasureArea::~MeasureArea()
{
}

/*! Add a point to the internal queue
    \param _x x-coordinate of the point
    \param _y y-coordinate of the point
*/
void
MeasureArea::addPoint(double _x, double _y)
{
	if (thePoints.isEmpty())
		baseY = _y;
	
	thePoints.enqueue(new MeasureAreaPoint(_x, _y));
}

/*! reset the queue
*/
void
MeasureArea::reset()
{
	thePoints.clear();
	area = 0.0;
	circumference = 0.0;
}

/*! calculate area and circumference
*/
void
MeasureArea::calculate()
{
	area = 0.0;
	circumference = 0.0;
	MeasureAreaPoint *ptFirst; // the first point
	MeasureAreaPoint *pt1, *pt2;

	if (thePoints.count() >= 3) // need at least 3 points for an area
	{
		ptFirst = thePoints.dequeue();
		pt1 = ptFirst;
		while ((pt2 = thePoints.dequeue()))
		{
			area += calcSubArea(pt1, pt2);
			circumference += calcDistance(pt1, pt2);
			if (pt1 != ptFirst)
				delete pt1; // need ptFirst later
			pt1 = pt2;
		}
		area += calcSubArea(pt1, ptFirst);
		circumference += calcDistance(pt1, ptFirst);
		delete pt1;
		delete ptFirst;
	}

	thePoints.clear();
	area = fabs(area);
}

/*! Calculates a sub area
    \param _pt1 first point
    \param _pt2 second point
*/
double
MeasureArea::calcSubArea(MeasureAreaPoint *_pt1, MeasureAreaPoint *_pt2)
{
	double width = _pt2->getX() - _pt1->getX();
	double height = (_pt1->getY() - baseY) + (_pt2->getY() - baseY);

	return width * height / 2.0;
}

/*! Calculates a distance
    \param _pt1 first point
    \param _pt2 second point
*/
double
MeasureArea::calcDistance(MeasureAreaPoint *_pt1, MeasureAreaPoint *_pt2)
{
	return mtGetDistance(_pt1->getX(), _pt1->getY(), _pt2->getX(), _pt2->getY());
}
