# Copyright 2006 David Johnson
# This project file is free software; the author gives unlimited
# permission to copy, distribute and modify it.

TARGET = qbrew
TEMPLATE = app
CONFIG += qt thread warn_on release
QT += xml

MOC_DIR = build
OBJECTS_DIR = build
RCC_DIR = build
UI_DIR = build
VPATH = src

win32 {
    RC_FILE = win\icon.rc
    CONFIG -= console

    target.path = release
    INSTALLS += target

    data.path = release
    data.files = data/* pics/splash.png win/qbrew.ico README LICENSE
    INSTALLS += data

    doc.path = release/doc
    doc.files = docs/book/* docs/primer/*
    INSTALLS += doc
}

macx {
    DEFINES += HAVE_ROUND
    LIBS += -dead-strip
    QMAKE_POST_LINK=strip qbrew.app/Contents/MacOS/qbrew

    # install into app bundle
    data.path = qbrew.app/Contents/Resources
    data.files = data/* pics/splash.png mac/application.icns mac/document.icns
    INSTALLS += data

    misc.path = qbrew.app/Contents
    misc.files = mac/Info.plist mac/PkgInfo
    INSTALLS += misc

    doc.path = qbrew.app/Contents/Resources/en.lproj
    doc.files = docs/book/* docs/primer/*
    INSTALLS += doc
}

unix:!macx {
    DEFINES += $$(HAVEDEFS)
    DEFINES += PACKAGE=\"$$(PACKAGE)\"
    DEFINES += VERSION=\"$$(VERSION)\"
    DEFINES += PREFIX=\"$$(PREFIX)\"

    target.path = $$(BINDIR)
    INSTALLS += target

    data.path = $$(DATADIR)
    data.files = data/* pics/splash.png
    INSTALLS += data

    doc.path = $$(DOCDIR)
    doc.files = docs/book/* docs/primer/* README LICENSE
    INSTALLS += doc
}

RESOURCES = qbrew.qrc

HEADERS = alcoholtool.h \
	qbrew.h \
	configstate.h \
	configure.h \
	data.h \
	databasetool.h \
	grain.h \
	graindelegate.h \
	grainmodel.h \
	helpviewer.h \
	hop.h \
	hopdelegate.h \
	hopmodel.h \
	hydrometertool.h \
	misc.h \
	miscdelegate.h \
	miscmodel.h \
	notepage.h \
	quantity.h \
	recipe.h \
	resource.h \
	style.h \
	styledelegate.h \
	stylemodel.h \
	view.h

SOURCES = alcoholtool.cpp \
	qbrew.cpp \
	configure.cpp \
	data.cpp \
	databasetool.cpp \
	export.cpp \
	grain.cpp \
	graindelegate.cpp \
	grainmodel.cpp \
	helpviewer.cpp \
	hop.cpp \
	hopdelegate.cpp \
	hopmodel.cpp \
	hydrometertool.cpp \
	main.cpp \
	misc.cpp \
	miscdelegate.cpp \
	miscmodel.cpp \
	notepage.cpp \
	quantity.cpp \
	recipe.cpp \
	style.cpp \
	styledelegate.cpp \
	stylemodel.cpp \
	view.cpp

FORMS = alcoholtool.ui \
	calcconfig.ui \
	databasetool.ui \
	mainwindow.ui \
	generalconfig.ui \
	helpviewer.ui \
	hydrometertool.ui \
	noteview.ui \
	recipeconfig.ui \
	view.ui
