/***************************************************************************
  old settings.cpp
  -------------------
  Settings class for QBrew (deprecated)
  -------------------
  begin         September 22th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "resource.h"
#include "preferences.h"
#include "oldsettings.h"
#include "oldstore.h"

using namespace AppResource;

OldSettings::OldSettings() { ; }

OldSettings::~OldSettings() { ; }

void OldSettings::insertSetting(const QString &name, const QString &value)
{
    map_.replace(name, value);
}

bool OldSettings::loadSettings(const QString &filename, const QString &appname)
{
    QString name, value;

    OldStore *ifile = new OldStore(IO_ReadOnly, filename, appname);
    if (!ifile->good()) {
        // couldn't open file
        qWarning("Error: couldn't read settings from " + filename);
        return false;
    }

    while (ifile->getLine()) {
        if (ifile->getName() != ifile->getGroup()) {
            insertSetting(ifile->getName(), ifile->getValue());
        }
    }

    delete ifile;
    return true;
}

void OldSettings::convert(Preferences* pref)
{
    // load in from deprecated file format
    if (!loadSettings(pref->file(), pref->format())) {
        qWarning("Error: could not convert file " + pref->file());
        return;
    }

    bool ok;
    // loop through map
    QMap<QString, QString>::Iterator it;
    for (it = map_.begin(); it != map_.end(); it++) {
        if (it.key() == "STATUSBAR")
            pref->setBool(ID_PREF_STATUSBAR,(it.data().upper() == "TRUE"));
        if (it.key() == "TOOLBAR")
            pref->setBool(ID_PREF_TOOLBAR,(it.data().upper() == "TRUE"));
        if (it.key() == "DOCDIR")
            pref->setString(ID_PREF_QBREWDIR, it.data());
        if (it.key() == "STYLE")
            pref->setString(ID_PREF_WIDGET_STYLE, it.data());
        if (it.key() == "BATCH")
            pref->setDouble(ID_PREF_BATCH, it.data().toDouble(&ok) / 100.0);
        if (it.key() == "EFFICIENCY")
            pref->setDouble(ID_PREF_EFFICIENCY, it.data().toDouble(&ok) / 100.0);
        if (it.key() == "TINSETH")
            pref->setBool(ID_PREF_TINSETH, (it.data().upper() == "TRUE"));
    }
}
