/****************************************************************************
** helpwindow.h
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
** Modified by David Johnson for use in QBrew
*****************************************************************************/

#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#include <qmainwindow.h>

class QTextBrowser;

class HelpWindow : public QMainWindow
{
    Q_OBJECT
public:
    // constructor
    HelpWindow(const QString& home, const QString& path, QWidget* parent=0, const char *name=0);
    // destructor
    ~HelpWindow();

private slots:
    // set if back button available
    void setBackwardAvailable(bool b);
    // set if forward button available
    void setForwardAvailable(bool b);
    // if text has changed
    void textChanged();
    // print contents of browser
    void print();

private:
    QTextBrowser* browser_;
    int _backward, forward_;
};

#endif // HELPWINDOW_H
