/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "transactionview.h"
#include "selectpayee.h"
#include "editpayee.h"
#include "selectcategory.h"
#include "editcategory.h"

#include <aqbanking/jobgetbalance.h>
#include "kbanking.h"
#ifdef WIN32
# define strcasecmp stricmp
#endif

#include <qevent.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qlistview.h>
#include <qspinbox.h>
#include <qapplication.h>
#include <qpopupmenu.h>

#include <gwenhywfar/debug.h>



#define BUTTON_WIDTH    110
#define DEFAULT_NUMDAYS 30


TransactionView::TransactionView(Account *a,
                                 bool shortList,
                                 QWidget* parent,
                                 const char* name,
                                 WFlags fl)
:TransactionViewUi(parent, name, fl)
,_app(0)
,_account(a)
,_currentItem(0)
,_currentContextItem(0)
,_shortList(shortList)
,_tname(0) {
  assert(a);
  _app=(KBanking*)(a->getApi());
  transactionListView->setShortList(shortList);
  transactionListView->setApp(_app);
  workingLabel->setHidden(true);

  QObject::connect(detailsButton, SIGNAL(clicked()),
                   this, SLOT(slotDetails()));
  QObject::connect(refreshButton, SIGNAL(clicked()),
                   this, SLOT(slotUpdated()));
  QObject::connect(transactionListView,
                   SIGNAL(currentChanged(QListViewItem*)),
                   this, SLOT(slotCurrentChanged(QListViewItem*)));

  QObject::connect(setPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotSetPayee()));
  QObject::connect(openPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenPayee()));
  QObject::connect(setCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotSetCategory()));
  QObject::connect(openCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenCategory()));

  QObject::connect(transactionListView,
                   SIGNAL(contextMenuRequested(QListViewItem *,
                                               const QPoint &,
                                               int)),
                   this,
                   SLOT(slotContextMenuRequested(QListViewItem *,
                                                 const QPoint &,
                                                 int)));

}



TransactionView::TransactionView(KBanking *app,
                                 const std::list<RefPointer<Transaction> > &l,
                                 const char *tname,
                                 bool shortList,
                                 QWidget* parent,
                                 const char* name,
                                 WFlags fl)
:TransactionViewUi(parent, name, fl)
,_app(app)
,_account(0)
,_currentItem(0)
,_currentContextItem(0)
,_shortList(shortList)
,_tname(tname)
,_transactions(l) {
  transactionListView->setShortList(shortList);
  transactionListView->setApp(_app);
  workingLabel->setHidden(true);
  timeSpanBox->setHidden(true);

  QObject::connect(detailsButton, SIGNAL(clicked()),
                   this, SLOT(slotDetails()));
  QObject::connect(refreshButton, SIGNAL(clicked()),
                   this, SLOT(slotUpdated()));
  QObject::connect(transactionListView,
                   SIGNAL(currentChanged(QListViewItem*)),
                   this, SLOT(slotCurrentChanged(QListViewItem*)));

  QObject::connect(setPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotSetPayee()));
  QObject::connect(openPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenPayee()));
  QObject::connect(setCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotSetCategory()));
  QObject::connect(openCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenCategory()));

  QObject::connect(transactionListView,
                   SIGNAL(contextMenuRequested(QListViewItem *,
                                               const QPoint &,
                                               int)),
                   this,
                   SLOT(slotContextMenuRequested(QListViewItem *,
                                                 const QPoint &,
                                                 int)));

}



TransactionView::~TransactionView(){
}


bool TransactionView::init(){
  GWEN_DB_NODE *dbConfig=NULL;
  int rv;
  std::string s;
  int i, j;
  std::string path;

  //transactionListView->beginModify();

  daySpin->setValue(DEFAULT_NUMDAYS);

  path="gui/views/transactionview";
  if (_account) {
    s=_account->getBankCode();
    if (!s.empty()) {
      path+="/";
      path+=s;
    }
    s=_account->getAccountNumber();
    if (!s.empty()) {
      path+="/";
      path+=s;
    }
  }
  else if (_tname) {
    path+="/";
    path+=_tname;
  }
  else {
    path+="/generic";
  }

  rv=_app->loadAppSubConfig(path.c_str(),
			    &dbConfig,
			    0);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
  }
  else {
    int w;
    int h;
    const char *p;

    /* found settings */
    p=GWEN_DB_GetCharValue(dbConfig, "sortOrder", 0, "ascending");
    if (p) {
      if (strcasecmp(p, "ascending")==0)
	transactionListView->setSortOrder(Qt::Ascending);
      else
	if (strcasecmp(p, "descending")==0)
	  transactionListView->setSortOrder(Qt::Descending);
    }
    i=GWEN_DB_GetIntValue(dbConfig, "sortColumn", 0, -1);
    if (i!=-1)
      transactionListView->setSortColumn(i);
    w=GWEN_DB_GetIntValue(dbConfig, "width", 0, 640);
    h=GWEN_DB_GetIntValue(dbConfig, "height", 0, 480);
    resize(w, h);
    for (i=0; i<transactionListView->columns(); i++) {
      transactionListView->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(dbConfig, "columns", i, -1);
      if (j!=-1)
	transactionListView->setColumnWidth(i, j);
    } /* for */
    daySpin->setValue(GWEN_DB_GetIntValue(dbConfig, "numDays", 0,
					  DEFAULT_NUMDAYS));
    GWEN_DB_Group_free(dbConfig);
  } // if application settings

  slotUpdated();
  //transactionListView->endModify();
  return true;
}



bool TransactionView::fini(){
  GWEN_DB_NODE *dbConfig;
  int rv;
  std::string path;
  int i, j;
  std::string s;

  path="gui/views/transactionview";
  if (_account) {
    s=_account->getBankCode();
    if (!s.empty()) {
      path+="/";
      path+=s;
    }
    s=_account->getAccountNumber();
    if (!s.empty()) {
      path+="/";
      path+=s;
    }
  }
  else if (_tname) {
    path+="/";
    path+=_tname;
  }
  else {
    path+="/generic";
  }

  dbConfig=GWEN_DB_Group_new("config");
  assert(dbConfig);

  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "width", width());
  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "height", height());

  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "sortColumn", transactionListView->sortColumn());
  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "numDays", daySpin->value());

  switch(transactionListView->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
			 "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
			 "sortOrder", "descending");
    break;
  default:
    break;
  }

  for (i=0; i<transactionListView->columns(); i++) {
    j=transactionListView->columnWidth(i);
    GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
			"columns", j);
  } /* for */

  rv=_app->saveAppSubConfig(path.c_str(),
			    dbConfig,
			    0);
  GWEN_DB_Group_free(dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
    return false;
  }

  return true;
}


void TransactionView::slotUpdated() {
  std::list<RefPointer<Transaction> > l;
  int n;
  GWEN_TIME *cti;
  GWEN_TIME *ti;
  uint32_t secs;
  bool res;
  bool h1;
  bool h2;

  //transactionListView->beginModify();
  h1=transactionListView->isHidden();
  h2=workingLabel->isHidden();
  workingLabel->setHidden(false);
  transactionListView->setHidden(true);
  qApp->processEvents();

  _currentItem=0;
  transactionListView->clear();
  transactionListView->setLastSessionId(_app->getLastSessionId());
  if (_account) {
    n=daySpin->value();
    cti=GWEN_CurrentTime();
    secs=GWEN_Time_Seconds(cti);
    secs-=(n*60*60*24);
    ti=GWEN_Time_fromSeconds(secs);

    res=_account->loadTransactions(ti, cti, l);
    GWEN_Time_free(ti);
    GWEN_Time_free(cti);
    if (!res) {
      DBG_ERROR(0, "Error loading transactions");
    }

    // TODO: Make these values adjustable
    if (l.size()<100)
      transactionListView->setDrawMode(RichTextListView::DrawMode_Slow);
    else if (l.size()<300)
      transactionListView->setDrawMode(RichTextListView::DrawMode_Fast);
    else
      transactionListView->setDrawMode(RichTextListView::DrawMode_Fastest);
    transactionListView->addTransactions(l);
  }
  else {
    // TODO: Make these values adjustable
    if (_transactions.size()<100)
      transactionListView->setDrawMode(RichTextListView::DrawMode_Slow);
    else if (_transactions.size()<300)
      transactionListView->setDrawMode(RichTextListView::DrawMode_Fast);
    else
      transactionListView->setDrawMode(RichTextListView::DrawMode_Fastest);
    transactionListView->addTransactions(_transactions);
  }
  transactionListView->setCurrentItem(transactionListView->firstChild());
  slotCurrentChanged(transactionListView->firstChild());
  transactionListView->setFocus();

  transactionListView->setHidden(h1);
  workingLabel->setHidden(h2);
  //transactionListView->endModify();
  qApp->processEvents();
}



void TransactionView::slotDetails() {
}



void TransactionView::slotSetPayee() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  Payee *payee;
  bool aborted;
  Account *a;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();

  a=_app->findAccount(tp.ref().getLocalBankCode().c_str(),
                      tp.ref().getLocalAccountNumber().c_str());
  if (!a)
    a=_account;
  if (!a) {
    QMessageBox::critical(this,
                          tr("Selection-Error"),
                          tr("Transactions in this view can not be saved."),
                          tr("Dismiss"), QString::null);
    return;
  }

  payee=SelectPayee::assignSinglePayee(_app, tp.ptr(), aborted, this);
  if (payee) {
    tp.ref().setPayee(payee->id());
    if (!a->saveTransaction(tp.ptr())) {
      DBG_ERROR(0, "Could not save transaction");
      QMessageBox::critical(this,
                            tr("Storage-Error"),
                            tr("The modified transaction could not be saved"),
                            tr("Dismiss"), QString::null);
      return;
    }
    else {
      tp.ref().setModified(false);
    }
    transactionListView->redrawSelected();
    _app->flagStaff()->payeesUpdated();
  }

}



void TransactionView::slotOpenPayee() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  std::string pname;
  Payee *payee;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();
  pname=tp.ref().getPayee();
  if (pname.empty()) {
    QMessageBox::warning(this,
                         tr("No Payee"),
                         tr("The selected transaction has no payee set."),
                         tr("Dismiss"), QString::null);
    return;
  }
  payee=_app->findPayeeById(pname.c_str());
  if (!payee) {
    QMessageBox::warning(this,
                         tr("Payee not found"),
                         tr("The selected transaction has an unknown payee."),
                         tr("Dismiss"), QString::null);
    return;
  }
  EditPayee ep(_app, payee, false, this, "EditPayee", true);
  if (ep.exec()==QDialog::Accepted) {
    _app->flagStaff()->payeesUpdated();
    transactionListView->redrawSelected();
  }
}



void TransactionView::slotSetCategory() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  Category *cat;
  bool aborted;
  Account *a;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();

  a=_app->findAccount(tp.ref().getLocalBankCode().c_str(),
                      tp.ref().getLocalAccountNumber().c_str());
  if (!a)
    a=_account;
  if (!a) {
    QMessageBox::critical(this,
                          tr("Selection-Error"),
                          tr("Transactions in this view can not be saved."),
                          tr("Dismiss"), QString::null);
    return;
  }

  cat=SelectCategory::assignSingleCategory(_app, tp.ptr(), aborted, this);
  if (cat) {
    tp.ref().setCategory(cat->getId());
    if (!a->saveTransaction(tp.ptr())) {
      DBG_ERROR(0, "Could not save transaction");
      QMessageBox::critical(this,
                            tr("Storage-Error"),
                            tr("The modified transaction could not be saved"),
                            tr("Dismiss"), QString::null);
      return;
    }
    else {
      tp.ref().setModified(false);
    }
    transactionListView->redrawSelected();
    _app->flagStaff()->categoriesUpdated();
  }

}



void TransactionView::slotOpenCategory() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  std::string pname;
  Category *cat;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();
  pname=tp.ref().getCategory();
  if (pname.empty()) {
    QMessageBox::warning(this,
                         tr("No Category"),
                         tr("The selected transaction has no cat set."),
                         tr("Dismiss"), QString::null);
    return;
  }
  cat=_app->findCategoryById(pname.c_str());
  if (!cat) {
    QMessageBox::warning(this,
                         tr("Category not found"),
                         tr("The selected transaction has an unknown cat."),
                         tr("Dismiss"), QString::null);
    return;
  }
  if (EditCategory::editCategory(_app, cat, this)) {
    _app->flagStaff()->categoriesUpdated();
    transactionListView->redrawSelected();
  }
}



void TransactionView::slotCurrentChanged(QListViewItem *item) {
#if 0
  if (_shortList) {
    if (_currentItem)
      _currentItem->redrawItem();
    _currentItem=0;
    if (item) {
      TransactionListView2Item *entry;
      entry=dynamic_cast<TransactionListView2Item*>(item);
      if (entry) {
        _currentItem=entry;
        _currentItem->redrawItem(true);
      }
    }
  } // if _shortList
#endif
}



void TransactionView::slotContextMenuRequested(QListViewItem *lvi,
                                               const QPoint &coord,
                                               int column) {
  QPopupMenu men(transactionListView, "TransactionContextMenu");
  QPopupMenu *tmplMenu;
  DBG_ERROR(0, "Right Button Clicked on column %d", column);

  _currentContextItem=dynamic_cast<TransactionListView2Item*>(lvi);
  assert(_currentContextItem);

  tmplMenu=new QPopupMenu();
  tmplMenu->insertItem(tr("Transfer"),
                       this, SLOT(slotNewTransaction()));
  tmplMenu->insertItem(tr("EU-Transfer"),
                       this, SLOT(slotNewEuTransaction()));
  tmplMenu->insertItem(tr("Debit Note"),
                       this, SLOT(slotNewDebitNote()));
  tmplMenu->insertItem(tr("Standing Order"),
                       this, SLOT(slotNewStandingOrder()));
  tmplMenu->insertItem(tr("Dated Transfer"),
                       this, SLOT(slotNewDatedTransfer()));

  men.insertItem(tr("Use as template for new..."), tmplMenu);


  men.exec(coord);
}



void TransactionView::slotNewTransaction() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;

  assert(_currentContextItem);
  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();
  _app->transferFromTemplate(tp, this);
}



void TransactionView::slotNewEuTransaction() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;

  assert(_currentContextItem);
  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();
  _app->euTransferFromTemplate(tp, this);
}



void TransactionView::slotNewDebitNote() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;

  assert(_currentContextItem);
  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();
  _app->debitNoteFromTemplate(tp, this);
}



void TransactionView::slotNewStandingOrder() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;

  assert(_currentContextItem);
  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();
  _app->standingOrderFromTemplate(tp, this);
}



void TransactionView::slotNewDatedTransfer() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;

  assert(_currentContextItem);
  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  tp=tl.front();
  _app->datedTransferFromTemplate(tp, this);
}









