/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: transfer.cpp 435 2008-02-11 13:42:42Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "transfer.h"

#include <stdlib.h>
#include <gwenhywfar/buffer.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/debug.h>

#include <time.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif


Transfer::Transfer(Transfer::TransferType ty)
:Transaction()
,_jobId(0)
,_status(StatusUnknown)
,_transferType(ty)
,_lastStatusChange(0)
{

}



Transfer::Transfer(const AB_TRANSACTION *t,
                   Transfer::TransferType ty)
:Transaction(t)
,_jobId(0)
,_status(StatusUnknown)
,_transferType(ty)
,_lastStatusChange(0)
{
}



Transfer::Transfer(const Transfer &t)
:Transaction(t)
,_jobId(t._jobId)
,_status(t._status)
,_transferType(t._transferType)
,_lastStatusChange(t._lastStatusChange)
{
}



Transfer::Transfer(const Transaction &t, Transfer::TransferType ty)
:Transaction(t)
,_jobId(0)
,_status(StatusUnknown)
,_transferType(ty)
,_lastStatusChange(0)
{
}



Transfer::Transfer(GWEN_DB_NODE *db)
:Transaction()
,_jobId(0)
,_status(StatusUnknown)
,_transferType(TransferType_Unknown)
,_lastStatusChange(0)
{
  fromDb(db);
}



Transfer::~Transfer() {
}



const char *Transfer::typeToString(TransferType t){
  const char *s;

  switch(t) {
  case TransferType_Simple:     s="simple"; break;
  case TransferType_DebitNote:  s="debitNote"; break;
  case TransferType_EuTransfer: s="eutransfer"; break;
  default:                      s="unknown"; break;
  }

  return s;
}



Transfer::TransferType Transfer::typeFromString(const char *s){
  TransferType t;

  assert(s);
  if (strcasecmp(s, "simple")==0)
    t=TransferType_Simple;
  else if (strcasecmp(s, "debitnote")==0)
    t=TransferType_DebitNote;
  else if (strcasecmp(s, "eutransfer")==0)
    t=TransferType_EuTransfer;
  else
    t=TransferType_Unknown;

  return t;
}



uint32_t Transfer::getJobId() const{
  return _jobId;
}



void Transfer::setJobId(uint32_t id){
  _jobId=id;
}



Transfer::TransferType Transfer::getTransferType() const{
  return _transferType;
}



void Transfer::setTransferType(TransferType t){
  _transferType=t;
}



bool Transfer::toDb(GWEN_DB_NODE *db) const{
  const char *s;

  if (!Transaction::toDb(db)) {
    DBG_ERROR(0, "Error saving transaction part");
    return false;
  }

  if (_lastStatusChange) {
    GWEN_DB_NODE *dbT;

    dbT=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                         "lastStatusChange");
    assert(dbT);
    if (GWEN_Time_toDb(_lastStatusChange, dbT)) {
      DBG_ERROR(0, "Error saving lastStatusChange");
      return false;
    }
  }

  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "transferType", typeToString(_transferType));

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "jobId", _jobId);
  switch(_status) {
  case StatusEnqueued:    s="enqueued"; break;
  case StatusPending:     s="pending"; break;
  case StatusOk:          s="ok"; break;
  case StatusError:       s="error"; break;
  case StatusManualOk:    s="manualOk"; break;
  case StatusManualError: s="manualError"; break;
  case StatusAborted:     s="aborted"; break;
  default:                s="unknown"; break;
  }

  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "status", s);
  return true;
}



bool Transfer::fromDb(GWEN_DB_NODE *db){
  const char *s;
  GWEN_DB_NODE *dbT;

  if (!Transaction::fromDb(db)) {
    DBG_ERROR(0, "Error loading transaction part");
    return false;
  }

  _jobId=GWEN_DB_GetIntValue(db, "jobid", 0, 0);
  _transferType=typeFromString(GWEN_DB_GetCharValue(db, "transferType", 0,
                                                    "simple"));

  s=GWEN_DB_GetCharValue(db, "status", 0, "unknown");
  if (strcasecmp(s, "pending")==0)
    _status=StatusPending;
  else if (strcasecmp(s, "enqueued")==0)
    _status=StatusEnqueued;
  else if (strcasecmp(s, "ok")==0)
    _status=StatusOk;
  else if (strcasecmp(s, "error")==0)
    _status=StatusError;
  else if (strcasecmp(s, "manualOk")==0)
    _status=StatusManualOk;
  else if (strcasecmp(s, "manualError")==0)
    _status=StatusManualError;
  else if (strcasecmp(s, "aborted")==0)
    _status=StatusAborted;
  else
    _status=StatusUnknown;

  dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                       "lastStatusChange");
  if (dbT)
    _lastStatusChange=GWEN_Time_fromDb(dbT);

  return true;
}



Transfer::Status Transfer::getStatus() const {
  return _status;
}



void Transfer::setStatus(Transfer::Status st){
  if (_status!=st) {
    DBG_INFO(0, "Changing status from %d to %d", _status, st);
    _status=st;
    GWEN_Time_free(_lastStatusChange);
    _lastStatusChange=GWEN_CurrentTime();
  }
}










