/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateconvertnumberbasesdialog.h"
#include "qalculate_kde_utils.h"
#include <klocale.h>
#include <qgrid.h>
#include <qlabel.h>
#include <klineedit.h>
#include <qpushbutton.h>

extern EvaluationOptions evalops;

QalculateConvertNumberBasesDialog::QalculateConvertNumberBasesDialog(QWidget *parent, const char *name)
		: KDialogBase(parent, name, false, i18n("Number Bases"), Close, Close) {

	actionButton(Close)->setAutoDefault(false);
	actionButton(Close)->setDefault(false);

	QGrid *grid = makeGridMainWidget(2, Qt::Horizontal);
	new QLabel(i18n("Decimal:"), grid);
	decimalEdit = new KLineEdit(grid);
	decimalEdit->setAlignment(Qt::AlignRight);
	QObject::connect(decimalEdit, SIGNAL(textChanged(const QString&)), this, SLOT(setDecimalValue(const QString&)));
	new QLabel(i18n("Binary:"), grid);
	binaryEdit = new KLineEdit(grid);
	binaryEdit->setAlignment(Qt::AlignRight);
	QObject::connect(binaryEdit, SIGNAL(textChanged(const QString&)), this, SLOT(setBinaryValue(const QString&)));
	new QLabel(i18n("Octal:"), grid);
	octalEdit = new KLineEdit(grid);
	octalEdit->setAlignment(Qt::AlignRight);
	QObject::connect(octalEdit, SIGNAL(textChanged(const QString&)), this, SLOT(setOctalValue(const QString&)));
	new QLabel(i18n("Hexadecimal:"), grid);
	hexadecimalEdit = new KLineEdit(grid);
	hexadecimalEdit->setAlignment(Qt::AlignRight);
	QObject::connect(hexadecimalEdit, SIGNAL(textChanged(const QString&)), this, SLOT(setHexadecimalValue(const QString&)));

	decimalEdit->setFocus();

}


QalculateConvertNumberBasesDialog::~QalculateConvertNumberBasesDialog() {}

void QalculateConvertNumberBasesDialog::setDecimalValue(const QString &qstr) {
	string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 10);
}
void QalculateConvertNumberBasesDialog::setBinaryValue(const QString &qstr) {
	string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.base = BASE_BINARY;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 2);
}
void QalculateConvertNumberBasesDialog::setOctalValue(const QString &qstr) {
	string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.base = BASE_OCTAL;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 8);
}
void QalculateConvertNumberBasesDialog::setHexadecimalValue(const QString &qstr) {
	string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	eo.parse_options.base = BASE_HEXADECIMAL;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 16);
}

void QalculateConvertNumberBasesDialog::updateEntries(const MathStructure *value, int base) {
	decimalEdit->blockSignals(true);
	binaryEdit->blockSignals(true);
	octalEdit->blockSignals(true);
	hexadecimalEdit->blockSignals(true);
	PrintOptions po;
	po.number_fraction_format = FRACTION_DECIMAL;
	if(base != 10) {po.base = 10; decimalEdit->setText(value->print(po).c_str());}
	if(base != 2) {po.base = 2; binaryEdit->setText(value->print(po).c_str());}
	if(base != 8) {po.base = 8; octalEdit->setText(value->print(po).c_str());}
	if(base != 16) {po.base = 16; hexadecimalEdit->setText(value->print(po).c_str());}
	decimalEdit->blockSignals(false);
	binaryEdit->blockSignals(false);
	octalEdit->blockSignals(false);
	hexadecimalEdit->blockSignals(false);
}

#include "qalculateconvertnumberbasesdialog.moc"
