# xkcd v2.4.1 [![Build Status](https://travis-ci.org/TC01/python-xkcd.svg?branch=master)](https://travis-ci.org/TC01/python-xkcd)

### A Python interface to xkcd.com

By Ben Rosser, released under MIT License (see LICENSE for full text).

This is a Python library for accessing and retrieving links to comics from
the xkcd webcomic by Randall Munroe. It is NOT endorsed or made by him, it's
an entirely independent project.

It makes use of the JSON interface to Randall's site to retrieve comic data.
Both Python 2 and Python 3 are supported, and there are no dependencies beyond
the Python standard library, so xkcd's footprint should be very light.

There is support for accessing specific comics, the latest comic, or a
random comic. Comic metadata can be queried and the comics themselves can be
downloaded onto your local system. The goal is simply to provide a relatively
Pythonic wrapper around the xkcd API for any Python program or library that
wants to access information about xkcd comics, for one reason or another.

The xkcd module, as of version 2.4.0, also supports getting information on
What If articles from whatif.xkcd.com. This information is generated by
scraping the What If archive page with a HTML parser.

Full API documentation is available [here](https://pythonhosted.org/xkcd/).

## Changelog:

### Version 2.4.1:
* Routines that take comic/article numbers (e.g. xkcd.getComic()) now also
can take strings containing cardinal numbers.

### Version 2.4.0:
* Added preliminary What If support; routines for querying basic data about
What If articles now exist.
* Comic.download() will create its default directory (~/Downloads) if it does
not already exist, rather than simply failing.
* All prints to standard output are now wrapped in "silent" options that
now default to True (this affects xkcd.getComic and Comic.download); if
silent is set, output won't be printed.
* Significantly improved documentation for all available functions and classes.

### Version 2.3.3:
* Made pypandoc conversion optional; long_description will be MD formatted if it
cannot be imported (and rST-formatted if it can).

### Version 2.3.2:
* Fixed distutils URL to point at TC01/python-xkcd, not TC01/xkcd.
* Started using pypandoc to dynamically turn README.md into a RST long-description.

### Version 2.3:
* Fixed ASCII bug in Python 2.x
* Created Sphinx documentation and uploaded it to pythonhosted.org

### Version 2.2:
* Fixed very silly bug with xkcd.getComic()
* Added a getExplanation() which returns an explainxkcd link for a Comic().
* Added support for Python 3!

### Version 2.1:
* Fixed bugs with Comic.download() function
* Added optional parameter to Comic.download() to change name of output file
* Added more information to long_description text

## Credits:

* Ben Rosser <rosser.bjr@gmail.com>: Developer

Contributions from (github users, unless indicated otherwise):

* @Kyu
