#!/usr/bin/env python

from distutils.core import setup, Extension
from distutils.command.install_headers import install_headers
import os, sys
from glob import glob

# If your netCDF installation is in a non-standard place, set the following
# variable to the base directory.
netcdf_prefix = None


if netcdf_prefix is None:
    for netcdf_prefix in ['/usr/local', '/usr']:
        netcdf_include = os.path.join(netcdf_prefix, 'include')
        netcdf_lib = os.path.join(netcdf_prefix, 'lib')
        if os.path.exists(os.path.join(netcdf_include, 'netcdf.h')):
            break
    else:
        netcdf_prefix = None

if netcdf_prefix is None:
    ext_modules = []
else:
    netcdf_include = os.path.join(netcdf_prefix, 'include')
    netcdf_lib = os.path.join(netcdf_prefix, 'lib')
    ext_modules = [Extension('Scientific_netcdf',
                             ['Src/Scientific_netcdf.c'],
                             include_dirs=['Include', netcdf_include],
                             library_dirs=[netcdf_lib],
                             libraries = ['netcdf'])]

class modified_install_headers(install_headers):

    def finalize_options(self):
        install_headers.finalize_options(self)
        self.install_dir = \
                os.path.join(os.path.split(self.install_dir)[0], 'Scientific')

headers = glob(os.path.join ("Include","Scientific","*.h"))

setup (name = "ScientificPython",
       version = "2.2",
       description = "Various Python modules for scientific computing",
       author = "Konrad Hinsen",
       author_email = "hinsen@cnrs-orleans.fr",
       url = "http://starship.python.net/crew/hinsen/scientific.html",
       licence = "LGPL",

       packages = ['Scientific', 'Scientific.Functions',
                   'Scientific.Geometry', 'Scientific.IO',
                   'Scientific.Physics', 'Scientific.Statistics',
                   'Scientific.Threading', 'Scientific.TkWidgets',
                   'Scientific.Visualization', 'Scientific.MPI'],
       headers = headers,
       ext_package = 'Scientific.'+sys.platform,
       ext_modules = ext_modules,

       cmdclass = {'install_headers': modified_install_headers},
       )
