# Contributing

All projects under the Pylons Projects, including this one, follow the guidelines established at [How to Contribute](https://pylonsproject.org/community-how-to-contribute.html), [Coding Style and Standards](https://pylonsproject.org/community-coding-style-standards.html), and [Pylons Project Documentation Style Guide](https://docs.pylonsproject.org/projects/docs-style-guide/).

You can contribute to this project in several ways.

* [File an Issue on GitHub](https://github.com/Pylons/pyramid/issues)
* Fork this project and create a branch with your suggested change. When ready, submit a pull request for consideration. [GitHub Flow](https://guides.github.com/introduction/flow/index.html) describes the workflow process and why it's a good practice. When submitting a pull request, sign [CONTRIBUTORS.txt](https://github.com/Pylons/pyramid/blob/master/CONTRIBUTORS.txt) if you have not yet done so.
* Join the [IRC channel #pyramid on irc.freenode.net](https://webchat.freenode.net/?channels=pyramid).

## Git Branches

Git branches and their purpose and status at the time of this writing are listed below.

* [master](https://github.com/Pylons/pyramid/) - The branch on which further
  development takes place. The default branch on GitHub.
* [1.10-branch](https://github.com/Pylons/pyramid/tree/1.10-branch) - The branch
  classified as "stable" or "latest".
* [1.9-branch](https://github.com/Pylons/pyramid/tree/1.9-branch) - The oldest
  actively maintained and stable branch.

Older branches are not actively maintained. In general, two stable branches and
one or two development branches are actively maintained.

## Developing

Follow the instructions in [HACKING.txt](https://github.com/Pylons/pyramid/blob/master/HACKING.txt) to install Pyramid and the tools needed to run its tests and build its documentation.
