package main;

use L2hos;

$VERBOSITY = 0;

#$PACKAGE_VERSION = "0.1";
#$t_date = "today";

$ICONSERVER = "icons";
$IMAGE_TYPE = "png";
$CUSTOM_BUTTONS = '';

# Change this variable to change the text added in "About this document...";
$ABOUT_FILE = "about.dat";

$HTML_VERSION = 4.0;

$TEXINPUTS = "texinputs";

# A little painful, but lets us clean up the top level directory a little,
# and not be tied to the current directory (as far as I can tell).
use Cwd;
use File::Basename;
($myname, $mydir, $myext) = fileparse(__FILE__, '\..*');

chop $mydir;  # remove trailing '/'
$mydir = getcwd() . "$dd$mydir"
	unless $mydir =~ s|^/|/|;

$LATEX2HTMLSTYLES = "$mydir$envkey$LATEX2HTMLSTYLES";
push (@INC, $mydir);

# Python documentation uses section numbers to support references to match
# in the printed and online versions.
$SHOW_SECTION_NUMBERS = 1;

$TOP_NAVIGATION = 1;
$BOTTOM_NAVIGATION = 1;

sub get_version_text {
	if ($PACKAGE_VERSION ne '' && $t_date) {
		return ("<span class=\"release-info\">"
		        . "Release $PACKAGE_VERSION$RELEASE_INFO,"
		        . " documentation updated on $t_date.</span>");
	}

	if ($PACKAGE_VERSION ne '') {
		return ("<span class=\"release-info\">"
		        . "Release $PACKAGE_VERSION$RELEASE_INFO.</span>");
	}

	if ($t_date) {
		return ("<span class=\"release-info\">Documentation released on "
		        . "$t_date.</span>");
	}

	return '';
}

@my_icon_tags = ();
$my_icon_tags{'next'} = 'Next Page';
$my_icon_tags{'next_page'} = 'Next Page';
$my_icon_tags{'previous'} = 'Previous Page';
$my_icon_tags{'previous_page'} = 'Previous Page';
$my_icon_tags{'up'} = 'Up One Level';
$my_icon_tags{'contents'} = 'Contents';
$my_icon_tags{'index'} = 'Index';
$my_icon_tags{'modules'} = 'Module Index';

@my_icon_names = ();
$my_icon_names{'previous_page'} = 'previous';
$my_icon_names{'next_page'} = 'next';

sub get_my_icon {
	my $name = @_[0];
	my $text = $my_icon_tags{$name};
	if ($my_icon_names{$name}) {
		$name = $my_icon_names{$name};
	}
	if ($text eq '') {
		$name = 'blank';
	}
	my $iconserver = ($ICONSERVER eq '.') ? '' : "$ICONSERVER/";
	return "<img src=\"$iconserver$name.$IMAGE_TYPE\"  border=\"0\""
	       . " height=\"32\" alt=\"$text\" width=\"32\">";
}

sub use_my_icon {
	my $s = @_[0];
	if ($s =~ /\<tex2html_([a-z_]+)_visible_mark\>/) {
		my $r = get_my_icon($1);
		$s =~ s/\<tex2html_[a-z_]+_visible_mark\>/$r/;
	}
	return $s;
}

sub make_nav_sectref {
	my($label,$title) = @_;
	if ($title) {
		if ($title =~ /\<[aA] /) {
			$title =~ s/\<[aA] /<a class="sectref" /;
		} else {
			$title = "<span class=\"sectref\">$title</span>";
		}
		return "<b class=\"navlabel\">" . $label . ":</b> $title\n";
	}
	return '';
}

sub make_nav_panel {
	my $BLANK_ICON = get_my_icon('blank');

	$NEXT = $NEXT_TITLE ? use_my_icon("$NEXT") : $BLANK_ICON;
	$UP = $UP_TITLE ? use_my_icon("$UP") : $BLANK_ICON;
	$PREVIOUS = $PREVIOUS_TITLE ? use_my_icon("$PREVIOUS") : $BLANK_ICON;
	$CONTENTS = use_my_icon("$CONTENTS");
	$INDEX = $INDEX ? use_my_icon("$INDEX") : $BLANK_ICON;

	if (!$CUSTOM_BUTTONS) {
		$CUSTOM_BUTTONS = $BLANK_ICON;
	}

	my $s = ('<table align="center" width="100%" cellpadding="0" cellspacing="2">'
	      . "\n<tr>\n"
	      # left-hand side
	      . "<td>$PREVIOUS</td>\n"
	      . "<td>$UP</td>\n"
	      . "<td>$NEXT</td>\n"
	      # title box
	      . "<td align=\"center\" width=\"100%\">$t_title</td>\n"
	      # right-hand side
	      . "<td>$CONTENTS</td>\n"
	      . "<td>$CUSTOM_BUTTONS</td>\n" # module index
	      . "<td>$INDEX</td>\n"
	      . "</tr></table>\n"
	      # textual navigation
	      . make_nav_sectref("Previous", $PREVIOUS_TITLE)
	      . make_nav_sectref("Up", $UP_TITLE)
	      . make_nav_sectref("Next", $NEXT_TITLE)
	);
	
	# remove these; they are unnecessary and cause errors from validation
	$s =~ s/ NAME="tex2html\d+"\n */ /g;
	return $s;
}

sub top_navigation_panel {
	return "\n"
	       . make_nav_panel() . "<br><hr>\n";
}

$ADDRESS = ''; # this must be empty, we supply our version text
sub bot_navigation_panel {
    return "\n<p><hr>\n"
	       . make_nav_panel() . "<hr>\n"
	       . get_version_text() . "\n";
}

sub add_child_links {
	my $toc = add_real_child_links(@_);
	$toc =~ s|\s*</[aA]>|</a>|g;
	$toc =~ s/ NAME=\"tex2html\d+\"\s*href=/ href=/gi;
	$toc =~ s|</UL>(\s*<BR>)?|</ul>|gi;
	return $toc;
}

# In addition to the standard stuff, add label to allow named node files.
sub do_cmd_textohtmlinfopage {
	local($_) = @_;
	if ($INFO) {
		anchor_label("about", $CURRENT_FILE, $_);
	}

	my $the_version = '';
	if ($t_date) {
		$the_version = ",\n$t_date";

		if ($PACKAGE_VERSION) {
		$the_version .= ", Release $PACKAGE_VERSION$RELEASE_INFO";
		}
	}
	
	my $about;
	open(ABOUT, "<$ABOUT_FILE") || die "\n$!: $ABOUT_FILE\n";
	sysread(ABOUT, $about, 1024*1024);
	close(ABOUT);
	
	$_ = (($INFO == 1)
	       ? join('', $close_all, "<strong>$t_title</strong>$the_version\n", $about, $open_all, $_)
	       : join('', $close_all, $INFO,"\n", $open_all, $_));

	$_;
}

sub gen_index_id {
	# this is used to ensure common index key generation and a stable sort
	my($str,$extra) = @_;
	sprintf('%s###%s%010d', $str, $extra, ++$global{'max_id'});
}

1;	# This must be the last line
