# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class TdeCertificate(ProxyResource):
    """A TDE certificate that can be uploaded into a server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_blob: Required. The base64 encoded certificate private
     blob.
    :type private_blob: str
    :param cert_password: The certificate password.
    :type cert_password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_blob': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_blob': {'key': 'properties.privateBlob', 'type': 'str'},
        'cert_password': {'key': 'properties.certPassword', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TdeCertificate, self).__init__(**kwargs)
        self.private_blob = kwargs.get('private_blob', None)
        self.cert_password = kwargs.get('cert_password', None)
