# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StreamingPolicyFairPlayConfiguration(Model):
    """Class to specify configurations of FairPlay in Streaming Policy.

    All required parameters must be populated in order to send to Azure.

    :param custom_license_acquisition_url_template: The template for a
     customer service to deliver keys to end users.  Not needed when using
     Azure Media Services for issuing keys.
    :type custom_license_acquisition_url_template: str
    :param allow_persistent_license: Required. All license to be persistent or
     not
    :type allow_persistent_license: bool
    """

    _validation = {
        'allow_persistent_license': {'required': True},
    }

    _attribute_map = {
        'custom_license_acquisition_url_template': {'key': 'customLicenseAcquisitionUrlTemplate', 'type': 'str'},
        'allow_persistent_license': {'key': 'allowPersistentLicense', 'type': 'bool'},
    }

    def __init__(self, *, allow_persistent_license: bool, custom_license_acquisition_url_template: str=None, **kwargs) -> None:
        super(StreamingPolicyFairPlayConfiguration, self).__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template
        self.allow_persistent_license = allow_persistent_license
