# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterGetProperties(Model):
    """The properties of cluster.

    All required parameters must be populated in order to send to Azure.

    :param cluster_version: The version of the cluster.
    :type cluster_version: str
    :param os_type: The type of operating system. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or ~azure.mgmt.hdinsight.models.OSType
    :param tier: The cluster tier. Possible values include: 'Standard',
     'Premium'
    :type tier: str or ~azure.mgmt.hdinsight.models.Tier
    :param cluster_definition: Required. The cluster definition.
    :type cluster_definition: ~azure.mgmt.hdinsight.models.ClusterDefinition
    :param security_profile: The security profile.
    :type security_profile: ~azure.mgmt.hdinsight.models.SecurityProfile
    :param compute_profile: The compute profile.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param provisioning_state: The provisioning state, which only appears in
     the response. Possible values include: 'InProgress', 'Failed',
     'Succeeded', 'Canceled', 'Deleting'
    :type provisioning_state: str or
     ~azure.mgmt.hdinsight.models.HDInsightClusterProvisioningState
    :param created_date: The date on which the cluster was created.
    :type created_date: str
    :param cluster_state: The state of the cluster.
    :type cluster_state: str
    :param quota_info: The quota information.
    :type quota_info: ~azure.mgmt.hdinsight.models.QuotaInfo
    :param errors: The list of errors.
    :type errors: list[~azure.mgmt.hdinsight.models.Errors]
    :param connectivity_endpoints: The list of connectivity endpoints.
    :type connectivity_endpoints:
     list[~azure.mgmt.hdinsight.models.ConnectivityEndpoint]
    """

    _validation = {
        'cluster_definition': {'required': True},
    }

    _attribute_map = {
        'cluster_version': {'key': 'clusterVersion', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'OSType'},
        'tier': {'key': 'tier', 'type': 'Tier'},
        'cluster_definition': {'key': 'clusterDefinition', 'type': 'ClusterDefinition'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'HDInsightClusterProvisioningState'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'cluster_state': {'key': 'clusterState', 'type': 'str'},
        'quota_info': {'key': 'quotaInfo', 'type': 'QuotaInfo'},
        'errors': {'key': 'errors', 'type': '[Errors]'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': '[ConnectivityEndpoint]'},
    }

    def __init__(self, *, cluster_definition, cluster_version: str=None, os_type=None, tier=None, security_profile=None, compute_profile=None, provisioning_state=None, created_date: str=None, cluster_state: str=None, quota_info=None, errors=None, connectivity_endpoints=None, **kwargs) -> None:
        super(ClusterGetProperties, self).__init__(**kwargs)
        self.cluster_version = cluster_version
        self.os_type = os_type
        self.tier = tier
        self.cluster_definition = cluster_definition
        self.security_profile = security_profile
        self.compute_profile = compute_profile
        self.provisioning_state = provisioning_state
        self.created_date = created_date
        self.cluster_state = cluster_state
        self.quota_info = quota_info
        self.errors = errors
        self.connectivity_endpoints = connectivity_endpoints
