# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .name_and_user_data_contract_py3 import NameAndUserDataContract


class Person(NameAndUserDataContract):
    """Person object.

    All required parameters must be populated in order to send to Azure.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param person_id: Required. PersonId of the target face list.
    :type person_id: str
    :param persisted_face_ids: PersistedFaceIds of registered faces in the
     person. These persistedFaceIds are returned from Person - Add a Person
     Face, and will not expire.
    :type persisted_face_ids: list[str]
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
        'person_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'person_id': {'key': 'personId', 'type': 'str'},
        'persisted_face_ids': {'key': 'persistedFaceIds', 'type': '[str]'},
    }

    def __init__(self, *, person_id: str, name: str=None, user_data: str=None, persisted_face_ids=None, **kwargs) -> None:
        super(Person, self).__init__(name=name, user_data=user_data, **kwargs)
        self.person_id = person_id
        self.persisted_face_ids = persisted_face_ids
