# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StorageEndpointProperties(Model):
    """The properties of the Storage Endpoint for file upload.

    :param sas_ttl_as_iso8601: SAS time to live. Range: 1 Min (PT1M) - 1 Day
     (P1D).
    :type sas_ttl_as_iso8601: timedelta
    :param connection_string: The account key credentials for storage account
     selected by customer for uploading files.
    :type connection_string: str
    :param container_name: The root container name where all files will be
     uploaded.
    :type container_name: str
    """ 

    _attribute_map = {
        'sas_ttl_as_iso8601': {'key': 'sasTtlAsIso8601', 'type': 'duration'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
    }

    def __init__(self, sas_ttl_as_iso8601=None, connection_string=None, container_name=None):
        self.sas_ttl_as_iso8601 = sas_ttl_as_iso8601
        self.connection_string = connection_string
        self.container_name = container_name
