#!/usr/bin/python
import os, sys, string
import ADNS

# Some of the RBL-style lists, particularly ORBS, return different
# addresses, which indicate different conditions. The blacklist
# dictionary looks like this:
#
# listname: (zone, {addr1: sublist2, addr2: sublist2})

class RBLQueryMixIn:

    blacklists = {
        'ORBS-relay': ('inputs.orbs.org.', { '127.0.0.2': 'ORBS-relay' }),
        'ORBS-relay2': ('outputs.orbs.org.', { '127.0.0.3': 'ORBS-relay2' }),
        'ORBS-manual': ('manual.orbs.org.', { '127.0.0.5': 'ORBS-manual' }),
        'ORBS-manual2': ('untestable-netblocks.orbs.org.',
                         { '127.0.0.7': 'ORBS-manual2' }),
        'ORBS-spamsource': ('spamsources.orbs.org.',
                            { '127.0.0.6': 'ORBS-spamsource' }),
        'ORBS-spamsource2': ('spamsources-netblocks.orbs.org.',
                            { '127.0.0.8': 'ORBS-spamsource2' }),
        ##'ORBS':         ('relays.orbs.org.',
        ##                 { '127.0.0.2': 'ORBS-relay',
        ##                   '127.0.0.3': 'ORBS-manual',
        ##                   '127.0.0.4': 'ORBS-blocked',
        ##                   '127.0.0.5': 'ORBS-spamtrap',
        ##                   }),
        'ORBS-testing': ('testing.orbs.org.',
                         { '127.126.0.2': 'ORBS-testing-closed',
                           '127.126.0.3': 'ORBS-testing-open',
                           }),
        'ORBS-ok': ('ok.orbs.org.', {'127.127.0.2': 'ORBS-OK'}),
        'RSS': ('relays.mail-abuse.org.', { '127.0.0.2': 'RSS'}),
        'DUL': ('dialups.mail-abuse.org.', {'127.0.0.3': 'DUL'}),
        'RBL': ('rbl.maps.vix.com.', {'127.0.0.2': 'RBL'}),
    }

    def submit_rbl(self, qname):
        from adns import rr
        if not hasattr(self, 'rbl_results'): self.rbl_results = {}
        for l, d in self.blacklists.items():
            self.rbl_results[qname] = []
            self.submit_reverse_any(qname, d[0], rr.A,
                                    callback=self.rbl_callback,
                                    extra=l)

    def rbl_callback(self, answer, qname, rr, flags, l):
        if not answer[0]:
            for addr in answer[3]:
                self.rbl_results[qname].append(
                    self.blacklists[l][1].get(addr, l+"-unknown"))

class RBLSMTPQueryMixIn(RBLQueryMixIn): # use for SMTP connections

    blacklists = RBLQueryMixIn.blacklists.copy()
    del blacklists['ORBS-testing']
    del blacklists['ORBS-ok']
                
class RBLQueryEngine(RBLQueryMixIn, ADNS.QueryEngine): pass

class RBLSMTPQueryEngine(RBLQueryEngine): 

    blacklists = RBLQueryEngine.blacklists.copy()
    del blacklists['ORBS-testing']
    del blacklists['ORBS-ok']

    
if __name__ == "__main__":
    s = RBLQueryEngine()
    for i in sys.argv[1:]:
        s.submit_rbl(i)
    s.finish()
    listed = s.rbl_results
    if len(listed) > 1:
        for k, v in listed.items():
            print "%s: %s" % (k, string.join(v))
    else:
        print string.join(listed[sys.argv[1]])
