import sha, time

from Ft.Server.Common import ResourceTypes, AclConstants, Schema

import test_helper

def test_create(tester):


    tester.startTest("Create Group")

    #Create Raw File
    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    g1 = gRoot.createGroup('group1')
    tester.compare(ResourceTypes.ResourceType.GROUP,gRoot.hasResource('group1'))
    tester.compare(ResourceTypes.ResourceType.GROUP,repo.hasResource(g1.getAbsolutePath()))
    tester.compare(g1,gRoot.fetchResource('group1'))

    tester.compare(ResourceTypes.ResourceType.GROUP,g1.getResourceType())
    tester.compare(0,g1.isResourceType(ResourceTypes.ResourceType.CONTAINER))
    tester.compare(1,g1.isResourceType(ResourceTypes.ResourceType.XML_DOCUMENT))

    dMd = g1.getMetaDataResource().getContent()
    dContent = g1.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     g1.getPath().name,
                                     ResourceTypes.ResourceType.GROUP,
                                     [AclConstants.READ_ACCESS,
                                      AclConstants.WRITE_ACCESS,
                                      AclConstants.CHANGE_PERMISSIONS_ACCESS,
                                      AclConstants.CHANGE_OWNER_ACCESS,
                                      AclConstants.EXECUTE_ACCESS,
                                      AclConstants.DELETE_ACCESS,
                                      AclConstants.WRITE_USER_MODEL_ACCESS,
                                      ],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     )

    test_helper.TestGroupRdf(tester,
                             repo,
                             g1.getPath().absolutePath,
                             len(dContent),
                             tester.test_data['userName'],
                             cd,
                             md,
                             'text/xml',
                             Schema.NULL_DOCDEF,
                             'group1',
                             [],
                             )



    
    repo.txCommit()


    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    g1 = gRoot.fetchResource('group1')
    tester.compare(gRoot,g1.getParent())
    repo.txRollback()

    tester.testDone()
    return



def test_access(tester):

    tester.startTest("Group Access")

    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    g1 = gRoot.fetchResource('group1')
    tester.compare(gRoot,g1.getParent())
    tester.compare([],g1.getMembers())
    tester.compare([],g1.getMemberPaths())
    #Just call, don't test
    g1.getCreationDate()
    g1.getLastModifiedDate()
    repo.txRollback()
    
    tester.testDone()


def test_members(tester):

    tester.startTest("Group Add Memebers")

    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    g1 = gRoot.fetchResource('group1')
    lmd = u1.getLastModifiedDate()
    time.sleep(1)
    g1.addMember(u1)



    dMd = g1.getMetaDataResource().getContent()
    dContent = g1.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     g1.getPath().name,
                                     ResourceTypes.ResourceType.GROUP,
                                     [AclConstants.READ_ACCESS,
                                      AclConstants.WRITE_ACCESS,
                                      AclConstants.CHANGE_PERMISSIONS_ACCESS,
                                      AclConstants.CHANGE_OWNER_ACCESS,
                                      AclConstants.EXECUTE_ACCESS,
                                      AclConstants.DELETE_ACCESS,
                                      AclConstants.WRITE_USER_MODEL_ACCESS,
                                      ],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     )

    test_helper.TestGroupRdf(tester,
                             repo,
                             g1.getAbsolutePath(),
                             len(dContent),
                             tester.test_data['userName'],
                             cd,
                             md,
                             'text/xml',
                             Schema.NULL_DOCDEF,
                             'group1',
                             [u1.getAbsolutePath()],
                             )


    mNames = g1.getMemberPaths()
    tester.compare(1,len(mNames))
    tester.compareIn(mNames,u1.getAbsolutePath())

    members = g1.getMembers()
    tester.compare(1,len(members))
    tester.compareIn(members,u1)

    u1Path = u1.getAbsolutePath()

    groups = u1.getGroups()
    tester.compare(1,len(groups))
    tester.compareIn(groups,g1)
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    g1 = gRoot.fetchResource('group1')
    mNames = g1.getMemberPaths()
    tester.compare(1,len(mNames))
    tester.compareIn(mNames,u1Path)
    tester.compare(1,g1.getLastModifiedDate() > lmd)
    repo.txRollback()
    tester.testDone()


    tester.startTest("Group Remove Memebers")
    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    g1 = gRoot.fetchResource('group1')
    g1.removeMember(u1)

    mNames = g1.getMemberPaths()
    tester.compare(0,len(mNames))

    members = g1.getMembers()
    tester.compare(0,len(members))

    groups = u1.getGroups()
    tester.compare(0,len(groups))
    repo.txCommit()


    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    g1 = gRoot.fetchResource('group1')
    mNames = g1.getMemberPaths()
    tester.compare(0,len(mNames))
    repo.txRollback()

    tester.testDone()

def test_delete(tester):

    tester.startTest("Delete Group")
    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    gRoot.deleteResource('group1')
    tester.compare(0,gRoot.hasResource('group1'))
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    tester.compare(0,gRoot.hasResource('group1'))
    repo.txRollback()

    tester.testDone()

def test_nested_groups(tester):

    tester.startTest("Add Nested Groups")

    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    g1 = gRoot.fetchResource('group1')
    ng1 = gRoot.createGroup('ngroup1')
    ng2 = gRoot.createGroup('ngroup2')
    lmd = u1.getLastModifiedDate()
    time.sleep(1)
    g1.addMember(ng1)
    ng1.addMember(ng2)
    ng2.addMember(u1)

    ng1g = ng1.getGroups()
    tester.compare(1,len(ng1g))
    tester.compareIn(ng1g,g1)
                   
    ng2g = ng2.getGroups()
    tester.compare(2,len(ng2g))
    tester.compareIn(ng2g,g1)
    tester.compareIn(ng2g,ng1)

    u1g = u1.getGroups()
    tester.compare(3,len(u1g))
    tester.compareIn(u1g,g1)
    tester.compareIn(u1g,ng1)
    tester.compareIn(u1g,ng2)
    repo.txCommit()
    tester.testDone()


    tester.startTest("Test User nested ACL")
    repo = test_helper.GetRepo(tester,'user1','user1')

    ua = repo.getAclIdentifiers()
    tester.compare(6,len(ua))
    tester.compareIn(ua,'user1')
    tester.compareIn(ua,'group1')
    tester.compareIn(ua,'ngroup1')
    tester.compareIn(ua,'ngroup2')
    tester.compareIn(ua,AclConstants.WORLD_GROUP_NAME)
    tester.compareIn(ua,AclConstants.USERS_GROUP_NAME)
    repo.txRollback()
    tester.testDone()

    


    tester.startTest("Nested Remove Group")
   
    repo = test_helper.GetRepo(tester)
    gRoot = repo.fetchResource('/test')
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    g1 = gRoot.fetchResource('group1')
    ng1 = gRoot.fetchResource('ngroup1')
    ng2 = gRoot.fetchResource('ngroup2')

    ng1.removeMember(ng2)

    ng1g = ng1.getGroups()
    tester.compare(1,len(ng1g))
    tester.compareIn(ng1g,g1)
                   
    ng2g = ng2.getGroups()
    tester.compare(0,len(ng2g))

    u1g = u1.getGroups()
    tester.compare(1,len(u1g))
    tester.compareIn(u1g,ng2)
    repo.txCommit()

    tester.testDone()

def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    test = repo.createContainer("/test",1)

    test.createUser('user1',sha.new('user1').hexdigest())
    test.createUser('user2',sha.new('user2').hexdigest())

    repo.txCommit()
    tester.testDone()



def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_access(tester)
    test_members(tester)
    test_nested_groups(tester)
    test_delete(tester)



