from Ft.Server.Server.Drivers import LoadDriverModule

def test_escape(tester):

    from Ft.Server.Server.Drivers.Postgres import Escapec

    tester.startGroup("Escape and Split")
    for i in ['Foo',
              "Foo'oo",
              "0123456789" * 1000,
              "0123'456789" * 1000,
              "0x001",
              "0x0A1",
              "%s"%chr(1),
              "%s"%chr(0),
              "\\",
              "01230x0456789" * 1000,
              "\n",
              ]:
        tester.startTest(repr(i[:10]))
        e = Escapec.escape(i)
        newE = ""
        for c in i:
            if ord(c) == 0:
                newE += "\\\\000"
            elif c == '\\':
                newE += '\\\\\\\\'
            elif c == '\'':
                newE += "\\'"
            else:
                newE += c
        tester.compare(newE,e)
        newE = ""
        for c in i:
            if ord(c) < 32:
                newE += "\\%03d" % int(oct(ord(c)))
            elif c == '\\':
                newE += '\\\\'
            else:
                newE += c
        o = Escapec.unescape(newE)
        tester.compare(i,o)
        tester.testDone()
    tester.groupDone()


def Test(tester):
    import test_driver
    import test_ftss_driver

    try:
        driverModule = LoadDriverModule('Postgres')
    except Exception, error:
        tester.warning(str(error))
        return

    test_escape(tester)

    props = {'DbName':test_driver.TEST_DBNAME,
             'Host':None,
             'Port':-1,
             'User':None,
             'Passwd':None}
    test_driver.Test(tester, driverModule, props)

    props['TYPE'] = 'Postgres'
    props = {'Driver':props}
    test_ftss_driver.Test(tester, props)
    return
