########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Update/Document.py,v 1.21 2004/10/21 15:06:16 uogbuji Exp $
"""
Implementation of '4ss update document' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command updates the content of an existing XML \
Document resource in a 4Suite repository. If necessary, you will be \
prompted first for credentials and access info to connect to the \
repository."""

import sys

from Ft.Lib import Uri
from Ft.Lib.CommandLine.CommandLineUtil import SourceArgToInputSource
from Ft.Server.Client.Commands import CommandUtil
from Ft.Xml.InputSource import DefaultFactory

def Run(options, args):
    sourceUri = args['sourceUri']
    try:
        isrc = SourceArgToInputSource(sourceUri, DefaultFactory)
    except Exception, e:
        sys.stderr.write(str(e) + '\n')
        sys.stderr.flush()
        return

    content = isrc.read()
    isrc.close()

    repo = CommandUtil.GetRepository(options, '4ss.update.document')
    if repo is not None:
        commit = False
        try:
            doc = repo.fetchResource(args['path'])
            doc.setContent(content)
            if options.has_key('imt'):
                doc.setImt(options['imt'])
            if options.has_key('docdef'):
                docDef = doc.fetchResource(options['docdef'])
                doc.setDocumentDefinition(docDef)
            if options.has_key('nodocdef'):
                doc.setDocumentDefinition(None)
            commit = True
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command(
        'document',
        """Update the content of an XML Document in a repository""",
        '/repo/path/to/dummy.xml dummy.xml',
        __doc__,
        function = Run,
        arguments = [
            Arguments.RequiredArgument(
                'path',
                "The repo path of the existing document in the repository.",
                str),
            Arguments.RequiredArgument(
                'sourceUri',
                "The URI to read the source from (Use '-' to read it from standard input)",
                str),
                ],
        options = Options.Options([
            Options.Option(
                None,
                'imt=','The internet media type to assign to the '\
                            'document.  If not specified it is left unchanged.'),
            Options.ExclusiveOptions([
                Options.Option(None,
                'docdef=',
                'The new document definition for this document'),
                Options.Option(None,
                'nodocdef',
                'remove the current doc def'),
                ]),
                ]),
                fileName = __file__,
                
                )
    return cmd

