#Test the overidding of the processor handlers
#This will also test baseUri resolution for includes, imports and documents (some see test_baseUris for more testing)

from Xslt import test_harness
from xml.xslt import StylesheetReader
from xml.xslt.Processor import Processor
from xml.xslt import pDomlette
from Ft.Lib import Uri
import time, urlparse, cStringIO

BASE_URI = "http://foo.com/"

URIS={BASE_URI+'DOC1':"""<?xml version='1.0' encoding='UTF-8'?><root>DOC1</root>""",
      BASE_URI+'DOC2':"""<?xml version='1.0' encoding='UTF-8'?><root>DOC2</root>""",
      BASE_URI+'STY1':"""<?xml version='1.0' encoding='UTF-8'?><xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'><xsl:template match='/root'>STY1<xsl:value-of select='.'/></xsl:template></xsl:stylesheet>""",
      BASE_URI+'STY2':"""<?xml version='1.0' encoding='UTF-8'?>
      <xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
        <xsl:include href='STY1'/>
        <xsl:template match='/root'>
          STY2<xsl:value-of select='.'/>
        </xsl:template>
      </xsl:stylesheet>""",
      BASE_URI+'STY3':"""<?xml version='1.0' encoding='UTF-8'?>
      <xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
        <xsl:import href='STY1'/>
        <xsl:template match='/root'>
          STY3<xsl:value-of select='.'/>
        </xsl:template>
      </xsl:stylesheet>""",
      BASE_URI+'STY4':"""<?xml version='1.0' encoding='UTF-8'?>
      <xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
        <xsl:template match='/root'>
          STY4<xsl:value-of select='document("DOC2")/root'/>
        </xsl:template>
      </xsl:stylesheet>""",
      }


class NewStylesheetReader(StylesheetReader.StylesheetReader):

    def fromUri(self, uri, baseUri = '',*args, **kw):
        scheme = urlparse.urlparse(uri)[0]
        if scheme in ['', 'http', 'ftp', 'file', 'gopher']:
            uri = urlparse.urljoin(baseUri, uri)
        return apply(self.fromStream,(cStringIO.StringIO(URIS[uri]),uri) + args,kw)

class NewDocumentReader(pDomlette.PyExpatReader):

    def fromUri(self, uri,baseUri='',*args,**kw):
        scheme = urlparse.urlparse(uri)[0]
        if scheme in ['', 'http', 'ftp', 'file', 'gopher']:
            uri = urlparse.urljoin(baseUri, uri)
        return apply(self.fromString,(URIS[uri],uri)+args,kw)


DOC1_STY1_EXPECTED="""<?xml version='1.0' encoding='UTF-8'?>
STY1DOC1"""

DOC1_STY2_EXPECTED="""<?xml version='1.0' encoding='UTF-8'?>

          STY2DOC1"""

DOC1_STY3_EXPECTED="""<?xml version='1.0' encoding='UTF-8'?>

          STY3DOC1"""

DOC1_STY4_EXPECTED="""<?xml version='1.0' encoding='UTF-8'?>

          STY4DOC2"""


def TestSimpleUri(tester):
    tester.startTest("Simple Uri")
    processor = Processor()
    processor.setStylesheetReader(NewStylesheetReader())
    processor.setDocumentReader(NewDocumentReader())
    processor.appendStylesheetUri(BASE_URI+'STY1')
    result = processor.runUri(BASE_URI+'DOC1')
    tester.compare(DOC1_STY1_EXPECTED, result)
    tester.testDone()

def TestRelativeInclude(tester):
    tester.startTest("Relative Uri Include")
    processor = Processor()
    processor.setStylesheetReader(NewStylesheetReader())
    processor.setDocumentReader(NewDocumentReader())
    processor.appendStylesheetUri(BASE_URI+'STY2')
    result = processor.runUri(BASE_URI+'DOC1')
    tester.compare(DOC1_STY2_EXPECTED, result)
    tester.testDone()

def TestRelativeImport(tester):
    tester.startTest("Relative Uri Import")
    processor = Processor()
    processor.setStylesheetReader(NewStylesheetReader())
    processor.setDocumentReader(NewDocumentReader())
    processor.appendStylesheetUri(BASE_URI+'STY3')
    result = processor.runUri(BASE_URI+'DOC1')
    tester.compare(DOC1_STY3_EXPECTED, result)
    tester.testDone()

def TestRelativeDocument(tester):
    tester.startTest("Relative Document")
    processor = Processor()
    processor.setStylesheetReader(NewStylesheetReader())
    processor.setDocumentReader(NewDocumentReader())
    processor.appendStylesheetUri(BASE_URI+'STY4')
    result = processor.runUri(BASE_URI+'DOC1')
    tester.compare(DOC1_STY4_EXPECTED, result)
    tester.testDone()

def Test(tester):
    TestSimpleUri(tester)
    TestRelativeInclude(tester)
    TestRelativeImport(tester)
    TestRelativeDocument(tester)
    return
