import os, string, cStringIO
from xml.dom.ext import PrettyPrint

expected = """<?xml version='1.0' encoding='UTF-8'?>
<ADDRBOOK xmlns:xlink='http://www.w3.org/1999/xlink'>
  <ENTRY ID='pa'>
    <NAME>Pieter Aaron</NAME>
    <ADDRESS>404 Error Way</ADDRESS>
    <PHONENUM DESC='Work'>404-555-1234</PHONENUM>
    <PHONENUM DESC='Fax'>404-555-4321</PHONENUM>
    <PHONENUM DESC='Pager'>404-555-5555</PHONENUM>
    <EMAIL>pieter.aaron@inter.net</EMAIL>
  </ENTRY>
  <ADDRBOOK attribute='value'>
    <ENTRY ID='gn'>
      <NAME>Gegbefuna Nwannem</NAME>
      <ADDRESS>666 Murtala Mohammed Blvd.</ADDRESS>
      <PHONENUM DESC='Home'>999-101-1001</PHONENUM>
      <EMAIL>nwanneg@naija.ng</EMAIL>
    </ENTRY>
    <NAME>Show Me</NAME>
  </ADDRBOOK>
  <ENTRY ID='en'>
    <NAME>Emeka Ndubuisi</NAME>
    <ADDRESS>42 Spam Blvd</ADDRESS>
    <PHONENUM DESC='Work'>767-555-7676</PHONENUM>
    <PHONENUM DESC='Fax'>767-555-7642</PHONENUM>
    <PHONENUM DESC='Pager'>800-SKY-PAGEx767676</PHONENUM>
    <EMAIL>endubuisi@spamtron.com</EMAIL>
  </ENTRY>
  <ENTRY ID='vz'>
    <NAME>Vasia Zhugenev</NAME>
    <ADDRESS>2000 Disaster Plaza</ADDRESS>
    <PHONENUM DESC='Work'>000-987-6543</PHONENUM>
    <PHONENUM DESC='Cell'>000-000-0000</PHONENUM>
    <EMAIL>vxz@magog.ru</EMAIL>
  </ENTRY>
</ADDRBOOK>
"""

def Test(tester):
    path = os.path.dirname(os.path.abspath(__file__))[len(os.getcwd())+1:]
    path = string.replace(path, os.sep, '/')
    
    tester.startGroup('Simple XLinks')
    from Ft.XLink.Processor import Processor

    tester.startTest('Checking simple document')
    p = Processor()
    stream = cStringIO.StringIO()
    doc = p.runUri('%s/addr_book1.xml' % path)
    # Use PrettyPrint to normalize whitespace
    PrettyPrint(doc, stream)
    actual = stream.getvalue()
    tester.compare(expected, actual)
    tester.testDone()

    return tester.groupDone()
