def PreprocessFiles(tester, dirs, files):
    """
    PreprocessFiles(tester, dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """

    ignored_dirs = ['use_case']
    for dir in ignored_dirs:
        if dir in dirs:
            dirs.remove(dir)

    ordered_dirs = ['Drivers', 'Inference', 'Core', 'borrowed']
    position = 0
    for dir in ordered_dirs:
        if dir in dirs:
            dirs.remove(dir)
            dirs.insert(position, dir)
            position = position + 1

    ignored_files = ['Helpers', 'test_bind', 'test_removeall','RdfHelper']
    for file in ignored_files:
        if file in files:
            files.remove(file)

    return (dirs, files)
    

from Ft.Lib.TestSuite import TestWalker
class _MemoryMode(TestWalker.TestMode):
    def __init__(self):
        TestWalker.TestMode.__init__(self,'Memory',1)


    def _init(self,tester):
        return 1
    
    def _pre(self, tester):
        """
        By having a __call__, this becomes a transparent wrapper
        around the real function.
        """
        from Ft.Rdf.Drivers import Memory
        # The tester will remove entries in test_data after each test
        tester.test_data['driver'] = Memory
        return

    def _post(self,tester):
        tester.test_data['driver'] = None
        
    
class _DbmMode(TestWalker.TestMode):

    def __init__(self):
        TestWalker.TestMode.__init__(self,'Dbm',0)

    def _init(self,tester):
        try:
            from Ft.Rdf.Drivers import Dbm
        except Exception, error:
            tester.warning("Unable to use mode 'Dbm': %s" % ( str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import Dbm
        tester.test_data['driver'] = Dbm
        return

    def _post(self,tester):
        tester.test_data['driver'] = None

class _PostgresMode(TestWalker.TestMode):
    def __init__(self):
        TestWalker.TestMode.__init__(self,'Postgres',0)

    def _init(self,tester):
        try:
            from Ft.Rdf.Drivers import Postgres
        except Exception, error:
            tester.warning("Unable to use mode 'Postgres': %s" % (str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import Postgres
        tester.test_data['driver'] = Postgres
        return

    def _post(self,tester):
        tester.test_data['driver'] = None


MODES = [_MemoryMode(), _DbmMode(), _PostgresMode()]


#Test all pf RDF
import os, time, glob


g_drivers = ['Memory',
             'Dbm',
             'Postgres',
             ]

# format: [(directory, [ignored...])...]
g_rawTests = [('Drivers', ['test_dbm',
                        'test_postgres',
                        'test_memory',
                         '__init__',
                        ]),
              ('.', ['__init__',
                     'Helpers',
                     'TestSuite',
                     'test',
                     'test_bind',
                     'test_removeall',
                     'RdfHelper',
                 ]),
           ('borrowed', ['rl_20001109',
                         'uo_20001111',
                         'rl_20010105',
                         'jc_20010313',
                         '__init__',
                         ]),
           ]



def InitMemory(tester):
    from Ft.Rdf.Drivers import Memory
    tester.rdf_driver = Memory
    tester.rdf_driver_name = 'Memory'

def InitPostgres(tester):
    from Ft.Rdf.Drivers import Postgres
    tester.rdf_driver = Postgres
    tester.rdf_driver_name = 'Postgres'

def InitDbm(tester):
    from Ft.Rdf.Drivers import Dbm
    tester.rdf_driver = Dbm
    tester.rdf_driver_name = 'Dbm'

def Post(tester):
    if hasattr(tester,'rdf_driver'):
        delattr(tester,'rdf_driver')
    

g_driverMap = {'Dbm':InitDbm,
               'Postgres':InitPostgres,
               'Memory':InitMemory,
               }

g_tests = {'All':[],

           }




usedDrivers = []
for driver in g_drivers:
    try:
        module = __import__('Ft.Rdf.Drivers.%s' % driver, {}, {}, '*')
        usedDrivers.append(driver)
        g_tests[driver] = []
    except:
        pass


import Rdf
BASE_DIR = os.path.split(Rdf.__file__)[0]

for driver in usedDrivers:
    
    init = g_driverMap[driver]
    for (path, ignored) in g_rawTests:
        if path == '.':
            name = 'Core'
        else:
            name = path
        g_tests[name] = []


        files = glob.glob(os.path.join(BASE_DIR,path,'*.py'))
        tests = map(lambda f: os.path.basename(f)[:-3], files)
        tests.sort()
        for test in tests:
            if test in ignored: continue
            
            if path == '.':
                tName = 'Rdf.' + test
            else:
                tName = 'Rdf.' + path + '.' + test

            module = __import__(tName,{},{},'*')
            g_tests[name].append((module.Test,init,Post))
            g_tests[driver].append((module.Test,init,Post))
            g_tests['All'].append((module.Test,init,Post))
            


g_tests['Inference'] = []

for name in ['test_action',
             'test_assert',
             'test_command',
             'test_predicate',
             'test_query',
             'test_rule',
             'test_inferenceengine_core',
             'test_parser',
             'test_parsed_action',
             'test_parsed_assert',
             'test_parsed_command',
             'test_parsed_query',
             'test_parsed_rule',
             ]:

    module = __import__('Rdf.Inference.' + name,{},{},'*')

    g_tests['Inference'].append((module.Test,None,None))
    g_tests['All'].append((module.Test,None,None))


def GetSpecs():
    return g_tests


