
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import PersistentObject

from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.PersistentObject import TupleDefinitions

from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import PrimitiveKind

td = TupleDefinitions

class DummyCollection:
    pass

class DummyPersistentObject(PersistentObject.PersistentObject):


    def __init__(self,db,data):
        if data is None:
            self.__dict__['meta_kind'] = MetaKind.mk_primitive_type
            self.__dict__['primitive_kind'] = PrimitiveKind.pk_short
            self.__dict__['_repoId'] = 0
            self.__dict__['name'] = ""

        PersistentObject.PersistentObject.__init__(self,db,data)


    def _4ods_setRepositoryId(self,rid):
        self.__dict__['_repoId'] = rid
    def _4ods_getRepositoryId(self):
        return self.__dict__['_repoId']
    _4ods_getId = _4ods_getRepositoryId


    def _4ods_getOdsType(self):
        return Constants.Types.ROBJECT

    #Give it some things
    #Make it look like a PrimitiveType

    _tupleDefinitions = {'_repoId':{td.TYPE:Constants.Types.SIGNED_LONG_LONG,
                                    td.READONLY:1
                                    },
                         'meta_kind':{td.TYPE:Constants.Types.ENUMERATION,
                                      td.READONLY:1,
                                      td.LITERAL_REPO_ID:MetaKind.MetaKind._typeId,
                                      },
                         'name':{td.TYPE:Constants.Types.STRING},
                         'comment':{td.TYPE:Constants.Types.STRING},
                         'definedIn':{td.TYPE:Constants.Types.ROBJECT,
                                      td.READONLY:1,
                                      td.RELATIONSHIP:1},
                         'collections':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'dictionaries':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'specifiers':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'unions':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'operations':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'properties':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'constants':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'type_defs':{td.TYPE:Constants.Types.SET_COLLECTION,
                                        td.READONLY:1,
                                        },
                         'primitive_kind':{td.TYPE:Constants.Types.ENUMERATION,
                                           td.READONLY:1,
                                           td.LITERAL_REPO_ID:PrimitiveKind.PrimitiveKind._typeId,
                                           },
                         }
                                       

    
    _tupleNames = (('_repoId',),('meta_kind',),('name',),('comment',),('definedIn',),('collections',), ('dictionaries',), ('specifiers',), ('unions',), ('operations',), ('properties',), ('constants',), ('type_defs',), ('primitive_kind',))

    _localExtents = ()

from Ft.Ods import MetaData
MetaData.SetClassData(DummyPersistentObject)

def Test(tester):

    tester.startGroup("Persistent Object Driver %s" % tester.test_data['driver'])

    #Can't have a full DB here
    tester.startTest("Init DB")
    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinit(DBNAME,adapter)
    else:
        manager.create(DBNAME)
        manager.init(DBNAME)

    tester.testDone()
    
    tester.startTest("Create Object")

    #Create a new module, set some info and commit
    db = Database.Database()
    db.open(DBNAME)

    try:
        tx = db.new()
        tx.begin()


        #Init the enums
        for e in MetaKind.MetaKind.elements:
            adapter.newPythonLiteralClass(tx._db,Constants.Types.ENUMERATION,e._typeId,e.__class__)

        for e in PrimitiveKind.PrimitiveKind.elements:
            adapter.newPythonLiteralClass(tx._db,Constants.Types.ENUMERATION,e._typeId,e.__class__)




        d = DummyPersistentObject(db,None)

        d.name = "Test Type"
        d.comment = "Test Comment"

        tester.testResults("Test Type",d.name,done=0,msg="Name")
        tester.testResults("Test Comment",d.comment,done=0,msg="Comment")

        tx.commit()

        tester.testDone()
        tester.startTest("Read Object")
        rid = d._repoId


        tx = db.new()
        tx.begin()

        d2 = db._4ods_getPersistentObjectById(Constants.Types.ROBJECT,rid)

        tester.testResults("Test Type",d2.name,done=0,msg="Name")
        tester.testResults("Test Comment",d2.comment,done=0,msg="Comment")

        tester.testDone()

        tester.groupDone()

    finally:
        db.close()

    return

