import os, time

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity1.odl or varsity2.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python basic_test1.py
#


from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import Database
import os,sys
import test_util

odl_string = """
class Professor
{
	attribute string name;
};

"""
#"


DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

NUM=1000

def test(tester):

    tester.startGroup('Lots of data Test')

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        import Professor
        reload(Professor)
    except:
        tester.error('Error in syntax', 1)
    tester.testDone()

    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()

    tester.startTest('Creating %d classes' % NUM)

    s = time.time()
    for ctr in range(NUM):
        p = Professor.new()
        db.bind(p,str(ctr))
    tx.commit()
    tester.testDone()
    print "Total Time %f" %(time.time() - s)


    tester.startTest('Testing Class Loading')
    tx = db.new()
    tx.begin()
    s = time.time()
    for ctr in range(NUM):
        db.lookup(str(ctr))
    tx.commit()
    tester.testDone()
    print "Total Time %f" %(time.time() - s)

    tester.startTest('Testing Class Modifing')
    tx = db.new()
    tx.begin()
    s = time.time()
    for ctr in range(NUM):
        p = db.lookup(str(ctr))
        p.name = "Professor %d" % ctr
    tx.commit()
    tester.testDone()
    print "Total Time %f" %(time.time() - s)

    tester.startTest('Testing Class Deleting')
    tx = db.new()
    tx.begin()
    s = time.time()
    for ctr in range(NUM):
        p = db.lookup(str(ctr))
        p.delete()
    tx.commit()
    tester.testDone()
    print "Total Time %f" %(time.time() - s)

    tester.groupDone()
    db.close()
    
    return

if __name__ == '__main__':


    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)

    retVal = test(tester)
    sys.exit(retVal)

