from xml.xpath import Context

class XPtrContext(Context.Context):

    def __init__(self,
                 node,
                 position,
                 size,
                 originalContext,
                 processorNss=None):
        Context.Context.__init__(self,
                                 node,
                                 position,
                                 size,
                                 {},
                                 processorNss)
        self.originalContext = originalContext

    def __repr__(self):
        return '<XPtrContext at %x: Node=%s, Pos="%d", Size="%d", Origin=%s>' % (
            id(self),
            repr(self.node),
            self.position,
            self.size,
            repr(self.originalContext),
            )
