########################################################################
#
# File Name:            __init__.py
#
# Documentation:        http://docs.4suite.org/4XSLT/__init__.py.html
#
"""
4XLink Elements
WWW: http://4suite.org/4XLink        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from xml.dom import Element
from Ft.XLink import XLINK_NAMESPACE
from xml.dom import Node

def Create(node, baseUri):
    elemType = node.getAttributeNS(XLINK_NAMESPACE, 'type')
    return TypeMap.get(elemType, Literal)(node, baseUri)

class Literal:
    type = None
    
    def __init__(self, node, baseUri):
        self.resource = node
        self.baseUri = baseUri

    def process(self, reader):
        return

class Simple(Literal):
    type = "simple"
    
    def __init__(self, node, baseUri):
        Literal.__init__(self, node, baseUri)
        self.href = node.getAttributeNS(XLINK_NAMESPACE, 'href')
        self.role = node.getAttributeNS(XLINK_NAMESPACE, 'role')
        self.arcrole = node.getAttributeNS(XLINK_NAMESPACE, 'arcrole')
        self.title = node.getAttributeNS(XLINK_NAMESPACE, 'title')
        self.show = node.getAttributeNS(XLINK_NAMESPACE, 'show')
        self.actuate = node.getAttributeNS(XLINK_NAMESPACE, 'actuate')
        self.attributes = filter(lambda x: x.namespaceURI != XLINK_NAMESPACE,
                                 node.attributes.values())

    def process(self, reader):
        resource = self.resource
        if self.actuate == "onLoad":
            doc = resource.ownerDocument
            if self.show == 'replace':
                frag = reader.fromUri(self.href, self.baseUri, ownerDoc=doc)
                for node in self.attributes:
                    frag.firstChild.setAttributeNS(node.namespaceURI,
                                                   node.nodeName,
                                                   node.value)
                for child in resource.childNodes[:]:
                    frag.firstChild.appendChild(child)

                parent = resource.parentNode or doc
                if frag.nodeType == Node.DOCUMENT_NODE:
                    for child in frag.childNodes:
                        frag.removeChild(child)
                        parent.insertBefore(child,resource)
                    parent.removeChild(resource)
                else:
                    parent.replaceChild(frag, resource)
                    
            elif self.show == 'embed':
                frag = reader.fromUri(self.href, ownerDoc=doc)
                if resource.parentNode:
                    resource.parentNode.replaceChild(frag, resource)
                else:
                    doc.replaceChild(frag, resource)


class Extended(Literal):
    type = "extended"
            
class Locator(Literal):
    type = "locator"
            
class Arc(Literal):
    type = "arc"
            
class Resource(Literal):
    type = "resource"
            
class Title(Literal):
    type = "title"
            
TypeMap = {
    'simple' : Simple,
    'extended' : Extended,
    'locator' : Locator,
    'arc' : Arc,
    'resource' : Resource,
    'title' : Title,
    }

