#!/usr/bin/env python
############################################################################
#  
#  Copyright (c)2000 Fourthought, Inc.
#  http://ftsuite.com/4ODS
#
############################################################################
#
# File Name: 		4odb odmsload.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Tools/4odb_destroy.py.html
#


#Load a 4ODS database from OIF

import sys
import sys, getopt
from Ft.Ods import StorageManager
from Ft.Ods.StorageManager import OifAdapter
from Ft.Ods import Database


__doc__ = 'Load a 4ODS database from OIF'



def Run(options,args):

    from Ft.Ods.StorageManager import Adapters
    dbName = args['dbName']
    Adapters.g_driverName = options.get('adapter')


    oif = OifAdapter.OifAdapter(dbName)
    oif.begin()

    if not len(args['file']):
        stream = sys.stdin
        oif.odmsload(stream)
    else:
        for file in args['file']:
            oif.odmsload(open(file))
    oif.commit()


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('odmsload',
                          'Load a 4ODS database from OIF',
                          ' test out.oif',                          
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('dbName',
                                                                  'The name of the database.',
                                                                  str),
                                       Arguments.ZeroOrMoreArgument('file',
                                                                    'An OIF file.  If none are specified, standard in will be used.',
                                                                    str),
                                       ],
                                                               
                          )
    return cmd
