#!/usr/bin/env python
############################################################################
#  
#  Copyright (c)2000 Fourthought, Inc.
#  http://ftsuite.com/4ODS
#
############################################################################
#
# File Name: 		4odb odmsdump.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Tools/4odb_destroy.py.html
#


#Dump a 4ODS database using OIF

import sys

__doc__ = 'Dump a 4ODS database to OIF'



def Run(options,args):
    import sys, getopt
    from Ft.Ods import StorageManager
    from Ft.Ods.StorageManager import OifAdapter
    from Ft.Ods import Database

    from Ft.Ods.StorageManager import Adapters
    dbName = args['dbName']
    Adapters.g_driverName = options.get('adapter')


    if options.has_key('outfile'):
        stream = open(options['outfile'], 'w')
    else:
        stream = sys.stdout

    oif = OifAdapter.OifAdapter(dbName)
    oif.begin()
    oif.odmsdump(stream)
    # Just to be safe, although nothing should have changed
    oif.abort()


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('odmsdump',
                          'Dump a 4ODS database to OIF',
                          ' test',                          
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('dbName',
                                                                  'The name of the database.',
                                                                  str),
                                       ],
                          options = Options.Options([Options.Option('o',
                                                                    'outfile',
                                                                    'Dump the output to the specified outfile'),
                                                     ]),

                                                               
                          )
    return cmd

